/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Highlight {
    private Type type;
    private ElectricObject eobj;
    private Cell cell;
    private int point;
    private Variable var;
    private Name name;
    private Rectangle2D bounds;
    private Point2D pt1;
    private Point2D pt2;
    private Point2D center;
    private String msg;
    private static int highOffX;
    private static int highOffY;
    private static List highlightList;
    private static List highlightStack;
    private static List lastHighlightsList;
    private static List highlightListeners;
    private static final int EXACTSELECTDISTANCE = 5;
    private static final int CROSSSIZE = 3;
    private static final BasicStroke solidLine;
    private static final BasicStroke dottedLine;
    private static final BasicStroke dashedLine;

    private Highlight(Type type) {
        this.type = type;
        this.eobj = null;
        this.cell = null;
        this.point = -1;
        this.var = null;
        this.name = null;
        this.bounds = null;
        this.pt1 = null;
        this.pt2 = null;
        this.msg = null;
    }

    public static synchronized void clear() {
        highlightList.clear();
        highOffY = 0;
        highOffX = 0;
    }

    public static synchronized void finished() {
        boolean changed = false;
        if (highlightList.size() != lastHighlightsList.size()) {
            changed = true;
        } else {
            for (int i = 0; i < highlightList.size(); ++i) {
                if (highlightList.get(i) == lastHighlightsList.get(i)) continue;
                changed = true;
                break;
            }
        }
        if (!changed) {
            return;
        }
        lastHighlightsList.clear();
        lastHighlightsList.add(highlightList);
        boolean mixedArc = false;
        ArcProto foundArcProto = null;
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            ElectricObject eobj;
            Highlight h = (Highlight)it.next();
            if (h.getType() != Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
            ArcProto ap = ((ArcInst)eobj).getProto();
            if (foundArcProto == null) {
                foundArcProto = ap;
                continue;
            }
            if (foundArcProto == ap) continue;
            mixedArc = true;
        }
        if (foundArcProto != null && !mixedArc) {
            User.tool.setCurrentArcProto(foundArcProto);
        }
        Highlight.fireHighlightChanged();
    }

    public static synchronized void addHighlightListener(HighlightListener l) {
        highlightListeners.add(l);
    }

    public static synchronized void removeHighlightListener(HighlightListener l) {
        highlightListeners.remove(l);
    }

    private static synchronized void fireHighlightChanged() {
        Iterator it = highlightListeners.iterator();
        while (it.hasNext()) {
            HighlightListener l = (HighlightListener)it.next();
            l.highlightChanged();
        }
    }

    public static synchronized Highlight addElectricObject(ElectricObject eobj, Cell cell) {
        Highlight h = new Highlight(Type.EOBJ);
        h.eobj = eobj;
        h.cell = cell;
        highlightList.add(h);
        return h;
    }

    public static synchronized void pushHighlight() {
        ArrayList pushable = new ArrayList();
        Iterator it = highlightList.iterator();
        while (it.hasNext()) {
            pushable.add(it.next());
        }
        highlightStack.add(pushable);
    }

    public static synchronized void popHighlight() {
        int stackSize = highlightStack.size();
        if (stackSize <= 0) {
            System.out.println("There is no highlighting saved on the highlight stack");
            return;
        }
        List popable = (List)highlightStack.get(stackSize - 1);
        highlightStack.remove(stackSize - 1);
        Highlight.clear();
        Iterator it = popable.iterator();
        while (it.hasNext()) {
            Highlight newH;
            Highlight h = (Highlight)it.next();
            if (h.type == Type.EOBJ) {
                if (!h.cell.objInCell(h.eobj)) continue;
                newH = Highlight.addElectricObject(h.eobj, h.cell);
                newH.setPoint(h.point);
                continue;
            }
            if (h.type == Type.TEXT) {
                if (!h.cell.objInCell(h.eobj)) continue;
                newH = Highlight.addText(h.eobj, h.cell, h.var, h.name);
                continue;
            }
            if (h.type == Type.BBOX) {
                newH = Highlight.addArea(h.bounds, h.cell);
                continue;
            }
            if (h.type == Type.LINE) {
                newH = Highlight.addLine(h.pt1, h.pt2, h.cell);
                continue;
            }
            if (h.type == Type.THICKLINE) {
                newH = Highlight.addThickLine(h.pt1, h.pt2, h.center, h.cell);
                continue;
            }
            if (h.type != Type.MESSAGE) continue;
            newH = Highlight.addMessage(h.cell, h.msg, h.center);
        }
        Highlight.finished();
    }

    public static synchronized Highlight addText(ElectricObject eobj, Cell cell, Variable var, Name name) {
        Highlight h = new Highlight(Type.TEXT);
        h.eobj = eobj;
        h.cell = cell;
        h.var = var;
        h.name = name;
        highlightList.add(h);
        return h;
    }

    public static synchronized Highlight addMessage(Cell cell, String message, Point2D loc) {
        Highlight h = new Highlight(Type.MESSAGE);
        h.msg = message;
        h.cell = cell;
        h.pt1 = loc;
        highlightList.add(h);
        return h;
    }

    public static synchronized Highlight addArea(Rectangle2D area, Cell cell) {
        Highlight h = new Highlight(Type.BBOX);
        h.bounds = new Rectangle2D.Double();
        h.bounds.setRect(area);
        h.cell = cell;
        highlightList.add(h);
        return h;
    }

    public static synchronized Highlight addLine(Point2D start, Point2D end, Cell cell) {
        Highlight h = new Highlight(Type.LINE);
        h.pt1 = new Point2D.Double(start.getX(), start.getY());
        h.pt2 = new Point2D.Double(end.getX(), end.getY());
        h.cell = cell;
        highlightList.add(h);
        return h;
    }

    public static synchronized Highlight addThickLine(Point2D start, Point2D end, Point2D center, Cell cell) {
        Highlight h = new Highlight(Type.THICKLINE);
        h.pt1 = new Point2D.Double(start.getX(), start.getY());
        h.pt2 = new Point2D.Double(end.getX(), end.getY());
        h.center = new Point2D.Double(center.getX(), center.getY());
        h.cell = cell;
        highlightList.add(h);
        return h;
    }

    public static void addNetwork(JNetwork net, Cell cell) {
        JNetwork oNet;
        int i;
        int width;
        Netlist netlist = cell.getUserNetlist();
        Iterator aIt = cell.getArcs();
        block0: while (aIt.hasNext()) {
            ArcInst ai = (ArcInst)aIt.next();
            width = netlist.getBusWidth(ai);
            for (i = 0; i < width; ++i) {
                oNet = netlist.getNetwork(ai, i);
                if (oNet != net) continue;
                Highlight.addElectricObject(ai, cell);
                continue block0;
            }
        }
        Iterator pIt = cell.getPorts();
        block2: while (pIt.hasNext()) {
            Export pp = (Export)pIt.next();
            width = netlist.getBusWidth(pp);
            for (i = 0; i < width; ++i) {
                oNet = netlist.getNetwork(pp, i);
                if (oNet != net) continue;
                Highlight.addText(pp, cell, null, null);
                continue block2;
            }
        }
    }

    public static synchronized void remove(Highlight h) {
        highlightList.remove(h);
    }

    public Type getType() {
        return this.type;
    }

    public ElectricObject getElectricObject() {
        return this.eobj;
    }

    private void setElectricObject(ElectricObject eobj) {
        this.eobj = eobj;
    }

    public Cell getCell() {
        return this.cell;
    }

    private void setCell(Cell cell) {
        this.cell = cell;
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int point) {
        this.point = point;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public Name getName() {
        return this.name;
    }

    private void setName(Name name) {
        this.name = name;
    }

    public Variable getVar() {
        return this.var;
    }

    public void setVar(Variable var) {
        this.var = var;
    }

    public Point2D getFromPoint() {
        return this.pt1;
    }

    public Point2D getToPoint() {
        return this.pt2;
    }

    public static synchronized int getNumHighlights() {
        return highlightList.size();
    }

    public static synchronized Iterator getHighlights() {
        ArrayList highlightsCopy = new ArrayList(highlightList);
        return highlightsCopy.iterator();
    }

    public static synchronized void setHighlightList(List newHighlights) {
        Iterator it = newHighlights.iterator();
        while (it.hasNext()) {
            highlightList.add(it.next());
        }
    }

    public static List getHighlighted(boolean wantNodes, boolean wantArcs) {
        ArrayList<ElectricObject> highlightedGeoms = new ArrayList<ElectricObject>();
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            ElectricObject eobj;
            Highlight h = (Highlight)it.next();
            if (h.getType() == Type.EOBJ) {
                eobj = h.getElectricObject();
                if (!wantNodes && (eobj instanceof NodeInst || eobj instanceof PortInst) || !wantArcs && eobj instanceof ArcInst) continue;
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (highlightedGeoms.contains(eobj)) continue;
                highlightedGeoms.add(eobj);
            }
            if (h.getType() == Type.BBOX) {
                List inArea = Highlight.findAllInArea(h.getCell(), false, false, false, false, false, false, h.getBounds(), null);
                Iterator ait = inArea.iterator();
                while (ait.hasNext()) {
                    Highlight ah = (Highlight)ait.next();
                    if (ah.getType() != Type.EOBJ) continue;
                    ElectricObject eobj2 = ah.getElectricObject();
                    if (!wantNodes && (eobj2 instanceof NodeInst || eobj2 instanceof PortInst) || !wantArcs && eobj2 instanceof ArcInst) continue;
                    if (eobj2 instanceof PortInst) {
                        eobj2 = ((PortInst)eobj2).getNodeInst();
                    }
                    highlightedGeoms.add(eobj2);
                }
            }
            if (h.getType() != Type.TEXT || !h.nodeMovesWithText()) continue;
            eobj = h.getElectricObject();
            if (eobj instanceof Export) {
                eobj = ((Export)eobj).getOriginalPort().getNodeInst();
            }
            highlightedGeoms.add(eobj);
        }
        return highlightedGeoms;
    }

    public static synchronized Set getHighlightedNetworks() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            return ww.getHighlightedNetworks();
        }
        HashSet<JNetwork> nets = new HashSet<JNetwork>();
        Cell cell = WindowFrame.getCurrentCell();
        if (cell != null) {
            Netlist netlist = cell.getUserNetlist();
            Iterator it = highlightList.iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.type == Type.EOBJ) {
                    ElectricObject eObj = h.getElectricObject();
                    if (eObj instanceof PortInst) {
                        PortInst pi = (PortInst)eObj;
                        JNetwork net = netlist.getNetwork(pi);
                        if (net != null) {
                            nets.add(net);
                            continue;
                        }
                        if (!pi.getPortProto().isIsolated()) continue;
                        Iterator aIt = pi.getNodeInst().getConnections();
                        while (aIt.hasNext()) {
                            Connection con = (Connection)aIt.next();
                            ArcInst ai = con.getArc();
                            net = netlist.getNetwork(ai, 0);
                            if (net == null) continue;
                            nets.add(net);
                        }
                        continue;
                    }
                    if (eObj instanceof NodeInst) {
                        JNetwork net;
                        PortInst pi;
                        NodeInst ni = (NodeInst)eObj;
                        if (ni.getNumPortInsts() != 1 || (pi = ni.getOnlyPortInst()) == null || (net = netlist.getNetwork(pi)) == null) continue;
                        nets.add(net);
                        continue;
                    }
                    if (!(eObj instanceof ArcInst)) continue;
                    ArcInst ai = (ArcInst)eObj;
                    int width = netlist.getBusWidth(ai);
                    for (int i = 0; i < width; ++i) {
                        JNetwork net = netlist.getNetwork((ArcInst)eObj, i);
                        if (net == null) continue;
                        nets.add(net);
                    }
                    continue;
                }
                if (h.type != Type.TEXT || h.getVar() != null || h.getName() != null || !(h.getElectricObject() instanceof Export)) continue;
                Export pp = (Export)h.getElectricObject();
                int width = netlist.getBusWidth(pp);
                for (int i = 0; i < width; ++i) {
                    JNetwork net = netlist.getNetwork(pp, i);
                    if (net == null) continue;
                    nets.add(net);
                }
            }
        }
        return nets;
    }

    public boolean nodeMovesWithText() {
        if (this.type != Type.TEXT) {
            return false;
        }
        if (this.var != null) {
            if (!(this.eobj instanceof NodeInst)) {
                return false;
            }
            NodeInst ni = (NodeInst)this.eobj;
            if (ni.isInvisiblePinWithText()) {
                return true;
            }
        } else {
            if (!(this.eobj instanceof Export)) {
                return false;
            }
            Export pp = (Export)this.eobj;
            if (pp.getOriginalPort().getNodeInst().getProto() == Generic.tech.invisiblePinNode) {
                return true;
            }
            if (User.isMoveNodeWithExport()) {
                return true;
            }
        }
        return false;
    }

    public static synchronized List getHighlightedText(boolean unique) {
        ArrayList<Highlight> highlightedText = new ArrayList<Highlight>();
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Type.TEXT || highlightedText.contains(h)) continue;
            if (unique) {
                ElectricObject eobj = h.getElectricObject();
                ElectricObject onObj = null;
                if (h.getVar() != null) {
                    if (eobj instanceof Export) {
                        onObj = ((Export)eobj).getOriginalPort().getNodeInst();
                    } else if (eobj instanceof PortInst) {
                        onObj = ((PortInst)eobj).getNodeInst();
                    } else if (eobj instanceof Geometric) {
                        onObj = eobj;
                    }
                } else if (h.getName() != null) {
                    if (eobj instanceof Geometric) {
                        onObj = eobj;
                    }
                } else if (eobj instanceof Export) {
                    onObj = ((Export)eobj).getOriginalPort().getNodeInst();
                } else if (eobj instanceof NodeInst) {
                    onObj = eobj;
                }
                if (eobj != null) {
                    boolean found = false;
                    Iterator fIt = Highlight.getHighlights();
                    while (fIt.hasNext()) {
                        Highlight oH = (Highlight)fIt.next();
                        if (oH.getType() != Type.EOBJ) continue;
                        ElectricObject fobj = oH.getElectricObject();
                        if (fobj instanceof PortInst) {
                            fobj = ((PortInst)fobj).getNodeInst();
                        }
                        if (fobj != onObj) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
            }
            highlightedText.add(h);
        }
        return highlightedText;
    }

    public static synchronized Rectangle2D getHighlightedArea(EditWindow wnd) {
        Rectangle2D.Double bounds = null;
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            Rectangle2D highBounds = null;
            if (h.getType() == Type.EOBJ) {
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (eobj instanceof Geometric) {
                    Geometric geom = (Geometric)eobj;
                    highBounds = geom.getBounds();
                }
            } else if (h.getType() == Type.TEXT) {
                Poly poly;
                if (wnd != null && (poly = h.getElectricObject().computeTextPoly(wnd, h.getVar(), h.getName())) != null) {
                    highBounds = poly.getBounds2D();
                }
            } else if (h.getType() == Type.BBOX) {
                highBounds = h.getBounds();
            } else if (h.getType() == Type.LINE || h.getType() == Type.THICKLINE) {
                double cX = (h.pt1.getX() + h.pt2.getX()) / 2.0;
                double cY = (h.pt1.getY() + h.pt2.getY()) / 2.0;
                double sX = Math.abs(h.pt1.getX() - h.pt2.getX());
                double sY = Math.abs(h.pt1.getY() - h.pt2.getY());
                highBounds = new Rectangle2D.Double(cX, cY, sX, sY);
            } else if (h.getType() == Type.MESSAGE) {
                highBounds = new Rectangle2D.Double(h.pt1.getX(), h.pt1.getY(), 0.0, 0.0);
            }
            if (highBounds == null) continue;
            if (bounds == null) {
                bounds = new Rectangle2D.Double();
                ((Rectangle2D)bounds).setRect(highBounds);
                continue;
            }
            Rectangle2D.union(bounds, highBounds, bounds);
        }
        return bounds;
    }

    public static synchronized Highlight getOneHighlight() {
        if (Highlight.getNumHighlights() == 0) {
            System.out.println("Must select an object first");
            return null;
        }
        Highlight h = null;
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight theH = (Highlight)it.next();
            if (theH.type != Type.EOBJ) continue;
            if (h != null) {
                System.out.println("Must select only one object");
                return null;
            }
            h = theH;
        }
        if (h == null) {
            System.out.println("Must select an object first");
            return null;
        }
        return h;
    }

    public static synchronized ElectricObject getOneElectricObject(Class type) {
        Highlight high = Highlight.getOneHighlight();
        if (high == null) {
            return null;
        }
        if (high.getType() != Type.EOBJ) {
            System.out.println("Must first select an object");
            return null;
        }
        ElectricObject eobj = high.getElectricObject();
        if (type == NodeInst.class && eobj instanceof PortInst) {
            eobj = ((PortInst)eobj).getNodeInst();
        }
        if (type != eobj.getClass()) {
            System.out.println("Wrong type of object is selected");
            System.out.println(" (Wanted " + type.toString() + " but got " + eobj.getClass().toString() + ")");
            return null;
        }
        return eobj;
    }

    public static synchronized void setHighlightOffset(int offX, int offY) {
        highOffX = offX;
        highOffY = offY;
    }

    public static synchronized Point2D getHighlightOffset() {
        return new Point2D.Double(highOffX, highOffY);
    }

    public static synchronized void selectArea(EditWindow wnd, double minSelX, double maxSelX, double minSelY, double maxSelY, boolean invertSelection, boolean findSpecial) {
        Rectangle2D.Double searchArea = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
        List underCursor = Highlight.findAllInArea(wnd.getCell(), false, false, false, false, findSpecial, true, searchArea, wnd);
        if (invertSelection) {
            Iterator it = underCursor.iterator();
            while (it.hasNext()) {
                Highlight newHigh = (Highlight)it.next();
                boolean found = false;
                for (int i = 0; i < highlightList.size(); ++i) {
                    Highlight oldHigh = (Highlight)highlightList.get(i);
                    if (!newHigh.sameThing(oldHigh)) continue;
                    highlightList.remove(i);
                    found = true;
                    break;
                }
                if (found) continue;
                highlightList.add(newHigh);
            }
        } else {
            Highlight.setHighlightList(underCursor);
        }
    }

    public static synchronized boolean overHighlighted(EditWindow wnd, int x, int y) {
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight got;
            Highlight h = (Highlight)it.next();
            Type style = h.getType();
            if (style == Type.TEXT) {
                Point2D start = wnd.screenToDatabase(x, y);
                Poly poly = h.getElectricObject().computeTextPoly(wnd, h.getVar(), h.getName());
                if (!poly.isInside(start)) continue;
                return true;
            }
            if (style != Type.EOBJ) continue;
            Point2D slop = wnd.deltaScreenToDatabase(10, 10);
            double directHitDist = slop.getX();
            Point2D start = wnd.screenToDatabase(x, y);
            Rectangle2D.Double searchArea = new Rectangle2D.Double(start.getX(), start.getY(), 0.0, 0.0);
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                eobj = ((PortInst)eobj).getNodeInst();
            }
            if (!(eobj instanceof Geometric) || (got = Highlight.checkOutObject((Geometric)eobj, true, false, true, searchArea, wnd, directHitDist, false)) == null) continue;
            ElectricObject hObj = got.getElectricObject();
            ElectricObject hReal = hObj;
            if (hReal instanceof PortInst) {
                hReal = ((PortInst)hReal).getNodeInst();
            }
            Iterator sIt = Highlight.getHighlights();
            while (sIt.hasNext()) {
                Highlight alreadyHighlighted = (Highlight)sIt.next();
                if (alreadyHighlighted.getType() != got.getType()) continue;
                ElectricObject aHObj = alreadyHighlighted.getElectricObject();
                ElectricObject aHReal = aHObj;
                if (aHReal instanceof PortInst) {
                    aHReal = ((PortInst)aHReal).getNodeInst();
                }
                if (hReal != aHReal) continue;
                if (hObj == aHObj && alreadyHighlighted.getPoint() == got.getPoint()) break;
                alreadyHighlighted.setElectricObject(got.getElectricObject());
                alreadyHighlighted.setPoint(got.getPoint());
                wnd.repaintContents(null);
                break;
            }
            return true;
        }
        return false;
    }

    public void showHighlight(EditWindow wnd, Graphics g) {
        g.setColor(new Color(User.getColorHighlight()));
        if (this.type == Type.BBOX) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY())};
            Highlight.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, null);
            return;
        }
        if (this.type == Type.LINE) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.pt1.getX(), this.pt1.getY()), new Point2D.Double(this.pt2.getX(), this.pt2.getY())};
            Highlight.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, null);
            return;
        }
        if (this.type == Type.THICKLINE) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.pt1.getX(), this.pt1.getY()), new Point2D.Double(this.pt2.getX(), this.pt2.getY())};
            Highlight.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, this.center);
            return;
        }
        if (this.type == Type.TEXT) {
            Point2D[] points = Highlight.describeHighlightText(wnd, this.getElectricObject(), this.getVar(), this.getName());
            if (points == null) {
                return;
            }
            Point2D[] linePoints = new Point2D[2];
            for (int i = 0; i < points.length; i += 2) {
                linePoints[0] = points[i];
                linePoints[1] = points[i + 1];
                Highlight.drawOutlineFromPoints(wnd, g, linePoints, highOffX, highOffY, false, null);
            }
            return;
        }
        if (this.type == Type.MESSAGE) {
            Point loc = wnd.databaseToScreen(this.pt1.getX(), this.pt1.getY());
            g.drawString(this.msg, loc.x, loc.y);
        }
        if (this.eobj instanceof ArcInst) {
            ArcInst ai = (ArcInst)this.eobj;
            Poly poly = ai.makePoly(ai.getLength(), ai.getWidth() - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
            if (poly == null) {
                return;
            }
            Highlight.drawOutlineFromPoints(wnd, g, poly.getPoints(), highOffX, highOffY, false, null);
            if (Highlight.getNumHighlights() == 1) {
                String constraints = "X";
                if (ai.isRigid()) {
                    constraints = "R";
                } else if (ai.isFixedAngle()) {
                    constraints = ai.isSlidable() ? "FS" : "F";
                } else if (ai.isSlidable()) {
                    constraints = "S";
                }
                Point p = wnd.databaseToScreen(ai.getTrueCenterX(), ai.getTrueCenterY());
                Font font = wnd.getFont(null);
                if (font != null) {
                    GlyphVector gv = wnd.getGlyphs(constraints, font);
                    Rectangle2D glyphBounds = gv.getVisualBounds();
                    g.drawString(constraints, (int)((double)p.x - glyphBounds.getWidth() / 2.0 + (double)highOffX), p.y + font.getSize() / 2 + highOffY);
                }
            }
            return;
        }
        PortProto pp = null;
        ElectricObject realEObj = this.eobj;
        if (realEObj instanceof PortInst) {
            pp = ((PortInst)realEObj).getPortProto();
            realEObj = ((PortInst)realEObj).getNodeInst();
        }
        if (realEObj instanceof NodeInst) {
            Point2D[] points;
            Point2D[] outline;
            NodeInst ni = (NodeInst)realEObj;
            NodeProto np = ni.getProto();
            AffineTransform trans = ni.rotateOutAboutTrueCenter();
            boolean drewOutline = false;
            if (np instanceof PrimitiveNode && np.isHoldsOutline() && (outline = ni.getTrace()) != null) {
                int numPoints = outline.length;
                Point2D[] pointList = new Point2D.Double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    pointList[i] = new Point2D.Double(ni.getTrueCenterX() + outline[i].getX(), ni.getTrueCenterY() + outline[i].getY());
                }
                trans.transform(pointList, 0, pointList, 0, numPoints);
                Highlight.drawOutlineFromPoints(wnd, g, pointList, 0, 0, true, null);
                drewOutline = true;
            }
            int offX = highOffX;
            int offY = highOffY;
            if (!drewOutline) {
                SizeOffset so = ni.getSizeOffset();
                double nodeLowX = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
                double nodeHighX = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
                double nodeLowY = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
                double nodeHighY = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
                if (nodeLowX == nodeHighX && nodeLowY == nodeHighY) {
                    float x = (float)nodeLowX;
                    float y = (float)nodeLowY;
                    float size = 3.0f / (float)wnd.getScale();
                    Point c1 = wnd.databaseToScreen(x + size, y);
                    Point c2 = wnd.databaseToScreen(x - size, y);
                    Point c3 = wnd.databaseToScreen(x, y + size);
                    Point c4 = wnd.databaseToScreen(x, y - size);
                    Highlight.drawLine(g, wnd, c1.x + offX, c1.y + offY, c2.x + offX, c2.y + offY);
                    Highlight.drawLine(g, wnd, c3.x + offX, c3.y + offY, c4.x + offX, c4.y + offY);
                } else {
                    double nodeX = (nodeLowX + nodeHighX) / 2.0;
                    double nodeY = (nodeLowY + nodeHighY) / 2.0;
                    Poly poly = new Poly(nodeX, nodeY, nodeHighX - nodeLowX, nodeHighY - nodeLowY);
                    poly.transform(trans);
                    Highlight.drawOutlineFromPoints(wnd, g, poly.getPoints(), offX, offY, false, null);
                }
            }
            if (this.point >= 0 && (points = ni.getTrace()) != null) {
                int nextPoint;
                boolean showWrap = ni.traceWraps();
                double x = ni.getAnchorCenterX() + points[this.point].getX();
                double y = ni.getAnchorCenterY() + points[this.point].getY();
                Point2D.Double thisPt = new Point2D.Double(x, y);
                trans.transform(thisPt, thisPt);
                Point cThis = wnd.databaseToScreen(thisPt);
                int size = 3;
                Highlight.drawLine(g, wnd, cThis.x + size + offX, cThis.y + size + offY, cThis.x - size + offX, cThis.y - size + offY);
                Highlight.drawLine(g, wnd, cThis.x + size + offX, cThis.y - size + offY, cThis.x - size + offX, cThis.y + size + offY);
                Point2D.Double prevPt = null;
                Point2D.Double nextPt = null;
                int prevPoint = this.point - 1;
                if (prevPoint < 0 && showWrap) {
                    prevPoint = points.length - 1;
                }
                if (prevPoint >= 0) {
                    prevPt = new Point2D.Double(ni.getAnchorCenterX() + points[prevPoint].getX(), ni.getAnchorCenterY() + points[prevPoint].getY());
                    trans.transform(prevPt, prevPt);
                    if (((Point2D)prevPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)prevPt).getY() == ((Point2D)thisPt).getY()) {
                        prevPoint = -1;
                    } else {
                        Point cPrev = wnd.databaseToScreen(prevPt);
                        Highlight.drawLine(g, wnd, cThis.x + offX, cThis.y + offY, cPrev.x, cPrev.y);
                    }
                }
                if ((nextPoint = this.point + 1) >= points.length) {
                    nextPoint = showWrap ? 0 : -1;
                }
                if (nextPoint >= 0) {
                    nextPt = new Point2D.Double(ni.getAnchorCenterX() + points[nextPoint].getX(), ni.getAnchorCenterY() + points[nextPoint].getY());
                    trans.transform(nextPt, nextPt);
                    if (((Point2D)nextPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)nextPt).getY() == ((Point2D)thisPt).getY()) {
                        nextPoint = -1;
                    } else {
                        Point cNext = wnd.databaseToScreen(nextPt);
                        Highlight.drawLine(g, wnd, cThis.x + offX, cThis.y + offY, cNext.x, cNext.y);
                    }
                }
                if (offX == 0 && offY == 0 && points.length > 2) {
                    double arrowLen = Double.MAX_VALUE;
                    if (prevPoint >= 0) {
                        arrowLen = Math.min(thisPt.distance(prevPt), arrowLen);
                    }
                    if (nextPoint >= 0) {
                        arrowLen = Math.min(thisPt.distance(nextPt), arrowLen);
                    }
                    arrowLen /= 10.0;
                    if (prevPoint >= 0) {
                        Point2D.Double prevCtr = new Point2D.Double((((Point2D)prevPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)prevPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                        double prevAngle = DBMath.figureAngleRadians(prevPt, thisPt);
                        Point2D.Double prevArrow1 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle + 2.356194490192345) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle + 2.356194490192345) * arrowLen);
                        Point2D.Double prevArrow2 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle - 2.356194490192345) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle - 2.356194490192345) * arrowLen);
                        Point cPrevCtr = wnd.databaseToScreen(prevCtr);
                        Point cPrevArrow1 = wnd.databaseToScreen(prevArrow1);
                        Point cPrevArrow2 = wnd.databaseToScreen(prevArrow2);
                        Highlight.drawLine(g, wnd, cPrevCtr.x, cPrevCtr.y, cPrevArrow1.x, cPrevArrow1.y);
                        Highlight.drawLine(g, wnd, cPrevCtr.x, cPrevCtr.y, cPrevArrow2.x, cPrevArrow2.y);
                    }
                    if (nextPoint >= 0) {
                        Point2D.Double nextCtr = new Point2D.Double((((Point2D)nextPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)nextPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                        double nextAngle = DBMath.figureAngleRadians(thisPt, nextPt);
                        Point2D.Double nextArrow1 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle + 2.356194490192345) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle + 2.356194490192345) * arrowLen);
                        Point2D.Double nextArrow2 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle - 2.356194490192345) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle - 2.356194490192345) * arrowLen);
                        Point cNextCtr = wnd.databaseToScreen(nextCtr);
                        Point cNextArrow1 = wnd.databaseToScreen(nextArrow1);
                        Point cNextArrow2 = wnd.databaseToScreen(nextArrow2);
                        Highlight.drawLine(g, wnd, cNextCtr.x, cNextCtr.y, cNextArrow1.x, cNextArrow1.y);
                        Highlight.drawLine(g, wnd, cNextCtr.x, cNextCtr.y, cNextArrow2.x, cNextArrow2.y);
                    }
                }
                offY = 0;
                offX = 0;
            }
            if (pp != null) {
                g.setColor(new Color(User.getColorPortHighlight()));
                Poly poly = ni.getShapeOfPort(pp);
                boolean opened = true;
                if (poly.getStyle() == Poly.Type.FILLED || poly.getStyle() == Poly.Type.CLOSED) {
                    opened = false;
                }
                if (poly.getStyle() == Poly.Type.CIRCLE || poly.getStyle() == Poly.Type.THICKCIRCLE || poly.getStyle() == Poly.Type.DISC) {
                    Point2D[] points2 = poly.getPoints();
                    double sX = points2[0].distance(points2[1]) * 2.0;
                    Point2D[] pts = Artwork.fillEllipse(points2[0], sX, sX, 0.0, 360.0);
                    Highlight.drawOutlineFromPoints(wnd, g, pts, offX, offY, opened, null);
                } else if (poly.getStyle() == Poly.Type.CIRCLEARC) {
                    Point2D[] points3 = poly.getPoints();
                    double[] angles = ni.getArcDegrees();
                    double sX = points3[0].distance(points3[1]) * 2.0;
                    Point2D[] pts = Artwork.fillEllipse(points3[0], sX, sX, angles[0], angles[1]);
                    Highlight.drawOutlineFromPoints(wnd, g, pts, offX, offY, opened, null);
                } else {
                    Highlight.drawOutlineFromPoints(wnd, g, poly.getPoints(), offX, offY, opened, null);
                }
                g.setColor(new Color(User.getColorHighlight()));
                if (!(np instanceof PrimitiveNode) && g instanceof Graphics2D) {
                    boolean wired = false;
                    Iterator cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = (Connection)cIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        wired = true;
                        break;
                    }
                    if (wired) {
                        Font font = new Font(User.getDefaultFont(), 0, (int)(1.5 * (double)EditWindow.getDefaultFontSize()));
                        GlyphVector v = wnd.getGlyphs(pp.getName(), font);
                        Point point = wnd.databaseToScreen(poly.getCenterX(), poly.getCenterY());
                        ((Graphics2D)g).drawGlyphVector(v, (float)((Point2D)point).getX() + (float)offX, (float)((Point2D)point).getY() + (float)offY);
                    }
                }
                Netlist netlist = this.cell.getUserNetlist();
                Nodable no = Netlist.getNodableFor(ni, 0);
                PortProto epp = pp.getEquivalent();
                if (epp == null) {
                    epp = pp;
                }
                int busWidth = pp.getNameKey().busWidth();
                FlagSet markObj = Geometric.getFlagSet(1);
                Iterator it = this.cell.getNodes();
                while (it.hasNext()) {
                    ((NodeInst)it.next()).clearBit(markObj);
                }
                it = this.cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    ai.clearBit(markObj);
                    if (!netlist.sameNetwork(no, epp, ai)) continue;
                    ai.setBit(markObj);
                    ai.getHead().getPortInst().getNodeInst().setBit(markObj);
                    ai.getTail().getPortInst().getNodeInst().setBit(markObj);
                }
                Graphics2D g2 = (Graphics2D)g;
                g2.setStroke(dashedLine);
                Iterator it2 = this.cell.getArcs();
                while (it2.hasNext()) {
                    ArcInst ai = (ArcInst)it2.next();
                    if (!ai.isBit(markObj)) continue;
                    Point c1 = wnd.databaseToScreen(ai.getHead().getLocation());
                    Point c2 = wnd.databaseToScreen(ai.getTail().getLocation());
                    Highlight.drawLine(g, wnd, c1.x, c1.y, c2.x, c2.y);
                }
                it2 = this.cell.getNodes();
                while (it2.hasNext()) {
                    NodeInst oNi = (NodeInst)it2.next();
                    if (oNi == ni || !oNi.isBit(markObj)) continue;
                    Point c = wnd.databaseToScreen(oNi.getTrueCenter());
                    g.fillOval(c.x - 4, c.y - 4, 8, 8);
                    Point2D nodeCenter = oNi.getTrueCenter();
                    Iterator pIt = oNi.getConnections();
                    while (pIt.hasNext()) {
                        Point2D arcEnd;
                        Connection con = (Connection)pIt.next();
                        ArcInst ai = con.getArc();
                        if (!ai.isBit(markObj) || (arcEnd = con.getLocation()).getX() == nodeCenter.getX() && arcEnd.getY() == nodeCenter.getY()) continue;
                        Point c1 = wnd.databaseToScreen(arcEnd);
                        Point c2 = wnd.databaseToScreen(nodeCenter);
                        g2.setStroke(dottedLine);
                        Highlight.drawLine(g, wnd, c1.x, c1.y, c2.x, c2.y);
                    }
                }
                g2.setStroke(solidLine);
                markObj.freeFlagSet();
            }
        }
    }

    public static Point2D[] describeHighlightText(EditWindow wnd, ElectricObject eObj, Variable var, Name name) {
        Poly poly = eObj.computeTextPoly(wnd, var, name);
        if (poly == null) {
            return null;
        }
        Rectangle2D bounds = poly.getBounds2D();
        Poly.Type style = poly.getStyle();
        if ((style = Poly.rotateType(style, eObj)) == Poly.Type.TEXTCENT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
            return points;
        }
        if (style == Poly.Type.TEXTBOT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
            return points;
        }
        if (style == Poly.Type.TEXTTOP) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
            return points;
        }
        if (style == Poly.Type.TEXTLEFT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
            return points;
        }
        if (style == Poly.Type.TEXTRIGHT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY())};
            return points;
        }
        if (style == Poly.Type.TEXTTOPLEFT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY())};
            return points;
        }
        if (style == Poly.Type.TEXTBOTLEFT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
            return points;
        }
        if (style == Poly.Type.TEXTTOPRIGHT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
            return points;
        }
        if (style == Poly.Type.TEXTBOTRIGHT) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
            return points;
        }
        if (style == Poly.Type.TEXTBOX) {
            Point2D[] points = new Point2D.Double[12];
            if (eObj instanceof Geometric) {
                bounds = ((Geometric)eObj).getBounds();
            }
            double lX = bounds.getMinX();
            double hX = bounds.getMaxX();
            double lY = bounds.getMinY();
            double hY = bounds.getMaxY();
            points[0] = new Point2D.Double(lX, lY);
            points[1] = new Point2D.Double(hX, hY);
            points[2] = new Point2D.Double(lX, hY);
            points[3] = new Point2D.Double(hX, lY);
            double shrinkX = (hX - lX) / 5.0;
            double shrinkY = (hY - lY) / 5.0;
            points[4] = new Point2D.Double(lX + shrinkX, lY);
            points[5] = new Point2D.Double(hX - shrinkX, lY);
            points[6] = new Point2D.Double(lX + shrinkX, hY);
            points[7] = new Point2D.Double(hX - shrinkX, hY);
            points[8] = new Point2D.Double(lX, lY + shrinkY);
            points[9] = new Point2D.Double(lX, hY - shrinkY);
            points[10] = new Point2D.Double(hX, lY + shrinkY);
            points[11] = new Point2D.Double(hX, hY - shrinkY);
            return points;
        }
        return null;
    }

    public static int findObject(Point2D pt, EditWindow wnd, boolean exclusively, boolean another, boolean invert, boolean findPort, boolean findPoint, boolean findSpecial, boolean findText) {
        Rectangle2D.Double bounds;
        double bestdist = Double.MAX_VALUE;
        boolean looping = false;
        Cell cell = wnd.getCell();
        List underCursor = Highlight.findAllInArea(cell, exclusively, another, findPort, findPoint, findSpecial, findText, bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0), wnd);
        if (underCursor.size() == 0) {
            if (!invert) {
                Highlight.clear();
                Highlight.finished();
            }
            return 0;
        }
        if (underCursor.size() > 1 && another) {
            for (int j = 0; j < highlightList.size(); ++j) {
                Highlight oldHigh = (Highlight)highlightList.get(j);
                for (int i = 0; i < underCursor.size(); ++i) {
                    if (!oldHigh.sameThing((Highlight)underCursor.get(i))) continue;
                    if (invert) {
                        highlightList.remove(j);
                    } else {
                        Highlight.clear();
                    }
                    if (i < underCursor.size() - 1) {
                        highlightList.add(underCursor.get(i + 1));
                    } else {
                        highlightList.add(underCursor.get(0));
                    }
                    Highlight.finished();
                    return 1;
                }
            }
        }
        if (invert) {
            Highlight newHigh = (Highlight)underCursor.get(0);
            for (int i = 0; i < highlightList.size(); ++i) {
                if (!newHigh.sameThing((Highlight)highlightList.get(i))) continue;
                highlightList.remove(i);
                Highlight.finished();
                return 1;
            }
            highlightList.add(newHigh);
            Highlight.finished();
        } else {
            Highlight.clear();
            highlightList.add(underCursor.get(0));
            Highlight.finished();
        }
        return 1;
    }

    public String toString() {
        return "Highlight " + this.type;
    }

    public static List findAllInArea(Cell cell, boolean exclusively, boolean another, boolean findPort, boolean findPoint, boolean findSpecial, boolean findText, Rectangle2D bounds, EditWindow wnd) {
        ArrayList<Highlight> list = new ArrayList<Highlight>();
        boolean areaMustEnclose = User.isDraggingMustEncloseObjects();
        double directHitDist = 0.0;
        if (wnd != null) {
            Point2D extra = wnd.deltaScreenToDatabase(5, 5);
            directHitDist = extra.getX() + 0.4;
        }
        if (findText && wnd != null) {
            Poly[] polys;
            if (User.isTextVisibilityOnCell() && (polys = cell.getAllText(findSpecial, wnd)) != null) {
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    if (poly.setExactTextBounds(wnd, cell) || (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0) ? !poly.isInside(bounds) : poly.polyDistance(bounds) >= directHitDist)) continue;
                    Highlight h = new Highlight(Type.TEXT);
                    h.setElectricObject(cell);
                    h.setCell(cell);
                    h.setVar(poly.getVariable());
                    list.add(h);
                }
            }
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                AffineTransform trans = ni.rotateOut();
                EditWindow subWnd = wnd;
                Poly[] polys2 = ni.getAllText(findSpecial, wnd);
                if (polys2 == null) continue;
                for (int i = 0; i < polys2.length; ++i) {
                    double hitdist;
                    Poly poly = polys2[i];
                    poly.transform(trans);
                    if (poly.setExactTextBounds(wnd, ni) || (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0) ? !poly.isInside(bounds) : (hitdist = poly.polyDistance(bounds)) >= directHitDist)) continue;
                    Highlight h = new Highlight(Type.TEXT);
                    if (poly.getPort() != null) {
                        PortProto pp = poly.getPort();
                        h.setElectricObject(pp);
                        Iterator pIt = ni.getPortInsts();
                        while (pIt.hasNext()) {
                            PortInst pi = (PortInst)pIt.next();
                            if (pi.getPortProto() != pp) continue;
                            h.setElectricObject(pi);
                            break;
                        }
                    } else {
                        h.setElectricObject(ni);
                    }
                    h.setCell(cell);
                    h.setVar(poly.getVariable());
                    h.setName(poly.getName());
                    list.add(h);
                }
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                Poly[] polys3;
                ArcInst ai = (ArcInst)it.next();
                if (!User.isTextVisibilityOnArc() || (polys3 = ai.getAllText(findSpecial, wnd)) == null) continue;
                for (int i = 0; i < polys3.length; ++i) {
                    Poly poly = polys3[i];
                    if (poly.setExactTextBounds(wnd, ai) || (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0) ? !poly.isInside(bounds) : poly.polyDistance(bounds) >= directHitDist)) continue;
                    Highlight h = new Highlight(Type.TEXT);
                    h.setElectricObject(ai);
                    h.setCell(cell);
                    h.setVar(poly.getVariable());
                    h.setName(poly.getName());
                    list.add(h);
                }
            }
        }
        if (exclusively) {
            Iterator sIt = Highlight.getHighlights();
            while (sIt.hasNext()) {
                Highlight h = (Highlight)sIt.next();
                if (h.getType() != Type.EOBJ) continue;
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (!(eobj instanceof NodeInst) || (h = Highlight.checkOutObject((Geometric)eobj, findPort, findPoint, findSpecial, bounds, wnd, Double.MAX_VALUE, areaMustEnclose)) == null) continue;
                list.add(h);
            }
            return list;
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(bounds.getMinX() - directHitDist, bounds.getMinY() - directHitDist, bounds.getWidth() + directHitDist * 2.0, bounds.getHeight() + directHitDist * 2.0);
        for (int phase = 0; phase < 3; ++phase) {
            if (phase == 0 && !findSpecial && !User.isEasySelectionOfCellInstances()) continue;
            Iterator it = cell.searchIterator(searchArea);
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                switch (phase) {
                    case 0: {
                        Highlight h;
                        if (!(geom instanceof NodeInst) || ((NodeInst)geom).getProto() instanceof Cell || (h = Highlight.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                        list.add(h);
                        break;
                    }
                    case 1: {
                        Highlight h;
                        if (!(geom instanceof NodeInst) || ((NodeInst)geom).getProto() instanceof PrimitiveNode || (h = Highlight.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                        list.add(h);
                        break;
                    }
                    case 2: {
                        Highlight h;
                        if (!(geom instanceof ArcInst) || (h = Highlight.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                        list.add(h);
                    }
                }
            }
        }
        return list;
    }

    private static Highlight checkOutObject(Geometric geom, boolean findPort, boolean findPoint, boolean findSpecial, Rectangle2D bounds, EditWindow wnd, double directHitDist, boolean areaMustEnclose) {
        Rectangle2D geomBounds;
        Poly poly;
        if (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0) && !(poly = new Poly(geomBounds = geom.getBounds())).isInside(bounds)) {
            return null;
        }
        if (geom instanceof NodeInst) {
            boolean ignoreCells;
            NodeInst ni = (NodeInst)geom;
            boolean hardToSelect = ni.isHardSelect();
            boolean bl = ignoreCells = !User.isEasySelectionOfCellInstances();
            if (ni.getProto() instanceof Cell && ignoreCells) {
                hardToSelect = true;
            }
            if (!findSpecial && hardToSelect) {
                return null;
            }
            if (ni.isInvisiblePinWithText()) {
                return null;
            }
            double dist = Highlight.distToNode(bounds, ni, wnd);
            if (dist < directHitDist) {
                Highlight h = new Highlight(Type.EOBJ);
                Geometric eobj = geom;
                if (findPort) {
                    double bestDist = Double.MAX_VALUE;
                    PortInst bestPort = null;
                    Iterator it = ni.getPortInsts();
                    while (it.hasNext()) {
                        PortInst pi = (PortInst)it.next();
                        Poly poly2 = pi.getPoly();
                        dist = poly2.polyDistance(bounds);
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestPort = pi;
                    }
                    if (bestPort != null) {
                        eobj = bestPort;
                    }
                }
                if (findPoint) {
                    Point2D[] points = ni.getTrace();
                    Point2D.Double cursor = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    if (points != null) {
                        double bestDist = Double.MAX_VALUE;
                        int bestPoint = -1;
                        AffineTransform trans = ni.rotateOutAboutTrueCenter();
                        for (int i = 0; i < points.length; ++i) {
                            Point2D.Double pt = new Point2D.Double(ni.getAnchorCenterX() + points[i].getX(), ni.getAnchorCenterY() + points[i].getY());
                            trans.transform(pt, pt);
                            dist = pt.distance(cursor);
                            if (!(dist < bestDist)) continue;
                            bestDist = dist;
                            bestPoint = i;
                        }
                        if (bestPoint >= 0) {
                            h.setPoint(bestPoint);
                        }
                    }
                }
                h.setElectricObject(eobj);
                h.setCell(geom.getParent());
                return h;
            }
        } else {
            ArcInst ai = (ArcInst)geom;
            if (!findSpecial && ai.isHardSelect()) {
                return null;
            }
            double dist = Highlight.distToArc(bounds, ai, wnd);
            if (dist < directHitDist) {
                Highlight h = new Highlight(Type.EOBJ);
                h.setElectricObject(geom);
                h.setCell(geom.getParent());
                return h;
            }
        }
        return null;
    }

    private static double distToNode(Rectangle2D bounds, NodeInst ni, EditWindow wnd) {
        AffineTransform trans = ni.rotateOut();
        NodeProto np = ni.getProto();
        Poly nodePoly = null;
        if (np instanceof PrimitiveNode) {
            NodeProto.Function fun = np.getFunction();
            if (fun == NodeProto.Function.TRANMOS || fun == NodeProto.Function.TRAPMOS || fun == NodeProto.Function.TRADMOS) {
                Technology tech = np.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, wnd);
                double bestDist = Double.MAX_VALUE;
                for (int box = 0; box < polys.length; ++box) {
                    Layer.Function lf;
                    Poly poly = polys[box];
                    Layer layer = poly.getLayer();
                    if (layer == null || !(lf = layer.getFunction()).isPoly() && !lf.isDiff()) continue;
                    poly.transform(trans);
                    double dist = poly.polyDistance(bounds);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (np.isEdgeSelect()) {
                Technology tech = np.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, wnd);
                double bestDist = Double.MAX_VALUE;
                for (int box = 0; box < polys.length; ++box) {
                    Poly poly = polys[box];
                    poly.transform(trans);
                    double dist = poly.polyDistance(bounds);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            SizeOffset so = ni.getSizeOffset();
            double lX = ni.getAnchorCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
            double hX = ni.getAnchorCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
            double lY = ni.getAnchorCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
            double hY = ni.getAnchorCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
            nodePoly = new Poly((lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY);
        } else {
            Cell subCell = (Cell)np;
            Rectangle2D instBounds = subCell.getBounds();
            nodePoly = new Poly(ni.getAnchorCenterX() + instBounds.getCenterX(), ni.getAnchorCenterY() + instBounds.getCenterY(), instBounds.getWidth(), instBounds.getHeight());
        }
        AffineTransform pureTrans = ni.rotateOut();
        nodePoly.transform(pureTrans);
        nodePoly.setStyle(Poly.Type.FILLED);
        double dist = nodePoly.polyDistance(bounds);
        return dist;
    }

    private static double distToArc(Rectangle2D bounds, ArcInst ai, EditWindow wnd) {
        ArcProto ap = ai.getProto();
        if (ap.isEdgeSelect()) {
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai, wnd);
            double bestDist = Double.MAX_VALUE;
            for (int box = 0; box < polys.length; ++box) {
                Poly poly = polys[box];
                double dist = poly.polyDistance(bounds);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
            }
            return bestDist;
        }
        double wid = ai.getWidth() - ai.getProto().getWidthOffset();
        if (DBMath.doublesEqual(wid, 0.0)) {
            wid = 1.0;
        }
        Poly poly = ai.makePoly(ai.getLength(), wid, Poly.Type.FILLED);
        return poly.polyDistance(bounds);
    }

    private static void drawOutlineFromPoints(EditWindow wnd, Graphics g, Point2D[] points, int offX, int offY, boolean opened, Point2D thickCenter) {
        Dimension screen = wnd.getScreenSize();
        boolean onePoint = true;
        Point firstP = wnd.databaseToScreen(points[0].getX(), points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            Point p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
            if (DBMath.doublesEqual(p.getX(), firstP.getX()) && DBMath.doublesEqual(p.getY(), firstP.getY())) continue;
            onePoint = false;
            break;
        }
        if (onePoint) {
            Highlight.drawLine(g, wnd, firstP.x + offX - 3, firstP.y + offY, firstP.x + offX + 3, firstP.y + offY);
            Highlight.drawLine(g, wnd, firstP.x + offX, firstP.y + offY - 3, firstP.x + offX, firstP.y + offY + 3);
            return;
        }
        int cX = 0;
        int cY = 0;
        if (thickCenter != null) {
            Point lp = wnd.databaseToScreen(thickCenter.getX(), thickCenter.getY());
            cX = lp.x;
            cY = lp.y;
        }
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                if (opened) continue;
                lastI = points.length - 1;
            }
            Point lp = wnd.databaseToScreen(points[lastI].getX(), points[lastI].getY());
            Point p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
            int fX = lp.x + offX;
            int fY = lp.y + offY;
            int tX = p.x + offX;
            int tY = p.y + offY;
            Highlight.drawLine(g, wnd, fX, fY, tX, tY);
            if (thickCenter == null) continue;
            fX = fX < cX ? --fX : ++fX;
            fY = fY < cY ? --fY : ++fY;
            tX = tX < cX ? --tX : ++tX;
            tY = tY < cY ? --tY : ++tY;
            Highlight.drawLine(g, wnd, fX, fY, tX, tY);
        }
    }

    private static void drawLine(Graphics g, EditWindow wnd, int x1, int y1, int x2, int y2) {
        Dimension size = wnd.getScreenSize();
        if (x1 >= 0 && (double)x1 <= size.getWidth() || x2 >= 0 && (double)x2 <= size.getWidth() || y1 >= 0 && (double)y1 <= size.getHeight() || y2 >= 0 && (double)y2 <= size.getHeight()) {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    private boolean sameThing(Highlight other) {
        if (this.type != other.getType()) {
            return false;
        }
        if (this.type == Type.BBOX || this.type == Type.LINE || this.type == Type.THICKLINE) {
            return false;
        }
        if (this.type == Type.EOBJ) {
            ElectricObject realOtherEObj;
            ElectricObject realEObj = this.eobj;
            if (realEObj instanceof PortInst) {
                realEObj = ((PortInst)realEObj).getNodeInst();
            }
            if ((realOtherEObj = other.getElectricObject()) instanceof PortInst) {
                realOtherEObj = ((PortInst)realOtherEObj).getNodeInst();
            }
            if (realEObj != realOtherEObj) {
                return false;
            }
        } else if (this.type == Type.TEXT) {
            if (this.eobj != other.getElectricObject()) {
                return false;
            }
            if (this.cell != other.getCell()) {
                return false;
            }
            if (this.var != other.getVar()) {
                return false;
            }
            if (this.name != other.getName()) {
                return false;
            }
        }
        return true;
    }

    static {
        highlightList = new ArrayList();
        highlightStack = new ArrayList();
        lastHighlightsList = new ArrayList();
        highlightListeners = new ArrayList();
        solidLine = new BasicStroke(0.0f);
        dottedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
        dashedLine = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    }

    public static class Type {
        private final String name;
        private int order;
        private static int ordering = 1;
        public static final Type EOBJ = new Type("electricObject");
        public static final Type TEXT = new Type("text");
        public static final Type BBOX = new Type("area");
        public static final Type LINE = new Type("line");
        public static final Type THICKLINE = new Type("thick line");
        public static final Type MESSAGE = new Type("message");

        private Type(String name) {
            this.name = name;
            this.order = ordering++;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return this.name;
        }
    }
}

