/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DRCTab
extends PreferencePanel {
    private boolean initialDRCIncrementalOn;
    private boolean initialDRCOneErrorPerCell;
    private boolean initialDRCUseMultipleThreads;
    private boolean initialDRCIgnoreCenterCuts;
    private int initialDRCNumberOfThreads;
    private boolean requestedDRCClearDates;
    private JPanel drc;
    private JButton drcClearValidDates;
    private JButton drcEditRulesDeck;
    private JCheckBox drcIgnoreCenterCuts;
    private JCheckBox drcIncrementalOn;
    private JTextField drcNumberOfThreads;
    private JCheckBox drcOneErrorPerCell;
    private JCheckBox drcUseMultipleThreads;
    private JLabel jLabel33;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;

    public DRCTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.drc;
    }

    public String getName() {
        return "DRC";
    }

    public void init() {
        this.initialDRCIncrementalOn = DRC.isIncrementalDRCOn();
        this.drcIncrementalOn.setSelected(this.initialDRCIncrementalOn);
        this.initialDRCOneErrorPerCell = DRC.isOneErrorPerCell();
        this.drcOneErrorPerCell.setSelected(this.initialDRCOneErrorPerCell);
        this.initialDRCUseMultipleThreads = DRC.isUseMultipleThreads();
        this.drcUseMultipleThreads.setSelected(this.initialDRCUseMultipleThreads);
        this.initialDRCNumberOfThreads = DRC.getNumberOfThreads();
        this.drcNumberOfThreads.setText(Integer.toString(this.initialDRCNumberOfThreads));
        this.initialDRCIgnoreCenterCuts = DRC.isIgnoreCenterCuts();
        this.drcIgnoreCenterCuts.setSelected(this.initialDRCIgnoreCenterCuts);
        this.requestedDRCClearDates = false;
        this.drcClearValidDates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DRCTab.this.drcClearValidDates.setEnabled(false);
                DRCTab.this.requestedDRCClearDates = true;
            }
        });
        this.drcUseMultipleThreads.setEnabled(false);
        this.drcNumberOfThreads.setEditable(false);
        this.drcEditRulesDeck.setEnabled(false);
    }

    public void term() {
        boolean currentIgnoreCenterCuts;
        int currentNumberOfThreads;
        boolean currentUseMultipleThreads;
        boolean currentOneErrorPerCell;
        boolean currentIncrementalOn = this.drcIncrementalOn.isSelected();
        if (currentIncrementalOn != this.initialDRCIncrementalOn) {
            DRC.setIncrementalDRCOn(currentIncrementalOn);
        }
        if ((currentOneErrorPerCell = this.drcOneErrorPerCell.isSelected()) != this.initialDRCOneErrorPerCell) {
            DRC.setOneErrorPerCell(currentOneErrorPerCell);
        }
        if ((currentUseMultipleThreads = this.drcUseMultipleThreads.isSelected()) != this.initialDRCUseMultipleThreads) {
            DRC.setUseMultipleThreads(currentUseMultipleThreads);
        }
        if ((currentNumberOfThreads = TextUtils.atoi(this.drcNumberOfThreads.getText())) != this.initialDRCNumberOfThreads) {
            DRC.setNumberOfThreads(currentNumberOfThreads);
        }
        if ((currentIgnoreCenterCuts = this.drcIgnoreCenterCuts.isSelected()) != this.initialDRCIgnoreCenterCuts) {
            DRC.setIgnoreCenterCuts(currentIgnoreCenterCuts);
        }
        if (this.requestedDRCClearDates) {
            DRC.resetDRCDates();
        }
    }

    private void initComponents() {
        this.drc = new JPanel();
        this.jPanel3 = new JPanel();
        this.drcIncrementalOn = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.drcOneErrorPerCell = new JCheckBox();
        this.drcClearValidDates = new JButton();
        this.jPanel5 = new JPanel();
        this.drcUseMultipleThreads = new JCheckBox();
        this.jLabel33 = new JLabel();
        this.drcNumberOfThreads = new JTextField();
        this.drcIgnoreCenterCuts = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.drcEditRulesDeck = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DRCTab.this.closeDialog(evt);
            }
        });
        this.drc.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(new TitledBorder("Incremental DRC"));
        this.drcIncrementalOn.setText("On");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel3.add((Component)this.drcIncrementalOn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("Hierarchical DRC"));
        this.drcOneErrorPerCell.setText("Just 1 error per cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel4.add((Component)this.drcOneErrorPerCell, gridBagConstraints);
        this.drcClearValidDates.setText("Clear valid DRC dates");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel4.add((Component)this.drcClearValidDates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(new TitledBorder("Incremental and Hierarchical"));
        this.drcUseMultipleThreads.setText("Use multiple threads");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel5.add((Component)this.drcUseMultipleThreads, gridBagConstraints);
        this.jLabel33.setText("Number of threads:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel5.add((Component)this.jLabel33, gridBagConstraints);
        this.drcNumberOfThreads.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.jPanel5.add((Component)this.drcNumberOfThreads, gridBagConstraints);
        this.drcIgnoreCenterCuts.setText("Ignore center cuts in large contacts");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel5.add((Component)this.drcIgnoreCenterCuts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel6.setBorder(new TitledBorder("Dracula DRC Interface"));
        this.drcEditRulesDeck.setText("Edit Rules Deck");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel6.add((Component)this.drcEditRulesDeck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.jPanel6, gridBagConstraints);
        this.getContentPane().add((Component)this.drc, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

