/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class View3DWindow
extends JPanel
implements WindowContent,
MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener,
HighlightListener {
    private SimpleUniverse u;
    private Canvas3D canvas;
    private TransformGroup objTrans;
    private MouseBehavior rotateB;
    private JMouseZoom zoomB;
    private JMouseTranslate translateB;
    private OffScreenCanvas3D offScreenCanvas3D;
    private WindowFrame wf;
    private WindowContent view2D;
    private Cell cell;
    private double scale = User.get3DFactor();
    private Highlighter highlighter;
    private PickCanvas pickCanvas;
    private HashMap electricObjectMap = new HashMap();
    private static JAppearance cellApp = new JAppearance(null);
    private static JAppearance highligtAp = new JAppearance(null);
    private static Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    private static Color3f white = new Color3f(1.0f, 1.0f, 1.0f);

    public View3DWindow(Cell cell, WindowFrame wf, WindowContent view2D) {
        this.cell = cell;
        this.wf = wf;
        this.view2D = view2D;
        this.highlighter = new Highlighter(0, wf);
        this.highlighter.addHighlightListener(this);
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        BoundingSphere infiniteBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        this.canvas = new Canvas3D(config);
        this.add("Center", (Component)this.canvas);
        this.canvas.addMouseListener((MouseListener)this);
        BranchGroup scene = this.createSceneGraph(cell, infiniteBounds);
        ViewingPlatform viewP = new ViewingPlatform(4);
        viewP.setCapability(12);
        Viewer viewer = new Viewer(this.canvas);
        this.u = new SimpleUniverse(viewP, viewer);
        this.u.addBranchGraph(scene);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        JMouseTranslate translate = new JMouseTranslate((Component)this.canvas, 2);
        translate.setTransformGroup(viewingPlatform.getMultiTransformGroup().getTransformGroup(2));
        translate.setSchedulingBounds((Bounds)infiniteBounds);
        double scale = cell.getDefWidth() < cell.getDefHeight() ? cell.getDefWidth() : cell.getDefHeight();
        translate.setFactor(0.01 * scale);
        BranchGroup translateBG = new BranchGroup();
        translateBG.addChild((Node)translate);
        viewingPlatform.addChild((Node)translateBG);
        this.translateB = translate;
        JMouseZoom zoom = new JMouseZoom((Component)this.canvas, 2);
        zoom.setTransformGroup(viewingPlatform.getMultiTransformGroup().getTransformGroup(1));
        zoom.setSchedulingBounds((Bounds)infiniteBounds);
        zoom.setFactor(0.7);
        BranchGroup zoomBG = new BranchGroup();
        zoomBG.addChild((Node)zoom);
        viewingPlatform.addChild((Node)zoomBG);
        this.zoomB = zoom;
        MouseRotate rotate = new MouseRotate(2);
        rotate.setTransformGroup(viewingPlatform.getMultiTransformGroup().getTransformGroup(0));
        BranchGroup rotateBG = new BranchGroup();
        rotateBG.addChild((Node)rotate);
        viewingPlatform.addChild((Node)rotateBG);
        rotate.setSchedulingBounds((Bounds)infiniteBounds);
        this.rotateB = rotate;
        BoundingSphere sceneBnd = (BoundingSphere)scene.getBounds();
        double radius = sceneBnd.getRadius();
        View view = this.u.getViewer().getView();
        if (this.canvas.getSceneAntialiasingAvailable() && User.is3DAntialiasing()) {
            view.setSceneAntialiasingEnable(true);
        }
        view.setProjectionPolicy(User.is3DPerspective() ? 1 : 0);
        if (!User.is3DPerspective()) {
            view.setCompatibilityModeEnable(true);
        }
        Point3d c1 = new Point3d();
        sceneBnd.getCenter(c1);
        Vector3d vCenter = new Vector3d((Tuple3d)c1);
        double vDist = 1.4 * radius / Math.tan(view.getFieldOfView() / 2.0);
        Point3d c2 = new Point3d();
        sceneBnd.getCenter(c2);
        c2.z += vDist;
        vCenter.z += vDist;
        Transform3D vTrans = new Transform3D();
        Transform3D proj = new Transform3D();
        proj.ortho(cell.getBounds().getMinX(), cell.getBounds().getMaxX(), cell.getBounds().getMinY(), cell.getBounds().getMaxY(), (vDist + radius) / 200.0, (vDist + radius) * 2.0);
        vTrans.set(vCenter);
        view.setBackClipDistance((vDist + radius) * 2.0);
        view.setFrontClipDistance((vDist + radius) / 200.0);
        view.setBackClipPolicy(2);
        view.setFrontClipPolicy(2);
        if (User.is3DPerspective()) {
            viewingPlatform.getViewPlatformTransform().setTransform(vTrans);
        } else {
            view.setVpcToEc(proj);
        }
        this.setWindowTitle();
    }

    private BranchGroup createSceneGraph(Cell cell, BoundingSphere infiniteBounds) {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(3);
        objRoot.setCapability(1);
        objRoot.setCapability(4);
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        this.objTrans.setCapability(1);
        objRoot.addChild((Node)this.objTrans);
        Background bg = new Background(new Color3f(new Color(User.getColorBackground())));
        bg.setApplicationBounds((Bounds)infiniteBounds);
        objRoot.addChild((Node)bg);
        View3DEnumerator view3D = new View3DEnumerator();
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, null, view3D);
        Color3f alColor = new Color3f(0.6f, 0.6f, 0.6f);
        AmbientLight aLgt = new AmbientLight(alColor);
        Vector3f lightDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(white, lightDir1);
        light1.setInfluencingBounds((Bounds)infiniteBounds);
        aLgt.setInfluencingBounds((Bounds)infiniteBounds);
        light1.setCapability(13);
        objRoot.addChild((Node)aLgt);
        this.objTrans.addChild((Node)light1);
        objRoot.compile();
        this.pickCanvas = new PickCanvas(this.canvas, objRoot);
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setTolerance(4.0f);
        return objRoot;
    }

    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, "3D View: ", 0));
    }

    public Cell getCell() {
        return this.cell;
    }

    public void finished() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    public void bottomScrollChanged(int e) {
    }

    public void rightScrollChanged(int e) {
    }

    public void fullRepaint() {
        System.out.println("View3DWindow::fullRepaint");
    }

    public boolean findNextText(boolean reverse) {
        return false;
    }

    public void replaceText(String replace) {
    }

    public JPanel getPanel() {
        return this;
    }

    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
    }

    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        Dimension dim = this.getSize();
        double panningAmount = panningAmounts[User.getPanningDistance()];
        int mult = (int)(10.0 * panningAmount);
        if (mult == 0) {
            mult = 1;
        }
        if (direction == 0) {
            this.translateB.panning(mult * ticks, 0);
        } else {
            this.translateB.panning(0, mult * ticks);
        }
    }

    public void zoomOutContents() {
        this.zoomB.zoomInOut(false);
    }

    public void zoomInContents() {
        this.zoomB.zoomInOut(true);
    }

    public void fillScreen() {
        Transform3D trans = new Transform3D();
        Transform3D x = new Transform3D();
        this.zoomB.getTransformGroup().getTransform(x);
        this.zoomB.getTransformGroup().setTransform(trans);
        this.rotateB.getTransformGroup().getTransform(x);
        this.rotateB.getTransformGroup().setTransform(trans);
        this.translateB.getTransformGroup().getTransform(x);
        this.translateB.getTransformGroup().setTransform(trans);
    }

    public void setCell(Cell cell, VarContext context) {
    }

    public void focusOnHighlighted() {
    }

    public void cellHistoryGoBack() {
    }

    public void cellHistoryGoForward() {
    }

    public boolean cellHistoryCanGoBack() {
        return false;
    }

    public boolean cellHistoryCanGoForward() {
        return false;
    }

    public void fireCellHistoryStatus() {
    }

    public void replaceAllText(String replace) {
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void loadExplorerTree(DefaultMutableTreeNode rootNode) {
        this.wf.libraryExplorerNode = ExplorerTree.makeLibraryTree();
        this.wf.jobExplorerNode = Job.getExplorerTree();
        this.wf.errorExplorerNode = ErrorLogger.getExplorerTree();
        this.wf.signalExplorerNode = null;
        rootNode.add(this.wf.libraryExplorerNode);
        rootNode.add(this.wf.jobExplorerNode);
        rootNode.add(this.wf.errorExplorerNode);
    }

    public void addArc(ArcInst ai, AffineTransform transform, TransformGroup objTrans) {
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        List list = this.addPolys(tech.getShapeOfArc(ai), transform, objTrans);
        this.electricObjectMap.put(ai, list);
    }

    public void addNode(NodeInst no, AffineTransform transform, TransformGroup objTrans) {
        NodeProto nProto = no.getProto();
        Technology tech = nProto.getTechnology();
        int gate = -1;
        int count = 0;
        int poly = -1;
        if (NodeInst.isSpecialNode(no)) {
            return;
        }
        ArrayList<Shape3D> list = null;
        if (!(nProto instanceof PrimitiveNode)) {
            Cell cell = (Cell)nProto;
            Rectangle2D rect = no.getBounds();
            double[] values = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
            cell.getZValues(values);
            values[0] = values[0] * this.scale;
            values[1] = values[1] * this.scale;
            Poly pol = new Poly(rect);
            list = new ArrayList<Shape3D>(1);
            pol.transform(transform);
            rect = pol.getBounds2D();
            list.add(this.addPolyhedron(rect, values[0], values[1] - values[0], (Appearance)cellApp, objTrans));
        } else {
            Poly[] polys = tech.getShapeOfNode(no, null, true, true, null);
            ArrayList<Shape3D> boxList = null;
            if (nProto.getFunction().isTransistor()) {
                int[] active = new int[2];
                boxList = new ArrayList<Shape3D>(4);
                for (int i = 0; i < polys.length; ++i) {
                    Layer.Function fun = polys[i].getLayer().getFunction();
                    if (fun.isDiff()) {
                        active[count++] = i;
                        continue;
                    }
                    if (fun.isGatePoly()) {
                        gate = i;
                        continue;
                    }
                    if (!fun.isPoly()) continue;
                    poly = i;
                }
                if (count == 2) {
                    Rectangle2D rect1 = polys[active[0]].getBounds2D();
                    Rectangle2D rect2 = polys[active[1]].getBounds2D();
                    double minX = Math.min(rect1.getMinX(), rect2.getMinX());
                    double minY = Math.min(rect1.getMinY(), rect2.getMinY());
                    double maxX = Math.max(rect1.getMaxX(), rect2.getMaxX());
                    double maxY = Math.max(rect1.getMaxY(), rect2.getMaxY());
                    Rectangle2D.Double newRect = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
                    Poly tmp = new Poly(newRect);
                    tmp.setLayer(polys[active[0]].getLayer());
                    polys[active[0]] = tmp;
                    int last = polys.length - 1;
                    if (active[1] != last) {
                        polys[active[1]] = polys[last];
                    }
                    polys[last] = null;
                }
            }
            list = this.addPolys(polys, transform, objTrans);
            if (nProto.getFunction().isTransistor() && gate != -1 && poly != -1) {
                int right;
                int center;
                Point2D pointClose;
                Point2D pointDist;
                Point3d[] pts = new Point3d[8];
                Point2D[] points = polys[gate].getPoints();
                Point2D p0 = points[0];
                Point2D p1 = points[1];
                Point2D p2 = points[points.length - 1];
                double dist1 = p0.distance(p1);
                double dist2 = p0.distance(p2);
                Layer layer = polys[gate].getLayer();
                double dist = (layer.getDistance() + layer.getThickness()) * this.scale;
                double distPoly = polys[poly].getLayer().getDistance() * this.scale;
                ArrayList<Point3d> topList = new ArrayList<Point3d>();
                ArrayList<Point3d> bottomList = new ArrayList<Point3d>();
                if (dist1 > dist2) {
                    pointDist = p1;
                    pointClose = p2;
                    center = 1;
                    right = 2;
                } else {
                    pointDist = p2;
                    pointClose = p1;
                    center = 2;
                    right = points.length - 1;
                }
                Point2d pDelta = new Point2d(pointDist.getX() - points[0].getX(), pointDist.getY() - points[0].getY());
                pDelta.scale(0.1);
                double[] values = new double[2];
                pDelta.get(values);
                topList.add(new Point3d(p0.getX() + values[0], p0.getY() + values[1], dist));
                topList.add(new Point3d(p0.getX(), p0.getY(), distPoly));
                topList.add(new Point3d(p0.getX() - values[0], p0.getY() - values[1], distPoly));
                topList.add(new Point3d(p0.getX(), p0.getY(), dist));
                bottomList.add(new Point3d(pointClose.getX() + values[0], pointClose.getY() + values[1], dist));
                bottomList.add(new Point3d(pointClose.getX(), pointClose.getY(), distPoly));
                bottomList.add(new Point3d(pointClose.getX() - values[0], pointClose.getY() - values[1], distPoly));
                bottomList.add(new Point3d(pointClose.getX(), pointClose.getY(), dist));
                this.correctNormals(topList, bottomList);
                System.arraycopy(topList.toArray(), 0, pts, 0, 4);
                System.arraycopy(bottomList.toArray(), 0, pts, 4, 4);
                boxList.add(this.addShape3D(pts, 4, this.getAppearance(layer)));
                topList.clear();
                bottomList.clear();
                topList.add(new Point3d(points[center].getX() - values[0], points[center].getY() - values[1], dist));
                topList.add(new Point3d(points[center].getX(), points[center].getY(), distPoly));
                topList.add(new Point3d(points[center].getX() + values[0], points[center].getY() + values[1], distPoly));
                topList.add(new Point3d(points[center].getX(), points[center].getY(), dist));
                bottomList.add(new Point3d(points[right].getX() - values[0], points[right].getY() - values[1], dist));
                bottomList.add(new Point3d(points[right].getX(), points[right].getY(), distPoly));
                bottomList.add(new Point3d(points[right].getX() + values[0], points[right].getY() + values[1], distPoly));
                bottomList.add(new Point3d(points[right].getX(), points[right].getY(), dist));
                this.correctNormals(topList, bottomList);
                System.arraycopy(topList.toArray(), 0, pts, 0, 4);
                System.arraycopy(bottomList.toArray(), 0, pts, 4, 4);
                boxList.add(this.addShape3D(pts, 4, this.getAppearance(layer)));
            }
            if (boxList != null) {
                list.addAll(boxList);
            }
        }
        this.electricObjectMap.put(no, list);
    }

    private void correctNormals(List topList, List bottomList) {
        Point3d p0 = (Point3d)topList.get(0);
        Point3d p1 = new Point3d((Point3d)topList.get(1));
        p1.sub((Tuple3d)p0);
        Point3d pn = new Point3d((Point3d)topList.get(topList.size() - 1));
        pn.sub((Tuple3d)p0);
        Vector3d aux = new Vector3d();
        aux.cross(new Vector3d((Tuple3d)p1), new Vector3d((Tuple3d)pn));
        Point3d b0 = new Point3d((Point3d)bottomList.get(0));
        b0.sub((Tuple3d)p0);
        double dot = aux.dot(new Vector3d((Tuple3d)b0));
        if (dot > 0.0) {
            Collections.reverse(topList);
            Collections.reverse(bottomList);
        }
    }

    private Shape3D addShape3D(Point3d[] pts, int listLen, Appearance ap) {
        int numFaces = listLen + 2;
        int[] indices = new int[listLen * 6];
        int[] stripCounts = new int[numFaces];
        int[] contourCount = new int[numFaces];
        Arrays.fill(contourCount, 1);
        Arrays.fill(stripCounts, 4);
        stripCounts[0] = listLen;
        stripCounts[numFaces - 1] = listLen;
        int count = 0;
        int i = 0;
        while (i < listLen) {
            indices[count++] = i++;
        }
        for (i = 0; i < listLen; ++i) {
            indices[count++] = i;
            indices[count++] = i + listLen;
            indices[count++] = (i + 1) % listLen + listLen;
            indices[count++] = (i + 1) % listLen;
        }
        for (i = 0; i < listLen; ++i) {
            indices[count++] = (listLen - i) % listLen + listLen;
        }
        GeometryInfo gi = new GeometryInfo(5);
        gi.setCoordinates(pts);
        gi.setCoordinateIndices(indices);
        gi.setStripCounts(stripCounts);
        gi.setContourCounts(contourCount);
        NormalGenerator ng = new NormalGenerator();
        ng.setCreaseAngle((double)((float)Math.toRadians(30.0)));
        ng.generateNormals(gi);
        GeometryArray c = gi.getGeometryArray();
        c.setCapability(18);
        Shape3D box = new Shape3D((Geometry)c, ap);
        box.setCapability(1);
        box.setCapability(11);
        box.setCapability(5);
        box.setCapability(14);
        box.setCapability(15);
        box.setCapability(3);
        PickTool.setCapabilities((Node)box, (int)4100);
        this.objTrans.addChild((Node)box);
        return box;
    }

    private Shape3D addPolyhedron(Rectangle2D bounds, double distance, double thickness, Appearance ap, TransformGroup objTrans) {
        GeometryInfo gi = new GeometryInfo(2);
        double height = thickness + distance;
        Point3d[] pts = new Point3d[]{new Point3d(bounds.getMinX(), bounds.getMinY(), distance), new Point3d(bounds.getMinX(), bounds.getMaxY(), distance), new Point3d(bounds.getMaxX(), bounds.getMaxY(), distance), new Point3d(bounds.getMaxX(), bounds.getMinY(), distance), new Point3d(bounds.getMinX(), bounds.getMinY(), height), new Point3d(bounds.getMinX(), bounds.getMaxY(), height), new Point3d(bounds.getMaxX(), bounds.getMaxY(), height), new Point3d(bounds.getMaxX(), bounds.getMinY(), height)};
        int[] indices = new int[]{0, 1, 2, 3, 0, 4, 5, 1, 0, 3, 7, 4, 1, 5, 6, 2, 2, 6, 7, 3, 4, 7, 6, 5};
        gi.setCoordinates(pts);
        gi.setCoordinateIndices(indices);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        GeometryArray c = gi.getGeometryArray();
        c.setCapability(18);
        Shape3D box = new Shape3D((Geometry)c, ap);
        box.setCapability(1);
        box.setCapability(11);
        box.setCapability(5);
        box.setCapability(14);
        box.setCapability(15);
        box.setCapability(3);
        PickTool.setCapabilities((Node)box, (int)4100);
        objTrans.addChild((Node)box);
        return box;
    }

    private JAppearance getAppearance(Layer layer) {
        EGraphics graphics = layer.getGraphics();
        JAppearance ap = (JAppearance)((Object)graphics.get3DAppearance());
        if (ap == null) {
            ap = new JAppearance(graphics);
            Color color = layer.getGraphics().getColor();
            Color3f objColor = new Color3f(color);
            RenderingAttributes ra = new RenderingAttributes();
            ra.setCapability(5);
            ra.setCapability(6);
            ra.setVisible(layer.isVisible());
            ap.setRenderingAttributes(ra);
            Material mat = new Material();
            mat.setDiffuseColor(objColor);
            mat.setSpecularColor(objColor);
            mat.setAmbientColor(objColor);
            mat.setLightingEnable(true);
            mat.setCapability(0);
            mat.setCapability(1);
            ap.setMaterial(mat);
            ap.setCapability(0);
            ap.setCapability(1);
            ap.setCapability(12);
            ap.setCapability(13);
            graphics.set3DAppearance((Object)ap);
        }
        return ap;
    }

    private Shape3D addPolyhedron(PathIterator pIt, double distance, double thickness, Appearance ap, TransformGroup objTrans) {
        double height = thickness + distance;
        double[] coords = new double[6];
        ArrayList<Point3d> topList = new ArrayList<Point3d>();
        ArrayList<Point3d> bottomList = new ArrayList<Point3d>();
        ArrayList<Shape3D> shapes = new ArrayList<Shape3D>();
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                int listLen = topList.size();
                Point3d[] pts = new Point3d[listLen * 2];
                this.correctNormals(topList, bottomList);
                System.arraycopy(topList.toArray(), 0, pts, 0, listLen);
                System.arraycopy(bottomList.toArray(), 0, pts, listLen, listLen);
                int numFaces = listLen + 2;
                int[] indices = new int[listLen * 6];
                int[] stripCounts = new int[numFaces];
                int[] contourCount = new int[numFaces];
                Arrays.fill(contourCount, 1);
                Arrays.fill(stripCounts, 4);
                stripCounts[0] = listLen;
                stripCounts[numFaces - 1] = listLen;
                int count = 0;
                int i = 0;
                while (i < listLen) {
                    indices[count++] = i++;
                }
                for (i = 0; i < listLen; ++i) {
                    indices[count++] = i;
                    indices[count++] = i + listLen;
                    indices[count++] = (i + 1) % listLen + listLen;
                    indices[count++] = (i + 1) % listLen;
                }
                for (i = 0; i < listLen; ++i) {
                    indices[count++] = (listLen - i) % listLen + listLen;
                }
                GeometryInfo gi = new GeometryInfo(5);
                gi.setCoordinates(pts);
                gi.setCoordinateIndices(indices);
                gi.setStripCounts(stripCounts);
                gi.setContourCounts(contourCount);
                NormalGenerator ng = new NormalGenerator();
                ng.setCreaseAngle((double)((float)Math.toRadians(30.0)));
                ng.generateNormals(gi);
                GeometryArray c = gi.getGeometryArray();
                c.setCapability(18);
                Shape3D box = new Shape3D((Geometry)c, ap);
                box.setCapability(1);
                box.setCapability(11);
                box.setCapability(5);
                box.setCapability(14);
                box.setCapability(15);
                box.setCapability(3);
                PickTool.setCapabilities((Node)box, (int)4100);
                objTrans.addChild((Node)box);
                shapes.add(box);
                topList.clear();
                bottomList.clear();
            } else if (type == 0 || type == 1) {
                Point3d pt = new Point3d(coords[0], coords[1], distance);
                topList.add(pt);
                pt = new Point3d(coords[0], coords[1], height);
                bottomList.add(pt);
            }
            pIt.next();
        }
        if (shapes.size() > 1) {
            System.out.println("Error: case not handled");
        }
        return (Shape3D)shapes.get(0);
    }

    private List addPolys(Poly[] polys, AffineTransform transform, TransformGroup objTrans) {
        if (polys == null) {
            return null;
        }
        ArrayList<Shape3D> list = new ArrayList<Shape3D>();
        for (int i = 0; i < polys.length; ++i) {
            Layer layer;
            Poly poly = polys[i];
            if (poly == null || !(layer = poly.getLayer()).isVisible()) continue;
            double thickness = layer.getThickness() * this.scale;
            double distance = layer.getDistance() * this.scale;
            if (thickness == 0.0) continue;
            if (transform != null) {
                poly.transform(transform);
            }
            JAppearance ap = this.getAppearance(layer);
            if (poly.getBox() == null) {
                list.add(this.addPolyhedron(poly.getPathIterator(null), distance, thickness, (Appearance)ap, objTrans));
                continue;
            }
            Rectangle2D bounds = poly.getBounds2D();
            list.add(this.addPolyhedron(bounds, distance, thickness, (Appearance)ap, objTrans));
        }
        return list;
    }

    public static void set3DVisibility(Object obj, Boolean visible) {
        JAppearance app = (JAppearance)((Object)obj);
        app.getRenderingAttributes().setVisible(visible.booleanValue());
    }

    public static void set3DColor(Object obj, Color color) {
        JAppearance app = (JAppearance)((Object)obj);
        Color3f color3D = new Color3f(color);
        Material mat = app.getMaterial();
        mat.setAmbientColor(color3D);
        mat.setDiffuseColor(color3D);
    }

    public static void show3DHighlight(WindowContent view2D) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof View3DWindow)) continue;
            View3DWindow wnd = (View3DWindow)content;
            wnd.selectObject(false, false);
            if (wnd.view2D != view2D) continue;
            Highlighter highlighter2D = view2D.getHighlighter();
            List geomList = highlighter2D.getHighlightedEObjs(true, true);
            Iterator hIt = geomList.iterator();
            while (hIt.hasNext()) {
                ElectricObject eobj = (ElectricObject)hIt.next();
                List list = (List)wnd.electricObjectMap.get(eobj);
                if (list == null || list.size() == 0) continue;
                Iterator lIt = list.iterator();
                while (lIt.hasNext()) {
                    Shape3D shape = (Shape3D)lIt.next();
                    wnd.highlighter.addObject(shape, Highlight.Type.SHAPE3D, wnd.cell);
                }
            }
            wnd.selectObject(true, false);
            return;
        }
    }

    public static void setScaleFactor(Double value) {
        Transform3D vTrans = new Transform3D();
        Vector3d vCenter = new Vector3d(1.0, 1.0, value.doubleValue());
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof View3DWindow)) continue;
            View3DWindow wnd = (View3DWindow)content;
            wnd.objTrans.getTransform(vTrans);
            vTrans.setScale(vCenter);
            wnd.objTrans.setTransform(vTrans);
        }
    }

    public static void setAntialiasing(Boolean value) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof View3DWindow)) continue;
            View3DWindow wnd = (View3DWindow)content;
            View view = wnd.u.getViewer().getView();
            view.setSceneAntialiasingEnable(value.booleanValue());
        }
    }

    public BufferedImage getOffScreenImage(ElectricPrinter ep) {
        Graphics2D g2d;
        BufferedImage bImage = ep.getBufferedImage();
        int OFF_SCREEN_SCALE = 3;
        if (bImage == null) {
            if (this.offScreenCanvas3D == null) {
                this.offScreenCanvas3D = new OffScreenCanvas3D(SimpleUniverse.getPreferredConfiguration(), true);
                this.u.getViewer().getView().addCanvas3D((Canvas3D)this.offScreenCanvas3D);
                Screen3D sOn = this.canvas.getScreen3D();
                Screen3D sOff = this.offScreenCanvas3D.getScreen3D();
                Dimension dim = sOn.getSize();
                dim.width *= OFF_SCREEN_SCALE;
                dim.height *= OFF_SCREEN_SCALE;
                sOff.setSize(dim);
                sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth() * (double)OFF_SCREEN_SCALE);
                sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight() * (double)OFF_SCREEN_SCALE);
                bImage = new BufferedImage(dim.width, dim.height, 2);
                ImageComponent2D buffer = new ImageComponent2D(2, bImage);
                this.offScreenCanvas3D.setOffScreenBuffer(buffer);
            }
            this.offScreenCanvas3D.renderOffScreenBuffer();
            this.offScreenCanvas3D.waitForOffScreenRendering();
            bImage = this.offScreenCanvas3D.getOffScreenBuffer().getImage();
            ep.setBufferedImage(bImage);
        }
        if ((g2d = (Graphics2D)ep.getGraphics()) != null) {
            AffineTransform t2d = new AffineTransform();
            t2d.translate(ep.getPageFormat().getImageableX(), ep.getPageFormat().getImageableY());
            double xscale = ep.getPageFormat().getImageableWidth() / (double)bImage.getWidth();
            double yscale = ep.getPageFormat().getImageableHeight() / (double)bImage.getHeight();
            double scale = Math.min(xscale, yscale);
            t2d.scale(scale, scale);
            try {
                ElectricPrinter obj = ep;
                g2d.drawImage(bImage, t2d, obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return bImage;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        Cell cell = (Cell)Cell.findNodeProto(source.getText());
        if (cell == null) {
            return;
        }
        this.setCell(cell, VarContext.globalContext);
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    private void selectObject(boolean toSelect, boolean do2D) {
        Highlighter highlighter2D = null;
        if (this.view2D != null && do2D) {
            highlighter2D = this.view2D.getHighlighter();
            highlighter2D.clear();
        }
        Iterator it = this.highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            Shape3D obj = (Shape3D)h.getObject();
            if (toSelect) {
                JAppearance app = (JAppearance)obj.getAppearance();
                obj.setAppearance((Appearance)highligtAp);
                highligtAp.seGraphics(app.getGraphics());
                if (this.view2D == null || !do2D) continue;
                BoundingBox bb = (BoundingBox)obj.getBounds();
                Point3d lowerP = new Point3d();
                Point3d upperP = new Point3d();
                bb.getUpper(upperP);
                bb.getLower(lowerP);
                double[] lowerValues = new double[3];
                double[] upperValues = new double[3];
                lowerP.get(lowerValues);
                upperP.get(upperValues);
                Rectangle2D.Double area = new Rectangle2D.Double(lowerValues[0], lowerValues[1], upperValues[0] - lowerValues[0], upperValues[1] - lowerValues[1]);
                highlighter2D.addArea(area, this.cell);
                continue;
            }
            EGraphics graphics = highligtAp.getGraphics();
            if (graphics != null) {
                JAppearance origAp = (JAppearance)((Object)graphics.get3DAppearance());
                obj.setAppearance((Appearance)origAp);
                continue;
            }
            obj.setAppearance((Appearance)cellApp);
        }
        if (!toSelect) {
            this.highlighter.clear();
        }
        if (do2D) {
            this.view2D.fullRepaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        Shape3D s;
        this.pickCanvas.setShapeLocation(evt);
        Transform3D t = new Transform3D();
        Transform3D t1 = new Transform3D();
        this.canvas.getImagePlateToVworld(t);
        this.canvas.getVworldToImagePlate(t1);
        PickResult result = this.pickCanvas.pickClosest();
        this.selectObject(false, true);
        if (result != null && (s = (Shape3D)result.getNode(1)) != null) {
            this.highlighter.addObject(s, Highlight.Type.SHAPE3D, this.cell);
            this.selectObject(true, true);
        }
        WindowFrame.curMouseListener.mouseClicked(evt);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    private void showCoordinates(MouseEvent evt) {
        View3DWindow wnd = (View3DWindow)evt.getSource();
        if (wnd.getCell() == null) {
            StatusBar.setCoordinates(null, wnd.wf);
        } else {
            Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(pt);
            StatusBar.setCoordinates("(" + TextUtils.formatDouble(pt.getX(), 2) + ", " + TextUtils.formatDouble(pt.getY(), 2) + ")", wnd.wf);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        WindowFrame.curMouseWheelListener.mouseWheelMoved(evt);
    }

    public void keyPressed(KeyEvent evt) {
        System.out.println("Here keyPressed");
        WindowFrame.curKeyListener.keyPressed(evt);
    }

    public void keyReleased(KeyEvent evt) {
        System.out.println("Here keyReleased");
        WindowFrame.curKeyListener.keyReleased(evt);
    }

    public void keyTyped(KeyEvent evt) {
        System.out.println("Here keyTyped");
        WindowFrame.curKeyListener.keyTyped(evt);
    }

    public void highlightChanged(Highlighter which) {
        this.repaint();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    public Point getLastMousePosition() {
        return new Point(0, 0);
    }

    public Point2D screenToDatabase(int screenX, int screenY) {
        double dbX = 0.0;
        double dbY = 0.0;
        return new Point2D.Double(dbX, dbY);
    }

    static {
        Color3f objColor = new Color3f(Color.GRAY);
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(objColor);
        cellApp.setColoringAttributes(ca);
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setTransparencyMode(3);
        ta.setTransparency(0.5f);
        cellApp.setTransparencyAttributes(ta);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        pa.setPolygonMode(1);
        cellApp.setPolygonAttributes(pa);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        cellApp.setTextureAttributes(texAttr);
        LineAttributes lineAttr = new LineAttributes();
        lineAttr.setLineAntialiasingEnable(true);
        cellApp.setLineAttributes(lineAttr);
        highligtAp.setColoringAttributes(new ColoringAttributes(black, 3));
        TransparencyAttributes hTa = new TransparencyAttributes(2, 0.5f);
        highligtAp.setTransparencyAttributes(hTa);
    }

    private class OffScreenCanvas3D
    extends Canvas3D {
        OffScreenCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean offScreen) {
            super(graphicsConfiguration, offScreen);
        }

        BufferedImage doRender(int width, int height) {
            BufferedImage bImage = new BufferedImage(width, height, 2);
            ImageComponent2D buffer = new ImageComponent2D(2, bImage);
            this.setOffScreenBuffer(buffer);
            this.renderOffScreenBuffer();
            this.waitForOffScreenRendering();
            bImage = this.getOffScreenBuffer().getImage();
            return bImage;
        }

        public void postSwap() {
        }
    }

    private class View3DEnumerator
    extends HierarchyEnumerator.Visitor {
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            AffineTransform rTrans = info.getTransformToRoot();
            Iterator it = info.getCell().getArcs();
            while (it.hasNext()) {
                View3DWindow.this.addArc((ArcInst)it.next(), rTrans, View3DWindow.this.objTrans);
            }
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            AffineTransform trans = ni.rotateOut();
            AffineTransform root = info.getTransformToRoot();
            if (root.getType() != 0) {
                trans.preConcatenate(root);
            }
            View3DWindow.this.addNode(ni, trans, View3DWindow.this.objTrans);
            return ni.isExpanded();
        }
    }

    public class JMouseZoom
    extends MouseZoom {
        public JMouseZoom(Component c, int flags) {
            super(c, flags);
        }

        void zoomInOut(boolean out) {
            this.transformGroup.getTransform(this.currXform);
            Matrix4d mat = new Matrix4d();
            this.currXform.get(mat);
            double z_factor = Math.abs(this.getFactor());
            double factor = out ? 0.5 / z_factor : 2.0 * z_factor;
            double factor1 = out ? 1.0 / z_factor : z_factor;
            double dy = this.currXform.getScale() * factor1;
            this.currXform.setScale(dy);
            this.transformGroup.setTransform(this.currXform);
            this.transformChanged(this.currXform);
        }
    }

    public class JMouseTranslate
    extends MouseTranslate {
        Vector3d extraTrans;

        public JMouseTranslate(Component c, int flags) {
            super(c, flags);
            this.extraTrans = new Vector3d();
        }

        void panning(int dx, int dy) {
            this.transformGroup.getTransform(this.currXform);
            this.extraTrans.x = (double)dx * this.getXFactor();
            this.extraTrans.y = (double)(-dy) * this.getYFactor();
            this.transformX.set(this.extraTrans);
            if (this.invert) {
                this.currXform.mul(this.currXform, this.transformX);
            } else {
                this.currXform.mul(this.transformX, this.currXform);
            }
            this.transformGroup.setTransform(this.currXform);
            this.transformChanged(this.currXform);
        }
    }

    private static class JAppearance
    extends Appearance {
        private EGraphics graphics;

        public JAppearance(EGraphics graphics) {
            this.graphics = graphics;
        }

        public void seGraphics(EGraphics graphics) {
            this.graphics = graphics;
        }

        public EGraphics getGraphics() {
            return this.graphics;
        }
    }
}

