/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.tool.ncc.jemNets.NccNameProxy;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.PinType;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import java.util.HashSet;
import java.util.Set;

public class Subcircuit
extends Part {
    private final int[] termCoeffs;
    private final SubcircuitInfo subcircuitInfo;

    private String getPortName(int i) {
        return this.subcircuitInfo.getPortName(i);
    }

    public String valueDescription() {
        return "";
    }

    public int[] getTermCoefs() {
        return this.termCoeffs;
    }

    public boolean parallelMerge(Part p) {
        return false;
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins.length;
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.termCoeffs[i];
        }
        hc += this.getClass().hashCode();
        return new Integer(hc += this.subcircuitInfo.getID());
    }

    public String typeString() {
        return this.subcircuitInfo.getName();
    }

    public int typeCode() {
        return 2 + (this.subcircuitInfo.getID() << 4);
    }

    public boolean touchesAtGate(Wire w) {
        return false;
    }

    public boolean isThisGate(int x) {
        return false;
    }

    public Set getPinTypes() {
        HashSet<SubcircuitPinType> types = new HashSet<SubcircuitPinType>();
        for (int i = 0; i < this.pins.length; ++i) {
            String pinDesc = this.typeString() + " " + this.getPortName(i);
            SubcircuitPinType t = new SubcircuitPinType(this.typeCode(), i, pinDesc);
            types.add(t);
        }
        return types;
    }

    public String connectionDescription(Wire w) {
        String msg = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (msg.length() != 0) {
                msg = msg + ',';
            }
            msg = msg + this.getPortName(i);
        }
        return msg;
    }

    public String connectionDescription(int maxCon) {
        String msg = "";
        for (int i = 0; i < maxCon && i < this.pins.length; ++i) {
            if (msg.length() != 0) {
                msg = msg + " ";
            }
            msg = msg + this.getPortName(i) + "=" + this.pins[i].getName();
        }
        return msg;
    }

    public Subcircuit(NccNameProxy.PartNameProxy instName, SubcircuitInfo subcircuitInfo, Wire[] pins) {
        super(instName, pins);
        this.subcircuitInfo = subcircuitInfo;
        this.termCoeffs = subcircuitInfo.getPortCoeffs();
    }

    private static class SubcircuitPinType
    implements PinType {
        private int typeCode;
        private int portIndex;
        private String description;

        SubcircuitPinType(int typeCode, int portIndex, String description) {
            this.typeCode = typeCode;
            this.portIndex = portIndex;
            this.description = description;
        }

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Subcircuit)) {
                return 0;
            }
            Subcircuit s = (Subcircuit)p;
            if (s.typeCode() != this.typeCode) {
                return 0;
            }
            if (s.pins[this.portIndex] != w) {
                return 0;
            }
            return 1;
        }

        public String description() {
            return this.description;
        }
    }
}

