/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SpiceTab
extends PreferencePanel {
    private JList spiceCellList;
    private DefaultListModel spiceCellListModel;
    private HashMap spiceCellModelOptions;
    private HashMap initialSpiceModelFiles;
    private boolean spiceModelFileChanging = false;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JCheckBox overwriteOutputFile;
    private JPanel spice;
    private JPanel spice1;
    private JPanel spice2;
    private JPanel spice3;
    private JPanel spice5;
    private JPanel spice6;
    private JButton spiceBrowseHeaderFile;
    private JButton spiceBrowseTrailerFile;
    private JScrollPane spiceCell;
    private JRadioButton spiceDeriveModelFromCircuit;
    private JComboBox spiceEnginePopup;
    private JCheckBox spiceForceGlobalPwrGnd;
    private ButtonGroup spiceHeader;
    private JTextField spiceHeaderCardExtension;
    private JTextField spiceHeaderCardFile;
    private JRadioButton spiceHeaderCardsFromFile;
    private JRadioButton spiceHeaderCardsWithExtension;
    private JComboBox spiceLevelPopup;
    private ButtonGroup spiceModel;
    private JTextField spiceModelCell;
    private JButton spiceModelFileBrowse;
    private JComboBox spiceModelLibrary;
    private JRadioButton spiceNoHeaderCards;
    private JRadioButton spiceNoTrailerCards;
    private JComboBox spiceOutputFormatPopup;
    private JComboBox spicePrimitivesetPopup;
    private JButton spiceRunHelp;
    private JComboBox spiceRunPopup;
    private JCheckBox spiceRunProbe;
    private JTextField spiceRunProgram;
    private JTextField spiceRunProgramArgs;
    private ButtonGroup spiceTrailer;
    private JTextField spiceTrailerCardExtension;
    private JTextField spiceTrailerCardFile;
    private JRadioButton spiceTrailerCardsFromFile;
    private JRadioButton spiceTrailerCardsWithExtension;
    private JCheckBox spiceUseCellParameters;
    private JRadioButton spiceUseModelFromFile;
    private JCheckBox spiceUseNodeNames;
    private JCheckBox spiceUseParasitics;
    private JCheckBox spiceWriteSubcktTopCell;
    private JCheckBox spiceWriteTransSizesInLambda;
    private JTextField useDir;
    private JCheckBox useDirCheckBox;
    static /* synthetic */ Class class$java$lang$String;

    public SpiceTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.spice;
    }

    public String getName() {
        return "Spice";
    }

    public void init() {
        Variable var;
        Cell cell;
        Iterator cIt;
        Library lib;
        this.spiceEnginePopup.addItem("Spice 2");
        this.spiceEnginePopup.addItem("Spice 3");
        this.spiceEnginePopup.addItem("HSpice");
        this.spiceEnginePopup.addItem("PSpice");
        this.spiceEnginePopup.addItem("Gnucap");
        this.spiceEnginePopup.addItem("SmartSpice");
        this.spiceEnginePopup.setSelectedIndex(Simulation.getSpiceEngine());
        this.spiceLevelPopup.addItem("1");
        this.spiceLevelPopup.addItem("2");
        this.spiceLevelPopup.addItem("3");
        this.spiceLevelPopup.setSelectedItem(Simulation.getSpiceLevel());
        this.spiceOutputFormatPopup.addItem("Standard");
        this.spiceOutputFormatPopup.addItem("Raw");
        this.spiceOutputFormatPopup.addItem("Raw/Smart");
        this.spiceOutputFormatPopup.addItem("Epic");
        this.spiceOutputFormatPopup.setSelectedItem(Simulation.getSpiceOutputFormat());
        this.spiceUseParasitics.setSelected(Simulation.isSpiceUseParasitics());
        this.spiceUseNodeNames.setSelected(Simulation.isSpiceUseNodeNames());
        this.spiceForceGlobalPwrGnd.setSelected(Simulation.isSpiceForceGlobalPwrGnd());
        this.spiceUseCellParameters.setSelected(Simulation.isSpiceUseCellParameters());
        this.spiceWriteTransSizesInLambda.setSelected(Simulation.isSpiceWriteTransSizeInLambda());
        this.spiceWriteSubcktTopCell.setSelected(Simulation.isSpiceWriteSubcktTopCell());
        this.useDir.setText(Simulation.getSpiceRunDir());
        this.useDirCheckBox.setSelected(Simulation.getSpiceUseRunDir());
        this.overwriteOutputFile.setSelected(Simulation.getSpiceOutputOverwrite());
        this.spiceRunProbe.setSelected(Simulation.getSpiceRunProbe());
        this.spiceRunProgram.setText(Simulation.getSpiceRunProgram());
        this.spiceRunProgramArgs.setText(Simulation.getSpiceRunProgramArgs());
        String[] libFiles = LibFile.getSpicePartsLibraries();
        for (int i = 0; i < libFiles.length; ++i) {
            this.spicePrimitivesetPopup.addItem(libFiles[i]);
        }
        this.spicePrimitivesetPopup.setSelectedItem(Simulation.getSpicePartsLibrary());
        String[] runChoices = Simulation.getSpiceRunChoiceValues();
        for (int i = 0; i < runChoices.length; ++i) {
            this.spiceRunPopup.addItem(runChoices[i]);
        }
        this.spiceRunPopup.setSelectedItem(Simulation.getSpiceRunChoice());
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
        String spiceHeaderCardInitial = Simulation.getSpiceHeaderCardInfo();
        if (spiceHeaderCardInitial.length() == 0) {
            this.spiceNoHeaderCards.setSelected(true);
        } else if (spiceHeaderCardInitial.startsWith("Extension ")) {
            this.spiceHeaderCardsWithExtension.setSelected(true);
            this.spiceHeaderCardExtension.setText(spiceHeaderCardInitial.substring("Extension ".length()));
        } else {
            this.spiceHeaderCardsFromFile.setSelected(true);
            this.spiceHeaderCardFile.setText(spiceHeaderCardInitial);
        }
        String spiceTrailerCardInitial = Simulation.getSpiceTrailerCardInfo();
        if (spiceTrailerCardInitial.length() == 0) {
            this.spiceNoTrailerCards.setSelected(true);
        } else if (spiceTrailerCardInitial.startsWith("Extension ")) {
            this.spiceTrailerCardsWithExtension.setSelected(true);
            this.spiceTrailerCardExtension.setText(spiceTrailerCardInitial.substring("Extension ".length()));
        } else {
            this.spiceTrailerCardsFromFile.setSelected(true);
            this.spiceTrailerCardFile.setText(spiceTrailerCardInitial);
        }
        this.spiceBrowseHeaderFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseHeaderFileActionPerformed();
            }
        });
        this.spiceBrowseTrailerFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseTrailerFileActionPerformed();
            }
        });
        this.initialSpiceModelFiles = new HashMap();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            lib = (Library)lIt.next();
            if (lib.isHidden()) continue;
            cIt = lib.getCells();
            while (cIt.hasNext()) {
                cell = (Cell)cIt.next();
                String behaveFile = "";
                var = cell.getVar(Spice.SPICE_MODEL_FILE_KEY);
                if (var != null) {
                    behaveFile = var.getObject().toString();
                }
                this.initialSpiceModelFiles.put(cell, Pref.makeStringPref(null, null, behaveFile));
            }
        }
        this.spiceCellModelOptions = new HashMap();
        Iterator it = Library.getVisibleLibraries().iterator();
        while (it.hasNext()) {
            lib = (Library)it.next();
            this.spiceModelLibrary.addItem(lib.getName());
            cIt = lib.getCells();
            while (cIt.hasNext()) {
                cell = (Cell)cIt.next();
                String modelFile = "";
                var = cell.getVar(Spice.SPICE_MODEL_FILE_KEY, class$java$lang$String == null ? SpiceTab.class$("java.lang.String") : class$java$lang$String);
                if (var != null) {
                    modelFile = (String)var.getObject();
                }
                this.spiceCellModelOptions.put(cell, Pref.makeStringPref(null, null, modelFile));
            }
        }
        this.spiceModelLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceLoadCellList();
            }
        });
        this.spiceCellListModel = new DefaultListModel();
        this.spiceCellList = new JList(this.spiceCellListModel);
        this.spiceCellList.setSelectionMode(0);
        this.spiceCell.setViewportView(this.spiceCellList);
        this.spiceCellList.setSelectedIndex(0);
        this.spiceCellList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SpiceTab.this.spiceCellListClick();
            }
        });
        this.spiceModelFileBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceModelFileBrowseActionPerformed();
            }
        });
        this.spiceDeriveModelFromCircuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceCellModelButtonClick();
            }
        });
        this.spiceUseModelFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceCellModelButtonClick();
            }
        });
        this.spiceModelCell.getDocument().addDocumentListener(new SpiceModelDocumentListener(this));
        this.spiceLoadCellList();
    }

    private void spiceLoadCellList() {
        String libName = (String)this.spiceModelLibrary.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        this.spiceCellListModel.clear();
        boolean notEmpty = false;
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            this.spiceCellListModel.addElement(cell.noLibDescribe());
            notEmpty = true;
        }
        if (notEmpty) {
            this.spiceCellList.setSelectedIndex(0);
            this.spiceCellListClick();
        }
    }

    private void spiceCellModelButtonClick() {
        this.spiceModelCell.setEditable(this.spiceUseModelFromFile.isSelected());
        this.spiceModelFileChanged();
    }

    private void spiceCellListClick() {
        if (this.spiceCellListModel.size() == 0) {
            return;
        }
        String libName = (String)this.spiceModelLibrary.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        String cellName = (String)this.spiceCellList.getSelectedValue();
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            return;
        }
        Pref pref = (Pref)this.spiceCellModelOptions.get(cell);
        String modelFile = pref.getString();
        this.spiceModelFileChanging = true;
        boolean hasModelFile = false;
        if (modelFile.length() > 0 && !modelFile.startsWith("-----")) {
            hasModelFile = true;
            this.spiceModelCell.setText(modelFile);
        }
        if (modelFile.startsWith("-----")) {
            this.spiceModelCell.setText(modelFile.substring(5));
        }
        if (hasModelFile) {
            this.spiceUseModelFromFile.setSelected(true);
        } else {
            this.spiceDeriveModelFromCircuit.setSelected(true);
        }
        this.spiceModelCell.setEditable(hasModelFile);
        this.spiceModelFileChanging = false;
    }

    private void spiceModelFileBrowseActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceUseModelFromFile.setSelected(true);
        this.spiceModelCell.setText(fileName);
        this.spiceModelCell.setEditable(true);
        this.spiceModelFileChanged();
    }

    private void spiceModelFileChanged() {
        if (this.spiceModelFileChanging) {
            return;
        }
        String libName = (String)this.spiceModelLibrary.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        String cellName = (String)this.spiceCellList.getSelectedValue();
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            return;
        }
        Pref pref = (Pref)this.spiceCellModelOptions.get(cell);
        String typedString = this.spiceModelCell.getText();
        if (this.spiceDeriveModelFromCircuit.isSelected()) {
            typedString = "-----" + typedString;
        }
        pref.setString(typedString);
    }

    private void spiceBrowseTrailerFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceTrailerCardFile.setText(fileName);
        this.spiceTrailerCardsFromFile.setSelected(true);
    }

    private void spiceBrowseHeaderFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceHeaderCardFile.setText(fileName);
        this.spiceHeaderCardsFromFile.setSelected(true);
    }

    public void term() {
        int intNow = this.spiceEnginePopup.getSelectedIndex();
        if (Simulation.getSpiceEngine() != intNow) {
            Simulation.setSpiceEngine(intNow);
        }
        String stringNow = (String)this.spiceLevelPopup.getSelectedItem();
        if (!Simulation.getSpiceLevel().equals(stringNow)) {
            Simulation.setSpiceLevel(stringNow);
        }
        stringNow = (String)this.spiceOutputFormatPopup.getSelectedItem();
        if (!Simulation.getSpiceOutputFormat().equals(stringNow)) {
            Simulation.setSpiceOutputFormat(stringNow);
        }
        stringNow = (String)this.spicePrimitivesetPopup.getSelectedItem();
        if (!Simulation.getSpicePartsLibrary().equals(stringNow)) {
            Simulation.setSpicePartsLibrary(stringNow);
        }
        boolean booleanNow = this.spiceUseNodeNames.isSelected();
        if (Simulation.isSpiceUseNodeNames() != booleanNow) {
            Simulation.setSpiceUseNodeNames(booleanNow);
        }
        booleanNow = this.spiceForceGlobalPwrGnd.isSelected();
        if (Simulation.isSpiceForceGlobalPwrGnd() != booleanNow) {
            Simulation.setSpiceForceGlobalPwrGnd(booleanNow);
        }
        booleanNow = this.spiceUseCellParameters.isSelected();
        if (Simulation.isSpiceUseCellParameters() != booleanNow) {
            Simulation.setSpiceUseCellParameters(booleanNow);
        }
        booleanNow = this.spiceWriteTransSizesInLambda.isSelected();
        if (Simulation.isSpiceWriteTransSizeInLambda() != booleanNow) {
            Simulation.setSpiceWriteTransSizeInLambda(booleanNow);
        }
        booleanNow = this.spiceWriteSubcktTopCell.isSelected();
        if (Simulation.isSpiceWriteSubcktTopCell() != booleanNow) {
            Simulation.setSpiceWriteSubcktTopCell(booleanNow);
        }
        booleanNow = this.spiceUseParasitics.isSelected();
        if (Simulation.isSpiceUseParasitics() != booleanNow) {
            Simulation.setSpiceUseParasitics(booleanNow);
        }
        stringNow = (String)this.spiceRunPopup.getSelectedItem();
        if (!Simulation.getSpiceRunChoice().equals(stringNow)) {
            Simulation.setSpiceRunChoice(stringNow);
        }
        stringNow = this.useDir.getText();
        if (!Simulation.getSpiceRunDir().equals(stringNow)) {
            Simulation.setSpiceRunDir(stringNow);
        }
        booleanNow = this.useDirCheckBox.isSelected();
        if (Simulation.getSpiceUseRunDir() != booleanNow) {
            Simulation.setSpiceUseRunDir(booleanNow);
        }
        booleanNow = this.overwriteOutputFile.isSelected();
        if (Simulation.getSpiceOutputOverwrite() != booleanNow) {
            Simulation.setSpiceOutputOverwrite(booleanNow);
        }
        booleanNow = this.spiceRunProbe.isSelected();
        if (Simulation.getSpiceRunProbe() != booleanNow) {
            Simulation.setSpiceRunProbe(booleanNow);
        }
        stringNow = this.spiceRunProgram.getText();
        if (!Simulation.getSpiceRunProgram().equals(stringNow)) {
            Simulation.setSpiceRunProgram(stringNow);
        }
        stringNow = this.spiceRunProgramArgs.getText();
        if (!Simulation.getSpiceRunProgramArgs().equals(stringNow)) {
            Simulation.setSpiceRunProgramArgs(stringNow);
        }
        String header = "";
        if (this.spiceHeaderCardsWithExtension.isSelected()) {
            header = "Extension " + this.spiceHeaderCardExtension.getText();
        } else if (this.spiceHeaderCardsFromFile.isSelected()) {
            header = this.spiceHeaderCardFile.getText();
        }
        if (!Simulation.getSpiceHeaderCardInfo().equals(header)) {
            Simulation.setSpiceHeaderCardInfo(header);
        }
        String trailer = "";
        if (this.spiceTrailerCardsWithExtension.isSelected()) {
            trailer = "Extension " + this.spiceTrailerCardExtension.getText();
        } else if (this.spiceTrailerCardsFromFile.isSelected()) {
            trailer = this.spiceTrailerCardFile.getText();
        }
        if (!Simulation.getSpiceTrailerCardInfo().equals(trailer)) {
            Simulation.setSpiceTrailerCardInfo(trailer);
        }
        Iterator lIt = Library.getVisibleLibraries().iterator();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            Iterator it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                Pref pref = (Pref)this.spiceCellModelOptions.get(cell);
                if (pref == null || pref.getStringFactoryValue().equals(pref.getString())) continue;
                String fileName = pref.getString().trim();
                if (fileName.length() == 0) {
                    cell.delVar(Spice.SPICE_MODEL_FILE_KEY);
                    continue;
                }
                cell.newVar(Spice.SPICE_MODEL_FILE_KEY, (Object)fileName);
            }
        }
    }

    private void setSpiceRunOptionsEnabled(boolean enabled) {
        this.useDirCheckBox.setEnabled(enabled);
        this.overwriteOutputFile.setEnabled(enabled);
        this.spiceRunProgram.setEnabled(enabled);
        this.spiceRunProgramArgs.setEnabled(enabled);
        this.spiceRunHelp.setEnabled(enabled);
        this.spiceRunProbe.setEnabled(enabled);
        if (enabled) {
            this.spiceRunProgram.setBackground(Color.white);
            if (!this.useDirCheckBox.isSelected()) {
                this.useDir.setEnabled(false);
                this.useDir.setBackground(this.spice2.getBackground());
            } else {
                this.useDir.setEnabled(true);
                this.useDir.setBackground(Color.white);
            }
        } else {
            this.spiceRunProgram.setBackground(this.spice2.getBackground());
            this.useDir.setBackground(this.spice2.getBackground());
            this.useDir.setEnabled(false);
        }
    }

    private void initComponents() {
        this.spiceHeader = new ButtonGroup();
        this.spiceTrailer = new ButtonGroup();
        this.spiceModel = new ButtonGroup();
        this.spice = new JPanel();
        this.spice1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.spiceRunPopup = new JComboBox();
        this.spiceEnginePopup = new JComboBox();
        this.spiceLevelPopup = new JComboBox();
        this.spiceOutputFormatPopup = new JComboBox();
        this.spiceUseParasitics = new JCheckBox();
        this.spiceUseNodeNames = new JCheckBox();
        this.spiceForceGlobalPwrGnd = new JCheckBox();
        this.spiceUseCellParameters = new JCheckBox();
        this.spiceWriteTransSizesInLambda = new JCheckBox();
        this.spiceWriteSubcktTopCell = new JCheckBox();
        this.spice2 = new JPanel();
        this.spiceRunProgram = new JTextField();
        this.jLabel17 = new JLabel();
        this.useDirCheckBox = new JCheckBox();
        this.useDir = new JTextField();
        this.overwriteOutputFile = new JCheckBox();
        this.spiceRunHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.spiceRunProgramArgs = new JTextField();
        this.spiceRunProbe = new JCheckBox();
        this.spice3 = new JPanel();
        this.jLabel13 = new JLabel();
        this.spicePrimitivesetPopup = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.spice5 = new JPanel();
        this.spiceHeaderCardExtension = new JTextField();
        this.spiceNoHeaderCards = new JRadioButton();
        this.spiceHeaderCardsWithExtension = new JRadioButton();
        this.spiceHeaderCardsFromFile = new JRadioButton();
        this.spiceNoTrailerCards = new JRadioButton();
        this.spiceTrailerCardsWithExtension = new JRadioButton();
        this.spiceTrailerCardsFromFile = new JRadioButton();
        this.spiceHeaderCardFile = new JTextField();
        this.spiceBrowseHeaderFile = new JButton();
        this.spiceTrailerCardExtension = new JTextField();
        this.spiceTrailerCardFile = new JTextField();
        this.spiceBrowseTrailerFile = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.spice6 = new JPanel();
        this.spiceCell = new JScrollPane();
        this.jLabel8 = new JLabel();
        this.spiceDeriveModelFromCircuit = new JRadioButton();
        this.spiceUseModelFromFile = new JRadioButton();
        this.spiceModelFileBrowse = new JButton();
        this.spiceModelCell = new JTextField();
        this.spiceModelLibrary = new JComboBox();
        this.jLabel2 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Spice Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SpiceTab.this.closeDialog(evt);
            }
        });
        this.spice.setLayout(new GridBagLayout());
        this.spice.setToolTipText("Options for Spice deck generation");
        this.spice1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Spice Engine:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        this.spice1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel9.setText("Spice Level:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Output format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.jLabel10, gridBagConstraints);
        this.spiceRunPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunPopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.spice1.add((Component)this.spiceRunPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceEnginePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceLevelPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceOutputFormatPopup, gridBagConstraints);
        this.spiceUseParasitics.setText("Use Parasitics");
        this.spiceUseParasitics.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpiceTab.this.spiceUseParasiticsStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseParasitics, gridBagConstraints);
        this.spiceUseNodeNames.setText("Use Node Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseNodeNames, gridBagConstraints);
        this.spiceForceGlobalPwrGnd.setText("Force Global VDD/GND");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceForceGlobalPwrGnd, gridBagConstraints);
        this.spiceUseCellParameters.setText("Use Cell Parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseCellParameters, gridBagConstraints);
        this.spiceWriteTransSizesInLambda.setText("Write Trans Sizes in Units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceWriteTransSizesInLambda, gridBagConstraints);
        this.spiceWriteSubcktTopCell.setText("Write Subckt For Top Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.spice1.add((Component)this.spiceWriteSubcktTopCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice1, gridBagConstraints);
        this.spice2.setLayout(new GridBagLayout());
        this.spice2.setBorder(new EtchedBorder());
        this.spiceRunProgram.setColumns(8);
        this.spiceRunProgram.setMinimumSize(new Dimension(100, 20));
        this.spiceRunProgram.setPreferredSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunProgram, gridBagConstraints);
        this.jLabel17.setText("Run Program:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice2.add((Component)this.jLabel17, gridBagConstraints);
        this.useDirCheckBox.setText("Use Dir:");
        this.useDirCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.useDirCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.spice2.add((Component)this.useDirCheckBox, gridBagConstraints);
        this.useDir.setColumns(8);
        this.useDir.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice2.add((Component)this.useDir, gridBagConstraints);
        this.overwriteOutputFile.setText("Overwrite existing output file (no prompts)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.spice2.add((Component)this.overwriteOutputFile, gridBagConstraints);
        this.spiceRunHelp.setText("help");
        this.spiceRunHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunHelpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunHelp, gridBagConstraints);
        this.jLabel3.setText("with args:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunProgramArgs, gridBagConstraints);
        this.spiceRunProbe.setText("Run probe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.spice2.add((Component)this.spiceRunProbe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice2, gridBagConstraints);
        this.spice3.setLayout(new GridBagLayout());
        this.jLabel13.setText("Spice primitive set:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        this.spice3.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice3.add((Component)this.spicePrimitivesetPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.spice.add((Component)this.jSeparator1, gridBagConstraints);
        this.spice5.setLayout(new GridBagLayout());
        this.spiceHeaderCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceHeaderCardExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceNoHeaderCards);
        this.spiceNoHeaderCards.setText("No Header Cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceNoHeaderCards, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsWithExtension);
        this.spiceHeaderCardsWithExtension.setText("Use Header Cards with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceHeaderCardsWithExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsFromFile);
        this.spiceHeaderCardsFromFile.setText("Use Header Cards from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceHeaderCardsFromFile, gridBagConstraints);
        this.spiceTrailer.add(this.spiceNoTrailerCards);
        this.spiceNoTrailerCards.setText("No Trailer Cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceNoTrailerCards, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsWithExtension);
        this.spiceTrailerCardsWithExtension.setText("Use Trailer Cards with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceTrailerCardsWithExtension, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsFromFile);
        this.spiceTrailerCardsFromFile.setText("Use Trailer Cards from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceTrailerCardsFromFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceHeaderCardFile, gridBagConstraints);
        this.spiceBrowseHeaderFile.setText("Browse");
        this.spiceBrowseHeaderFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseHeaderFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice5.add((Component)this.spiceBrowseHeaderFile, gridBagConstraints);
        this.spiceTrailerCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceTrailerCardExtension, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceTrailerCardFile, gridBagConstraints);
        this.spiceBrowseTrailerFile.setText("Browse");
        this.spiceBrowseTrailerFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseTrailerFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice5.add((Component)this.spiceBrowseTrailerFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.spice5.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.spice.add((Component)this.jSeparator3, gridBagConstraints);
        this.spice6.setLayout(new GridBagLayout());
        this.spiceCell.setMinimumSize(new Dimension(150, 100));
        this.spiceCell.setPreferredSize(new Dimension(150, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.spice6.add((Component)this.spiceCell, gridBagConstraints);
        this.jLabel8.setText("Cell:");
        this.jLabel8.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.spice6.add((Component)this.jLabel8, gridBagConstraints);
        this.spiceModel.add(this.spiceDeriveModelFromCircuit);
        this.spiceDeriveModelFromCircuit.setText("Derive Cell Model from Circuitry");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.spice6.add((Component)this.spiceDeriveModelFromCircuit, gridBagConstraints);
        this.spiceModel.add(this.spiceUseModelFromFile);
        this.spiceUseModelFromFile.setText("Use Cell Model from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice6.add((Component)this.spiceUseModelFromFile, gridBagConstraints);
        this.spiceModelFileBrowse.setText("Browse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice6.add((Component)this.spiceModelFileBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.spice6.add((Component)this.spiceModelCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.spice6.add((Component)this.spiceModelLibrary, gridBagConstraints);
        this.jLabel2.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.spice6.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.spice.add((Component)this.spice6, gridBagConstraints);
        this.getContentPane().add((Component)this.spice, new GridBagConstraints());
        this.pack();
    }

    private void spiceUseParasiticsStateChanged(ChangeEvent evt) {
    }

    private void spiceRunPopupActionPerformed(ActionEvent evt) {
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
    }

    private void spiceRunHelpActionPerformed(ActionEvent evt) {
        String[] message = new String[]{"IMPORTANT: This executes a single program with the given args.  It does NOT run a command-line command.", "For example, 'echo blah > file' will NOT work. Encapsulate it in a script if you want to do such things.", "-----------------", "The following variables are available to use in the program name and arguments:", "   ${WORKING_DIR}:  The current working directory", "   ${USE_DIR}:  The Use Dir field, if specified (otherwise defaults to WORKING_DIR)", "   ${FILENAME}:  The output file name (with extension)", "   ${FILENAME_NO_EXT}:  The output file name (without extension)", "Example: Program: \"hspice\".  Args: \"${FILENAME}\""};
        JOptionPane.showMessageDialog(this, message, "Spice Run Help", 1);
    }

    private void useDirCheckBoxActionPerformed(ActionEvent evt) {
        boolean b = this.useDirCheckBox.isSelected();
        this.useDir.setEnabled(b);
        if (b) {
            this.useDir.setBackground(Color.white);
        } else {
            this.useDir.setBackground(this.spice2.getBackground());
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SpiceModelDocumentListener
    implements DocumentListener {
        SpiceTab dialog;

        SpiceModelDocumentListener(SpiceTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.spiceModelFileChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.spiceModelFileChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.spiceModelFileChanged();
        }
    }
}

