/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PixelDrawing {
    public static final int MINIMUMTEXTSIZE = 5;
    public static final int SINGLETONSTOADD = 5;
    private static final boolean TAKE_STATS = false;
    private static int tinyCells;
    private static int tinyPrims;
    private static int totalCells;
    private static int renderedCells;
    private static int totalPrims;
    private static int tinyArcs;
    private static int linedArcs;
    private static int totalArcs;
    private static int offscreensCreated;
    private static int offscreenPixelsCreated;
    private static int offscreensUsed;
    private static int offscreenPixelsUsed;
    private static int cellsRendered;
    private static int boxes;
    private static int crosses;
    private static int solidLines;
    private static int patLines;
    private static int thickLines;
    private static int polygons;
    private static int texts;
    private static int circles;
    private static int thickCircles;
    private static int discs;
    private static int circleArcs;
    private static int points;
    private static int thickPoints;
    private static final boolean DEBUGRENDERTIMING = false;
    private static long renderTextTime;
    private static long renderPolyTime;
    private EditWindow wnd;
    private Dimension sz;
    private double scale;
    private double originX;
    private double originY;
    private Rectangle2D drawBounds;
    boolean highlightingLayers;
    private boolean lastFullInstantiate = false;
    private boolean canDrawText;
    private static double maxObjectSize;
    private static double halfMaxObjectSize;
    private Point tempPt1 = new Point();
    private Point tempPt2 = new Point();
    private Point tempPt3 = new Point();
    private Point tempPt4 = new Point();
    private BufferedImage img;
    private int[] opaqueData;
    private int total;
    private int backgroundColor;
    private int backgroundValue;
    private byte[][][] layerBitMaps;
    private byte[][] compositeRows;
    int numLayerBitMaps;
    private int numBytesPerRow;
    private int numLayerBitMapsCreated;
    private Technology curTech;
    private HashMap patternedOpaqueLayers;
    private boolean renderedWindow;
    private boolean periodicRefresh;
    private int objectCount;
    private long lastRefreshTime;
    private static Dimension topSz;
    private static Technology techWithLayers;
    private static HashMap expandedCells;
    private static double expandedScale;
    private static int numberToReconcile;
    private static MutableTextDescriptor noCellTextDescriptor;
    private static final Rectangle2D CENTERRECT;
    private static EGraphics textGraphics;
    private static EGraphics gridGraphics;
    private static EGraphics instanceGraphics;
    private static EGraphics portGraphics;
    private int clipLX;
    private int clipHX;
    private int clipLY;
    private int clipHY;
    private int width;
    private double[] hsvTempArray = new double[3];
    private boolean[] arcOctTable = new boolean[9];
    private Point arcCenter;
    private int arcRadius;
    private int arcCol;
    private byte[][] arcLayerBitMap;
    private boolean arcThick;

    public PixelDrawing(EditWindow wnd) {
        this.wnd = wnd;
        this.sz = wnd.getScreenSize();
        this.initOrigin();
        this.img = new BufferedImage(this.sz.width, this.sz.height, 1);
        WritableRaster raster = this.img.getRaster();
        DataBufferInt dbi = (DataBufferInt)raster.getDataBuffer();
        this.opaqueData = dbi.getData();
        this.total = this.sz.height * this.sz.width;
        this.numBytesPerRow = (this.sz.width + 7) / 8;
        this.patternedOpaqueLayers = new HashMap();
        this.renderedWindow = true;
        this.curTech = null;
        this.initForTechnology();
        this.clearImage(false, null);
    }

    public PixelDrawing(EditWindow wnd, Rectangle screenBounds) {
        this.wnd = wnd;
        this.scale = wnd.getScale();
        this.originX = -screenBounds.x;
        this.originY = screenBounds.y + screenBounds.height;
        this.sz = new Dimension(screenBounds.width, screenBounds.height);
        this.total = this.sz.height * this.sz.width;
        this.opaqueData = new int[this.total];
        this.numBytesPerRow = (this.sz.width + 7) / 8;
        this.patternedOpaqueLayers = new HashMap();
        this.curTech = null;
        this.initForTechnology();
        this.clearImage(false, null);
    }

    void initOrigin() {
        this.scale = this.wnd.getScale();
        Point2D offset = this.wnd.getOffset();
        this.originX = (double)(this.sz.width / 2) - offset.getX() * this.scale;
        this.originY = (double)(this.sz.height / 2) + offset.getY() * this.scale;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg.getRGB() & 0xFFFFFF;
    }

    protected BufferedImage getBufferedImage() {
        return this.img;
    }

    public Dimension getSize() {
        return this.sz;
    }

    public static void clearSubCellCache() {
        expandedCells = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(boolean fullInstantiate, Rectangle2D drawLimitBounds) {
        long startTime = 0L;
        long initialFree = 0L;
        if (fullInstantiate != this.lastFullInstantiate) {
            PixelDrawing.clearSubCellCache();
            this.lastFullInstantiate = fullInstantiate;
        }
        Cell cell = this.wnd.getCell();
        if (this.wnd.isInPlaceEdit()) {
            cell = this.wnd.getInPlaceEditTopCell();
        }
        this.drawBounds = this.wnd.getDisplayedBounds();
        textGraphics.setColor(new Color(User.getColorText()));
        gridGraphics.setColor(new Color(User.getColorGrid()));
        instanceGraphics.setColor(new Color(User.getColorInstanceOutline()));
        if (expandedScale != this.wnd.getScale()) {
            PixelDrawing.clearSubCellCache();
            expandedScale = this.wnd.getScale();
        }
        this.initOrigin();
        this.canDrawText = expandedScale > 1.0;
        maxObjectSize = 2.0 / expandedScale;
        halfMaxObjectSize = maxObjectSize / 2.0;
        topSz = this.sz;
        this.highlightingLayers = false;
        Iterator it = Technology.getCurrent().getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (!layer.isDimmed()) continue;
            this.highlightingLayers = true;
            break;
        }
        Rectangle renderBounds = null;
        if (drawLimitBounds != null) {
            renderBounds = this.wnd.databaseToScreen(drawLimitBounds);
        }
        this.clearImage(true, renderBounds);
        if (cell == null) {
            if (noCellTextDescriptor == null) {
                noCellTextDescriptor = new MutableTextDescriptor();
                noCellTextDescriptor.setAbsSize(18);
                noCellTextDescriptor.setBold(true);
            }
            Rectangle rect = new Rectangle(this.sz);
            this.drawText(rect, Poly.Type.TEXTBOX, noCellTextDescriptor, "No cell in this window", null, textGraphics, false);
        } else {
            this.wnd.vd.render(cell, fullInstantiate, drawLimitBounds, this.wnd.getVarContext());
        }
        BufferedImage bufferedImage = this.img;
        synchronized (bufferedImage) {
            if (cell != null && this.wnd.isGrid()) {
                this.drawGrid();
            }
            this.composite(renderBounds);
        }
    }

    public void clearImage(boolean periodicRefresh, Rectangle bounds) {
        this.initForTechnology();
        this.backgroundColor = User.getColorBackground() & 0xFFFFFF;
        this.backgroundValue = this.backgroundColor | 0xFF000000;
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            byte[][] layerBitMap = this.layerBitMaps[i];
            if (layerBitMap == null) continue;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        Iterator it = this.patternedOpaqueLayers.entrySet().iterator();
        while (it.hasNext()) {
            PatternedOpaqueLayer pol = (PatternedOpaqueLayer)((Object)it.next());
            byte[][] layerBitMap = pol.bitMap;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        if (bounds == null) {
            for (int i = 0; i < this.total; ++i) {
                this.opaqueData[i] = this.backgroundValue;
            }
        } else {
            int lx = bounds.x;
            int hx = lx + bounds.width;
            int ly = bounds.y;
            int hy = ly + bounds.height;
            if (lx < 0) {
                lx = 0;
            }
            if (hx >= this.sz.width) {
                hx = this.sz.width - 1;
            }
            if (ly < 0) {
                ly = 0;
            }
            if (hy >= this.sz.height) {
                hy = this.sz.height - 1;
            }
            for (int y = ly; y <= hy; ++y) {
                int baseIndex = y * this.sz.width;
                for (int x = lx; x <= hx; ++x) {
                    this.opaqueData[baseIndex + x] = this.backgroundValue;
                }
            }
        }
        this.periodicRefresh = periodicRefresh;
        if (periodicRefresh) {
            this.objectCount = 0;
            this.lastRefreshTime = System.currentTimeMillis();
        }
    }

    public Image composite(Rectangle bounds) {
        if (this.numLayerBitMapsCreated > 0) {
            Color[] colorMap = this.curTech.getColorMap();
            boolean dimmedTransparentLayers = false;
            Iterator it = this.curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                if (!layer.isDimmed() || layer.getGraphics().getTransparentLayer() == 0) continue;
                dimmedTransparentLayers = true;
                break;
            }
            if (dimmedTransparentLayers) {
                Color[] newColorMap = new Color[colorMap.length];
                int numTransparents = this.curTech.getNumTransparentLayers();
                boolean[] dimLayer = new boolean[numTransparents];
                for (int i = 0; i < numTransparents; ++i) {
                    dimLayer[i] = true;
                }
                Iterator it2 = this.curTech.getLayers();
                while (it2.hasNext()) {
                    int tIndex;
                    Layer layer = (Layer)it2.next();
                    if (layer.isDimmed() || (tIndex = layer.getGraphics().getTransparentLayer()) == 0) continue;
                    dimLayer[tIndex - 1] = false;
                }
                for (int i = 0; i < colorMap.length; ++i) {
                    newColorMap[i] = colorMap[i];
                    if (i == 0) continue;
                    boolean dimThisEntry = true;
                    for (int j = 0; j < numTransparents; ++j) {
                        if ((i & 1 << j) == 0 || dimLayer[j]) continue;
                        dimThisEntry = false;
                        break;
                    }
                    newColorMap[i] = dimThisEntry ? new Color(this.dimColor(colorMap[i].getRGB())) : new Color(this.brightenColor(colorMap[i].getRGB()));
                }
                colorMap = newColorMap;
            }
            int lx = 0;
            int hx = this.sz.width - 1;
            int ly = 0;
            int hy = this.sz.height - 1;
            if (bounds != null) {
                lx = bounds.x;
                hx = lx + bounds.width;
                ly = bounds.y;
                hy = ly + bounds.height;
                if (lx < 0) {
                    lx = 0;
                }
                if (hx >= this.sz.width) {
                    hx = this.sz.width - 1;
                }
                if (ly < 0) {
                    ly = 0;
                }
                if (hy >= this.sz.height) {
                    hy = this.sz.height - 1;
                }
            }
            for (int y = ly; y <= hy; ++y) {
                for (int i = 0; i < this.numLayerBitMaps; ++i) {
                    byte[][] layerBitMap = this.layerBitMaps[i];
                    this.compositeRows[i] = (byte[])(layerBitMap == null ? null : layerBitMap[y]);
                }
                int baseIndex = y * this.sz.width;
                for (int x = lx; x <= hx; ++x) {
                    int index = baseIndex + x;
                    int pixelValue = this.opaqueData[index];
                    int alpha = pixelValue >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    int bits = 0;
                    int entry = x >> 3;
                    int maskBit = 1 << (x & 7);
                    for (int i = 0; i < this.numLayerBitMaps; ++i) {
                        byte byt;
                        if (this.compositeRows[i] == null || ((byt = this.compositeRows[i][entry]) & maskBit) == 0) continue;
                        bits |= 1 << i;
                    }
                    int newColor = this.backgroundColor;
                    if (bits != 0) {
                        newColor = colorMap[bits].getRGB() & 0xFFFFFF;
                    }
                    if (alpha != 255) {
                        newColor = this.alphaBlend(pixelValue, newColor, alpha);
                    }
                    this.opaqueData[index] = newColor;
                }
            }
        } else if (bounds == null) {
            for (int i = 0; i < this.total; ++i) {
                int pixelValue = this.opaqueData[i];
                if (pixelValue == this.backgroundValue) {
                    this.opaqueData[i] = this.backgroundColor;
                    continue;
                }
                if ((pixelValue & 0xFF000000) == 0) continue;
                int alpha = pixelValue >> 24 & 0xFF;
                this.opaqueData[i] = this.alphaBlend(pixelValue, this.backgroundColor, alpha);
            }
        } else {
            int lx = bounds.x;
            int hx = lx + bounds.width;
            int ly = bounds.y;
            int hy = ly + bounds.height;
            if (lx < 0) {
                lx = 0;
            }
            if (hx >= this.sz.width) {
                hx = this.sz.width - 1;
            }
            if (ly < 0) {
                ly = 0;
            }
            if (hy >= this.sz.height) {
                hy = this.sz.height - 1;
            }
            for (int y = ly; y <= hy; ++y) {
                int baseIndex = y * this.sz.width;
                for (int x = lx; x <= hx; ++x) {
                    int index = baseIndex + x;
                    int pixelValue = this.opaqueData[index];
                    if (pixelValue == this.backgroundValue) {
                        this.opaqueData[index] = this.backgroundColor;
                        continue;
                    }
                    if ((pixelValue & 0xFF000000) == 0) continue;
                    int alpha = pixelValue >> 24 & 0xFF;
                    this.opaqueData[index] = this.alphaBlend(pixelValue, this.backgroundColor, alpha);
                }
            }
        }
        return this.img;
    }

    private void drawGrid() {
        double spacingX = this.wnd.getGridXSpacing();
        double spacingY = this.wnd.getGridYSpacing();
        if (spacingX == 0.0 || spacingY == 0.0) {
            return;
        }
        double boldSpacingX = spacingX * (double)User.getDefGridXBoldFrequency();
        double boldSpacingY = spacingY * (double)User.getDefGridYBoldFrequency();
        double boldSpacingThreshX = spacingX / 4.0;
        double boldSpacingThreshY = spacingY / 4.0;
        Rectangle2D displayable = this.wnd.displayableBounds();
        double lX = displayable.getMinX();
        double lY = displayable.getMaxY();
        double hX = displayable.getMaxX();
        double hY = displayable.getMinY();
        double scaleX = (double)this.sz.width / (hX - lX);
        double scaleY = (double)this.sz.height / (lY - hY);
        double x1 = DBMath.toNearest(lX, spacingX);
        double y1 = DBMath.toNearest(lY, spacingY);
        boolean allBoldDots = false;
        if (spacingX * scaleX < 5.0 || spacingY * scaleY < 5.0) {
            x1 = DBMath.toNearest(x1, boldSpacingX);
            spacingX = boldSpacingX;
            y1 = DBMath.toNearest(y1, boldSpacingY);
            spacingY = boldSpacingY;
            if (spacingX * scaleX < 10.0 || spacingY * scaleY < 10.0) {
                return;
            }
        } else if (spacingX * scaleX > 75.0 && spacingY * scaleY > 75.0) {
            allBoldDots = true;
        }
        int col = User.getColorGrid() & 0xFFFFFF;
        for (double i = y1; i > hY; i -= spacingY) {
            double boldValueY = i;
            boldValueY = i < 0.0 ? (boldValueY -= boldSpacingThreshY / 2.0) : (boldValueY += boldSpacingThreshY / 2.0);
            boolean everyTenY = Math.abs(boldValueY) % boldSpacingY < boldSpacingThreshY;
            for (double j = x1; j < hX; j += spacingX) {
                boolean everyTenX;
                Point xy = this.wnd.databaseToScreen(j, i);
                int x = xy.x;
                int y = xy.y;
                if (x < 0 || x > this.sz.width || y < 0 || y > this.sz.height) continue;
                double boldValueX = j;
                boldValueX = j < 0.0 ? (boldValueX -= boldSpacingThreshX / 2.0) : (boldValueX += boldSpacingThreshX / 2.0);
                boolean bl = everyTenX = Math.abs(boldValueX) % boldSpacingX < boldSpacingThreshX;
                if (allBoldDots && everyTenX && everyTenY) {
                    int boxHY;
                    int boxLY;
                    int boxHX;
                    int boxLX = x - 2;
                    if (boxLX < 0) {
                        boxLX = 0;
                    }
                    if ((boxHX = x + 2) >= this.sz.width) {
                        boxHX = this.sz.width - 1;
                    }
                    if ((boxLY = y - 2) < 0) {
                        boxLY = 0;
                    }
                    if ((boxHY = y + 2) >= this.sz.height) {
                        boxHY = this.sz.height - 1;
                    }
                    this.drawBox(boxLX, boxHX, boxLY, boxHY, null, gridGraphics, false);
                    if (x > 1) {
                        this.opaqueData[y * this.sz.width + (x - 2)] = col;
                    }
                    if (x < this.sz.width - 2) {
                        this.opaqueData[y * this.sz.width + (x + 2)] = col;
                    }
                    if (y > 1) {
                        this.opaqueData[(y - 2) * this.sz.width + x] = col;
                    }
                    if (y >= this.sz.height - 2) continue;
                    this.opaqueData[(y + 2) * this.sz.width + x] = col;
                    continue;
                }
                if (allBoldDots || everyTenX && everyTenY) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    if (x > 0) {
                        this.opaqueData[y * this.sz.width + (x - 1)] = col;
                    }
                    if (x < this.sz.width - 1) {
                        this.opaqueData[y * this.sz.width + (x + 1)] = col;
                    }
                    if (y > 0) {
                        this.opaqueData[(y - 1) * this.sz.width + x] = col;
                    }
                    if (y >= this.sz.height - 1) continue;
                    this.opaqueData[(y + 1) * this.sz.width + x] = col;
                    continue;
                }
                this.opaqueData[y * this.sz.width + x] = col;
            }
        }
        if (User.isGridAxesShown()) {
            Point xy = this.wnd.databaseToScreen(0.0, 0.0);
            if (xy.x >= 0 && xy.x < this.sz.width) {
                this.drawSolidLine(xy.x, 0, xy.x, this.sz.height - 1, (byte[][])null, col);
            }
            if (xy.y >= 0 && xy.y < this.sz.height) {
                this.drawSolidLine(0, xy.y, this.sz.width - 1, xy.y, (byte[][])null, col);
            }
        }
    }

    private void initForTechnology() {
        Technology tech = Technology.getCurrent();
        if (tech == null) {
            return;
        }
        if (tech == this.curTech) {
            return;
        }
        int transLayers = tech.getNumTransparentLayers();
        if (transLayers != 0) {
            techWithLayers = this.curTech = tech;
        }
        if (this.curTech == null) {
            this.curTech = techWithLayers;
        }
        if (this.curTech == null) {
            return;
        }
        this.numLayerBitMaps = this.curTech.getNumTransparentLayers();
        this.layerBitMaps = new byte[this.numLayerBitMaps][][];
        this.compositeRows = new byte[this.numLayerBitMaps][];
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            this.layerBitMaps[i] = null;
        }
        this.numLayerBitMapsCreated = 0;
    }

    private void drawCell(Cell cell, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform prevTrans, EditWindow topWnd, VarContext context) {
        Rectangle2D.Double bounds;
        Rectangle2D curBounds;
        ++renderedCells;
        renderPolyTime = 0L;
        renderTextTime = 0L;
        Iterator arcs = cell.getArcs();
        while (arcs.hasNext()) {
            ArcInst ai = (ArcInst)arcs.next();
            if (drawLimitBounds != null) {
                curBounds = ai.getBounds();
                bounds = new Rectangle2D.Double(curBounds.getX(), curBounds.getY(), curBounds.getWidth(), curBounds.getHeight());
                GenMath.transformRect(bounds, prevTrans);
                if (!GenMath.rectsIntersect(bounds, drawLimitBounds)) continue;
            }
            this.drawArc(ai, prevTrans, false);
        }
        Iterator nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = (NodeInst)nodes.next();
            if (drawLimitBounds != null) {
                curBounds = ni.getBounds();
                bounds = new Rectangle2D.Double(curBounds.getX(), curBounds.getY(), curBounds.getWidth(), curBounds.getHeight());
                GenMath.transformRect(bounds, prevTrans);
                if (!GenMath.rectsIntersect(bounds, drawLimitBounds)) continue;
            }
            this.drawNode(ni, orient, prevTrans, topWnd, drawLimitBounds, fullInstantiate, false, context);
        }
        boolean topLevel = true;
        if (topWnd != null) {
            boolean bl = topLevel = cell == topWnd.getCell();
        }
        if (this.canDrawText && topLevel && User.isTextVisibilityOnCell()) {
            int numPolys = cell.numDisplayableVariables(true);
            Poly[] polys = new Poly[numPolys];
            cell.addDisplayableVariables(CENTERRECT, polys, 0, this.wnd, true);
            this.drawPolys(polys, prevTrans, false);
        }
    }

    public void drawNode(NodeInst ni, Orientation orient, AffineTransform trans, EditWindow topWnd, Rectangle2D drawLimitBounds, boolean fullInstantiate, boolean forceVisible, VarContext context) {
        NodeProto np = ni.getProto();
        AffineTransform localTrans = ni.rotateOut(trans);
        boolean topLevel = true;
        if (topWnd != null) {
            boolean bl = topLevel = ni.getParent() == topWnd.getCell();
        }
        if (np instanceof Cell) {
            List path;
            ++totalCells;
            Cell subCell = (Cell)np;
            Orientation subOrient = orient.concatenate(ni.getOrient());
            AffineTransform subTrans = ni.translateOut(localTrans);
            Rectangle2D cellBounds = subCell.getBounds();
            Poly poly = new Poly(cellBounds);
            poly.transform(subTrans);
            cellBounds = poly.getBounds2D();
            Rectangle screenBounds = this.databaseToScreen(cellBounds);
            if (screenBounds.width <= 0 || screenBounds.height <= 0) {
                ++tinyCells;
                return;
            }
            if (screenBounds.x >= this.sz.width || screenBounds.x + screenBounds.width <= 0) {
                return;
            }
            if (screenBounds.y >= this.sz.height || screenBounds.y + screenBounds.height <= 0) {
                return;
            }
            boolean expanded = ni.isExpanded();
            if (fullInstantiate) {
                expanded = true;
            }
            if (!expanded && (path = this.wnd.getInPlaceEditNodePath()) != null) {
                for (int pathIndex = 0; pathIndex < path.size(); ++pathIndex) {
                    NodeInst niOnPath = (NodeInst)path.get(pathIndex);
                    if (niOnPath.getProto() != subCell) continue;
                    expanded = true;
                    break;
                }
            }
            if (expanded) {
                if (!this.expandedCellCached(subCell, subOrient, subTrans, topWnd, context, drawLimitBounds, fullInstantiate)) {
                    ++cellsRendered;
                    this.drawCell(subCell, drawLimitBounds, fullInstantiate, subOrient, subTrans, topWnd, context.push(ni));
                }
                if (this.canDrawText) {
                    this.showCellPorts(ni, trans, Color.BLACK);
                }
            } else {
                this.drawUnexpandedCell(ni, poly);
                if (this.canDrawText) {
                    this.showCellPorts(ni, trans, null);
                }
            }
            if (this.canDrawText && User.isTextVisibilityOnNode()) {
                int numPolys = ni.numDisplayableVariables(true);
                Poly[] polys = new Poly[numPolys];
                Rectangle2D rect = ni.getUntransformedBounds();
                ni.addDisplayableVariables(rect, polys, 0, this.wnd, true);
                this.drawPolys(polys, localTrans, false);
            }
        } else if (topLevel || !ni.isVisInside() && np != Generic.tech.cellCenterNode) {
            Point2D ctr = ni.getTrueCenter();
            trans.transform(ctr, ctr);
            double halfWidth = Math.max(ni.getXSize(), ni.getYSize()) / 2.0;
            double ctrX = ctr.getX();
            double ctrY = ctr.getY();
            if (this.renderedWindow) {
                Rectangle2D databaseBounds = this.wnd.getDisplayedBounds();
                if (ctrX + halfWidth < databaseBounds.getMinX()) {
                    return;
                }
                if (ctrX - halfWidth > databaseBounds.getMaxX()) {
                    return;
                }
                if (ctrY + halfWidth < databaseBounds.getMinY()) {
                    return;
                }
                if (ctrY - halfWidth > databaseBounds.getMaxY()) {
                    return;
                }
            }
            PrimitiveNode prim = (PrimitiveNode)np;
            ++totalPrims;
            if (!prim.isCanBeZeroSize() && halfWidth < halfMaxObjectSize && !forceVisible) {
                ++tinyPrims;
                this.databaseToScreen(ctrX, ctrY, this.tempPt1);
                if (this.tempPt1.x >= 0 && this.tempPt1.x < this.sz.width && this.tempPt1.y >= 0 && this.tempPt1.y < this.sz.height) {
                    this.drawTinyLayers(prim.layerIterator(), this.tempPt1.x, this.tempPt1.y);
                }
                return;
            }
            EditWindow nodeWnd = this.wnd;
            if (!this.canDrawText || !User.isTextVisibilityOnNode()) {
                nodeWnd = null;
            }
            if (prim == Generic.tech.invisiblePinNode && !User.isTextVisibilityOnAnnotation()) {
                nodeWnd = null;
            }
            Technology tech = prim.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni, nodeWnd, context, false, false, null);
            this.drawPolys(polys, localTrans, forceVisible);
        }
        if (this.canDrawText && topLevel && User.isTextVisibilityOnExport()) {
            int exportDisplayLevel = User.getExportDisplayLevel();
            Iterator it = ni.getExports();
            while (it.hasNext()) {
                int numPolys;
                Export e = (Export)it.next();
                Poly poly = e.getNamePoly();
                poly.transform(trans);
                Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
                if (exportDisplayLevel == 2) {
                    this.drawCross(poly, textGraphics, false);
                } else {
                    TextDescriptor descript = poly.getTextDescriptor();
                    Poly.Type type = descript.getPos().getPolyType();
                    String portName = e.getName();
                    if (exportDisplayLevel == 1) {
                        portName = e.getShortName();
                    }
                    this.databaseToScreen(poly.getCenterX(), poly.getCenterY(), this.tempPt1);
                    Rectangle textRect = new Rectangle(this.tempPt1);
                    type = Poly.rotateType(type, ni);
                    this.drawText(textRect, type, descript, portName, null, textGraphics, false);
                }
                if ((numPolys = e.numDisplayableVariables(true)) <= 0) continue;
                Poly[] polys = new Poly[numPolys];
                e.addDisplayableVariables(rect, polys, 0, this.wnd, true);
                this.drawPolys(polys, localTrans, false);
            }
        }
    }

    public void drawArc(ArcInst ai, AffineTransform trans, boolean forceVisible) {
        Rectangle2D arcBounds = ai.getBounds();
        double arcSize = Math.max(arcBounds.getWidth(), arcBounds.getHeight());
        ++totalArcs;
        if (!forceVisible) {
            if (arcSize < maxObjectSize) {
                ++tinyArcs;
                return;
            }
            if (ai.getWidth() > 0.0 && (arcSize = Math.min(arcBounds.getWidth(), arcBounds.getHeight())) < maxObjectSize) {
                ++linedArcs;
                Point2D.Double headEnd = new Point2D.Double(ai.getHeadLocation().getX(), ai.getHeadLocation().getY());
                trans.transform(headEnd, headEnd);
                this.databaseToScreen(((Point2D)headEnd).getX(), ((Point2D)headEnd).getY(), this.tempPt1);
                Point2D.Double tailEnd = new Point2D.Double(ai.getTailLocation().getX(), ai.getTailLocation().getY());
                trans.transform(tailEnd, tailEnd);
                this.databaseToScreen(((Point2D)tailEnd).getX(), ((Point2D)tailEnd).getY(), this.tempPt2);
                ArcProto prim = ai.getProto();
                this.drawTinyArc(prim.layerIterator(), this.tempPt1, this.tempPt2);
                return;
            }
        }
        Rectangle2D dbBounds = new Rectangle2D.Double(arcBounds.getX(), arcBounds.getY(), arcBounds.getWidth(), arcBounds.getHeight());
        Poly p = new Poly(dbBounds);
        p.transform(trans);
        dbBounds = p.getBounds2D();
        if (this.drawBounds != null && !GenMath.rectsIntersect(this.drawBounds, dbBounds)) {
            return;
        }
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        EditWindow arcWnd = this.wnd;
        if (!this.canDrawText || !User.isTextVisibilityOnArc()) {
            arcWnd = null;
        }
        Poly[] polys = tech.getShapeOfArc(ai, arcWnd);
        this.drawPolys(polys, trans, forceVisible);
    }

    private void showCellPorts(NodeInst ni, AffineTransform trans, Color col) {
        PortInst pi;
        int numPorts = ni.getProto().getNumPorts();
        boolean[] shownPorts = new boolean[numPorts];
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            pi = con.getPortInst();
            shownPorts[pi.getPortIndex()] = true;
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            shownPorts[pi.getPortIndex()] = true;
        }
        int portDisplayLevel = User.getPortDisplayLevel();
        for (int i = 0; i < numPorts; ++i) {
            Export pp;
            Poly portPoly;
            if (shownPorts[i] || (portPoly = ni.getShapeOfPort(pp = (Export)ni.getProto().getPort(i))) == null) continue;
            portPoly.transform(trans);
            Color portColor = col;
            if (portColor == null) {
                portColor = pp.getBasePort().getPortColor();
            }
            portGraphics.setColor(portColor);
            if (portDisplayLevel == 2) {
                this.drawCross(portPoly, portGraphics, false);
                continue;
            }
            if (!User.isTextVisibilityOnPort()) continue;
            TextDescriptor descript = portPoly.getTextDescriptor();
            MutableTextDescriptor portDescript = pp.getMutableTextDescriptor(Export.EXPORT_NAME_TD);
            portDescript.setColorIndex(descript.getColorIndex());
            Poly.Type type = descript.getPos().getPolyType();
            String portName = pp.getName();
            if (portDisplayLevel == 1) {
                portName = pp.getShortName();
            }
            this.databaseToScreen(portPoly.getCenterX(), portPoly.getCenterY(), this.tempPt1);
            Rectangle rect = new Rectangle(this.tempPt1);
            this.drawText(rect, type, portDescript, portName, null, portGraphics, false);
        }
    }

    private void drawUnexpandedCell(NodeInst ni, Poly poly) {
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                lastI = points.length - 1;
            }
            Point2D lastPt = points[lastI];
            Point2D thisPt = points[i];
            this.databaseToScreen(lastPt.getX(), lastPt.getY(), this.tempPt1);
            this.databaseToScreen(thisPt.getX(), thisPt.getY(), this.tempPt2);
            this.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
        }
        if (this.canDrawText && User.isTextVisibilityOnInstance()) {
            Rectangle2D bounds = poly.getBounds2D();
            Rectangle rect = this.databaseToScreen(bounds);
            ImmutableTextDescriptor descript = ni.getTextDescriptor(NodeInst.NODE_PROTO_TD);
            NodeProto np = ni.getProto();
            this.drawText(rect, Poly.Type.TEXTBOX, descript, np.describe(false), null, textGraphics, false);
        }
    }

    private void drawTinyLayers(Iterator layerIterator, int x, int y) {
        Iterator it = layerIterator;
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (layer == null) continue;
            byte[][] layerBitMap = null;
            int col = 0;
            EGraphics graphics = layer.getGraphics();
            if (graphics != null) {
                int pat;
                int[] pattern;
                if (graphics.isPatternedOnDisplay() && (pattern = graphics.getPattern()) != null && ((pat = pattern[y & 0xF]) == 0 || (pat & 32768 >> (x & 0xF)) == 0)) continue;
                int layerNum = graphics.getTransparentLayer() - 1;
                if (layerNum < this.numLayerBitMaps) {
                    layerBitMap = this.getLayerBitMap(layerNum);
                }
                col = graphics.getColor().getRGB() & 0xFFFFFF;
            }
            if (layerBitMap == null) {
                int index = y * this.sz.width + x;
                int alpha = this.opaqueData[index] >> 24 & 0xFF;
                if (alpha != 255) continue;
                this.opaqueData[index] = col;
                continue;
            }
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private void drawTinyArc(Iterator layerIterator, Point head, Point tail) {
        Iterator it = layerIterator;
        while (it.hasNext()) {
            int layerNum;
            Layer layer = (Layer)it.next();
            if (layer == null) continue;
            EGraphics graphics = layer.getGraphics();
            byte[][] layerBitMap = null;
            if (graphics != null && (layerNum = graphics.getTransparentLayer() - 1) < this.numLayerBitMaps) {
                layerBitMap = this.getLayerBitMap(layerNum);
            }
            this.drawLine(head, tail, layerBitMap, graphics, 0, layer.isDimmed());
        }
    }

    private boolean expandedCellCached(Cell subCell, Orientation orient, AffineTransform origTrans, EditWindow topWnd, VarContext context, Rectangle2D drawLimitBounds, boolean fullInstantiate) {
        if (expandedCells == null) {
            return false;
        }
        if (subCell.isIcon()) {
            return false;
        }
        ExpandedCellKey expansionKey = new ExpandedCellKey(subCell, orient);
        ExpandedCellInfo expandedCellCount = (ExpandedCellInfo)expandedCells.get(expansionKey);
        if (expandedCellCount != null && expandedCellCount.singleton && expandedCellCount.instanceCount < 2 && expandedCellCount.offscreen == null) {
            if (numberToReconcile > 0) {
                --numberToReconcile;
                expandedCellCount.singleton = false;
            } else {
                return false;
            }
        }
        if (expandedCellCount == null || expandedCellCount.offscreen == null) {
            Rectangle2D.Double cellBounds = new Rectangle2D.Double();
            ((Rectangle2D)cellBounds).setRect(subCell.getBounds());
            Rectangle2D textBounds = subCell.getTextBounds(this.wnd);
            if (textBounds != null) {
                cellBounds.add(textBounds);
            }
            AffineTransform rotTrans = orient.pureRotate();
            DBMath.transformRect(cellBounds, rotTrans);
            int lX = (int)Math.floor(cellBounds.getMinX() * this.scale);
            int hX = (int)Math.ceil(cellBounds.getMaxX() * this.scale);
            int lY = (int)Math.floor(cellBounds.getMinY() * this.scale);
            int hY = (int)Math.ceil(cellBounds.getMaxY() * this.scale);
            Rectangle screenBounds = new Rectangle(lX, lY, hX - lX, hY - lY);
            if (screenBounds.width <= 0 || screenBounds.height <= 0) {
                return true;
            }
            if (screenBounds.width >= PixelDrawing.topSz.width / 2 && screenBounds.height >= PixelDrawing.topSz.height / 2) {
                return false;
            }
            if (expandedCellCount == null) {
                expandedCellCount = new ExpandedCellInfo();
                expandedCells.put(expansionKey, expandedCellCount);
            }
            expandedCellCount.offscreen = new PixelDrawing(this.wnd, screenBounds);
            expandedCellCount.offscreen.drawCell(subCell, null, fullInstantiate, orient, rotTrans, topWnd, context);
            ++offscreensCreated;
            offscreenPixelsCreated += ((ExpandedCellInfo)expandedCellCount).offscreen.total;
        }
        this.databaseToScreen(origTrans.getTranslateX(), origTrans.getTranslateY(), this.tempPt1);
        this.copyBits(expandedCellCount.offscreen, this.tempPt1.x, this.tempPt1.y);
        ++offscreensUsed;
        offscreenPixelsUsed += ((ExpandedCellInfo)expandedCellCount).offscreen.total;
        return true;
    }

    private void countCell(Cell cell, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform prevTrans) {
        Iterator nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = (NodeInst)nodes.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            if (drawLimitBounds != null) {
                Rectangle2D curBounds = ni.getBounds();
                Rectangle2D.Double bounds = new Rectangle2D.Double(curBounds.getX(), curBounds.getY(), curBounds.getWidth(), curBounds.getHeight());
                GenMath.transformRect(bounds, prevTrans);
                if (!GenMath.rectsIntersect(bounds, drawLimitBounds)) {
                    return;
                }
            }
            this.countNode(ni, drawLimitBounds, fullInstantiate, orient, prevTrans);
        }
    }

    private void countNode(NodeInst ni, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform trans) {
        List path;
        double objWidth = Math.max(ni.getXSize(), ni.getYSize());
        if (objWidth < maxObjectSize) {
            return;
        }
        Orientation subOrient = orient.concatenate(ni.getOrient());
        AffineTransform subTrans = ni.transformOut(trans);
        NodeProto np = ni.getProto();
        Cell subCell = (Cell)np;
        Rectangle2D cellBounds = subCell.getBounds();
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        cellBounds = poly.getBounds2D();
        Rectangle screenBounds = this.databaseToScreen(cellBounds);
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (screenBounds.x > this.sz.width || screenBounds.x + screenBounds.width < 0) {
            return;
        }
        if (screenBounds.y > this.sz.height || screenBounds.y + screenBounds.height < 0) {
            return;
        }
        boolean expanded = ni.isExpanded();
        if (fullInstantiate) {
            expanded = true;
        }
        if (!expanded && (path = this.wnd.getInPlaceEditNodePath()) != null) {
            for (int pathIndex = 0; pathIndex < path.size(); ++pathIndex) {
                NodeInst niOnPath = (NodeInst)path.get(pathIndex);
                if (niOnPath.getProto() != subCell) continue;
                expanded = true;
                break;
            }
        }
        if (!expanded) {
            return;
        }
        if (screenBounds.width < this.sz.width / 2 || screenBounds.height <= this.sz.height / 2) {
            ExpandedCellKey expansionKey = new ExpandedCellKey(subCell, subOrient);
            ExpandedCellInfo expansionCount = (ExpandedCellInfo)expandedCells.get(expansionKey);
            if (expansionCount == null) {
                expansionCount = new ExpandedCellInfo();
                expansionCount.instanceCount = 1;
                expandedCells.put(expansionKey, expansionCount);
            } else {
                expansionCount.instanceCount++;
                if (expansionCount.instanceCount > 1) {
                    return;
                }
            }
        }
        this.countCell(subCell, null, fullInstantiate, subOrient, subTrans);
    }

    public static void forceRedraw(Cell cell) {
        if (expandedCells == null) {
            return;
        }
        ArrayList keys = new ArrayList();
        Iterator<Object> it = expandedCells.keySet().iterator();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        it = keys.iterator();
        while (it.hasNext()) {
            ExpandedCellKey expansionKey = (ExpandedCellKey)it.next();
            if (expansionKey.cell != cell) continue;
            expandedCells.remove(expansionKey);
        }
    }

    private void copyBits(PixelDrawing srcOffscreen, int centerX, int centerY) {
        if (srcOffscreen == null) {
            return;
        }
        Dimension dim = srcOffscreen.sz;
        int cornerX = centerX - (int)srcOffscreen.originX;
        int cornerY = centerY - (int)srcOffscreen.originY;
        if (Main.getDebug() && this.numLayerBitMaps != srcOffscreen.numLayerBitMaps) {
            System.out.println("Possible mixture of technologies in PixelDrawing.copyBits");
        }
        for (int srcY = 0; srcY < dim.height; ++srcY) {
            int destY = srcY + cornerY;
            if (destY < 0 || destY >= this.sz.height) continue;
            int srcBase = srcY * dim.width;
            int destBase = destY * this.sz.width;
            for (int srcX = 0; srcX < dim.width; ++srcX) {
                int destX = srcX + cornerX;
                if (destX < 0 || destX >= this.sz.width) continue;
                int srcColor = srcOffscreen.opaqueData[srcBase + srcX];
                if (srcColor != this.backgroundValue) {
                    this.opaqueData[destBase + destX] = srcColor;
                }
                for (int i = 0; i < this.numLayerBitMaps && i < srcOffscreen.numLayerBitMaps; ++i) {
                    byte[][] srcLayerBitMap = srcOffscreen.layerBitMaps[i];
                    if (srcLayerBitMap == null) continue;
                    byte[] srcRow = srcLayerBitMap[srcY];
                    byte[][] destLayerBitMap = this.getLayerBitMap(i);
                    byte[] destRow = destLayerBitMap[destY];
                    if ((srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
        Iterator it = srcOffscreen.patternedOpaqueLayers.keySet().iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            PatternedOpaqueLayer polSrc = (PatternedOpaqueLayer)srcOffscreen.patternedOpaqueLayers.get(layer);
            byte[][] srcLayerBitMap = polSrc.bitMap;
            if (srcLayerBitMap == null) continue;
            if (this.renderedWindow) {
                EGraphics desc = layer.getGraphics();
                int col = desc.getColor().getRGB() & 0xFFFFFF;
                int[] pattern = desc.getPattern();
                for (int srcY = 0; srcY < dim.height; ++srcY) {
                    int destY = srcY + cornerY;
                    if (destY < 0 || destY >= this.sz.height) continue;
                    int destBase = destY * this.sz.width;
                    int pat = pattern[destY & 0xF];
                    if (pat == 0) continue;
                    byte[] srcRow = srcLayerBitMap[srcY];
                    for (int srcX = 0; srcX < dim.width; ++srcX) {
                        int destX = srcX + cornerX;
                        if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0 || (pat & 32768 >> (destX & 0xF)) == 0) continue;
                        this.opaqueData[destBase + destX] = col;
                    }
                }
                continue;
            }
            PatternedOpaqueLayer polDest = (PatternedOpaqueLayer)this.patternedOpaqueLayers.get(layer);
            if (polDest == null) {
                polDest = new PatternedOpaqueLayer();
                PatternedOpaqueLayer.access$002(polDest, new byte[this.sz.height][]);
                for (int y = 0; y < this.sz.height; ++y) {
                    byte[] row = new byte[this.numBytesPerRow];
                    for (int x = 0; x < this.numBytesPerRow; ++x) {
                        row[x] = 0;
                    }
                    ((PatternedOpaqueLayer)polDest).bitMap[y] = row;
                }
                this.patternedOpaqueLayers.put(layer, polDest);
            }
            byte[][] destLayerBitMap = polDest.bitMap;
            for (int srcY = 0; srcY < dim.height; ++srcY) {
                int destY = srcY + cornerY;
                if (destY < 0 || destY >= this.sz.height) continue;
                int destBase = destY * this.sz.width;
                byte[] srcRow = srcLayerBitMap[srcY];
                byte[] destRow = destLayerBitMap[destY];
                for (int srcX = 0; srcX < dim.width; ++srcX) {
                    int destX = srcX + cornerX;
                    if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
    }

    private void drawPolys(Poly[] polys, AffineTransform trans, boolean forceVisible) {
        if (polys == null) {
            return;
        }
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            if (poly == null) continue;
            Layer layer = poly.getLayer();
            EGraphics graphics = null;
            boolean dimmed = false;
            if (layer != null) {
                if (!forceVisible && !layer.isVisible()) continue;
                graphics = layer.getGraphics();
                dimmed = layer.isDimmed();
            }
            poly.transform(trans);
            this.renderPoly(poly, graphics, dimmed);
            if (!this.periodicRefresh) continue;
            ++this.objectCount;
            if (this.objectCount <= 100) continue;
            this.objectCount = 0;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRefreshTime <= 1000L) continue;
            this.wnd.repaint();
        }
    }

    byte[][] getLayerBitMap(int layerNum) {
        if (layerNum < 0) {
            return null;
        }
        byte[][] layerBitMap = this.layerBitMaps[layerNum];
        if (layerBitMap != null) {
            return layerBitMap;
        }
        return this.newLayerBitMap(layerNum);
    }

    private byte[][] newLayerBitMap(int layerNum) {
        byte[][] layerBitMap = new byte[this.sz.height][];
        for (int y = 0; y < this.sz.height; ++y) {
            byte[] row = new byte[this.numBytesPerRow];
            for (int x = 0; x < this.numBytesPerRow; ++x) {
                row[x] = 0;
            }
            layerBitMap[y] = row;
        }
        this.layerBitMaps[layerNum] = layerBitMap;
        ++this.numLayerBitMapsCreated;
        return layerBitMap;
    }

    private void renderPoly(Poly poly, EGraphics graphics, boolean dimmed) {
        Point2D center;
        Point2D newPt;
        Rectangle2D bounds;
        int layerNum;
        byte[][] layerBitMap = null;
        if (graphics != null && (layerNum = graphics.getTransparentLayer() - 1) < this.numLayerBitMaps) {
            layerBitMap = this.getLayerBitMap(layerNum);
        }
        Poly.Type style = poly.getStyle();
        if (!this.renderedWindow && (style == Poly.Type.FILLED || style == Poly.Type.DISC) && layerBitMap == null && graphics.isPatternedOnDisplay()) {
            Layer layer = poly.getLayer();
            PatternedOpaqueLayer pol = (PatternedOpaqueLayer)this.patternedOpaqueLayers.get(layer);
            if (pol == null) {
                pol = new PatternedOpaqueLayer();
                PatternedOpaqueLayer.access$002(pol, new byte[this.sz.height][]);
                for (int y = 0; y < this.sz.height; ++y) {
                    byte[] row = new byte[this.numBytesPerRow];
                    for (int x = 0; x < this.numBytesPerRow; ++x) {
                        row[x] = 0;
                    }
                    ((PatternedOpaqueLayer)pol).bitMap[y] = row;
                }
                this.patternedOpaqueLayers.put(layer, pol);
            }
            layerBitMap = pol.bitMap;
            graphics = null;
        }
        Point2D[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            bounds = poly.getBox();
            if (bounds != null) {
                this.databaseToScreen(bounds.getMinX(), bounds.getMinY(), this.tempPt1);
                this.databaseToScreen(bounds.getMaxX(), bounds.getMaxY(), this.tempPt2);
                int lX = Math.min(this.tempPt1.x, this.tempPt2.x);
                int hX = Math.max(this.tempPt1.x, this.tempPt2.x);
                int lY = Math.min(this.tempPt1.y, this.tempPt2.y);
                int hY = Math.max(this.tempPt1.y, this.tempPt2.y);
                if (lX < 0) {
                    lX = 0;
                }
                if (hX >= this.sz.width) {
                    hX = this.sz.width - 1;
                }
                if (lY < 0) {
                    lY = 0;
                }
                if (hY >= this.sz.height) {
                    hY = this.sz.height - 1;
                }
                this.drawBox(lX, hX, lY, hY, layerBitMap, graphics, dimmed);
                return;
            }
            Point[] intPoints = new Point[points.length];
            for (int i = 0; i < points.length; ++i) {
                intPoints[i] = new Point();
                this.databaseToScreen(points[i].getX(), points[i].getY(), intPoints[i]);
            }
            Point[] clippedPoints = GenMath.clipPoly(intPoints, 0, this.sz.width - 1, 0, this.sz.height - 1);
            this.drawPolygon(clippedPoints, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            this.databaseToScreen(points[0].getX(), points[0].getY(), this.tempPt1);
            this.databaseToScreen(points[1].getX(), points[1].getY(), this.tempPt2);
            this.databaseToScreen(points[2].getX(), points[2].getY(), this.tempPt3);
            this.databaseToScreen(points[3].getX(), points[3].getY(), this.tempPt4);
            this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt2, this.tempPt3, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt3, this.tempPt4, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt4, this.tempPt1, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt1, this.tempPt3, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt2, this.tempPt4, layerBitMap, graphics, 0, dimmed);
            return;
        }
        if (style.isText()) {
            bounds = poly.getBounds2D();
            Rectangle rect = this.databaseToScreen(bounds);
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            this.drawText(rect, style, descript, str, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j = 1; j < points.length; ++j) {
                Point2D oldPt = points[j - 1];
                Point2D newPt2 = points[j];
                this.databaseToScreen(oldPt.getX(), oldPt.getY(), this.tempPt1);
                this.databaseToScreen(newPt2.getX(), newPt2.getY(), this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, lineType, dimmed);
            }
            if (style == Poly.Type.CLOSED) {
                Point2D oldPt = points[points.length - 1];
                newPt = points[0];
                this.databaseToScreen(oldPt.getX(), oldPt.getY(), this.tempPt1);
                this.databaseToScreen(newPt.getX(), newPt.getY(), this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, lineType, dimmed);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j = 0; j < points.length; j += 2) {
                Point2D oldPt = points[j];
                newPt = points[j + 1];
                this.databaseToScreen(oldPt.getX(), oldPt.getY(), this.tempPt1);
                this.databaseToScreen(newPt.getX(), newPt.getY(), this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, 0, dimmed);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            center = points[0];
            Point2D edge = points[1];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge.getX(), edge.getY(), this.tempPt2);
            this.drawCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            center = points[0];
            Point2D edge = points[1];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge.getX(), edge.getY(), this.tempPt2);
            this.drawThickCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.DISC) {
            center = points[0];
            Point2D edge = points[1];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge.getX(), edge.getY(), this.tempPt2);
            this.drawDisc(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            center = points[0];
            Point2D edge1 = points[1];
            Point2D edge2 = points[2];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge1.getX(), edge1.getY(), this.tempPt2);
            this.databaseToScreen(edge2.getX(), edge2.getY(), this.tempPt3);
            this.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, style == Poly.Type.THICKCIRCLEARC, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CROSS) {
            this.drawCross(poly, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            center = points[0];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            int size = 5;
            this.drawLine(new Point(this.tempPt1.x - size, this.tempPt1.y), new Point(this.tempPt1.x + size, this.tempPt1.y), layerBitMap, graphics, 0, dimmed);
            this.drawLine(new Point(this.tempPt1.x, this.tempPt1.y - size), new Point(this.tempPt1.x, this.tempPt1.y + size), layerBitMap, graphics, 0, dimmed);
            return;
        }
    }

    int getTheColor(EGraphics desc, boolean dimmed) {
        int col = desc.getColor().getRGB() & 0xFFFFFF;
        if (this.highlightingLayers) {
            col = dimmed ? this.dimColor(col) : this.brightenColor(col);
        }
        return col;
    }

    private int dimColor(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
        this.hsvTempArray[1] = this.hsvTempArray[1] * 0.2;
        col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
        return col;
    }

    private int brightenColor(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
        this.hsvTempArray[1] = this.hsvTempArray[1] * 1.5;
        if (this.hsvTempArray[1] > 1.0) {
            this.hsvTempArray[1] = 1.0;
        }
        col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
        return col;
    }

    private void fromRGBtoHSV(int ir, int ig, int ib, double[] hsi) {
        double r = (float)ir / 255.0f;
        double g = (float)ig / 255.0f;
        double b = (float)ib / 255.0f;
        hsi[2] = Math.max(Math.max(r, g), b);
        double x = Math.min(Math.min(r, g), b);
        hsi[1] = hsi[2] == 0.0 ? 0.0 : (hsi[2] - x) / hsi[2];
        hsi[0] = 0.0;
        if (hsi[1] != 0.0) {
            double rdot = (hsi[2] - r) / (hsi[2] - x);
            double gdot = (hsi[2] - g) / (hsi[2] - x);
            double bdot = (hsi[2] - b) / (hsi[2] - x);
            if (b == x && r == hsi[2]) {
                hsi[0] = (1.0 - gdot) / 6.0;
            } else if (b == x && g == hsi[2]) {
                hsi[0] = (1.0 + rdot) / 6.0;
            } else if (r == x && g == hsi[2]) {
                hsi[0] = (3.0 - bdot) / 6.0;
            } else if (r == x && b == hsi[2]) {
                hsi[0] = (3.0 + gdot) / 6.0;
            } else if (g == x && b == hsi[2]) {
                hsi[0] = (5.0 - rdot) / 6.0;
            } else if (g == x && r == hsi[2]) {
                hsi[0] = (5.0 + bdot) / 6.0;
            } else {
                System.out.println("Cannot convert (" + ir + "," + ig + "," + ib + "), for x=" + x + " i=" + hsi[2] + " s=" + hsi[1]);
            }
        }
    }

    private int fromHSVtoRGB(double h, double s, double v) {
        int i = (int)(h *= 6.0);
        double f = h - (double)i;
        double m = v * (1.0 - s);
        double n = v * (1.0 - s * f);
        double k = v * (1.0 - s * (1.0 - f));
        int r = 0;
        int g = 0;
        int b = 0;
        switch (i) {
            case 0: {
                r = (int)(v * 255.0);
                g = (int)(k * 255.0);
                b = (int)(m * 255.0);
                break;
            }
            case 1: {
                r = (int)(n * 255.0);
                g = (int)(v * 255.0);
                b = (int)(m * 255.0);
                break;
            }
            case 2: {
                r = (int)(m * 255.0);
                g = (int)(v * 255.0);
                b = (int)(k * 255.0);
                break;
            }
            case 3: {
                r = (int)(m * 255.0);
                g = (int)(n * 255.0);
                b = (int)(v * 255.0);
                break;
            }
            case 4: {
                r = (int)(k * 255.0);
                g = (int)(m * 255.0);
                b = (int)(v * 255.0);
                break;
            }
            case 5: {
                r = (int)(v * 255.0);
                g = (int)(m * 255.0);
                b = (int)(n * 255.0);
            }
        }
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            System.out.println("(" + h + "," + s + "," + v + ") -> (" + r + "," + g + "," + b + ") (i=" + i + ")");
            if (r < 0) {
                r = 0;
            }
            if (r > 255) {
                r = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (g > 255) {
                g = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (b > 255) {
                b = 255;
            }
        }
        return b << 16 | g << 8 | r;
    }

    void drawBox(int lX, int hX, int lY, int hY, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        block17: {
            EGraphics.Outline o;
            int x;
            int pat;
            int y;
            int[] pattern;
            int col;
            block16: {
                col = 0;
                pattern = null;
                if (desc != null) {
                    col = this.getTheColor(desc, dimmed);
                    if (desc.isPatternedOnDisplay()) {
                        pattern = desc.getPattern();
                    }
                }
                if (pattern != null) break block16;
                if (layerBitMap == null) {
                    for (int y2 = lY; y2 <= hY; ++y2) {
                        int baseIndex = y2 * this.sz.width + lX;
                        for (int x2 = lX; x2 <= hX; ++x2) {
                            int index;
                            int alpha;
                            if ((alpha = this.opaqueData[index = baseIndex++] >> 24 & 0xFF) != 255) continue;
                            this.opaqueData[index] = col;
                        }
                    }
                } else {
                    for (int y3 = lY; y3 <= hY; ++y3) {
                        byte[] row = layerBitMap[y3];
                        for (int x3 = lX; x3 <= hX; ++x3) {
                            int n = x3 >> 3;
                            row[n] = (byte)(row[n] | 1 << (x3 & 7));
                        }
                    }
                }
                break block17;
            }
            if (layerBitMap == null) {
                for (y = lY; y <= hY; ++y) {
                    pat = pattern[y & 0xF];
                    if (pat == 0) continue;
                    int baseIndex = y * this.sz.width;
                    for (x = lX; x <= hX; ++x) {
                        if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                        this.opaqueData[baseIndex + x] = col;
                    }
                }
            } else {
                for (y = lY; y <= hY; ++y) {
                    pat = pattern[y & 0xF];
                    if (pat == 0) continue;
                    byte[] row = layerBitMap[y];
                    for (x = lX; x <= hX; ++x) {
                        if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
            }
            if ((o = desc.getOutlined()) == EGraphics.Outline.NOPAT) break block17;
            this.drawPatLine(lX, lY, lX, hY, layerBitMap, col, o.getPattern(), o.getLen());
            this.drawPatLine(lX, hY, hX, hY, layerBitMap, col, o.getPattern(), o.getLen());
            this.drawPatLine(hX, hY, hX, lY, layerBitMap, col, o.getPattern(), o.getLen());
            this.drawPatLine(hX, lY, lX, lY, layerBitMap, col, o.getPattern(), o.getLen());
            if (o.getThickness() != 1) {
                for (int i = 1; i < o.getThickness(); ++i) {
                    this.drawPatLine(lX + i, lY, lX + i, hY, layerBitMap, col, o.getPattern(), o.getLen());
                    this.drawPatLine(lX, hY - i, hX, hY - i, layerBitMap, col, o.getPattern(), o.getLen());
                    this.drawPatLine(hX - i, hY, hX - i, lY, layerBitMap, col, o.getPattern(), o.getLen());
                    this.drawPatLine(hX, lY + i, lX, lY + i, layerBitMap, col, o.getPattern(), o.getLen());
                }
            }
        }
    }

    private void drawBox(int lX, int hX, int lY, int hY, byte[] layerBitMap, byte layerBitMask) {
        ++boxes;
        int dx = hX - lX;
        int dy = hY - lY;
        int baseIndex = lY * this.width + lX;
        if (dx >= dy) {
            int baseIncr = this.width - (dx + 1);
            for (int i = dy; i >= 0; --i) {
                for (int j = dx; j >= 0; --j) {
                    int n = baseIndex++;
                    layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                }
                baseIndex += baseIncr;
            }
        } else {
            int baseIncr = 1 - (dy + 1) * this.width;
            for (int i = dx; i >= 0; --i) {
                for (int j = dy; j >= 0; --j) {
                    int n = baseIndex;
                    layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                    baseIndex += this.width;
                }
                baseIndex += baseIncr;
            }
        }
    }

    void drawLine(Point pt1, Point pt2, byte[][] layerBitMap, EGraphics desc, int texture, boolean dimmed) {
        if (GenMath.clipLine(pt1, pt2, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col, 136, 8);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col, 231, 8);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col);
            }
        }
    }

    private void drawLine(Point pt1, Point pt2, byte[] layerBitMap, byte layerBitMask, int texture) {
        if (GenMath.clipLine(pt1, pt2, this.clipLX, this.clipHX, this.clipLY, this.clipHY)) {
            return;
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, layerBitMask);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, layerBitMask, 136, 8);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, layerBitMask, 231, 8);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, layerBitMask);
            }
        }
    }

    private void drawCross(Poly poly, EGraphics graphics, boolean dimmed) {
        Point2D[] points = poly.getPoints();
        this.databaseToScreen(points[0].getX(), points[0].getY(), this.tempPt1);
        int size = 3;
        this.drawLine(new Point(this.tempPt1.x - size, this.tempPt1.y), new Point(this.tempPt1.x + size, this.tempPt1.y), null, graphics, 0, dimmed);
        this.drawLine(new Point(this.tempPt1.x, this.tempPt1.y - size), new Point(this.tempPt1.x, this.tempPt1.y + size), null, graphics, 0, dimmed);
    }

    private void drawCross(Poly poly, byte[] layerBitMap, byte layerBitMask) {
        int baseIndex;
        ++crosses;
        Point2D[] points = poly.getPoints();
        Point center = this.tempPt1;
        this.databaseToScreen(points[0].getX(), points[0].getY(), center);
        int size = 3;
        if (this.clipLY <= center.y && center.y <= this.clipHY) {
            baseIndex = center.y * this.width;
            int xend = Math.min(this.clipLY, center.x + size);
            for (int x = Math.max(this.clipLX, center.x - size); x <= xend; ++x) {
                int n = baseIndex + x;
                layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
            }
        }
        if (this.clipLX <= center.x && center.x <= this.clipHX) {
            baseIndex = center.y;
            int yend = Math.min(this.clipHY, center.y + size);
            for (int y = Math.max(this.clipLY, center.y - size); y <= yend; ++y) {
                int n = y * this.width + baseIndex;
                layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
            }
        }
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, int col) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, byte[] layerBitMap, byte layerBitMask) {
        int dy;
        ++solidLines;
        int dx = Math.abs(x2 - x1);
        if (dx >= (dy = Math.abs(y2 - y1))) {
            int yend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 <= x2) {
                x = x1;
                y = y1;
                yend = y2;
            } else {
                x = x2;
                y = y2;
                yend = y1;
            }
            int baseIndex = y * this.width + x;
            if (dy == 0) {
                for (int i = dx; i >= 0; --i) {
                    int n = baseIndex++;
                    layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                }
            } else {
                int baseIncr = yend >= y ? 1 + this.width : 1 - this.width;
                for (int i = dx; i >= 0; --i) {
                    int n = baseIndex++;
                    layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                    if (d < 0) {
                        d += incr1;
                        continue;
                    }
                    d += incr2;
                    baseIndex += baseIncr;
                }
            }
        } else {
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 <= y2) {
                x = x1;
                y = y1;
                xend = x2;
            } else {
                x = x2;
                y = y2;
                xend = x1;
            }
            int baseIndex = y * this.width + x;
            if (dx == 0) {
                for (int i = dy; i >= 0; --i) {
                    int n = baseIndex;
                    layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                    baseIndex += this.width;
                }
            } else {
                int baseIncr = xend >= x ? this.width + 1 : this.width - 1;
                for (int i = dy; i >= 0; --i) {
                    int n = baseIndex;
                    layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                    if (d < 0) {
                        d += incr1;
                        baseIndex += this.width;
                        continue;
                    }
                    d += incr2;
                    baseIndex += baseIncr;
                }
            }
        }
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, int col, int pattern, int len) {
        int dy;
        int i = 0;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, byte[] layerBitMap, byte layerBitMask, int pattern, int len) {
        int dy;
        ++patLines;
        int dx = Math.abs(x2 - x1);
        if (dx >= (dy = Math.abs(y2 - y1))) {
            int yend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 <= x2) {
                x = x1;
                y = y1;
                yend = y2;
            } else {
                x = x2;
                y = y2;
                yend = y1;
            }
            int baseIndex = y * this.width + x;
            if (dy == 0) {
                for (int i = 0; i <= dx; ++i) {
                    if ((pattern & 1 << (i & 7)) == 0) continue;
                    int n = baseIndex++;
                    layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                }
            } else {
                int baseIncr = yend >= y ? 1 + this.width : 1 - this.width;
                for (int i = 0; i <= dx; ++i) {
                    if ((pattern & 1 << (i & 7)) != 0) {
                        int n = baseIndex;
                        layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                    }
                    if (d < 0) {
                        d += incr1;
                        ++baseIndex;
                        continue;
                    }
                    d += incr2;
                    baseIndex += baseIncr;
                }
            }
        } else {
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 <= y2) {
                x = x1;
                y = y1;
                xend = x2;
            } else {
                x = x2;
                y = y2;
                xend = x1;
            }
            int baseIndex = y * this.width + x;
            if (dx == 0) {
                for (int i = 0; i <= dy; ++i) {
                    if ((pattern & 1 << (i & 7)) != 0) {
                        int n = baseIndex;
                        layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                    }
                    baseIndex += this.width;
                }
            } else {
                int baseIncr = xend >= x ? this.width + 1 : this.width - 1;
                for (int i = 0; i <= dy; ++i) {
                    if ((pattern & 1 << (i & 7)) != 0) {
                        int n = baseIndex;
                        layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
                    }
                    if (d < 0) {
                        d += incr1;
                        baseIndex += this.width;
                        continue;
                    }
                    d += incr2;
                    baseIndex += baseIncr;
                }
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, int col) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, byte[] layerBitMap, byte layerBitMask) {
        block12: {
            int xend;
            int y;
            int x;
            int d;
            int incr2;
            int incr1;
            int dy;
            block13: {
                int yend;
                int dx;
                block10: {
                    int yend2;
                    int y3;
                    int x3;
                    int d2;
                    int incr22;
                    int incr12;
                    block11: {
                        int xend2;
                        ++thickLines;
                        dx = Math.abs(x2 - x1);
                        if (dx < (dy = Math.abs(y2 - y1))) break block10;
                        incr12 = 2 * dy;
                        d2 = incr22 = 2 * (dy - dx);
                        if (x1 <= x2) {
                            x3 = x1;
                            y3 = y1;
                            xend2 = x2;
                            yend2 = y2;
                        } else {
                            x3 = x2;
                            y3 = y2;
                            xend2 = x1;
                            yend2 = y1;
                        }
                        if (dy != 0) break block11;
                        this.drawBox(x3, xend2, Math.max(this.clipLY, y3 - 1), Math.min(this.clipHY, y3 + 1), layerBitMap, layerBitMask);
                        if (x3 > this.clipLX) {
                            this.drawPoint(x3 - 1, y3, layerBitMap, layerBitMask);
                        }
                        if (xend2 >= this.clipHX) break block12;
                        this.drawPoint(xend2 + 1, y3, layerBitMap, layerBitMask);
                        break block12;
                    }
                    int yIncr = yend2 >= y3 ? 1 : -1;
                    for (int i = 0; i <= dx; ++i) {
                        this.drawThickPoint(x3 + i, y3, layerBitMap, layerBitMask);
                        if (d2 < 0) {
                            d2 += incr12;
                            continue;
                        }
                        d2 += incr22;
                        y3 += yIncr;
                    }
                    break block12;
                }
                incr1 = 2 * dx;
                d = incr2 = 2 * (dx - dy);
                if (y1 <= y2) {
                    x = x1;
                    y = y1;
                    xend = x2;
                    yend = y2;
                } else {
                    x = x2;
                    y = y2;
                    xend = x1;
                    yend = x1;
                }
                if (dx != 0) break block13;
                this.drawBox(Math.max(this.clipLX, x - 1), Math.min(this.clipHX, x + 1), y, yend, layerBitMap, layerBitMask);
                if (y > this.clipLY) {
                    this.drawPoint(x, y - 1, layerBitMap, layerBitMask);
                }
                if (yend >= this.clipHY) break block12;
                this.drawPoint(x, yend + 1, layerBitMap, layerBitMask);
                break block12;
            }
            int xIncr = xend >= x ? 1 : -1;
            for (int i = 0; i <= dy; ++i) {
                this.drawThickPoint(x, y + i, layerBitMap, layerBitMask);
                if (d < 0) {
                    d += incr1;
                    continue;
                }
                d += incr2;
                x += xIncr;
            }
        }
    }

    void drawPolygon(Point[] points, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        EGraphics.Outline o;
        int i;
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        PolySeg edgelist = null;
        PolySeg[] polySegs = new PolySeg[points.length];
        for (i = 0; i < points.length; ++i) {
            polySegs[i] = new PolySeg();
            if (i == 0) {
                polySegs[i].fx = points[points.length - 1].x;
                polySegs[i].fy = points[points.length - 1].y;
            } else {
                polySegs[i].fx = points[i - 1].x;
                polySegs[i].fy = points[i - 1].y;
            }
            polySegs[i].tx = points[i].x;
            polySegs[i].ty = points[i].y;
        }
        block1: for (i = 0; i < points.length; ++i) {
            int j = polySegs[i].ty - polySegs[i].fy;
            if (j > 0) {
                polySegs[i].direction = 1;
            } else if (j < 0) {
                polySegs[i].direction = -1;
            } else {
                polySegs[i].direction = 0;
            }
            if (j == 0) {
                polySegs[i].increment = 0;
            } else {
                polySegs[i].increment = polySegs[i].tx - polySegs[i].fx;
                if (polySegs[i].increment != 0) {
                    polySegs[i].increment = (polySegs[i].increment * 65536 - j + 1) / j;
                }
            }
            polySegs[i].tx <<= 16;
            polySegs[i].fx <<= 16;
            if (polySegs[i].fy > polySegs[i].ty) {
                j = polySegs[i].tx;
                polySegs[i].tx = polySegs[i].fx;
                polySegs[i].fx = j;
                j = polySegs[i].ty;
                polySegs[i].ty = polySegs[i].fy;
                polySegs[i].fy = j;
            }
            if (edgelist == null) {
                edgelist = polySegs[i];
                polySegs[i].nextedge = null;
                continue;
            }
            if (edgelist.fy > polySegs[i].fy) {
                polySegs[i].nextedge = edgelist;
                edgelist = polySegs[i];
                continue;
            }
            PolySeg a = edgelist;
            while (a != null) {
                if (a.nextedge == null || a.nextedge.fy > polySegs[i].fy) {
                    polySegs[i].nextedge = a.nextedge;
                    a.nextedge = polySegs[i];
                    continue block1;
                }
                a = a.nextedge;
            }
        }
        int ycur = 0;
        PolySeg active = null;
        while (active != null || edgelist != null) {
            if (active == null) {
                active = edgelist;
                active.nextactive = null;
                edgelist = edgelist.nextedge;
                ycur = active.fy;
            }
            block4: while (edgelist != null && edgelist.fy <= ycur) {
                if (active.fx > edgelist.fx || active.fx == edgelist.fx && active.increment > edgelist.increment) {
                    edgelist.nextactive = active;
                    active = edgelist;
                    edgelist = edgelist.nextedge;
                    continue;
                }
                PolySeg a = active;
                while (a != null) {
                    if (a.nextactive == null || a.nextactive.fx > edgelist.fx || a.nextactive.fx == edgelist.fx && a.nextactive.increment > edgelist.increment) {
                        edgelist.nextactive = a.nextactive;
                        a.nextactive = edgelist;
                        edgelist = edgelist.nextedge;
                        continue block4;
                    }
                    a = a.nextactive;
                }
            }
            int wrap = 0;
            PolySeg left = active;
            PolySeg edge = active;
            while (edge != null) {
                if ((wrap += edge.direction) == 0) {
                    int x;
                    int j = left.fx + 32768 >> 16;
                    int k = edge.fx + 32768 >> 16;
                    if (pattern != null) {
                        int pat = pattern[ycur & 0xF];
                        if (pat != 0) {
                            int x2;
                            if (layerBitMap == null) {
                                int baseIndex = ycur * this.sz.width;
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    int index = baseIndex + x2;
                                    this.opaqueData[index] = col;
                                }
                            } else {
                                byte[] row = layerBitMap[ycur];
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    int n = x2 >> 3;
                                    row[n] = (byte)(row[n] | 1 << (x2 & 7));
                                }
                            }
                        }
                    } else if (layerBitMap == null) {
                        int baseIndex = ycur * this.sz.width;
                        for (x = j; x <= k; ++x) {
                            this.opaqueData[baseIndex + x] = col;
                        }
                    } else {
                        byte[] row = layerBitMap[ycur];
                        for (x = j; x <= k; ++x) {
                            int n = x >> 3;
                            row[n] = (byte)(row[n] | 1 << (x & 7));
                        }
                    }
                    left = edge.nextactive;
                }
                edge = edge.nextactive;
            }
            ++ycur;
            PolySeg lastedge = null;
            PolySeg edge2 = active;
            while (edge2 != null) {
                if (ycur >= edge2.ty) {
                    if (lastedge == null) {
                        active = edge2.nextactive;
                    } else {
                        lastedge.nextactive = edge2.nextactive;
                    }
                } else {
                    edge2.fx += edge2.increment;
                    lastedge = edge2;
                }
                edge2 = edge2.nextactive;
            }
        }
        if (pattern != null && (o = desc.getOutlined()) != EGraphics.Outline.NOPAT) {
            for (int i2 = 0; i2 < points.length; ++i2) {
                int last = i2 - 1;
                if (last < 0) {
                    last = points.length - 1;
                }
                int fX = points[last].x;
                int fY = points[last].y;
                int tX = points[i2].x;
                int tY = points[i2].y;
                this.drawPatLine(fX, fY, tX, tY, layerBitMap, col, o.getPattern(), o.getLen());
                if (o.getThickness() == 1) continue;
                int ang = GenMath.figureAngle(new Point2D.Double(fX, fY), new Point2D.Double(tX, tY));
                double sin = DBMath.sin(ang + 900);
                double cos = DBMath.cos(ang + 900);
                for (int t = 1; t < o.getThickness(); ++t) {
                    int dX = (int)(cos * (double)t + 0.5);
                    int dY = (int)(sin * (double)t + 0.5);
                    this.drawPatLine(fX + dX, fY + dY, tX + dX, tY + dY, layerBitMap, col, o.getPattern(), o.getLen());
                }
            }
        }
    }

    private void drawPolygon(Point[] points, byte[] layerBitMap, byte layerBitMask) {
        ++polygons;
    }

    public void drawText(String s, Rectangle rect) {
        textGraphics.setColor(new Color(User.getColorText()));
        this.drawText(rect, Poly.Type.TEXTBOX, noCellTextDescriptor, s, null, textGraphics, false);
    }

    public void drawText(Rectangle rect, Poly.Type style, TextDescriptor descript, String s, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        int col = User.getColorText() & 0xFFFFFF;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int size = EditWindow.getDefaultFontSize();
        boolean fontStyle = false;
        String fontName = User.getDefaultFont();
        boolean italic = false;
        boolean bold = false;
        boolean underline = false;
        int rotation = 0;
        int greekScale = 0;
        if (descript != null) {
            TextDescriptor.ActiveFont af;
            double dSize;
            Color full;
            rotation = descript.getRotation().getIndex();
            int colorIndex = descript.getColorIndex();
            if (colorIndex != 0 && (full = EGraphics.getColorFromIndex(colorIndex)) != null) {
                col = full.getRGB() & 0xFFFFFF;
            }
            if ((size = (int)(dSize = descript.getTrueSize(this.wnd))) < 5) {
                greekScale = 2;
                while ((size = (int)(dSize * (double)greekScale)) < 5) {
                    greekScale *= 2;
                }
            }
            italic = descript.isItalic();
            bold = descript.isBold();
            underline = descript.isUnderline();
            int fontIndex = descript.getFace();
            if (fontIndex != 0 && (af = TextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
        }
        if (style == Poly.Type.TEXTBOX && (rect.x >= this.sz.width || rect.x + rect.width < 0 || rect.y >= this.sz.height || rect.y + rect.height < 0)) {
            return;
        }
        long startTime = 0L;
        RenderTextInfo renderInfo = new RenderTextInfo();
        if (!renderInfo.buildInfo(s, fontName, size, italic, bold, underline, rect, style, rotation)) {
            return;
        }
        if (greekScale != 0) {
            int lY;
            int width = (int)renderInfo.bounds.getWidth() / greekScale;
            int sizeIndent = (size / greekScale + 1) / 4;
            Point pt = PixelDrawing.getTextCorner(width, size / greekScale, style, rect, rotation);
            int lX = pt.x;
            int hX = lX + width;
            int hY = lY = pt.y + sizeIndent;
            if (lX < 0) {
                lX = 0;
            }
            if (hX >= this.sz.width) {
                hX = this.sz.width - 1;
            }
            if (lY < 0) {
                lY = 0;
            }
            if (hY >= this.sz.height) {
                hY = this.sz.height - 1;
            }
            this.drawBox(lX, hX, lY, hY, layerBitMap, desc, dimmed);
            return;
        }
        if (renderInfo.bounds.getMinX() >= (double)this.sz.width || renderInfo.bounds.getMaxX() < 0.0 || renderInfo.bounds.getMinY() >= (double)this.sz.height || renderInfo.bounds.getMaxY() < 0.0) {
            return;
        }
        Raster ras = PixelDrawing.renderText(renderInfo);
        if (ras == null) {
            return;
        }
        Point pt = PixelDrawing.getTextCorner(ras.getWidth(), ras.getHeight(), style, rect, rotation);
        int atX = pt.x;
        int atY = pt.y;
        DataBufferByte dbb = (DataBufferByte)ras.getDataBuffer();
        byte[] samples = dbb.getData();
        int rasWidth = ras.getWidth();
        int rasHeight = ras.getHeight();
        switch (rotation) {
            case 0: {
                int sx = atX < 0 ? -atX : 0;
                int ex = atX + rasWidth >= this.sz.width ? this.sz.width - 1 - atX : rasWidth;
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    int samp = y * rasWidth + sx;
                    for (int x = sx; x < ex; ++x) {
                        int alpha;
                        int trueX = atX + x;
                        if ((alpha = samples[samp++] & 0xFF) == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 1: {
                int sx = atX < 0 ? -atX : 0;
                int ex = atX >= this.sz.width ? this.sz.width - atX : rasHeight;
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY - y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[x * rasWidth + y] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 2: {
                atY -= rasHeight;
                int sx = (atX -= rasWidth) < 0 ? -atX : 0;
                int ex = atX + rasWidth >= this.sz.width ? this.sz.width - 1 - atX : rasWidth;
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[(rasHeight - y - 1) * rasWidth + (rasWidth - x - 1)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 3: {
                int sx = atX < 0 ? -atX : 0;
                int ex = atX >= this.sz.width ? this.sz.width - atX : rasHeight;
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX - x;
                        int alpha = samples[x * rasWidth + y] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
        }
    }

    private void drawText(Rectangle rect, Poly.Type style, TextDescriptor descript, String s, byte[] layerBitMap, byte layerBitMask) {
        ++texts;
    }

    private int alphaBlend(int color, int backgroundColor, int alpha) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int inverseAlpha = 254 - alpha;
        int redBack = backgroundColor >> 16 & 0xFF;
        int greenBack = backgroundColor >> 8 & 0xFF;
        int blueBack = backgroundColor & 0xFF;
        red = (red * alpha + redBack * inverseAlpha) / 255;
        green = (green * alpha + greenBack * inverseAlpha) / 255;
        blue = (blue * alpha + blueBack * inverseAlpha) / 255;
        color = red << 16 | (green << 8) + blue;
        return color;
    }

    private static Point getTextCorner(int rasterWidth, int rasterHeight, Poly.Type style, Rectangle rect, int rotation) {
        int textWidth = rasterWidth;
        int textHeight = rasterHeight;
        int offX = 0;
        int offY = 0;
        if (style == Poly.Type.TEXTCENT) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTTOP) {
            offX = -textWidth / 2;
        } else if (style == Poly.Type.TEXTBOT) {
            offX = -textWidth / 2;
            offY = -textHeight;
        } else if (style == Poly.Type.TEXTLEFT) {
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTRIGHT) {
            offX = -textWidth;
            offY = -textHeight / 2;
        } else if (style != Poly.Type.TEXTTOPLEFT) {
            if (style == Poly.Type.TEXTBOTLEFT) {
                offY = -textHeight;
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                offX = -textWidth;
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                offX = -textWidth;
                offY = -textHeight;
            }
        }
        if (style == Poly.Type.TEXTBOX) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        }
        if (rotation != 0) {
            int saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = offY;
                    offY = -saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = -offY;
                    offY = saveOffX;
                }
            }
        }
        int cX = (int)rect.getCenterX() + offX;
        int cY = (int)rect.getCenterY() + offY;
        return new Point(cX, cY);
    }

    public static Raster renderText(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline, int boxedWidth, int boxedHeight) {
        RenderTextInfo renderInfo = new RenderTextInfo();
        if (!renderInfo.buildInfo(msg, font, tSize, italic, bold, underline, new Rectangle(boxedWidth, boxedHeight), null, 0)) {
            return null;
        }
        return PixelDrawing.renderText(renderInfo);
    }

    private static Raster renderText(RenderTextInfo renderInfo) {
        Font theFont = renderInfo.font;
        if (theFont == null) {
            return null;
        }
        int width = (int)renderInfo.rasBounds.getWidth();
        int height = (int)renderInfo.rasBounds.getHeight();
        GlyphVector gv = renderInfo.gv;
        LineMetrics lm = renderInfo.lm;
        if (width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage textImage = new BufferedImage(width, height, 10);
        Graphics2D g2 = (Graphics2D)textImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(new Color(255, 255, 255));
        g2.drawGlyphVector(gv, (float)(-renderInfo.rasBounds.getX()), lm.getAscent() - lm.getLeading());
        if (renderInfo.underline) {
            g2.drawLine(0, height - 1, width, height - 1);
        }
        return textImage.getData();
    }

    public static Font getFont(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline) {
        Font theFont;
        int fontStyle = 0;
        if (italic) {
            fontStyle |= 2;
        }
        if (bold) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(font, fontStyle, tSize)) == null) {
            System.out.println("Could not find font " + font + " to render text: " + msg);
            return null;
        }
        return theFont;
    }

    void drawCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int x;
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        int y = radius;
        int d = 3 - 2 * radius;
        if (left >= 0 && right < this.sz.width && top >= 0 && bottom < this.sz.height) {
            for (x = 0; x <= y; ++x) {
                if (layerBitMap == null) {
                    int baseIndex = (center.y + y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y - y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y + x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                    baseIndex = (center.y - x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                } else {
                    byte[] row = layerBitMap[center.y + y];
                    int n = center.x + x >> 3;
                    row[n] = (byte)(row[n] | 1 << (center.x + x & 7));
                    int n2 = center.x - x >> 3;
                    row[n2] = (byte)(row[n2] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y - y];
                    int n3 = center.x + x >> 3;
                    row[n3] = (byte)(row[n3] | 1 << (center.x + x & 7));
                    int n4 = center.x - x >> 3;
                    row[n4] = (byte)(row[n4] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y + x];
                    int n5 = center.x + y >> 3;
                    row[n5] = (byte)(row[n5] | 1 << (center.x + y & 7));
                    int n6 = center.x - y >> 3;
                    row[n6] = (byte)(row[n6] | 1 << (center.x - y & 7));
                    row = layerBitMap[center.y - x];
                    int n7 = center.x + y >> 3;
                    row[n7] = (byte)(row[n7] | 1 << (center.x + y & 7));
                    int n8 = center.x - y >> 3;
                    row[n8] = (byte)(row[n8] | 1 << (center.x - y & 7));
                }
                if (d < 0) {
                    d += 4 * x + 6;
                    continue;
                }
                d += 4 * (x - y) + 10;
                --y;
            }
        } else {
            while (x <= y) {
                int thisx;
                int thisy = center.y + y;
                if (thisy >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if (d < 0) {
                    d += 4 * x + 6;
                } else {
                    d += 4 * (x - y) + 10;
                    --y;
                }
                ++x;
            }
        }
    }

    private void drawCircle(Point center, Point edge, byte[] layerBitMap, byte layerBitMask) {
        ++circles;
    }

    void drawThickCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            int thisx;
            int thisy = center.y + y;
            if (thisy >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private void drawThickCircle(Point center, Point edge, byte[] layerBitMap, byte layerBitMask) {
        ++thickCircles;
    }

    private void drawDiscRow(int thisy, int startx, int endx, byte[][] layerBitMap, int col, int[] pattern) {
        block12: {
            block11: {
                if (thisy < 0 || thisy >= this.sz.height) {
                    return;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (endx >= this.sz.width) {
                    endx = this.sz.width - 1;
                }
                if (pattern == null) break block11;
                int pat = pattern[thisy & 0xF];
                if (pat == 0) break block12;
                if (layerBitMap == null) {
                    int baseIndex = thisy * this.sz.width;
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        this.opaqueData[baseIndex + x] = col;
                    }
                } else {
                    byte[] row = layerBitMap[thisy];
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
                break block12;
            }
            if (layerBitMap == null) {
                int baseIndex = thisy * this.sz.width;
                for (int x = startx; x <= endx; ++x) {
                    int index = baseIndex + x;
                    int alpha = this.opaqueData[index] >> 24 & 0xFF;
                    if (alpha != 255) continue;
                    this.opaqueData[index] = col;
                }
            } else {
                byte[] row = layerBitMap[thisy];
                for (int x = startx; x <= endx; ++x) {
                    int n = x >> 3;
                    row[n] = (byte)(row[n] | 1 << (x & 7));
                }
            }
        }
    }

    void drawDisc(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int radius = (int)center.distance(edge);
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
                if (desc.getOutlined() != EGraphics.Outline.NOPAT) {
                    this.drawCircle(center, edge, layerBitMap, desc, dimmed);
                }
            }
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        if (radius == 1) {
            if (left < 0) {
                left = 0;
            }
            if (right >= this.sz.width) {
                right = this.sz.width - 1;
            }
            for (int y = top; y < bottom; ++y) {
                if (y < 0 || y >= this.sz.height) continue;
                for (int x = left; x < right; ++x) {
                    this.drawPoint(x, y, layerBitMap, col);
                }
            }
            return;
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            this.drawDiscRow(center.y + y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y + x, center.x - y, center.x + y, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - x, center.x - y, center.x + y, layerBitMap, col, pattern);
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private void drawDisc(Point center, Point edge, byte[] layerBitMap, byte layerBitMask) {
        ++discs;
    }

    private int arcFindOctant(int x, int y) {
        if (x > 0) {
            if (y >= 0) {
                if (y >= x) {
                    return 7;
                }
                return 8;
            }
            if (x >= -y) {
                return 1;
            }
            return 2;
        }
        if (y > 0) {
            if (y > -x) {
                return 6;
            }
            return 5;
        }
        if (y > x) {
            return 4;
        }
        return 3;
    }

    private Point arcXformOctant(int x, int y, int oct) {
        switch (oct) {
            case 1: {
                return new Point(-y, x);
            }
            case 2: {
                return new Point(x, -y);
            }
            case 3: {
                return new Point(-x, -y);
            }
            case 4: {
                return new Point(-y, -x);
            }
            case 5: {
                return new Point(y, -x);
            }
            case 6: {
                return new Point(-x, y);
            }
            case 7: {
                return new Point(x, y);
            }
            case 8: {
                return new Point(y, x);
            }
        }
        return null;
    }

    private void arcDoPixel(int x, int y) {
        if (x < 0 || x >= this.sz.width || y < 0 || y >= this.sz.height) {
            return;
        }
        if (this.arcThick) {
            this.drawThickPoint(x, y, this.arcLayerBitMap, this.arcCol);
        } else {
            this.drawPoint(x, y, this.arcLayerBitMap, this.arcCol);
        }
    }

    private void arcOutXform(int x, int y) {
        if (this.arcOctTable[1]) {
            this.arcDoPixel(y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[2]) {
            this.arcDoPixel(x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[3]) {
            this.arcDoPixel(-x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[4]) {
            this.arcDoPixel(-y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[5]) {
            this.arcDoPixel(-y + this.arcCenter.x, x + this.arcCenter.y);
        }
        if (this.arcOctTable[6]) {
            this.arcDoPixel(-x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[7]) {
            this.arcDoPixel(x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[8]) {
            this.arcDoPixel(y + this.arcCenter.x, x + this.arcCenter.y);
        }
    }

    private void arcBresCW(Point pt, Point pt1) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt1.x && pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        while (pt.x < pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.x;
        }
        while (pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            --pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void arcBresMidCW(Point pt) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        if (pt.x == pt.y) {
            this.arcOutXform(pt.x, pt.y);
        }
    }

    private void arcBresMidCCW(Point pt) {
        int d = 3 + 2 * pt.y - 4 * pt.x;
        while (pt.x > 0) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        this.arcOutXform(0, this.arcRadius);
    }

    private void arcBresCCW(Point pt, Point pt1) {
        int d = 3 + 2 * pt.y + 4 * pt.x;
        while (pt.x > pt1.x && pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        while (pt.x > pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            --pt.x;
        }
        while (pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    void drawCircleArc(Point center, Point p1, Point p2, boolean thick, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        this.arcLayerBitMap = layerBitMap;
        this.arcCol = 0;
        if (desc != null) {
            this.arcCol = this.getTheColor(desc, dimmed);
        }
        this.arcCenter = center;
        int pa_x = p2.x - this.arcCenter.x;
        int pa_y = p2.y - this.arcCenter.y;
        int pb_x = p1.x - this.arcCenter.x;
        int pb_y = p1.y - this.arcCenter.y;
        this.arcRadius = (int)this.arcCenter.distance(p2);
        int alternate = (int)this.arcCenter.distance(p1);
        int start_oct = this.arcFindOctant(pa_x, pa_y);
        int end_oct = this.arcFindOctant(pb_x, pb_y);
        this.arcThick = thick;
        if (this.arcRadius != alternate) {
            int diff = this.arcRadius - alternate;
            switch (end_oct) {
                case 6: 
                case 7: {
                    pb_y += diff;
                    break;
                }
                case 1: 
                case 8: {
                    pb_x += diff;
                    break;
                }
                case 2: 
                case 3: {
                    pb_y -= diff;
                    break;
                }
                case 4: 
                case 5: {
                    pb_x -= diff;
                }
            }
        }
        for (int i = 1; i < 9; ++i) {
            this.arcOctTable[i] = false;
        }
        if (start_oct == end_oct) {
            this.arcOctTable[start_oct] = true;
            Point pa = this.arcXformOctant(pa_x, pa_y, start_oct);
            Point pb = this.arcXformOctant(pb_x, pb_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresCW(pa, pb);
            } else {
                this.arcBresCCW(pa, pb);
            }
            this.arcOctTable[start_oct] = false;
        } else {
            this.arcOctTable[start_oct] = true;
            Point pt = this.arcXformOctant(pa_x, pa_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresMidCW(pt);
            } else {
                this.arcBresMidCCW(pt);
            }
            this.arcOctTable[start_oct] = false;
            this.arcOctTable[end_oct] = true;
            pt = this.arcXformOctant(pb_x, pb_y, end_oct);
            if ((end_oct & 1) != 0) {
                this.arcBresMidCCW(pt);
            } else {
                this.arcBresMidCW(pt);
            }
            this.arcOctTable[end_oct] = false;
            if (this.MODP(start_oct + 1) != end_oct) {
                if (this.MODP(start_oct + 1) == this.MODM(end_oct - 1)) {
                    this.arcOctTable[this.MODP((int)(start_oct + 1))] = true;
                } else {
                    int i = this.MODP(start_oct + 1);
                    while (i != end_oct) {
                        this.arcOctTable[i] = true;
                        i = this.MODP(i + 1);
                    }
                }
                this.arcBresMidCW(new Point(0, this.arcRadius));
            }
        }
    }

    private int MODM(int x) {
        return x < 1 ? x + 8 : x;
    }

    private int MODP(int x) {
        return x > 8 ? x - 8 : x;
    }

    private void drawCircleArc(Point center, Point p1, Point p2, boolean thick, byte[] layerBitMap, byte layerBitMask) {
        ++circleArcs;
    }

    void drawPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            this.opaqueData[y * this.sz.width + x] = col;
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private void drawPoint(int x, int y, byte[] layerBitMap, byte layerBitMask) {
        ++points;
        int n = y * this.width + x;
        layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
    }

    private void drawThickPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            int baseIndex = y * this.sz.width + x;
            this.opaqueData[baseIndex] = col;
            if (x > 0) {
                this.opaqueData[baseIndex - 1] = col;
            }
            if (x < this.sz.width - 1) {
                this.opaqueData[baseIndex + 1] = col;
            }
            if (y > 0) {
                this.opaqueData[baseIndex - this.sz.width] = col;
            }
            if (y < this.sz.height - 1) {
                this.opaqueData[baseIndex + this.sz.width] = col;
            }
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            if (x > 0) {
                byte[] byArray2 = layerBitMap[y];
                int n2 = x - 1 >> 3;
                byArray2[n2] = (byte)(byArray2[n2] | 1 << (x - 1 & 7));
            }
            if (x < this.sz.width - 1) {
                byte[] byArray3 = layerBitMap[y];
                int n3 = x + 1 >> 3;
                byArray3[n3] = (byte)(byArray3[n3] | 1 << (x + 1 & 7));
            }
            if (y > 0) {
                byte[] byArray4 = layerBitMap[y - 1];
                int n4 = x >> 3;
                byArray4[n4] = (byte)(byArray4[n4] | 1 << (x & 7));
            }
            if (y < this.sz.height - 1) {
                byte[] byArray5 = layerBitMap[y + 1];
                int n5 = x >> 3;
                byArray5[n5] = (byte)(byArray5[n5] | 1 << (x & 7));
            }
        }
    }

    private void drawThickPoint(int x, int y, byte[] layerBitMap, byte layerBitMask) {
        int baseIndex;
        ++thickPoints;
        int n = baseIndex = y * this.sz.width + x;
        layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
        if (x > this.clipLX) {
            int n2 = baseIndex - 1;
            layerBitMap[n2] = (byte)(layerBitMap[n2] | layerBitMask);
        }
        if (x < this.clipHX) {
            int n3 = baseIndex + 1;
            layerBitMap[n3] = (byte)(layerBitMap[n3] | layerBitMask);
        }
        if (y > this.clipLY) {
            int n4 = baseIndex - this.width;
            layerBitMap[n4] = (byte)(layerBitMap[n4] | layerBitMask);
        }
        if (y < this.sz.height - 1) {
            int n5 = baseIndex + this.width;
            layerBitMap[n5] = (byte)(layerBitMap[n5] | layerBitMask);
        }
    }

    private void databaseToScreen(double dbX, double dbY, Point result) {
        double scrX = this.originX + dbX * this.scale;
        double scrY = this.originY - dbY * this.scale;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    private Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.tempPt1;
        Point urPt = this.tempPt2;
        this.databaseToScreen(db.getMinX(), db.getMinY(), llPt);
        this.databaseToScreen(db.getMaxX(), db.getMaxY(), urPt);
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX + 1, screenHY - screenLY + 1);
    }

    static {
        techWithLayers = null;
        expandedCells = null;
        expandedScale = 0.0;
        noCellTextDescriptor = null;
        CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        textGraphics = new EGraphics(0, 0, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        gridGraphics = new EGraphics(0, 0, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        instanceGraphics = new EGraphics(0, 0, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        portGraphics = new EGraphics(0, 0, 0, 255, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    private static class RenderTextInfo {
        private Font font;
        private GlyphVector gv;
        private LineMetrics lm;
        private Point2D anchorPoint;
        private Rectangle2D rasBounds;
        private Rectangle2D bounds;
        private boolean underline;

        private RenderTextInfo() {
        }

        private boolean buildInfo(String msg, String fontName, int tSize, boolean italic, boolean bold, boolean underline, Rectangle probableBoxedBounds, Poly.Type style, int rotation) {
            this.font = PixelDrawing.getFont(msg, fontName, tSize, italic, bold, underline);
            this.underline = underline;
            FontRenderContext frc = new FontRenderContext(null, true, true);
            this.gv = this.font.createGlyphVector(frc, msg);
            this.lm = this.font.getLineMetrics(msg, frc);
            Rectangle2D rasRect = this.gv.getLogicalBounds();
            int width = (int)rasRect.getWidth();
            int height = (int)((double)this.lm.getHeight() + 0.5);
            if (width <= 0 || height <= 0) {
                return false;
            }
            int fontStyle = this.font.getStyle();
            int boxedWidth = (int)probableBoxedBounds.getWidth();
            int boxedHeight = (int)probableBoxedBounds.getHeight();
            if (boxedWidth > 1 && boxedHeight > 1 && (width > boxedWidth || height > boxedHeight)) {
                double scale = Math.min((double)boxedWidth / (double)width, (double)boxedHeight / (double)height);
                this.font = new Font(fontName, fontStyle, (int)((double)tSize * scale));
                if (this.font != null) {
                    this.gv = this.font.createGlyphVector(frc, msg);
                    this.lm = this.font.getLineMetrics(msg, frc);
                    rasRect = this.gv.getLogicalBounds();
                    height = (int)((double)this.lm.getHeight() + 0.5);
                    if (height <= 0) {
                        return false;
                    }
                    width = (int)rasRect.getWidth();
                }
            }
            if (underline) {
                ++height;
            }
            this.rasBounds = new Rectangle2D.Double(0.0, this.lm.getAscent() - this.lm.getLeading(), width, height);
            this.anchorPoint = PixelDrawing.getTextCorner(width, height, style, probableBoxedBounds, rotation);
            this.bounds = rotation == 1 || rotation == 3 ? new Rectangle2D.Double(this.anchorPoint.getX(), this.anchorPoint.getY(), height, width) : new Rectangle2D.Double(this.anchorPoint.getX(), this.anchorPoint.getY(), width, height);
            return true;
        }
    }

    private static class PatternedOpaqueLayer {
        private byte[][] bitMap;
        private byte[] compositeRow;

        private PatternedOpaqueLayer() {
        }

        static /* synthetic */ byte[][] access$002(PatternedOpaqueLayer x0, byte[][] x1) {
            x0.bitMap = x1;
            return x1;
        }
    }

    private static class ExpandedCellInfo {
        private boolean singleton = true;
        private int instanceCount;
        private PixelDrawing offscreen = null;

        ExpandedCellInfo() {
        }
    }

    private static class ExpandedCellKey {
        private Cell cell;
        private Orientation orient;

        private ExpandedCellKey(Cell cell, Orientation orient) {
            this.cell = cell;
            this.orient = orient;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExpandedCellKey) {
                ExpandedCellKey that = (ExpandedCellKey)obj;
                return this.cell == that.cell && this.orient.equals(that.orient);
            }
            return false;
        }

        public int hashCode() {
            return this.cell.hashCode() ^ this.orient.hashCode();
        }
    }

    private static class PolySeg {
        private int fx;
        private int fy;
        private int tx;
        private int ty;
        private int direction;
        private int increment;
        private PolySeg nextedge;
        private PolySeg nextactive;

        private PolySeg() {
        }
    }
}

