/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.sclibrary;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCLibraryGen {
    private String purpleLibraryName = "purpleFour";
    private String redLibraryName = "redFour";
    private String scLibraryName = "sclib";
    private Library purpleLibrary;
    private Library redLibrary;
    private Library scLibrary;
    private List<StdCellSpec> scellSpecs = new ArrayList<StdCellSpec>();
    private PrimitiveNode pin;
    private Variable.Key sizeKey;
    public static final Variable.Key STANDARDCELL = Variable.newKey("ATTR_StandardCell");
    private static final int blueColorIndex = EGraphics.makeIndex(Color.blue);

    public SCLibraryGen() {
        this.pin = Generic.tech.invisiblePinNode;
        this.sizeKey = Variable.findKey("ATTR_X");
    }

    public void setPurpleRedLibs(String purpleLibraryName, String redLibraryName) {
        this.purpleLibraryName = purpleLibraryName;
        this.redLibraryName = redLibraryName;
    }

    public void setOutputLibName(String name) {
        this.scLibraryName = name;
    }

    public void addStandardCell(String type, String sizes) {
        if ((sizes = sizes.trim()).equals("")) {
            return;
        }
        String[] ss = sizes.split("\\s+");
        double[] sss = new double[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            sss[i] = Double.parseDouble(ss[i]);
        }
        this.scellSpecs.add(new StdCellSpec(type, sss));
    }

    public boolean generate(StdCellParams sc) {
        this.purpleLibrary = Library.findLibrary(this.purpleLibraryName);
        if (this.purpleLibrary == null) {
            this.prErr("Purple library \"" + this.purpleLibraryName + "\" is not loaded.");
            return false;
        }
        this.redLibrary = Library.findLibrary(this.redLibraryName);
        if (this.redLibrary == null) {
            this.prErr("Red library \"" + this.redLibraryName + "\" is not loaded.");
            return false;
        }
        this.prMsg("Using purple library \"" + this.purpleLibraryName + "\" and red library \"" + this.redLibraryName + "\"");
        if (sc.getTechnology() == TechType.TSMC180) {
            this.scLibraryName = "sclibTSMC180";
        } else if (sc.getTechnology() == TechType.CMOS90) {
            this.scLibraryName = "sclibCMOS90";
        }
        this.scLibrary = Library.findLibrary(this.scLibraryName);
        if (this.scLibrary == null) {
            this.scLibrary = Library.newInstance(this.scLibraryName, null);
            this.prMsg("Created standard cell library " + this.scLibraryName);
        }
        this.prMsg("Using standard cell library " + this.scLibraryName);
        sc.enableNCC(this.purpleLibraryName);
        for (StdCellSpec stdcell : this.scellSpecs) {
            for (double d : stdcell.sizes) {
                Cell schcell;
                String cellname = sc.sizedName(stdcell.type, d);
                Cell laycell = this.scLibrary.findNodeProto((cellname = cellname.substring(0, cellname.indexOf(123))) + "{lay}");
                if (laycell == null && (laycell = GateLayoutGenerator.generateCell(this.scLibrary, sc, stdcell.type, d)) == null) {
                    this.prErr("Error creating layout cell " + stdcell.type + " of size " + d);
                    continue;
                }
                Cell iconcell = this.scLibrary.findNodeProto(cellname + "{ic}");
                if (iconcell == null) {
                    this.copyIconCell(stdcell.type, this.purpleLibrary, cellname, this.scLibrary, d);
                }
                if ((schcell = this.scLibrary.findNodeProto(cellname + "{sch}")) == null) {
                    this.copySchCell(stdcell.type, this.purpleLibrary, cellname, this.scLibrary, d);
                }
                schcell = this.scLibrary.findNodeProto(cellname + "{sch}");
                SCLibraryGen.markStandardCell(schcell);
            }
        }
        return true;
    }

    private boolean copyIconCell(String name, Library lib, String toName, Library toLib, double size) {
        Cell iconcell = toLib.findNodeProto(toName + "{ic}");
        Cell fromIconCell = lib.findNodeProto(name + "{ic}");
        if (iconcell == null && fromIconCell != null) {
            iconcell = Cell.copyNodeProto(fromIconCell, toLib, toName, false);
            if (iconcell == null) {
                this.prErr("Unable to copy purple cell " + fromIconCell.describe(false) + " to library " + toLib);
                return false;
            }
            NodeInst sizeni = NodeInst.makeInstance(this.pin, new EPoint(0.0, 0.0), 0.0, 0.0, iconcell);
            sizeni.newVar(Artwork.ART_MESSAGE, (Object)new Double(size), TextDescriptor.getAnnotationTextDescriptor().withColorIndex(blueColorIndex));
            Iterator<Geometric> it = iconcell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                ai.newVar(Artwork.ART_COLOR, (Object)new Integer(blueColorIndex));
            }
            it = iconcell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.newVar(Artwork.ART_COLOR, (Object)new Integer(blueColorIndex));
            }
        }
        return true;
    }

    private boolean copySchCell(String name, Library lib, String toName, Library toLib, double size) {
        Cell schcell = toLib.findNodeProto(toName + "{sch}");
        Cell fromSchCell = lib.findNodeProto(name + "{sch}");
        if (schcell == null && fromSchCell != null) {
            Cell np;
            NodeInst ni;
            Iterator<NodeInst> it;
            schcell = Cell.copyNodeProto(fromSchCell, toLib, toName, false);
            if (schcell == null) {
                this.prErr("Unable to copy purple cell " + fromSchCell.describe(false) + " to library " + toLib);
                return false;
            }
            Cell iconcell = toLib.findNodeProto(toName + "{ic}");
            Cell fromIconCell = lib.findNodeProto(name + "{ic}");
            if (iconcell != null && fromIconCell != null) {
                it = schcell.getNodes();
                while (it.hasNext()) {
                    ni = it.next();
                    if (!ni.isCellInstance() || (np = (Cell)ni.getProto()) != fromIconCell) continue;
                    ni.replace(iconcell, true, true);
                }
            }
            if (schcell.getVar(this.sizeKey) != null) {
                schcell.delVar(this.sizeKey);
            }
            it = schcell.getNodes();
            while (it.hasNext()) {
                Variable var;
                ni = it.next();
                if (!ni.isCellInstance()) continue;
                np = (Cell)ni.getProto();
                if (np.getLibrary() == this.redLibrary && (var = ni.getVar(this.sizeKey)) != null) {
                    ni.newVar(this.sizeKey, (Object)new Double(size), var.getTextDescriptor());
                }
                if (!np.isIconOf(schcell)) continue;
                ni.delVar(this.sizeKey);
            }
        }
        return true;
    }

    public static void markStandardCellJob(Cell cell) {
        CreateVar job = new CreateVar(cell, STANDARDCELL, new Integer(1));
        job.startJob();
    }

    public static void markStandardCell(Cell cell) {
        CreateVar job = new CreateVar(cell, STANDARDCELL, new Integer(1));
        job.doIt();
    }

    public static Set<Cell> getStandardCellsInHierarchy(Cell topCell) {
        TreeSet<Cell> cells = new TreeSet<Cell>();
        if (topCell.getView() == View.ICON) {
            topCell = topCell.getCellGroup().getMainSchematics();
        }
        Iterator<NodeInst> it = topCell.getNodes();
        while (it.hasNext()) {
            Cell subcell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || (subcell = (Cell)ni.getProto()).isIconOf(topCell)) continue;
            if (SCLibraryGen.isStandardCell(subcell.getCellGroup().getMainSchematics())) {
                cells.add(subcell.getCellGroup().getMainSchematics());
                continue;
            }
            cells.addAll(SCLibraryGen.getStandardCellsInHierarchy(subcell));
        }
        return cells;
    }

    public static boolean isStandardCell(Cell cell) {
        return cell.getVar(STANDARDCELL) != null;
    }

    private void prErr(String msg) {
        System.out.println("Standard Cell Library Generator Error: " + msg);
    }

    private void prMsg(String msg) {
        System.out.println("Standard Cell Library Generator: " + msg);
    }

    public static class CreateVar
    extends Job {
        private Cell cell;
        private Variable.Key key;
        private Object defaultVal;

        public CreateVar(Cell cell, Variable.Key key, Object defaultVal) {
            super("Create Var", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.key = key;
            this.defaultVal = defaultVal;
        }

        public boolean doIt() {
            TextDescriptor td = TextDescriptor.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            if (this.cell == null) {
                return false;
            }
            this.cell.newVar(this.key, this.defaultVal, td);
            return true;
        }
    }

    private static class StdCellSpec {
        private String type;
        private double[] sizes;

        private StdCellSpec(String type, double[] sizes) {
            this.type = type;
            this.sizes = sizes;
        }
    }
}

