/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StratPortName
extends Strategy {
    private int numWiresProcessed;
    private int numEquivProcessed;
    private Map<Wire, Integer> theMap;
    private boolean doneOne;

    private StratPortName(NccGlobals globals) {
        super(globals);
    }

    public static LeafList doYourJob(NccGlobals globals) {
        if (globals.getWires() == null) {
            return new LeafList();
        }
        StratPortName wn = new StratPortName(globals);
        wn.preamble();
        Iterator<EquivRecord> frontier = globals.getWireLeafEquivRecs().getNotMatched();
        LeafList ll = new LeafList();
        while (frontier.hasNext()) {
            ll.add(frontier.next());
        }
        LeafList el = wn.doFor(ll);
        wn.summary(el);
        return el;
    }

    private void preamble() {
        this.startTime("StratPortName", "all active Wires");
    }

    private void summary(LeafList offspring) {
        this.globals.status2("StratPortName processed " + this.numWiresProcessed + " Wires from " + this.numEquivProcessed + " EquivRecords");
        this.globals.status2(this.offspringStats(offspring));
        this.globals.status2(offspring.sizeInfoString());
        this.elapsedTime();
    }

    private void printTheMap(Map<Wire, Integer> m) {
        this.globals.status2("  printing an EquivRecord map of size= " + m.size());
        if (m.size() == 0) {
            return;
        }
        for (Wire w : m.keySet()) {
            Integer oo = m.get(w);
            if (oo == null) {
                this.globals.status2(" " + w.instanceDescription() + " maps to null");
                continue;
            }
            Integer i = oo;
            this.globals.status2(" " + w.instanceDescription() + " maps to " + i);
        }
    }

    private Map<String, Wire> getMapFromExportNamesToWires(Circuit wires) {
        HashMap<String, Wire> out = new HashMap<String, Wire>();
        Iterator<NetObject> it = wires.getNetObjs();
        while (it.hasNext()) {
            NetObject n = it.next();
            this.error(!(n instanceof Wire), "getExportMap expects only Wires");
            Wire w = (Wire)n;
            Port p = w.getPort();
            if (p == null || p.getToBeRenamed()) continue;
            Iterator<String> ni = p.getExportNames();
            while (ni.hasNext()) {
                String exportNm = ni.next();
                this.error(out.containsKey(exportNm), "different wires have the same export name?");
                out.put(exportNm, w);
            }
        }
        return out;
    }

    private Map<Wire, Integer> getWireExportMap(EquivRecord er) {
        ArrayList<Map<String, Wire>> mapPerCkt = new ArrayList<Map<String, Wire>>();
        HashSet<String> keys = new HashSet<String>();
        Iterator<Circuit> ci = er.getCircuits();
        while (ci.hasNext()) {
            Map<String, Wire> exportToWire = this.getMapFromExportNamesToWires(ci.next());
            mapPerCkt.add(exportToWire);
            keys.addAll(exportToWire.keySet());
        }
        if (keys.size() == 0) {
            return new HashMap<Wire, Integer>();
        }
        HashMap<Wire, Integer> out = new HashMap<Wire, Integer>();
        int i = 0;
        for (String key : keys) {
            ArrayList<Wire> wires = new ArrayList<Wire>();
            for (Map map : mapPerCkt) {
                if (!map.containsKey(key)) continue;
                Wire w = (Wire)map.get(key);
                wires.add(w);
            }
            if (wires.size() != mapPerCkt.size()) continue;
            ++i;
            for (Wire wire : wires) {
                out.put(wire, new Integer(i));
            }
        }
        this.printTheMap(out);
        return out;
    }

    @Override
    public LeafList doFor(RecordList g) {
        LeafList gg = (LeafList)g;
        gg.sortByIncreasingSize();
        return super.doFor(gg);
    }

    @Override
    public LeafList doFor(EquivRecord g) {
        LeafList out;
        if (g.isLeaf()) {
            EquivRecord er = g;
            if (this.doneOne) {
                return new LeafList();
            }
            ++this.numEquivProcessed;
            this.theMap = this.getWireExportMap(er);
            if (this.theMap.size() == 0) {
                return new LeafList();
            }
            this.doneOne = true;
            out = super.doFor(g);
            this.globals.status2(" processed " + g.nameString() + " with map size= " + this.theMap.size() + " yields " + out.size() + " offspring ");
        } else {
            out = super.doFor(g);
        }
        return out;
    }

    @Override
    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Wire), "StratPortName expects only Wires");
        ++this.numWiresProcessed;
        Wire w = (Wire)n;
        Integer i = this.theMap.get(w);
        return i != null ? i : new Integer(0);
    }
}

