/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.tecEdit.TechConversionResult;
import java.awt.geom.Dimension2D;
import java.util.Iterator;
import java.util.List;

public class NodeInfo
extends Info {
    String name;
    String abbrev;
    PrimitiveNode generated;
    PrimitiveNode.Function func = PrimitiveNode.Function.UNKNOWN;
    boolean serp;
    boolean arcsShrink;
    boolean square;
    boolean canBeZeroSize;
    boolean wipes;
    boolean lockable;
    boolean edgeSelect;
    boolean skipSizeInPalette;
    boolean notUsed;
    boolean lowVt;
    boolean highVt;
    boolean nativeBit;
    boolean od18;
    boolean od25;
    boolean od33;
    LayerDetails[] nodeLayers;
    PortDetails[] nodePortDetails;
    PrimitivePort[] primPorts;
    SizeOffset so;
    PrimitiveNode.NodeSizeRule nodeSizeRule;
    Dimension2D autoGrowth;
    int specialType;
    double[] specialValues;
    double xSize;
    double ySize;
    String spiceTemplate;
    static Info.SpecialTextDescr[] nodeTextTable = new Info.SpecialTextDescr[]{new Info.SpecialTextDescr(0.0, 18.0, 10), new Info.SpecialTextDescr(0.0, 15.0, 16), new Info.SpecialTextDescr(0.0, 12.0, 21), new Info.SpecialTextDescr(0.0, 9.0, 22), new Info.SpecialTextDescr(0.0, 6.0, 25), new Info.SpecialTextDescr(0.0, 3.0, 61)};

    NodeInfo() {
    }

    public static Cell[] getNodeCells(Library lib) {
        Library[] oneLib = new Library[]{lib};
        return NodeInfo.findCellSequence(oneLib, "node-", NODESEQUENCE_KEY);
    }

    void generate(Cell np) {
        NodeInfo.loadTableEntry(nodeTextTable, 10, (Object)this.func);
        NodeInfo.loadTableEntry(nodeTextTable, 16, new Boolean(this.serp));
        NodeInfo.loadTableEntry(nodeTextTable, 21, new Boolean(this.square));
        NodeInfo.loadTableEntry(nodeTextTable, 22, new Boolean(this.wipes));
        NodeInfo.loadTableEntry(nodeTextTable, 25, new Boolean(this.lockable));
        NodeInfo.loadTableEntry(nodeTextTable, 61, this.spiceTemplate);
        NodeInfo.createSpecialText(np, nodeTextTable);
    }

    static NodeInfo parseCell(Cell np) {
        NodeInfo nIn = new NodeInfo();
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Variable var = ni.getVar(OPTION_KEY);
            if (var == null) continue;
            String str = NodeInfo.getValueOnNode(ni);
            switch ((Integer)var.getObject()) {
                case 10: {
                    nIn.func = PrimitiveNode.Function.findName(str);
                    if (nIn.func != null) break;
                    nIn.func = PrimitiveNode.Function.UNKNOWN;
                    break;
                }
                case 21: {
                    nIn.square = str.equalsIgnoreCase("yes");
                    break;
                }
                case 22: {
                    nIn.wipes = str.equalsIgnoreCase("yes");
                    break;
                }
                case 25: {
                    nIn.lockable = str.equalsIgnoreCase("yes");
                    break;
                }
                case 16: {
                    nIn.serp = str.equalsIgnoreCase("yes");
                    break;
                }
                case 61: {
                    nIn.spiceTemplate = str;
                }
            }
        }
        return nIn;
    }

    static void compactCell(Cell cell) {
        TechConversionResult tcr = new TechConversionResult();
        List<Example> neList = Example.getExamples(cell, true, tcr);
        if (tcr.failed()) {
            tcr.showError();
        }
        if (neList == null || neList.size() == 0) {
            return;
        }
        Example firstEx = neList.get(0);
        int numExamples = neList.size();
        Example smallest = firstEx;
        Example biggest = firstEx;
        for (Example ne : neList) {
            if (!(ne.hx - ne.lx > biggest.hx - biggest.lx)) continue;
            biggest = ne;
        }
        if (numExamples == 1) {
            NodeInfo.moveExample(firstEx, -(firstEx.lx + firstEx.hx) / 2.0, -firstEx.hy);
            return;
        }
        if (numExamples != 4) {
            return;
        }
        Example stretchX = null;
        Example stretchY = null;
        for (Example ne : neList) {
            if (ne == biggest || ne == smallest) continue;
            if (stretchX == null) {
                stretchX = ne;
                continue;
            }
            if (stretchY != null) continue;
            stretchY = ne;
        }
        if (stretchX.hx - stretchX.lx < stretchY.hx - stretchY.lx) {
            Example swap = stretchX;
            stretchX = stretchY;
            stretchY = swap;
        }
        double separation = Math.min(smallest.hx - smallest.lx, smallest.hy - smallest.ly);
        double totalWid = stretchX.hx - stretchX.lx + (smallest.hx - smallest.lx) + separation;
        double totalHei = stretchY.hy - stretchY.ly + (smallest.hy - smallest.ly) + separation;
        double cX = -totalWid / 2.0 - smallest.lx;
        double cY = -smallest.hy - 1.0;
        NodeInfo.moveExample(smallest, cX, cY);
        cX = totalWid / 2.0 - stretchX.hx;
        cY = -stretchX.hy - 1.0;
        NodeInfo.moveExample(stretchX, cX, cY);
        cX = -totalWid / 2.0 - stretchY.lx;
        cY = -totalHei - stretchY.ly - 1.0;
        NodeInfo.moveExample(stretchY, cX, cY);
        cX = totalWid / 2.0 - biggest.hx;
        cY = -totalHei - biggest.ly - 1.0;
        NodeInfo.moveExample(biggest, cX, cY);
    }

    private static void moveExample(Example ne, double dX, double dY) {
        for (Sample ns : ne.samples) {
            ns.node.move(dX, dY);
        }
    }

    static class LayerDetails {
        LayerInfo layer;
        Poly.Type style;
        int representation;
        Technology.TechPoint[] values;
        Sample ns;
        int portIndex;
        boolean inLayers = true;
        boolean inElectricalLayers = true;
        boolean multiCut;
        double multiXS;
        double multiYS;
        double multiIndent;
        double multiSep;
        double multiSep2D;
        double lWidth;
        double rWidth;
        double extendT;
        double extendB;
        String message;
        TextDescriptor descriptor;

        public LayerDetails duplicate() {
            LayerDetails dup = new LayerDetails();
            dup.layer = this.layer;
            dup.style = this.style;
            dup.representation = this.representation;
            dup.values = new Technology.TechPoint[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                dup.values[i] = this.values[i].duplicate();
            }
            dup.ns = this.ns;
            dup.portIndex = this.portIndex;
            dup.inLayers = this.inLayers;
            dup.inElectricalLayers = this.inElectricalLayers;
            dup.multiCut = this.multiCut;
            dup.multiXS = this.multiXS;
            dup.multiYS = this.multiYS;
            dup.multiIndent = this.multiIndent;
            dup.multiSep = this.multiSep;
            dup.multiSep2D = this.multiSep2D;
            dup.lWidth = this.lWidth;
            dup.rWidth = this.rWidth;
            dup.extendT = this.extendT;
            dup.extendB = this.extendB;
            dup.message = this.message;
            dup.descriptor = this.descriptor;
            return dup;
        }
    }

    static class PortDetails {
        String name;
        ArcInfo[] connections;
        int angle;
        int range;
        int netIndex;
        Technology.TechPoint[] values;
        PortCharacteristic characterisitic;
        boolean isolated;
        boolean negatable;

        PortDetails() {
        }
    }
}

