/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.GDSLayers;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GDSTab
extends ProjSettingsPanel {
    private JList gdsLayersList;
    private DefaultListModel gdsLayersModel;
    private boolean changingGDS = false;
    private Setting gdsOutMergesBoxesSetting = IOTool.getGDSOutMergesBoxesSetting();
    private Setting gdsOutWritesExportPinsSetting = IOTool.getGDSOutWritesExportPinsSetting();
    private Setting gdsOutUpperCaseSetting = IOTool.getGDSOutUpperCaseSetting();
    private Setting gdsOutDefaultTextLayerSetting = IOTool.getGDSOutDefaultTextLayerSetting();
    private Setting gdsOutputConvertsBracketsInExportsSetting = IOTool.getGDSOutputConvertsBracketsInExportsSetting();
    private Setting gdsCellNameLenMaxSetting = IOTool.getGDSCellNameLenMaxSetting();
    private Setting gdsInputScaleSetting = IOTool.getGDSInputScaleSetting();
    private JComboBox foundrySelection;
    private JPanel gds;
    private JTextField gdsCellNameLenMax;
    private JTextField gdsDefaultTextLayer;
    private JLabel gdsFoundryName;
    private JTextField gdsInputScale;
    private JScrollPane gdsLayerList;
    private JTextField gdsLayerNumber;
    private JTextField gdsLayerType;
    private JCheckBox gdsOutputConvertsBracketsInExports;
    private JCheckBox gdsOutputMergesBoxes;
    private JCheckBox gdsOutputUpperCase;
    private JCheckBox gdsOutputWritesExportPins;
    private JTextField gdsPinLayer;
    private JTextField gdsPinType;
    private JTextField gdsTextLayer;
    private JTextField gdsTextType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JComboBox technologySelection;

    public GDSTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.gdsLayerNumber);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsLayerType);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsPinLayer);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsPinType);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsTextLayer);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsTextType);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsCellNameLenMax);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsDefaultTextLayer);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsInputScale);
    }

    public JPanel getPanel() {
        return this.gds;
    }

    public String getName() {
        return "GDS";
    }

    public void init() {
        this.gdsOutputMergesBoxes.setSelected(this.getBoolean(this.gdsOutMergesBoxesSetting));
        this.gdsOutputWritesExportPins.setSelected(this.getBoolean(this.gdsOutWritesExportPinsSetting));
        this.gdsOutputUpperCase.setSelected(this.getBoolean(this.gdsOutUpperCaseSetting));
        this.gdsDefaultTextLayer.setText(Integer.toString(this.getInt(this.gdsOutDefaultTextLayerSetting)));
        this.gdsOutputConvertsBracketsInExports.setSelected(this.getBoolean(this.gdsOutputConvertsBracketsInExportsSetting));
        this.gdsCellNameLenMax.setText(Integer.toString(this.getInt(this.gdsCellNameLenMaxSetting)));
        this.gdsInputScale.setText(TextUtils.formatDouble(this.getDouble(this.gdsInputScaleSetting)));
        this.gdsLayersModel = new DefaultListModel();
        this.gdsLayersList = new JList(this.gdsLayersModel);
        this.gdsLayersList.setSelectionMode(0);
        this.gdsLayerList.setViewportView(this.gdsLayersList);
        this.gdsLayersList.clearSelection();
        this.gdsLayersList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GDSTab.this.gdsClickLayer();
            }
        });
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.technologySelection.addItem(new TechGDSTab(tech));
        }
        this.technologySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.techChanged();
            }
        });
        this.technologySelection.setSelectedItem(Technology.getCurrent());
        this.foundrySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.foundryChanged();
            }
        });
        this.techChanged();
        GDSDocumentListener myDocumentListener = new GDSDocumentListener(this);
        this.gdsLayerNumber.getDocument().addDocumentListener(myDocumentListener);
        this.gdsLayerType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextType.getDocument().addDocumentListener(myDocumentListener);
    }

    private void foundryChanged() {
        Foundry foundry = (Foundry)this.foundrySelection.getSelectedItem();
        if (foundry == null) {
            return;
        }
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        this.gdsLayersModel.clear();
        Iterator<Layer> lIt = tech.getLayers();
        while (lIt.hasNext()) {
            Layer layer = lIt.next();
            String str = layer.getName();
            String gdsLayer = this.getString(foundry.getGDSLayerSetting(layer));
            if (gdsLayer != null && gdsLayer.length() > 0) {
                str = str + " (" + gdsLayer + ")";
            }
            this.gdsLayersModel.addElement(str);
        }
        this.gdsLayersList.setSelectedIndex(0);
        this.gdsClickLayer();
    }

    private void setFoundries(Technology tech) {
        this.foundrySelection.removeAllItems();
        Iterator<Foundry> itF = tech.getFoundries();
        while (itF.hasNext()) {
            this.foundrySelection.addItem(itF.next());
        }
        this.foundrySelection.setSelectedItem(tech.getSelectedFoundry());
        this.foundryChanged();
    }

    private void techChanged() {
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        if (tech == null) {
            return;
        }
        this.setFoundries(tech);
    }

    private void gdsClickLayer() {
        this.changingGDS = true;
        String str = (String)this.gdsLayersList.getSelectedValue();
        GDSLayers numbers = this.gdsGetNumbers(str);
        if (numbers == null) {
            numbers = GDSLayers.EMPTY;
        }
        if (numbers.getNumLayers() == 0) {
            this.gdsLayerNumber.setText("");
            this.gdsLayerType.setText("");
        } else {
            Integer gdsValue = numbers.getFirstLayer();
            int layerNum = gdsValue & 0xFFFF;
            int layerType = gdsValue >> 16 & 0xFFFF;
            this.gdsLayerNumber.setText(Integer.toString(layerNum));
            this.gdsLayerType.setText(Integer.toString(layerType));
        }
        if (numbers.getPinLayer() == -1) {
            this.gdsPinLayer.setText("");
            this.gdsPinType.setText("");
        } else {
            this.gdsPinLayer.setText(Integer.toString(numbers.getPinLayer() & 0xFFFF));
            this.gdsPinType.setText(Integer.toString(numbers.getPinLayer() >> 16 & 0xFFFF));
        }
        if (numbers.getTextLayer() == -1) {
            this.gdsTextLayer.setText("");
            this.gdsTextType.setText("");
        } else {
            this.gdsTextLayer.setText(Integer.toString(numbers.getTextLayer() & 0xFFFF));
            this.gdsTextType.setText(Integer.toString(numbers.getTextLayer() >> 16 & 0xFFFF));
        }
        this.changingGDS = false;
    }

    private GDSLayers gdsGetNumbers(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        int closeParen = str.lastIndexOf(41);
        if (closeParen < 0) {
            return null;
        }
        String gdsNumbers = str.substring(openParen + 1, closeParen);
        GDSLayers numbers = GDSLayers.parseLayerString(gdsNumbers);
        return numbers;
    }

    private Layer gdsGetLayer(String str) {
        int openParen = str.indexOf(40);
        String layerName = openParen >= 0 ? str.substring(0, openParen - 1) : str;
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        if (tech == null) {
            return null;
        }
        Layer layer = tech.findLayer(layerName);
        return layer;
    }

    private void gdsNumbersChanged() {
        if (this.changingGDS) {
            return;
        }
        String str = (String)this.gdsLayersList.getSelectedValue();
        Layer layer = this.gdsGetLayer(str);
        if (layer == null) {
            return;
        }
        String newLine = this.gdsLayerNumber.getText().trim();
        int layerType = TextUtils.atoi(this.gdsLayerType.getText().trim());
        if (layerType != 0) {
            newLine = newLine + "/" + layerType;
        }
        String pinLayer = this.gdsPinLayer.getText().trim();
        int pinType = TextUtils.atoi(this.gdsPinType.getText().trim());
        if (pinLayer.length() > 0 || pinType != 0) {
            newLine = newLine + "," + pinLayer;
            if (pinType != 0) {
                newLine = newLine + "/" + pinType;
            }
            newLine = newLine + "p";
        }
        String textLayer = this.gdsTextLayer.getText().trim();
        int textType = TextUtils.atoi(this.gdsTextType.getText().trim());
        if (textLayer.length() > 0 || textType != 0) {
            newLine = newLine + "," + textLayer;
            if (textType != 0) {
                newLine = newLine + "/" + textType;
            }
            newLine = newLine + "t";
        }
        String wholeLine = layer.getName();
        if (newLine.length() > 0) {
            wholeLine = wholeLine + " (" + newLine + ")";
        }
        int index = this.gdsLayersList.getSelectedIndex();
        this.gdsLayersModel.set(index, wholeLine);
        Foundry foundry = (Foundry)this.foundrySelection.getSelectedItem();
        this.setString(foundry.getGDSLayerSetting(layer), newLine);
    }

    public void term() {
        this.setBoolean(this.gdsOutMergesBoxesSetting, this.gdsOutputMergesBoxes.isSelected());
        this.setBoolean(this.gdsOutWritesExportPinsSetting, this.gdsOutputWritesExportPins.isSelected());
        this.setBoolean(this.gdsOutUpperCaseSetting, this.gdsOutputUpperCase.isSelected());
        this.setInt(this.gdsOutDefaultTextLayerSetting, TextUtils.atoi(this.gdsDefaultTextLayer.getText()));
        this.setBoolean(this.gdsOutputConvertsBracketsInExportsSetting, this.gdsOutputConvertsBracketsInExports.isSelected());
        this.setInt(this.gdsCellNameLenMaxSetting, TextUtils.atoi(this.gdsCellNameLenMax.getText()));
        this.setDouble(this.gdsInputScaleSetting, TextUtils.atof(this.gdsInputScale.getText()));
    }

    private void initComponents() {
        this.gds = new JPanel();
        this.gdsLayerList = new JScrollPane();
        this.jLabel6 = new JLabel();
        this.gdsLayerNumber = new JTextField();
        this.jLabel7 = new JLabel();
        this.gdsPinLayer = new JTextField();
        this.jLabel8 = new JLabel();
        this.gdsTextLayer = new JTextField();
        this.gdsOutputMergesBoxes = new JCheckBox();
        this.gdsOutputWritesExportPins = new JCheckBox();
        this.gdsOutputUpperCase = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.gdsDefaultTextLayer = new JTextField();
        this.jLabel29 = new JLabel();
        this.gdsOutputConvertsBracketsInExports = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.gdsLayerType = new JTextField();
        this.gdsPinType = new JTextField();
        this.gdsTextType = new JTextField();
        this.jLabel3 = new JLabel();
        this.gdsCellNameLenMax = new JTextField();
        this.technologySelection = new JComboBox();
        this.jLabel4 = new JLabel();
        this.gdsFoundryName = new JLabel();
        this.foundrySelection = new JComboBox();
        this.jLabel5 = new JLabel();
        this.gdsInputScale = new JTextField();
        this.jLabel10 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GDSTab.this.closeDialog(evt);
            }
        });
        this.gds.setLayout(new GridBagLayout());
        this.gdsLayerList.setMinimumSize(new Dimension(200, 200));
        this.gdsLayerList.setOpaque(false);
        this.gdsLayerList.setPreferredSize(new Dimension(200, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerList, gridBagConstraints);
        this.jLabel6.setText("Normal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel6, gridBagConstraints);
        this.gdsLayerNumber.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerNumber, gridBagConstraints);
        this.jLabel7.setText("Pin:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel7, gridBagConstraints);
        this.gdsPinLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsPinLayer, gridBagConstraints);
        this.jLabel8.setText("Text:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel8, gridBagConstraints);
        this.gdsTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTextLayer, gridBagConstraints);
        this.gdsOutputMergesBoxes.setText("Output merges Boxes (slow)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputMergesBoxes, gridBagConstraints);
        this.gdsOutputWritesExportPins.setText("Output writes export Pins");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputWritesExportPins, gridBagConstraints);
        this.gdsOutputUpperCase.setText("Output all upper-case");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputUpperCase, gridBagConstraints);
        this.jLabel9.setText("Output default text layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.jLabel9, gridBagConstraints);
        this.gdsDefaultTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsDefaultTextLayer, gridBagConstraints);
        this.jLabel29.setText("Blank layer values generate no GDS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 8, 4);
        this.gds.add((Component)this.jLabel29, gridBagConstraints);
        this.gdsOutputConvertsBracketsInExports.setText("Output converts brackets in exports");
        this.gdsOutputConvertsBracketsInExports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.gdsOutputConvertsBracketsInExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputConvertsBracketsInExports, gridBagConstraints);
        this.jLabel1.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.gds.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.gds.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsPinType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTextType, gridBagConstraints);
        this.jLabel3.setText("Max chars in output cell name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsCellNameLenMax, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.gds.add((Component)this.technologySelection, gridBagConstraints);
        this.jLabel4.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.gds.add((Component)this.jLabel4, gridBagConstraints);
        this.gdsFoundryName.setText("Foundry:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.gds.add((Component)this.gdsFoundryName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.gds.add((Component)this.foundrySelection, gridBagConstraints);
        this.jLabel5.setText("Scale by:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 4, 4, 2);
        this.gds.add((Component)this.jLabel5, gridBagConstraints);
        this.gdsInputScale.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(8, 2, 4, 2);
        this.gds.add((Component)this.gdsInputScale, gridBagConstraints);
        this.jLabel10.setText("when reading");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 2, 4, 4);
        this.gds.add((Component)this.jLabel10, gridBagConstraints);
        this.getContentPane().add((Component)this.gds, new GridBagConstraints());
        this.pack();
    }

    private void gdsOutputConvertsBracketsInExportsActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class GDSDocumentListener
    implements DocumentListener {
        GDSTab dialog;

        GDSDocumentListener(GDSTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }
    }

    private static class TechGDSTab {
        public Technology tech;

        TechGDSTab(Technology t) {
            this.tech = t;
        }

        public String toString() {
            return this.tech.getTechName();
        }
    }
}

