/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.AbstractToolSettings;

public class ToolSettings
extends AbstractToolSettings {
    private static ToolSettings t = new ToolSettings(null);
    private Setting.Group curXmlGroup;
    private String curPrefGroup;
    private final Setting cacheDefaultTechnology;
    private final Setting cacheSchematicTechnology;
    private final Setting cacheIncludeDateAndVersionInOutput;
    private final Setting cachePSubstrateProcess;
    private final Setting cacheSoftTechnologies;
    private final Setting cacheIgnoreResistors;
    private final Setting cacheUseCopyrightMessage;
    private final Setting cacheCopyrightMessage;
    private final Setting cacheCIFMimicsDisplay;
    private final Setting cacheCIFMergesBoxes;
    private final Setting cacheCIFInstantiatesTopLevel;
    private final Setting cacheCIFOutScaleFactor;
    private final Setting cacheGDSMergesBoxes;
    private final Setting cacheGDSWritesExportPins;
    private final Setting cacheGDSOutputUpperCase;
    private final Setting cacheGDSOutputWriteExportCharacteristics;
    private final Setting cacheGDSDefaultTextLayer;
    private final Setting cacheGDSOutputConvertsBracketsInExports;
    private final Setting cacheGDSCellNameLenMax;
    private final Setting cacheGDSInputScale;
    private final Setting cacheGDSOutputScale;
    private final Setting cacheDXFScale;
    private static final double DEFAULT_GLOBALFANOUT = 4.7;
    private static final double DEFAULT_EPSILON = 0.001;
    private static final int DEFAULT_MAXITER = 30;
    private static final double DEFAULT_KEEPERRATIO = 0.1;
    private static final double DEFAULT_X1INVERTER_NWIDTH = 3.0;
    private static final double DEFAULT_X1INVERTER_PWIDTH = 6.0;
    private static final double DEFAULT_X1INVERTER_LENGTH = 2.0;
    private final Setting cacheUseLocalSettings;
    private final Setting cacheGlobalFanout;
    private final Setting cacheConvergenceEpsilon;
    private final Setting cacheMaxIterations;
    private final Setting cacheKeeperRatio;
    private final Setting cacheX1InverterNWidth;
    private final Setting cacheX1InverterPWidth;
    private final Setting cacheX1InverterLength;
    private final Setting cacheVerilogUseAssign;
    private final Setting cacheVerilogUseTrireg;
    private final Setting cachefoundry;
    private final Setting cacheenableNCC;
    private final Setting cachequantError;
    private final Setting cachemaxmos;
    private final Setting cachevddy;
    private final Setting cachegndy;
    private final Setting cachenheight;
    private final Setting cachepheight;
    private final Setting cachesimpleName;
    private final Setting cacheGlobalSDCCommandsMAX;
    private final Setting cacheGlobalSDCCommandsMIN;
    private final Setting cacheNumWorstPaths;

    public static Setting.Group getToolSettings(String groupName) {
        return ToolSettings.t.rootSettingGroup.node(groupName);
    }

    public static Setting getDefaultTechnologySetting() {
        return ToolSettings.t.cacheDefaultTechnology;
    }

    public static Setting getSchematicTechnologySetting() {
        return ToolSettings.t.cacheSchematicTechnology;
    }

    public static Setting getIncludeDateAndVersionInOutputSetting() {
        return ToolSettings.t.cacheIncludeDateAndVersionInOutput;
    }

    public static Setting getPSubstrateProcessLayoutTechnologySetting() {
        return ToolSettings.t.cachePSubstrateProcess;
    }

    public static Setting getSoftTechnologiesSetting() {
        return ToolSettings.t.cacheSoftTechnologies;
    }

    public static Setting getIgnoreResistorsSetting() {
        return ToolSettings.t.cacheIgnoreResistors;
    }

    public static Setting getUseCopyrightMessageSetting() {
        return ToolSettings.t.cacheUseCopyrightMessage;
    }

    public static Setting getCopyrightMessageSetting() {
        return ToolSettings.t.cacheCopyrightMessage;
    }

    public static Setting getCIFOutMimicsDisplaySetting() {
        return ToolSettings.t.cacheCIFMimicsDisplay;
    }

    public static Setting getCIFOutMergesBoxesSetting() {
        return ToolSettings.t.cacheCIFMergesBoxes;
    }

    public static Setting getCIFOutInstantiatesTopLevelSetting() {
        return ToolSettings.t.cacheCIFInstantiatesTopLevel;
    }

    public static Setting getCIFOutScaleFactor() {
        return ToolSettings.t.cacheCIFOutScaleFactor;
    }

    public static Setting getGDSOutMergesBoxesSetting() {
        return ToolSettings.t.cacheGDSMergesBoxes;
    }

    public static Setting getGDSOutWritesExportPinsSetting() {
        return ToolSettings.t.cacheGDSWritesExportPins;
    }

    public static Setting getGDSOutUpperCaseSetting() {
        return ToolSettings.t.cacheGDSOutputUpperCase;
    }

    public static Setting getGDSOutWriteExportChacteristicsSetting() {
        return ToolSettings.t.cacheGDSOutputWriteExportCharacteristics;
    }

    public static Setting getGDSDefaultTextLayerSetting() {
        return ToolSettings.t.cacheGDSDefaultTextLayer;
    }

    public static Setting getGDSOutputConvertsBracketsInExportsSetting() {
        return ToolSettings.t.cacheGDSOutputConvertsBracketsInExports;
    }

    public static Setting getGDSCellNameLenMaxSetting() {
        return ToolSettings.t.cacheGDSCellNameLenMax;
    }

    public static Setting getGDSInputScaleSetting() {
        return ToolSettings.t.cacheGDSInputScale;
    }

    public static Setting getGDSOutputScaleSetting() {
        return ToolSettings.t.cacheGDSOutputScale;
    }

    public static Setting getDXFScaleSetting() {
        return ToolSettings.t.cacheDXFScale;
    }

    public static Setting getUseLocalSettingsSetting() {
        return ToolSettings.t.cacheUseLocalSettings;
    }

    public static Setting getGlobalFanoutSetting() {
        return ToolSettings.t.cacheGlobalFanout;
    }

    public static Setting getConvergenceEpsilonSetting() {
        return ToolSettings.t.cacheConvergenceEpsilon;
    }

    public static Setting getMaxIterationsSetting() {
        return ToolSettings.t.cacheMaxIterations;
    }

    public static Setting getKeeperRatioSetting() {
        return ToolSettings.t.cacheKeeperRatio;
    }

    public static Setting getX1InverterNWidthSetting() {
        return ToolSettings.t.cacheX1InverterNWidth;
    }

    public static Setting getX1InverterPWidthSetting() {
        return ToolSettings.t.cacheX1InverterPWidth;
    }

    public static Setting getX1InverterLengthSetting() {
        return ToolSettings.t.cacheX1InverterLength;
    }

    public static Setting getVerilogUseAssignSetting() {
        return ToolSettings.t.cacheVerilogUseAssign;
    }

    public static Setting getVerilogUseTriregSetting() {
        return ToolSettings.t.cacheVerilogUseTrireg;
    }

    public static Setting getFoundrySetting() {
        return ToolSettings.t.cachefoundry;
    }

    public static Setting getEnableNCCSetting() {
        return ToolSettings.t.cacheenableNCC;
    }

    public static Setting getSizeQuantizationErrorSetting() {
        return ToolSettings.t.cachequantError;
    }

    public static Setting getMaxMosWidthSetting() {
        return ToolSettings.t.cachemaxmos;
    }

    public static Setting getVddYSetting() {
        return ToolSettings.t.cachevddy;
    }

    public static Setting getGndYSetting() {
        return ToolSettings.t.cachegndy;
    }

    public static Setting getNmosWellHeightSetting() {
        return ToolSettings.t.cachenheight;
    }

    public static Setting getPmosWellHeightSetting() {
        return ToolSettings.t.cachepheight;
    }

    public static Setting getSimpleNameSetting() {
        return ToolSettings.t.cachesimpleName;
    }

    public static Setting getGlobalSDCCommandsMAXSetting() {
        return ToolSettings.t.cacheGlobalSDCCommandsMAX;
    }

    public static Setting getGlobalSDCCommandsMINSetting() {
        return ToolSettings.t.cacheGlobalSDCCommandsMIN;
    }

    public static Setting getNumWorstPathsSetting() {
        return ToolSettings.t.cacheNumWorstPaths;
    }

    public static void attachToGroup(Setting.RootGroup rootSettingGroup) {
        t = new ToolSettings(rootSettingGroup);
    }

    private ToolSettings(Setting.RootGroup rootSettingGroup) {
        super(rootSettingGroup);
        this.tool("userTool", "tool/user");
        this.cacheDefaultTechnology = this.makeStringSetting("DefaultTechnology", "Technology tab", "Default Technology for editing", "mocmos");
        this.cacheSchematicTechnology = this.makeStringSetting("SchematicTechnology", "Technology tab", "Schematics use scale values from this technology", "mocmos");
        this.cacheIncludeDateAndVersionInOutput = this.makeBooleanSetting("IncludeDateAndVersionInOutput", "Netlists tab", "Include date and version in output", true);
        this.cachePSubstrateProcess = this.makeBooleanSetting("PSubstrateProcess", "Technology tab", "Define Layout Technology as a PSubstrate process", true);
        this.cacheSoftTechnologies = this.makeStringSetting("SoftTechnologies", "Technology tab", "A list of added Xml Technologies", "");
        this.tool("networkTool", "database/network");
        this.cacheIgnoreResistors = this.makeBooleanSetting("IgnoreResistors", "Netlists tab", "Networks ignore Resistors", false);
        this.tool("compactionTool", "tool/compaction");
        this.tool("drcTool", "tool/drc");
        this.tool("ercTool", "tool/erc");
        this.tool("extractTool", "tool/extract");
        this.tool("ioTool", "tool/io");
        this.cacheUseCopyrightMessage = this.makeBooleanSetting("UseCopyrightMessage", "Netlists tab", "Use copyright message", false);
        this.cacheCopyrightMessage = this.makeStringSetting("CopyrightMessage", "Netlists tab", "Copyright message", "");
        this.cacheCIFMimicsDisplay = this.makeBooleanSetting("CIFMimicsDisplay", "CIF tab", "CIF output mimics display", false);
        this.cacheCIFMergesBoxes = this.makeBooleanSetting("CIFMergesBoxes", "CIF tab", "CIF output merges boxes", false);
        this.cacheCIFInstantiatesTopLevel = this.makeBooleanSetting("CIFInstantiatesTopLevel", "CIF tab", "CIF output instantiates top level", true);
        this.cacheCIFOutScaleFactor = this.makeIntSetting("CIFOutScaleFactor", "CIF tab", "CIF output scale factor", 1);
        this.cacheGDSMergesBoxes = this.makeBooleanSetting("GDSMergesBoxes", "GDS tab", "GDS output merges boxes", false);
        this.cacheGDSWritesExportPins = this.makeBooleanSetting("GDSWritesExportPins", "GDS tab", "GDS output writes export pins", false);
        this.cacheGDSOutputUpperCase = this.makeBooleanSetting("GDSOutputUpperCase", "GDS tab", "GDS output all upper-case", false);
        this.cacheGDSOutputWriteExportCharacteristics = this.makeBooleanSetting("GDSOutputWriteExportCharacteristics", "GDS tab", "GDS output writes export characteristics", true);
        this.cacheGDSDefaultTextLayer = this.makeIntSetting("GDSDefaultTextLayer", "GDS tab", "GDS output default text layer", 230);
        this.cacheGDSOutputConvertsBracketsInExports = this.makeBooleanSetting("GDSOutputConvertsBracketsInExports", "GDS tab", "GDS output converts brackets in exports", true);
        this.cacheGDSCellNameLenMax = this.makeIntSetting("GDSCellNameLenMax", "GDS tab", "GDS name length limit", 32);
        this.cacheGDSInputScale = this.makeDoubleSetting("GDSInputScale", "GDS tab", "GDS input scale", 1.0);
        this.cacheGDSOutputScale = this.makeDoubleSetting("GDSOutputScale", "GDS tab", "GDS output scale", 1.0);
        this.cacheDXFScale = this.makeIntSetting("DXFScale", "DXF tab", "DXF scale factor", 2);
        this.tool("logeffortTool", "tool/logicaleffort");
        this.cacheUseLocalSettings = this.makeBooleanSetting("UseLocalSettings", "Logical Effort Tab", "Use Local Settings from Cell", true);
        this.cacheGlobalFanout = this.makeDoubleSetting("GlobalFanout", "Logical Effort Tab", "Global Fanout", 4.7);
        this.cacheConvergenceEpsilon = this.makeDoubleSetting("ConvergenceEpsilon", "Logical Effort Tab", "Convergence Epsilon", 0.001);
        this.cacheMaxIterations = this.makeIntSetting("MaxIterations", "Logical Effort Tab", "Maximum Iterations", 30);
        this.cacheKeeperRatio = this.makeDoubleSetting("KeeperRatio", "Logical Effort Tab", "Keeper Ratio", 0.1);
        this.cacheX1InverterNWidth = this.makeDoubleSetting("X1InverterNWidth", "Logical Effort Tab", "X=1 Inverter N Width", 3.0);
        this.cacheX1InverterPWidth = this.makeDoubleSetting("X1InverterPWidth", "Logical Effort Tab", "X=1 Inverter P Width", 6.0);
        this.cacheX1InverterLength = this.makeDoubleSetting("X1InverterLength", "Logical Effort Tab", "X=1 Inverter Lengths", 2.0);
        this.tool("parasiticTool", "tool/extract");
        this.tool("placementTool", "tool/placement");
        this.tool("projectTool", "tool/project");
        this.tool("routingTool", "tool/routing");
        this.tool("scTool", "tool/sc");
        this.tool("simulationTool", "tool/simulation");
        this.cacheVerilogUseAssign = this.makeBooleanSetting("VerilogUseAssign", "Verilog tab", "Verilog uses Assign construct", false);
        this.cacheVerilogUseTrireg = this.makeBooleanSetting("VerilogUseTrireg", "Verilog tab", "Verilog presumes wire is Trireg", false);
        this.tool("coverageTool", "tool/extract");
        this.tool("GateLayoutGenerator", "tool/generator/layout");
        this.cachefoundry = this.makeStringSetting("foundry", "Gate Layout Generator Tab", "Foundry", "MOCMOS");
        this.cacheenableNCC = this.makeStringSetting("enableNCC", "Gate Layout Generator Tab", "Enable NCC checking of layout", "purpleFour");
        this.cachequantError = this.makeIntSetting("quantError", "Gate Layout Generator Tab", "Allowable quantization error", 0);
        this.cachemaxmos = this.makeIntSetting("maxmos", "Gate Layout Generator Tab", "Maximum width of MOS transistors", 1000);
        this.cachevddy = this.makeIntSetting("vddy", "Gate Layout Generator Tab", "Y coordinate of VDD bus", 21);
        this.cachegndy = this.makeIntSetting("gndy", "Gate Layout Generator Tab", "Y coordinate of GND bus", -21);
        this.cachenheight = this.makeIntSetting("nheight", "Gate Layout Generator Tab", "Height of Nwell", 84);
        this.cachepheight = this.makeIntSetting("pheight", "Gate Layout Generator Tab", "Height of Pwell", 84);
        this.cachesimpleName = this.makeBooleanSetting("simpleName", "Gate Layout Generator Tab", "Name is gate type plus size", true);
        this.tool("Fill GeneratorTool", "tool/generator/layout/fill");
        this.tool("CVSTool", "tool/cvspm");
        this.tool("STATool", "plugins/sctiming");
        this.cacheGlobalSDCCommandsMAX = this.makeStringSetting("GlobalSDCCommands", "Static Timing Analysis Tab", "Global SDC Constraints (MAX)", "");
        this.cacheGlobalSDCCommandsMIN = this.makeStringSetting("GlobalSDCCommandsMIN", "Static Timing Analysis Tab", "Global SDC Constraints (MIN)", "");
        this.cacheNumWorstPaths = this.makeIntSetting("NumWorstPaths", "Static Timing Analysis Tab", "Num Worst Paths", 10);
        this.curXmlGroup = null;
        this.curPrefGroup = null;
        this.rootSettingGroup.lock();
    }

    private void tool(String xmlPath, String prefPath) {
        this.curXmlGroup = this.rootSettingGroup.node(xmlPath);
        this.curPrefGroup = prefPath;
    }

    private Setting makeBooleanSetting(String name, String location, String description, boolean factory) {
        if (this.attach) {
            return this.findSetting(name, location, description, factory);
        }
        return this.curXmlGroup.makeBooleanSetting(name, this.curPrefGroup, name, location, description, factory);
    }

    private Setting makeIntSetting(String name, String location, String description, int factory) {
        if (this.attach) {
            return this.findSetting(name, location, description, factory);
        }
        return this.curXmlGroup.makeIntSetting(name, this.curPrefGroup, name, location, description, factory, new String[0]);
    }

    private Setting makeLongSetting(String name, String location, String description, long factory) {
        if (this.attach) {
            return this.findSetting(name, location, description, factory);
        }
        return this.curXmlGroup.makeLongSetting(name, this.curPrefGroup, name, location, description, factory);
    }

    private Setting makeDoubleSetting(String name, String location, String description, double factory) {
        if (this.attach) {
            return this.findSetting(name, location, description, factory);
        }
        return this.curXmlGroup.makeDoubleSetting(name, this.curPrefGroup, name, location, description, factory);
    }

    private Setting makeStringSetting(String name, String location, String description, String factory) {
        if (this.attach) {
            return this.findSetting(name, location, description, factory);
        }
        return this.curXmlGroup.makeStringSetting(name, this.curPrefGroup, name, location, description, factory);
    }

    private Setting findSetting(String name, String location, String description, Object factory) {
        Setting setting = this.curXmlGroup.getSetting(name);
        assert (setting.getPrefPath().equals(this.curPrefGroup + "/" + name));
        assert (setting.getLocation().equals(location));
        assert (setting.getDescription().equals(description));
        assert (setting.getFactoryValue().equals(factory));
        return setting;
    }
}

