/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.TechType;

public class TechTypeMoCMOS
extends TechType {
    private static final long serialVersionUID = 0L;
    private static boolean singletonCreated = false;

    public TechTypeMoCMOS() {
        super(Technology.getMocmosTechnology());
        if (singletonCreated) {
            throw new RuntimeException("Only one instance of TechTypeMoCMOS is allowed");
        }
        singletonCreated = true;
        assert (this.getNumMetals() == 6);
        assert (this.getTechnology() == Technology.getMocmosTechnology());
        assert (this.pdiff().getName().equals("P-Active"));
        assert (this.ndiff().getName().equals("N-Active"));
        assert (this.p1().getName().equals("Polysilicon-1"));
        assert (this.m1().getName().equals("Metal-1"));
        assert (this.m2().getName().equals("Metal-2"));
        assert (this.m3().getName().equals("Metal-3"));
        assert (this.m4().getName().equals("Metal-4"));
        assert (this.m5().getName().equals("Metal-5"));
        assert (this.m6().getName().equals("Metal-6"));
        assert (this.m7() == null);
        assert (this.m8() == null);
        assert (this.m9() == null);
        assert (this.ndiff18() == null);
        assert (this.pdiff18() == null);
        assert (this.ndiff25() == null);
        assert (this.pdiff25() == null);
        assert (this.ndiff33() == null);
        assert (this.pdiff33() == null);
        assert (this.ndpin().getName().equals("N-Active-Pin"));
        assert (this.pdpin().getName().equals("P-Active-Pin"));
        assert (this.p1pin().getName().equals("Polysilicon-1-Pin"));
        assert (this.m1pin().getName().equals("Metal-1-Pin"));
        assert (this.m2pin().getName().equals("Metal-2-Pin"));
        assert (this.m3pin().getName().equals("Metal-3-Pin"));
        assert (this.m4pin().getName().equals("Metal-4-Pin"));
        assert (this.m5pin().getName().equals("Metal-5-Pin"));
        assert (this.m6pin().getName().equals("Metal-6-Pin"));
        assert (this.m7pin() == null);
        assert (this.m8pin() == null);
        assert (this.m9pin() == null);
        assert (this.nwm1().getName().equals("Metal-1-N-Well-Con"));
        assert (this.pwm1().getName().equals("Metal-1-P-Well-Con"));
        assert (this.nwm1Y() == null);
        assert (this.pwm1Y() == null);
        assert (this.ndm1().getName().equals("Metal-1-N-Active-Con"));
        assert (this.pdm1().getName().equals("Metal-1-P-Active-Con"));
        assert (this.p1m1().getName().equals("Metal-1-Polysilicon-1-Con"));
        assert (this.m1m2().getName().equals("Metal-1-Metal-2-Con"));
        assert (this.m2m3().getName().equals("Metal-2-Metal-3-Con"));
        assert (this.m3m4().getName().equals("Metal-3-Metal-4-Con"));
        assert (this.m4m5().getName().equals("Metal-4-Metal-5-Con"));
        assert (this.m5m6().getName().equals("Metal-5-Metal-6-Con"));
        assert (this.m6m7() == null);
        assert (this.m7m8() == null);
        assert (this.m8m9() == null);
        assert (this.nmos().getName().equals("N-Transistor"));
        assert (this.pmos().getName().equals("P-Transistor"));
        assert (this.nmos18().getName().equals("Thick-N-Transistor"));
        assert (this.pmos18().getName().equals("Thick-P-Transistor"));
        assert (this.nmos25() == null);
        assert (this.pmos25() == null);
        assert (this.nmos33() == null);
        assert (this.pmos33() == null);
        assert (this.nmos18contact() == null);
        assert (this.pmos18contact() == null);
        assert (this.nmos25contact() == null);
        assert (this.pmos25contact() == null);
        assert (this.nmos33contact() == null);
        assert (this.pmos33contact() == null);
        assert (this.nwell().getName().equals("N-Well-Node"));
        assert (this.pwell().getName().equals("P-Well-Node"));
        assert (this.m1Node().getName().equals("Metal-1-Node"));
        assert (this.m2Node().getName().equals("Metal-2-Node"));
        assert (this.m3Node().getName().equals("Metal-3-Node"));
        assert (this.m4Node().getName().equals("Metal-4-Node"));
        assert (this.m5Node().getName().equals("Metal-5-Node"));
        assert (this.m6Node().getName().equals("Metal-6-Node"));
        assert (this.m7Node() == null);
        assert (this.m8Node() == null);
        assert (this.m9Node() == null);
        assert (this.p1Node().getName().equals("Polysilicon-1-Node"));
        assert (this.pdNode().getName().equals("P-Active-Node"));
        assert (this.ndNode().getName().equals("N-Active-Node"));
        assert (this.pselNode().getName().equals("P-Select-Node"));
        assert (this.nselNode().getName().equals("N-Select-Node"));
        assert (this.od18() == null);
        assert (this.od25() == null);
        assert (this.od33() == null);
        assert (this.vth() == null);
        assert (this.vtl() == null);
        assert (this.name().equals("MOCMOS"));
        this.gateToDiffContSpaceDogBone = 1.0;
        assert (this.getWellWidth() == 17.0);
        assert (this.getWellSurroundDiffInWellContact() == 3.0);
        assert (this.getGateExtendPastMOS() == 2.0);
        assert (this.getP1Width() == 2.0);
        assert (this.getP1ToP1Space() == 3.0);
        assert (this.getGateToGateSpace() == 3.0);
        assert (this.getGateToDiffContSpace() == 0.5);
        assert (this.getGateToDiffContSpaceDogBone() == 1.0);
        assert (this.getWellContWidth() == 5.0);
        assert (this.getDiffContWidth() == 5.0);
        assert (this.getP1M1Width() == 5.0);
        assert (this.getGateLength() == 2.0);
        assert (this.selectSurroundDiffInWellContact() == 2.0);
        assert (this.selectSurroundDiffInDiffContact() == 2.0);
        assert (this.selectSurroundDiffAlongGateInTrans() == 2.0);
        assert (this.getPolyLShapeOffset() == 1.5);
        assert (this.getPolyTShapeOffset() == 3.5);
        assert (this.getSelectSpacingRule() == 2.0);
        assert (this.getSelectSurroundDiffInTrans() == 2.0);
        assert (Double.isNaN(this.getSelectSurroundOverPoly()));
        assert (this.getM1MinArea() == 0.0);
        assert (this.getDiffCont_m1Width() == 4.0);
        assert (this.getDiffContIncr() == 5.0);
    }

    @Override
    public double roundToGrid(double x) {
        return Math.rint(x * 2.0) / 2.0;
    }

    @Override
    public String name() {
        return "MOCMOS";
    }

    @Override
    public double reservedToLambda(int layer, double nbTracks) {
        double m1via = 4.0;
        double m1sp = 3.0;
        double m1SP = 6.0;
        double m6via = 5.0;
        double m6sp = 4.0;
        double m6SP = 8.0;
        if (layer != 6) {
            return 2.0 * m1SP - m1sp + nbTracks * (m1via + m1sp);
        }
        return 2.0 * m6SP - m6sp + nbTracks * (m6via + m6sp);
    }
}

