/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapCellMosis;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.ExportConfig;
import com.sun.electric.tool.generator.layout.fill.FillCell;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplan;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplanFlex;
import com.sun.electric.tool.generator.layout.fill.TiledCell;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class FillGeneratorTool
extends Tool {
    public FillGenConfig config;
    protected Library lib;
    private boolean libInitialized;
    public List<Cell> masters;
    protected CapCell capCell;
    protected Floorplan[] plans;
    private static FillGeneratorTool tool = FillGeneratorTool.getTool();
    public static final Units LAMBDA = Units.LAMBDA;
    public static final Units TRACKS = Units.TRACKS;
    public static final ExportConfig PERIMETER = ExportConfig.PERIMETER;
    public static final ExportConfig PERIMETER_AND_INTERNAL = ExportConfig.PERIMETER_AND_INTERNAL;

    public static FillGeneratorTool getTool() {
        FillGeneratorTool tool;
        if (FillGeneratorTool.tool != null) {
            return FillGeneratorTool.tool;
        }
        try {
            Class<?> extraClass = Class.forName("com.sun.electric.plugins.generator.FillCellTool");
            Constructor<?> instance = extraClass.getDeclaredConstructor(new Class[0]);
            Object obj = instance.newInstance(new Object[0]);
            tool = (FillGeneratorTool)obj;
        }
        catch (Exception e) {
            TextUtils.recordMissingComponent("Fill Cell Generator");
            tool = new FillGeneratorTool();
        }
        return tool;
    }

    public FillGeneratorTool() {
        super("Fill Generator");
    }

    public void setConfig(FillGenConfig config) {
        this.config = config;
        this.libInitialized = false;
    }

    protected boolean getOrientation() {
        return this.plans[this.plans.length - 1].horizontal;
    }

    private double reservedToLambda(int layer, double reserved, Units units) {
        if (units == LAMBDA) {
            return reserved;
        }
        double nbTracks = reserved;
        if (nbTracks == 0.0) {
            return 0.0;
        }
        return this.config.getTechType().reservedToLambda(layer, nbTracks);
    }

    private Floorplan[] makeFloorplans(boolean metalFlex, boolean hierFlex) {
        Job.error(this.config.width == Double.NaN, "width hasn't been specified. use setWidth()");
        Job.error(this.config.height == Double.NaN, "height hasn't been specified. use setHeight()");
        double w = this.config.width;
        double h = this.config.height;
        int numLayers = this.config.getTechType().getNumMetals() + 1;
        double[] vddRes = new double[numLayers];
        double[] gndRes = new double[numLayers];
        double[] vddW = new double[numLayers];
        double[] gndW = new double[numLayers];
        for (FillGenConfig.ReserveConfig c : this.config.reserves) {
            vddRes[c.layer] = this.reservedToLambda(c.layer, c.vddReserved, c.vddUnits);
            gndRes[c.layer] = this.reservedToLambda(c.layer, c.gndReserved, c.gndUnits);
            if (c.vddWUnits != Units.NONE) {
                vddW[c.layer] = this.reservedToLambda(c.layer, c.vddWidth, c.vddWUnits);
            }
            if (c.gndWUnits == Units.NONE) continue;
            gndW[c.layer] = this.reservedToLambda(c.layer, c.gndWidth, c.gndWUnits);
        }
        boolean evenHor = this.config.evenLayersHorizontal;
        boolean alignedMetals = true;
        double[] spacing = new double[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            spacing[i] = this.config.drcSpacingRule;
        }
        if (alignedMetals) {
            int i;
            double maxVddRes = 0.0;
            double maxGndRes = 0.0;
            double maxSpacing = 0.0;
            double maxVddW = 0.0;
            double maxGndW = 0.0;
            for (i = 0; i < vddRes.length; ++i) {
                boolean vddOK = false;
                boolean gndOK = false;
                if (vddRes[i] > 0.0) {
                    vddOK = true;
                    if (maxVddRes < vddRes[i]) {
                        maxVddRes = vddRes[i];
                    }
                }
                if (gndRes[i] > 0.0) {
                    gndOK = true;
                    if (maxGndRes < gndRes[i]) {
                        maxGndRes = gndRes[i];
                    }
                }
                if ((gndOK || vddOK) && maxSpacing < this.config.drcSpacingRule) {
                    maxSpacing = this.config.drcSpacingRule;
                }
                if (maxVddW < vddW[i]) {
                    maxVddW = vddW[i];
                }
                if (!(maxGndW < gndW[i])) continue;
                maxGndW = gndW[i];
            }
            for (i = 0; i < vddRes.length; ++i) {
                vddRes[i] = maxVddRes;
                gndRes[i] = maxGndRes;
                spacing[i] = maxSpacing;
                vddW[i] = maxVddW;
                gndW[i] = maxGndW;
            }
        }
        Floorplan[] thePlans = new Floorplan[numLayers];
        thePlans[1] = new CapFloorplan(w, h, !evenHor);
        if (metalFlex) {
            if (!hierFlex) {
                for (int i = 2; i < numLayers; ++i) {
                    boolean horiz = i % 2 == 0;
                    thePlans[i] = new MetalFloorplanFlex(w, h, vddRes[i], gndRes[i], spacing[i], vddW[i], gndW[i], horiz);
                }
                return thePlans;
            }
            w = this.config.width = this.config.minTileSizeX;
            h = this.config.height = this.config.minTileSizeY;
        }
        for (int i = 2; i < numLayers; ++i) {
            boolean horiz = i % 2 == 0;
            thePlans[i] = new MetalFloorplan(w, h, vddRes[i], gndRes[i], spacing[i], horiz);
        }
        return thePlans;
    }

    private void printCoverage(Floorplan[] plans) {
        for (int i = 2; i < plans.length; ++i) {
            System.out.println("metal-" + i + " coverage: " + ((MetalFloorplan)plans[i]).coverage);
        }
    }

    private static CapCell getCMOS90CapCell(Library lib, CapFloorplan plan, EditingPreferences ep) {
        CapCell c;
        block2: {
            c = null;
            try {
                Class<?> cmos90Class = Class.forName("com.sun.electric.plugins.tsmc.fill90nm.CapCellCMOS90");
                Constructor<?> capCellC = cmos90Class.getDeclaredConstructor(Library.class, CapFloorplan.class, EditingPreferences.class);
                Object cell = capCellC.newInstance(lib, plan, ep);
                c = (CapCell)cell;
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return c;
    }

    protected void initFillParameters(boolean metalFlex, boolean hierFlex, EditingPreferences ep) {
        if (this.libInitialized) {
            return;
        }
        Job.error(this.config.fillLibName == null, "no library specified. Use setFillLibrary()");
        Job.error(this.config.width == Double.NaN || this.config.width <= 0.0, "no width specified. Use setFillCellWidth()");
        Job.error(this.config.height == Double.NaN || this.config.height <= 0.0, "no height specified. Use setFillCellHeight()");
        this.plans = this.makeFloorplans(metalFlex, hierFlex);
        if (!metalFlex) {
            this.printCoverage(this.plans);
        }
        this.lib = LayoutLib.openLibForWrite(this.config.fillLibName);
        if (!metalFlex) {
            this.capCell = this.config.getTechType().getTechnology() == Technology.getCMOS90Technology() ? FillGeneratorTool.getCMOS90CapCell(this.lib, (CapFloorplan)this.plans[1], ep) : new CapCellMosis(this.lib, (CapFloorplan)this.plans[1], this.config.getTechType(), ep);
        }
        this.libInitialized = true;
    }

    private void makeTiledCells(Cell cell, Floorplan[] plans, Library lib, int[] tiledSizes, EditingPreferences ep) {
        if (tiledSizes == null) {
            return;
        }
        for (int num : tiledSizes) {
            TiledCell.makeTiledCell(num, num, cell, plans, lib, ep);
        }
    }

    public static Cell makeFillCell(Library lib, Floorplan[] plans, int botLayer, int topLayer, CapCell capCell, TechType tech, EditingPreferences ep, ExportConfig expCfg, boolean metalFlex, boolean hierFlex) {
        FillCell fc = new FillCell(tech, ep);
        return fc.makeFillCell1(lib, plans, botLayer, topLayer, capCell, expCfg, metalFlex, hierFlex);
    }

    private Cell standardMakeAndTileCell(Library lib, Floorplan[] plans, int lowLay, int hiLay, CapCell capCell, TechType tech, EditingPreferences ep, ExportConfig expCfg, int[] tiledSizes, boolean metalFlex) {
        Cell master = FillGeneratorTool.makeFillCell(lib, plans, lowLay, hiLay, capCell, tech, ep, expCfg, metalFlex, false);
        this.masters = new ArrayList<Cell>();
        this.masters.add(master);
        this.makeTiledCells(master, plans, lib, tiledSizes, ep);
        return master;
    }

    public Cell standardMakeFillCell(int loLayer, int hiLayer, TechType tech, EditingPreferences ep, ExportConfig exportConfig, int[] tiledSizes, boolean metalFlex) {
        this.initFillParameters(metalFlex, false, ep);
        Job.error(loLayer < 1, "loLayer must be >=1");
        int maxNumMetals = this.config.getTechType().getNumMetals();
        Job.error(hiLayer > maxNumMetals, "hiLayer must be <=" + maxNumMetals);
        Job.error(loLayer > hiLayer, "loLayer must be <= hiLayer");
        Cell cell = null;
        cell = this.standardMakeAndTileCell(this.lib, this.plans, loLayer, hiLayer, this.capCell, tech, ep, exportConfig, tiledSizes, metalFlex);
        return cell;
    }

    public void makeGallery(EditingPreferences ep) {
        Gallery.makeGallery(this.lib, ep);
    }

    public void writeLibrary(int backupScheme) throws JobException {
        LayoutLib.writeLibrary(this.lib, backupScheme);
    }

    public static enum FillTypeEnum {
        INVALID,
        TEMPLATE,
        CELL;

    }

    public static enum Units {
        NONE,
        LAMBDA,
        TRACKS;

    }
}

