/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.logicaleffort.Instance;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.logicaleffort.Net;
import com.sun.electric.tool.logicaleffort.Pin;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.TextUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LENetlister1
extends LENetlister {
    protected LENetlister.NetlisterConstants constants;
    private HashMap<String, Net> allNets;
    private Map<String, Instance> allInstances;
    private LESizer sizer;
    private Job job;
    private PrintStream out;
    private List<Instance> instancesMap;
    private boolean aborted;
    private ErrorLogger errorLogger;
    private HashMap<Export, Export> lePortError;
    private Cell topLevelCell;
    private static final boolean DEBUG = false;

    public LENetlister1(Job job, Technology layoutTech) {
        super(layoutTech);
        Tool leTool = Tool.findTool("logical effort");
        this.constants = null;
        this.topLevelCell = null;
        this.allNets = new HashMap();
        this.allInstances = new TreeMap<String, Instance>();
        this.job = job;
        this.instancesMap = new ArrayList<Instance>();
        this.lePortError = new HashMap();
        this.out = new PrintStream(System.out);
        this.errorLogger = null;
        this.aborted = false;
    }

    @Override
    public boolean netlist(Cell cell, VarContext context, boolean useCaching) {
        assert (this.errorLogger == null);
        this.errorLogger = ErrorLogger.newInstance("LE Netlister");
        this.constants = this.getSettings(cell);
        if (this.constants == null) {
            this.constants = new LENetlister.NetlisterConstants(this.layoutTech);
            if (!this.saveSettings(this.constants, cell)) {
                return false;
            }
        }
        this.topLevelCell = cell;
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)this, SHORT_RESISTORS);
        return !this.aborted;
    }

    @Override
    public boolean size(LESizer.Alg algorithm) {
        boolean verbose = false;
        this.sizer = new LESizer(algorithm, this, this.job, this.errorLogger);
        boolean success = this.sizer.optimizeLoops(this.constants.epsilon, this.constants.maxIterations, verbose, this.constants.alpha, this.constants.keeperRatio);
        this.sizer = null;
        return success;
    }

    @Override
    public void getSizes(List<Float> sizes, List<String> varNames, List<NodeInst> nodes, List<VarContext> contexts) {
        Set<Map.Entry<String, Instance>> allEntries = this.allInstances.entrySet();
        for (Map.Entry<String, Instance> entry : allEntries) {
            Instance inst = entry.getValue();
            Nodable no = inst.getNodable();
            NodeInst ni = no.getNodeInst();
            if (ni != null) {
                no = ni;
            }
            if (!inst.isLeGate()) continue;
            String varName = "LEDRIVE_" + inst.getName();
            sizes.add(new Float(inst.getLeX()));
            varNames.add(varName);
            nodes.add(ni);
            contexts.add(inst.getContext());
        }
    }

    @Override
    public void done() {
        this.errorLogger.termLogging(true);
    }

    @Override
    public ErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    @Override
    public void nullErrorLogger() {
        this.errorLogger = null;
    }

    @Override
    public LENetlister.NetlisterConstants getConstants() {
        return this.constants;
    }

    protected Instance addInstance(String name, Instance.Type type, float leSU, float leX, ArrayList<Pin> pins, Nodable no) {
        if (this.allInstances.containsKey(name)) {
            this.out.println("Error: Instance " + name + " already exists.");
            return null;
        }
        Instance instance = new Instance(name, type, leSU, leX, no);
        for (Pin pin : pins) {
            String netname = pin.getNetName();
            Net net = this.allNets.get(netname);
            if (net != null) {
                pin.setNet(net);
                pin.setInstance(instance);
                net.addPin(pin);
                continue;
            }
            net = new Net(netname);
            this.allNets.put(netname, net);
            pin.setNet(net);
            pin.setInstance(instance);
            net.addPin(pin);
        }
        instance.setPins(pins);
        this.allInstances.put(name, instance);
        return instance;
    }

    protected Map<String, Instance> getAllInstances() {
        return this.allInstances;
    }

    protected HashMap<String, Net> getAllNets() {
        return this.allNets;
    }

    protected int getNumGates() {
        return this.allInstances.size();
    }

    protected LESizer getSizer() {
        return this.sizer;
    }

    protected float getKeeperRatio() {
        return this.constants.keeperRatio;
    }

    @Override
    public HierarchyEnumerator.CellInfo newCellInfo() {
        return new LECellInfo();
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.aborted) {
            return false;
        }
        if (((LETool.AnalyzeCell)this.job).checkAbort(null)) {
            this.aborted = true;
            return false;
        }
        LECellInfo leinfo = (LECellInfo)info;
        leinfo.leInit(this.constants);
        if (this.topLevelCell != info.getCell() && this.isSettingsConflict(leinfo.getSettings(), this.topLevelCell, info.getContext(), info.getCell())) {
            this.aborted = true;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        float nisu;
        float leX = 0.0f;
        boolean wire = false;
        boolean primitiveTransistor = false;
        float x1inverter_totalgate = this.constants.x1inverter_nwidth + this.constants.x1inverter_pwidth;
        Instance.Type type = null;
        Variable var = null;
        var = this.getVar(ni, ATTR_LEGATE);
        if (var != null) {
            int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
            if (gate != 1) return true;
            type = Instance.Type.LEGATE;
        } else {
            var = this.getVar(ni, ATTR_LEKEEPER);
            if (var != null) {
                int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
                if (gate != 1) return true;
                type = Instance.Type.LEKEEPER;
            } else if (this.getVar(ni, ATTR_LEWIRE) != null) {
                type = Instance.Type.WIRE;
                var = ni.getParameterOrVariable(ATTR_LEWIRECAP);
                float cap = 0.0f;
                if (var != null) {
                    cap = VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                } else {
                    var = ni.getParameterOrVariable(ATTR_L);
                    if (var == null) {
                        System.out.println("Error, no L attribute found on LEWIRE " + info.getContext().push(ni).getInstPath("."));
                    }
                    float len = VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                    var = ni.getParameterOrVariable(Schematics.ATTR_WIDTH);
                    if (var == null) {
                        System.out.println("Warning, no width attribute found on LEWIRE " + info.getContext().push(ni).getInstPath("."));
                    }
                    float width = VarContext.objectToFloat(info.getContext().evalVar(var), 3.0f);
                    cap = 0.95f * len + 0.05f * len * (width / 3.0f);
                }
                leX = cap * this.constants.wireRatio / x1inverter_totalgate;
                wire = true;
            } else if (ni.getProto() != null && ni.getProto().getFunction().isTransistor()) {
                type = Instance.Type.STATICGATE;
                var = ni.getParameterOrVariable(Schematics.ATTR_WIDTH);
                if (var == null) {
                    System.out.println("Error: transistor " + ni + " has no width in Cell " + info.getCell());
                    this.errorLogger.logError("Error: transistor " + ni + " has no width in Cell " + info.getCell(), ni.getNodeInst(), info.getCell(), info.getContext(), 0);
                    return false;
                }
                float width = VarContext.objectToFloat(info.getContext().evalVar(var), 3.0f);
                leX = width / x1inverter_totalgate;
                primitiveTransistor = true;
            } else if (ni.getProto() != null && ni.getProto().getFunction().isCapacitor()) {
                type = Instance.Type.CAPACITOR;
                var = ni.getVar(Schematics.SCHEM_CAPACITANCE);
                if (var == null) {
                    System.out.println("Error: capacitor " + ni + " has no capacitance in Cell " + ni.getParent());
                    return false;
                }
                float cap = VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                leX = (float)((double)(cap / this.constants.gateCap) / 1.0E-15 / (double)x1inverter_totalgate);
            } else {
                if (ni.getParameterOrVariable(ATTR_LESETTINGS) != null) {
                    return false;
                }
                if (ni.getParameterOrVariable(ATTR_LEIGNORE) != null) {
                    return false;
                }
            }
        }
        if (type == null) {
            return true;
        }
        ArrayList<Pin> pins = new ArrayList<Pin>();
        Netlist netlist = info.getNetlist();
        Iterator<PortProto> ppIt = ni.getProto().getPorts();
        while (ppIt.hasNext()) {
            PortProto pp = ppIt.next();
            float le = this.getLE(ni, type, pp, info);
            String netName = info.getUniqueNetName(info.getNetID(netlist.getNetwork(ni, pp, 0)), ".");
            Pin.Dir dir = Pin.Dir.INPUT;
            if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                dir = Pin.Dir.OUTPUT;
            }
            if (primitiveTransistor && pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                dir = Pin.Dir.OUTPUT;
            }
            if (dir == Pin.Dir.INPUT && type == Instance.Type.STATICGATE) {
                float length;
                var = ni.getParameterOrVariable(Schematics.ATTR_LENGTH);
                if (var == null) {
                    System.out.println("Error: transistor " + ni + " has no length in Cell " + info.getCell());
                    this.errorLogger.logError("Error: transistor " + ni + " has no length in Cell " + info.getCell(), ni.getNodeInst(), info.getCell(), info.getContext(), 0);
                }
                if ((length = VarContext.objectToFloat(info.getContext().evalVar(var), 2.0f)) != this.constants.x1inverter_length) {
                    le = le * length / this.constants.x1inverter_length;
                }
            }
            pins.add(new Pin(pp.getName(), dir, le, netName));
            if (type != Instance.Type.WIRE) continue;
            break;
        }
        float localsu = this.constants.su;
        if (((LECellInfo)info).getSU() != -1.0f) {
            localsu = ((LECellInfo)info).getSU();
        }
        if ((var = ni.getParameterOrVariable(ATTR_su)) != null && (nisu = VarContext.objectToFloat(info.getContext().evalVar(var), -1.0f)) != -1.0f) {
            localsu = nisu;
        }
        VarContext vc = info.getContext().push(ni);
        Instance inst = this.addInstance(vc.getInstPath("."), type, localsu, leX, pins, ni);
        inst.setContext(info.getContext());
        if ((type == Instance.Type.LEGATE || type == Instance.Type.LEKEEPER) && (var = ni.getParameterOrVariable(ATTR_LEPARALLGRP)) != null) {
            int g = VarContext.objectToInt(info.getContext().evalVar(var), 0);
            inst.setParallelGroup(g);
        }
        float parentM = ((LECellInfo)info).getMFactor();
        inst.setMfactor(parentM);
        var = LETool.getMFactor(ni);
        if (var != null) {
            float m = VarContext.objectToFloat(info.getContext().evalVar(var), 1.0f);
            inst.setMfactor(m *= parentM);
        }
        this.instancesMap.add(inst);
        return false;
    }

    private float getLE(Nodable ni, Instance.Type type, PortProto pp, HierarchyEnumerator.CellInfo info) {
        Cell cell;
        Export exp;
        boolean leFound = false;
        float le = 1.0f;
        if (!(pp instanceof Export)) {
            return le;
        }
        Variable var = ((Export)pp).getParameterOrVariable(ATTR_le);
        if (var != null) {
            leFound = true;
            le = VarContext.objectToFloat(info.getContext().evalVar(var), 1.0f);
        } else if (pp.getCharacteristic() == PortCharacteristic.OUT && (type == Instance.Type.LEGATE || type == Instance.Type.LEKEEPER)) {
            float diff2 = 0.0f;
            var = ((Export)pp).getParameterOrVariable(ATTR_diffn);
            if (var != null) {
                diff2 += VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                leFound = true;
            }
            if ((var = ((Export)pp).getParameterOrVariable(ATTR_diffp)) != null) {
                diff2 += VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                leFound = true;
            }
            le = diff2 / 3.0f;
        }
        if (!(leFound || type != Instance.Type.LEGATE && type != Instance.Type.LEKEEPER || (exp = (cell = (Cell)ni.getProto()).findExport(pp.getName())) == null || this.lePortError.get(exp) != null)) {
            String msg = "Warning: Sizeable gate has no logical effort specified for port " + pp.getName() + " in " + cell;
            System.out.println(msg);
            this.errorLogger.logWarning(msg, exp, cell, info.getContext().push(ni), 0);
            this.lePortError.put(exp, exp);
        }
        return le;
    }

    private Variable getVar(Nodable no, Variable.Key key) {
        Variable var = no.getParameter(key);
        return var;
    }

    public void doneVisitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    @Override
    public void printStatistics() {
        Collection<Instance> instances = this.getAllInstances().values();
        float totalsize = 0.0f;
        float instsize = 0.0f;
        int numLEGates = 0;
        int numLEWires = 0;
        for (Instance inst : instances) {
            totalsize += inst.getLeX();
            if (inst.getType() == Instance.Type.LEGATE || inst.getType() == Instance.Type.LEKEEPER) {
                ++numLEGates;
                instsize += inst.getLeX();
            }
            if (inst.getType() != Instance.Type.WIRE) continue;
            ++numLEWires;
        }
        System.out.println("Number of LEGATEs: " + numLEGates);
        System.out.println("Number of Wires: " + numLEWires);
        System.out.println("Total size of all LEGATEs: " + instsize);
        System.out.println("Total size of all instances (sized and loads): " + totalsize);
    }

    @Override
    public float getTotalLESize() {
        return this.getTotalSize(Instance.Type.LEGATE) + this.getTotalSize(Instance.Type.LEKEEPER);
    }

    public float getTotalSize(Instance.Type type) {
        Collection<Instance> instances = this.getAllInstances().values();
        float totalsize = 0.0f;
        for (Instance inst : instances) {
            if (type == null) {
                totalsize += inst.getLeX();
                continue;
            }
            if (inst.getType() != type) continue;
            totalsize += inst.getLeX();
        }
        return totalsize;
    }

    @Override
    public boolean printResults(Nodable no, VarContext context) {
        if (no instanceof NodeInst) {
            no = Netlist.getNodableFor((NodeInst)no, 0);
        }
        Instance inst = null;
        for (Instance instance : this.instancesMap) {
            if (instance.getNodable() != no || !instance.getContext().getInstPath(".").equals(context.getInstPath("."))) continue;
            inst = instance;
            break;
        }
        if (inst == null) {
            return false;
        }
        System.out.println("Netlister: Gate Cap=" + this.constants.gateCap + ", Alpha=" + this.constants.alpha);
        inst.print();
        Pin out = inst.getOutputPins().get(0);
        Net net = out.getNet();
        ArrayList<Pin> gatesDrivenPins = new ArrayList<Pin>();
        ArrayList<Pin> loadsDrivenPins = new ArrayList<Pin>();
        ArrayList<Pin> wiresDrivenPins = new ArrayList<Pin>();
        ArrayList<Pin> gatesFightingPins = new ArrayList<Pin>();
        for (Pin pin : net.getAllPins()) {
            Instance in = pin.getInstance();
            if (pin.getDir() == Pin.Dir.INPUT) {
                if (in.isGate()) {
                    gatesDrivenPins.add(pin);
                }
                if (in.getType() == Instance.Type.LOAD) {
                    loadsDrivenPins.add(pin);
                }
                if (in.getType() == Instance.Type.CAPACITOR) {
                    loadsDrivenPins.add(pin);
                }
                if (in.getType() == Instance.Type.WIRE) {
                    wiresDrivenPins.add(pin);
                }
            }
            if (pin.getDir() != Pin.Dir.OUTPUT || !in.isGate()) continue;
            gatesFightingPins.add(pin);
        }
        System.out.println("Note: Load = Size * LE * M");
        System.out.println("Note: Load = Size * LE * M * Alpha, for Gates Fighting");
        float totalLoad = 0.0f;
        System.out.println("  -------------------- Gates Driven (" + gatesDrivenPins.size() + ") --------------------");
        for (Pin pin : gatesDrivenPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Loads Driven (" + loadsDrivenPins.size() + ") --------------------");
        for (Pin pin : loadsDrivenPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Wires Driven (" + wiresDrivenPins.size() + ") --------------------");
        for (Pin pin : wiresDrivenPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Gates Fighting (" + gatesFightingPins.size() + ") --------------------");
        for (Pin pin : gatesFightingPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("*** Total Load: " + TextUtils.formatDouble(totalLoad, 2));
        return true;
    }

    public static void test1() {
        LESizer.test1();
    }

    public class LECellInfo
    extends LENetlister.LECellInfo {
    }
}

