/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;

public class StratHashParts
extends Strategy {
    private int numPartsProcessed;
    private int numEquivProcessed;

    private StratHashParts(NccGlobals globals) {
        super(globals);
    }

    private void preamble() {
        this.startTime("StratHashParts", " Parts");
    }

    private void summary(LeafList offspring) {
        this.globals.status2(" processed " + this.numPartsProcessed + " Parts from " + this.numEquivProcessed + " leaf Records");
        this.globals.status2(this.offspringStats(offspring));
        this.globals.status2(offspring.sizeInfoString());
        this.elapsedTime();
    }

    @Override
    public LeafList doFor(EquivRecord g) {
        if (g.isLeaf()) {
            ++this.numEquivProcessed;
        }
        return super.doFor(g);
    }

    @Override
    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Part), "StratHashPartAll expects only Parts");
        ++this.numPartsProcessed;
        Part p = (Part)n;
        return p.computeHashCode();
    }

    public static LeafList doYourJob(Iterator<EquivRecord> it, NccGlobals globals) {
        StratHashParts jhpa = new StratHashParts(globals);
        if (!it.hasNext()) {
            return new LeafList();
        }
        jhpa.preamble();
        LeafList offspring = jhpa.doFor(it);
        jhpa.summary(offspring);
        return offspring;
    }

    public static LeafList doYourJob(EquivRecord er, NccGlobals globals) {
        StratHashParts jhpa = new StratHashParts(globals);
        return jhpa.doFor(er);
    }
}

