/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.geometry.ERectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FindEmptyRects {
    public List<ERectangle> findEmptySpace(List<ERectangle> rectangles, ERectangle bound) {
        ArrayList<ERectangle> emptyRects = new ArrayList<ERectangle>();
        for (ERectangle rect : rectangles) {
            double segLX = rect.getMinX();
            double segHX = rect.getMaxX();
            double segLY = rect.getMinY();
            double segHY = rect.getMaxY();
            LineSeg bottom = new LineSeg(segLX, segLY, segHX, segLY);
            this.buildEmptyRectsBelow(bottom, rect, rectangles, bound, emptyRects);
            LineSeg left = new LineSeg(segLX, segLY, segLX, segHY);
            this.buildEmptyRectsLeft(left, rect, rectangles, bound, emptyRects);
        }
        LineSeg bottom = new LineSeg(bound.getMinX(), bound.getMaxY(), bound.getMaxX(), bound.getMaxY());
        this.buildEmptyRectsBelow(bottom, null, rectangles, bound, emptyRects);
        LineSeg left = new LineSeg(bound.getMaxX(), bound.getMinY(), bound.getMaxX(), bound.getMaxY());
        this.buildEmptyRectsLeft(left, null, rectangles, bound, emptyRects);
        Collections.sort(emptyRects, new SortRectsBySize());
        for (int i = 0; i < emptyRects.size(); ++i) {
            ERectangle big = (ERectangle)emptyRects.get(i);
            for (int j = i + 1; j < emptyRects.size(); ++j) {
                ERectangle small = (ERectangle)emptyRects.get(j);
                if (!(small.getMinX() >= big.getMinX()) || !(small.getMaxX() <= big.getMaxX()) || !(small.getMinY() >= big.getMinY()) || !(small.getMaxY() <= big.getMaxY())) continue;
                emptyRects.remove(i);
                --j;
            }
        }
        return emptyRects;
    }

    private void buildEmptyRectsBelow(LineSeg bottom, ERectangle rect, List<ERectangle> rectangles, ERectangle bound, List<ERectangle> emptyRects) {
        double highX;
        int i;
        double segLX = bottom.getMinX();
        double segHX = bottom.getMaxX();
        double segY = bottom.getMinY();
        List<LineSeg> segsBelow = this.getSegmentsBelow(bottom, rect, rectangles);
        segsBelow.add(new LineSeg(bound.getMinX(), bound.getMinY(), bound.getMaxX(), bound.getMinY()));
        Collections.sort(segsBelow, new SortLineSegsDown());
        block0: for (i = 0; i < segsBelow.size(); ++i) {
            for (int j = i + 1; j < segsBelow.size(); ++j) {
                LineSeg thisSeg = segsBelow.get(i);
                LineSeg nextSeg = segsBelow.get(j);
                if (thisSeg.y1 != nextSeg.y1) continue block0;
                LineSeg adjoin = thisSeg.adjoins(nextSeg);
                if (adjoin == null) continue;
                segsBelow.set(i, adjoin);
                segsBelow.remove(j);
                --j;
            }
        }
        block2: for (i = 1; i < segsBelow.size(); ++i) {
            LineSeg thisSeg = segsBelow.get(i);
            for (int j = 0; j < i; ++j) {
                double lowX;
                LineSeg prevSeg = segsBelow.get(j);
                if (prevSeg.getMinX() <= thisSeg.getMinX() && prevSeg.getMaxX() >= thisSeg.getMaxX()) {
                    segsBelow.remove(i);
                    --i;
                    continue block2;
                }
                if (prevSeg.getMaxX() < thisSeg.getMaxX() && prevSeg.getMinX() > thisSeg.getMinX()) {
                    double lowX1 = thisSeg.getMinX();
                    double highX1 = prevSeg.getMinX();
                    double lowX2 = prevSeg.getMaxX();
                    double highX2 = thisSeg.getMaxX();
                    thisSeg.x1 = lowX1;
                    thisSeg.x2 = highX1;
                    segsBelow.add(i + 1, new LineSeg(lowX2, thisSeg.y2, highX2, thisSeg.y2));
                    continue;
                }
                if (prevSeg.getMinX() <= thisSeg.getMinX() && prevSeg.getMaxX() > thisSeg.getMinX()) {
                    lowX = prevSeg.getMaxX();
                    highX = thisSeg.getMaxX();
                    thisSeg.x1 = lowX;
                    thisSeg.x2 = highX;
                    continue;
                }
                if (!(prevSeg.getMaxX() >= thisSeg.getMaxX()) || !(prevSeg.getMinX() < thisSeg.getMaxX())) continue;
                lowX = thisSeg.getMinX();
                highX = prevSeg.getMinX();
                thisSeg.x1 = lowX;
                thisSeg.x2 = highX;
            }
        }
        for (i = 0; i < segsBelow.size(); ++i) {
            LineSeg ls = segsBelow.get(i);
            if (ls.y1 == segY) {
                segsBelow.remove(i);
                --i;
                continue;
            }
            if (ls.getMinX() >= segHX || ls.getMaxX() <= segLX) {
                segsBelow.remove(i);
                --i;
                continue;
            }
            if (ls.getMinX() <= segLX) {
                ls.x2 = ls.getMaxX();
                ls.x1 = bound.getMinX();
            }
            if (!(ls.getMaxX() >= segHX)) continue;
            ls.x1 = ls.getMinX();
            ls.x2 = bound.getMaxX();
        }
        for (LineSeg ls : segsBelow) {
            double lowX = ls.getMinX();
            double lowY = ls.getMinY();
            highX = ls.getMaxX();
            double highY = segY;
            if (lowX < segLX) {
                for (ERectangle r : rectangles) {
                    if (r.getMinY() >= highY || r.getMaxY() <= lowY || r.getMinX() >= highX || r.getMaxX() <= lowX || !(r.getMinX() < segLX) || !(r.getMaxX() > lowX)) continue;
                    lowX = r.getMaxX();
                }
            }
            if (highX > segHX) {
                for (ERectangle r : rectangles) {
                    if (r.getMinY() >= highY || r.getMaxY() <= lowY || r.getMinX() >= highX || r.getMaxX() <= lowX || !(r.getMaxX() > segHX) || !(r.getMinX() < highX)) continue;
                    highX = r.getMinX();
                }
            }
            emptyRects.add(ERectangle.fromLambda(lowX, lowY, highX - lowX, highY - lowY));
        }
    }

    private void buildEmptyRectsLeft(LineSeg left, ERectangle rect, List<ERectangle> rectangles, ERectangle bound, List<ERectangle> emptyRects) {
        double highY;
        int i;
        double segLY = left.getMinY();
        double segHY = left.getMaxY();
        double segX = left.getMinX();
        List<LineSeg> segsLeft = this.getSegmentsLeft(left, rect, rectangles);
        segsLeft.add(new LineSeg(bound.getMinX(), bound.getMinY(), bound.getMinX(), bound.getMaxY()));
        Collections.sort(segsLeft, new SortLineSegsLeft());
        block0: for (i = 0; i < segsLeft.size(); ++i) {
            for (int j = i + 1; j < segsLeft.size(); ++j) {
                LineSeg thisSeg = segsLeft.get(i);
                LineSeg nextSeg = segsLeft.get(j);
                if (thisSeg.x1 != nextSeg.x1) continue block0;
                LineSeg adjoin = thisSeg.adjoins(nextSeg);
                if (adjoin == null) continue;
                segsLeft.set(i, adjoin);
                segsLeft.remove(j);
                --j;
            }
        }
        block2: for (i = 1; i < segsLeft.size(); ++i) {
            LineSeg thisSeg = segsLeft.get(i);
            for (int j = 0; j < i; ++j) {
                double lowY;
                LineSeg prevSeg = segsLeft.get(j);
                if (prevSeg.getMinY() <= thisSeg.getMinY() && prevSeg.getMaxY() >= thisSeg.getMaxY()) {
                    segsLeft.remove(i);
                    --i;
                    continue block2;
                }
                if (prevSeg.getMaxY() < thisSeg.getMaxY() && prevSeg.getMinY() > thisSeg.getMinY()) {
                    double lowY1 = thisSeg.getMinY();
                    double highY1 = prevSeg.getMinY();
                    double lowY2 = prevSeg.getMaxY();
                    double highY2 = thisSeg.getMaxY();
                    thisSeg.y1 = lowY1;
                    thisSeg.y2 = highY1;
                    segsLeft.add(i + 1, new LineSeg(thisSeg.x2, lowY2, thisSeg.x2, highY2));
                    continue;
                }
                if (prevSeg.getMinY() <= thisSeg.getMinY() && prevSeg.getMaxY() > thisSeg.getMinY()) {
                    lowY = prevSeg.getMaxY();
                    highY = thisSeg.getMaxY();
                    thisSeg.y1 = lowY;
                    thisSeg.y2 = highY;
                    continue;
                }
                if (!(prevSeg.getMaxY() >= thisSeg.getMaxY()) || !(prevSeg.getMinY() < thisSeg.getMaxY())) continue;
                lowY = thisSeg.getMinY();
                highY = prevSeg.getMinY();
                thisSeg.y1 = lowY;
                thisSeg.y2 = highY;
            }
        }
        for (i = 0; i < segsLeft.size(); ++i) {
            LineSeg ls = segsLeft.get(i);
            if (ls.x1 == segX) {
                segsLeft.remove(i);
                --i;
                continue;
            }
            if (ls.getMinY() >= segHY || ls.getMaxY() <= segLY) {
                segsLeft.remove(i);
                --i;
                continue;
            }
            if (ls.getMinY() <= segLY) {
                ls.y2 = ls.getMaxY();
                ls.y1 = bound.getMinY();
            }
            if (!(ls.getMaxY() >= segHY)) continue;
            ls.y1 = ls.getMinY();
            ls.y2 = bound.getMaxY();
        }
        for (LineSeg ls : segsLeft) {
            double lowY = ls.getMinY();
            double lowX = ls.getMinX();
            highY = ls.getMaxY();
            double highX = segX;
            if (lowY < segLY) {
                for (ERectangle r : rectangles) {
                    if (r.getMinX() >= highX || r.getMaxX() <= lowX || r.getMinY() >= highY || r.getMaxY() <= lowY || !(r.getMinY() < segLY) || !(r.getMaxY() > lowY)) continue;
                    lowY = r.getMaxY();
                }
            }
            if (highY > segHY) {
                for (ERectangle r : rectangles) {
                    if (r.getMinX() >= highX || r.getMaxX() <= lowX || r.getMinY() >= highY || r.getMaxY() <= lowY || !(r.getMaxY() > segHY) || !(r.getMinY() < highY)) continue;
                    highY = r.getMinY();
                }
            }
            emptyRects.add(ERectangle.fromLambda(lowX, lowY, highX - lowX, highY - lowY));
        }
    }

    private List<LineSeg> getSegmentsBelow(LineSeg ls, ERectangle rect, List<ERectangle> rectangles) {
        ArrayList<LineSeg> segs = new ArrayList<LineSeg>();
        for (ERectangle r : rectangles) {
            if (r == rect) continue;
            double lX = r.getMinX();
            double hX = r.getMaxX();
            double hY = r.getMaxY();
            if (hX <= ls.getMinX() || lX >= ls.getMaxX() || hY > ls.getMinY()) continue;
            segs.add(new LineSeg(lX, hY, hX, hY));
        }
        return segs;
    }

    private List<LineSeg> getSegmentsLeft(LineSeg ls, ERectangle rect, List<ERectangle> rectangles) {
        ArrayList<LineSeg> segs = new ArrayList<LineSeg>();
        for (ERectangle r : rectangles) {
            if (r == rect) continue;
            double hX = r.getMaxX();
            double lY = r.getMinY();
            double hY = r.getMaxY();
            if (hY <= ls.getMinY() || lY >= ls.getMaxY() || hX > ls.getMinX()) continue;
            segs.add(new LineSeg(hX, lY, hX, hY));
        }
        return segs;
    }

    private static class SortRectsBySize
    implements Comparator<ERectangle> {
        private SortRectsBySize() {
        }

        @Override
        public int compare(ERectangle r1, ERectangle r2) {
            double s2;
            double s1 = r1.getWidth() * r1.getHeight();
            if (s1 < (s2 = r2.getWidth() * r2.getHeight())) {
                return 1;
            }
            if (s1 > s2) {
                return -1;
            }
            return 0;
        }
    }

    private static class SortLineSegsLeft
    implements Comparator<LineSeg> {
        private SortLineSegsLeft() {
        }

        @Override
        public int compare(LineSeg ls1, LineSeg ls2) {
            if (ls1.x1 < ls2.x1) {
                return 1;
            }
            if (ls1.x1 > ls2.x1) {
                return -1;
            }
            if (ls1.y1 < ls2.y1) {
                return 1;
            }
            if (ls1.y1 > ls2.y1) {
                return -1;
            }
            return 0;
        }
    }

    private static class SortLineSegsDown
    implements Comparator<LineSeg> {
        private SortLineSegsDown() {
        }

        @Override
        public int compare(LineSeg ls1, LineSeg ls2) {
            if (ls1.y1 < ls2.y1) {
                return 1;
            }
            if (ls1.y1 > ls2.y1) {
                return -1;
            }
            if (ls1.x1 < ls2.x1) {
                return 1;
            }
            if (ls1.x1 > ls2.x1) {
                return -1;
            }
            return 0;
        }
    }

    private static class LineSeg {
        double x1;
        double y1;
        double x2;
        double y2;

        public LineSeg(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public double getMinX() {
            return Math.min(this.x1, this.x2);
        }

        public double getMaxX() {
            return Math.max(this.x1, this.x2);
        }

        public double getMinY() {
            return Math.min(this.y1, this.y2);
        }

        public double getMaxY() {
            return Math.max(this.y1, this.y2);
        }

        public LineSeg adjoins(LineSeg other) {
            if (this.x1 == other.x1 && this.y1 == other.y1) {
                return new LineSeg(this.x2, this.y2, other.x2, other.y2);
            }
            if (this.x1 == other.x2 && this.y1 == other.y2) {
                return new LineSeg(other.x1, other.y1, this.x2, this.y2);
            }
            if (this.x2 == other.x1 && this.y2 == other.y1) {
                return new LineSeg(this.x1, this.y1, other.x2, other.y2);
            }
            if (this.x2 == other.x2 && this.y2 == other.y2) {
                return new LineSeg(this.x1, this.y1, other.x1, other.y1);
            }
            return null;
        }
    }
}

