/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.menus.MenuCommands;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class RoutingTab
extends PreferencePanel {
    private PreferencesFrame parent;
    private Map<RoutingFrame.RoutingParameter, JComponent> currentParameters;
    private RoutingFrame.RoutingPrefs routingOptions;
    private ArcProto initRoutDefArc;
    private static boolean oneProcessorWarning = false;
    private static boolean twoProcessorWarning = false;
    private JPanel all;
    private JPanel auto;
    private JPanel experimental;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel70;
    private JPanel left;
    private JPanel mimic;
    private JPanel right;
    private JLabel routArcLabel;
    private JCheckBox routAutoCreateExports;
    private JRadioButton routAutoStitcher;
    private JComboBox routDefaultArc;
    private JComboBox routExperimental;
    private JCheckBox routMimicInteractive;
    private JCheckBox routMimicKeepPins;
    private JCheckBox routMimicNoOtherArcs;
    private JCheckBox routMimicNodeSizesMustMatch;
    private JCheckBox routMimicNodeTypesMustMatch;
    private JCheckBox routMimicNumArcsMustMatch;
    private JCheckBox routMimicOnlyNewTopology;
    private JCheckBox routMimicPortsMustMatch;
    private JCheckBox routMimicPortsWidthMustMatch;
    private JRadioButton routMimicStitcher;
    private JRadioButton routNoStitcher;
    private JCheckBox routOverrideArc;
    private ButtonGroup routStitcher;
    private JLabel routTechLabel;
    private JComboBox routTechnology;
    private JPanel routing;
    private JPanel seaOfGates;
    private JTextField sogComplexityLimit;
    private JComboBox sogContactSubcellAction;
    private JTextField sogForcedProcessorCount;
    private JCheckBox sogGlobalRouting;
    private JTextField sogMaxArcWidth;
    private JTextField sogMaxDistance;
    private JCheckBox sogParallel;
    private JCheckBox sogParallelDij;
    private JTextField sogRerunComplexityLimit;
    private JCheckBox sogRerunFailedRoutes;
    private JCheckBox sogRunOnConnectedRoutes;
    private JCheckBox sogSpineRouting;

    public RoutingTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.sogMaxArcWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.sogComplexityLimit);
        EDialog.makeTextFieldSelectAllOnTab(this.sogMaxDistance);
        EDialog.makeTextFieldSelectAllOnTab(this.sogRerunComplexityLimit);
        EDialog.makeTextFieldSelectAllOnTab(this.sogForcedProcessorCount);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.routing;
    }

    @Override
    public String getName() {
        return "Routing";
    }

    @Override
    public void init() {
        RoutingFrame[] algorithms;
        boolean initRoutMimicOn = Routing.isMimicStitchOn();
        boolean initRoutAutoOn = Routing.isAutoStitchOn();
        if (!initRoutMimicOn && !initRoutAutoOn) {
            this.routNoStitcher.setSelected(true);
        } else if (initRoutMimicOn) {
            this.routMimicStitcher.setSelected(true);
        } else {
            this.routAutoStitcher.setSelected(true);
        }
        this.sogMaxArcWidth.setText(TextUtils.formatDistance(Routing.getSeaOfGatesMaxWidth()));
        this.sogComplexityLimit.setText(Integer.toString(Routing.getSeaOfGatesComplexityLimit()));
        this.sogMaxDistance.setText(Integer.toString(Routing.getSeaOfGatesMaxDistance()));
        this.sogGlobalRouting.setSelected(Routing.isSeaOfGatesUseGlobalRouting());
        this.sogSpineRouting.setSelected(Routing.isSeaOfGatesEnableSpineRouting());
        this.sogRerunFailedRoutes.setSelected(Routing.isSeaOfGatesRerunFailedRoutes());
        this.sogRunOnConnectedRoutes.setSelected(Routing.isSeaOfGatesRunOnConnectedRoutes());
        this.sogContactSubcellAction.addItem(Routing.SoGContactsStrategy.SOGCONTACTSATTOPLEVEL);
        this.sogContactSubcellAction.addItem(Routing.SoGContactsStrategy.SOGCONTACTSUSEEXISTINGSUBCELLS);
        this.sogContactSubcellAction.addItem(Routing.SoGContactsStrategy.SOGCONTACTSALWAYSINSUBCELLS);
        this.sogContactSubcellAction.addItem(Routing.SoGContactsStrategy.SOGCONTACTSFORCESUBCELLS);
        this.sogContactSubcellAction.setSelectedIndex(Routing.getSeaOfGatesContactPlacementAction());
        this.sogRerunComplexityLimit.setText(Integer.toString(Routing.getSeaOfGatesRerunComplexityLimit()));
        this.sogForcedProcessorCount.setText(Integer.toString(Routing.getSeaOfGatesForcedProcessorCount()));
        this.sogParallel.setSelected(Routing.isSeaOfGatesUseParallelRoutes());
        this.sogParallel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoutingTab.this.sogParallelChanged();
            }
        });
        this.sogParallelDij.setSelected(Routing.isSeaOfGatesUseParallelFromToRoutes());
        this.sogParallelDij.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoutingTab.this.sogParallelChanged();
            }
        });
        this.routTechnology.setSelectedItem(Technology.getCurrent().getTechName());
        this.routOverrideArc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoutingTab.this.overrideChanged();
            }
        });
        String prefArcName = Routing.getPreferredRoutingArc();
        this.initRoutDefArc = null;
        if (prefArcName.length() > 0) {
            this.initRoutDefArc = ArcProto.findArcProto(prefArcName, Technology.getCurrent());
            this.routOverrideArc.setSelected(true);
        } else {
            this.routOverrideArc.setSelected(false);
        }
        this.overrideChanged();
        if (this.initRoutDefArc != null) {
            this.routTechnology.setSelectedItem(this.initRoutDefArc.getTechnology().getTechName());
            this.routDefaultArc.setSelectedItem(this.initRoutDefArc.getName());
        }
        this.routAutoCreateExports.setSelected(Routing.isAutoStitchCreateExports());
        this.routMimicPortsMustMatch.setSelected(Routing.isMimicStitchMatchPorts());
        this.routMimicPortsWidthMustMatch.setSelected(Routing.isMimicStitchMatchPortWidth());
        this.routMimicNumArcsMustMatch.setSelected(Routing.isMimicStitchMatchNumArcs());
        this.routMimicNodeSizesMustMatch.setSelected(Routing.isMimicStitchMatchNodeSize());
        this.routMimicNodeTypesMustMatch.setSelected(Routing.isMimicStitchMatchNodeType());
        this.routMimicNoOtherArcs.setSelected(Routing.isMimicStitchNoOtherArcsSameDir());
        this.routMimicOnlyNewTopology.setSelected(Routing.isMimicStitchOnlyNewTopology());
        this.routMimicInteractive.setSelected(Routing.isMimicStitchInteractive());
        this.routMimicKeepPins.setSelected(Routing.isMimicStitchPinsKept());
        for (RoutingFrame rf : algorithms = RoutingFrame.getRoutingAlgorithms()) {
            this.routExperimental.addItem(rf.getAlgorithmName());
        }
        this.routExperimental.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoutingTab.this.getAlgorithmParameters();
                RoutingTab.this.setupForAlgorithm();
            }
        });
        this.routingOptions = new RoutingFrame.RoutingPrefs(false);
        this.setupForAlgorithm();
    }

    private void setupForAlgorithm() {
        List<RoutingFrame.RoutingParameter> allParams;
        for (int i = this.experimental.getComponentCount() - 1; i >= 2; --i) {
            this.experimental.remove(i);
        }
        this.experimental.updateUI();
        this.currentParameters = new HashMap<RoutingFrame.RoutingParameter, JComponent>();
        String algName = (String)this.routExperimental.getSelectedItem();
        RoutingFrame[] algorithms = RoutingFrame.getRoutingAlgorithms();
        RoutingFrame whichOne = null;
        for (RoutingFrame an : algorithms) {
            if (!algName.equals(an.getAlgorithmName())) continue;
            whichOne = an;
            break;
        }
        if (whichOne != null && (allParams = whichOne.getParameters()) != null) {
            int yPos = 1;
            JSeparator sep = new JSeparator();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 10, 4, 10);
            this.experimental.add((Component)sep, gbc);
            for (RoutingFrame.RoutingParameter pp : allParams) {
                Object value = this.routingOptions.getParameter(pp);
                if (pp.getType() == 4) {
                    JCheckBox cb = new JCheckBox(pp.getName());
                    cb.setSelected((Boolean)value);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = yPos;
                    gbc.anchor = 17;
                    gbc.gridwidth = 2;
                    gbc.insets = new Insets(1, 4, 1, 4);
                    this.experimental.add((Component)cb, gbc);
                    this.currentParameters.put(pp, cb);
                } else {
                    JLabel lab = new JLabel(pp.getName());
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = yPos;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(1, 4, 1, 4);
                    this.experimental.add((Component)lab, gbc);
                    String init2 = null;
                    if (pp.getType() == 1) {
                        init2 = value.toString();
                    } else if (pp.getType() == 2) {
                        init2 = value.toString();
                    } else if (pp.getType() == 3) {
                        init2 = TextUtils.formatDouble((Double)value);
                    }
                    JTextField txt = new JTextField(init2);
                    txt.setColumns(init2.length() * 2);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = yPos;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(1, 4, 1, 4);
                    this.experimental.add((Component)txt, gbc);
                    this.currentParameters.put(pp, txt);
                }
                ++yPos;
            }
        }
        this.parent.pack();
    }

    private void overrideChanged() {
        boolean enableRest = this.routOverrideArc.isSelected();
        this.routTechnology.setEnabled(enableRest);
        this.routTechLabel.setEnabled(enableRest);
        this.routDefaultArc.setEnabled(enableRest);
        this.routArcLabel.setEnabled(enableRest);
    }

    private void sogParallelChanged() {
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        boolean twoPerRoute = this.sogParallelDij.isSelected();
        boolean parallelRouting = this.sogParallel.isSelected();
        if ((twoPerRoute || parallelRouting) && numberOfProcessors == 1 && !oneProcessorWarning) {
            oneProcessorWarning = true;
            Job.getUserInterface().showInformationMessage("This computer has only one processor and cannot do parallel routing.", "Not Enough Processors");
            return;
        }
        if (twoPerRoute && parallelRouting && numberOfProcessors == 2 && !twoProcessorWarning) {
            twoProcessorWarning = true;
            Job.getUserInterface().showInformationMessage("This computer has only two processors and so it can do either\n   'two processors per route' or 'multiple routes in parallel' but not both.\nIt is recommended that two-processor machines use 'two processors per route'.", "Not Enough Processors");
            return;
        }
    }

    @Override
    public void term() {
        boolean cur;
        String techName;
        Technology tech;
        boolean curSOGParallel;
        int useSubcellsForContacts;
        boolean runConnected;
        boolean reRun;
        boolean useSR;
        boolean useGR;
        int curSoGMInt;
        double curSOGMaxWid;
        boolean curAuto;
        boolean curMimic = this.routMimicStitcher.isSelected();
        if (curMimic != Routing.isMimicStitchOn()) {
            Routing.setMimicStitchOn(curMimic);
            MenuCommands.menuBar().updateAllButtons();
        }
        if ((curAuto = this.routAutoStitcher.isSelected()) != Routing.isAutoStitchOn()) {
            Routing.setAutoStitchOn(curAuto);
            MenuCommands.menuBar().updateAllButtons();
        }
        if ((curSOGMaxWid = TextUtils.atofDistance(this.sogMaxArcWidth.getText())) != Routing.getSeaOfGatesMaxWidth()) {
            Routing.setSeaOfGatesMaxWidth(curSOGMaxWid);
        }
        if ((curSoGMInt = TextUtils.atoi(this.sogComplexityLimit.getText())) != Routing.getSeaOfGatesComplexityLimit()) {
            Routing.setSeaOfGatesComplexityLimit(curSoGMInt);
        }
        if ((curSoGMInt = TextUtils.atoi(this.sogMaxDistance.getText())) != Routing.getSeaOfGatesMaxDistance()) {
            Routing.setSeaOfGatesMaxDistance(curSoGMInt);
        }
        if ((useGR = this.sogGlobalRouting.isSelected()) != Routing.isSeaOfGatesUseGlobalRouting()) {
            Routing.setSeaOfGatesUseGlobalRouting(useGR);
        }
        if ((useSR = this.sogSpineRouting.isSelected()) != Routing.isSeaOfGatesEnableSpineRouting()) {
            Routing.setSeaOfGatesEnableSpineRouting(useSR);
        }
        if ((reRun = this.sogRerunFailedRoutes.isSelected()) != Routing.isSeaOfGatesRerunFailedRoutes()) {
            Routing.setSeaOfGatesRerunFailedRoutes(reRun);
        }
        if ((runConnected = this.sogRunOnConnectedRoutes.isSelected()) != Routing.isSeaOfGatesRunOnConnectedRoutes()) {
            Routing.setSeaOfGatesRunOnConnectedRoutes(runConnected);
        }
        if ((useSubcellsForContacts = this.sogContactSubcellAction.getSelectedIndex()) != Routing.getSeaOfGatesContactPlacementAction()) {
            Routing.setSeaOfGatesContactPlacementAction(useSubcellsForContacts);
        }
        if ((curSoGMInt = TextUtils.atoi(this.sogRerunComplexityLimit.getText())) != Routing.getSeaOfGatesRerunComplexityLimit()) {
            Routing.setSeaOfGatesRerunComplexityLimit(curSoGMInt);
        }
        if ((curSoGMInt = TextUtils.atoi(this.sogForcedProcessorCount.getText())) != Routing.getSeaOfGatesForcedProcessorCount()) {
            Routing.setSeaOfGatesForcedProcessorCount(curSoGMInt);
        }
        if ((curSOGParallel = this.sogParallel.isSelected()) != Routing.isSeaOfGatesUseParallelRoutes()) {
            Routing.setSeaOfGatesUseParallelRoutes(curSOGParallel);
        }
        if ((curSOGParallel = this.sogParallelDij.isSelected()) != Routing.isSeaOfGatesUseParallelFromToRoutes()) {
            Routing.setSeaOfGatesUseParallelFromToRoutes(curSOGParallel);
        }
        ArcProto ap = null;
        if (this.routOverrideArc.isSelected() && (tech = Technology.findTechnology(techName = (String)this.routTechnology.getSelectedItem())) != null) {
            String curArcName = (String)this.routDefaultArc.getSelectedItem();
            ap = tech.findArcProto(curArcName);
        }
        if (ap != this.initRoutDefArc) {
            String newArcName = "";
            if (ap != null) {
                newArcName = ap.getTechnology().getTechName() + ":" + ap.getName();
            }
            Routing.setPreferredRoutingArc(newArcName);
        }
        if ((cur = this.routMimicPortsMustMatch.isSelected()) != Routing.isMimicStitchMatchPorts()) {
            Routing.setMimicStitchMatchPorts(cur);
        }
        if ((cur = this.routMimicPortsWidthMustMatch.isSelected()) != Routing.isMimicStitchMatchPortWidth()) {
            Routing.setMimicStitchMatchPortWidth(cur);
        }
        if ((cur = this.routMimicNumArcsMustMatch.isSelected()) != Routing.isMimicStitchMatchNumArcs()) {
            Routing.setMimicStitchMatchNumArcs(cur);
        }
        if ((cur = this.routMimicNodeSizesMustMatch.isSelected()) != Routing.isMimicStitchMatchNodeSize()) {
            Routing.setMimicStitchMatchNodeSize(cur);
        }
        if ((cur = this.routMimicNodeTypesMustMatch.isSelected()) != Routing.isMimicStitchMatchNodeType()) {
            Routing.setMimicStitchMatchNodeType(cur);
        }
        if ((cur = this.routMimicNoOtherArcs.isSelected()) != Routing.isMimicStitchNoOtherArcsSameDir()) {
            Routing.setMimicStitchNoOtherArcsSameDir(cur);
        }
        if ((cur = this.routMimicOnlyNewTopology.isSelected()) != Routing.isMimicStitchOnlyNewTopology()) {
            Routing.setMimicStitchOnlyNewTopology(cur);
        }
        if ((cur = this.routMimicInteractive.isSelected()) != Routing.isMimicStitchInteractive()) {
            Routing.setMimicStitchInteractive(cur);
        }
        if ((cur = this.routMimicKeepPins.isSelected()) != Routing.isMimicStitchPinsKept()) {
            Routing.setMimicStitchPinsKept(cur);
        }
        if ((cur = this.routAutoCreateExports.isSelected()) != Routing.isAutoStitchCreateExports()) {
            Routing.setAutoStitchCreateExports(cur);
        }
        this.getAlgorithmParameters();
        this.putPrefs(this.routingOptions);
    }

    @Override
    public void reset() {
        if (Routing.isFactoryMimicStitchOn() != Routing.isMimicStitchOn()) {
            Routing.setMimicStitchOn(Routing.isFactoryMimicStitchOn());
        }
        if (Routing.isFactoryAutoStitchOn() != Routing.isAutoStitchOn()) {
            Routing.setAutoStitchOn(Routing.isFactoryAutoStitchOn());
        }
        if (!Routing.getFactoryPreferredRoutingArc().equals(Routing.getPreferredRoutingArc())) {
            Routing.setPreferredRoutingArc(Routing.getFactoryPreferredRoutingArc());
        }
        if (Routing.getFactorySeaOfGatesMaxWidth() != Routing.getSeaOfGatesMaxWidth()) {
            Routing.setSeaOfGatesMaxWidth(Routing.getFactorySeaOfGatesMaxWidth());
        }
        if (Routing.getFactorySeaOfGatesComplexityLimit() != Routing.getSeaOfGatesComplexityLimit()) {
            Routing.setSeaOfGatesComplexityLimit(Routing.getFactorySeaOfGatesComplexityLimit());
        }
        if (Routing.getFactorySeaOfGatesMaxDistance() != Routing.getSeaOfGatesMaxDistance()) {
            Routing.setSeaOfGatesMaxDistance(Routing.getFactorySeaOfGatesMaxDistance());
        }
        if (Routing.isFactorySeaOfGatesUseGlobalRouting() != Routing.isSeaOfGatesUseGlobalRouting()) {
            Routing.setSeaOfGatesUseGlobalRouting(Routing.isFactorySeaOfGatesUseGlobalRouting());
        }
        if (Routing.isFactorySeaOfGatesEnableSpineRouting() != Routing.isSeaOfGatesEnableSpineRouting()) {
            Routing.setSeaOfGatesEnableSpineRouting(Routing.isFactorySeaOfGatesEnableSpineRouting());
        }
        if (Routing.isFactorySeaOfGatesRerunFailedRoutes() != Routing.isSeaOfGatesRerunFailedRoutes()) {
            Routing.setSeaOfGatesRerunFailedRoutes(Routing.isFactorySeaOfGatesRerunFailedRoutes());
        }
        if (Routing.isFactorySeaOfGatesRunOnConnectedRoutes() != Routing.isSeaOfGatesRunOnConnectedRoutes()) {
            Routing.setSeaOfGatesRunOnConnectedRoutes(Routing.isFactorySeaOfGatesRunOnConnectedRoutes());
        }
        if (Routing.getFactorySeaOfGatesContactPlacementAction() != Routing.getSeaOfGatesContactPlacementAction()) {
            Routing.setSeaOfGatesContactPlacementAction(Routing.getFactorySeaOfGatesContactPlacementAction());
        }
        if (Routing.getFactorySeaOfGatesRerunComplexityLimit() != Routing.getSeaOfGatesRerunComplexityLimit()) {
            Routing.setSeaOfGatesRerunComplexityLimit(Routing.getFactorySeaOfGatesRerunComplexityLimit());
        }
        if (Routing.isFactorySeaOfGatesUseParallelRoutes() != Routing.isSeaOfGatesUseParallelRoutes()) {
            Routing.setSeaOfGatesUseParallelRoutes(Routing.isFactorySeaOfGatesUseParallelRoutes());
        }
        if (Routing.isFactorySeaOfGatesUseParallelFromToRoutes() != Routing.isSeaOfGatesUseParallelFromToRoutes()) {
            Routing.setSeaOfGatesUseParallelFromToRoutes(Routing.isFactorySeaOfGatesUseParallelFromToRoutes());
        }
        if (Routing.getFactorySeaOfGatesForcedProcessorCount() != Routing.getSeaOfGatesForcedProcessorCount()) {
            Routing.setSeaOfGatesForcedProcessorCount(Routing.getFactorySeaOfGatesForcedProcessorCount());
        }
        if (Routing.isFactoryMimicStitchInteractive() != Routing.isMimicStitchInteractive()) {
            Routing.setMimicStitchInteractive(Routing.isFactoryMimicStitchInteractive());
        }
        if (Routing.isFactoryMimicStitchPinsKept() != Routing.isMimicStitchPinsKept()) {
            Routing.setMimicStitchPinsKept(Routing.isFactoryMimicStitchPinsKept());
        }
        if (Routing.isFactoryMimicStitchMatchPorts() != Routing.isMimicStitchMatchPorts()) {
            Routing.setMimicStitchMatchPorts(Routing.isFactoryMimicStitchMatchPorts());
        }
        if (Routing.isFactoryMimicStitchMatchPortWidth() != Routing.isMimicStitchMatchPortWidth()) {
            Routing.setMimicStitchMatchPortWidth(Routing.isFactoryMimicStitchMatchPortWidth());
        }
        if (Routing.isFactoryMimicStitchMatchNumArcs() != Routing.isMimicStitchMatchNumArcs()) {
            Routing.setMimicStitchMatchNumArcs(Routing.isFactoryMimicStitchMatchNumArcs());
        }
        if (Routing.isFactoryMimicStitchMatchNodeSize() != Routing.isMimicStitchMatchNodeSize()) {
            Routing.setMimicStitchMatchNodeSize(Routing.isFactoryMimicStitchMatchNodeSize());
        }
        if (Routing.isFactoryMimicStitchMatchNodeType() != Routing.isMimicStitchMatchNodeType()) {
            Routing.setMimicStitchMatchNodeType(Routing.isFactoryMimicStitchMatchNodeType());
        }
        if (Routing.isFactoryMimicStitchNoOtherArcsSameDir() != Routing.isMimicStitchNoOtherArcsSameDir()) {
            Routing.setMimicStitchNoOtherArcsSameDir(Routing.isFactoryMimicStitchNoOtherArcsSameDir());
        }
        if (Routing.isFactoryMimicStitchOnlyNewTopology() != Routing.isMimicStitchOnlyNewTopology()) {
            Routing.setMimicStitchOnlyNewTopology(Routing.isFactoryMimicStitchOnlyNewTopology());
        }
        if (Routing.isFactoryAutoStitchCreateExports() != Routing.isAutoStitchCreateExports()) {
            Routing.setAutoStitchCreateExports(Routing.isFactoryAutoStitchCreateExports());
        }
        this.putPrefs(new RoutingFrame.RoutingPrefs(true));
    }

    private void getAlgorithmParameters() {
        if (this.currentParameters == null) {
            return;
        }
        for (RoutingFrame.RoutingParameter pp : this.currentParameters.keySet()) {
            Object value;
            JComponent txt = this.currentParameters.get(pp);
            switch (pp.getType()) {
                case 1: {
                    value = TextUtils.atoi(((JTextField)txt).getText());
                    break;
                }
                case 2: {
                    value = String.valueOf(((JTextField)txt).getText());
                    break;
                }
                case 3: {
                    value = TextUtils.atof(((JTextField)txt).getText());
                    break;
                }
                case 4: {
                    value = ((JCheckBox)txt).isSelected();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.routingOptions = this.routingOptions.withParameter(pp, value);
        }
    }

    private void initComponents() {
        this.routStitcher = new ButtonGroup();
        this.routing = new JPanel();
        this.left = new JPanel();
        this.auto = new JPanel();
        this.routAutoCreateExports = new JCheckBox();
        this.mimic = new JPanel();
        this.jLabel70 = new JLabel();
        this.routMimicPortsMustMatch = new JCheckBox();
        this.routMimicInteractive = new JCheckBox();
        this.routMimicNumArcsMustMatch = new JCheckBox();
        this.routMimicNodeSizesMustMatch = new JCheckBox();
        this.routMimicNodeTypesMustMatch = new JCheckBox();
        this.routMimicNoOtherArcs = new JCheckBox();
        this.routMimicPortsWidthMustMatch = new JCheckBox();
        this.routMimicKeepPins = new JCheckBox();
        this.routMimicOnlyNewTopology = new JCheckBox();
        this.all = new JPanel();
        this.routTechLabel = new JLabel();
        this.routDefaultArc = new JComboBox();
        this.routNoStitcher = new JRadioButton();
        this.routAutoStitcher = new JRadioButton();
        this.routMimicStitcher = new JRadioButton();
        this.routTechnology = new JComboBox();
        this.routArcLabel = new JLabel();
        this.routOverrideArc = new JCheckBox();
        this.right = new JPanel();
        this.experimental = new JPanel();
        this.jLabel5 = new JLabel();
        this.routExperimental = new JComboBox();
        this.seaOfGates = new JPanel();
        this.jLabel2 = new JLabel();
        this.sogMaxArcWidth = new JTextField();
        this.jLabel3 = new JLabel();
        this.sogComplexityLimit = new JTextField();
        this.sogParallel = new JCheckBox();
        this.sogParallelDij = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.sogForcedProcessorCount = new JTextField();
        this.jLabel6 = new JLabel();
        this.sogGlobalRouting = new JCheckBox();
        this.sogRerunFailedRoutes = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.sogRerunComplexityLimit = new JTextField();
        this.sogSpineRouting = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.sogMaxDistance = new JTextField();
        this.sogRunOnConnectedRoutes = new JCheckBox();
        this.sogContactSubcellAction = new JComboBox();
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RoutingTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.routing.setLayout(new GridBagLayout());
        this.left.setLayout(new GridBagLayout());
        this.auto.setBorder(BorderFactory.createTitledBorder("Auto Stitcher"));
        this.auto.setLayout(new GridBagLayout());
        this.routAutoCreateExports.setText("Create exports where necessary");
        this.routAutoCreateExports.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.auto.add((Component)this.routAutoCreateExports, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.left.add((Component)this.auto, gridBagConstraints);
        this.mimic.setBorder(BorderFactory.createTitledBorder("Mimic Stitcher"));
        this.mimic.setLayout(new GridBagLayout());
        this.jLabel70.setText("Restrictions (when non-interactive):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 1, 4);
        this.mimic.add((Component)this.jLabel70, gridBagConstraints);
        this.routMimicPortsMustMatch.setText("Ports must match");
        this.routMimicPortsMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.mimic.add((Component)this.routMimicPortsMustMatch, gridBagConstraints);
        this.routMimicInteractive.setText("Interactive mimicking");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.mimic.add((Component)this.routMimicInteractive, gridBagConstraints);
        this.routMimicNumArcsMustMatch.setText("Number of existing arcs must match");
        this.routMimicNumArcsMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.mimic.add((Component)this.routMimicNumArcsMustMatch, gridBagConstraints);
        this.routMimicNodeSizesMustMatch.setText("Node sizes must match");
        this.routMimicNodeSizesMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.mimic.add((Component)this.routMimicNodeSizesMustMatch, gridBagConstraints);
        this.routMimicNodeTypesMustMatch.setText("Node types must match");
        this.routMimicNodeTypesMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.mimic.add((Component)this.routMimicNodeTypesMustMatch, gridBagConstraints);
        this.routMimicNoOtherArcs.setText("No other arcs in the same direction");
        this.routMimicNoOtherArcs.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.mimic.add((Component)this.routMimicNoOtherArcs, gridBagConstraints);
        this.routMimicPortsWidthMustMatch.setText("Bus ports must have same width");
        this.routMimicPortsWidthMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.mimic.add((Component)this.routMimicPortsWidthMustMatch, gridBagConstraints);
        this.routMimicKeepPins.setText("Keep pins");
        this.routMimicKeepPins.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.mimic.add((Component)this.routMimicKeepPins, gridBagConstraints);
        this.routMimicOnlyNewTopology.setText("Ignore if already connected elsewhere");
        this.routMimicOnlyNewTopology.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 4, 4);
        this.mimic.add((Component)this.routMimicOnlyNewTopology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.left.add((Component)this.mimic, gridBagConstraints);
        this.all.setBorder(BorderFactory.createTitledBorder("Stitching Routers"));
        this.all.setLayout(new GridBagLayout());
        this.routTechLabel.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.all.add((Component)this.routTechLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.all.add((Component)this.routDefaultArc, gridBagConstraints);
        this.routStitcher.add(this.routNoStitcher);
        this.routNoStitcher.setText("No stitcher running");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.all.add((Component)this.routNoStitcher, gridBagConstraints);
        this.routStitcher.add(this.routAutoStitcher);
        this.routAutoStitcher.setText("Auto-stitcher running");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.all.add((Component)this.routAutoStitcher, gridBagConstraints);
        this.routStitcher.add(this.routMimicStitcher);
        this.routMimicStitcher.setText("Mimic-stitcher running");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.all.add((Component)this.routMimicStitcher, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.all.add((Component)this.routTechnology, gridBagConstraints);
        this.routArcLabel.setText("Arc:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 4, 4);
        this.all.add((Component)this.routArcLabel, gridBagConstraints);
        this.routOverrideArc.setText("Use this arc in stitching routers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 1, 4);
        this.all.add((Component)this.routOverrideArc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        this.left.add((Component)this.all, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.routing.add((Component)this.left, gridBagConstraints);
        this.right.setLayout(new GridBagLayout());
        this.experimental.setBorder(BorderFactory.createTitledBorder("Experimental Routers"));
        this.experimental.setLayout(new GridBagLayout());
        this.jLabel5.setText("Routing algorithm:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.experimental.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.experimental.add((Component)this.routExperimental, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.right.add((Component)this.experimental, gridBagConstraints);
        this.seaOfGates.setBorder(BorderFactory.createTitledBorder("Sea-of-Gates Router"));
        this.seaOfGates.setLayout(new GridBagLayout());
        this.jLabel2.setText("Maximum arc width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.jLabel2, gridBagConstraints);
        this.sogMaxArcWidth.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.sogMaxArcWidth, gridBagConstraints);
        this.jLabel3.setText("Search complexity limit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.jLabel3, gridBagConstraints);
        this.sogComplexityLimit.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.sogComplexityLimit, gridBagConstraints);
        this.sogParallel.setText("Do multiple routes in parallel");
        this.sogParallel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.seaOfGates.add((Component)this.sogParallel, gridBagConstraints);
        this.sogParallelDij.setText("Use two processors per route");
        this.sogParallelDij.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.seaOfGates.add((Component)this.sogParallelDij, gridBagConstraints);
        this.jLabel4.setText("If there are multiple processors available:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 1, 4);
        this.seaOfGates.add((Component)this.jLabel4, gridBagConstraints);
        this.sogForcedProcessorCount.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.sogForcedProcessorCount, gridBagConstraints);
        this.jLabel6.setText("Forced processor count:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.jLabel6, gridBagConstraints);
        this.sogGlobalRouting.setText("Do Global Routing");
        this.sogGlobalRouting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.seaOfGates.add((Component)this.sogGlobalRouting, gridBagConstraints);
        this.sogRerunFailedRoutes.setText("Rerun routing with failed routes");
        this.sogRerunFailedRoutes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.seaOfGates.add((Component)this.sogRerunFailedRoutes, gridBagConstraints);
        this.jLabel7.setText("Rerun complexity limit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 4, 4);
        this.seaOfGates.add((Component)this.jLabel7, gridBagConstraints);
        this.sogRerunComplexityLimit.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 2, 4);
        this.seaOfGates.add((Component)this.sogRerunComplexityLimit, gridBagConstraints);
        this.sogSpineRouting.setText("Do Spine Routing");
        this.sogSpineRouting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.seaOfGates.add((Component)this.sogSpineRouting, gridBagConstraints);
        this.jLabel1.setText("Maximum search factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.seaOfGates.add((Component)this.sogMaxDistance, gridBagConstraints);
        this.sogRunOnConnectedRoutes.setText("Run even on connected routes");
        this.sogRunOnConnectedRoutes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.seaOfGates.add((Component)this.sogRunOnConnectedRoutes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.seaOfGates.add((Component)this.sogContactSubcellAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.right.add((Component)this.seaOfGates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.routing.add((Component)this.right, gridBagConstraints);
        this.getContentPane().add((Component)this.routing, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

