/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.user.menus.WindowMenu;
import com.sun.electric.tool.user.ncc.ComparisonsPane;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;

public class NccMsgsFrame {
    protected static Container frame;
    private static boolean placed;
    private ComparisonsPane comparPane;
    private List<NccGuiInfo> mismatches;
    private NccOptions nccOptions;

    public NccMsgsFrame() {
        Container contentPane;
        Dimension scrnSize = TopLevel.getScreenSize();
        if (TopLevel.isMDIMode()) {
            JInternalFrame jInternalFrame = new JInternalFrame("NCC Messages", true, true, true, true);
            jInternalFrame.setDefaultCloseOperation(1);
            frame = jInternalFrame;
            contentPane = jInternalFrame.getContentPane();
            jInternalFrame.setFrameIcon(TopLevel.getFrameIcon());
        } else {
            JFrame jFrame = new JFrame("NCC Messages");
            jFrame.setDefaultCloseOperation(1);
            frame = jFrame;
            contentPane = jFrame.getContentPane();
            jFrame.setIconImage(TopLevel.getFrameIcon().getImage());
        }
        this.comparPane = new ComparisonsPane();
        contentPane.add(this.comparPane);
        this.comparPane.setPreferredSize(new Dimension(scrnSize.width / 3 * 2, scrnSize.height / 3 * 2));
        frame.setLocation(scrnSize.width / 6, scrnSize.height / 6);
        frame.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (WindowMenu.getCloseWindowAccelerator() == KeyStroke.getKeyStrokeForEvent(event)) {
                    frame.setVisible(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent event) {
            }

            @Override
            public void keyReleased(KeyEvent event) {
            }
        });
    }

    public static Container getCurrentFrame() {
        return frame;
    }

    public void setMismatches(List<NccGuiInfo> misms, NccOptions options) {
        this.mismatches = misms;
        this.nccOptions = options;
    }

    public void display() {
        if (this.mismatches.size() == 0) {
            frame.setVisible(false);
            return;
        }
        this.comparPane.setMismatches(this.mismatches);
        if (TopLevel.isMDIMode()) {
            JInternalFrame jif = (JInternalFrame)frame;
            if (!placed) {
                placed = true;
                jif.pack();
                TopLevel.addToDesktop(jif);
            }
            try {
                jif.setIcon(false);
                jif.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!jif.isVisible()) {
                jif.setVisible(true);
                jif.show();
            }
            jif.toFront();
            jif.requestFocusInWindow();
        } else {
            JFrame jf = (JFrame)frame;
            jf.setState(0);
            if (!jf.isVisible()) {
                jf.setVisible(true);
                if (!placed) {
                    placed = true;
                    jf.pack();
                }
                jf.setVisible(true);
            }
            jf.toFront();
            jf.requestFocus();
        }
    }

    static {
        placed = false;
    }
}

