// { dg-options "-std=gnu++17" }
// { dg-do run { target c++17 } }

// Copyright (C) 2018-2021 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// 30.11.7.4.9 path decomposition [fs.path.decompose]

#include <filesystem>
#include <testsuite_hooks.h>

using std::filesystem::path;

void
test01()
{
#ifdef _GLIBCXX_FILESYSTEM_IS_WINDOWS
  const bool is_posix = false;
#else
  const bool is_posix = true;
#endif

  VERIFY( path("/").is_absolute() == is_posix );
  VERIFY( path("/foo").is_absolute() == is_posix );
  VERIFY( path("/foo/").is_absolute() == is_posix );
  VERIFY( path("/foo/bar").is_absolute() == is_posix );
  VERIFY( path("/foo/bar/").is_absolute() == is_posix );
  VERIFY( ! path("foo").is_absolute() );
  VERIFY( ! path("foo/").is_absolute() );
  VERIFY( ! path("foo/bar").is_absolute() );
  VERIFY( ! path("foo/bar/").is_absolute() );
  VERIFY( ! path("c:").is_absolute() );
  VERIFY( ! path("c:foo").is_absolute() );
  VERIFY( ! path("c:foo/").is_absolute() );
  VERIFY( ! path("c:foo/bar").is_absolute() );
  VERIFY( ! path("c:foo/bar/").is_absolute() );
  VERIFY( path("c:/").is_absolute() == !is_posix );
  VERIFY( path("c:/foo").is_absolute() == !is_posix );
  VERIFY( path("c:/foo/").is_absolute() == !is_posix );
  VERIFY( path("c:/foo/bar").is_absolute() == !is_posix );
  VERIFY( path("c:/foo/bar/").is_absolute() == !is_posix );
}

int
main()
{
  test01();
}
