/* gnu/java/lang/CharData -- Database for java.lang.Character Unicode info
   Copyright (C) 2002 Free Software Foundation, Inc.
   *** This file is generated by scripts/unicode-muncher.pl ***

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.lang;

/**
 * This contains the info about the unicode characters, that
 * java.lang.Character needs.  It is generated automatically from
 * <code>gnu/gcj/convert/UnicodeData-3.0.0.txt</code>, by some
 * perl scripts. This Unicode definition file can be found on the
 * <a href="http://www.unicode.org">http://www.unicode.org</a> website.
 * JDK 1.4 uses Unicode version 3.0.0.
 *
 * The data is stored as string constants, but Character will convert these
 * Strings to their respective <code>char[]</code> components.  The field
 * <code>BLOCKS</code> stores the offset of a block of 2<sup>SHIFT</sup>
 * characters within <code>DATA</code>.  The DATA field, in turn, stores
 * information about each character in the low order bits, and an offset
 * into the attribute tables <code>UPPER</code>, <code>LOWER</code>,
 * <code>NUM_VALUE</code>, and <code>DIRECTION</code>.  Notice that the
 * attribute tables are much smaller than 0xffff entries; as many characters
 * in Unicode share common attributes.  Finally, there is a listing for
 * <code>TITLE</code> exceptions (most characters just have the same
 * title case as upper case).
 *
 * @author scripts/unicode-muncher.pl (written by Jochen Hoenicke,
 *         Eric Blake)
 * @see Character
 */
public interface CharData
{
  /**
   * The Unicode definition file that was parsed to build this database.
   */
  String SOURCE = "gnu/gcj/convert/UnicodeData-3.0.0.txt";

  /**
   * The character shift amount to look up the block offset. In other words,
   * <code>(char) (BLOCKS.value[ch >> SHIFT] + ch)</code> is the index where
   * <code>ch</code> is described in <code>DATA</code>.
   */
  int SHIFT = 5;

  /**
   * The mapping of character blocks to their location in <code>DATA</code>.
   * Each entry has been adjusted so that the 16-bit sum with the desired
   * character gives the actual index into <code>DATA</code>.
   */
  String BLOCKS
    = "\u01c2\u01c2\u01c1\u012c\u012b\u01a0\u01f8\u027e\u0201\u0290\u01b7"
    + "\u02c9\u0157\u02a9\u023f\u01b8\u0101\u0257\u02f9\u02f9\u0370\u0363"
    + "\ufe8f\u033e\uff85\uff65\ufdb5\ufda1\uffbd\u02be\uffbe\uffe9\ufea8"
    + "\uff2e\u022f\ufea1\uff9d\ufe61\uffa9\ufb20\u00c3\u010d\u00fe\ufb61"
    + "\ufb5a\u0105\u0103\u00f8\ufe8b\u0223\u0258\u01c1\u01f6\u01d6\ufee1"
    + "\u0223\ufdaa\ufb55\u0163\ufe63\u00f6\u00fd\ufe03\ufde3\ufdc3\ufda3"
    + "\ufd83\ufd63\ufd43\ufd23\ufd03\ufce3_J\u00a5\u0133\ufe08"
    + "]\u014f\u01a2\uf669\u0123\u0122\uf8c1\ufe50\u0102\u0101\ufa43"
    + "\ufc88\ufea7\u00c0\ufca1\ufb8f\uf47d\u0099\ufb11\ufe1a\ufd22\ufb29"
    + "5\uf3b9\ufe51\ufcc8\uffb5\uf339\ufa92\uff85\uff35\ufa4e\uf766"
    + "\uff25\ufad1\ufb63\ufc34\ufedf\uf763\ufcaa\ufa82\ufdb9\uf6e3\ufe3f"
    + "\ufcc1\ufe49\uf7eb\uf70f\uf2e8\ufd99\uf5e3\uf964\ufbfc\ufd91\uf563"
    + "\uf543\uf43c\uf436\uef6b\uf864\uf844\ufc52\uf804\uf7e4\ufc09\uf7a4"
    + "\uee9c\ufb8a\uf744\uf7f4\uf704\uf7c4\uf78c\uf46b\uf4cc\uf72c\uf644"
    + "\uf3fb\uf647\uf243\uf5c4\uf5a4\ueca1\uf563\uf544\uf524\uf504\uf4e4"
    + "\uf4c4\uf4a4\uf484\uf464\uf444\uf424\uf404\uf3e4\uf3c4\uf3a4\uf384"
    + "\uf364\uf344\uf324\uf283\uf771\uf2c4\uf2a4\uf731\ueec3\ueea3\uee83"
    + "\uee63\uf1e4\uf49c\uf53f\ued49\uf2d1\uf144\ue8ed\ue81e\uf0e4\uf591"
    + "\ued03\uece3\uecc3\ueca3\uec83\uec63\uec43\uec23\uec03\uebe3\uebc3"
    + "\ueba3\ueb83\ueb63\ueb43\ueb23\ueb03\ueae3\ueac3\ueaa3\uea83\uea63"
    + "\uea43\uea23\uea03\ue9e3\ue9c3\ue9a3\ue983\ue963\ue943\ue923\ue903"
    + "\ue8e3\ue8c3\ue8a3\ue883\ue863\ue843\ue823\ue803\ue7e3\ue501\ue4e1"
    + "\ue4c1\ue4a1\uefd1\ue461\ue441\ue427\uef81\uef51\uef51\uef51\uef51"
    + "\uef41\ue1ad\uef40\uef40\uef40\ue1e0\ue37f\uef00\ue9d3\uebe5\ue4df"
    + "\ueece\uef5f\ue490\uef3f\ueee3\uef76\uee6e\uef6a\uef77\uef72\uee8b"
    + "\uefcd\uee77\uee1f\uee21\uef5f\uefd7\uee90\uefcd\uefdb\uef63\ue223"
    + "\ue203\ue1e3\ued25\ued37\ued13\uef16\uef02\ued41\ued37\ued2d\uec25"
    + "\uec05\uebe5\uebc5\uebc8\uea76\ueb63\ueb66\ue9b0\ueb05\ueae5\ue9e3"
    + "\udf43\udf23\udf03\udee3\ue90a\uea1d\ueb52\ueb49\ueb3f\ueadf\ude03"
    + "\udde3\ue925\ue905\ue8e5\ue8c5\ue8a5\ue885\ue865\ue845\udcc3\udca3"
    + "\udc83\udc63\udc43\udc23\udc03\udbe3\udbc3\udba3\udb83\udb63\udb43"
    + "\udb23\udb03\udae3\udac3\udaa3\uda83\uda63\uda43\uda23\uda03\ud9e3"
    + "\ud9c3\ud9a3\ud983\ud963\ud943\ud923\ud903\ud8e3\ud8c3\ud8a3\ud883"
    + "\ud863\ud843\ud823\ud803\ud7e3\ud7c3\ud7a3\ud783\ud763\ue2ab\ue285"
    + "\ue265\ue26a\ue225\ue205\ue1e5\ue1c5\ue1a5\ue185\ue188\udd89\ue3a2"
    + "\udfcd\ud923\ud904\ue342\ud8c3\ud8a4\udcd1\udcac\ud67b\ud824\ud804"
    + "\ue262\ucede\ud403\ud3e3\ue110\ue0e3\ue1c5\ue0b1\ue0b1\ue158\udf11"
    + "\ue02e\ue00d\udfed\udfcd\ude66\udf8d\udf6d\udf4f\udf2e\ud564\ud544"
    + "\ud524\ud504\ud4e4\ud4c4\ud4a4\ud484\ud464\ud444\ud424\ud404\ud3e4"
    + "\ud3c4\ud3a4\ud384\ud364\ud344\ud324\ud304\ud2e4\ud2c4\ud2a4\ud284"
    + "\ud264\ud244\ud224\ud204\ud1e4\ud1c4\ud1a4\ud184\ud164\ud144\ud124"
    + "\ud104\ud0e4\ud0c4\ud0a4\ud084\ud064\ud044\ud024\ud004\ucfe4\ucfc4"
    + "\ucfa4\ucf84\ucf64\ucf44\ucf24\ucf04\ucee4\ucec4\ucea4\uce84\uce64"
    + "\uce44\uce24\uce04\ucde4\ucdc4\ucda4\ucd84\ucd64\ucd44\ucd24\ucd04"
    + "\ucce4\uccc4\ucca4\ucc84\ucc64\ucc44\ucc24\ucc04\ucbe4\ucbc4\ucba4"
    + "\ucb84\ucb64\ucb44\ucb24\ucb04\ucae4\ucac4\ucaa4\uca84\uca64\uca44"
    + "\uca24\uca04\uc9e4\uc9c4\uc9a4\uc984\uc964\uc944\uc924\uc904\uc8e4"
    + "\uc8c4\uc8a4\uc884\uc864\uc844\uc824\uc804\uc7e4\uc7c4\uc7a4\uc784"
    + "\uc764\uc744\uc724\uc704\uc6e4\uc6c4\uc6a4\uc684\uc664\uc644\uc624"
    + "\uc604\uc5e4\uc5c4\uc5a4\uc584\uc564\uc544\uc524\uc504\uc4e4\uc4c4"
    + "\uc4a4\uc484\uc464\uc444\uc424\uc404\uc3e4\uc3c4\uc3a4\uc384\uc364"
    + "\uc344\uc324\uc304\uc2e4\uc2c4\uc2a4\uc284\uc264\uc244\uc224\uc204"
    + "\uc1e4\uc1c4\uc1a4\uc184\uc164\uc144\uc124\uc104\uc0e4\uc0c4\uc0a4"
    + "\uc084\uc064\uc044\uc024\uc004\ubfe4\ubfc4\ubfa4\ubf84\ubf64\ubf44"
    + "\ubf24\ubf04\ubee4\ubec4\ubea4\ube84\ube64\ube44\ube24\ube04\ubde4"
    + "\ubdc4\ubda4\ubd84\ubd64\ubd44\ubd24\ubd04\ubce4\ubcc4\ubca4\ubc84"
    + "\ubc64\ubc44\ubc24\ubc04\ubbe4\ub2e0\ub803\ub7e3\ubb64\ubb44\ubb24"
    + "\ubb04\ubae4\ubac4\ubaa4\uba84\uba64\uba44\uba24\uba04\ub9e4\ub9c4"
    + "\ub9a4\ub984\ub964\ub944\ub924\ub904\ub8e4\ub8c4\ub8a4\ub884\ub864"
    + "\ub844\ub824\ub804\ub7e4\ub7c4\ub7a4\ub784\ub764\ub744\ub724\ub704"
    + "\ub6e4\ub6c4\ub6a4\ub684\ub664\ub644\ub624\ub604\ub5e4\ub5c4\ub5a4"
    + "\ub584\ub564\ub544\ub524\ub504\ub4e4\ub4c4\ub4a4\ub484\ub464\ub444"
    + "\ub424\ub404\ub3e4\ub3c4\ub3a4\ub384\ub364\ub344\ub324\ub304\ub2e4"
    + "\ub2c4\ub2a4\ub284\ub264\ub244\ub224\ub204\ub1e4\ub1c4\ub1a4\ub184"
    + "\ub164\ub144\ub124\ub104\ub0e4\ub0c4\ub0a4\ub084\ub064\ub044\ub024"
    + "\ub004\uafe4\uafc4\uafa4\uaf84\uaf64\uaf44\uaf24\uaf04\uaee4\uaec4"
    + "\uaea4\uae84\uae64\uae44\uae24\uae04\uade4\uadc4\uada4\uad84\uad64"
    + "\uad44\uad24\uad04\uace4\uacc4\uaca4\uac84\uac64\uac44\uac24\uac04"
    + "\uabe4\uabc4\uaba4\uab84\uab64\uab44\uab24\uab04\uaae4\uaac4\uaaa4"
    + "\uaa84\uaa64\uaa44\uaa24\uaa04\ua9e4\ua9c4\ua9a4\ua984\ua964\ua944"
    + "\ua924\ua904\ua8e4\ua8c4\ua8a4\ua884\ua864\ua844\ua824\ua804\ua7e4"
    + "\ua7c4\ua7a4\ua784\ua764\ua744\ua724\ua704\ua6e4\ua6c4\ua6a4\ua684"
    + "\ua664\ua644\ua624\ua604\ua5e4\ua5c4\ua5a4\ua584\ua564\ua544\ua524"
    + "\ua504\ua4e4\ua4c4\ua4a4\ua484\ua464\ua444\ua424\ua404\ua3e4\ua3c4"
    + "\ua3a4\ua384\ua364\ua344\ua324\ua304\ua2e4\ua2c4\ua2a4\ua284\ua264"
    + "\ua244\ua224\ua204\ua1e4\ua1c4\ua1a4\ua184\ua164\ua144\ua124\ua104"
    + "\ua0e4\ua0c4\ua0a4\ua084\ua064\ua044\ua024\ua004\u9fe4\u9fc4\u9fa4"
    + "\u9f84\u9f64\u9f44\u9f24\u9f04\u9ee4\u9ec4\u9ea4\u9e84\u9e64\u9e44"
    + "\u9e24\u9e04\u9de4\u9dc4\u9da4\u9d84\u9d64\u9d44\u9d24\u9d04\u9ce4"
    + "\u9cc4\u9ca4\u9c84\u9c64\u9c44\u9c24\u9c04\u9be4\u9bc4\u9ba4\u9b84"
    + "\u9b64\u9b44\u9b24\u9b04\u9ae4\u9ac4\u9aa4\u9a84\u9a64\u9a44\u9a24"
    + "\u9a04\u99e4\u99c4\u99a4\u9984\u9964\u9944\u9924\u9904\u98e4\u98c4"
    + "\u98a4\u9884\u9864\u9844\u9824\u9804\u97e4\u97c4\u97a4\u9784\u9764"
    + "\u9744\u9724\u9704\u96e4\u96c4\u96a4\u9684\u9664\u9644\u9624\u9604"
    + "\u95e4\u95c4\u95a4\u9584\u9564\u9544\u9524\u9504\u94e4\u94c4\u94a4"
    + "\u9484\u9464\u9444\u9424\u9404\u93e4\u93c4\u93a4\u9384\u9364\u9344"
    + "\u9324\u9304\u92e4\u92c4\u92a4\u9284\u9264\u9244\u9224\u9204\u91e4"
    + "\u91c4\u91a4\u9184\u9164\u9144\u9124\u9104\u90e4\u90c4\u90a4\u9084"
    + "\u9064\u9044\u9024\u9004\u8fe4\u8fc4\u8fa4\u8f84\u8f64\u8f44\u8f24"
    + "\u8f04\u8ee4\u8ec4\u8ea4\u8e84\u8e64\u8e44\u8e24\u8e04\u8de4\u8dc4"
    + "\u8da4\u8d84\u8d64\u8d44\u8d24\u8d04\u8ce4\u8cc4\u8ca4\u8c84\u8c64"
    + "\u8c44\u8c24\u8c04\u8be4\u8bc4\u8ba4\u8b84\u8b64\u8b44\u8b24\u8b04"
    + "\u8ae4\u8ac4\u8aa4\u8a84\u8a64\u8a44\u8a24\u8a04\u89e4\u89c4\u89a4"
    + "\u8984\u8964\u8944\u8924\u8904\u88e4\u88c4\u88a4\u8884\u8864\u8844"
    + "\u8824\u8804\u87e4\u87c4\u87a4\u8784\u8764\u8744\u8724\u8704\u86e4"
    + "\u86c4\u86a4\u8684\u8664\u8644\u8624\u8604\u85e4\u85c4\u85a4\u8584"
    + "\u8564\u8544\u8524\u8504\u84e4\u84c4\u84a4\u8484\u8464\u8444\u8424"
    + "\u8404\u83e4\u83c4\u83a4\u8384\u8364\u8344\u8324\u8304\u82e4\u82c4"
    + "\u82a4\u8284\u8264\u8244\u8224\u8204\u81e4\u81c4\u81a4\u8184\u8164"
    + "\u8144\u8124\u8104\u80e4\u80c4\u80a4\u8084\u8064\u8044\u8024\u8004"
    + "\u7fe4\u7fc4\u7fa4\u7f84\u7f64\u7f44\u7f24\u7f04\u7ee4\u7ec4\u7ea4"
    + "\u7e84\u7e64\u7e44\u7e24\u7e04\u7de4\u7dc4\u7da4\u7d84\u7d64\u7d44"
    + "\u7d24\u7d04\u7ce4\u7cc4\u7ca4\u7c84\u7c64\u7c44\u7c24\u7c04\u7be4"
    + "\u7bc4\u7ba4\u7b84\u7b64\u7b44\u7b24\u7b04\u7ae4\u7ac4\u7aa4\u7a84"
    + "\u7a64\u7a44\u7a24\u7a04\u79e4\u79c4\u79a4\u7984\u7964\u7944\u7924"
    + "\u7904\u78e4\u78c4\u78a4\u7884\u7864\u7844\u7824\u7804\u77e4\u77c4"
    + "\u77a4\u7784\u7764\u7744\u7724\u7704\u76e4\u76c4\u76a4\u7684\u7664"
    + "\u7644\u7624\u7604\u75e4\u75c4\u75a4\u7584\u7564\u7544\u7524\u7504"
    + "\u74e4\u74c4\u74a4\u7484\u7464\u7444\u7424\u7404\u73e4\u73c4\u73a4"
    + "\u7384\u7364\u7344\u7324\u7304\u72e4\u72c4\u72a4\u7284\u7264\u7244"
    + "\u7224\u7204\u71e4\u71c4\u71a4\u7184\u7164\u7144\u7124\u7104\u70e4"
    + "\u70c4\u70a4\u7084\u7064\u7044\u7024\u7004\u6fe4\u6fc4\u6fa4\u6f84"
    + "\u6f64\u6f44\u6f24\u6f04\u6ee4\u6ec4\u6ea4\u6e84\u6e64\u6e44\u6e24"
    + "\u6e04\u6de4\u6dc4\u6da4\u6d84\u6d64\u6d44\u6d24\u6d04\u6ce4\u6cc4"
    + "\u6ca4\u6c84\u6c64\u6c44\u6c24\u6c04\u6be4\u6bc4\u6ba4\u6b84\u6b64"
    + "\u6b44\u6b24\u6b04\u6ae4\u6ac4\u6aa4\u6a84\u6a64\u6a44\u6a24\u6a04"
    + "\u69e4\u60f0\u6603\u65e3\u6964\u6944\u6924\u6904\u68e4\u68c4\u68a4"
    + "\u6884\u6864\u6844\u6824\u6804\u67e4\u67c4\u67a4\u6784\u6764\u6744"
    + "\u6724\u6704\u66e4\u66c4\u66a4\u6684\u6664\u6644\u6624\u6604\u65e4"
    + "\u65c4\u65a4\u6584\u6564\u6544\u6524\u6504\u6b20\u6ddb\u6e96\u60e3"
    + "\u60c3\u60a3\u6083\u6063\u6043\u6023\u6003\u5fe3\u5fc3\u5fa3\u5f83"
    + "\u5f63\u5f43\u5f23\u5f03\u5ee3\u5ec3\u5ea3\u5e83\u5e63\u5e43\u5e23"
    + "\u5e03\u5de3\u5dc3\u5da3\u5d83\u5d63\u5d43\u5d23\u5d03\u5ce3\u5cc3"
    + "\u5ca3\u5c83\u5c63\u5c43\u5c23\u5c03\u5be3\u5bc3\u5ba3\u5b83\u5b63"
    + "\u5b43\u5b23\u5b03\u5ae3\u5ac3\u5aa3\u5a83\u5a63\u5a43\u5a23\u5a03"
    + "\u59e3\u5d64\u5d44\u5d24\u5d04\u5ce4\u5cc4\u5ca4\u5c84\u5c64\u5c44"
    + "\u5c24\u5c04\u5be4\u5bc4\u5ba4\u5b84\u5b64\u5b44\u5b24\u5b04\u5ae4"
    + "\u5ac4\u5aa4\u5a84\u5a64\u5a44\u5a24\u5a04\u59e4\u59c4\u59a4\u5984"
    + "\u5964\u5944\u5924\u5904\u58e4\u58c4\u58a4\u5884\u5864\u5844\u5824"
    + "\u5804\u57e4\u57c4\u57a4\u5784\u5764\u5744\u5724\u5704\u56e4\u56c4"
    + "\u56a4\u5684\u5664\u5644\u5624\u5604\u55e4\u55c4\u55a4\u5584\u5564"
    + "\u5544\u5524\u5504\u54e4\u54c4\u54a4\u5484\u5464\u5444\u5424\u5404"
    + "\u53e4\u53c4\u53a4\u5384\u5364\u5344\u5324\u5304\u52e4\u52c4\u52a4"
    + "\u5284\u5264\u5244\u5224\u5204\u51e4\u51c4\u51a4\u5184\u5164\u5144"
    + "\u5124\u5104\u50e4\u50c4\u50a4\u5084\u5064\u5044\u5024\u5004\u4fe4"
    + "\u4fc4\u4fa4\u4f84\u4f64\u4f44\u4f24\u4f04\u4ee4\u4ec4\u4ea4\u4e84"
    + "\u4e64\u4e44\u4e24\u4e04\u4de4\u4dc4\u4da4\u4d84\u4d64\u4d44\u4d24"
    + "\u4d04\u4ce4\u4cc4\u4ca4\u4c84\u4c64\u4c44\u4c24\u4c04\u4be4\u4bc4"
    + "\u4ba4\u4b84\u4b64\u4b44\u4b24\u4b04\u4ae4\u4ac4\u4aa4\u4a84\u4a64"
    + "\u4a44\u4a24\u4a04\u49e4\u49c4\u49a4\u4984\u4964\u4944\u4924\u4904"
    + "\u48e4\u48c4\u48a4\u4884\u4864\u4844\u4824\u4804\u47e4\u47c4\u47a4"
    + "\u4784\u4764\u4744\u4724\u4704\u46e4\u46c4\u46a4\u4684\u4664\u4644"
    + "\u4624\u4604\u45e4\u45c4\u45a4\u4584\u4564\u4544\u4524\u4504\u44e4"
    + "\u44c4\u44a4\u4484\u4464\u4444\u4424\u4404\u43e4\u43c4\u43a4\u4384"
    + "\u4364\u4344\u4324\u4304\u42e4\u42c4\u42a4\u4284\u4264\u4244\u4224"
    + "\u4204\u41e4\u41c4\u41a4\u4184\u4164\u4144\u4124\u4104\u40e4\u40c4"
    + "\u40a4\u4084\u4064\u4044\u4024\u4004\u3fe4\u3fc4\u3fa4\u3f84\u3f64"
    + "\u3f44\u3f24\u3f04\u3ee4\u3ec4\u3ea4\u3e84\u3e64\u3e44\u3e24\u3e04"
    + "\u3de4\u3dc4\u3da4\u3d84\u3d64\u3d44\u3d24\u3d04\u3ce4\u3cc4\u3ca4"
    + "\u3c84\u3c64\u3c44\u3c24\u3c04\u3be4\u3bc4\u3ba4\u3b84\u3b64\u3b44"
    + "\u3b24\u3b04\u3ae4\u3ac4\u3aa4\u3a84\u3a64\u3a44\u3a24\u3a04\u39e4"
    + "\u39c4\u39a4\u3984\u3964\u3944\u3924\u3904\u38e4\u38c4\u38a4\u3884"
    + "\u3864\u3844\u3824\u3804\u37e4\u37c4\u37a4\u3784\u3764\u3744\u3724"
    + "\u3704\u36e4\u36c4\u36a4\u3684\u3664\u3644\u3624\u3604\u35e4\u35c4"
    + "\u35a4\u3584\u3564\u3544\u3524\u3504\u34e4\u34c4\u34a4\u3484\u3464"
    + "\u3444\u3424\u3404\u33e4\u33c4\u33a4\u3384\u3364\u3344\u3324\u3304"
    + "\u32e4\u32c4\u32a4\u3284\u3264\u3244\u3224\u3204\u31e4\u28f2\u2e03"
    + "\u2de3\u3c25\u3c05\u3be5\u3bc5\u3ba5\u3b85\u3b65\u3b45\u3b25\u3b05"
    + "\u3ae5\u3ac5\u3aa5\u3a85\u3a65\u3a45\u3a25\u3a05\u39e5\u39c5\u39a5"
    + "\u3985\u3965\u3945\u3925\u3905\u38e5\u38c5\u38a5\u3885\u3865\u3845"
    + "\u3825\u3805\u37e5\u37c5\u37a5\u3785\u3765\u3745\u3725\u3705\u36e5"
    + "\u36c5\u36a5\u3685\u3665\u3645\u3625\u3605\u35e5\u35c5\u35a5\u3585"
    + "\u3565\u3545\u3525\u3505\u34e5\u34c5\u34a5\u3485\u3465\u3445\u3445"
    + "\u3425\u3405\u33e5\u33c5\u33a5\u3385\u3365\u3345\u3325\u3305\u32e5"
    + "\u32c5\u32a5\u3285\u3265\u3245\u3225\u3205\u31e5\u31c5\u31a5\u3185"
    + "\u3165\u3145\u3125\u3105\u30e5\u30c5\u30a5\u3085\u3065\u3045\u3025"
    + "\u3005\u2fe5\u2fc5\u2fa5\u2f85\u2f65\u2f45\u2f25\u2f05\u2ee5\u2ec5"
    + "\u2ea5\u2e85\u2e65\u2e45\u2e25\u2e05\u2de5\u2dc5\u2da5\u2d85\u2d65"
    + "\u2d45\u2d25\u2d05\u2ce5\u2cc5\u2ca5\u2c85\u2c65\u2c45\u2c25\u2c05"
    + "\u2be5\u2bc5\u2ba5\u2b85\u2b65\u2b45\u2b25\u2b05\u2ae5\u2ac5\u2aa5"
    + "\u2a85\u2a65\u2a45\u2a25\u2a05\u29e5\u29c5\u29a5\u2985\u2965\u2945"
    + "\u2925\u2905\u28e5\u28c5\u28a5\u2885\u2865\u2845\u2825\u2805\u27e5"
    + "\u27c5\u27a5\u2785\u2765\u2745\u2725\u2705\u26e5\u26c5\u26a5\u2685"
    + "\u2665\u2645\u2625\u2605\u25e5\u25c5\u25a5\u2585\u2565\u2545\u2525"
    + "\u2505\u24e5\u24c5\u24a5\u2485\u2465\u2445\u2425\u2405\u23e5\u23c5"
    + "\u23a5\u2385\u2365\u2345\u2325\u2305\u22e5\u22c5\u22a5\u2285\u2265"
    + "\u2245\u2225\u2205\u21e5\u21c5\u21a5\u2185\u2165\u2145\u2125\u2105"
    + "\u20e5\u20c5\u20a5\u2085\u2065\u2045\u2025\u2005\u1fe5\u1fc5\u1fa5"
    + "\u1f85\u1f65\u1f45\u1f25\u1f05\u1ee5\u1ec5\u1ea5\u1e85\u1e65\u1e45"
    + "\u1e25\u1e05\u1de5\u1dc5\u1da5\u1d85\u1d65\u1d45\u1d25\u1d05\u1ce5"
    + "\u1cc5\u1ca5\u1c85\u1c65\u1c45\u1c25\u1c05\u1be5\u1bc5\u1ba5\u1b85"
    + "\u1b65\u1064\u1044\u1024\u1004\u0fe4\u0fc4\u0fa4\u0f84\u0f64\u0668"
    + "\u0b83\u0b63\u0b43\u0b23\u0b03\u0ae3\u0a72\u1945\u0a51\u0d16\u0cf6"
    + "\u0cac\u0ca3\u0c96\u0c76\u0c56\u0c36\u0c16\u0bf6\u0bd6\u0bb6\u0b96"
    + "\u0b76\u0b58\u0b26\u0b16\u0ab2\u0ad6\u0a96\u02c2\u07c3\u1665\u1661"
    + "\u03ff\u09f6\u09d6\u09b6\u05dc\u0bb2\u15a1\u0fc0\u01c0\u01b1\u09c5"
    + "\u0826\u127f";

  /**
   * Information about each character.  The low order 5 bits form the
   * character type, the next bit is a flag for non-breaking spaces, and the
   * next bit is a flag for mirrored directionality.  The high order 9 bits
   * form the offset into the attribute tables.  Note that this limits the
   * number of unique character attributes to 512, which is not a problem
   * as of Unicode version 3.2.0, but may soon become one.
   */
  String DATA
    = "\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81"
    + "\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002"
    + "\u3e00\u3e00\u2f81\u3002\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05"
    + "\u3a05\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05"
    + "\u3e00\u3e00\u3e00\u3e00\u5a88\u5a88\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00"
    + "\u3e00\u3e00\u3e00\u5098\u3e00\u3e00\u3e00\u3e00\u4586\u3e00\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00\u3e00\u3a05"
    + "\u3a05\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u3e00\u3e00\u3e00\u3e00\u5102\u5102\u5102\u5102"
    + "\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102"
    + "\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102\u5102"
    + "\u5102\u5102\u5102\u5102\u5102\u2902\u3e00\u5098\u2a14\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4606\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u1a1b\u1a1b\u3e00\u3e00\u3e00\u3e00\u4504\u3e00\u3e00"
    + "\u3e00\u0298\u3e00\u0298\u6515\u6596\u0298\u1a97\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u4504\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u4504\u4504\u1a1b\u1a1b\u1a1b\u1a1b"
    + "\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u4504"
    + "\u4504\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b"
    + "\u1a1b\u1a1b\u1a1b\u1a1b\u2902\u7102\u2902\u3e00\u2902\u2902\u7301"
    + "\u7301\u7301\u7301\u7203\u1a1b\u1a1b\u1a1b\u6c82\u6c82\u2902\u2902"
    + "\u3e00\u3e00\u2902\u2902\u6d01\u6d01\u7381\u7381\u3e00\u1a1b\u1a1b"
    + "\u1a1b\u1b02\u1b82\u1c02\u1c82\u1d02\u1d82\u1e02\u1e82\u1f02\u1f82"
    + "\u2002\u2082\u2102\u2182\u2202\u2282\u2302\u2382\u2402\u2482\u2502"
    + "\u2582\u2602\u2682\u2702\u2782\u0455\u0c99\u04d6\u0c99\017\017"
    + "\017\017\017\u010f\017\017\017\017\017\017\017"
    + "\017\017\017\017\017\017\017\017\017\017\017"
    + "\017\017\017\017\017\017\017\017\u008f\u010f\u008f"
    + "\u018f\u010f\017\017\017\017\017\017\017\017\017"
    + "\017\017\017\017\017\u010f\u010f\u010f\u008f\u020c\u0298"
    + "\u0298\u0318\u039a\u0318\u0298\u0298\u0455\u04d6\u0298\u0519\u0598"
    + "\u0614\u0598\u0698\u0709\u0789\u0809\u0889\u0909\u0989\u0a09\u0a89"
    + "\u0b09\u0b89\u0598\u0298\u0c59\u0c99\u0c59\u0298\u0d01\u0d81\u0e01"
    + "\u0e81\u0f01\u0f81\u1001\u1081\u1101\u1181\u1201\u1281\u1301\u1381"
    + "\u1401\u1481\u1501\u1581\u1601\u1681\u1701\u1781\u1801\u1881\u1901"
    + "\u1981\u0455\u0298\u04d6\u1a1b\u1a97\u0298\u0298\u0298\u0c99\u0455"
    + "\u04d6\u3e00\u0298\u0298\u0298\u0298\u0298\u0298\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u282c\u0298\u039a\u039a\u039a\u039a\u289c"
    + "\u289c\u1a1b\u289c\u2902\u29dd\u0c99\u2a14\u289c\u1a1b\u2a9c\u0519"
    + "\u2b0b\u2b8b\u1a1b\u2c02\u289c\u0298\u1a1b\u2c8b\u2902\u2d5e\u2d8b"
    + "\u2d8b\u2d8b\u0298\u0298\u0519\u0614\u0c99\u0c99\u0c99\u3e00\u0298"
    + "\u039a\u0318\u0298\u3e00\u3e00\u3e00\u3e00\u5305\u5305\u5305\u3e00"
    + "\u5305\u3e00\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u3e00\u3e00\u3e00\u4586\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u3e00\u4f1c\u4f1c\u4e81\u4e81"
    + "\u4e81\u4e81\u4e81\u4e81\u4e81\u4e81\u4e81\u4e81\u4e81\u4e81\u4e81"
    + "\u4e81\u4e81\u4e81\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01"
    + "\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01"
    + "\u2e01\u2e01\u2e01\u2e01\u0c99\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01"
    + "\u2e01\u2902\u3281\u2f81\u3002\u2f81\u3002\u3301\u2f81\u3002\u3381"
    + "\u3381\u2f81\u3002\u2902\u3401\u3481\u3501\u2f81\u3002\u3381\u3581"
    + "\u3602\u3681\u3701\u2f81\u3002\u2902\u2902\u3681\u3781\u2902\u3801"
    + "\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2902\u2f81"
    + "\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002"
    + "\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81"
    + "\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u5b09\u5b89\u5c09\u5c89\u5d09\u5d89\u5e09"
    + "\u5e89\u5f09\u5f89\u4586\u4586\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u1a1b\u1a1b\u4681"
    + "\u0298\u4701\u4701\u4701\u3e00\u4781\u3e00\u4801\u4801\u2902\u2e01"
    + "\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01"
    + "\u2e01\u2e01\u2e01\u2e01\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82"
    + "\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82"
    + "\u2e82\u2e82\u2e82\u2e82\u2e82\u0c99\u2e82\u2e82\u2e82\u2e82\u2e82"
    + "\u2e82\u2e82\u2f02\u2e82\u2e82\u4982\u2e82\u2e82\u2e82\u2e82\u2e82"
    + "\u2e82\u2e82\u2e82\u2e82\u4a02\u4a82\u4a82\u3e00\u4b02\u4b82\u4c01"
    + "\u4c01\u4c01\u4c82\u4d02\u2902\u3e00\u3e00\u2f81\u3002\u2f81\u3002"
    + "\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81"
    + "\u3002\u2902\u3b01\u3b83\u3c02\u2f81\u3002\u3d01\u3d81\u2f81\u3002"
    + "\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81"
    + "\u3002\u2f81\u3002\u3081\u3102\u2f81\u3002\u2f81\u3002\u2f81\u3002"
    + "\u2902\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002"
    + "\u2f81\u3002\u2f81\u3002\u2f81\u3002\u4d82\u4e02\u3c82\u2902\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u5a10\u5a10\u5a10\u5a10\u5a10\u5a10\u7d8b\u3e00\u3e00\u3e00\u7e0b"
    + "\u7e8b\u7f0b\u7f8b\u800b\u808b\u0519\u0519\u0c99\u0455\u04d6\u2902"
    + "\u3a05\u3a05\u3a05\u3a05\u3b01\u3b83\u3c02\u3b01\u3b83\u3c02\u3b01"
    + "\u3b83\u3c02\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81"
    + "\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u3c82\u2f81\u3002\u4f1c"
    + "\u4586\u4586\u4586\u4586\u3e00\u4f87\u4f87\u3e00\u3e00\u2f81\u3002"
    + "\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81"
    + "\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002"
    + "\u3181\u2f81\u3002\u2f81\u3002\u2f81\u3002\u3202\u2f81\u3002\u2f81"
    + "\u3002\u2f81\u3002\u3881\u2f81\u3002\u3881\u2902\u2902\u2f81\u3002"
    + "\u3881\u2f81\u3002\u3901\u3901\u2f81\u3002\u2f81\u3002\u3981\u2f81"
    + "\u3002\u2902\u3a05\u2f81\u3002\u2902\u3a82\u4c01\u2f81\u3002\u2f81"
    + "\u3002\u3e00\u3e00\u2f81\u3002\u3e00\u3e00\u2f81\u3002\u3e00\u3e00"
    + "\u3e00\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002"
    + "\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u0598\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u5298\u3e00\u3e00\u3e00\u5298\u5298\u5298\u5298\u5298"
    + "\u5298\u5298\u5298\u5298\u5298\u5298\u5298\u5298\u5298\u3e00\u5a10"
    + "\u5305\u4586\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u3e00\u3e00"
    + "\u5a10\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01"
    + "\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01"
    + "\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01\u4c01"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u5b09\u5b89\u5c09\u5c89\u5d09\u5d89\u5e09\u5e89\u5f09\u5f89"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u2902\u2902\u2902\u3e82\u3f02\u2902\u3f82\u3f82\u2902\u4002\u2902"
    + "\u4082\u2902\u2902\u2902\u2902\u3f82\u2902\u2902\u4102\u2902\u2902"
    + "\u2902\u2902\u4182\u4202\u2902\u2902\u2902\u2902\u2902\u4202\u2902"
    + "\u2902\u4282\u2902\u2902\u4302\u2902\u2902\u2902\u2902\u2902\u2902"
    + "\u2902\u2902\u2902\u2902\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u2902\u2902\u2902\u2902\u2902\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u5205\u4586\u5205\u5205\u3e00\u5205\u5205"
    + "\u3e00\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5298\u5305"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4f87\u4f87\u4586\u4f87"
    + "\u4f87\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u2d8b\u2d8b\u2d8b\u2d8b\u2d8b\u2d8b\u2d8b\u2d8b\u2d8b\u2d8b\u2d8b"
    + "\u2d8b\u828b\u4382\u2902\u2902\u4382\u2902\u2902\u2902\u2902\u4382"
    + "\u2902\u4402\u4402\u2902\u2902\u2902\u2902\u2902\u2902\u4482\u2902"
    + "\u2902\u2902\u2902\u2902\u2902\u2902\u2902\u2902\u2902\u2902\u2902"
    + "\u2902\u2902\u3e00\u3e00\u4504\u4504\u4504\u4504\u4504\u4504\u4504"
    + "\u4504\u4504\u1a1b\u1a1b\u4504\u4504\u4504\u4504\u4504\u1a1b\u1a1b"
    + "\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u1a1b\u4504\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u5001\u5001\u5001\u5001\u5001\u5001\u5001\u5001"
    + "\u5001\u5001\u5001\u5001\u5001\u5001\u5001\u5001\u5001\u5001\u5001"
    + "\u5001\u5001\u5001\u5001\u3e00\u3e00\u4504\u5098\u5098\u5098\u5098"
    + "\u5098\u5098\u2e01\u2e01\u3e00\u2e01\u2e01\u2e01\u2e01\u2e01\u2e01"
    + "\u2e01\u2e01\u2e01\u4882\u4902\u4902\u4902\u2902\u2e82\u2e82\u2e82"
    + "\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82\u2e82"
    + "\u2e82\u2e82\u4e02\u4e02\u4e02\u4e02\u4e02\u4e02\u4e02\u4e02\u4e02"
    + "\u4e02\u4e02\u4e02\u4e02\u4e02\u4e02\u4e02\u4586\u4586\u4586\u4586"
    + "\u4586\u5098\u4586\u4586\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00"
    + "\u3e00\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u3e00\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u3e00\u4586\u4586\u4586\u5198\u4586\u4586\u5198\u4586\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u5205\u5205"
    + "\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205"
    + "\u5205\u5205\u5205\u3e00\u3e00\u3e00\u3e00\u3e00\u5205\u5205\u5205"
    + "\u5198\u5198\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u5b89\u5c09\u5c89\u5d09\u5d89\u5e09\u5e89\u5f09\u5f89"
    + "\u630b\u638b\u640b\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u4586\u5a88\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3e00\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00\u3a05\u3a05\u3e00\u3a05\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u5a88\u5a88\u5a88\u5a88\u3e00"
    + "\u4586\u4586\u4586\u3e00\u4586\u4586\u4586\u4586\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u4586\u4586\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u4586\u5a88\u5a88\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3a05\u3a05\u3e00\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00\u3e00\u5a88\u5a88"
    + "\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3e00\u3e00\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00\u3e00\u5b09\u5b89"
    + "\u5c09\u5c89\u5d09\u5d89\u5e09\u5e89\u5f09\u5f89\u4f1c\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u5409\u5489\u5509\u5589\u5609\u5689\u5709\u5789\u5809"
    + "\u5889\u0318\u5918\u5918\u5298\u3e00\u3e00\u4586\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u3e00\u3e00\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u6515\u6596"
    + "\u5384\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305\u5305"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u5a88"
    + "\u5a88\u5098\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u4586\u4586\u5a88\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3e00\u3a05\u3e00\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u5098\u5098\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u4586\u4586\u4586"
    + "\u4586\u4586\u5384\u5384\u4586\u4586\u289c\u4586\u4586\u4586\u4586"
    + "\u3e00\u3e00\u0709\u0789\u0809\u0889\u0909\u0989\u0a09\u0a89\u0b09"
    + "\u0b89\u5305\u5305\u5305\u599c\u599c\u3e00\u3a05\u3a05\u3a05\u3e00"
    + "\u3a05\u3e00\u3a05\u3e00\u3e00\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u4586\u3a05\u3a05\u4586\u4586\u4586\u4586\u4586\u4586\u3e00"
    + "\u4586\u4586\u3a05\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00"
    + "\u3e00\u3e00\u4586\u4586\u5a88\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u4586\u3a05\u5a88\u5a88"
    + "\u5a88\u5a88\u5a88\u3e00\u4586\u5a88\u5a88\u3e00\u5a88\u5a88\u4586"
    + "\u4586\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u5a88\u5a88\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05\u3e00\u5098\u5098\u5098"
    + "\u5098\u5098\u5098\u5098\u5098\u5b89\u5c09\u5c89\u5d09\u5d89\u5e09"
    + "\u5e89\u5f09\u5f89\u630b\u660b\u668b\u670b\u678b\u680b\u688b\u690b"
    + "\u698b\u638b\u6a0b\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3e00\u3a05\u3a05\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3e00"
    + "\u3e00\u4586\u3a05\u5a88\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u5a88\u5a88\u5a88\u5a88\u4586\u3e00\u3e00\u3a05\u4586\u4586"
    + "\u4586\u4586\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3e00\u3a05\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00"
    + "\u4586\u3e00\u5a88\u5a88\u5a88\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3e00\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3e00\u3a05\u3a05"
    + "\u3a05\u3a05\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u4586"
    + "\u3a05\u3a05\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u3e00\u3e00"
    + "\u3e00\u3e00\u039a\u039a\u039a\u039a\u039a\u039a\u039a\u039a\u039a"
    + "\u039a\u039a\u039a\u039a\u039a\u039a\u039a\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3a05\u3a05\u4586\u4586\u5098\u5098\u5b09\u5b89\u5c09\u5c89"
    + "\u5d09\u5d89\u5e09\u5e89\u5f09\u5f89\u5098\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u0298\u0298\u0318\u039a\u0318\u0298\u0298\u6515\u6596\u0298\u0519"
    + "\u0598\u0614\u0598\u0698\u0709\u0789\u0809\u0889\u0909\u0989\u0a09"
    + "\u0a89\u0b09\u0b89\u0598\u0298\u0c99\u0c99\u0c99\u0298\u0298\u0298"
    + "\u0298\u0298\u0298\u2a14\u0298\u0298\u0298\u0298\u5a10\u5a10\u5a10"
    + "\u5a10\u3e00\u5b09\u5b89\u5c09\u5c89\u5d09\u5d89\u5e09\u5e89\u5f09"
    + "\u5f89\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3e00\u3e00\u3e00\u3e00\u5a88\u4586\u4586\u4586\u4586\u3e00\u3e00"
    + "\u5a88\u5a88\u3e00\u3e00\u5a88\u5a88\u4586\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u5a88\u3e00\u3e00\u3e00\u3e00\u3a05"
    + "\u3a05\u3e00\u3a05\u3e00\u3e00\u3a05\u3a05\u3e00\u3a05\u3e00\u3e00"
    + "\u3a05\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3e00"
    + "\u3a05\u3a05\u3e00\u3a05\u3a05\u3e00\u3e00\u4586\u3e00\u5a88\u5a88"
    + "\u4586\u4586\u3e00\u3e00\u3e00\u3e00\u4586\u4586\u3e00\u3e00\u4586"
    + "\u4586\u4586\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3e00\u3a05\u3a05"
    + "\u4586\u4586\u3e00\u3e00\u5b09\u5b89\u5c09\u5c89\u5d09\u5d89\u5e09"
    + "\u5e89\u5f09\u5f89\u3a05\u3a05\u039a\u039a\u600b\u608b\u610b\u618b"
    + "\u620b\u628b\u4f1c\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3e00\u3e00\u4586\u3a05\u5a88\u5a88\u4586\u4586\u4586\u4586"
    + "\u4586\u3e00\u4586\u4586\u5a88\u3e00\u5a88\u5a88\u4586\u3e00\u3e00"
    + "\u3a05\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u5b09\u5b89\u5c09\u5c89\u5d09\u5d89"
    + "\u5e09\u5e89\u5f09\u5f89\u620b\u620b\u620b\u620b\u620b\u620b\u620b"
    + "\u620b\u620b\u620b\u4f1c\u4586\u4f1c\u4586\u4f1c\u4586\u6515\u6596"
    + "\u6515\u6596\u5a88\u5a88\u4586\u4586\u4586\u3e00\u3e00\u3e00\u5a88"
    + "\u5a88\u3e00\u3e00\u5a88\u5a88\u4586\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u4586\u5a88\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05"
    + "\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05\u3e00\u5a88"
    + "\u4586\u4586\u4586\u4586\u5a88\u4586\u3e00\u3e00\u3e00\u4586\u4586"
    + "\u5a88\u4586\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u5a88\u5a88\u5a88\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u5a88\u5a88\u3e00\u3e00\u3e00\u5a88"
    + "\u5a88\u5a88\u3e00\u5a88\u5a88\u5a88\u4586\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u5a88\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u4504\u3e00"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u3e00\u3e00\u5b09\u5b89\u5c09"
    + "\u5c89\u5d09\u5d89\u5e09\u5e89\u5f09\u5f89\u3e00\u3e00\u3a05\u3a05"
    + "\u3e00\u3e00\u3e00\u3e00\u5b09\u5b89\u5c09\u5c89\u5d09\u5d89\u5e09"
    + "\u5e89\u5f09\u5f89\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4f87"
    + "\u4f87\u4f87\u5a88\u4586\u4586\u4586\u3e00\u3e00\u5a88\u5a88\u5a88"
    + "\u3e00\u5a88\u5a88\u5a88\u4586\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u5a88\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00"
    + "\u4586\u3e00\u3e00\u3e00\u3e00\u5a88\u5a88\u5a88\u4586\u4586\u4586"
    + "\u3e00\u4586\u3e00\u5a88\u5a88\u5a88\u5a88\u5a88\u5a88\u5a88\u5a88"
    + "\u4586\u5a88\u5a88\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u4586\u4586\u5098\u5098\u5098\u5098\u5098\u5098\u5098\u039a"
    + "\u5098\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u4504"
    + "\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u4586\u5098\u5b09\u5b89"
    + "\u5c09\u5c89\u5d09\u5d89\u5e09\u5e89\u5f09\u5f89\u5098\u5098\u3e00"
    + "\u3e00\u3e00\u3e00\u3a05\u4f1c\u4f1c\u4f1c\u5098\u5098\u5098\u5098"
    + "\u5098\u5098\u5098\u5098\u64b8\u5098\u5098\u5098\u5098\u5098\u5098"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4586\u4586\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4586\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u3e00\u3e00"
    + "\u4f1c\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u3e00\u3e00\u3e00\u3e00"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u1a97\u4504\u4504\u4504\u3e00\u5b09\u5b89\u5c09\u5c89\u5d09"
    + "\u5d89\u5e09\u5e89\u5f09\u5f89\u5098\u5098\u5098\u5098\u5098\u5098"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u5a88\u5a88\u4586\u4586\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u020c\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u6515"
    + "\u6596\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u5098\u5098\u5098\u6a8b\u6b0b\u6b8b\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u4586\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81"
    + "\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002\u2f81\u3002"
    + "\u2f81\u3002\u2902\u2902\u2902\u2902\u2902\u6c02\u3e00\u3e00\u3e00"
    + "\u3e00\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u6d01\u6d01"
    + "\u6d01\u6d01\u6d01\u6d01\u6d01\u6d01\u6c82\u6c82\u6c82\u6c82\u6c82"
    + "\u6c82\u6c82\u6c82\u6d01\u6d01\u6d01\u6d01\u6d01\u6d01\u6d01\u6d01"
    + "\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u3e00\u3e00\u6d01\u6d01\u6d01"
    + "\u6d01\u6d01\u6d01\u3e00\u3e00\u2902\u6c82\u2902\u6c82\u2902\u6c82"
    + "\u2902\u6c82\u3e00\u6d01\u3e00\u6d01\u3e00\u6d01\u3e00\u6d01\u6c82"
    + "\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u6d01\u6d01\u6d01\u6d01"
    + "\u6d01\u6d01\u6d01\u6d01\u6d82\u6d82\u6e02\u6e02\u6e02\u6e02\u6e82"
    + "\u6e82\u6f02\u6f02\u6f82\u6f82\u7002\u7002\u3e00\u3e00\u6c82\u6c82"
    + "\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u7083\u7083\u7083\u7083\u7083"
    + "\u7083\u7083\u7083\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82\u6c82"
    + "\u7083\u7083\u7083\u7083\u7083\u7083\u7083\u7083\u6c82\u6c82\u2902"
    + "\u7102\u2902\u3e00\u2902\u2902\u6d01\u6d01\u7181\u7181\u7203\u1a1b"
    + "\u7282\u1a1b\u1b02\u1b82\u1c02\u1c82\u1d02\u1d82\u1e02\u1e82\u1f02"
    + "\u1f82\u2002\u2082\u2102\u2182\u2202\u2282\u2302\u2382\u2402\u2482"
    + "\u2502\u2582\u2602\u2682\u2702\u2782\u6515\u0c99\u6596\u0c99\u3e00"
    + "\u6c82\u6c82\u2902\u2902\u2902\u7402\u2902\u2902\u6d01\u6d01\u7481"
    + "\u7481\u7501\u1a1b\u1a1b\u1a1b\u3e00\u3e00\u2902\u7102\u2902\u3e00"
    + "\u2902\u2902\u7581\u7581\u7601\u7601\u7203\u1a1b\u1a1b\u3e00\u020c"
    + "\u020c\u020c\u020c\u020c\u020c\u020c\u76ac\u020c\u020c\u020c\u770c"
    + "\u5a10\u5a10\u7790\u7810\u2a14\u78b4\u2a14\u2a14\u2a14\u2a14\u0298"
    + "\u0298\u791d\u799e\u6515\u791d\u791d\u799e\u6515\u791d\u0298\u0298"
    + "\u0298\u0298\u0298\u0298\u0298\u0298\u7a0d\u7a8e\u7b10\u7b90\u7c10"
    + "\u7c90\u7d10\u76ac\u0318\u0318\u0318\u0318\u0318\u0298\u0298\u0298"
    + "\u0298\u29dd\u2d5e\u0298\u0298\u0298\u0298\u1a97\u7d8b\u2c8b\u2b0b"
    + "\u2b8b\u7e0b\u7e8b\u7f0b\u7f8b\u800b\u808b\u0519\u0519\u0c99\u0455"
    + "\u04d6\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00"
    + "\u3e00\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u4c01\u289c\u289c\u289c\u289c\u4c01\u289c\u289c\u2902\u4c01\u4c01"
    + "\u4c01\u2902\u2902\u4c01\u4c01\u4c01\u2902\u289c\u4c01\u289c\u289c"
    + "\u289c\u4c01\u4c01\u4c01\u4c01\u4c01\u289c\u289c\ua08a\ua10a\ua18a"
    + "\ua20a\ua28a\ua30a\ua38a\ua40a\ua48a\u4586\u4586\u4586\u4586\u4586"
    + "\u4586\u2a14\u4504\u4504\u4504\u4504\u4504\u289c\u289c\ua50a\ua58a"
    + "\ua60a\u3e00\u3e00\u3e00\u289c\u289c\u289c\u289c\u3e00\u289c\u289c"
    + "\u289c\u289c\u3e00\u3e00\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u0c99\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u0c99\u0c99"
    + "\u289c\u289c\u0c99\u289c\u0c99\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u0c99\u289c"
    + "\u289c\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u930a\u938a\u940a\u948a\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u0c99\u0c99"
    + "\u0c99\u0c99\u0c99\u289c\u289c\u289c\u289c\u289c\u0c99\u0c99\u289c"
    + "\u289c\u289c\u289c\u4c01\u289c\u8101\u289c\u4c01\u289c\u8181\u8201"
    + "\u4c01\u4c01\u2a9c\u2902\u4c01\u4c01\u289c\u4c01\u2902\u3a05\u3a05"
    + "\u3a05\u3a05\u2902\u289c\u3e00\u3e00\u3e00\u3e00\u3e00\u830a\u838a"
    + "\u840a\u848a\u850a\u858a\u860a\u868a\u870a\u878a\u880a\u888a\u890a"
    + "\u898a\u8a0a\u8a8a\u8b0a\u8b8a\u8c0a\u8c8a\u8d0a\u8d8a\u8e0a\u8e8a"
    + "\u8f0a\u8f8a\u900a\u908a\u910a\u918a\u920a\u928a\u0c99\u0c99\u0c59"
    + "\u0c59\u0c99\u0c99\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59"
    + "\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59"
    + "\u0c99\u0c99\u0c99\u0c99\u0c99\u0c59\u0c59\u0c59\u0c59\u0c99\u0c99"
    + "\u0c99\u0c99\u0c99\u0c99\u0c99\u0c99\u0c99\u0c59\u0c59\u0c59\u0c59"
    + "\u0c59\u0c99\u0c99\u0c59\u0c59\u0c99\u0c99\u0c99\u0c99\u0c59\u0c59"
    + "\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59"
    + "\u0c99\u0c99\u0c59\u0c59\u0c59\u0c59\u0c99\u0c99\u0c99\u0c99\u0c99"
    + "\u0c59\u0c99\u0c99\u0c99\u0c99\u0c99\u0c99\u0c99\u289c\u289c\u0c99"
    + "\u289c\u289c\u0c99\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u0c99"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u3e00"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u0c99\u0c59\u0c59\u0c59\u0c59\u0c99"
    + "\u0c99\u0c99\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c99\u0c99\u0c99"
    + "\u0c59\u0519\u0519\u0c99\u0c59\u0c59\u0c99\u0c99\u0c99\u0c59\u0c59"
    + "\u0c59\u0c59\u0c99\u0c59\u0c99\u0c59\u0c99\u0c99\u0c99\u0c99\u0c59"
    + "\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c99\u0c99\u0c99"
    + "\u0c99\u0c99\u0c59\u0c99\u0c59\u0c59\u0c59\u0c59\u0c59\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u0455\u04d6\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u3e00\u3e00\u3e00"
    + "\u3e00\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c"
    + "\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c\u9a9c\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c"
    + "\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c\u9b1c"
    + "\u7d8b\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u0c59\u0c99\u0c59\u0c99\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59"
    + "\u0c59\u0c99\u0c99\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59"
    + "\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c59\u0c99"
    + "\u0c99\u0c59\u0c59\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u039a\u039a\u0c99\u1a1b\u289c"
    + "\u039a\u039a\u3e00\u289c\u0c99\u0c99\u0c99\u0c99\u289c\u289c\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u5a10\u5a10"
    + "\u5a10\u289c\u289c\u3e00\u3e00\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u3e00"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u3e00\u289c\u3e00\u289c\u289c\u289c\u289c\u3e00"
    + "\u3e00\u3e00\u289c\u3e00\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u828b\u9b8b\u9c0b\u9c8b\u9d0b\u9d8b\u9e0b\u9e8b"
    + "\u9f0b\u9f8b\u828b\u9b8b\u9c0b\u9c8b\u9d0b\u9d8b\u9e0b\u9e8b\u9f0b"
    + "\u9f8b\u289c\u3e00\u3e00\u3e00\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u0c59\u0c59\u0c59\u0c59\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c\u289c"
    + "\u289c\u289c\u289c\u289c\u289c\u4f1c\u289c\u289c\u289c\u289c\u289c"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u620b\u620b\u620b\u620b\u620b\u620b"
    + "\u620b\u620b\u620b\u620b\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u3e00\u3e00\u3e00\u4f1c\u600b\u608b\u610b\u618b"
    + "\ua68b\ua70b\ua78b\ua80b\ua88b\u630b\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u289c\u3e00\u289c\u289c\u289c\u3e00\u289c\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u2c8b"
    + "\u2b0b\u2b8b\u7e0b\u7e8b\u7f0b\u7f8b\u800b\u808b\u950b\u958b\u960b"
    + "\u968b\u970b\u978b\u980b\u988b\u990b\u998b\u9a0b\u2c8b\u2b0b\u2b8b"
    + "\u7e0b\u7e8b\u7f0b\u7f8b\u800b\u808b\u950b\u958b\u960b\u968b\u970b"
    + "\u978b\u980b\u988b\u990b\u998b\u9a0b\u4f1c\u4f1c\u4f1c\u4f1c\u020c"
    + "\u0298\u0298\u0298\u289c\u4504\u3a05\ua00a\u0455\u04d6\u0455\u04d6"
    + "\u0455\u04d6\u0455\u04d6\u0455\u04d6\u289c\u289c\u0455\u04d6\u0455"
    + "\u04d6\u0455\u04d6\u0455\u04d6\u2a14\u6515\u6596\u6596\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3e00\u3e00\u3e00"
    + "\u3e00\u4586\u4586\u1a1b\u1a1b\u4504\u4504\u3e00\u3a05\u3a05\u3a05"
    + "\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05\u3a05"
    + "\u3a05\u3e00\u4f1c\u4f1c\u620b\u620b\u620b\u620b\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c\u4f1c"
    + "\u4f1c\u4f1c\u4f1c\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\ua913\ua913"
    + "\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913"
    + "\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913"
    + "\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua913\ua992\ua992\ua992"
    + "\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992"
    + "\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992\ua992"
    + "\ua992\ua992\ua992\ua992\ua992\ua992\ua992\u5205\u5205\u5205\u5205"
    + "\u5205\u5205\u5205\u5205\u5205\u0519\u5205\u5205\u5205\u5205\u5205"
    + "\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u5205\u3e00\u5205\u5205"
    + "\u5205\u5205\u5205\u3e00\u5205\u3e00\u4586\u4586\u4586\u4586\u3e00"
    + "\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00\u3e00"
    + "\u0298\u2a14\u2a14\u1a97\u1a97\u6515\u6596\u6515\u6596\u6515\u6596"
    + "\u6515\u6596\u6515\u6596\u6515\u6596\u3e00\u3e00\u3e00\u3e00\u0298"
    + "\u0298\u0298\u0298\u1a97\u1a97\u1a97\u0598\u0298\u0598\u3e00\u0298"
    + "\u0598\u0298\u0298\u2a14\u6515\u6596\u6515\u6596\u6515\u6596\u0318"
    + "\u0298\u0d01\u0d81\u0e01\u0e81\u0f01\u0f81\u1001\u1081\u1101\u1181"
    + "\u1201\u1281\u1301\u1381\u1401\u1481\u1501\u1581\u1601\u1681\u1701"
    + "\u1781\u1801\u1881\u1901\u1981\u6515\u0298\u6596\u1a1b\u1a97";

  /**
   * This is the attribute table for computing the numeric value of a
   * character.  The value is -1 if Unicode does not define a value, -2
   * if the value is not a positive integer, otherwise it is the value.
   * Note that this is a signed value, but stored as an unsigned char
   * since this is a String literal.
   */
  String NUM_VALUE
    = "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\000\001\002\003\004\005\006\007"
    + "\010\011\uffff\uffff\012\013\014\015\016\017\020"
    + "\021\022\023\024\025\026\027\030\031\032\033"
    + "\034\035\036\037 !\"#\uffff\uffff\012"
    + "\013\014\015\016\017\020\021\022\023\024\025"
    + "\026\027\030\031\032\033\034\035\036\037 "
    + "!\"#\uffff\uffff\uffff\uffff\uffff\uffff\002\003"
    + "\uffff\001\uffff\ufffe\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\000\001\002\003\004\005\006\007"
    + "\010\011\uffff\uffff\uffff\uffff\000\001\002\003\004"
    + "\005\006\007\010\011\001\002\003\004\uffff\020"
    + "\012d\u03e8\uffff\uffff\uffff\024\036(2<"
    + "FPZ\u2710\021\022\023\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff"
    + "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\000\004"
    + "\005\006\007\010\011\uffff\uffff\uffff\001\001\002"
    + "\003\004\005\006\007\010\011\012\013\0142"
    + "d\u01f4\u03e8\001\002\003\004\005\006\007\010"
    + "\011\012\013\0142d\u01f4\u03e8\u03e8\u1388\u2710"
    + "\uffff\012\013\014\015\016\017\020\021\022\023"
    + "\024\uffff\uffff\002\003\004\005\006\007\010\011"
    + "\012\000\001\002\003\004\005\006\007\010\011"
    + "\012\024\036\005\006\007\010\011\uffff\uffff";

  /**
   * This is the attribute table for computing the uppercase representation
   * of a character.  The value is the signed difference between the
   * character and its uppercase version.  Note that this is stored as an
   * unsigned char since this is a String literal.
   */
  String UPPER
    = "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\uffe0"
    + "\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0"
    + "\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0\uffe0"
    + "\uffe0\uffe0\uffe0\000\000\000\000\000\000\000\000"
    + "\u02e7\000\000\000\000\uffe0y\000\uffff\000\uff18"
    + "\000\ufed4\000\000\000\000\000\000\000a\000"
    + "\000\000\000\000\000\000\0008\000\uffff\ufffe"
    + "\uffb1\000\000\000\uff2e\uff32\uff33\uff36\uff35\uff31\uff2f"
    + "\uff2d\uff2b\uff2a\uff26\uff27\uff25\000\000T\000\000"
    + "\000\000\uffda\uffdb\uffe1\uffc0\uffc1\uffc2\uffc7\000\uffd1"
    + "\uffca\uffaa\uffb0\000\000\000\000\000\uffd0\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\uffc5\010\000J"
    + "Vd\u0080p~\000\011\000\000\ue3db\000"
    + "\000\007\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\ufff0\ufff0\ufff0\ufff0\ufff0\ufff0\ufff0\ufff0"
    + "\ufff0\ufff0\ufff0\ufff0\ufff0\ufff0\ufff0\ufff0\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\uffe6\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000";

  /**
   * This is the attribute table for computing the lowercase representation
   * of a character.  The value is the signed difference between the
   * character and its lowercase version.  Note that this is stored as an
   * unsigned char since this is a String literal.
   */
  String LOWER
    = "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000       "
    + "           "
    + "        \000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000 \000\000\001\000\uff39\000"
    + "\uff87\000\u00d2\u00ce\u00cdO\u00ca\u00cb\u00cf\000\u00d3"
    + "\u00d1\u00d5\u00d6\u00da\u00d9\u00db\000\000\002\001\000"
    + "\000\uff9f\uffc8\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000&%"
    + "@?\000\000\000\000\000\000\000\000\000"
    + "\000\000\000P\000\0000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\ufff8\000"
    + "\000\000\000\000\000\ufff8\000\uffb6\ufff7\000\uffaa"
    + "\uff9c\000\uff90\ufff9\uff80\uff82\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\ue2a3\udf41\udfba\000\020\020"
    + "\020\020\020\020\020\020\020\020\020\020\020"
    + "\020\020\020\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\032\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000";

  /**
   * This is the attribute table for computing the directionality class
   * of a character.  At present, the value is in the range 0 - 18 if the
   * character has a direction, otherwise it is -1.  Note that this is
   * stored as an unsigned char since this is a String literal.
   */
  String DIRECTION
    = "\011\013\012\014\014\015\005\005\015\015\005"
    + "\007\005\004\003\003\003\003\003\003\003\003"
    + "\003\003\015\015\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\015\015\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\007\015\000\015\015\005\003\003"
    + "\000\003\015\015\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\uffff\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\010\010\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\010\000\000\000\001\001"
    + "\002\002\002\006\006\006\006\006\006\006\006"
    + "\006\006\006\002\011\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\015\015\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\014\011\000\001\015"
    + "\015\015\014\012\016\020\022\017\021\003\003"
    + "\003\003\003\003\003\000\000\000\015\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000\000"
    + "\000\003\003\003\003\003\003\003\003\003\003"
    + "\003\000\000\015\015\015\015\015\015\015\015"
    + "\015\000\000\000\000\000\000\000\000\000\000"
    + "\000\000\000\000\000\000\000\000\000\000";

  /**
   * This is the listing of titlecase special cases (all other character
   * can use <code>UPPER</code> to determine their titlecase).  The listing
   * is a sequence of character pairs; converting the first character of the
   * pair to titlecase produces the second character.
   */
  String TITLE
    = "\u01c4\u01c5\u01c5\u01c5\u01c6\u01c5\u01c7\u01c8\u01c8\u01c8\u01c9"
    + "\u01c8\u01ca\u01cb\u01cb\u01cb\u01cc\u01cb\u01f1\u01f2\u01f2\u01f2"
    + "\u01f3\u01f2";
}
