;; AMD K6/K6-2 Scheduling
;; Copyright (C) 2002 ;; Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.  */
;;
;; The K6 has similar architecture to PPro.  Important difference is, that
;; there are only two decoders and they seems to be much slower than execution
;; units.  So we have to pay much more attention to proper decoding for
;; schedulers.  We share most of scheduler code for PPro in i386.c
;;
;; The fp unit is not pipelined and do one operation per two cycles including
;; the FXCH.
;;
;; alu	  describes both ALU units (ALU-X and ALU-Y).
;; alux   describes X alu unit
;; fpu    describes FPU unit
;; load   describes load unit.
;; branch describes branch unit.
;; store  describes store unit.  This unit is not modelled completely and only
;;        used to model lea operation.  Otherwise it lie outside of the critical
;;        path.
;;
;; ??? fxch isn't handled; not an issue until sched3 after reg-stack is real.

;; The decoder specification is in the PPro section above!

;; Shift instructions and certain arithmetic are issued only to X pipe.
(define_function_unit "k6_alux" 1 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "ishift,ishift1,rotate,rotate1,alu1,negnot,cld"))
  1 1)

;; The QI mode arithmetic is issued to X pipe only.
(define_function_unit "k6_alux" 1 0
  (and (eq_attr "cpu" "k6")
       (and (eq_attr "type" "alu,alu1,negnot,icmp,test,imovx,incdec")
	    (eq_attr "mode" "QI")))
  1 1)

(define_function_unit "k6_alu" 2 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "ishift,ishift1,rotate,rotate1,alu1,negnot,alu,icmp,test,imovx,incdec,setcc,lea"))
  1 1)

(define_function_unit "k6_alu" 2 0
  (and (eq_attr "cpu" "k6")
       (and (eq_attr "type" "imov")
       	    (eq_attr "memory" "none")))
  1 1)

(define_function_unit "k6_branch" 1 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "call,callv,ibr"))
  1 1)

;; Load unit have two cycle latency, but we take care for it in adjust_cost
(define_function_unit "k6_load" 1 0
  (and (eq_attr "cpu" "k6")
       (ior (eq_attr "type" "pop,leave")
	    (eq_attr "memory" "load,both")))
  1 1)

(define_function_unit "k6_load" 1 0
  (and (eq_attr "cpu" "k6")
       (and (eq_attr "type" "str")
	    (eq_attr "memory" "load,both")))
  10 10)

;; Lea have two instructions, so latency is probably 2
(define_function_unit "k6_store" 1 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "lea"))
  2 1)

(define_function_unit "k6_store" 1 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "str"))
  10 10)

(define_function_unit "k6_store" 1 0
  (and (eq_attr "cpu" "k6")
       (ior (eq_attr "type" "push")
	    (eq_attr "memory" "store,both")))
  1 1)

(define_function_unit "k6_fpu" 1 1
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "fop,fmov,fcmp,fistp"))
  2 2)

(define_function_unit "k6_fpu" 1 1
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "fmul"))
  2 2)

;; ??? Guess
(define_function_unit "k6_fpu" 1 1
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "fdiv,fpspc"))
  56 56)

(define_function_unit "k6_alu" 2 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "imul"))
  2 2)

(define_function_unit "k6_alux" 1 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "imul"))
  2 2)

;; ??? Guess
(define_function_unit "k6_alu" 2 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "idiv"))
  17 17)

(define_function_unit "k6_alux" 1 0
  (and (eq_attr "cpu" "k6")
       (eq_attr "type" "idiv"))
  17 17)
