# Configure paths for LIBART
# Raph Levien 98-11-18
# stolen from Manish Singh    98-9-30
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_LIBART([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for LIBART, and define LIBART_CFLAGS and LIBART_LIBS
dnl
AC_DEFUN(AM_PATH_LIBART,
[dnl 
dnl Get the cflags and libraries from the libart-config script
dnl
AC_ARG_WITH(libart-prefix,[  --with-libart-prefix=PFX   Prefix where LIBART is installed (optional)],
            libart_prefix="$withval", libart_prefix="")
AC_ARG_WITH(libart-exec-prefix,[  --with-libart-exec-prefix=PFX Exec prefix where LIBART is installed (optional)],
            libart_exec_prefix="$withval", libart_exec_prefix="")
AC_ARG_ENABLE(libarttest, [  --disable-libarttest       Do not try to compile and run a test LIBART program],
		    , enable_libarttest=yes)

  if test x$libart_exec_prefix != x ; then
     libart_args="$libart_args --exec-prefix=$libart_exec_prefix"
     if test x${LIBART_CONFIG+set} != xset ; then
        LIBART_CONFIG=$libart_exec_prefix/bin/libart-config
     fi
  fi
  if test x$libart_prefix != x ; then
     libart_args="$libart_args --prefix=$libart_prefix"
     if test x${LIBART_CONFIG+set} != xset ; then
        LIBART_CONFIG=$libart_prefix/bin/libart-config
     fi
  fi

  AC_PATH_PROG(LIBART_CONFIG, libart2-config, no)
  if test "$LIBART_CONFIG" = "no" ; then
    AC_PATH_PROG(LIBART_CONFIG, libart-config, no)
  fi
  min_libart_version=ifelse([$1], ,0.2.5,$1)
  AC_MSG_CHECKING(for LIBART - version >= $min_libart_version)
  no_libart=""
  if test "$LIBART_CONFIG" = "no" ; then
    no_libart=yes
  else
    LIBART_CFLAGS=`$LIBART_CONFIG $libartconf_args --cflags`
    LIBART_LIBS=`$LIBART_CONFIG $libartconf_args --libs`

    libart_major_version=`$LIBART_CONFIG $libart_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    libart_minor_version=`$LIBART_CONFIG $libart_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    libart_micro_version=`$LIBART_CONFIG $libart_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_libarttest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $LIBART_CFLAGS"
      LIBS="$LIBS $LIBART_LIBS"
dnl
dnl Now check if the installed LIBART is sufficiently new. (Also sanity
dnl checks the results of libart-config to some extent
dnl
      rm -f conf.libarttest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libart_lgpl/libart.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.libarttest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_libart_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_libart_version");
     exit(1);
   }

   if (($libart_major_version > major) ||
      (($libart_major_version == major) && ($libart_minor_version > minor)) ||
      (($libart_major_version == major) && ($libart_minor_version == minor) && ($libart_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'libart-config --version' returned %d.%d.%d, but the minimum version\n", $libart_major_version, $libart_minor_version, $libart_micro_version);
      printf("*** of LIBART required is %d.%d.%d. If libart-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If libart-config was wrong, set the environment variable LIBART_CONFIG\n");
      printf("*** to point to the correct copy of libart-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_libart=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_libart" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$LIBART_CONFIG" = "no" ; then
       echo "*** The libart-config script installed by LIBART could not be found"
       echo "*** If LIBART was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the LIBART_CONFIG environment variable to the"
       echo "*** full path to libart-config."
     else
       if test -f conf.libarttest ; then
        :
       else
          echo "*** Could not run LIBART test program, checking why..."
          CFLAGS="$CFLAGS $LIBART_CFLAGS"
          LIBS="$LIBS $LIBART_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <libart_lgpl/libart.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding LIBART or finding the wrong"
          echo "*** version of LIBART. If it is not finding LIBART, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means LIBART was incorrectly installed"
          echo "*** or that you have moved LIBART since it was installed. In the latter case, you"
          echo "*** may want to edit the libart-config script: $LIBART_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     LIBART_CFLAGS=""
     LIBART_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(LIBART_CFLAGS)
  AC_SUBST(LIBART_LIBS)
  rm -f conf.libarttest
])
