package net

import (
	"io"
	"os"
)

// Pipe creates a synchronous, in-memory, full duplex
// network connection; both ends implement the Conn interface.
// Reads on one end are matched with writes on the other,
// copying data directly between the two; there is no internal
// buffering.
func Pipe() (Conn, Conn) {
	r1, w1 := io.Pipe()
	r2, w2 := io.Pipe()

	return &pipe{r1, w2}, &pipe{r2, w1}
}

type pipe struct {
	*io.PipeReader
	*io.PipeWriter
}

type pipeAddr int

func (pipeAddr) Network() string {
	return "pipe"
}

func (pipeAddr) String() string {
	return "pipe"
}

func (p *pipe) Close() os.Error {
	err := p.PipeReader.Close()
	err1 := p.PipeWriter.Close()
	if err == nil {
		err = err1
	}
	return err
}

func (p *pipe) LocalAddr() Addr {
	return pipeAddr(0)
}

func (p *pipe) RemoteAddr() Addr {
	return pipeAddr(0)
}

func (p *pipe) SetTimeout(nsec int64) os.Error {
	return os.NewError("net.Pipe does not support timeouts")
}

func (p *pipe) SetReadTimeout(nsec int64) os.Error {
	return os.NewError("net.Pipe does not support timeouts")
}

func (p *pipe) SetWriteTimeout(nsec int64) os.Error {
	return os.NewError("net.Pipe does not support timeouts")
}
