/* { dg-require-effective-target vect_int } */

#include <stdarg.h>
#include "tree-vect.h"

#define N 128

struct {
  char ca[N];
} s;
char cb[N];

volatile int y = 0;

__attribute__ ((noinline))
int main1 ()
{
  int i;

  for (i = 0; i < N; i++)
    {
      cb[i] = i*3;
      /* To avoid vectorization.  */
      if (y)
	abort ();
    }
  for (i = 0; i < N; i++)
    {
      s.ca[i] = cb[i];
    }

  /* check results:  */
  for (i = 0; i < N; i++)
    {
      if (s.ca[i] != cb[i])
        abort ();
    }

  return 0;
}

int main (void)
{
  check_vect ();

  return main1 ();
}

/* { dg-final { scan-tree-dump-times "vectorized 1 loops" 1 "vect" } } */
/* { dg-final { cleanup-tree-dump "vect" } } */
