/* { dg-do compile  } */
/* { dg-require-effective-target powerpc_altivec_ok } */
/* { dg-skip-if "do not override -mcpu" { powerpc*-*-* } { "-mcpu=*" } { "-mcpu=cell" } } */
/* { dg-options "-O2 -maltivec -mabi=altivec -mcpu=cell" } */
/* { dg-final { scan-assembler-times "vor" 2 } } */
#include <altivec.h>

/* Make sure that lvlx and lvrx are not combined into one insn and
   we still get a vor. */

vector unsigned char
lvx_float (long off, float *p)
{
    vector unsigned char l, r;

    l = (vector unsigned char) vec_lvlx (off, p);
    r = (vector unsigned char) vec_lvrx (off, p);
    return vec_or(l, r);
}

vector unsigned char
lvxl_float (long off, float *p)
{
    vector unsigned char l, r;

    l = (vector unsigned char) vec_lvlxl (off, p);
    r = (vector unsigned char) vec_lvrxl (off, p);
    return vec_or(l, r);
}
