
#ifndef _memory_h
#define _memory_h 1

#include <stddef.h>

extern "C" {

void*     memalign (size_t, size_t);
void*     memccpy (void*, const void*, int, size_t);
void*     memchr (const void*, int, size_t);
int       memcmp (const void*, const void*, size_t);
void*     memcpy (void*, const void*, size_t);
void*     memmove (void*, const void*, size_t);
void*     memset (void*, int, size_t);
int       ffs (int);
size_t    getpagesize (void);
void*     valloc (size_t);

void      bcopy (const void*, void*, size_t);
int       bcmp (const void*, const void*, int);
void      bzero (void*, int);
}

#ifdef __GNUG__
#ifndef alloca
#define alloca(x)  __builtin_alloca(x)
#endif
#else
#ifndef IV
extern "C" void* alloca(size_t);
#else
extern "C" void* alloca(unsigned long);
#endif /* IV */
#endif

#endif
