/* This testcase is part of GDB, the GNU debugger.

   Copyright 2014-2017 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>

// Make 'done' lookup working.
#pragma GCC user_expression

static void
foo ()
{
  jmp_buf env;

  switch (setjmp (env))
    {
    case 2:
      done = 1;
      return;
    case 0:
      longjmp (env, 2);
      break;
    }
  abort ();
}

void
_gdb_expr (void)
{
  foo ();
}
