# more-warnings.m4
# serial 3 (gettext-0.23)
dnl Copyright (C) 2023-2024 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

dnl Use more compiler warnings, beyond '-Wall' (for gcc and clang).
AC_DEFUN([gt_MORE_WARNINGS],
[
  AC_ARG_ENABLE([more-warnings],
AS_HELP_STRING([[--enable-more-warnings]], [enable additional compiler warnings beyond -Wall])
AS_HELP_STRING([[--disable-more-warnings]], [obey exactly the warning options specified in $CPPFLAGS $CFLAGS]),
    [more_warnings=$enableval],
    [dnl When to enable the warnings by default?
     dnl Some other packages enable the warnings by default in a git checkout
     dnl when there is no .tarball version file. This is too unreliable, since
     dnl - Often the .tarball-version file is still present after the maintainer
     dnl   made a release or prerelease.
     dnl - It is useful to see the warnings also when doing portability testing,
     dnl   that is, when building a tarball created by "make distcheck".
     dnl Hence, use a different heuristic: Enable the warnings by default if
     dnl the option -Wall is already specified.
     case " $CC $CPPFLAGS $CFLAGS " in
       *" -Wall "*) more_warnings=yes ;;
       *)           more_warnings=no ;;
     esac
    ])

  dnl Warning options for production code, not including tests.
  WARN_CFLAGS=
  dnl Warning options for production code imported from other packages
  dnl (libglib, libxml, libcroco).
  FOREIGN_WARN_CFLAGS=
  dnl Warning options that turn off expensive processing in the compiler.
  NO_EXPENSIVE_WARN_CFLAGS=
  if test "x$more_warnings" = xyes; then
    dnl Add warning options. But do *not* add options that change the
    dnl generated code. (That's because this code here is also in effect
    dnl for distro builds.)

    dnl Set up the list of the pointless, undesired warnings.
    nw=
    dnl First, the warnings that are generated already with -O0:
    dnl These warnings enforce a certain programming style that is not ours.
    nw="$nw -Wempty-body"
    nw="$nw -Wvla"
    dnl All warnings produced by these options (in gcc 13) have been false
    dnl alarms.
    nw="$nw -Wanalyzer-double-fclose"
    nw="$nw -Wanalyzer-double-free"
    nw="$nw -Wanalyzer-fd-double-close"
    nw="$nw -Wanalyzer-null-argument"
    nw="$nw -Wanalyzer-null-dereference"
    nw="$nw -Wanalyzer-use-of-uninitialized-value"
    dnl This warning option is nonsense. It's normal to have to cast, for
    dnl example, a 'double' to an 'int'. When that 'double' value is the
    dnl result of a function call, this does not make the cast dangerous
    dnl in any way.
    nw="$nw -Wbad-function-cast"
    dnl When we allocate memory for several objects through a single malloc()
    dnl call, it's normal that we then have to cast a 'char *' to various
    dnl pointer types with varying alignment.
    nw="$nw -Wcast-align"
    dnl We use computed format strings in a number of places, and glibc's
    dnl <bits/error.h> does it as well.
    nw="$nw -Wformat-nonliteral"
    dnl We define a few functions for binary backward compatibility only.
    dnl These functions are not declared on purpose: So that they cannot be
    dnl accidentally used in new code.
    nw="$nw -Wmissing-declarations"
    nw="$nw -Wmissing-prototypes"
    dnl We frequently have a static variable and a local variable in a function
    dnl with the same name. This is normal, because the same concept often
    dnl occurs in multiple locations in a file. Thus, ignore
    dnl "... shadows a global declaration" warnings. Only
    dnl "... shadows a parameter" and "... shadows a previous local" warnings
    dnl are worth eliminating; see below.
    nw="$nw -Wshadow"
    dnl Too many warnings. We often use signed types like 'int' or 'idx_t'
    dnl for counter variables, yet SIZEOF(array) is an unsigned value.
    nw="$nw -Wsign-compare"
    dnl This warning is based on older ISO C standards. It warns, in particular,
    dnl about function definitions that are valid in ISO C 23 (static and
    dnl non-static functions). Cf.
    dnl https://lists.gnu.org/archive/html/bug-gnulib/2023-02/msg00055.html
    dnl https://lore.kernel.org/distributions/2354211.7hzS34FegO@nimes/
    nw="$nw -Wold-style-definition"
    dnl This warning is based on older ISO C standards. It warns, in particular,
    dnl about function definitions that are valid in ISO C 23 (static functions
    dnl only). Cf.
    dnl https://lists.gnu.org/archive/html/bug-gnulib/2023-02/msg00055.html
    dnl https://lore.kernel.org/distributions/2354211.7hzS34FegO@nimes/
    dnl https://gcc.gnu.org/bugzilla/show_bug.cgi?id=108690
    nw="$nw -Wstrict-prototypes"
    dnl There is no reason to warn about an abstract (unimplemented) method in
    dnl an abstract class; it has no chance of ever being called. Only the
    dnl implementations of the method on concrete subclasses can be called.
    nw="$nw -Wsuggest-attribute=noreturn"
    dnl There is no reason to warn about code that does not want to make
    dnl assumptions about whether a certain type is signed or unsigned.
    nw="$nw -Wtype-limits"
    dnl Too many warnings. #if preprocessor directives often lead to unused
    dnl macros.
    nw="$nw -Wunused-macros"
    dnl Unused parameters are frequent in functions that are meant to implement
    dnl a given function type.
    nw="$nw -Wunused-parameter"
    dnl
    dnl Next, the warnings that are generated with -O2:
    dnl This warning option frequently produces false alarms.
    dnl See <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=21161>.
    nw="$nw -Wclobbered"
    dnl I'm not interested in the details of which functions get inlined and
    dnl which don't.
    nw="$nw -Winline"
    dnl Some of these warnings point to functions for which the result's
    dnl destruction should be done through fclose(), <datatype>_free(), etc.,
    dnl not free().
    nw="$nw -Wsuggest-attribute=malloc"
    dnl Too many warnings. It's ridiculous that the developer should spend
    dnl brain cycles on things that the compiler could often infer and which
    dnl have little effect on the performance of the generated code.
    dnl Cf. <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=109914>.
    nw="$nw -Wsuggest-attribute=pure"
    dnl Too many warnings. It's ridiculous that the developer should spend
    dnl brain cycles on things that the compiler could often infer and which
    dnl have little effect on the performance of the generated code.
    dnl Cf. <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=109915>.
    nw="$nw -Wsuggest-attribute=const"
    dnl It's ridiculous that the developer should spend brain cycles on things
    dnl that the compiler could often infer and which have little effect on the
    dnl performance of the generated code.
    nw="$nw -Wsuggest-attribute=cold"
    dnl With GCC 11 and older, there warnings are pointless:
    dnl "warning: stack protector not protecting local variables: variable
    dnl length buffer [-Wstack-protector]", "[-Wanalyzer-use-after-free],
    dnl "[-Wanalyzer-free-of-non-heap]".
    AC_PREPROC_IFELSE([AC_LANG_PROGRAM([[
      #if __GNUC__ > 11
      #error "You are lucky"
      #endif
      ]])],
      [nw="$nw -Wstack-protector"
       nw="$nw -Wanalyzer-use-after-free -Wanalyzer-free-of-non-heap"
      ])

    dnl Setup the list of meaningful warning options for the C compiler.
    dnl The list comes from manywarnings.m4. Warning options that are not
    dnl generally meaningful have already been filtered out (cf.
    dnl build-aux/gcc-warning.spec).
    gl_MANYWARN_ALL_GCC([possible_warning_options])

    dnl Compute the list of warning options that are desired.
    gl_MANYWARN_COMPLEMENT([desired_warning_options],
                           [$possible_warning_options], [$nw])
    dnl Compute the list of remaining undesired warning options.
    dnl Namely those, that were not in manywarnings.m4 because they were
    dnl already listed in build-aux/gcc-warning.spec; this includes those
    dnl that are implied by -Wall.
    gl_MANYWARN_COMPLEMENT([remaining_undesired_warning_options],
                           [$nw], [$possible_warning_options])

    dnl Add the desired warning options to WARN_CFLAGS.
    for w in $desired_warning_options; do
      gl_WARN_ADD([$w])
    done

    dnl Add the opposites of the remaining undesired warning options to
    dnl WARN_CFLAGS.
    for w in `echo "$remaining_undesired_warning_options" | sed -e 's/-W/-Wno-/g'`; do
      gl_WARN_ADD([$w])
    done

    dnl Cf. -Wshadow, above.
    gl_WARN_ADD([-Wshadow=local])

    dnl With GCC 10 and older, turn off -fanalyzer, because it requires too much
    dnl memory in the compiler.
    dnl See <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=97240>. In particular,
    dnl on AIX 7.3, gcc 10.3 cannot compile regex.c with -fanalyzer:
    dnl cc1: out of memory allocating 732 bytes after a total of 1072239104 bytes
    AC_PREPROC_IFELSE([AC_LANG_PROGRAM([[
      #if __GNUC__ > 10
      #error "You are lucky"
      #endif
      ]])],
      [
        gl_WARN_ADD([-fno-analyzer])
      ])

    dnl For production code imported from other packages, disable some other
    dnl warnings. For imported code, I want to minimize difference w.r.t.
    dnl upstream.
    FOREIGN_WARN_CFLAGS="$WARN_CFLAGS"
    fnw=
    fnw="$fnw -Wcast-function-type"
    fnw="$fnw -Wduplicated-cond"
    fnw="$fnw -Wformat"
    fnw="$fnw -Wimplicit-fallthrough"
    fnw="$fnw -Wnull-dereference"
    fnw="$fnw -Wsuggest-attribute=format"
    for w in `echo "$fnw" | sed -e 's/-W/-Wno-/g'`; do
      gl_WARN_ADD([$w], [FOREIGN_WARN_CFLAGS])
    done

    dnl Warning options that turn off expensive processing in the compiler.
    gl_WARN_ADD([-fno-analyzer], [NO_EXPENSIVE_WARN_CFLAGS])
  fi
  AC_SUBST([WARN_CFLAGS])
  AC_SUBST([FOREIGN_WARN_CFLAGS])
  AC_SUBST([NO_EXPENSIVE_WARN_CFLAGS])
])
