#include <stdio.h>
#include <string.h>

/* Tests taken from Cygnus C library. */
typedef struct {
  int line;
  long value;
  const char *result;
  const char *format_string;
} sprint_int_type;

sprint_int_type sprint_ints[] =
{
  {__LINE__, 0x000838d2,	"838d2", "%.4x"},
  {__LINE__, 0x0063be46,	"63BE46", "%-6X"},
  {__LINE__, -0x1b236c0,	"-28456640", "%#0.d"},
  {__LINE__, -0x0000003,	"-3", "% 0d"},
  {__LINE__, 0x0000ed51,	"ed51", "%2.x"},
  {__LINE__, -0x00001f2,	"-498", "%1ld"},
  {__LINE__, 0x0ea3e927,	"EA3E927", "%+X"},
  {__LINE__, 0xffbef8da,	"FFBEF8DA", "%5X"},
  {__LINE__, 0x62ff9f56,	"62ff9f56", "%0x"},
  {__LINE__, 0x00000ad2,	"AD2", "%.0X"},
  {__LINE__, 0x00000000,	"      ", "% 6.ld"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%1.4X"},
  {__LINE__, 0x0000208c,	" 208C", "%5X"},
  {__LINE__, 0x0000003c,	"3c", "%x"},
  {__LINE__, 0xffff6177,	"0xffff6177", "%+#x"},
  {__LINE__, 0xffffdc8d,	"ffffdc8d", "%+x"},
  {__LINE__, 0x00000000,	"0", "%X"},
  {__LINE__, 0x00002434,	"9268", "%0d"},
  {__LINE__, 0xd2c72cdb,	"d2c72cdb", "%-x"},
  {__LINE__, 0xfe38012b,	"0xfe38012b", "%+#7x"},
  {__LINE__, 0x00000001,	"0001", "%#.4d"},
  {__LINE__, -0x008525a,	"-0545370", "%06.7ld"},
  {__LINE__, 0xffffffac,	"ffffffac", "%3.7x"},
  {__LINE__, 0x007424d2,	"+7611602", "%+ld"},
  {__LINE__, 0x00001a85,	"1A85", "%.4X"},
  {__LINE__, -0x0000019,	"-25", "%3.d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%-x"},
  {__LINE__, -0x34473b2,	"-54817714", "% d"},
  {__LINE__, 0x000000ea,	"234", "%1.ld"},
  {__LINE__, -0x0000004,	"-4     ", "%-7.ld"},
  {__LINE__, 0x00006c94,	"27796", "%0d"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, 0x00000619,	"619", "%1x"},
  {__LINE__, 0x0000209c,	"8348", "%ld"},
  {__LINE__, -0x327f8ff,	"-52951295", "%-0ld"},
  {__LINE__, 0xffffff0b,	"FFFFFF0B", "%2.X"},
  {__LINE__, 0xf199d6ae,	"F199D6AE", "%X"},
  {__LINE__, 0x3ca5602e,	"1017471022", "%-1.ld"},
  {__LINE__, -0xfb2080b,	"-263325707", "%3.5d"},
  {__LINE__, 0x00001cb8,	"7352", "%d"},
  {__LINE__, 0x00000000,	"0000000", "%3.7d"},
  {__LINE__, 0xffffff40,	"FFFFFF40", "%+X"},
  {__LINE__, 0x14664450,	"0x14664450", "%#x"},
  {__LINE__, 0x0000002e,	"2e", "%1x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, 0xffff606a,	"0XFFFF606A", "%#X"},
  {__LINE__, 0xffffff33,	"0XFFFFFF33", "%#X"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, -0x0000012,	"-00018", "%-2.5d"},
  {__LINE__, 0x0001fbe6,	"130022", "%1.d"},
  {__LINE__, 0xfff59dd9,	"fff59dd9", "%+x"},
  {__LINE__, 0x00000002,	"2", "%0.0d"},
  {__LINE__, 0x00000fe1,	"fe1    ", "%-7.x"},
  {__LINE__, 0x001f8f6a,	"1F8F6A", "%1.X"},
  {__LINE__, 0x0000001b,	"000001B", "%04.7X"},
  {__LINE__, 0x126a2609,	" 308946441", "% 4d"},
  {__LINE__, 0xffffffe3,	"0XFFFFFFE3", "%+#.1X"},
  {__LINE__, 0x1858f1c9,	"1858f1c9", "%.3x"},
  {__LINE__, 0x003fc672,	"3fc672", "%1x"},
  {__LINE__, 0x00c0bddc,	"12631516", "%#d"},
  {__LINE__, 0x000006d6,	"1750", "%#d"},
  {__LINE__, 0x000006a0,	"6A0", "%X"},
  {__LINE__, 0x000007be,	"7BE", "%X"},
  {__LINE__, -0x1c7cd1a,	"-29871386", "%ld"},
  {__LINE__, 0x000000cc,	"204", "%ld"},
  {__LINE__, 0x000002db,	"731  ", "%-#5d"},
  {__LINE__, 0xffff67ad,	"FFFF67AD", "% X"},
  {__LINE__, 0x00000008,	"8", "%d"},
  {__LINE__, 0xffe07007,	"FFE07007", "%5X"},
  {__LINE__, -0x0000001,	"     -1", "% 7d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%x"},
  {__LINE__, 0x00027b68,	"+162664", "%+ld"},
  {__LINE__, 0x0a7c1997,	"+175905175", "%+2ld"},
  {__LINE__, 0xfe300896,	"fe300896", "%.4x"},
  {__LINE__, 0x00000537,	"537", "%-0.x"},
  {__LINE__, 0x3e981779,	"3e981779", "%.6x"},
  {__LINE__, 0xfffff05e,	"FFFFF05E", "%1.0X"},
  {__LINE__, -0x07bc0cf,	"-8110287", "%-7d"},
  {__LINE__, -0x01371bc,	"-1274300", "%.7ld"},
  {__LINE__, -0x0000013,	"-19", "%.2ld"},
  {__LINE__, 0x000000d1,	"0xd1", "%#x"},
  {__LINE__, -0x0000003,	"-3", "%-ld"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%4.1X"},
  {__LINE__, 0x00000000,	"0", "%ld"},
  {__LINE__, 0x0001c8af,	"116911", "%d"},
  {__LINE__, 0x000048c3,	"48C3", "%X"},
  {__LINE__, 0x00000079,	"0x0000079", "%-#0.7x"},
  {__LINE__, 0x0000615a,	" 24922", "% d"},
  {__LINE__, 0xfffffff5,	"fffffff5", "%x"},
  {__LINE__, 0x00000308,	"0000308", "%+07.7x"},
  {__LINE__, 0xfcadc983,	"fcadc983", "%x"},
  {__LINE__, 0x00000097,	"151", "%#d"},
  {__LINE__, 0x000001c5,	"453", "%0.2ld"},
  {__LINE__, 0x00000000,	"00", "%-1.2x"},
  {__LINE__, 0x00000001,	"+1", "%+02.d"},
  {__LINE__, 0x01eb4354,	"1EB4354", "% X"},
  {__LINE__, 0xffffa7d1,	"ffffa7d1", "%5.x"},
  {__LINE__, 0x0003170e,	"0x3170e", "%#x"},
  {__LINE__, 0x000001ce,	"1CE", "% .2X"},
  {__LINE__, 0x3a2991fb,	"975802875", "%d"},
  {__LINE__, -0xcdad8e2,	"-215668962", "%-d"},
  {__LINE__, 0xfe0261c3,	"fe0261c3", "%x"},
  {__LINE__, -0x0006ea7,	"-28327", "% ld"},
  {__LINE__, 0x032854a3,	"0X32854A3", "% #6X"},
  {__LINE__, 0x0000004b,	"4b", "%x"},
  {__LINE__, 0xffff6ca3,	"FFFF6CA3", "%4.X"},
  {__LINE__, 0x00000000,	"0", "%X"},
  {__LINE__, 0x00611f04,	"611F04", "%.1X"},
  {__LINE__, 0x00000000,	"     0", "%#6d"},
  {__LINE__, 0x0002c711,	"2c711", "%-02.x"},
  {__LINE__, -0x07a2fe4,	"-8007652", "%d"},
  {__LINE__, -0x0000547,	"-1351", "%ld"},
  {__LINE__, 0x00013954,	"0x13954", "%#x"},
  {__LINE__, -0x00523b7,	"-336823", "%ld"},
  {__LINE__, -0x00f6c6e,	"-1010798", "%6.ld"},
  {__LINE__, 0xffea6427,	"FFEA6427", "%3X"},
  {__LINE__, -0x0000005,	"-5", "%d"},
  {__LINE__, -0x04fe618,	"-5236248", "% .7d"},
  {__LINE__, 0xffa80a28,	"ffa80a28", "%-0x"},
  {__LINE__, 0x00000047,	"71", "%ld"},
  {__LINE__, 0x001dc6bb,	"1951419", "%#4ld"},
  {__LINE__, 0x00000868,	"  2152", "%#6d"},
  {__LINE__, 0x000002fb,	"2fb", "%x"},
  {__LINE__, 0x00607fa0,	"6324128", "%4d"},
  {__LINE__, 0xfffed161,	"fffed161", "%x"},
  {__LINE__, 0x0001c6e4,	" 116452", "% 2.5d"},
  {__LINE__, 0x0003dda8,	"3DDA8", "%4X"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%x"},
  {__LINE__, 0xfacf664a,	"facf664a", "%x"},
  {__LINE__, 0x000000c1,	"C1", "% 1X"},
  {__LINE__, 0x0000839c,	"  839C", "%6X"},
  {__LINE__, 0xfffff69a,	"FFFFF69A", "%X"},
  {__LINE__, 0x000e5c2e,	"+941102", "%+d"},
  {__LINE__, -0x0000004,	"-4", "%#d"},
  {__LINE__, 0x00000000,	"00000", "%#.5ld"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%3.1x"},
  {__LINE__, 0x0010ed68,	"1109352", "%-ld"},
  {__LINE__, 0xffffffe9,	"ffffffe9", "%.6x"},
  {__LINE__, 0x00000007,	"   7", "% 4.ld"},
  {__LINE__, 0x0000caba,	"51898", "%ld"},
  {__LINE__, -0x0000119,	"-281", "% d"},
  {__LINE__, 0x0c3012a9,	"204477097", "%03.6ld"},
  {__LINE__, -0x001c98f,	"-117135", "%ld"},
  {__LINE__, 0x000017b1,	"+6065", "%+d"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, -0x0000019,	"-25", "% .2d"},
  {__LINE__, 0x0009ae28,	"9AE28", "%X"},
  {__LINE__, 0xe861c4fe,	"e861c4fe", "%7.x"},
  {__LINE__, 0xffac88d3,	"FFAC88D3", "%X"},
  {__LINE__, -0x00005df,	"-01503", "%-5.5ld"},
  {__LINE__, 0x0000013e,	"318", "%-0d"},
  {__LINE__, 0x04b6f58f,	"4b6f58f", "%x"},
  {__LINE__, 0xfffe3978,	"fffe3978", "%+0.6x"},
  {__LINE__, 0x57ee5244,	"57ee5244", "%+7.4x"},
  {__LINE__, 0xfffb5610,	"fffb5610", "% 6x"},
  {__LINE__, 0x00000006,	"      6", "%#7d"},
  {__LINE__, 0x0000000c,	"0x0000c", "%#.5x"},
  {__LINE__, -0xec59362,	"-247829346", "%1.7d"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, -0x0007e4b,	"-32331", "% d"},
  {__LINE__, 0x0ececa6f,	"248433263", "%0d"},
  {__LINE__, 0x00000578,	"   578", "%+6.x"},
  {__LINE__, -0x0000003,	"-3", "%ld"},
  {__LINE__, 0x000002bb,	"2bb", "% 0x"},
  {__LINE__, -0x0000006,	"-6", "%-ld"},
  {__LINE__, 0x000002f9,	"761", "%d"},
  {__LINE__, 0xffffd736,	"ffffd736", "%3.4x"},
  {__LINE__, 0x0010ba79,	"1096313", "%7.4d"},
  {__LINE__, -0x0001244,	"-4676", "%#.1d"},
  {__LINE__, 0x00000dbe,	"DBE", "%1X"},
  {__LINE__, -0x0000015,	"-21", "%-0.d"},
  {__LINE__, 0xffffffff,	"0xffffffff", "%#x"},
  {__LINE__, -0x6cdf4a3,	"-114160803", "%ld"},
  {__LINE__, 0x00008ac9,	"8AC9", "%1X"},
  {__LINE__, 0x00000000,	"00", "%.2X"},
  {__LINE__, -0x2263dba,	"-36060602", "%5.5d"},
  {__LINE__, 0x00007da9,	"32169", "%0d"},
  {__LINE__, 0xfffffff7,	"FFFFFFF7", "% 4.X"},
  {__LINE__, 0xfbf36cca,	"FBF36CCA", "%.1X"},
  {__LINE__, 0x00000040,	"64", "%.0ld"},
  {__LINE__, 0x0000001c,	" 28", "% d"},
  {__LINE__, 0xfffffadb,	"0xfffffadb", "%#.5x"},
  {__LINE__, 0x0eb95847,	"247027783", "%d"},
  {__LINE__, 0xfffd7030,	"FFFD7030", "%+02X"},
  {__LINE__, 0x00000005,	"00005", "%.5x"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%X"},
  {__LINE__, 0x98975b15,	"98975B15", "%02X"},
  {__LINE__, -0x0000034,	"   -52", "%6ld"},
  {__LINE__, 0xffd7d0cc,	"ffd7d0cc", "% 5.6x"},
  {__LINE__, 0xffffffa6,	"FFFFFFA6", "%X"},
  {__LINE__, 0xfff27132,	"fff27132", "%x"},
  {__LINE__, -0x065b74d,	"-6666061", "%+6ld"},
  {__LINE__, 0xf6ac99d6,	"0XF6AC99D6", "%#X"},
  {__LINE__, 0xfffff4bd,	"FFFFF4BD", "%X"},
  {__LINE__, 0xfffffb62,	"FFFFFB62", "%6X"},
  {__LINE__, 0xf8434543,	"f8434543", "%-0x"},
  {__LINE__, 0x0002b374,	"0x2b374", "%-#6x"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xffb5751d,	"ffb5751d", "%-3.x"},
  {__LINE__, 0x34ea7347,	"887780167", "%d"},
  {__LINE__, -0x008f457,	"-586839", "%0ld"},
  {__LINE__, 0x00000001,	"   1", "%#4d"},
  {__LINE__, 0xc32d7ad4,	"c32d7ad4", "%0x"},
  {__LINE__, 0xfffffb80,	"FFFFFB80", "%-.2X"},
  {__LINE__, 0x00000756,	"756   ", "%-6x"},
  {__LINE__, 0xfffb020f,	"FFFB020F", "%+.2X"},
  {__LINE__, -0xe68619f,	"-241721759", "%#1.6ld"},
  {__LINE__, 0x180166cd,	"402745037", "%3.7ld"},
  {__LINE__, -0x0000001,	"-1", "%+00d"},
  {__LINE__, 0xfdbc3611,	"fdbc3611", "%x"},
  {__LINE__, -0x000005b,	"-91", "%d"},
  {__LINE__, 0xffffe77f,	"ffffe77f", "%x"},
  {__LINE__, -0x0000019,	"-25", "%ld"},
  {__LINE__, 0x00000016,	"22", "%#d"},
  {__LINE__, -0x0000025,	"-37", "%ld"},
  {__LINE__, 0xffffe43f,	"ffffe43f", "%x"},
  {__LINE__, 0x000050a5,	"00050a5", "%.7x"},
  {__LINE__, 0x0000000c,	"   12", "% 5.ld"},
  {__LINE__, -0x001faff,	"-129791", "%4d"},
  {__LINE__, 0x239d7cf2,	"597523698", "%0.7ld"},
  {__LINE__, 0x04092183,	"4092183", "% 7X"},
  {__LINE__, -0x0043498,	"-275608", "%-ld"},
  {__LINE__, -0x0018dbe,	"-101822", "%d"},
  {__LINE__, 0xff3e09c3,	"FF3E09C3", "%X"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, -0x15d57558,	"-366310744", "%+0.7ld"},
  {__LINE__, 0x0004fb06,	"326406", "%0.0d"},
  {__LINE__, 0x00000119,	"0X119", "%#X"},
  {__LINE__, -0x14c53e19,	"-348470809", "%d"},
  {__LINE__, 0x00000019,	"0000019", "% .7X"},
  {__LINE__, -0x0000654,	"-1620", "%0.4ld"},
  {__LINE__, -0xde5899b,	"-233146779", "%#.1d"},
  {__LINE__, 0x0013c1f0,	"1294832", "%4.ld"},
  {__LINE__, 0x0a9fe761,	"A9FE761", "%X"},
  {__LINE__, -0x00000e5,	"-229", "%1ld"},
  {__LINE__, 0x00000161,	"000353", "%.6ld"},
  {__LINE__, 0x6b04e4bd,	"0x6b04e4bd", "%#7.0x"},
  {__LINE__, -0x0000ef0,	"-3824 ", "%-6.ld"},
  {__LINE__, -0x026306e,	"-2502766", "%ld"},
  {__LINE__, 0x00000000,	"0", "%-X"},
  {__LINE__, 0xfffffe1f,	"fffffe1f", "%-x"},
  {__LINE__, 0x0003aecf,	" 241359", "% 2.1ld"},
  {__LINE__, -0x0000014,	"-20", "%d"},
  {__LINE__, 0x00000002,	"0002", "%-.4ld"},
  {__LINE__, 0xfffff662,	"0XFFFFF662", "% #.6X"},
  {__LINE__, 0x00000006,	"6", "%0x"},
  {__LINE__, 0x0001f4c4,	" 128196", "% 0d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%5X"},
  {__LINE__, 0x05605e38,	"90201656", "%ld"},
  {__LINE__, 0xffffffde,	"0XFFFFFFDE", "% #X"},
  {__LINE__, 0x000001e0,	"    1e0", "%7.x"},
  {__LINE__, 0x00000007,	"7", "%X"},
  {__LINE__, 0x00000001,	"+1", "%+d"},
  {__LINE__, 0xffffffe0,	"FFFFFFE0", "% X"},
  {__LINE__, 0xffd7f77a,	"FFD7F77A", "%+00.1X"},
  {__LINE__, 0xfffffffe,	"0xfffffffe", "%-#x"},
  {__LINE__, 0x01b0a63b,	"1b0a63b", "%x"},
  {__LINE__, -0x06554b7,	"-6640823", "%d"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%x"},
  {__LINE__, 0x00000b2d,	"b2d", "%x"},
  {__LINE__, -0x2664ba2,	"-40258466", "%-d"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%X"},
  {__LINE__, -0x0000552,	" -1362", "%6.2ld"},
  {__LINE__, 0x00000009,	" 00009", "%6.5x"},
  {__LINE__, 0x00035c72,	"220274", "%05.ld"},
  {__LINE__, -0x014d09d,	"-1364125", "%d"},
  {__LINE__, -0x0000002,	"  -2", "% 4d"},
  {__LINE__, 0x00000001,	"1", "%+X"},
  {__LINE__, 0x00000028,	"28", "%X"},
  {__LINE__, 0xf25c9eb2,	"F25C9EB2", "%7.X"},
  {__LINE__, -0x7ae4b62,	"-128863074", "%d"},
  {__LINE__, 0x00630d87,	"630D87", "%2X"},
  {__LINE__, 0x000000f8,	"F8", "%-X"},
  {__LINE__, 0xfffffff9,	"FFFFFFF9", "%X"},
  {__LINE__, -0x0000007,	"-7", "%0d"},
  {__LINE__, -0x2518fcd,	"-38899661", "% 3ld"},
  {__LINE__, 0xfffff4b4,	"FFFFF4B4", "%-5X"},
  {__LINE__, 0x01cc36c8,	"30160584", "%ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%-x"},
  {__LINE__, 0x0000000b,	"    11", "%6.ld"},
  {__LINE__, 0x00010d55,	" 68949", "% d"},
  {__LINE__, -0x0c01306,	"-12587782", "% 6.1ld"},
  {__LINE__, 0x001719d7,	"1513943", "%.1ld"},
  {__LINE__, -0x0000002,	" -2", "%+3.ld"},
  {__LINE__, 0x0000018e,	"398", "%d"},
  {__LINE__, 0x000000a6,	"0xa6", "%-#3x"},
  {__LINE__, 0x00006f66,	" 28518", "% #d"},
  {__LINE__, 0x0000032a,	"32A", "%X"},
  {__LINE__, -0x0000145,	"-325", "%0d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%2.x"},
  {__LINE__, 0x00287171,	"2650481", "%ld"},
  {__LINE__, 0x0000004b,	"+75", "%+02.ld"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%-0x"},
  {__LINE__, 0x00000064,	"64", "% X"},
  {__LINE__, 0xfffffca2,	"fffffca2", "%0x"},
  {__LINE__, 0x000010b6,	"10b6", "% .0x"},
  {__LINE__, -0x003806f,	"-229487", "%7d"},
  {__LINE__, -0x00000b7,	"-183", "%3ld"},
  {__LINE__, 0xffffe5ba,	"FFFFE5BA", "%0X"},
  {__LINE__, 0x001f0da8,	"1f0da8", "%+x"},
  {__LINE__, 0x000ce185,	"844165", "%0ld"},
  {__LINE__, 0x00000c96,	"3222", "%0d"},
  {__LINE__, -0x0013099,	"-77977", "%1.ld"},
  {__LINE__, -0x5f3c47a,	"-99861626", "%.6ld"},
  {__LINE__, 0x00000cbf,	"  CBF", "%+5.X"},
  {__LINE__, -0x0000001,	"-1", "%+ld"},
  {__LINE__, 0x0d793bc3,	"d793bc3", "%6.x"},
  {__LINE__, 0xfffffffd,	"0xfffffffd", "%+#x"},
  {__LINE__, -0x0000070,	"  -112", "%6.d"},
  {__LINE__, 0xfffffb3f,	"FFFFFB3F", "%.7X"},
  {__LINE__, 0x037dfc78,	"0X37DFC78", "%#X"},
  {__LINE__, 0x00009ba5,	"39845", "%3ld"},
  {__LINE__, 0x0000004a,	"4a", "%0x"},
  {__LINE__, 0xffffff81,	"ffffff81", "%5.5x"},
  {__LINE__, -0x86ef222,	"-141488674", "%ld"},
  {__LINE__, -0xac5531e,	"-180704030", "% 4ld"},
  {__LINE__, 0x00002493,	"2493", "%+X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%1.3X"},
  {__LINE__, 0x0005c875,	"378997", "%.0ld"},
  {__LINE__, 0x0301d345,	"50451269", "%d"},
  {__LINE__, 0xfff6b589,	"fff6b589", "%2.4x"},
  {__LINE__, -0x00001db,	"-475   ", "%-7.0d"},
  {__LINE__, 0x0000d1e7,	"0x000d1e7", "%#2.7x"},
  {__LINE__, 0xf4c4d2bb,	"f4c4d2bb", "%.6x"},
  {__LINE__, 0x00c89f54,	"13147988", "%ld"},
  {__LINE__, -0x6599253c,	"-1704535356", "%+ld"},
  {__LINE__, 0xab7d61ea,	"ab7d61ea", "% x"},
  {__LINE__, 0x00000006,	"6", "%1ld"},
  {__LINE__, 0xffff5ab7,	"ffff5ab7", "%0x"},
  {__LINE__, -0x1cfeca5b,	"-486459995", "%#ld"},
  {__LINE__, 0x000000f3,	"    f3", "% 6.x"},
  {__LINE__, -0x0000021,	"-33", "%d"},
  {__LINE__, 0xfe7246ac,	"fe7246ac", "%-5.x"},
  {__LINE__, 0x00000017,	"00017", "%-.5X"},
  {__LINE__, -0x0cc250a,	"-13378826", "%0.0d"},
  {__LINE__, -0x00010ae,	"-04270", "%#.5ld"},
  {__LINE__, -0x7952c8b,	"-127216779", "% ld"},
  {__LINE__, 0x0002a53e,	"173374", "%4.0d"},
  {__LINE__, 0x03801bbf,	"3801BBF", "%0X"},
  {__LINE__, 0x0368645f,	"+57173087", "%+#0.6ld"},
  {__LINE__, 0x0000002f,	"47", "%d"},
  {__LINE__, 0x00000003,	"3", "%x"},
  {__LINE__, 0x000005f7,	"5F7", "%0X"},
  {__LINE__, -0x06e5e76,	"-7233142", "% 0.1ld"},
  {__LINE__, 0x053da936,	"53da936", "%1.4x"},
  {__LINE__, -0x0df0c2f,	"-14617647", "%.5ld"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%-0X"},
  {__LINE__, 0x000104bf,	"104BF", "%X"},
  {__LINE__, 0x000353fc,	"353FC", "%X"},
  {__LINE__, 0x182a18dc,	"+405412060", "%+ld"},
  {__LINE__, 0x0000000e,	" 14", "% 2d"},
  {__LINE__, -0x0000091,	"-145", "%+ld"},
  {__LINE__, 0x0029a9d6,	"2730454", "%d"},
  {__LINE__, 0x00009d57,	"009d57", "% .6x"},
  {__LINE__, 0x4c4d4f79,	"1280135033", "%5.ld"},
  {__LINE__, -0x000075b,	"-1883", "% 03d"},
  {__LINE__, -0x001b718,	"-112408", "%+d"},
  {__LINE__, 0xfffaaf57,	"FFFAAF57", "%+1X"},
  {__LINE__, 0x00f44e52,	"F44E52", "% 4X"},
  {__LINE__, 0x00000002,	"0X2", "%#X"},
  {__LINE__, 0x000a85e9,	"A85E9", "%+0X"},
  {__LINE__, 0xffff70bb,	"ffff70bb", "%6x"},
  {__LINE__, 0x00004e15,	"4e15", "%x"},
  {__LINE__, 0x000eeb60,	" 977760", "% ld"},
  {__LINE__, 0xfffffff1,	"fffffff1", "%0x"},
  {__LINE__, -0x294d7e2,	"-43309026", "% 02.d"},
  {__LINE__, 0x0001aaeb,	"0109291", "%02.7ld"},
  {__LINE__, 0x000a01fc,	"0xa01fc", "%-#.5x"},
  {__LINE__, 0x002c3c30,	"+2898992", "%+#d"},
  {__LINE__, 0x015667ae,	"+22439854", "%+5ld"},
  {__LINE__, -0x05af42b,	"-5960747", "%+d"},
  {__LINE__, 0x0000be36,	"be36", "%+2x"},
  {__LINE__, 0x005e3f67,	"5e3f67", "% x"},
  {__LINE__, -0x0000020,	"-32", "% ld"},
  {__LINE__, -0x0003617,	"-13847", "% d"},
  {__LINE__, 0x00000014,	"14  ", "%-4.X"},
  {__LINE__, 0x00000001,	"001", "%0.3d"},
  {__LINE__, 0xfffffea9,	"fffffea9", "%3.x"},
  {__LINE__, 0xe447099e,	"E447099E", "%0X"},
  {__LINE__, 0x00049c71,	"302193", "%d"},
  {__LINE__, 0x76356ed3,	"0x76356ed3", "%#4.1x"},
  {__LINE__, 0x00000005,	"  0X5", "%#5X"},
  {__LINE__, 0x00004da2,	"0x004da2", "%#1.6x"},
  {__LINE__, 0xffdfb36c,	"FFDFB36C", "%4X"},
  {__LINE__, 0xffffe3c5,	"FFFFE3C5", "%+4.X"},
  {__LINE__, 0x00000006,	"6", "%0x"},
  {__LINE__, -0x914ff17,	"-152370967", "% .5ld"},
  {__LINE__, -0x0000002,	"-2", "%0ld"},
  {__LINE__, 0xffffff36,	"FFFFFF36", "% 2X"},
  {__LINE__, -0x0bb1598,	"-12260760", "%-ld"},
  {__LINE__, 0x00006db5,	"28085", "%0.5ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, -0x0000001,	"-1", "%0ld"},
  {__LINE__, 0x0fa37e79,	"FA37E79", "%1.X"},
  {__LINE__, -0x00000ac,	"-172", "%.2d"},
  {__LINE__, 0xffffffd8,	"ffffffd8", "%.7x"},
  {__LINE__, -0x000a513,	"-42259", "%ld"},
  {__LINE__, 0x00001294,	"4756", "%2ld"},
  {__LINE__, -0x56bae0b4,	"-1455087796", "%.1ld"},
  {__LINE__, 0x3b26d5fa,	"3b26d5fa", "%x"},
  {__LINE__, 0xff657013,	"ff657013", "%x"},
  {__LINE__, -0x00005f5,	"-1525", "%0.0ld"},
  {__LINE__, -0x0000001,	"     -1", "% 7d"},
  {__LINE__, -0x02396b2,	"-2332338", "%d"},
  {__LINE__, -0x0000003,	"-000003", "%+7.6d"},
  {__LINE__, 0xfd3ec7c1,	"fd3ec7c1", "% 3.4x"},
  {__LINE__, -0x076e338,	"-7791416", "%0.d"},
  {__LINE__, -0x000015e,	"-350", "%3ld"},
  {__LINE__, 0x0a0f0b71,	"a0f0b71", "%x"},
  {__LINE__, 0xfffe00ba,	"FFFE00BA", "%X"},
  {__LINE__, 0x00036bd8,	" 36bd8", "% 06.x"},
  {__LINE__, 0xfffff2df,	"0XFFFFF2DF", "%#2.6X"},
  {__LINE__, 0x004687fb,	"4622331", "%ld"},
  {__LINE__, -0x0000331,	"  -817", "%+6.d"},
  {__LINE__, 0xfcd5b090,	"fcd5b090", "%+0x"},
  {__LINE__, 0x0334f94c,	"334F94C", "%.6X"},
  {__LINE__, 0x00000bce,	"3022", "%.3ld"},
  {__LINE__, 0xf28d9ddd,	"f28d9ddd", "%x"},
  {__LINE__, 0x00003a79,	" 14969", "% ld"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%.7X"},
  {__LINE__, 0x0043d7fe,	"43D7FE", "%X"},
  {__LINE__, -0x0000b82,	"-2946", "%-ld"},
  {__LINE__, -0x00e29d8,	"-928216", "%d"},
  {__LINE__, 0xffffffec,	"ffffffec", "%-x"},
  {__LINE__, 0x0aeaf557,	"0xaeaf557", "%-#x"},
  {__LINE__, 0x00c07fe6,	"C07FE6", "%X"},
  {__LINE__, 0x307414d8,	"307414d8", "% 0x"},
  {__LINE__, -0x045ef67,	"-4583271", "%d"},
  {__LINE__, 0x0000024a,	" 0000586", "% .7d"},
  {__LINE__, 0xfffffc42,	"fffffc42", "%x"},
  {__LINE__, 0xfc38c249,	"fc38c249", "%5.x"},
  {__LINE__, -0x000d096,	"-53398", "%-d"},
  {__LINE__, -0x213a345,	"-34841413", "%ld"},
  {__LINE__, -0x0000130,	"-304", "%ld"},
  {__LINE__, -0x000efd1,	"-61393", "%ld"},
  {__LINE__, 0xfffff867,	"FFFFF867", "%2X"},
  {__LINE__, 0x00113ed0,	"0x113ed0", "%-#7x"},
  {__LINE__, 0x00000677,	" 1655", "% 3.ld"},
  {__LINE__, 0x0000002f,	"2f", "%x"},
  {__LINE__, 0xfffffd38,	"fffffd38", "%-4x"},
  {__LINE__, -0x000b3cc,	"-46028", "%1.2d"},
  {__LINE__, 0x45da719b,	"45DA719B", "%+0X"},
  {__LINE__, -0x000a454,	" -42068", "%7.3ld"},
  {__LINE__, 0x01cc7c30,	" 30178352", "% d"},
  {__LINE__, -0x05ae80e,	"-5957646", "%#.4ld"},
  {__LINE__, 0x000000b9,	"185", "%d"},
  {__LINE__, 0x003fcaf4,	"4180724", "%1.ld"},
  {__LINE__, 0x02da1b74,	"2DA1B74", "%X"},
  {__LINE__, 0xffffffd9,	"FFFFFFD9", "%X"},
  {__LINE__, 0x00064359,	"64359 ", "%-6X"},
  {__LINE__, 0x000000f0,	"240", "%ld"},
  {__LINE__, -0x01715e5,	"-1512933", "%ld"},
  {__LINE__, 0xc8f6e118,	"0XC8F6E118", "%#X"},
  {__LINE__, 0xfffffd8f,	"FFFFFD8F", "%X"},
  {__LINE__, 0x0000176d,	"5997  ", "%-6d"},
  {__LINE__, 0x00003cab,	"0x3cab", "%#0.3x"},
  {__LINE__, 0x00000001,	" 1", "% d"},
  {__LINE__, 0xfffff610,	"0XFFFFF610", "%#X"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%5.7X"},
  {__LINE__, 0x00000001,	"1", "%0x"},
  {__LINE__, 0x00000001,	"00001", "%.5ld"},
  {__LINE__, -0x0000d51,	"-3409", "%d"},
  {__LINE__, -0x08639ee,	"-8796654", "%ld"},
  {__LINE__, 0x00003121,	"12577", "%#1.2ld"},
  {__LINE__, 0x0000004e,	"78", "%d"},
  {__LINE__, 0xfffff64f,	"fffff64f", "%-x"},
  {__LINE__, 0x0000002a,	"2a", "%0x"},
  {__LINE__, 0x00000020,	"20", "%x"},
  {__LINE__, -0x00000b8,	"-184", "%#ld"},
  {__LINE__, 0x0000000a,	"10", "%-#d"},
  {__LINE__, 0x00000364,	"868", "%.1ld"},
  {__LINE__, 0x00d1f9b6,	"D1F9B6", "%0.X"},
  {__LINE__, 0x008cfda1,	"8CFDA1", "% 6.X"},
  {__LINE__, 0xffd58cce,	"FFD58CCE", "%X"},
  {__LINE__, 0x00000008,	"0000008", "%6.7ld"},
  {__LINE__, 0x00000318,	" 318", "%4X"},
  {__LINE__, 0x000172d8,	"94936", "%2ld"},
  {__LINE__, -0x056ccbf,	"-5688511", "%ld"},
  {__LINE__, 0x000000c7,	"+000199", "%+0.6d"},
  {__LINE__, 0x00000002,	"0X2", "%-#X"},
  {__LINE__, 0xfffff634,	"FFFFF634", "%.1X"},
  {__LINE__, -0x00001f3,	"-499", "%-ld"},
  {__LINE__, -0x000081b,	"-2075", "%-d"},
  {__LINE__, 0x000000b5,	"181", "%0d"},
  {__LINE__, 0xfe961ee8,	"fe961ee8", "%0x"},
  {__LINE__, 0x000028a2,	"10402", "%d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%.4X"},
  {__LINE__, -0x000058a,	"-1418", "%.3ld"},
  {__LINE__, 0x00001ceb,	"1CEB", "%X"},
  {__LINE__, 0x00000021,	"21", "% X"},
  {__LINE__, 0x00000002,	"2", "%0d"},
  {__LINE__, -0x2f9bbf5,	"-49921013", "%.4ld"},
  {__LINE__, 0x00000e91,	"03729", "%#.5ld"},
  {__LINE__, 0xf1116740,	"f1116740", "%2x"},
  {__LINE__, 0x00014f72,	"14F72", "%X"},
  {__LINE__, 0xfffffced,	"FFFFFCED", "%X"},
  {__LINE__, 0xffffffff,	"ffffffff", "%.5x"},
  {__LINE__, 0x0017cf0c,	" 1560332", "% 0ld"},
  {__LINE__, 0x0000000a,	"A", "% X"},
  {__LINE__, 0xff3a39d4,	"ff3a39d4", "%x"},
  {__LINE__, 0xfffef05f,	"FFFEF05F", "%X"},
  {__LINE__, 0xfedfe708,	"fedfe708", "%03.0x"},
  {__LINE__, 0x000345a0,	"345A0", "% X"},
  {__LINE__, -0x1ed5b6f7,	"-517322487", "%d"},
  {__LINE__, 0xd2d56c22,	"D2D56C22", "%0.X"},
  {__LINE__, 0x00002cbf,	"2CBF", "%.2X"},
  {__LINE__, 0x00000db4,	"db4", "%3x"},
  {__LINE__, -0x000b154,	"-45396", "%d"},
  {__LINE__, 0x002bf4c7,	"2BF4C7", "%X"},
  {__LINE__, 0x6954abf4,	"+1767156724", "%+d"},
  {__LINE__, 0xfffffffb,	"fffffffb", "%x"},
  {__LINE__, -0x29e0050e,	"-702547214", "%-0ld"},
  {__LINE__, -0x0014989,	"-84361", "%-#0.3ld"},
  {__LINE__, 0x001a557c,	"+1725820", "%+6.5d"},
  {__LINE__, -0x56689a81,	"-1449695873", "%.2d"},
  {__LINE__, 0x00000016,	"   16", "%05.X"},
  {__LINE__, 0x0001da1e,	" 121374", "% d"},
  {__LINE__, -0x04deac7,	"-5106375", "%03.4d"},
  {__LINE__, 0x000012b1,	"4785", "%d"},
  {__LINE__, 0x0009a116,	"9a116", "%-x"},
  {__LINE__, -0x0000003,	"-000003", "%4.6ld"},
  {__LINE__, 0x00000000,	"", "%.0x"},
  {__LINE__, 0x0000000a,	"  A", "% 3X"},
  {__LINE__, 0xfffffff0,	"0xfffffff0", "%-#0.1x"},
  {__LINE__, 0x00000086,	"86", "%0X"},
  {__LINE__, 0x0000001f,	"31", "%-d"},
  {__LINE__, 0x0386f706,	"59176710", "%3.6ld"},
  {__LINE__, 0xffe437ae,	"0XFFE437AE", "%#X"},
  {__LINE__, 0x0e5405c6,	"e5405c6", "%-x"},
  {__LINE__, 0xfffdee46,	"FFFDEE46", "%+X"},
  {__LINE__, 0xff861e9d,	"FF861E9D", "%5.X"},
  {__LINE__, 0xfffff570,	"FFFFF570", "%-X"},
  {__LINE__, 0x045c90bd,	"45c90bd", "%0x"},
  {__LINE__, 0x000000aa,	"AA", "%+X"},
  {__LINE__, -0x747262e,	"-122103342", "%0ld"},
  {__LINE__, 0xffffad89,	"FFFFAD89", "%X"},
  {__LINE__, 0x00000018,	"18", "%0.2X"},
  {__LINE__, 0x00057a2d,	" 358957", "% #7.d"},
  {__LINE__, 0x73a0e21d,	"1939923485", "%ld"},
  {__LINE__, -0x00021e1,	"-8673", "%0d"},
  {__LINE__, 0x000000e9,	"   233", "% 06.3ld"},
  {__LINE__, 0xffffcc0d,	"ffffcc0d", "%x"},
  {__LINE__, 0x00000052,	"52", "%x"},
  {__LINE__, 0x01c155af,	"1C155AF", "%.5X"},
  {__LINE__, 0xffffffff,	"ffffffff", "%0.x"},
  {__LINE__, -0x00400a4,	"-262308", "%-d"},
  {__LINE__, -0x0000001,	"-0000001", "%#.7ld"},
  {__LINE__, 0x01fb9c99,	"1fb9c99", "% 03.5x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%6.x"},
  {__LINE__, 0xff5e5eea,	"FF5E5EEA", "%X"},
  {__LINE__, 0x0000000f,	"F", "%+0X"},
  {__LINE__, 0xfffffe3a,	"fffffe3a", "% x"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%-X"},
  {__LINE__, -0x0000007,	"-7", "%0ld"},
  {__LINE__, -0x002f635,	"-194101", "%d"},
  {__LINE__, -0x0000005,	"-5", "%ld"},
  {__LINE__, -0x0000059,	"-89", "%0ld"},
  {__LINE__, -0x1ccda96,	"-30202518", "%d"},
  {__LINE__, -0x0000002,	"-2", "%-d"},
  {__LINE__, 0xffffffda,	"0XFFFFFFDA", "%#X"},
  {__LINE__, 0x00036cc5,	"224453", "%#d"},
  {__LINE__, 0x00000010,	"+16", "%+ld"},
  {__LINE__, 0x0b6039c7,	"190855623", "%d"},
  {__LINE__, -0x0000002,	"-002", "%#.3d"},
  {__LINE__, 0xfff3e746,	"FFF3E746", "%-4X"},
  {__LINE__, 0x0361b3de,	"361B3DE", "% 04X"},
  {__LINE__, 0xffffe6a2,	"ffffe6a2", "%-x"},
  {__LINE__, 0x00032790,	"0x0032790", "%#7.7x"},
  {__LINE__, 0xffe33b4e,	"ffe33b4e", "%-0x"},
  {__LINE__, -0x0094663,	"-607843", "%.3ld"},
  {__LINE__, -0x00a3efa,	"-671482", "%4d"},
  {__LINE__, 0x000000e6,	"   00E6", "%7.4X"},
  {__LINE__, 0x000125cb,	"125CB", "%+X"},
  {__LINE__, 0x0000b97e,	"b97e", "%x"},
  {__LINE__, -0x0000039,	"-57", "%+ld"},
  {__LINE__, 0xffffe39a,	"ffffe39a", "%5.4x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%6.1x"},
  {__LINE__, -0xdee910c,	"-233738508", "%-#2d"},
  {__LINE__, -0x14044930,	"-335825200", "%6.ld"},
  {__LINE__, 0x00a81259,	"a81259", "%x"},
  {__LINE__, 0x020e74c6,	"20E74C6", "%X"},
  {__LINE__, -0x00000fb,	"-251", "%01.d"},
  {__LINE__, 0x034ceb45,	"34CEB45", "%5.X"},
  {__LINE__, 0xfeacb66a,	"feacb66a", "% x"},
  {__LINE__, 0x00003eb6,	"3EB6", "% X"},
  {__LINE__, 0x000009ef,	"9ef", "% x"},
  {__LINE__, 0xf9d9dd07,	"F9D9DD07", "%0X"},
#ifndef __PCCNECV70__

  {__LINE__, 0x000154d7,	"087255", "%.6ld"},
  {__LINE__, -0x000036e,	"-878", "%-ld"},
  {__LINE__, -0x0007dcc,	"-32204", "% d"},
  {__LINE__, 0x000019dc,	"6620", "%d"},
  {__LINE__, 0xffffff6e,	"FFFFFF6E", "%2X"},
  {__LINE__, 0x00000016,	"0x16", "%-#x"},
  {__LINE__, 0xffdb3e96,	"ffdb3e96", "%+.5x"},
  {__LINE__, 0xffffffef,	"FFFFFFEF", "% 04.X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%5X"},
  {__LINE__, 0x000c08cd,	"C08CD", "%-X"},
  {__LINE__, 0x18de71ee,	"18de71ee", "%x"},
  {__LINE__, 0xffffffff,	"ffffffff", "% x"},
  {__LINE__, -0x00025bd,	"-009661", "%#.6d"},
  {__LINE__, 0x2f05de14,	" 788913684", "% 6.4ld"},
  {__LINE__, 0x0c99cf86,	"211406726", "%.5d"},
  {__LINE__, 0x09e6a21d,	" 166109725", "% 0d"},
  {__LINE__, -0x013da65,	"-1301093", "%+ld"},
  {__LINE__, 0x000003d0,	" 976", "% 4.2d"},
  {__LINE__, -0xef9e3cc,	"-251257804", "%-7.0d"},
  {__LINE__, 0x0000000c,	"+12", "%+00ld"},
  {__LINE__, 0xffffffe2,	"ffffffe2", "%x"},
  {__LINE__, 0x000000fe,	"fe", "%-x"},
  {__LINE__, 0xfffffc5f,	"fffffc5f", "%x"},
  {__LINE__, -0x0005c55,	"-23637", "%d"},
  {__LINE__, -0x0111ff2,	"-1122290", "% 7.d"},
  {__LINE__, -0x1a1746e5,	"-437733093", "%.4ld"},
  {__LINE__, 0x00001007,	"004103", "%00.6d"},
  {__LINE__, 0xffffffe1,	"ffffffe1", "%x"},
  {__LINE__, 0x0000d80f,	"55311", "%d"},
  {__LINE__, 0x00000004,	"4", "%+X"},
  {__LINE__, 0xfffffffd,	"fffffffd", "%6x"},
  {__LINE__, -0x2afbcc3c,	"-721144892", "%4.6ld"},
  {__LINE__, 0x00377f96,	"377F96", "%6.X"},
  {__LINE__, 0xffffffc8,	"FFFFFFC8", "%0X"},
  {__LINE__, 0x007ed9d1,	"8313297", "%-3d"},
  {__LINE__, 0x00000000,	"0", "%-X"},
  {__LINE__, 0x001e122d,	"1970733", "%01.d"},
  {__LINE__, -0x000029b,	"-667", "%ld"},
  {__LINE__, -0x002f563,	"-193891", "% 2.5d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%+3.7x"},
  {__LINE__, 0xfff7658c,	"fff7658c", "%x"},
  {__LINE__, -0x0006d08,	"-0027912", "%7.7ld"},
  {__LINE__, 0x00000080,	"80", "%X"},
  {__LINE__, 0x0000078f,	"  1935", "% 6ld"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "% X"},
  {__LINE__, 0x000000ae,	"     AE", "%7.X"},
  {__LINE__, -0x000d6aa,	"-54954", "%-ld"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%6.X"},
  {__LINE__, 0x000003bf,	"+959", "%+d"},
  {__LINE__, -0x7242d04b,	"-1916981323", "% ld"},
  {__LINE__, 0xf0e6546f,	"F0E6546F", "% .7X"},
  {__LINE__, 0x047e196a,	"75372906", "%ld"},
  {__LINE__, 0x0240174e,	"240174E", "%+0X"},
  {__LINE__, -0x0000006,	"-006", "%.3ld"},
  {__LINE__, 0x00068aac,	"428716", "%#ld"},
  {__LINE__, 0xffffffa1,	"ffffffa1", "%0x"},
  {__LINE__, 0x000adab3,	"adab3", "%x"},
  {__LINE__, -0x00000ae,	"-0000174", "%7.7ld"},
  {__LINE__, 0x0f0a8f4b,	"f0a8f4b", "% x"},
  {__LINE__, 0xfee229bc,	"fee229bc", "%x"},
  {__LINE__, -0x275b8455,	"-660309077", "%.2ld"},
  {__LINE__, -0xca4b2a5,	"-212120229", "%d"},
  {__LINE__, 0x000000b5,	" 181", "%04.d"},
  {__LINE__, 0xfff213f2,	"FFF213F2", "%X"},
  {__LINE__, 0x00000003,	"3", "%-X"},
  {__LINE__, 0x0ebb978b,	"247175051", "%.6ld"},
  {__LINE__, 0xffffffca,	"FFFFFFCA", "%X"},
  {__LINE__, -0x0000003,	"-03", "%+0.2d"},
  {__LINE__, -0x178ff86,	"-24706950", "%+d"},
  {__LINE__, 0x0000003c,	"     60", "%7.ld"},
  {__LINE__, -0x001012d,	"-65837", "%.5d"},
  {__LINE__, 0x03673fd2,	"3673fd2", "%.5x"},
  {__LINE__, -0x001fe74,	"-130676", "%#0.6ld"},
  {__LINE__, 0x004f6226,	"4f6226", "%-0x"},
  {__LINE__, 0xfffffa0f,	"fffffa0f", "%7x"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%-.6x"},
  {__LINE__, -0x0000001,	"-1", "%#d"},
  {__LINE__, 0xffffe43d,	"ffffe43d", "%7x"},
  {__LINE__, 0x00009d47,	"0040263", "%7.7ld"},
  {__LINE__, 0xff0fc79f,	"FF0FC79F", "%-4.X"},
  {__LINE__, 0x2d610907,	"2d610907", "%x"},
  {__LINE__, -0x00002de,	"-734", "%04d"},
  {__LINE__, 0x0000036b,	"    36B", "%7.1X"},
  {__LINE__, 0x00000002,	"2", "%.0x"},
  {__LINE__, -0x1f577b3e,	"-525826878", "%d"},
  {__LINE__, 0x0000002d,	"45", "%#ld"},
  {__LINE__, 0xfffffffb,	"fffffffb", "%x"},
  {__LINE__, -0x0000004,	"-4", "%-.0d"},
  {__LINE__, 0x00016ba4,	"16ba4", "%x"},
  {__LINE__, -0x1ad853d5,	"-450384853", "% 0ld"},
  {__LINE__, 0x00366899,	"366899", "%2.x"},
  {__LINE__, 0x1659158b,	"1659158B", "%X"},
  {__LINE__, 0x000076c7,	"76c7", "%x"},
  {__LINE__, 0x00000674,	"674", "%0x"},
  {__LINE__, 0x016c9d8a,	"+23895434", "%+ld"},
  {__LINE__, 0xfffffc43,	"FFFFFC43", "%0X"},
  {__LINE__, 0xfff249d2,	"fff249d2", "%-2.x"},
  {__LINE__, 0xffffffdd,	"ffffffdd", "%5x"},
  {__LINE__, 0xffffa7ef,	"FFFFA7EF", "%0.3X"},
  {__LINE__, 0x030d4d06,	"30d4d06", "%x"},
  {__LINE__, -0x0e4694b,	"-14969163", "%d"},
  {__LINE__, 0x00000078,	"120", "%.3ld"},
  {__LINE__, -0x16c1273e,	"-381757246", "%0d"},
  {__LINE__, 0xffffd183,	"FFFFD183", "% 0X"},
  {__LINE__, -0x2dfdadd,	"-48224989", "%ld"},
  {__LINE__, -0x5767fe5c,	"-1466433116", "%ld"},
  {__LINE__, 0x01bea036,	"29270070", "%#4.3d"},
  {__LINE__, 0x00000027,	"27", "%-x"},
  {__LINE__, 0x0004d183,	"4D183", "%X"},
  {__LINE__, 0xffdaf9c8,	"FFDAF9C8", "%.7X"},
  {__LINE__, 0xfffffd95,	"fffffd95", "%x"},
  {__LINE__, -0x0059acb,	"-367307", "%00.d"},
  {__LINE__, 0x017d8db4,	"17d8db4", "% 05.x"},
  {__LINE__, 0x0001f084,	"001F084", "%5.7X"},
  {__LINE__, 0x00000006,	" 6", "% ld"},
  {__LINE__, 0x011b0802,	"18548738", "%.3ld"},
  {__LINE__, 0x00000006,	"  6", "%#3.d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%6x"},
  {__LINE__, 0x00000001,	"1", "% x"},
  {__LINE__, 0x00000750,	" 01872", "% .5d"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%x"},
  {__LINE__, -0x00f842c,	"-1016876", "%+d"},
  {__LINE__, -0x001dcf0,	"-122096", "%-0d"},
  {__LINE__, 0x000000c9,	"0XC9", "% #3X"},
  {__LINE__, 0x1e368e86,	"1e368e86", "%7x"},
  {__LINE__, -0x0001157,	"-4439", "% 03.4d"},
  {__LINE__, 0xfff91e87,	"FFF91E87", "%3.5X"},
  {__LINE__, 0x00000006,	"6", "%x"},
  {__LINE__, 0x00000bca,	"3018", "%ld"},
  {__LINE__, 0x00495ff6,	"495ff6", "%01.0x"},
  {__LINE__, -0x0267f7a,	"-2523002", "% #5d"},
  {__LINE__, 0x00000060,	"96", "%-d"},
  {__LINE__, 0x000850c6,	"544966", "%#.1d"},
  {__LINE__, 0x00231457,	"231457", "%-6.4X"},
  {__LINE__, 0x0000000b,	"11", "%-d"},
  {__LINE__, 0x000003bd,	"957", "%#d"},
  {__LINE__, 0xfd51d970,	"FD51D970", "%+.7X"},
  {__LINE__, 0x000007bf,	"1983", "%-ld"},
  {__LINE__, 0x000034b2,	"34B2", "%0.X"},
  {__LINE__, 0x0000c18d,	"C18D", "%0.X"},
  {__LINE__, 0xffffbb83,	"ffffbb83", "% 3x"},
  {__LINE__, 0x000001d0,	"0x1d0", "%#x"},
  {__LINE__, -0x003c784,	"-247684", "%#ld"},
  {__LINE__, 0x0210cffa,	"210CFFA", "%X"},
  {__LINE__, -0x33093a1,	"-53515169", "% 0d"},
  {__LINE__, 0x00000001,	" 1", "% #ld"},
  {__LINE__, 0xffffaa53,	"ffffaa53", "%-4.5x"},
  {__LINE__, 0x2935c056,	"691388502", "%1.d"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, 0x000013d1,	"0X013D1", "%+#2.5X"},
  {__LINE__, -0x000035c,	"-860", "%-.2d"},
  {__LINE__, 0x00000000,	"    ", "%-4.X"},
  {__LINE__, -0x0000147,	"-327", "%d"},
  {__LINE__, 0x0a317eb0,	"171015856", "%.7d"},
  {__LINE__, 0x00000003,	"3", "%ld"},
  {__LINE__, 0x000001d6,	"1d6", "%-x"},
  {__LINE__, 0x18185214,	"404247060", "%-.2ld"},
  {__LINE__, 0x00574140,	"0574140", "%.7X"},
  {__LINE__, 0x00002ea5,	"02ea5", "%.5x"},
  {__LINE__, 0x00000005,	"5", "% x"},
  {__LINE__, 0xffc47ed6,	"ffc47ed6", "%-x"},
  {__LINE__, 0x0001f5da,	"0X1F5DA", "%#X"},
  {__LINE__, 0xfffffcc9,	"fffffcc9", "% x"},
  {__LINE__, 0x02586c98,	"2586C98", "%X"},
  {__LINE__, -0x0000036,	"-54", "% ld"},
  {__LINE__, 0x00064b57,	"412503", "%1.5d"},
  {__LINE__, -0x0000007,	"-7", "%#0.0ld"},
  {__LINE__, 0x00023a03,	"145923", "%ld"},
  {__LINE__, -0x0000065,	"-101", "%+#d"},
  {__LINE__, 0x00000208,	"208", "%X"},
  {__LINE__, 0x00e97728,	"15300392", "%-ld"},
  {__LINE__, 0x0000030a,	"+778", "%+d"},
  {__LINE__, 0xf4d7deee,	"F4D7DEEE", "%+X"},
  {__LINE__, -0x000009a,	"-154", "%+.3ld"},
  {__LINE__, 0x000002c0,	"+704", "%+ld"},
  {__LINE__, 0x0067ec23,	"67ec23", "%x"},
  {__LINE__, 0x005ca7fc,	"+6072316", "%+d"},
  {__LINE__, 0xfffff5f1,	"fffff5f1", "%x"},
  {__LINE__, 0x00000601,	"  0X601", "%#7.2X"},
  {__LINE__, -0x0000057,	"-87", "% ld"},
  {__LINE__, -0x0000078,	"   -120", "%7.d"},
  {__LINE__, -0x000001f,	"-31   ", "%-6d"},
  {__LINE__, 0x0160c000,	"23117824", "%ld"},
  {__LINE__, -0x0000007,	"-7", "%0ld"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%+x"},
  {__LINE__, 0x5b6ef898,	"5b6ef898", "%+0x"},
  {__LINE__, 0x0009bfb6,	"638902", "%d"},
  {__LINE__, -0x0000145,	"  -325", "%#6.0d"},
  {__LINE__, -0x508c048,	"-84459592", "%-5.ld"},
  {__LINE__, 0x00000002,	" 0x2", "% #4x"},
  {__LINE__, 0x0001486e,	"84078", "%#d"},
  {__LINE__, 0x006ac76a,	"6997866", "%.6d"},
  {__LINE__, 0xffffff98,	"FFFFFF98", "%X"},
  {__LINE__, 0xfffffe08,	"fffffe08", "%6.x"},
  {__LINE__, -0x24ef47e,	"-38728830", "%1.6ld"},
  {__LINE__, 0x39d1b2db,	"39D1B2DB", "% X"},
  {__LINE__, 0xfffc9ce2,	"0xfffc9ce2", "%#x"},
  {__LINE__, 0x59485e14,	"1497914900", "%#4ld"},
  {__LINE__, 0x000022eb,	"22EB", "%3.X"},
  {__LINE__, 0xfa410352,	"FA410352", "%-X"},
  {__LINE__, -0x4a342f0,	"-77808368", "% ld"},
  {__LINE__, 0xef5825a4,	"EF5825A4", "%.6X"},
  {__LINE__, 0x01b0185a,	"0x1b0185a", "% #x"},
  {__LINE__, -0x0004290,	"-17040", "%.3d"},
  {__LINE__, -0x10f88659,	"-284722777", "%+6.2ld"},
  {__LINE__, 0x00003216,	"12822", "%-d"},
  {__LINE__, 0x4a31a219,	"1244766745", "%d"},
  {__LINE__, 0xffffffb5,	"FFFFFFB5", "%-X"},
  {__LINE__, 0x0000d586,	"D586", "%-2.X"},
  {__LINE__, 0x00008496,	"33942", "%1.d"},
  {__LINE__, -0x0000011,	"-17", "%1ld"},
  {__LINE__, 0x0000003c,	"3C", "%2.X"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%.3X"},
  {__LINE__, 0x0000152a,	"152A", "%X"},
  {__LINE__, 0xfffe876e,	"FFFE876E", "%X"},
  {__LINE__, -0x0003874,	"-14452", "%-ld"},
  {__LINE__, -0x004918a,	"-299402", "%#.6d"},
  {__LINE__, -0x000000c,	"-12", "%-d"},
  {__LINE__, 0xffffd812,	"FFFFD812", "%+X"},
  {__LINE__, -0x000000c,	"-12", "%0d"},
  {__LINE__, -0x0000229,	"-553", "%0d"},
  {__LINE__, 0x00002ab8,	"2AB8", "%4.X"},
  {__LINE__, 0x0000004b,	"+75", "%+ld"},
  {__LINE__, 0x001c3178,	" 1847672", "% ld"},
  {__LINE__, -0x0000006,	"-6", "%.0ld"},
  {__LINE__, 0x0003be65,	"245349", "%ld"},
  {__LINE__, -0x0000001,	"-1", "%#1ld"},
  {__LINE__, 0x0000007f,	"+127", "%+ld"},
  {__LINE__, 0x0000020e,	"526  ", "%-5ld"},
  {__LINE__, 0x00000002,	"2", "%d"},
  {__LINE__, 0x03bd0873,	"0X3BD0873", "%#X"},
  {__LINE__, 0x00093a52,	"604754", "%-2d"},
  {__LINE__, -0x00823fc,	"-0533500", "%+.7ld"},
  {__LINE__, 0x00000000,	"    ", "%4.X"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, 0xfff09ede,	"fff09ede", "%-x"},
  {__LINE__, 0x01e28c24,	"31624228", "%ld"},
  {__LINE__, 0x00001dcc,	"1DCC", "%X"},
  {__LINE__, -0x0f0ea0d,	"-15788557", "%-00.ld"},
  {__LINE__, 0xffff73a1,	"FFFF73A1", "%X"},
  {__LINE__, -0x0004040,	"-16448", "%+#d"},
  {__LINE__, 0x0073b158,	"0x73b158", "%#7x"},
  {__LINE__, 0xfffff8ff,	"FFFFF8FF", "% 5X"},
  {__LINE__, -0x0000004,	"-4", "%0d"},
  {__LINE__, 0xffff56a3,	"ffff56a3", "%1.6x"},
  {__LINE__, -0x0000041,	"-65", "%0d"},
  {__LINE__, 0x00000009,	"+0000009", "%+2.7d"},
  {__LINE__, 0xffffe13d,	"0XFFFFE13D", "%+#2.X"},
  {__LINE__, -0x00002ce,	"-00718", "%.5ld"},
  {__LINE__, 0xffc53e28,	"ffc53e28", "%03.4x"},
  {__LINE__, 0x00000005,	"0X5", "%#X"},
  {__LINE__, 0x00000004,	"4", "%x"},
  {__LINE__, 0xe21b35eb,	"e21b35eb", "%-x"},
  {__LINE__, -0x0000098,	"-152", "%-ld"},
  {__LINE__, 0xffffff81,	"FFFFFF81", "%2X"},
  {__LINE__, 0x00000003,	"00003", "%.5ld"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%+x"},
  {__LINE__, 0x000491f5,	"299509", "%1.ld"},
  {__LINE__, 0xf06bfd7d,	"F06BFD7D", "%X"},
  {__LINE__, -0x0000006,	"-6", "%0d"},
  {__LINE__, -0x0a4af7d,	"-10792829", "%-0d"},
  {__LINE__, -0x11a74ef,	"-18511087", "%ld"},
  {__LINE__, 0x2dc95e17,	"768171543", "%-1.d"},
  {__LINE__, -0x0000001,	"-1", "%#ld"},
  {__LINE__, 0x00000033,	"51", "%-#d"},
  {__LINE__, 0x002d0219,	"2949657", "%ld"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%2.4X"},
  {__LINE__, 0x00000f20,	"+3872", "%+ld"},
  {__LINE__, -0x0000047,	"-071", "%4.3ld"},
  {__LINE__, 0x00000010,	"    16", "%6d"},
  {__LINE__, 0x00000000,	"0", "%0d"},
  {__LINE__, 0xffffff57,	"FFFFFF57", "%X"},
  {__LINE__, -0x0000700,	"-1792", "%-#d"},
  {__LINE__, -0x0000064,	"-100", "%-ld"},
  {__LINE__, 0xff26d49a,	"FF26D49A", "%-0X"},
  {__LINE__, -0x0000006,	"-6", "%.1ld"},
  {__LINE__, 0x1391edc5,	"1391edc5", "%.1x"},
  {__LINE__, 0x0000014a,	"330", "%-#ld"},
  {__LINE__, 0x07ecd1e1,	"7ecd1e1", "%6x"},
  {__LINE__, -0xa2b8898,	"-170625176", "%3.d"},
  {__LINE__, 0x00035287,	"0x35287", "%#.0x"},
  {__LINE__, 0x00000000,	"00000", "%0.5X"},
  {__LINE__, -0x0000153,	"-339", "%d"},
  {__LINE__, 0x0000ad6e,	" 44398", "% 0.d"},
  {__LINE__, 0x00000001,	"1", "%-X"},
  {__LINE__, -0x000000d,	"-13   ", "%-6.2d"},
  {__LINE__, -0x01bff8a,	"-1834890", "%d"},
  {__LINE__, 0x000a0fa8,	"+659368", "%+ld"},
  {__LINE__, 0xac044dc0,	"ac044dc0", "%.0x"},
  {__LINE__, 0x0003a729,	"239401", "%ld"},
  {__LINE__, -0x00004f0,	"-1264", "%+ld"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0x00000012,	"12", "% x"},
  {__LINE__, 0xffff770b,	"ffff770b", "%7.1x"},
  {__LINE__, 0xd7458572,	"d7458572", "%x"},
  {__LINE__, 0x01f1b4f9,	"1f1b4f9", "% 0x"},
  {__LINE__, 0xfffb2198,	"0XFFFB2198", "% #1.X"},
  {__LINE__, 0x00ef6189,	" 15688073", "% ld"},
  {__LINE__, -0x3f0ae63,	"-66104931", "% #d"},
  {__LINE__, -0x0006075,	"-24693", "%ld"},
  {__LINE__, 0x000000a1,	"161", "%d"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%3.2x"},
  {__LINE__, 0xff6b4125,	"FF6B4125", "%+5.X"},
  {__LINE__, 0x00000001,	"     1", "%6.d"},
  {__LINE__, -0x0000001,	"-1", "%+0d"},
  {__LINE__, -0x000096c,	"-2412", "%0.4d"},
  {__LINE__, 0x00039c6f,	"236655", "%.0d"},
  {__LINE__, 0x3625286c,	"908404844", "%.1d"},
  {__LINE__, 0xfffffffa,	"fffffffa", "%x"},
  {__LINE__, 0x00000000,	"0", "%X"},
  {__LINE__, 0x00c34353,	"12796755", "%#.4d"},
  {__LINE__, 0x000002df,	"735", "%ld"},
  {__LINE__, 0xffff38fa,	"FFFF38FA", "%5.1X"},
  {__LINE__, -0x000002a,	"-42", "%0.d"},
  {__LINE__, 0x0000077e,	"1918", "%ld"},
  {__LINE__, 0x000001f7,	"503", "%ld"},
  {__LINE__, 0x00000004,	"4", "%ld"},
  {__LINE__, 0x0021fb02,	"2226946", "%d"},
  {__LINE__, 0x007c858d,	"8160653", "%-0d"},
  {__LINE__, -0x0000109,	"-265", "%.0d"},
  {__LINE__, 0xfffffffa,	"fffffffa", "% x"},
  {__LINE__, 0x0097932d,	"97932d", "%+x"},
  {__LINE__, 0xfffbbd03,	"fffbbd03", "%-.5x"},
  {__LINE__, -0x0000005,	"-5", "%0d"},
  {__LINE__, 0x03ee3a95,	"65944213", "%ld"},
  {__LINE__, -0x0000002,	" -00002", "%7.5d"},
  {__LINE__, 0xea1a4e54,	"EA1A4E54", "%X"},
  {__LINE__, -0x000a9d6,	"-43478", "%+d"},
  {__LINE__, -0x0fd8d65,	"-16616805", "%5ld"},
  {__LINE__, 0x00000001,	"1", "%-d"},
  {__LINE__, 0x00000072,	"72", "%2.X"},
  {__LINE__, 0xffffff94,	"FFFFFF94", "%X"},
  {__LINE__, 0x00000d2a,	"D2A", "%+X"},
  {__LINE__, 0xffff614f,	"ffff614f", "%x"},
  {__LINE__, -0x0000018,	"-24", "%ld"},
  {__LINE__, 0x0000003b,	"059", "%2.3d"},
  {__LINE__, 0x0000001a,	"1A", "%0X"},
  {__LINE__, -0x0000109,	"-265", "%02ld"},
  {__LINE__, 0x00000f9d,	"3997", "%#1d"},
  {__LINE__, 0x0000001b,	"1b", "%x"},
  {__LINE__, 0xffffff07,	"ffffff07", "%x"},
  {__LINE__, 0xfff1a425,	"0xfff1a425", "%#x"},
  {__LINE__, 0x00000005,	"5", "%-1d"},
  {__LINE__, -0x53a6efd,	"-87715581", "%ld"},
  {__LINE__, 0x042f37db,	"42F37DB", "%6.X"},
  {__LINE__, 0x00053bd5,	"+342997", "%+5ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "% x"},
  {__LINE__, 0xffffffef,	"FFFFFFEF", "%6.X"},
  {__LINE__, -0x10ec29a,	"-17744538", "%+2.d"},
  {__LINE__, 0x01dcc901,	"1dcc901", "%x"},
  {__LINE__, 0x0007dc68,	"515176", "%-3.d"},
  {__LINE__, -0x0000062,	"-0098", "%#2.4d"},
  {__LINE__, 0x00000000,	"   ", "%3.0X"},
  {__LINE__, -0x00000de,	"-222", "%ld"},
  {__LINE__, 0x000c1fb8,	"C1FB8", "%0X"},
  {__LINE__, 0x0005bf58,	"5BF58", "%X"},
  {__LINE__, -0x000dd1b,	"-56603", "%-03.1d"},
  {__LINE__, 0x00000b14,	"B14", "%+3.X"},
  {__LINE__, 0x00000799,	"799", "%-x"},
  {__LINE__, 0xfffffffa,	"fffffffa", "%x"},
  {__LINE__, 0x00000003,	"0x00003", "% #7.5x"},
  {__LINE__, -0x002b9f1,	"-178673", "%+d"},
  {__LINE__, -0x001b817,	"-112663", "%0d"},
  {__LINE__, 0xf6f98533,	"f6f98533", "%.1x"},
  {__LINE__, 0x00338ffc,	"3379196", "%d"},
  {__LINE__, 0x0409e9b5,	"0X409E9B5", "%#X"},
  {__LINE__, 0x00b8e98e,	" 12118414", "% 0d"},
  {__LINE__, -0x002a8f6,	"-174326", "%ld"},
  {__LINE__, 0x13bb9722,	"331061026", "%0d"},
  {__LINE__, 0x00063c71,	"63c71", "%x"},
  {__LINE__, 0xfffffe37,	"FFFFFE37", "%.1X"},
  {__LINE__, 0xffff7b3e,	"ffff7b3e", "%+.1x"},
  {__LINE__, 0x005eeab1,	"5eeab1", "%+x"},
  {__LINE__, 0xffc69e99,	"ffc69e99", "%x"},
  {__LINE__, -0x000005c,	"  -92", "%5ld"},
  {__LINE__, 0x07d8fa8a,	"7d8fa8a", "%x"},
  {__LINE__, 0x00030e0a,	"200202", "%-4.1d"},
  {__LINE__, 0x00001dc1,	"1DC1", "%.0X"},
  {__LINE__, 0x00000008,	"8", "%0ld"},
  {__LINE__, -0x01b5397,	"-1790871", "%3.d"},
  {__LINE__, 0x27fbb4b5,	"27fbb4b5", "%x"},
  {__LINE__, -0xe3fdcfc,	"-239066364", "%4ld"},
  {__LINE__, 0x0008bcb1,	"8bcb1", "%0x"},
  {__LINE__, 0xffff039e,	"ffff039e", "%.6x"},
  {__LINE__, 0x000d0bd4,	"d0bd4", "%-x"},
  {__LINE__, 0x00000000,	"+0", "%+d"},
  {__LINE__, -0x2a49ea4,	"-44342948", "%1d"},
  {__LINE__, -0x0000055,	"-85", "%0d"},
  {__LINE__, -0x0000a05,	"-2565", "%3.3ld"},
  {__LINE__, -0x000000b,	"-11 ", "%-4d"},
  {__LINE__, 0xfff30444,	"FFF30444", "%7.X"},
  {__LINE__, 0x0000003f,	"63", "%-0d"},
  {__LINE__, 0x00046779,	"46779", "%X"},
  {__LINE__, 0x000028d7,	" 0X28D7", "%#7.X"},
  {__LINE__, 0x00000019,	"   19", "%5x"},
  {__LINE__, 0x0032291d,	"3287325", "%2.ld"},
  {__LINE__, 0x00057afa,	"57AFA", "%X"},
  {__LINE__, 0xfffe8c64,	"fffe8c64", "%3.4x"},
  {__LINE__, -0x624110d6,	"-1648431318", "%+6d"},
  {__LINE__, 0x0000001a,	"   26", "% 5.d"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%6.X"},
  {__LINE__, 0x00199490,	"1676432", "%-1d"},
  {__LINE__, -0xfff8265,	"-268403301", "%-0ld"},
  {__LINE__, 0x0000000e,	"e", "%-x"},
  {__LINE__, 0x00c38aec,	"c38aec", "%x"},
  {__LINE__, -0x00658f4,	"-415988", "%#ld"},
  {__LINE__, 0x0066ac4e,	"6728782", "%0d"},
  {__LINE__, 0xc4a808d5,	"c4a808d5", "%x"},
  {__LINE__, 0x00000000,	"     0", "%6.1x"},
  {__LINE__, 0x00066d24,	"66d24", "%x"},
  {__LINE__, 0x00002117,	"2117", "%X"},
  {__LINE__, 0xfe06fdf4,	"FE06FDF4", "%0X"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%x"},
  {__LINE__, 0x1c6bb795,	"+476821397", "%+d"},
  {__LINE__, 0xfffffba4,	"FFFFFBA4", "%X"},
  {__LINE__, 0xfffd7d44,	"fffd7d44", "%0x"},
  {__LINE__, 0x0019dd17,	"1694999", "%d"},
  {__LINE__, 0x6475851e,	"0x6475851e", "% #7.x"},
  {__LINE__, -0x00330d5,	"-209109", "%0ld"},
  {__LINE__, 0x009f53f7,	"09F53F7", "%+6.7X"},
  {__LINE__, -0x00172f9,	" -94969", "%7.5ld"},
  {__LINE__, 0xffffffdc,	"FFFFFFDC", "%X"},
  {__LINE__, -0x013bdec,	"-1293804", "%+#2ld"},
  {__LINE__, 0xfff845c0,	"fff845c0", "%+7.x"},
  {__LINE__, -0x0fbe712,	"-16508690", "%.7d"},
  {__LINE__, 0xffffe13f,	"ffffe13f", "%x"},
  {__LINE__, 0xbbc19951,	"BBC19951", "%-4X"},
  {__LINE__, -0x28d6d1b,	"-42822939", "%#d"},
  {__LINE__, -0x93cda6b,	"-154983019", "%-d"},
  {__LINE__, 0xffc93342,	"FFC93342", "%7.X"},
  {__LINE__, 0x072ac8b3,	" 120244403", "% ld"},
  {__LINE__, 0xfff8d17b,	"FFF8D17B", "% X"},
  {__LINE__, 0x00000da5,	"DA5", "%0.X"},
  {__LINE__, 0x055ad3ac,	"0x55ad3ac", "%#1x"},
  {__LINE__, 0x00000e5a,	" 3674", "% .4ld"},
  {__LINE__, 0xffffff79,	"FFFFFF79", "%+X"},
  {__LINE__, 0xffffe167,	"ffffe167", "%+5x"},
  {__LINE__, 0x0000fa50,	"0064080", "%.7ld"},
  {__LINE__, 0x00000001,	"1", "%-d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%x"},
  {__LINE__, 0x000009ac,	" 2476", "% #2.ld"},
  {__LINE__, 0x00000e78,	"0003704", "%.7ld"},
  {__LINE__, -0x000dfc3,	"-57283", "%6.d"},
  {__LINE__, 0x00000ee0,	"EE0", "%0X"},
  {__LINE__, -0x293703b3,	"-691471283", "%ld"},
  {__LINE__, 0x000073e8,	"  73e8", "%6x"},
  {__LINE__, 0xffffdffd,	"ffffdffd", "%5.5x"},
  {__LINE__, 0x00000004,	"4", "%+00.x"},
  {__LINE__, 0x00000008,	"0X8", "%#X"},
  {__LINE__, 0x0003044c,	"3044c", "%0x"},
  {__LINE__, 0xffc2095e,	"FFC2095E", "%0X"},
  {__LINE__, 0x00000aac,	"0002732", "%-.7ld"},
  {__LINE__, 0xffffff79,	"FFFFFF79", "%+1.X"},
  {__LINE__, 0x53a0f94a,	" 1403058506", "% 2.4ld"},
  {__LINE__, 0x000e928d,	"e928d", "%x"},
  {__LINE__, 0x0024127a,	"2364026", "%5.d"},
  {__LINE__, 0x000f7c1c,	" 1014812", "% 2.d"},
  {__LINE__, -0x000003d,	"-61 ", "%-#4ld"},
  {__LINE__, -0x0000122,	"-290", "%+ld"},
  {__LINE__, 0x00000006,	"+6", "%+0d"},
  {__LINE__, 0x00000129,	" 000129", "%7.6X"},
  {__LINE__, 0x15d873e5,	" 366506981", "% 5.7d"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, 0x038d6110,	"+59597072", "%+d"},
  {__LINE__, 0x0f46ccc3,	"256298179", "%-1.4d"},
  {__LINE__, 0xfe434d21,	"fe434d21", "%x"},
  {__LINE__, -0x179797d7,	"-395810775", "%d"},
  {__LINE__, 0xe35807bf,	"e35807bf", "%x"},
  {__LINE__, 0x00000003,	"     +3", "%+7d"},
  {__LINE__, 0x017e699e,	"25061790", "%#ld"},
  {__LINE__, -0x0000029,	"-41", "%d"},
  {__LINE__, 0xffffff11,	"ffffff11", "%1.x"},
  {__LINE__, -0x0001bf6,	"-7158", "%+0ld"},
  {__LINE__, 0xffffff4b,	"FFFFFF4B", "%4X"},
  {__LINE__, -0x0000040,	"-64", "%ld"},
  {__LINE__, 0x000034d6,	"+13526", "%+ld"},
  {__LINE__, 0xffffffa7,	"ffffffa7", "%x"},
  {__LINE__, 0xfffffe8e,	"fffffe8e", "%+.3x"},
  {__LINE__, 0x00000000,	"0", "%0.1d"},
  {__LINE__, -0x007cdf1,	"-511473", "%ld"},
  {__LINE__, 0xfffffeef,	"FFFFFEEF", "%-X"},
  {__LINE__, 0x00002d91,	"2d91", "%x"},
  {__LINE__, -0x000025b,	"-603", "%#ld"},
  {__LINE__, -0x000001b,	"-27", "%-ld"},
  {__LINE__, 0x042b6752,	"42B6752", "%+X"},
  {__LINE__, -0x75afb0a6,	"-1974448294", "% ld"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, 0x00000542,	"  1346", "%6d"},
  {__LINE__, -0x0000010,	"-16", "%+0d"},
  {__LINE__, 0xfffed8f7,	"FFFED8F7", "%5.X"},
  {__LINE__, 0x0541852e,	"541852e", "% 2.x"},
  {__LINE__, 0xff22aec3,	"ff22aec3", "% .1x"},
  {__LINE__, 0x5e34b745,	"1580513093", "%ld"},
  {__LINE__, 0xfffffff3,	"fffffff3", "%x"},
  {__LINE__, 0x0eda7b86,	"+249199494", "%+.3d"},
  {__LINE__, 0xffffe40f,	"ffffe40f", "%+x"},
  {__LINE__, -0x0003484,	"-13444", "%-1.5ld"},
  {__LINE__, 0x0000334b,	" 13131", "%6.ld"},
  {__LINE__, -0x0000149,	"-329", "%ld"},
  {__LINE__, 0x00000001,	"  001", "% 5.3x"},
  {__LINE__, 0xffeaa035,	"ffeaa035", "%+3.5x"},
  {__LINE__, 0x00211dff,	"2170367", "%ld"},
  {__LINE__, 0x007e91f4,	"7e91f4", "%x"},
  {__LINE__, 0xfffffffc,	"0xfffffffc", "%+#5x"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%6.X"},
  {__LINE__, 0x0156a9b5,	"156a9b5", "%x"},
  {__LINE__, 0xfffffe58,	"fffffe58", "%+x"},
  {__LINE__, 0xffff8c66,	"FFFF8C66", "%.0X"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, 0x00000005,	"      5", "%7.d"},
  {__LINE__, -0x0000002,	"-2", "%ld"},
  {__LINE__, 0x000076b9,	" 30393", "% ld"},
  {__LINE__, 0x00003824,	"3824", "%4X"},
  {__LINE__, 0x00000cdf,	"    CDF", "% 7X"},
  {__LINE__, 0x017c9e8f,	"17C9E8F", "%-X"},
  {__LINE__, -0x20f582d,	"-34560045", "%-.5d"},
  {__LINE__, 0x0000732e,	"  29486", "% 7.ld"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%+0X"},
  {__LINE__, 0xf379a4a2,	"F379A4A2", "% .7X"},
  {__LINE__, -0x0000028,	"-40", "%-d"},
  {__LINE__, 0xe73cf79e,	"e73cf79e", "%x"},
  {__LINE__, 0x00000002,	"      2", "%7ld"},
  {__LINE__, -0x00029b1,	"-10673", "%-#1.ld"},
  {__LINE__, -0x0002a58,	"-10840", "%3.d"},
  {__LINE__, 0x00000002,	"2", "%-X"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%X"},
  {__LINE__, -0x000003a,	"  -58", "%5ld"},
  {__LINE__, 0x0245ef3b,	"245ef3b", "%.3x"},
  {__LINE__, 0x00026cca,	"158922", "%-06.3ld"},
  {__LINE__, 0x01016fd3,	"16871379", "%-d"},
  {__LINE__, 0x000016fc,	"5884", "%0ld"},
  {__LINE__, -0x00007fb,	"  -2043", "%7.3d"},
  {__LINE__, 0xfff73d3c,	"fff73d3c", "%0x"},
  {__LINE__, -0x0000110,	"-272", "% 04.3d"},
  {__LINE__, 0x0000000e,	" 014", "% 04ld"},
  {__LINE__, -0x0000039,	"-57", "%.0ld"},
  {__LINE__, 0x00000c95,	"c95", "%0x"},
  {__LINE__, 0xffff3b2e,	"ffff3b2e", "%x"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%X"},
  {__LINE__, 0x00000015,	"21", "%.1d"},
  {__LINE__, 0x0000000c,	"+12", "%+ld"},
  {__LINE__, 0x00000000,	"0", "%+X"},
  {__LINE__, 0xfffc9a14,	"fffc9a14", "%-.5x"},
  {__LINE__, 0x0000003c,	"60", "%.2ld"},
  {__LINE__, -0x0000023,	"   -35", "%6.d"},
  {__LINE__, 0x00000740,	"1856", "%ld"},
  {__LINE__, 0x00000160,	"160", "% 3.X"},
  {__LINE__, 0x00000006,	"    6", "%5.X"},
  {__LINE__, -0x0000677,	"-1655", "%.3ld"},
  {__LINE__, 0x12709c7e,	"12709C7E", "%.7X"},
  {__LINE__, 0x0000090f,	"+2319", "%+#d"},
  {__LINE__, 0xffffffe0,	"0xffffffe0", "%#4.1x"},
  {__LINE__, 0x00132ce0,	"1256672", "%ld"},
  {__LINE__, 0x00000059,	"59", "%+X"},
  {__LINE__, -0x0000017,	"-23", "%0d"},
  {__LINE__, -0x01fade6,	"-2076134", "%-4.3ld"},
  {__LINE__, 0x000df3fa,	"914426", "%.5ld"},
  {__LINE__, 0xfffffd0f,	"fffffd0f", "%7x"},
  {__LINE__, -0x000c212,	"-49682", "%0.1ld"},
  {__LINE__, 0xffff8bcb,	"FFFF8BCB", "%.3X"},
  {__LINE__, 0x0000000a,	"a", "% x"},
  {__LINE__, 0x00000021,	"21", "%x"},
  {__LINE__, -0x0000040,	"-64", "% 1ld"},
  {__LINE__, 0x00000009,	"     9", "%6.ld"},
  {__LINE__, -0x0000d67,	"-3431", "% 5.3d"},
  {__LINE__, 0x03a85f1b,	"61366043", "%ld"},
  {__LINE__, 0x00000035,	"000053", "%0.6d"},
  {__LINE__, 0xfffda5cb,	"fffda5cb", "%+x"},
  {__LINE__, 0xffffff78,	"FFFFFF78", "%-7.0X"},
  {__LINE__, 0xfffffd6d,	"fffffd6d", "%7.x"},
  {__LINE__, 0xfffffc08,	"fffffc08", "%7.3x"},
  {__LINE__, 0x00003335,	" 13109", "% #d"},
  {__LINE__, -0x0000002,	"   -2", "%5.d"},
  {__LINE__, -0x13767a48,	"-326531656", "%+ld"},
  {__LINE__, 0x00000be5,	"3045", "%4.0ld"},
  {__LINE__, 0xfffdb28c,	"FFFDB28C", "%X"},
  {__LINE__, 0x00127118,	"1208600", "%ld"},
  {__LINE__, 0x00000086,	" 134", "% ld"},
  {__LINE__, 0x0002214c,	"2214c", "%+x"},
  {__LINE__, 0x0000a0c2,	" a0c2", "%5.0x"},
  {__LINE__, -0x000007c,	"-124", "%ld"},
  {__LINE__, 0x0000012a,	"00298", "%3.5d"},
  {__LINE__, 0xfd4f1257,	"FD4F1257", "%+2.X"},
  {__LINE__, 0xffffd8aa,	"ffffd8aa", "%5x"},
  {__LINE__, -0x00000a7,	"-167", "%+ld"},
  {__LINE__, -0x0009c69,	"-40041", "%0.0ld"},
  {__LINE__, 0x02230418,	"35849240", "%-0.6ld"},
  {__LINE__, 0x00000000,	"     0", "%6x"},
  {__LINE__, 0xfffff184,	"fffff184", "%02.5x"},
  {__LINE__, -0x0ae967b,	"-11441787", "%d"},
  {__LINE__, 0x0015de3a,	"1433146", "%-5.3d"},
  {__LINE__, -0x0071e93,	"-466579", "%1.ld"},
  {__LINE__, 0xfffff8bd,	"fffff8bd", "%+x"},
  {__LINE__, -0x00000e4,	"-228", "%+ld"},
  {__LINE__, 0x000001d8,	" 472", "% .3ld"},
  {__LINE__, 0x00315faa,	"315faa", "%-0x"},
  {__LINE__, 0x00000e59,	"e59", "%0x"},
  {__LINE__, -0x0000005,	"-5", "%ld"},
  {__LINE__, 0x000018ec,	"6380", "%ld"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%5.2x"},
  {__LINE__, -0xe7cfd39,	"-243072313", "%-d"},
  {__LINE__, 0x0002c30b,	"2C30B", "%1.2X"},
  {__LINE__, 0x0000007a,	"7A", "%X"},
  {__LINE__, 0xf604ecb2,	"F604ECB2", "%2X"},
  {__LINE__, -0x05f602c,	"-6250540", "%d"},
  {__LINE__, 0xffff9c86,	"ffff9c86", "%2.x"},
  {__LINE__, -0x00d7f55,	"-884565", "%#d"},
  {__LINE__, 0xd2a37824,	"D2A37824", "%4X"},
  {__LINE__, 0x00000000,	"", "%-.0x"},
  {__LINE__, 0x000d4b51,	"0d4b51", "%3.6x"},
  {__LINE__, 0x000ecd97,	"ecd97", "% x"},
  {__LINE__, -0x0000018,	"-024", "%+04ld"},
  {__LINE__, -0x009f292,	"-651922", "%ld"},
  {__LINE__, -0x0002da9,	"-11689", "%-0ld"},
  {__LINE__, -0x000a218,	"-41496", "%4.5d"},
  {__LINE__, 0xffff85ac,	"FFFF85AC", "% 04.X"},
  {__LINE__, -0x0d9ffbe,	"-14286782", "%0d"},
  {__LINE__, 0xfb18cc8e,	"fb18cc8e", "%x"},
  {__LINE__, 0xffffe5d3,	"FFFFE5D3", "%-X"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, -0x0000006,	"-6", "% d"},
  {__LINE__, 0x0002fc62,	"2fc62", "% 03.x"},
  {__LINE__, 0x00000000,	"00", "%.2d"},
  {__LINE__, -0x00000fd,	"  -253", "%6ld"},
  {__LINE__, -0x000000b,	"-11", "%d"},
  {__LINE__, -0x00042a3,	"-17059", "% 6d"},
  {__LINE__, 0x00000002,	"2", "% X"},
  {__LINE__, -0x61ead93e,	"-1642780990", "%-0d"},
  {__LINE__, 0xf2e61f6d,	"f2e61f6d", "%-.4x"},
  {__LINE__, 0xffd31b93,	"ffd31b93", "%x"},
  {__LINE__, -0x0000008,	"-8", "%ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%00x"},
  {__LINE__, 0x000000fb,	"+000251", "%+2.6d"},
  {__LINE__, 0x00000015,	"  15", "%4.X"},
  {__LINE__, 0x06ec6d96,	"6EC6D96", "%+2.X"},
  {__LINE__, 0xffff1df7,	"0xffff1df7", "% #1x"},
  {__LINE__, -0x000004b,	"-75", "%-ld"},
  {__LINE__, 0x00000008,	"8", "%#.0d"},
  {__LINE__, 0x00001355,	"4949", "%3.4ld"},
  {__LINE__, -0x00000f7,	"-247", "%d"},
  {__LINE__, 0x0000001f,	"31", "%.2ld"},
  {__LINE__, 0x0000d556,	"D556", "%-X"},
  {__LINE__, 0xffffd5a5,	"ffffd5a5", "% x"},
  {__LINE__, -0x0000e34,	"-3636", "%#d"},
  {__LINE__, -0x0000007,	"-7", "%d"},
  {__LINE__, 0x01ba10a4,	"1ba10a4", "%x"},
  {__LINE__, 0xfffff759,	"FFFFF759", "% X"},
  {__LINE__, -0x80d0adb,	"-135072475", "%d"},
  {__LINE__, 0x0002bf61,	"2bf61", "%x"},
  {__LINE__, 0xffff008b,	"FFFF008B", "%-7X"},
  {__LINE__, 0x00000e72,	"E72", "%X"},
  {__LINE__, -0x00000ea,	"-234", "%0ld"},
  {__LINE__, -0x0007b9d,	"-0031645", "%0.7ld"},
  {__LINE__, 0x0001baaa,	"0X1BAAA", "%#4X"},
  {__LINE__, 0x0000a57f,	"  a57f", "%6.x"},
  {__LINE__, -0x21a73726,	"-564606758", "%ld"},
  {__LINE__, 0x06f45c9f,	"0x6f45c9f", "%#.3x"},
  {__LINE__, 0x00018e5d,	"101981", "%-d"},
  {__LINE__, 0x0001e69a,	"124570", "%-d"},
  {__LINE__, -0x0000d26,	"  -3366", "% 07.d"},
  {__LINE__, 0x00000000,	"+", "%+0.ld"},
  {__LINE__, 0x00003916,	"14614", "%ld"},
  {__LINE__, 0xfffffd8f,	"fffffd8f", "%-3.x"},
  {__LINE__, 0x00000011,	"11", "%x"},
  {__LINE__, 0x000000e7,	"E7", "%X"},
  {__LINE__, 0xfdf9d89b,	"FDF9D89B", "%X"},
  {__LINE__, 0x00000a7c,	"a7c", "%x"},
  {__LINE__, 0x0000003f,	"00003F", "%.6X"},
  {__LINE__, 0xffffe729,	"FFFFE729", "%X"},
  {__LINE__, 0xfffffffe,	"fffffffe", "% .6x"},
  {__LINE__, -0x0000a4b,	"-2635", "%+d"},
  {__LINE__, 0xffffff50,	"ffffff50", "%0.7x"},
  {__LINE__, 0xfaf57e8b,	"faf57e8b", "% 4.x"},
  {__LINE__, -0x0000056,	"-86", "%ld"},
  {__LINE__, 0x08ed2a4d,	"8ed2a4d", "%4x"},
  {__LINE__, 0xff8d9081,	"FF8D9081", "%+0.X"},
  {__LINE__, 0x002730a1,	"2568353", "%4d"},
  {__LINE__, 0xffff9564,	"ffff9564", "%x"},
  {__LINE__, -0x0000006,	"  -6", "%4ld"},
  {__LINE__, -0x19890310,	"-428409616", "%0ld"},
  {__LINE__, 0xd2ce636c,	"d2ce636c", "%+x"},
  {__LINE__, -0x00001fe,	"-510", "%d"},
  {__LINE__, 0x00000006,	"0000006", "%+0.7x"},
  {__LINE__, 0xffffffc2,	"0XFFFFFFC2", "%-#.5X"},
  {__LINE__, -0x00000fd,	"-253", "%+d"},
  {__LINE__, 0x000216aa,	"0x216aa", "%#x"},
  {__LINE__, 0xffe36c66,	"ffe36c66", "%x"},
  {__LINE__, 0x00000002,	"2", "%x"},
  {__LINE__, -0x0000025,	"-37", "% d"},
  {__LINE__, 0x0000007e,	"126", "%d"},
  {__LINE__, 0x0003c1f9,	"+246265", "%+ld"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, -0x00539e7,	"-342503", "%06.ld"},
  {__LINE__, 0x00000d42,	"  3394", "%#6.ld"},
  {__LINE__, 0xf73b7c4e,	"F73B7C4E", "%X"},
  {__LINE__, 0x00000022,	"22", "%.1x"},
  {__LINE__, 0xffffa883,	"FFFFA883", "%X"},
  {__LINE__, 0x016ec247,	"16ec247", "%x"},
  {__LINE__, 0x00000019,	"19", "%+X"},
  {__LINE__, 0x0000665a,	"665A", "% 2.X"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%-5.X"},
  {__LINE__, 0x008e3fbc,	"8E3FBC", "%X"},
  {__LINE__, 0xfffffffa,	"FFFFFFFA", "%X"},
  {__LINE__, 0x1b806597,	"461399447", "%.2d"},
  {__LINE__, 0x00000366,	"0000870", "%#1.7ld"},
  {__LINE__, 0x0001d92e,	"1d92e", "%x"},
  {__LINE__, 0x000104ce,	"104CE", "%-X"},
  {__LINE__, 0xfffffe4c,	"fffffe4c", "%x"},
  {__LINE__, 0x000000e9,	"E9", "%X"},
  {__LINE__, 0x000a855c,	" 689500", "% d"},
  {__LINE__, 0x00000075,	"75", "% X"},
  {__LINE__, -0x0000026,	"-38", "%ld"},
  {__LINE__, 0xfffff169,	"fffff169", "%-04.2x"},
  {__LINE__, 0xffffff6f,	"ffffff6f", "%x"},
  {__LINE__, 0x00000003,	"0x3", "%#x"},
  {__LINE__, 0x00623bab,	"6437803", "%.0d"},
  {__LINE__, -0x2260224c,	"-576725580", "%ld"},
  {__LINE__, 0xe7e7a998,	"E7E7A998", "%.1X"},
  {__LINE__, 0x00000005,	"5", "%X"},
  {__LINE__, 0x0000b560,	"0xb560", "%#x"},
  {__LINE__, 0xfe11854d,	"fe11854d", "%-.5x"},
  {__LINE__, 0x00190014,	"1638420", "%ld"},
  {__LINE__, 0x0001d22a,	"0X1D22A", "%-#X"},
  {__LINE__, 0x00000c16,	"c16", "%2x"},
  {__LINE__, 0x00000d1a,	"3354", "%#d"},
  {__LINE__, 0x000165f6,	"91638", "%d"},
  {__LINE__, 0xfffff557,	"0XFFFFF557", "%#X"},
  {__LINE__, 0x00000588,	"    588", "%07.X"},
  {__LINE__, 0xf4a72708,	"f4a72708", "%x"},
  {__LINE__, 0xfff1cba9,	"0xfff1cba9", "% #2.5x"},
  {__LINE__, 0x000333a4,	"209828", "%d"},
  {__LINE__, 0x0000179b,	"179B", "% 2.X"},
  {__LINE__, 0x00000460,	"1120", "%0ld"},
  {__LINE__, 0xffffff89,	"FFFFFF89", "%X"},
  {__LINE__, -0x0000012,	"-18", "%ld"},
  {__LINE__, 0x00004fe0,	"20448", "%0.d"},
  {__LINE__, 0x00532e77,	"532e77", "%00.x"},
  {__LINE__, 0xf7b92efe,	"f7b92efe", "%0x"},
  {__LINE__, -0x0000243,	"-579", "%+1.d"},
  {__LINE__, 0x34894bb7,	"+881413047", "%+d"},
  {__LINE__, 0xfffaa189,	"FFFAA189", "% 6X"},
  {__LINE__, -0x0000579,	"-1401", "%+ld"},
  {__LINE__, 0x005acb12,	"5acb12", "%5.0x"},
  {__LINE__, 0xffff890a,	"FFFF890A", "%X"},
  {__LINE__, 0x010dff2f,	"10DFF2F", "%.7X"},
  {__LINE__, 0x00005a7f,	"23167", "%#ld"},
  {__LINE__, 0x000005e3,	"1507", "%#3d"},
  {__LINE__, -0xa815bcb,	"-176249803", "%d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%+x"},
  {__LINE__, 0xfffe0ff7,	"fffe0ff7", "%3x"},
  {__LINE__, 0xffffffff,	"0XFFFFFFFF", "%#2.1X"},
  {__LINE__, -0x1cc5ea52,	"-482732626", "%6.d"},
  {__LINE__, 0x000425ed,	"+0271853", "%+.7d"},
  {__LINE__, 0x00000001,	"1", "%+x"},
  {__LINE__, -0x48f2a72,	"-76491378", "%7.0d"},
  {__LINE__, 0xfffffff7,	"FFFFFFF7", "% 0X"},
  {__LINE__, 0xfd8ffc0a,	"fd8ffc0a", "%.1x"},
  {__LINE__, 0x0001f56d,	"  1F56D", "%+7.2X"},
  {__LINE__, 0x000000db,	"    DB", "%6.X"},
  {__LINE__, 0xffffffc2,	"ffffffc2", "%x"},
  {__LINE__, 0x00000001,	"001", "%03ld"},
  {__LINE__, 0xffd89f58,	"ffd89f58", "% 0.x"},
  {__LINE__, 0xfe1a72fc,	"fe1a72fc", "%x"},
  {__LINE__, 0xfffff9b6,	"FFFFF9B6", "%X"},
  {__LINE__, 0x00243633,	"243633", "%X"},
  {__LINE__, 0x00821bc7,	"+8526791", "%+#0ld"},
  {__LINE__, 0xfe63f348,	"0XFE63F348", "%#3X"},
  {__LINE__, 0xff729f19,	"ff729f19", "%4x"},
  {__LINE__, 0xffff570f,	"FFFF570F", "%+X"},
  {__LINE__, 0x00a57a42,	"10844738", "%6.3d"},
  {__LINE__, 0xfe4a3ed0,	"FE4A3ED0", "%6.X"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, 0x000001bb,	"01bb", "% .4x"},
  {__LINE__, 0x02b4a1e9,	"2b4a1e9", "%-7.x"},
  {__LINE__, 0x31750683,	"31750683", "%x"},
  {__LINE__, 0x00001cd7,	"7383", "%#ld"},
  {__LINE__, 0x0000079d,	"1949", "%d"},
  {__LINE__, 0xffb8ff3b,	"FFB8FF3B", "%X"},
  {__LINE__, 0x00a768b6,	"0A768B6", "%-6.7X"},
  {__LINE__, 0x1c665b48,	"0X1C665B48", "% #X"},
  {__LINE__, -0x000037d,	"-000893", "%3.6d"},
  {__LINE__, 0x29890443,	"29890443", "%+0x"},
  {__LINE__, 0x000000e5,	"e5  ", "%-4x"},
  {__LINE__, 0xfff2b5fa,	"FFF2B5FA", "%X"},
  {__LINE__, -0x5d32c2b,	"-97725483", "%05ld"},
  {__LINE__, -0x00016c5,	" -05829", "%+#7.5ld"},
  {__LINE__, 0x00000644,	"644", "%X"},
  {__LINE__, -0x018c027,	"-1622055", "%+.1d"},
  {__LINE__, 0x0000013c,	"0x13c", "%#x"},
  {__LINE__, 0x00000009,	"+9", "%+#ld"},
  {__LINE__, 0x00000000,	"0", "%ld"},
  {__LINE__, -0x018eb19,	"-1633049", "%4.3ld"},
  {__LINE__, 0xfffff429,	"FFFFF429", "% X"},
  {__LINE__, 0x0032de67,	"32DE67", "%X"},
  {__LINE__, 0x0016bdfa,	" 1490426", "% .2ld"},
  {__LINE__, 0x00000065,	"65", "%+.0X"},
  {__LINE__, 0x00000072,	"  72", "%+4.2X"},
  {__LINE__, 0x00075119,	"75119", "%2x"},
  {__LINE__, 0x000000b8,	"b8", "%x"},
  {__LINE__, 0x000000d0,	"d0", "%x"},
  {__LINE__, 0x000000b9,	"b9", "%x"},
  {__LINE__, 0x003fda9d,	" 4184733", "% #3.d"},
  {__LINE__, 0x00029a24,	"170532", "%4.d"},
  {__LINE__, -0x132a337d,	"-321532797", "% ld"},
  {__LINE__, 0x0000047a,	"0X47A", "%-#X"},
  {__LINE__, 0x00000000,	"0", "%-ld"},
  {__LINE__, -0x0d9750b,	"-14251275", "% ld"},
  {__LINE__, 0x00029d6c,	"29d6c", "%x"},
  {__LINE__, 0xfb060cc0,	"fb060cc0", "%x"},
  {__LINE__, 0xffffd524,	"0XFFFFD524", "%#X"},
  {__LINE__, 0xffffff30,	"ffffff30", "%-5x"},
  {__LINE__, 0x00001650,	"0005712", "%#0.7d"},
  {__LINE__, 0x0000b702,	"0B702", "%03.5X"},
  {__LINE__, 0x000003c1,	"3c1", "% .1x"},
  {__LINE__, -0x0290412,	"-2688018", "%d"},
  {__LINE__, -0x00008bf,	"-2239", "%#d"},
  {__LINE__, -0x0000001,	"-1", "%d"},
  {__LINE__, 0x0001d750,	"1D750", "%-X"},
  {__LINE__, 0x006eee92,	"6EEE92", "%-X"},
  {__LINE__, 0xff812b02,	"ff812b02", "%0x"},
  {__LINE__, 0xfffffeac,	"FFFFFEAC", "%+0X"},
  {__LINE__, 0x000003a5,	"3a5", "%x"},
  {__LINE__, -0x15270cee,	"-354880750", "%2.ld"},
  {__LINE__, 0x06b686d2,	"6b686d2", "%0x"},
  {__LINE__, 0xffe9cdcc,	"ffe9cdcc", "%x"},
  {__LINE__, 0x0ecb168e,	"ecb168e", "%x"},
  {__LINE__, 0x00000051,	"51", "%-X"},
  {__LINE__, -0x0018860,	"-100448", "%-0d"},
  {__LINE__, 0x8f08b82b,	"0x8f08b82b", "%-#.5x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, 0x0000000e,	"e", "%+01x"},
  {__LINE__, 0x04cf15bc,	" 80680380", "% #ld"},
  {__LINE__, 0x50006e8a,	"50006e8a", "%x"},
  {__LINE__, 0x0002f669,	"194153", "%0d"},
  {__LINE__, 0x000000a6,	"  166", "% 5.ld"},
  {__LINE__, -0x04036bb,	"-4208315", "%7.5d"},
  {__LINE__, 0x00070dea,	"70DEA", "%+X"},
  {__LINE__, 0x00000964,	"0x964", "%#x"},
  {__LINE__, 0x0000004d,	"0x4d", "% #3.x"},
  {__LINE__, -0x0000001,	"-1", "%-0d"},
  {__LINE__, 0x0000043e,	"1086", "%ld"},
  {__LINE__, -0x0000001,	"-1", "%-d"},
  {__LINE__, 0x00000000,	"+0", "%+d"},
  {__LINE__, 0xfffe68d9,	"FFFE68D9", "%7.X"},
  {__LINE__, -0x0169199,	"-1479065", "%#.5ld"},
  {__LINE__, -0x000003d,	"-61", "%ld"},
  {__LINE__, 0x00000001,	"+1", "%+.1d"},
  {__LINE__, 0x0001a65d,	"1a65d", "%.5x"},
  {__LINE__, 0x00000141,	"+000321", "%+#5.6ld"},
  {__LINE__, 0x00000000,	"   0", "%4x"},
  {__LINE__, 0x00000408,	"1032", "%-2.3ld"},
  {__LINE__, 0xffffffed,	"FFFFFFED", "%-X"},
  {__LINE__, 0xfe832351,	"FE832351", "% .4X"},
  {__LINE__, 0x003a421b,	"3A421B", "%-X"},
  {__LINE__, -0x53ed7f25,	"-1408073509", "%ld"},
  {__LINE__, -0x0000003,	"-0003", "%-5.4ld"},
  {__LINE__, 0x00000ad0,	"   2768", "%7d"},
  {__LINE__, 0xfffaf30b,	"FFFAF30B", "%X"},
  {__LINE__, 0x006349d3,	" 6506963", "% 6.2ld"},
  {__LINE__, 0x07f0146a,	"7f0146a", "%+3.4x"},
  {__LINE__, -0x0000002,	" -2", "% 3.ld"},
  {__LINE__, -0x26e94f3,	"-40801523", "%-#ld"},
  {__LINE__, -0x0000004,	"   -004", "%7.3d"},
  {__LINE__, 0xfffe8cc9,	"FFFE8CC9", "%0X"},
  {__LINE__, 0x00000018,	"   18", "%5.x"},
  {__LINE__, -0x4941de83,	"-1229053571", "% 0.5ld"},
  {__LINE__, 0x00000000,	"     0", "%6ld"},
  {__LINE__, 0xfffffffe,	"0XFFFFFFFE", "%-#X"},
  {__LINE__, -0x0142ae1,	"-1321697", "%4.ld"},
  {__LINE__, -0x0319e7f,	"-3251839", "%0ld"},
  {__LINE__, 0x000004ff,	"    4FF", "%7.2X"},
  {__LINE__, -0x0001c3e,	"-7230", "%#.2ld"},
  {__LINE__, 0xffffe522,	"ffffe522", "%x"},
  {__LINE__, 0x0001d1cb,	"+119243", "%+.3ld"},
  {__LINE__, 0xfad19d52,	"FAD19D52", "%+X"},
  {__LINE__, 0x00002a7c,	" 10876", "% 0.ld"},
  {__LINE__, 0x00001449,	"1449", "%X"},
  {__LINE__, 0x000732b8,	"471736", "%d"},
  {__LINE__, -0x211a496e,	"-555370862", "%ld"},
  {__LINE__, -0x0000004,	"-4", "%1.d"},
  {__LINE__, 0x0295c03d,	"43368509", "%5.ld"},
  {__LINE__, 0x01fa5722,	"33183522", "%0ld"},
  {__LINE__, 0xfffbff62,	"0xfffbff62", "%#x"},
  {__LINE__, 0x000000f5,	" 245", "% 2.d"},
  {__LINE__, 0x000000a0,	"160", "%-d"},
  {__LINE__, 0x0000000f,	"15", "%.2ld"},
  {__LINE__, 0x0bf5f077,	"+200667255", "%+ld"},
  {__LINE__, -0x14d3e5a,	"-21839450", "%#2.3d"},
  {__LINE__, -0x21cbe656,	"-567010902", "%ld"},
  {__LINE__, 0x000002b9,	"697", "%ld"},
  {__LINE__, 0xfffff9b0,	"FFFFF9B0", "%X"},
  {__LINE__, 0x007fd9c7,	"8378823", "%3.4d"},
  {__LINE__, 0x00036d06,	"36d06", "%x"},
  {__LINE__, 0xffde8052,	"FFDE8052", "%4.6X"},
  {__LINE__, 0x0000000d,	"13", "%#d"},
  {__LINE__, 0x68157d93,	"68157d93", "%x"},
  {__LINE__, 0x00000005,	"5", "%1x"},
  {__LINE__, 0xfffffff4,	"FFFFFFF4", "%X"},
  {__LINE__, 0xf5bbf7e9,	"f5bbf7e9", "%+.1x"},
  {__LINE__, 0x0be98f98,	"BE98F98", "%X"},
  {__LINE__, 0x00000122,	"00122", "%.5X"},
  {__LINE__, -0x0000936,	"-2358", "%+#3.0ld"},
  {__LINE__, 0xfd230f09,	"FD230F09", "%-7X"},
  {__LINE__, 0x00000089,	"137", "%ld"},
  {__LINE__, 0x00000078,	"    120", "%7d"},
  {__LINE__, -0x68ef2b6b,	"-1760504683", "%-ld"},
  {__LINE__, 0xc24480bb,	"C24480BB", "%+4X"},
  {__LINE__, 0xfefe36a2,	"FEFE36A2", "%0X"},
  {__LINE__, -0x35344ba,	"-55788730", "%7.d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%+.6X"},
  {__LINE__, -0x0000f40,	"-3904", "% ld"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "%X"},
  {__LINE__, 0x58b37c4b,	"58b37c4b", "%2.2x"},
  {__LINE__, 0x000000e2,	"226", "%#ld"},
  {__LINE__, 0xfff5ebde,	"fff5ebde", "%-7.1x"},
  {__LINE__, 0x0c6ea9be,	"208579006", "%-ld"},
  {__LINE__, 0xff708c74,	"FF708C74", "% 4.X"},
  {__LINE__, 0x00000000,	"  0", "% 3X"},
  {__LINE__, 0x00000004,	"  4", "%03.d"},
  {__LINE__, 0x0919be7c,	"+152682108", "%+6.d"},
  {__LINE__, 0x00d4fd1e,	"13958430", "%0d"},
  {__LINE__, 0xfe77a69e,	"fe77a69e", "%-7.x"},
  {__LINE__, 0x284ded44,	"676195652", "%-#2ld"},
  {__LINE__, -0x00006e6,	"-1766", "% ld"},
  {__LINE__, -0x7dac7ea,	"-131778538", "%.0ld"},
  {__LINE__, 0x0003c50f,	"247055", "%#d"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%-x"},
  {__LINE__, 0xfe0f0d1f,	"fe0f0d1f", "% 5.1x"},
  {__LINE__, 0x00000009,	"9", "%0ld"},
  {__LINE__, -0x0175cc1,	"-1531073", "%-04.d"},
  {__LINE__, 0x000e4da2,	" 937378", "% 4.ld"},
  {__LINE__, 0x00000762,	"762", "%-0.X"},
  {__LINE__, 0x005211bf,	"5211bf", "%-x"},
  {__LINE__, 0xfffffffb,	"fffffffb", "%+2.6x"},
  {__LINE__, 0x00008862,	"34914", "%ld"},
  {__LINE__, 0xfffc9754,	"fffc9754", "%+x"},
  {__LINE__, 0x0000716e,	"716E", "%X"},
  {__LINE__, 0x000000a8,	"a8", "%x"},
  {__LINE__, 0xffff84f5,	"ffff84f5", "%0x"},
  {__LINE__, 0x00005032,	"5032", "%x"},
  {__LINE__, 0xffe242b4,	"ffe242b4", "%6x"},
  {__LINE__, 0x002df9bd,	"3013053", "%ld"},
  {__LINE__, 0xffffe267,	"FFFFE267", "%.5X"},
  {__LINE__, 0xffffffc7,	"0xffffffc7", "%#x"},
  {__LINE__, -0x1727c38,	"-24280120", "%d"},
  {__LINE__, 0x01308072,	"1308072", "%x"},
  {__LINE__, -0x5883c7c,	"-92814460", "%+ld"},
  {__LINE__, 0x000030ad,	"30ad", "%x"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%X"},
  {__LINE__, -0x2090a708,	"-546350856", "% d"},
  {__LINE__, 0x0024e6b4,	"2418356", "%#ld"},
  {__LINE__, 0x02db71ac,	"2DB71AC", "% 6.3X"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%2.7X"},
  {__LINE__, -0x000074e,	"  -1870", "%7.ld"},
  {__LINE__, -0x0011d84,	"-73092", "%d"},
  {__LINE__, 0x00160723,	"160723", "%1.3x"},
  {__LINE__, 0x00412929,	"4270377", "%-d"},
  {__LINE__, -0x0008fc6,	"-36806", "% d"},
  {__LINE__, 0x00000002,	"2", "%d"},
  {__LINE__, 0x0eb67ffa,	"eb67ffa", "%.4x"},
  {__LINE__, 0x05b86c3c,	"95972412", "%4.4d"},
  {__LINE__, 0xffffca9c,	"FFFFCA9C", "% 4.X"},
  {__LINE__, 0x0007d571,	"7d571", "%-0x"},
  {__LINE__, -0x000239b,	"-09115", "%5.5d"},
  {__LINE__, -0x0000155,	" -341", "%5.3ld"},
  {__LINE__, 0x00000034,	"34", "%x"},
  {__LINE__, -0x0000051,	"-81", "%.1ld"},
  {__LINE__, 0x309bbbe0,	"309bbbe0", "%x"},
  {__LINE__, 0x0075be1e,	" 7716382", "% #ld"},
  {__LINE__, 0x000002d5,	"2d5", "%x"},
  {__LINE__, 0x006b466d,	"6B466D", "%-0X"},
  {__LINE__, 0x01d6c30f,	"1D6C30F", "%4.X"},
  {__LINE__, 0x00000003,	"      3", "%07.x"},
  {__LINE__, 0xfffcc102,	"FFFCC102", "%6.X"},
  {__LINE__, 0xffffffff,	"0XFFFFFFFF", "%#X"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%+x"},
  {__LINE__, 0x00000005,	"5", "%ld"},
  {__LINE__, 0xff060284,	"ff060284", "%x"},
  {__LINE__, 0x007a3325,	"7A3325", "%-X"},
  {__LINE__, 0xf5f595bd,	"F5F595BD", "%0X"},
  {__LINE__, 0xfffa3a10,	"FFFA3A10", "%0X"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, -0x15078f9,	"-22051065", "%7d"},
  {__LINE__, -0x0000002,	"-000002", "%.6d"},
  {__LINE__, 0x00000036,	"54", "%1.1ld"},
  {__LINE__, -0xbbecf6a,	"-197054314", "%ld"},
  {__LINE__, 0x0000043d,	"43D", "%X"},
  {__LINE__, 0xfffffffa,	"0xfffffffa", "% #6.x"},
  {__LINE__, 0x016759f8,	"23550456", "%0.ld"},
  {__LINE__, 0x000052d2,	"+21202", "%+6.2d"},
  {__LINE__, -0x007d232,	"-512562", "%ld"},
  {__LINE__, 0x00240be0,	"2362336", "%.1d"},
  {__LINE__, -0x0000001,	"-1", "%0d"},
  {__LINE__, 0xfffffffa,	"FFFFFFFA", "%X"},
  {__LINE__, -0x0000e88,	"-3720", "%ld"},
  {__LINE__, 0xfffffa9b,	"FFFFFA9B", "%.5X"},
  {__LINE__, 0x09296eeb,	"153710315", "%-1.0d"},
  {__LINE__, 0x001f46fc,	"0X1F46FC", "%#X"},
  {__LINE__, 0x00000006,	"6", "%X"},
  {__LINE__, 0xffffff87,	"0XFFFFFF87", "%+#X"},
  {__LINE__, 0x00000469,	"0469", "%04X"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, 0x00000000,	"", "%.0ld"},
  {__LINE__, -0x52bc137,	"-86753591", "%-#3ld"},
  {__LINE__, -0x2bddb08,	"-45996808", "%-3.d"},
  {__LINE__, 0x041367f7,	"41367F7", "%+X"},
  {__LINE__, -0x0018eb5,	"-102069", "%+ld"},
  {__LINE__, -0x0000537,	"-1335", "%#ld"},
  {__LINE__, -0x6f159ff4,	"-1863688180", "%+1.d"},
  {__LINE__, 0x00112ac8,	"0X112AC8", "%#6.3X"},
  {__LINE__, 0x00000000,	"   ", "%3.d"},
  {__LINE__, 0x0008afe8,	"08afe8", "%+3.6x"},
  {__LINE__, 0x00000015,	"21", "%ld"},
  {__LINE__, -0x02b7130,	"-2847024", "% #2.4d"},
  {__LINE__, 0xffffffd0,	"FFFFFFD0", "%X"},
  {__LINE__, -0x6970fa1,	"-110563233", "%+#.4ld"},
  {__LINE__, 0x06387dcc,	"0X6387DCC", "%-#X"},
  {__LINE__, 0xffffd506,	"ffffd506", "%+6x"},
  {__LINE__, -0x00fe5cd,	"-1041869", "%-#7d"},
  {__LINE__, -0x0c35bf6,	"-12803062", "%-03d"},
  {__LINE__, -0x0020d89,	"-134537", "%#d"},
  {__LINE__, -0x0c7aed3,	"-13086419", "%-ld"},
  {__LINE__, -0x000362a,	"-13866", "%#.4ld"},
  {__LINE__, -0x02d05f0,	"-2950640", "%#ld"},
  {__LINE__, 0x02de1321,	"0x2de1321", "%#7.x"},
  {__LINE__, 0xffb56428,	"0xffb56428", "%#x"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%X"},
  {__LINE__, 0xf072292d,	"F072292D", "%.5X"},
  {__LINE__, -0x0f4b0f2,	"-16036082", "%.5ld"},
  {__LINE__, 0x01b81885,	"28842117", "%5d"},
  {__LINE__, -0x009cfa6,	"-642982", "%d"},
  {__LINE__, 0xfffffffd,	"0XFFFFFFFD", "%-#.5X"},
  {__LINE__, 0x0dc97a66,	"DC97A66", "%2.X"},
  {__LINE__, 0x000000be,	"190", "%.0d"},
  {__LINE__, 0xffffe1c7,	"FFFFE1C7", "% X"},
  {__LINE__, 0x01883b9a,	"1883b9a", "%3x"},
  {__LINE__, 0xffffdde1,	"ffffdde1", "%+x"},
  {__LINE__, 0x2f1b4e32,	"+790318642", "%+ld"},
  {__LINE__, 0x000129aa,	"129aa", "%x"},
  {__LINE__, -0x00092c2,	"-37570", "%d"},
  {__LINE__, 0x00070fbd,	"70fbd", "%x"},
  {__LINE__, -0x00000ea,	"-234", "%+4ld"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%x"},
  {__LINE__, 0x0091c7f7,	"91C7F7", "% .3X"},
  {__LINE__, -0x0c14fe2,	"-12668898", "%d"},
  {__LINE__, -0x0017c15,	"-97301", "%d"},
  {__LINE__, -0x00005d0,	"-0001488", "%5.7d"},
  {__LINE__, 0x0114c36e,	"18137966", "%0d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%+x"},
  {__LINE__, 0x0ac76e78,	"180842104", "%d"},
  {__LINE__, 0x001976cd,	" 1668813", "% 4.ld"},
  {__LINE__, -0x0642319,	"-6562585", "% d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%X"},
  {__LINE__, -0x035019d,	"-3473821", "%.7d"},
  {__LINE__, -0x0000061,	"-97", "%#3.d"},
  {__LINE__, 0x0000001f,	"    31", "% 6.1ld"},
  {__LINE__, -0x0000024,	"-36", "%d"},
  {__LINE__, 0x000b3785,	"735109", "%ld"},
  {__LINE__, 0xfffffda9,	"fffffda9", "%-x"},
  {__LINE__, 0x00254832,	"2443314", "%-ld"},
  {__LINE__, 0xfffffd40,	"FFFFFD40", "%0X"},
  {__LINE__, -0x0006105,	"-24837", "%+#d"},
  {__LINE__, 0x00000006,	"+6", "%+d"},
  {__LINE__, 0xffd40fd8,	"ffd40fd8", "%3.x"},
  {__LINE__, -0x000988e,	"-39054", "%03d"},
  {__LINE__, 0x0005ad8b,	"5AD8B", "%0.0X"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, 0xfe1f59b7,	"fe1f59b7", "%4.x"},
  {__LINE__, -0x0000022,	"-34", "%#d"},
  {__LINE__, 0x0018e3e9,	"18E3E9", "% X"},
  {__LINE__, 0xffffff25,	"FFFFFF25", "%2.X"},
  {__LINE__, -0x00002c6,	"-710", "%1.ld"},
  {__LINE__, 0x00009765,	"38757", "%5ld"},
  {__LINE__, 0xfe197646,	"FE197646", "%-X"},
  {__LINE__, 0x00000001,	"    1", "%+5.x"},
  {__LINE__, -0x0000002,	"-2", "%#ld"},
  {__LINE__, 0x0072f6be,	"72F6BE", "%1X"},
  {__LINE__, -0x000f06d,	"-61549", "%-d"},
  {__LINE__, 0x00000001,	"    1", "%5X"},
  {__LINE__, 0x328cba28,	" 848083496", "% 2.ld"},
  {__LINE__, 0x0000cddc,	"cddc", "%.1x"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%7x"},
  {__LINE__, 0x00baf511,	"BAF511", "%-5.6X"},
  {__LINE__, 0x00000001,	"   1", "%4.ld"},
  {__LINE__, 0x0001e4b0,	"+124080", "%+ld"},
  {__LINE__, -0x07548f3,	"-7686387", "% 6.d"},
  {__LINE__, -0x01b14ea,	"-1774826", "% #0d"},
  {__LINE__, -0x000005c,	"-92 ", "%-04ld"},
  {__LINE__, -0x00000ae,	"-174", "%+.3ld"},
  {__LINE__, 0x0000008c,	"0X8C", "%+#X"},
  {__LINE__, 0x14c02360,	"14C02360", "%.6X"},
  {__LINE__, 0xfffffff6,	"FFFFFFF6", "%X"},
  {__LINE__, 0x009f4ee5,	"9f4ee5", "%x"},
  {__LINE__, 0x00000035,	"35", "%X"},
  {__LINE__, -0x00000eb,	"-235", "%ld"},
  {__LINE__, 0x1552ced8,	"1552CED8", "%04X"},
  {__LINE__, 0x0000002a,	"   2A", "%5X"},
  {__LINE__, 0xffffffff,	"ffffffff", "% x"},
  {__LINE__, -0xdec0db2,	"-233573810", "%d"},
  {__LINE__, 0x001e2ef0,	"1978096", "%2.d"},
  {__LINE__, 0xffffef24,	"ffffef24", "%.5x"},
  {__LINE__, 0xfffe6a6c,	"fffe6a6c", "%+x"},
  {__LINE__, -0x0000004,	"-4", "% ld"},
  {__LINE__, 0xfe3c6743,	"fe3c6743", "%.1x"},
  {__LINE__, 0x0000033d,	"829", "%0ld"},
  {__LINE__, -0x00006a0,	"  -1696", "% 7.ld"},
  {__LINE__, 0xffffffdb,	"ffffffdb", "%0.0x"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%3.3X"},
  {__LINE__, -0x0000004,	"-4", "%#ld"},
  {__LINE__, 0x00b32b56,	"B32B56", "%X"},
  {__LINE__, 0xffffffff,	"0xffffffff", "%+#x"},
  {__LINE__, 0x01cd1a48,	"1cd1a48", "%+7x"},
  {__LINE__, 0xffffffda,	"ffffffda", "%x"},
  {__LINE__, 0x1886509e,	"1886509E", "% X"},
  {__LINE__, 0x000000eb,	"235", "%0d"},
  {__LINE__, 0xfffffff4,	"fffffff4", "%0x"},
  {__LINE__, 0x00000547,	"547", "% X"},
  {__LINE__, 0x000017e6,	"17e6", "%-2.x"},
  {__LINE__, 0x00001dc4,	"7620", "%d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%3.0X"},
  {__LINE__, 0xffff93fa,	"0XFFFF93FA", "%#X"},
  {__LINE__, 0xfffffe1c,	"FFFFFE1C", "%-X"},
  {__LINE__, 0x00000000,	"", "% .0x"},
  {__LINE__, 0x000000a1,	"A1", "%X"},
  {__LINE__, 0xffffffff,	"0xffffffff", "%#x"},
  {__LINE__, -0x0001460,	"-05216", "%+#.5d"},
  {__LINE__, 0x00000001,	"1     ", "%-6.x"},
  {__LINE__, 0xfffd5324,	"FFFD5324", "%+2.6X"},
  {__LINE__, 0x00000007,	"    07", "%06.2d"},
  {__LINE__, 0x00000003,	"3", "%-X"},
  {__LINE__, 0xfffffdb7,	"0XFFFFFDB7", "%+#X"},
  {__LINE__, 0xfffff4cc,	"fffff4cc", "%0x"},
  {__LINE__, 0x00000000,	"0    ", "%-5X"},
  {__LINE__, 0x00758c96,	"758C96", "%X"},
  {__LINE__, -0x0000001,	"-1", "%-ld"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, 0x03f03caf,	"66075823", "%.2ld"},
  {__LINE__, 0x0000a87c,	"a87c", "%1.x"},
  {__LINE__, 0x00000034,	"34", "%X"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0x00010167,	"10167", "%x"},
  {__LINE__, -0x00007ce,	"-1998 ", "%-6ld"},
  {__LINE__, 0x00000001,	"1", "%.0d"},
  {__LINE__, 0x00d94cee,	"14241006", "%ld"},
  {__LINE__, -0x0000008,	"-8", "% d"},
  {__LINE__, -0x71520839,	"-1901201465", "%+0d"},
  {__LINE__, 0x0000035a,	"35a", "%-x"},
  {__LINE__, 0xfffd2f68,	"FFFD2F68", "%-X"},
  {__LINE__, 0x0006ea53,	"453203", "%1d"},
  {__LINE__, 0x000000df,	"DF", "% 1X"},
  {__LINE__, 0xfffffffe,	"fffffffe", "% 7x"},
  {__LINE__, 0x00000156,	"156", "% X"},
  {__LINE__, 0x00037ac9,	" 228041", "% ld"},
  {__LINE__, 0xffffffde,	"FFFFFFDE", "%0.5X"},
  {__LINE__, 0x00000025,	"37", "%-0.ld"},
  {__LINE__, -0x4133686,	"-68368006", "%2ld"},
  {__LINE__, -0x000003b,	"-59", "%.2ld"},
  {__LINE__, 0xfffff910,	"fffff910", "% 00.0x"},
  {__LINE__, 0xff9ec802,	"FF9EC802", "%2.6X"},
  {__LINE__, 0x00000008,	"0X8", "%#1X"},
  {__LINE__, 0xfffffff7,	"FFFFFFF7", "%-X"},
  {__LINE__, 0x0029a4da,	"2729178", "%04.ld"},
  {__LINE__, 0x007d1588,	"8197512", "%#d"},
  {__LINE__, 0x0007e86d,	"518253", "%0d"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%x"},
  {__LINE__, 0x00000002,	"002", "%.3d"},
  {__LINE__, 0x00006ec1,	"6EC1", "%2X"},
  {__LINE__, 0x0000300c,	"12300", "%-d"},
  {__LINE__, -0x0000002,	"-2", "%+ld"},
  {__LINE__, -0x0000002,	"-2", "%ld"},
  {__LINE__, -0x00015d5,	"-005589", "%#.6ld"},
  {__LINE__, 0x00000041,	"65", "%d"},
  {__LINE__, 0x00000229,	"0000229", "% 0.7x"},
  {__LINE__, 0xfffffffb,	"fffffffb", "%03.x"},
  {__LINE__, 0x00093262,	"0602722", "%.7d"},
  {__LINE__, -0x00037b4,	"-14260", "%-0ld"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%-x"},
  {__LINE__, 0xf24cb3e6,	"f24cb3e6", "%1x"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "%0X"},
  {__LINE__, 0x00000031,	"0000049", "%00.7ld"},
  {__LINE__, 0x00000bb3,	"BB3", "%.1X"},
  {__LINE__, -0x0000001,	"-0001", "%+#4.4ld"},
  {__LINE__, -0x0000001,	"-1", "% d"},
  {__LINE__, 0x00022c0c,	"22c0c", "%-x"},
  {__LINE__, 0xffffffd4,	"ffffffd4", "%x"},
  {__LINE__, 0x000729c6,	"469446", "%3.d"},
  {__LINE__, 0xb180feae,	"b180feae", "%3.x"},
  {__LINE__, 0x124fac15,	"307211285", "%-0ld"},
  {__LINE__, -0x0000004,	"-4", "%ld"},
  {__LINE__, 0x0000006a,	"106", "%#d"},
  {__LINE__, 0x0000297f,	"297F", "%+3X"},
  {__LINE__, 0x0000000e,	"14", "%0ld"},
  {__LINE__, 0x00000027,	"27", "%0.1X"},
  {__LINE__, 0xffeb98eb,	"ffeb98eb", "% 05.2x"},
  {__LINE__, 0xfffff19b,	"FFFFF19B", "%+X"},
  {__LINE__, 0x00025992,	"154002", "%6.6d"},
  {__LINE__, 0x00000040,	"   040", "%6.3X"},
  {__LINE__, 0x00000a9e,	" 0a9e", "%5.4x"},
  {__LINE__, 0x00c7f2cc,	"c7f2cc", "%x"},
  {__LINE__, 0x000325e6,	" 325E6", "%6.X"},
  {__LINE__, -0x69faad3,	"-111127251", "%d"},
  {__LINE__, -0x059a307,	"-5874439", "% ld"},
  {__LINE__, 0xfffffff6,	"0xfffffff6", "%#0.0x"},
  {__LINE__, 0x0030fdf3,	"30fdf3", "%x"},
  {__LINE__, 0x00007343,	"+29507", "%+#2d"},
  {__LINE__, 0x0003cf4b,	"0X3CF4B", "% #.2X"},
  {__LINE__, 0x00000433,	"+1075", "%+0ld"},
  {__LINE__, 0xfffffffd,	"fffffffd", "%+.3x"},
  {__LINE__, 0x0ae30c4e,	"ae30c4e", "%+00x"},
  {__LINE__, 0x0002540f,	"02540f", "%-.6x"},
  {__LINE__, -0x0000001,	"  -01", "% #5.2ld"},
  {__LINE__, 0xffffffe7,	"0xffffffe7", "% #5.x"},
  {__LINE__, 0x0000005b,	"91", "%d"},
  {__LINE__, 0x00001f9b,	"8091", "%.4ld"},
  {__LINE__, 0xfffff315,	"fffff315", "%4.x"},
  {__LINE__, -0x130eec41,	"-319745089", "% ld"},
  {__LINE__, 0xfff8fe13,	"FFF8FE13", "%X"},
  {__LINE__, -0x0000004,	"-00004", "%5.5d"},
  {__LINE__, 0x00000669,	"669", "%0X"},
  {__LINE__, -0x0000004,	"-4", "%d"},
  {__LINE__, 0xf5e81496,	"F5E81496", "% 6X"},
  {__LINE__, -0x0000001,	"-1", "% 0d"},
  {__LINE__, 0xfffffff7,	"fffffff7", "%x"},
  {__LINE__, 0x000001de,	"478", "%d"},
  {__LINE__, 0x0000623e,	"25150", "%5.0d"},
  {__LINE__, 0xffffffa8,	"FFFFFFA8", "%+X"},
  {__LINE__, -0x0000117,	"-279", "% ld"},
  {__LINE__, -0x0000517,	"-1303", "%d"},
  {__LINE__, 0xfffff9d5,	"fffff9d5", "% x"},
  {__LINE__, 0x000001cc,	"1CC", "%-X"},
  {__LINE__, 0x0000019a,	"0000410", "%.7d"},
  {__LINE__, 0x00000003,	"3     ", "%-06X"},
  {__LINE__, 0x00000009,	"0x9", "%#0x"},
  {__LINE__, 0xfd544610,	"0XFD544610", "% #X"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%+x"},
  {__LINE__, 0x00009437,	"37943", "%ld"},
  {__LINE__, -0x00b5ea6,	"-745126", "%d"},
  {__LINE__, 0xffffffd8,	"ffffffd8", "%6x"},
  {__LINE__, 0x00002a2d,	"10797", "%.3ld"},
  {__LINE__, 0x00275238,	"2576952", "%0ld"},
  {__LINE__, 0xfff90a34,	"FFF90A34", "%-7X"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "% .7X"},
  {__LINE__, -0xb3b673e,	"-188442430", "% ld"},
  {__LINE__, 0xfffff67a,	"0xfffff67a", "%#0.x"},
  {__LINE__, 0x0000dff6,	"   dff6", "%+7.x"},
  {__LINE__, 0xffee46e3,	"ffee46e3", "%x"},
  {__LINE__, 0x00001a66,	" 0006758", "% 7.7d"},
  {__LINE__, 0x0002b475,	"2B475", "%.4X"},
  {__LINE__, 0x0002090d,	"002090d", "%.7x"},
  {__LINE__, -0x0057838,	"-358456", "%#ld"},
  {__LINE__, 0x00000004,	"0x4", "%#x"},
  {__LINE__, 0x0574cb62,	"91540322", "%#7d"},
  {__LINE__, -0x0054388,	"-344968", "% #d"},
  {__LINE__, 0x000421c2,	"421C2", "% X"},
  {__LINE__, 0x00000003,	"3", "%0d"},
  {__LINE__, 0xffffe2e2,	"ffffe2e2", "% 5.x"},
  {__LINE__, 0x00000021,	"+33", "%+d"},
  {__LINE__, -0x0020033,	"-131123", "%ld"},
  {__LINE__, -0x0000001,	"  -1", "%4.ld"},
  {__LINE__, 0x000000fd,	"000fd", "%3.5x"},
  {__LINE__, 0x023e4337,	"37634871", "%1d"},
  {__LINE__, 0x6e823d96,	"6E823D96", "% X"},
  {__LINE__, 0xfff0e133,	"fff0e133", "%x"},
  {__LINE__, -0x000decc,	"-57036", "%3d"},
  {__LINE__, 0x004397b8,	"4429752", "%0d"},
  {__LINE__, -0x0000023,	"   -35", "%6d"},
  {__LINE__, 0xffe701ca,	"FFE701CA", "%3X"},
  {__LINE__, 0x000c0319,	"+787225", "%+.6d"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xfffffe1d,	"FFFFFE1D", "%X"},
  {__LINE__, 0xfffffb33,	"fffffb33", "%x"},
  {__LINE__, 0x02b5e30a,	"45474570", "%d"},
  {__LINE__, 0x000074eb,	"29931", "%03.ld"},
  {__LINE__, -0x4e42e310,	"-1313006352", "%-0.d"},
  {__LINE__, -0x000007b,	"-123", "%d"},
  {__LINE__, 0x00000160,	" 352", "% d"},
  {__LINE__, -0x16af31ec,	"-380580332", "%#ld"},
  {__LINE__, -0x000006e,	"-000110", "%07ld"},
  {__LINE__, 0x232699a0,	"232699a0", "%7.x"},
  {__LINE__, 0x00f9b8e5,	"+16365797", "%+0d"},
  {__LINE__, 0x0000000c,	"C", "%X"},
  {__LINE__, 0xfffffd4f,	"FFFFFD4F", "%X"},
  {__LINE__, 0xffffe7bb,	"FFFFE7BB", "%.7X"},
  {__LINE__, -0x0000163,	"-355", "%d"},
  {__LINE__, 0x00070315,	" 459541", "% #2.d"},
  {__LINE__, -0x7d5c12a,	"-131449130", "% 6.ld"},
  {__LINE__, 0xffffffb2,	"FFFFFFB2", "%X"},
  {__LINE__, -0x0004aad,	"-19117", "%+6.4ld"},
  {__LINE__, 0x00115586,	"1136006", "%0d"},
  {__LINE__, -0x0000021,	"-33", "%d"},
  {__LINE__, 0x093ce01e,	"93ce01e", "% 5x"},
  {__LINE__, 0x00672135,	"672135", "% x"},
  {__LINE__, 0x05f4abd5,	"0x5f4abd5", "%+#6.x"},
  {__LINE__, -0x0448b03,	"-4492035", "%-0.2ld"},
  {__LINE__, 0x00000000,	"0", "%#x"},
  {__LINE__, 0x1987217e,	"428286334", "%d"},
  {__LINE__, 0x000010f6,	"10f6", "%-x"},
  {__LINE__, 0x0000177a,	"177a", "%1x"},
  {__LINE__, 0xfffffefd,	"FFFFFEFD", "%7X"},
  {__LINE__, -0x095cbf8,	"-9817080", "%-5ld"},
  {__LINE__, 0x0000008a,	"138", "%2.0ld"},
  {__LINE__, 0xfffe80ad,	"fffe80ad", "%0x"},
  {__LINE__, -0x1a4c8f7,	"-27576567", "%d"},
  {__LINE__, 0x00000000,	"0", "%-x"},
  {__LINE__, 0x0000a82b,	"43051", "%-ld"},
  {__LINE__, 0x000000eb,	"235", "%2.3ld"},
  {__LINE__, -0x0002747,	"-10055", "%d"},
  {__LINE__, 0x00000319,	"0X319", "%#X"},
  {__LINE__, 0xfffffcfe,	"FFFFFCFE", "% X"},
  {__LINE__, 0x00050f0e,	"50f0e", "%-1x"},
  {__LINE__, -0x398e09e,	"-60350622", "%0.7ld"},
  {__LINE__, 0x00000000,	"  ", "%2.ld"},
  {__LINE__, 0x00000049,	"00049", "% .5X"},
  {__LINE__, -0x00000dd,	" -221", "%+#5ld"},
  {__LINE__, 0xf6db2fac,	"f6db2fac", "%-07x"},
  {__LINE__, 0x0000004f,	"4F", "% .0X"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xfd07f692,	"fd07f692", "%x"},
  {__LINE__, 0xdb98bde0,	"db98bde0", "%x"},
  {__LINE__, 0x00000271,	"0271", "% 3.4x"},
  {__LINE__, -0x000115a,	"-4442", "%#1.ld"},
  {__LINE__, 0x0002f5f2,	"194034", "%ld"},
  {__LINE__, -0x0000152,	"   -338", "%+7ld"},
  {__LINE__, 0x00059336,	"365366", "%d"},
  {__LINE__, 0xfffffff6,	"fffffff6", "%-7x"},
  {__LINE__, 0xfb916c51,	"fb916c51", "%-x"},
  {__LINE__, 0xffff413d,	"FFFF413D", "%-X"},
  {__LINE__, 0xf2576910,	"F2576910", "%-4.X"},
  {__LINE__, 0xfffc7730,	"fffc7730", "%5.x"},
  {__LINE__, 0x000002e6,	"+742", "%+1d"},
  {__LINE__, -0x00001bf,	"-447", "%3d"},
  {__LINE__, 0x000002e1,	"2E1", "%-X"},
  {__LINE__, 0x00000096,	"150", "%#0ld"},
  {__LINE__, 0x000002bd,	"701", "%d"},
  {__LINE__, -0x0053386,	"-340870", "%#d"},
  {__LINE__, 0xfffdb076,	"FFFDB076", "%X"},
  {__LINE__, 0x00004dc5,	" +19909", "%+07.ld"},
  {__LINE__, 0x00000f7a,	" F7A", "%4X"},
  {__LINE__, 0x02405000,	" 37769216", "% ld"},
  {__LINE__, 0xfffce68d,	"fffce68d", "%0x"},
  {__LINE__, -0x35b3af2,	"-56310514", "%-ld"},
  {__LINE__, -0x0238631,	"-2328113", "%.4d"},
  {__LINE__, -0x000001e,	"-030", "%.3ld"},
  {__LINE__, 0xffffffdd,	"FFFFFFDD", "%.4X"},
  {__LINE__, 0x0013f6ac,	"13f6ac", "%02.x"},
  {__LINE__, 0xfffffffa,	"fffffffa", "%+07.x"},
  {__LINE__, -0x000192b,	" -6443", "%6.d"},
  {__LINE__, 0x0000058b,	"+1419", "%+d"},
  {__LINE__, 0x00001391,	"5009", "%ld"},
  {__LINE__, -0x0041a57,	"-268887", "%1ld"},
  {__LINE__, -0x0041a57,	"-268887", "%1ld"},
  {__LINE__, 0xfffff266,	"0xfffff266", "%+#6.6x"},
  {__LINE__, 0x0000018b,	"   395", "%6.ld"},
  {__LINE__, 0x009ae24d,	"+10150477", "%+ld"},
  {__LINE__, 0x0000007e,	"7E", "%X"},
  {__LINE__, 0xfffffd53,	"FFFFFD53", "% 0X"},
  {__LINE__, 0x000002fa,	"2FA", "%-1.3X"},
  {__LINE__, 0x000000a4,	"164", "%0d"},
  {__LINE__, 0x00001833,	"6195", "%ld"},
  {__LINE__, -0x0000001,	"-1", "%d"},
  {__LINE__, 0xf2fcbd9b,	"F2FCBD9B", "%+0.2X"},
  {__LINE__, 0x00004a8a,	"4A8A", "%X"},
  {__LINE__, -0x10695cda,	"-275340506", "%d"},
  {__LINE__, 0x00000037,	"37", "%X"},
  {__LINE__, 0x00082d5c,	"82D5C", "%+0.5X"},
  {__LINE__, 0xfffffe01,	"fffffe01", "% 5.3x"},
  {__LINE__, 0x000005ea,	"05EA", "% 1.4X"},
  {__LINE__, 0x0e0b8826,	"e0b8826", "%2x"},
  {__LINE__, -0x0000161,	"-353", "%+d"},
  {__LINE__, 0x19e3014a,	"19E3014A", "%+5X"},
  {__LINE__, 0x00000140,	"140", "%x"},
  {__LINE__, 0xffff84b9,	"FFFF84B9", "%X"},
  {__LINE__, -0x0005776,	"-22390", "%+5ld"},
  {__LINE__, 0x0162ad61,	"162AD61", "% X"},
  {__LINE__, 0x00002395,	"2395", "%X"},
  {__LINE__, 0x003702ec,	"3605228", "%5.2d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%7X"},
  {__LINE__, 0x00001778,	"0x1778", "%#5.x"},
  {__LINE__, 0xc52bef7f,	"C52BEF7F", "%X"},
  {__LINE__, 0xfffffec4,	"FFFFFEC4", "%X"},
  {__LINE__, 0x00000006,	"6", "%X"},
  {__LINE__, 0x00000000,	"000", "%03.3x"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xffff6c46,	"FFFF6C46", "% 2.2X"},
  {__LINE__, -0x1506098,	"-22044824", "%01.d"},
  {__LINE__, 0x03415caf,	"3415caf", "%x"},
  {__LINE__, -0x00007b4,	"-1972", "%#4.4d"},
  {__LINE__, -0x00158c9,	"-88265", "%03.4d"},
  {__LINE__, 0x6947c336,	"1766310710", "%.6d"},
  {__LINE__, 0x0000017c,	"17C", "% 0X"},
  {__LINE__, -0x00001b7,	"-439", "% 0ld"},
  {__LINE__, 0x06a7575a,	"6A7575A", "%-.0X"},
  {__LINE__, 0x000b3459,	"734297", "%ld"},
  {__LINE__, -0x395d8dd,	"-60152029", "%ld"},
  {__LINE__, 0x00036bb3,	"224179", "%-6.d"},
  {__LINE__, 0xffff14ff,	"FFFF14FF", "%X"},
  {__LINE__, -0x15910e4f,	"-361827919", "%-0d"},
  {__LINE__, -0x0000004,	"-4", "%#d"},
  {__LINE__, 0xf7f7adac,	"F7F7ADAC", "% 3.X"},
  {__LINE__, 0xffffff74,	"FFFFFF74", "%0X"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, -0x000007b,	"-123   ", "%-7.d"},
  {__LINE__, -0x000002c,	"-44", "%d"},
  {__LINE__, -0x000002b,	"  -43", "%5d"},
  {__LINE__, 0x0000ae5f,	"44639", "%d"},
  {__LINE__, 0x003cbc63,	"3CBC63", "%X"},
  {__LINE__, 0xfffffffc,	"0XFFFFFFFC", "%#5.7X"},
  {__LINE__, 0x0003e044,	"3E044", "%X"},
  {__LINE__, -0x0000c46,	"-3142", "%.1d"},
  {__LINE__, 0xff18f4bb,	"FF18F4BB", "%0X"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%.1X"},
  {__LINE__, -0x01c0f27,	"-1838887", "%0d"},
  {__LINE__, -0x1242901f,	"-306352159", "%.4ld"},
  {__LINE__, 0x1775c10a,	"393593098", "%6.ld"},
  {__LINE__, 0x00000001,	"  1", "%03.d"},
  {__LINE__, 0xfff1fd30,	"0xfff1fd30", "%#x"},
  {__LINE__, 0x00000191,	"191", "%0.X"},
  {__LINE__, 0x2e597178,	"777613688", "%2.ld"},
  {__LINE__, -0x4ef0cf3,	"-82775283", "%+.6ld"},
  {__LINE__, -0x0000085,	"  -133", "%6.d"},
  {__LINE__, 0x0000014d,	"333  ", "%-5ld"},
  {__LINE__, -0xc03bd74,	"-201571700", "%07.6ld"},
  {__LINE__, -0x000000a,	"-10", "%d"},
  {__LINE__, 0x01f5e86e,	"32893038", "%#2.ld"},
  {__LINE__, 0x00000033,	"0X33", "% #X"},
  {__LINE__, 0x0087c797,	" 8898455", "% 7.d"},
  {__LINE__, -0x0001205,	"-4613", "%5d"},
  {__LINE__, 0x00000192,	"    192", "%7.X"},
  {__LINE__, 0x000e6c00,	"945152", "%6.1ld"},
  {__LINE__, 0x00018629,	" 99881", "% d"},
  {__LINE__, -0x04739c6,	"-4667846", "%-01.3ld"},
  {__LINE__, 0x00001f42,	"8002", "%d"},
  {__LINE__, 0x00000caf,	"3247", "%d"},
  {__LINE__, -0x4992e24,	"-77147684", "%#.6d"},
  {__LINE__, 0x0000001d,	"1d", "%-0x"},
  {__LINE__, 0x14d79f03,	"349675267", "%0ld"},
  {__LINE__, 0x00000dd4,	" 03540", "%#6.5ld"},
  {__LINE__, 0x0005f30e,	"0X5F30E", "%#X"},
  {__LINE__, 0x00000157,	"157", "%X"},
  {__LINE__, -0x9281698,	"-153622168", "%d"},
  {__LINE__, -0x000004a,	"-74", "%d"},
  {__LINE__, -0x0010c9e,	"-68766", "%-0d"},
  {__LINE__, 0x00000059,	"00089", "%.5ld"},
  {__LINE__, -0x06959e3,	"-6904291", "% 4.d"},
  {__LINE__, 0xfbea12b1,	"0XFBEA12B1", "%+#X"},
  {__LINE__, 0xffffdfb1,	"FFFFDFB1", "%2.6X"},
  {__LINE__, 0x0434faac,	"434faac", "%.5x"},
  {__LINE__, 0xffffffff,	"ffffffff", "% x"},
  {__LINE__, 0x00000b32,	"B32", "%0X"},
  {__LINE__, 0x00000047,	"71", "%.1d"},
  {__LINE__, 0x00070bef,	" 0461807", "% .7d"},
  {__LINE__, 0x00000038,	"38", "% 0x"},
  {__LINE__, 0x00000000,	"     0", "%6X"},
  {__LINE__, 0xfff9c011,	"FFF9C011", "%2X"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%7x"},
  {__LINE__, 0xfffffff9,	"FFFFFFF9", "%X"},
  {__LINE__, -0x016a095,	"-1482901", "%4.0ld"},
  {__LINE__, -0x000001c,	"-28", "% ld"},
  {__LINE__, 0xfffd6133,	"0xfffd6133", "%#x"},
  {__LINE__, 0x000004a4,	"0x4a4", "%#x"},
  {__LINE__, 0x000003c2,	"0962", "%.4d"},
  {__LINE__, -0x000323b,	"-12859", "%+#d"},
  {__LINE__, 0x0f620237,	"F620237", "%X"},
  {__LINE__, 0x00007863,	"007863", "%.6X"},
  {__LINE__, 0x0000002c,	" 44", "% #ld"},
  {__LINE__, 0xfffffff0,	"fffffff0", "%03.6x"},
  {__LINE__, 0xffff6346,	"FFFF6346", "%1.X"},
  {__LINE__, 0x00063188,	"63188", "% x"},
  {__LINE__, 0xfffff91c,	"fffff91c", "%-.3x"},
  {__LINE__, 0x004cd0b4,	"4CD0B4", "%-2.X"},
  {__LINE__, 0x06b4d739,	"112514873", "%0.1d"},
  {__LINE__, -0x0009beb,	"-39915", "%.2d"},
  {__LINE__, 0x0000831b,	"33563", "%d"},
  {__LINE__, 0x00000001,	"1", "%X"},
  {__LINE__, -0x942d76b,	"-155375467", "% #0ld"},
  {__LINE__, 0xffff2a95,	"FFFF2A95", "%2X"},
  {__LINE__, 0x00548d5e,	"5541214", "%.3ld"},
  {__LINE__, 0x0b5e1a01,	"B5E1A01", "% .7X"},
  {__LINE__, 0xfffffc22,	"fffffc22", "%6x"},
  {__LINE__, -0x0000dd7,	"-3543", "%-.3ld"},
  {__LINE__, 0xfffff834,	"FFFFF834", "%X"},
  {__LINE__, 0x0365f762,	"57014114", "%ld"},
  {__LINE__, -0x0000003,	"-3", "%d"},
  {__LINE__, 0x3bd998a3,	"1004116131", "%d"},
  {__LINE__, 0xfffff6c9,	"FFFFF6C9", "%+X"},
  {__LINE__, 0xffffded9,	"FFFFDED9", "%-.1X"},
  {__LINE__, -0x00fbb5a,	"-1031002", "% 1.0d"},
  {__LINE__, 0xffffffb7,	"ffffffb7", "%6.x"},
  {__LINE__, 0xff1b8ac3,	"FF1B8AC3", "%-X"},
  {__LINE__, 0xfffffff2,	"FFFFFFF2", "%00.X"},
  {__LINE__, -0x000013d,	" -317", "%05.d"},
  {__LINE__, 0x0000f5e2,	"+62946", "%+0.2ld"},
  {__LINE__, 0x16ac6358,	"16ac6358", "%x"},
  {__LINE__, 0xffff8728,	"FFFF8728", "%+X"},
  {__LINE__, -0x0014a6d,	"-084589", "%0.6ld"},
  {__LINE__, 0xfc904514,	"FC904514", "%+0X"},
  {__LINE__, 0x00000004,	"4", "%ld"},
  {__LINE__, 0xffffffe0,	"ffffffe0", "%+x"},
  {__LINE__, -0x0a0ffdd,	"-10551261", "%+02d"},
  {__LINE__, -0x0000bbc,	"-3004", "%+d"},
  {__LINE__, 0x00000006,	"     +6", "%+7ld"},
  {__LINE__, 0x17afa6e5,	"397387493", "%ld"},
  {__LINE__, 0xfffff6bf,	"fffff6bf", "%+04.4x"},
  {__LINE__, 0x000001dc,	"01dc", "% 02.4x"},
  {__LINE__, 0x0000000e,	" 14", "% d"},
  {__LINE__, 0xfffffff9,	"0XFFFFFFF9", "%#4.X"},
  {__LINE__, 0x0000005d,	"93", "%0d"},
  {__LINE__, -0x004fa05,	"-0326149", "%.7d"},
  {__LINE__, -0x0000018,	"-24", "%ld"},
  {__LINE__, 0xfffff7eb,	"FFFFF7EB", "%X"},
  {__LINE__, 0x0072b044,	" 7516228", "% .7ld"},
  {__LINE__, 0xffffffed,	"0xffffffed", "%#x"},
  {__LINE__, 0x0010364d,	"10364D", "%X"},
  {__LINE__, 0xfff90469,	"0XFFF90469", "%#X"},
  {__LINE__, 0x000001b4,	" 436", "% 0d"},
  {__LINE__, 0x00000000,	"0", "% X"},
  {__LINE__, 0xfffffff3,	"fffffff3", "%x"},
  {__LINE__, 0x19335d40,	"19335d40", "%6x"},
  {__LINE__, 0x00039c24,	"236580", "%ld"},
  {__LINE__, 0x000021f7,	"8695", "%0.4ld"},
  {__LINE__, -0x057b406,	"-5747718", "%d"},
  {__LINE__, -0x017b371,	"-1553265", "%#ld"},
  {__LINE__, 0x0003e405,	"254981", "%2.d"},
  {__LINE__, 0x00000001,	"1", "%-.1x"},
  {__LINE__, 0x000000ae,	"AE", "%.1X"},
  {__LINE__, 0xffd85825,	"ffd85825", "%-7.x"},
  {__LINE__, 0xfffad763,	"fffad763", "%x"},
  {__LINE__, 0x002431d4,	"2372052", "%6.ld"},
  {__LINE__, 0x00000003,	"000003", "%-05.6d"},
  {__LINE__, 0xffffffeb,	"0xffffffeb", "%#x"},
  {__LINE__, 0xff8cf3b0,	"ff8cf3b0", "%x"},
  {__LINE__, 0xfe88d2ff,	"0xfe88d2ff", "%+#.2x"},
  {__LINE__, 0xffffff6b,	"ffffff6b", "%6.3x"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%-x"},
  {__LINE__, 0xe998945a,	"e998945a", "%2.x"},
  {__LINE__, 0x03b9c50f,	"3B9C50F", "%+X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%3.7X"},
  {__LINE__, 0x000024ef,	"24ef", "%+x"},
  {__LINE__, 0xfffffc04,	"FFFFFC04", "%X"},
  {__LINE__, 0x0d4bef7c,	" 223080316", "% .1ld"},
  {__LINE__, -0xc33f3bc,	"-204731324", "%.5ld"},
  {__LINE__, 0xffffffff,	"0XFFFFFFFF", "%#2X"},
  {__LINE__, 0x0000e493,	"e493", "%x"},
  {__LINE__, 0x000001b4,	"1b4", "%x"},
  {__LINE__, 0xffffffd6,	"0xffffffd6", "% #1x"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, -0x0000f28,	"-3880", "%ld"},
  {__LINE__, 0x00000277,	"631", "%-1ld"},
  {__LINE__, 0x00000001,	" 1", "%2x"},
  {__LINE__, -0x0ff4d2c,	"-16731436", "%#ld"},
  {__LINE__, 0x0bb80344,	"196608836", "%00ld"},
  {__LINE__, 0xffffffdc,	"FFFFFFDC", "%X"},
  {__LINE__, 0x00000484,	"1156", "%ld"},
  {__LINE__, 0x00000341,	"341", "%-.2x"},
  {__LINE__, 0x0000ee62,	"ee62", "%x"},
  {__LINE__, 0xfffffe20,	"fffffe20", "%+x"},
  {__LINE__, -0x00076eb,	"-30443", "%.2d"},
  {__LINE__, 0x2c4a7407,	"2c4a7407", "% x"},
  {__LINE__, 0x00000000,	"   ", "%3.X"},
  {__LINE__, 0xffffff60,	"ffffff60", "% 4.x"},
  {__LINE__, 0x000e4cf2,	"+937202", "%+.5ld"},
  {__LINE__, 0x00000008,	" 00008", "%06.5X"},
  {__LINE__, 0x0002f612,	"194066", "%d"},
  {__LINE__, 0xfffffc96,	"fffffc96", "%-3.3x"},
  {__LINE__, -0x0000001,	"-1", "% ld"},
  {__LINE__, 0x00000000,	"      ", "% 6.0X"},
  {__LINE__, 0xfffffff5,	"fffffff5", "%3.x"},
  {__LINE__, 0x0bfd63a1,	"201155489", "%d"},
  {__LINE__, -0x1547c214,	"-357024276", "%ld"},
  {__LINE__, 0x00000004,	"4", "%#0.d"},
  {__LINE__, -0x000f2f3,	"-62195", "%.2d"},
  {__LINE__, 0xfff843dd,	"FFF843DD", "%X"},
  {__LINE__, 0x00966e36,	"9858614", "%.0ld"},
  {__LINE__, 0x0000782e,	"0X782E", "% #X"},
  {__LINE__, 0x00bd36c0,	"12400320", "%ld"},
  {__LINE__, 0x00000000,	"00", "% .2X"},
  {__LINE__, 0x00000000,	"0", "%1X"},
  {__LINE__, 0x0003f416,	"3f416 ", "%-6.x"},
  {__LINE__, -0x00b74bd,	"-750781", "% ld"},
  {__LINE__, 0x0000138a,	"138a", "% x"},
  {__LINE__, 0x024df7f0,	"24DF7F0", "% 0.6X"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%X"},
  {__LINE__, -0x0003284,	"-12932 ", "%-07.ld"},
  {__LINE__, 0x000094d3,	"94d3", "%x"},
  {__LINE__, 0x000000bf,	"bf", "%.2x"},
  {__LINE__, 0x00000000,	"00000", "%-1.5X"},
  {__LINE__, -0x04899b8,	"-4757944", "%d"},
  {__LINE__, 0x2b51bf20,	"+726777632", "%+d"},
  {__LINE__, -0x000000d,	"-13", "%.2d"},
  {__LINE__, 0x04f78fbd,	"4F78FBD", "% 7.X"},
  {__LINE__, 0x00011684,	"71300", "%5.d"},
  {__LINE__, 0x0000539d,	"21405", "%0d"},
  {__LINE__, 0x00000008,	"000008", "%-3.6X"},
  {__LINE__, 0xfc7a2cdc,	"fc7a2cdc", "%2.3x"},
  {__LINE__, 0xffc21da1,	"ffc21da1", "%x"},
  {__LINE__, 0x00000273,	"273", "%x"},
  {__LINE__, 0x00000000,	"0", "%#X"},
  {__LINE__, -0x31cd6b9,	"-52221625", "% d"},
  {__LINE__, 0xfffffff8,	"FFFFFFF8", "%.0X"},
  {__LINE__, 0x00000002,	"2", "%#ld"},
  {__LINE__, 0x00e8922c,	"15241772", "%d"},
  {__LINE__, 0xfeb19ea7,	"FEB19EA7", "%0.1X"},
  {__LINE__, 0x00003931,	"014641", "%06ld"},
  {__LINE__, 0x00000015,	"0X00015", "%#.5X"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%1.X"},
  {__LINE__, 0xfff17103,	"0XFFF17103", "% #X"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%+X"},
  {__LINE__, 0x00000002,	"00002", "%.5x"},
  {__LINE__, 0x00001617,	"   5655", "% 7.d"},
  {__LINE__, -0x0000010,	"-000016", "%00.6d"},
  {__LINE__, 0x000000b0,	"B0", "% X"},
  {__LINE__, 0xfc9362b2,	"FC9362B2", "%-X"},
  {__LINE__, 0xfc3d8276,	"fc3d8276", "% 1x"},
  {__LINE__, 0x00001405,	"5125", "%#d"},
  {__LINE__, 0x02250183,	" 35979651", "% ld"},
  {__LINE__, 0xffc9b007,	"ffc9b007", "% 4.x"},
  {__LINE__, 0x00000311,	"785", "%0d"},
  {__LINE__, 0x0004d273,	" 316019", "% d"},
  {__LINE__, 0x00000001,	"1", "%1.x"},
  {__LINE__, 0xffff240f,	"FFFF240F", "%4.X"},
  {__LINE__, 0x0049cfda,	"+4837338", "%+ld"},
  {__LINE__, 0x012f6dd5,	"12F6DD5", "% 6.2X"},
  {__LINE__, 0x00000002,	"0x2", "%#2.0x"},
  {__LINE__, 0xfffd834a,	"FFFD834A", "%.6X"},
  {__LINE__, 0xfe2a40f8,	"0XFE2A40F8", "%#X"},
  {__LINE__, 0xffffffeb,	"ffffffeb", "%x"},
  {__LINE__, -0x00ac5cb,	"-705995", "%d"},
  {__LINE__, -0x3021108c,	"-807473292", "% .4d"},
  {__LINE__, -0x0000035,	"-53", "%-ld"},
  {__LINE__, -0x1a36475,	"-27485301", "% d"},
  {__LINE__, -0x0000011,	"-17", "%d"},
  {__LINE__, 0x000001a3,	"000419", "%.6ld"},
  {__LINE__, 0x0030a0a8,	"3186856", "%.5ld"},
  {__LINE__, 0x00000019,	"25", "%d"},
  {__LINE__, 0xf32deac1,	"F32DEAC1", "%06.2X"},
  {__LINE__, -0x0000004,	" -00004", "%7.5ld"},
  {__LINE__, 0x00000000,	"0", "%ld"},
  {__LINE__, 0x0006bf19,	"442137", "%#0.d"},
  {__LINE__, 0x566f6c44,	"1450142788", "%1.6d"},
  {__LINE__, 0xfffffc10,	"fffffc10", "%.2x"},
  {__LINE__, -0x000e04d,	"-57421", "%+0d"},
  {__LINE__, 0x00000000,	"0000000", "%+.7X"},
  {__LINE__, 0x00b5c74d,	" 11913037", "% ld"},
  {__LINE__, -0x028dfe2,	"-2678754", "%05.1d"},
  {__LINE__, 0xfffffee0,	"fffffee0", "%0x"},
  {__LINE__, -0x030c077,	"-3194999", "%-.6d"},
  {__LINE__, 0x00055ca1,	"055ca1", "%-.6x"},
  {__LINE__, 0x00000000,	"       ", "%7.X"},
  {__LINE__, 0xfffffe3b,	"FFFFFE3B", "%X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "% 3X"},
  {__LINE__, 0x00000857,	"2135", "%-#1.d"},
  {__LINE__, -0x00546a2,	"-345762", "%0.5d"},
  {__LINE__, 0x0000000b,	"0xb   ", "%-#6x"},
  {__LINE__, 0x00000d2b,	"d2b ", "%-4.0x"},
  {__LINE__, 0x0ae02b9e,	"AE02B9E", "%X"},
  {__LINE__, 0xfffffa7b,	"fffffa7b", "%-2.x"},
  {__LINE__, 0x00000001,	"1", "%X"},
  {__LINE__, 0x000006ad,	"01709", "%05.5ld"},
  {__LINE__, -0x0000102,	"-258", "%-0.ld"},
  {__LINE__, 0x00000000,	"0", "%.1X"},
  {__LINE__, -0x01daa95,	"-1944213", "%-1ld"},
  {__LINE__, 0x02b99040,	"2B99040", "%2.X"},
  {__LINE__, 0x1b3d5621,	"1B3D5621", "%X"},
  {__LINE__, 0x0312d16b,	"51564907", "%-1.7ld"},
  {__LINE__, 0x000aa76c,	" 698220", "% 2d"},
  {__LINE__, 0x00000000,	"0", "%ld"},
  {__LINE__, 0xfff8a4ec,	"FFF8A4EC", "%-X"},
  {__LINE__, 0xffffe06d,	"ffffe06d", "%x"},
  {__LINE__, 0x00000003,	"3", "% x"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xd3e244dd,	"D3E244DD", "%+5X"},
  {__LINE__, 0x000028b3,	" 28b3", "% 5.x"},
  {__LINE__, 0x0001aceb,	"109803", "%6d"},
  {__LINE__, 0xfffbc5ca,	"0xfffbc5ca", "%-#5x"},
  {__LINE__, 0x00000097,	"    151", "% 7ld"},
  {__LINE__, 0x00001fcc,	"+8140", "%+d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%0x"},
  {__LINE__, -0x00052a9,	"-21161", "%ld"},
  {__LINE__, 0xfffffc76,	"FFFFFC76", "%.1X"},
  {__LINE__, -0x2acb012,	"-44871698", "%0.1ld"},
  {__LINE__, 0xffffff81,	"ffffff81", "%x"},
  {__LINE__, -0x0018394,	"-99220", "%-ld"},
  {__LINE__, 0x0000001b,	"1B", "%X"},
  {__LINE__, 0x00000033,	"51", "%1d"},
  {__LINE__, 0xffec37e5,	"FFEC37E5", "%-1X"},
  {__LINE__, -0x000000a,	"  -10", "%#5.d"},
  {__LINE__, -0x0000412,	"-1042", "%ld"},
  {__LINE__, 0x000cd0b1,	"cd0b1  ", "%-7.5x"},
  {__LINE__, 0x0b445370,	"B445370", "%+2.0X"},
  {__LINE__, 0xfffffff3,	"0XFFFFFFF3", "%-#X"},
  {__LINE__, 0xffff9f33,	"FFFF9F33", "%5.X"},
  {__LINE__, 0x00010a1e,	"10A1E", "%-2X"},
  {__LINE__, -0xede156f,	"-249435503", "% 7.1ld"},
  {__LINE__, 0xfc6d63aa,	"fc6d63aa", "% .6x"},
  {__LINE__, 0x0000311c,	" 12572", "% ld"},
  {__LINE__, 0x00001f8a,	"8074", "%00.d"},
  {__LINE__, 0x00000199,	"199", "%-X"},
  {__LINE__, 0xfffffc60,	"FFFFFC60", "%+3X"},
  {__LINE__, -0x000022c,	"-556", "%+0ld"},
  {__LINE__, 0x021d8407,	"35488775", "%-#.7ld"},
  {__LINE__, 0x0000020f,	"527", "%d"},
  {__LINE__, -0x000064b,	"-1611", "%#ld"},
  {__LINE__, -0x0c15aef,	"-12671727", "%d"},
  {__LINE__, -0x1f1a6881,	"-521824385", "%ld"},
  {__LINE__, 0xffffc115,	"ffffc115", "% x"},
  {__LINE__, 0x00000017,	" 23", "% #ld"},
  {__LINE__, 0x00000dc1,	"DC1 ", "%-4X"},
  {__LINE__, 0x000002ca,	"2CA", "%X"},
  {__LINE__, 0x000f052c,	" 984364", "%7.d"},
  {__LINE__, 0x0000005a,	"0090", "%0.4d"},
  {__LINE__, -0x001e463,	"-124003", "% 4.ld"},
  {__LINE__, 0x00000001,	"0000001", "%+.7X"},
  {__LINE__, 0x00000bfb,	"0000bfb", "%5.7x"},
  {__LINE__, 0x0002484b,	"149579", "%#1d"},
  {__LINE__, 0x0043ba18,	"4438552", "%-ld"},
  {__LINE__, 0x000078f8,	"0X78F8", "%#X"},
  {__LINE__, 0x00000001,	"   1", "%4d"},
  {__LINE__, 0x0cedaeed,	"CEDAEED", "%X"},
  {__LINE__, 0x00000003,	"+3", "%+ld"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "%7.4X"},
  {__LINE__, 0x00000169,	"361", "%ld"},
  {__LINE__, 0x00003c7a,	"+15482", "%+ld"},
  {__LINE__, -0x0159d93,	"-1416595", "% 0.0d"},
  {__LINE__, 0x0000775c,	"+30556", "%+3.d"},
  {__LINE__, 0x10284768,	"+271075176", "%+0.0ld"},
  {__LINE__, -0xf8b610e,	"-260792590", "%0d"},
  {__LINE__, 0xfdd8d369,	"fdd8d369", "%-.3x"},
  {__LINE__, 0x000c9495,	"+824469", "%+ld"},
  {__LINE__, -0x000003f,	"   -063", "%7.3d"},
  {__LINE__, -0x000073b,	"-1851", "%+03.ld"},
  {__LINE__, 0xfffe4e23,	"0xfffe4e23", "%#.5x"},
  {__LINE__, 0x0081788c,	"81788c", "%5x"},
  {__LINE__, -0x015f888,	"-1439880", "%+1d"},
  {__LINE__, -0x31d64b4,	"-52257972", "%0.2d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%6.5X"},
  {__LINE__, -0x0000072,	"-114", "%+.1d"},
  {__LINE__, -0x00000e1,	"-225", "%ld"},
  {__LINE__, 0x000006a8,	"0x6a8", "%+#x"},
  {__LINE__, 0xfffe673a,	"fffe673a", "%01.x"},
  {__LINE__, 0xfff2ee0d,	"FFF2EE0D", "%-X"},
  {__LINE__, 0x0290320a,	"43004426", "%0ld"},
  {__LINE__, -0xeb7a832,	"-246917170", "% ld"},
  {__LINE__, 0x02ae9265,	"2ae9265", "%1.x"},
  {__LINE__, 0xffffffd2,	"ffffffd2", "%+2.x"},
  {__LINE__, 0x00e6e858,	"0xe6e858", "%#0.x"},
  {__LINE__, 0x00000c4a,	"+3146", "%+3.1d"},
  {__LINE__, -0x6943c1a,	"-110378010", "% 0ld"},
  {__LINE__, 0x0167b119,	"167b119", "%0x"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%+x"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%X"},
  {__LINE__, 0x000b861e,	"755230", "%ld"},
  {__LINE__, 0x0000015b,	"347", "%-#ld"},
  {__LINE__, 0xfffffffa,	"0XFFFFFFFA", "%#X"},
  {__LINE__, 0x000de9e5,	"911845", "%d"},
  {__LINE__, 0x00000001,	"01", "%.2d"},
  {__LINE__, 0x000007a5,	"1957", "%0d"},
  {__LINE__, 0x0000000f,	"f", "%x"},
  {__LINE__, 0x00c38cbf,	" 12815551", "% .2d"},
  {__LINE__, -0x7bd1b6e,	"-129833838", "% d"},
  {__LINE__, -0x000013c,	"-316", "%0d"},
  {__LINE__, 0x00001aad,	"1AAD", "%-0X"},
  {__LINE__, 0x0034f903,	"3471619", "%00d"},
  {__LINE__, 0xff925717,	"ff925717", "%4x"},
  {__LINE__, 0x00000002,	"02", "%.2d"},
  {__LINE__, 0x00000f34,	"F34", "%+X"},
  {__LINE__, 0xffffeefe,	"FFFFEEFE", "%X"},
  {__LINE__, 0xfffeecb4,	"FFFEECB4", "% 2.X"},
  {__LINE__, 0x00034421,	"214049", "%0ld"},
  {__LINE__, 0x00000000,	"     0", "%+6X"},
  {__LINE__, -0x0000062,	"-98", "%-#2d"},
  {__LINE__, -0x0000557,	"-1367", "%-4.4d"},
  {__LINE__, 0xffffe17c,	"FFFFE17C", "%X"},
  {__LINE__, 0x00000097,	"00097", "%.5X"},
  {__LINE__, 0xfffcb278,	"FFFCB278", "%0.7X"},
  {__LINE__, -0x0000001,	"-0001  ", "%-7.4d"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, 0x000002c4,	"708", "%d"},
  {__LINE__, 0x04946f45,	"4946F45", "%-2.X"},
  {__LINE__, 0x000000ff,	"00ff", "% 2.4x"},
  {__LINE__, 0x00073307,	"471815", "%3ld"},
  {__LINE__, 0x0085b7b6,	"+8763318", "%+ld"},
  {__LINE__, -0x0000002,	"-2", "%1ld"},
  {__LINE__, -0x0000001,	"-1", "%-2d"},
  {__LINE__, -0x00000b5,	"   -181", "%7ld"},
  {__LINE__, -0x0412486,	"-4269190", "%+2.1ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%0x"},
  {__LINE__, 0x0000006d,	"6d", "%x"},
  {__LINE__, 0x000000da,	"218", "%-.3ld"},
  {__LINE__, 0xfffffcfe,	"fffffcfe", "%x"},
  {__LINE__, 0x652e60c7,	"652E60C7", "%7.7X"},
  {__LINE__, 0x00000035,	" 53", "% #2d"},
  {__LINE__, 0x000000fc,	"FC", "%-X"},
  {__LINE__, 0x00000019,	" 25", "% ld"},
  {__LINE__, 0xfffffcf4,	"fffffcf4", "%6x"},
  {__LINE__, 0xffffff41,	"ffffff41", "%x"},
  {__LINE__, 0x00000034,	" 52", "%3.ld"},
  {__LINE__, 0xffffffb2,	"ffffffb2", "%-x"},
  {__LINE__, -0x6dc43e7c,	"-1841577596", "% .2ld"},
  {__LINE__, 0x00000004,	"4", "%d"},
  {__LINE__, -0x000023b,	"-571", "%ld"},
  {__LINE__, -0x000004d,	"-77", "%ld"},
  {__LINE__, 0x0000e3ba,	"58298", "%.0ld"},
  {__LINE__, 0xfffffff2,	"fffffff2", "%0.0x"},
  {__LINE__, -0x0000020,	"-32", "%ld"},
  {__LINE__, 0xffffb33e,	"0XFFFFB33E", "%-#X"},
  {__LINE__, 0x00000000,	"    ", "% 4.x"},
  {__LINE__, 0xffd96f92,	"FFD96F92", "%X"},
  {__LINE__, 0x0000002e,	" 46", "% 0ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, -0x5008ba3,	"-83921827", "%+d"},
  {__LINE__, 0xfdc1df3d,	"FDC1DF3D", "%0X"},
  {__LINE__, 0xfc7410e5,	"fc7410e5", "%7x"},
  {__LINE__, 0xfffffffa,	"FFFFFFFA", "% 6.X"},
  {__LINE__, 0x00000000,	"0", "%X"},
  {__LINE__, -0x040fd4e,	"-4259150", "% 05.d"},
  {__LINE__, 0x0000003b,	" 59", "%3.2d"},
  {__LINE__, 0xff776dd8,	"ff776dd8", "%x"},
  {__LINE__, 0x0000055b,	"+1371", "%+#2d"},
  {__LINE__, 0x00004841,	"4841", "%.1x"},
  {__LINE__, 0x0229d710,	"36296464", "%-.2ld"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xfffe8376,	"fffe8376", "%0x"},
  {__LINE__, 0x000a7b83,	"a7b83", "%x"},
  {__LINE__, 0x0000000d,	"    013", "%#7.3d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%5.0X"},
  {__LINE__, 0x00000704,	"  0x704", "%#7.0x"},
  {__LINE__, 0xfff970b9,	"FFF970B9", "%.1X"},
  {__LINE__, -0x000b60a,	"-46602", "%+d"},
  {__LINE__, 0x00000000,	" 00000", "%6.5x"},
  {__LINE__, 0x00000003,	"3", "%X"},
  {__LINE__, 0x0000c14b,	"c14b", "%0x"},
  {__LINE__, 0x066d7860,	"107837536", "%-d"},
  {__LINE__, 0x00000013,	"  13", "%4.x"},
  {__LINE__, 0xfff96f18,	"FFF96F18", "%4X"},
  {__LINE__, 0xffffff30,	"FFFFFF30", "%X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "% .7X"},
  {__LINE__, -0x72a9e985,	"-1923737989", "%2.d"},
  {__LINE__, 0x00000002,	"0x2", "%#x"},
  {__LINE__, 0x0000050e,	"50e", "%2.3x"},
  {__LINE__, 0x0000605c,	"24668", "%4.1d"},
  {__LINE__, 0xffffff3e,	"ffffff3e", "%x"},
  {__LINE__, -0x0000010,	"-16", "%-2d"},
  {__LINE__, 0x000061aa,	"61AA", "%X"},
  {__LINE__, 0x000c2ec3,	"C2EC3", "%0X"},
  {__LINE__, -0x0000001,	"-1", "%-0d"},
  {__LINE__, 0x00130e17,	"+1248791", "%+.6ld"},
  {__LINE__, 0x000000ef,	"EF", "%-X"},
  {__LINE__, -0x0000001,	"   -1", "%+5ld"},
  {__LINE__, 0x0000989d,	"39069", "%d"},
  {__LINE__, 0x00000000,	"0", "%-x"},
  {__LINE__, 0x00000417,	"417", "%X"},
  {__LINE__, 0x00005e86,	"5E86", "%+X"},
  {__LINE__, -0x0007c08,	"-31752", "%ld"},
  {__LINE__, 0x00da8e0f,	"DA8E0F", "%2.2X"},
  {__LINE__, -0x3ee095ec,	"-1054905836", "% 0d"},
  {__LINE__, 0xfffdb5a3,	"fffdb5a3", "%x"},
  {__LINE__, 0xffffff83,	"FFFFFF83", "%X"},
  {__LINE__, 0xfff8efd7,	"0xfff8efd7", "%#x"},
  {__LINE__, 0x00000020,	" 32", "% d"},
  {__LINE__, 0xfff7c002,	"fff7c002", "%.7x"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, 0x00000000,	"  000", "%05.3X"},
  {__LINE__, 0xfff190ee,	"FFF190EE", "%X"},
  {__LINE__, 0x00000a6c,	"  2668", "%#6.ld"},
  {__LINE__, 0x00037024,	"37024", "%x"},
  {__LINE__, 0xfffec37f,	"FFFEC37F", "%X"},
  {__LINE__, 0x007ee9bb,	"8317371", "%#0.ld"},
  {__LINE__, 0x00000122,	"290", "%ld"},
  {__LINE__, -0x0013b5f,	"-80735", "%ld"},
  {__LINE__, 0xfffffff6,	"FFFFFFF6", "%X"},
  {__LINE__, -0x0000c16,	"-0003094", "%-00.7d"},
  {__LINE__, -0x00010ed,	"-4333", "%ld"},
  {__LINE__, 0x00000007,	" 0X007", "%#6.3X"},
  {__LINE__, 0x0053781e,	" 5470238", "% 2d"},
  {__LINE__, 0xffff03e9,	"0XFFFF03E9", "%+#7.3X"},
  {__LINE__, 0xfffffdc2,	"0xfffffdc2", "% #4.x"},
  {__LINE__, -0x00018e1,	"-6369", "%d"},
  {__LINE__, 0xf3a4abc6,	"F3A4ABC6", "%-.2X"},
  {__LINE__, 0xfff64a27,	"FFF64A27", "%7.7X"},
  {__LINE__, 0x00195ae5,	"195AE5", "%+03.X"},
  {__LINE__, 0xfff8849a,	"fff8849a", "%.1x"},
  {__LINE__, -0x001b045,	"-110661", "%+ld"},
  {__LINE__, 0x01e8a106,	"32022790", "%7.ld"},
  {__LINE__, 0x0008ee94,	"8EE94", "%X"},
  {__LINE__, 0xfffcdabc,	"FFFCDABC", "%X"},
  {__LINE__, 0xfda75cd2,	"fda75cd2", "%x"},
  {__LINE__, 0x00fd505a,	"fd505a", "%x"},
  {__LINE__, 0x00003748,	"3748", "%+x"},
  {__LINE__, 0xffffffe5,	"ffffffe5", "% 3.6x"},
  {__LINE__, -0x1d1c4045,	"-488390725", "%d"},
  {__LINE__, 0xfffffff9,	"0xfffffff9", "%#x"},
  {__LINE__, -0x0000001,	"-1", "%-#ld"},
  {__LINE__, 0x00000191,	"191", "%X"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%-X"},
  {__LINE__, -0x0000006,	"-6", "%ld"},
  {__LINE__, 0x00000033,	"  33", "% 4x"},
  {__LINE__, -0x0159a14,	"-1415700", "% ld"},
  {__LINE__, 0x000001c3,	"00001c3", "%07x"},
  {__LINE__, 0xffffe9e2,	"ffffe9e2", "%-x"},
  {__LINE__, 0x5b19abd9,	"0x5b19abd9", "%-#x"},
  {__LINE__, 0xffff1bae,	"0xffff1bae", "%#x"},
  {__LINE__, 0x00000001,	"+1", "%+d"},
  {__LINE__, 0x006a23c7,	"6A23C7", "%2.X"},
  {__LINE__, 0x000008a4,	" 8a4", "% 4.1x"},
  {__LINE__, 0xfffffcd9,	"fffffcd9", "%.1x"},
  {__LINE__, 0x0000121b,	"121B", "%X"},
  {__LINE__, 0x001231aa,	"1192362", "%7.d"},
  {__LINE__, -0x008026d,	"-524909", "%4.2d"},
  {__LINE__, 0x192ea594,	"422487444", "%ld"},
  {__LINE__, 0x0001a800,	"108544", "%0d"},
  {__LINE__, 0x000062f1,	"62f1", "%.4x"},
  {__LINE__, 0xff8b39b0,	"ff8b39b0", "% x"},
  {__LINE__, 0x00000001,	"0x1", "%+#x"},
  {__LINE__, 0x0000144a,	"5194", "%ld"},
  {__LINE__, 0x00002599,	"9625", "%d"},
  {__LINE__, 0xffa0a2ef,	"ffa0a2ef", "%0x"},
  {__LINE__, 0xff6712e1,	"FF6712E1", "%0X"},
  {__LINE__, 0x0007ebb3,	"519091", "%1ld"},
  {__LINE__, 0x0000000f,	"15  ", "%-4.ld"},
  {__LINE__, -0x0000096,	"-150", "%2.ld"},
  {__LINE__, 0x0000004f,	"4F", "%.2X"},
  {__LINE__, 0xfffffc29,	"fffffc29", "%-4.x"},
  {__LINE__, 0x00000019,	"19", "%x"},
  {__LINE__, 0x00000c4e,	"c4e", "%x"},
  {__LINE__, 0x0000006b,	" 0006B", "%6.5X"},
  {__LINE__, 0x00c8d2c6,	"c8d2c6", "%.0x"},
  {__LINE__, -0x256fb8de,	"-628078814", "%ld"},
  {__LINE__, 0x4f51fcf4,	"4F51FCF4", "%+X"},
  {__LINE__, 0x000f000e,	"983054", "%1.ld"},
  {__LINE__, 0xfffff03f,	"fffff03f", "%x"},
  {__LINE__, 0x0000001d,	"   1D", "%05.X"},
  {__LINE__, 0x0072ea14,	"72ea14", "%x"},
  {__LINE__, -0xc6098b9,	"-207657145", "%-7d"},
  {__LINE__, 0x00000a76,	"2678", "%3ld"},
  {__LINE__, 0xfff84db3,	"FFF84DB3", "%X"},
  {__LINE__, 0x0fb52870,	"fb52870", "%+x"},
  {__LINE__, 0x08bc170a,	"0x8bc170a", "%#x"},
  {__LINE__, 0xfffeeb00,	"fffeeb00", "%0.5x"},
  {__LINE__, 0x000ece95,	"970389", "%d"},
  {__LINE__, 0x00000000,	"0", "%0X"},
  {__LINE__, 0x07f98e8a,	"7f98e8a", "% x"},
  {__LINE__, 0x000499eb,	" 499eb", "% 6.x"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%-X"},
  {__LINE__, 0x0aa45e86,	"178544262", "%#.2d"},
  {__LINE__, 0xff73387d,	"FF73387D", "%03.X"},
  {__LINE__, 0xfffffb51,	"FFFFFB51", "%.3X"},
  {__LINE__, 0xffffffdc,	"ffffffdc", "%6.x"},
  {__LINE__, 0xffffffed,	"FFFFFFED", "%-X"},
  {__LINE__, 0x0001c4c2,	"1c4c2", "%0.3x"},
  {__LINE__, -0x0000001,	"-0000001", "%-#.7d"},
  {__LINE__, 0x00000007,	"7", "%0.x"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, 0xffffd000,	"ffffd000", "%4.3x"},
  {__LINE__, 0x00000030,	"48", "%2.d"},
  {__LINE__, -0x6c121ce,	"-113320398", "%.5ld"},
  {__LINE__, 0x000001ed,	"1ED", "% 3.X"},
  {__LINE__, 0xfffff0f3,	"FFFFF0F3", "%+.6X"},
  {__LINE__, 0xffffffec,	"ffffffec", "%x"},
  {__LINE__, 0x002d5ab8,	"0x2d5ab8", "%-#x"},
  {__LINE__, 0x0026acff,	"2534655", "%0ld"},
  {__LINE__, 0x01d90cd7,	"+31001815", "%+.2ld"},
  {__LINE__, -0x1f7abc0,	"-33008576", "%7.6d"},
  {__LINE__, 0xfc5babcc,	"fc5babcc", "%x"},
  {__LINE__, -0x9b74892,	"-163006610", "% .6d"},
  {__LINE__, 0x03931d84,	"59972996", "%0.d"},
  {__LINE__, 0x07d261ce,	"131228110", "%#ld"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0x00000002,	"2", "%+X"},
  {__LINE__, -0x0000604,	"-1540", "%+d"},
  {__LINE__, 0x00000000,	"       ", "%7.x"},
  {__LINE__, 0x00000001,	"1", "%.0X"},
  {__LINE__, -0x0005a8e,	"-23182", "% d"},
  {__LINE__, 0x03fb2730,	"3fb2730", "%7.x"},
  {__LINE__, 0xffffff03,	"ffffff03", "%x"},
  {__LINE__, 0x00000000,	"   ", "%-#3.d"},
  {__LINE__, 0x04025a4b,	"0X4025A4B", "%+#X"},
  {__LINE__, -0x0000001,	"  -1", "%4.d"},
  {__LINE__, 0xfffe00a3,	"FFFE00A3", "%+X"},
  {__LINE__, -0x1b26e3c8,	"-455533512", "% ld"},
  {__LINE__, 0x000017e5,	"6117", "%d"},
  {__LINE__, -0x0e4f3b6,	"-15004598", "%0ld"},
  {__LINE__, 0x00000034,	"52", "%ld"},
  {__LINE__, 0x0000024c,	" 24C", "%4X"},
  {__LINE__, 0xfffedf65,	"FFFEDF65", "%-0X"},
  {__LINE__, -0x000ff1f,	"-65311", "%+#d"},
  {__LINE__, 0x00000007,	"      7", "%7.x"},
  {__LINE__, 0x018656ae,	"18656ae", "%3.7x"},
  {__LINE__, -0x0000004,	"-4", "%d"},
  {__LINE__, 0x7081292d,	"1887512877", "%d"},
  {__LINE__, 0x87d3e48c,	"87d3e48c", "%-x"},
  {__LINE__, 0xf99c516e,	"0xf99c516e", "% #7.4x"},
  {__LINE__, 0xfffffffa,	"FFFFFFFA", "%-1X"},
  {__LINE__, -0x000001d,	"-29", "%#ld"},
  {__LINE__, -0x0000001,	"-1", "%+ld"},
  {__LINE__, 0x28ab3350,	" 682308432", "% 1d"},
  {__LINE__, -0x0000006,	"-6", "%ld"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "%.5X"},
  {__LINE__, -0x0000007,	"-7", "%#d"},
  {__LINE__, -0x0000328,	"  -808", "%6.ld"},
  {__LINE__, -0x29386f00,	"-691564288", "%.3d"},
  {__LINE__, -0x059f38a,	"-5895050", "%.4ld"},
  {__LINE__, 0xfffff888,	"FFFFF888", "%3X"},
  {__LINE__, 0xffffffdf,	"ffffffdf", "%0.0x"},
  {__LINE__, -0xb4fc354,	"-189776724", "%2d"},
  {__LINE__, 0x00058c07,	"363527", "%1.d"},
  {__LINE__, 0x0a256162,	"a256162", "%x"},
  {__LINE__, -0x05c87b0,	"-6064048", "%0ld"},
  {__LINE__, 0xfffffda1,	"fffffda1", "%x"},
  {__LINE__, 0x000034b7,	"13495", "%d"},
  {__LINE__, -0x6d1a8918,	"-1830455576", "%.1d"},
  {__LINE__, 0x00022290,	"139920", "%05ld"},
  {__LINE__, 0x00000000,	"0", "%-x"},
  {__LINE__, -0x1f8eafce,	"-529444814", "%4.d"},
  {__LINE__, -0x7bf32808,	"-2079533064", "% ld"},
  {__LINE__, 0x0000023c,	"23c", "% x"},
  {__LINE__, 0x00000039,	"39", "%X"},
  {__LINE__, -0x000556d,	"-21869", "%ld"},
  {__LINE__, -0x00000ca,	"-202", "%ld"},
  {__LINE__, 0x00002e28,	"11816", "%-d"},
  {__LINE__, 0x00000011,	"17", "%-ld"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "%-X"},
  {__LINE__, 0xfffdd67f,	"0XFFFDD67F", "%#X"},
  {__LINE__, -0x000003d,	"-61", "%d"},
  {__LINE__, 0x0000bfce,	"0XBFCE", "%-#5.2X"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%x"},
  {__LINE__, -0x00aea17,	"-715287", "%.5d"},
  {__LINE__, -0x02fce89,	"-3133065", "%0d"},
  {__LINE__, 0x007f6ed1,	"7F6ED1", "%6X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%X"},
  {__LINE__, -0x0002761,	"-10081", "%#6.2d"},
  {__LINE__, 0x003be8d8,	"3BE8D8", "%-X"},
  {__LINE__, 0x00000901,	"  2305", "%6.d"},
  {__LINE__, 0x00049916,	"0301334", "%3.7ld"},
  {__LINE__, 0x0678ffea,	"0X678FFEA", "%#4X"},
  {__LINE__, 0xffffffff,	"ffffffff", "%+.0x"},
  {__LINE__, -0x31d2ec61,	"-835906657", "%.0d"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%0X"},
  {__LINE__, -0x0015588,	"-87432", "%d"},
  {__LINE__, 0xffffff3e,	"ffffff3e", "%.4x"},
  {__LINE__, 0x0000000a,	"10", "%d"},
  {__LINE__, -0x0000003,	"-3", "%2.1ld"},
  {__LINE__, -0x000d29a,	"-53914", "%ld"},
  {__LINE__, -0x04ccbe0,	"-5032928", "%2.2ld"},
  {__LINE__, 0x0357c2a5,	"357c2a5", "% 7.x"},
  {__LINE__, 0x00000009,	" 9", "% 1.ld"},
  {__LINE__, -0x005908d,	"-364685", "%0d"},
  {__LINE__, -0x0000de6,	"-3558", "%0ld"},
  {__LINE__, 0x2d395e6b,	"+758734443", "%+6d"},
  {__LINE__, 0x001aba58,	"1ABA58", "% X"},
  {__LINE__, 0x0ceba5ab,	"0XCEBA5AB", "%#.1X"},
  {__LINE__, -0x01a8575,	"-1738101", "% 2ld"},
  {__LINE__, 0x0000000d,	"13", "%#ld"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, 0x4b856407,	"4b856407", "%5x"},
  {__LINE__, 0x006f333c,	"6F333C", "%-X"},
  {__LINE__, 0x000000d0,	"d0", "%x"},
  {__LINE__, 0x2ecf0d4e,	"2ecf0d4e", "%0x"},
  {__LINE__, -0x0000188,	"-0000392", "%#1.7ld"},
  {__LINE__, -0x0000037,	"-55", "%d"},
  {__LINE__, 0xfffffff1,	"FFFFFFF1", "% .1X"},
  {__LINE__, 0x00000001,	"0x1", "%#3x"},
  {__LINE__, 0x000005ed,	"5ED", "%3X"},
  {__LINE__, 0x031183a3,	"31183A3", "%X"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, -0x0018695,	"-99989", "%-0.5ld"},
  {__LINE__, -0x0000001,	"-01", "%0.2ld"},
  {__LINE__, 0x00007822,	"7822", "%+x"},
  {__LINE__, 0x00000000,	"0", "% x"},
  {__LINE__, 0xfda2461a,	"FDA2461A", "%X"},
  {__LINE__, 0x065c50ef,	"106713327", "%2.ld"},
  {__LINE__, 0x00000a81,	"a81", "% 0x"},
  {__LINE__, -0x000022e,	"-558", "%.0ld"},
  {__LINE__, 0x00013d2f,	"81199", "%.2ld"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%+X"},
  {__LINE__, 0x000015f9,	"5625", "%04.ld"},
  {__LINE__, 0x0ab575a2,	"179664290", "%0d"},
  {__LINE__, 0x0024d07f,	"0X24D07F", "%#X"},
  {__LINE__, 0x07ee35e1,	"7EE35E1", "%+X"},
  {__LINE__, -0x00c114c,	"-790860", "%#ld"},
  {__LINE__, 0x00003be3,	"  15331", "%07.d"},
  {__LINE__, 0xfff87570,	"FFF87570", "%4.0X"},
  {__LINE__, -0x14eab419,	"-350925849", "%-ld"},
  {__LINE__, -0x000001b,	"-27", "%ld"},
  {__LINE__, 0x167ce2ea,	"0x167ce2ea", "%#0.x"},
  {__LINE__, -0x00009bc,	"-002492", "% 3.6d"},
  {__LINE__, 0xfffffdb9,	"0XFFFFFDB9", "%#7.X"},
  {__LINE__, 0x008b2b9d,	"8B2B9D", "% X"},
  {__LINE__, 0x000cfec3,	"CFEC3", "% 05X"},
  {__LINE__, 0x05970be6,	"5970be6", "%x"},
  {__LINE__, 0x00002780,	"010112", "%2.6d"},
  {__LINE__, 0x00000005,	"+5", "%+d"},
  {__LINE__, 0xfffffffb,	"0xfffffffb", "%#3.x"},
  {__LINE__, 0x00000001,	"1    ", "%-#5.ld"},
  {__LINE__, -0x0000017,	"-23", "%ld"},
  {__LINE__, -0x023b943,	"-2341187", "%d"},
  {__LINE__, 0x0000000d,	"13", "%ld"},
  {__LINE__, 0x00025a03,	"25a03", "% .5x"},
  {__LINE__, 0x3e1ebe24,	"3e1ebe24", "% x"},
  {__LINE__, 0x0000013a,	"0x13a", "%#5.0x"},
  {__LINE__, 0xfff6f5b3,	"FFF6F5B3", "%4.X"},
  {__LINE__, -0x0000a8a,	"-2698", "%.3d"},
  {__LINE__, 0x0009dd5f,	"9dd5f", "%x"},
  {__LINE__, 0x000003c7,	" 3C7", "%04.2X"},
  {__LINE__, 0x1bcfa2f2,	"1bcfa2f2", "%+1.x"},
  {__LINE__, 0x0001b4f4,	"1b4f4", "%+1.x"},
  {__LINE__, 0x1bc19a90,	"465672848", "%#d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%+06x"},
  {__LINE__, -0x0000a88,	"-2696", "%3.d"},
  {__LINE__, 0x00084a19,	"84A19", "%-X"},
  {__LINE__, 0xffe1fc8f,	"FFE1FC8F", "%0.1X"},
  {__LINE__, -0x0000a3a,	"-2618", "%5d"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, -0x5c6183d,	"-96868413", "%+ld"},
  {__LINE__, -0x0000001,	"-1", "%-d"},
  {__LINE__, 0x0000faa8,	"64168", "%05.d"},
  {__LINE__, 0x003913ef,	"3740655", "%ld"},
  {__LINE__, 0x0dde330a,	"232665866", "%#ld"},
  {__LINE__, 0xfcfb1a7b,	"FCFB1A7B", "%+X"},
  {__LINE__, 0x07b1a81f,	" 129083423", "% 0d"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, 0x00000070,	"  112", "%5ld"},
  {__LINE__, 0xffff74d9,	"ffff74d9", "%x"},
  {__LINE__, -0x001ab93,	"-109459", "%03.d"},
  {__LINE__, 0x0eb6b497,	"EB6B497", "%+X"},
  {__LINE__, 0x07adbac2,	"128826050", "%#0.4d"},
  {__LINE__, 0xff747068,	"FF747068", "%6.X"},
  {__LINE__, -0x190ce98f,	"-420276623", "%06.6ld"},
  {__LINE__, -0x0000007,	"-7", "%.0d"},
  {__LINE__, 0x0001240f,	"1240f", "% 3x"},
  {__LINE__, 0x267ae4a0,	"645588128", "%-#ld"},
  {__LINE__, -0x0000001,	"-1", "% ld"},
  {__LINE__, -0x0000066,	"-00102", "%.5ld"},
  {__LINE__, 0x868fa035,	"868fa035", "%x"},
  {__LINE__, 0x00000000,	"    ", "%-4.ld"},
  {__LINE__, 0xfffffe72,	"FFFFFE72", "%4.4X"},
  {__LINE__, 0x00a6b4f4,	"10925300", "%#ld"},
  {__LINE__, -0x0000002,	"-2", "%00.1d"},
  {__LINE__, -0x00000a3,	"-163", "%ld"},
  {__LINE__, 0xfffffffe,	"fffffffe", "% 3.x"},
  {__LINE__, 0xffe25941,	"ffe25941", "% x"},
  {__LINE__, 0x0000a20f,	"41487", "%ld"},
  {__LINE__, -0x000009b,	"-155", "%#.3ld"},
  {__LINE__, 0x000c5dc1,	"810433", "%4.ld"},
  {__LINE__, 0x00003ec4,	"16068", "%ld"},
  {__LINE__, 0x000002f3,	"0755", "%04ld"},
  {__LINE__, 0xffffff28,	"FFFFFF28", "%.5X"},
  {__LINE__, -0x08450ff,	"-8671487", "%-3.0ld"},
  {__LINE__, 0x00000092,	"92", "%x"},
  {__LINE__, -0x0000317,	"-791", "%d"},
  {__LINE__, 0x0000000d,	"d", "%x"},
  {__LINE__, 0x00000036,	"36", "%x"},
  {__LINE__, -0x112693f,	"-17983807", "%ld"},
  {__LINE__, 0x00004226,	"16934", "%0.d"},
  {__LINE__, 0x000001ba,	" 442", "% ld"},
  {__LINE__, 0xfffffffc,	"0XFFFFFFFC", "%#4X"},
  {__LINE__, 0xffdb3d23,	"0xffdb3d23", "% #x"},
  {__LINE__, 0x039eb84d,	"39EB84D", "%+.6X"},
  {__LINE__, 0xffffc7da,	"ffffc7da", "%0x"},
  {__LINE__, 0xfffffdb6,	"FFFFFDB6", "%6X"},
  {__LINE__, 0x001b75b0,	"1799600", "%ld"},
  {__LINE__, 0xfffffca2,	"FFFFFCA2", "%-X"},
  {__LINE__, 0xffffffba,	"ffffffba", "%7.4x"},
  {__LINE__, -0x000124e,	"-4686", "%3.ld"},
  {__LINE__, -0x000bec0,	"-48832", "% 0d"},
  {__LINE__, 0xfffffca0,	"fffffca0", "%2.x"},
  {__LINE__, 0x00b2a462,	"11707490", "%ld"},
  {__LINE__, 0x0745a647,	"745a647", "%+4.x"},
  {__LINE__, 0xfffffbac,	"0XFFFFFBAC", "%#3.X"},
  {__LINE__, -0x0000002,	"-2", "%-0.1d"},
  {__LINE__, 0x0006cfdb,	"446427", "%#5.d"},
  {__LINE__, -0x0000001,	"-1", "%d"},
  {__LINE__, 0x043b134e,	"43B134E", "%X"},
  {__LINE__, -0x0000015,	"-21", "%ld"},
  {__LINE__, -0x0000114,	"-276", "%0d"},
  {__LINE__, -0x0004d4a,	"-19786", "%-d"},
  {__LINE__, -0x000001c,	"-28", "%ld"},
  {__LINE__, -0x0cb89fc,	"-13339132", "%ld"},
  {__LINE__, 0xffffffcf,	"ffffffcf", "%x"},
  {__LINE__, 0xf6d2387a,	"f6d2387a", "%-x"},
  {__LINE__, -0x00000cd,	"-205", "%#ld"},
  {__LINE__, 0x00000000,	"0", "%#x"},
  {__LINE__, 0xfffffc81,	"fffffc81", "%x"},
  {__LINE__, 0x00000000,	" 0", "% ld"},
  {__LINE__, 0x00024fb5,	"24fb5", "%x"},
  {__LINE__, 0x000012fa,	"12FA", "%X"},
  {__LINE__, 0x0318ce7c,	"51957372", "%0d"},
  {__LINE__, 0x02280a99,	"2280a99", "%-x"},
  {__LINE__, 0xffffff5c,	"FFFFFF5C", "%2.X"},
  {__LINE__, -0x000002e,	"    -46", "%7ld"},
  {__LINE__, -0x04a73e8,	"-4879336", "%4ld"},
  {__LINE__, 0x000007f3,	"7f3", "% 1.3x"},
  {__LINE__, 0x00000114,	"0x114", "%#x"},
  {__LINE__, 0x0000030c,	"30c", "%-x"},
  {__LINE__, 0x001dd0dd,	"0x1dd0dd", "%+#5.5x"},
  {__LINE__, 0xfff23de3,	"fff23de3", "%-x"},
  {__LINE__, -0x0178f9c,	"-1544092", "%d"},
  {__LINE__, 0x02ded8da,	"2DED8DA", "%X"},
  {__LINE__, -0x0991672,	"-10032754", "%3.d"},
  {__LINE__, 0x6943c150,	"6943c150", "%x"},
  {__LINE__, 0xffffc25d,	"FFFFC25D", "%4X"},
  {__LINE__, 0x00000c9c,	" 0003228", "% .7d"},
  {__LINE__, 0xffffffdf,	"FFFFFFDF", "% 6.X"},
  {__LINE__, 0x0001a145,	" 1a145", "%6.0x"},
  {__LINE__, 0xffdc832f,	"0xffdc832f", "%#.1x"},
  {__LINE__, 0x00699f7b,	"699f7b", "%x"},
  {__LINE__, 0xf9575268,	"F9575268", "%+0X"},
  {__LINE__, 0x04eb4783,	"82528131", "%-ld"},
  {__LINE__, -0x0000023,	"-35", "%0ld"},
  {__LINE__, -0x012b08a,	"-1224842", "%0d"},
  {__LINE__, 0xffffb587,	"FFFFB587", "%X"},
  {__LINE__, 0xffffffe9,	"ffffffe9", "%x"},
  {__LINE__, 0x006b5596,	" 7034262", "% 0d"},
  {__LINE__, 0x004d0d2a,	"+5049642", "%+ld"},
  {__LINE__, -0x002a099,	"-172185", "%d"},
  {__LINE__, 0x00000224,	"548", "%ld"},
  {__LINE__, 0x03e0cca8,	"65064104", "%d"},
  {__LINE__, -0x7bb389d,	"-129710237", "%.3ld"},
  {__LINE__, 0xffc630f5,	"ffc630f5", "%-07.0x"},
  {__LINE__, 0xfffffff8,	"FFFFFFF8", "%X"},
  {__LINE__, 0x0030225b,	"3154523", "%#d"},
  {__LINE__, 0xff7f4e28,	"ff7f4e28", "%+4.x"},
  {__LINE__, 0x14ee154d,	"+351147341", "%+ld"},
  {__LINE__, 0x00000003,	"03", "%.2d"},
  {__LINE__, 0xfe0359d6,	"fe0359d6", "%x"},
  {__LINE__, 0x002b71c3,	"2847171", "%d"},
  {__LINE__, 0x055c4d4a,	"55C4D4A", "%-X"},
  {__LINE__, 0xfffb17d2,	"fffb17d2", "% .0x"},
  {__LINE__, 0x00000002,	"2", "%x"},
  {__LINE__, 0x000018e1,	"18E1", "%1.1X"},
  {__LINE__, 0x00000331,	"817", "%0d"},
  {__LINE__, -0x0000982,	"-2434 ", "%-06.ld"},
  {__LINE__, -0x0000168,	"-0000360", "%.7ld"},
  {__LINE__, 0xffffffe9,	"FFFFFFE9", "%-0.4X"},
  {__LINE__, 0xe42084ef,	"E42084EF", "%X"},
  {__LINE__, 0x000000aa,	"aa", "%x"},
  {__LINE__, -0xe8b98b5,	"-244029621", "%+d"},
  {__LINE__, -0x00000d9,	"-217", "%+2.d"},
  {__LINE__, 0x0000027b,	"27B", "%+.0X"},
  {__LINE__, 0x002e52db,	"3035867", "%-ld"},
  {__LINE__, -0x00e2ba8,	"-928680", "%0.2ld"},
  {__LINE__, 0x003b74d8,	"3B74D8", "%X"},
  {__LINE__, -0x000006f,	"-111", "%+ld"},
  {__LINE__, 0xf8507e22,	"0XF8507E22", "%-#X"},
  {__LINE__, 0x0629f4c0,	"103412928", "%-ld"},
  {__LINE__, -0x000002d,	"-45", "%0d"},
  {__LINE__, -0x0001db0,	"-7600", "%d"},
  {__LINE__, -0x00001bb,	" -443", "%5.ld"},
  {__LINE__, 0xffffd2b9,	"ffffd2b9", "%+x"},
  {__LINE__, 0xffffe685,	"0XFFFFE685", "%#0.7X"},
  {__LINE__, 0x0000a4ce,	"A4CE", "% X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%X"},
  {__LINE__, 0x0000000c,	"C", "% X"},
  {__LINE__, 0xfff59369,	"FFF59369", "%7X"},
  {__LINE__, 0x00000156,	"  156", "%5.X"},
  {__LINE__, 0x02833aa9,	"+42154665", "%+2d"},
  {__LINE__, 0x0004a8f3,	"+305395", "%+d"},
  {__LINE__, 0x01a09267,	"1A09267", "%0.3X"},
  {__LINE__, 0x000004f1,	"4f1", "%x"},
  {__LINE__, 0x00000005,	"5", "%x"},
  {__LINE__, 0x00000119,	" 0281", "% #2.4ld"},
  {__LINE__, -0x0001a2a,	"-6698", "%ld"},
  {__LINE__, 0xa3633a57,	"A3633A57", "%7X"},
  {__LINE__, -0x10bd2970,	"-280832368", "%-d"},
  {__LINE__, 0xffff9c38,	"ffff9c38", "%x"},
  {__LINE__, 0xffdbe81e,	"ffdbe81e", "%+6.7x"},
  {__LINE__, 0xffffffe7,	"FFFFFFE7", "%-3.0X"},
  {__LINE__, 0x0002f6d6,	"2f6d6", "%5.x"},
  {__LINE__, 0xffffffff,	"ffffffff", "% x"},
  {__LINE__, 0xffc2c07a,	"ffc2c07a", "%0.x"},
  {__LINE__, 0xfcc0e13a,	"FCC0E13A", "%X"},
  {__LINE__, 0x0000000d,	"d", "% x"},
  {__LINE__, 0x0016cac8,	"16CAC8", "%-0.3X"},
  {__LINE__, 0x00945dc1,	"9723329", "%2d"},
  {__LINE__, 0xf19a1cd1,	"F19A1CD1", "%-X"},
  {__LINE__, 0x00000003,	"+3", "%+ld"},
  {__LINE__, 0x00000773,	"1907", "%ld"},
  {__LINE__, 0x000263e6,	"263e6", "%-x"},
  {__LINE__, -0x0238b55,	"-2329429", "%d"},
  {__LINE__, 0x00006c56,	"6C56", "%X"},
  {__LINE__, 0x0000f34b,	"62283", "%#.0ld"},
  {__LINE__, -0x1620e21,	"-23203361", "%0ld"},
  {__LINE__, 0xf9257d6a,	"f9257d6a", "%2x"},
  {__LINE__, -0x00ed463,	"-971875", "%03.d"},
  {__LINE__, 0x02bb94c6,	"45847750", "%d"},
  {__LINE__, 0xffffd20c,	"0XFFFFD20C", "%#X"},
  {__LINE__, 0x000087d8,	"34776", "%.0d"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%+7.X"},
  {__LINE__, -0x0009cd5,	"-40149", "%-ld"},
  {__LINE__, 0xfffff85e,	"FFFFF85E", "% 0.7X"},
  {__LINE__, -0x0000006,	"    -6", "%+#6.ld"},
  {__LINE__, 0x007ff453,	"0x7ff453", "%-#1.x"},
  {__LINE__, 0xffffffe6,	"FFFFFFE6", "%2X"},
  {__LINE__, 0x0000001f,	"0X1F", "%#4X"},
  {__LINE__, -0x001c157,	"-115031", "%.3ld"},
  {__LINE__, 0x00096e06,	"617990", "%3.1ld"},
  {__LINE__, 0x0f77271d,	"259467037", "%d"},
  {__LINE__, -0x0001403,	"-5123", "%d"},
  {__LINE__, 0xffffff8a,	"ffffff8a", "%x"},
  {__LINE__, -0x000010f,	"-271", "%1.ld"},
  {__LINE__, 0xe573cc4a,	"E573CC4A", "%0X"},
  {__LINE__, -0x0000d88,	"-3464", "%-d"},
  {__LINE__, 0x0000000e,	"14", "%#ld"},
  {__LINE__, -0x000345b,	"-13403", "%#d"},
  {__LINE__, 0x00000602,	"602", "%+x"},
  {__LINE__, 0x00000011,	"17", "%#d"},
  {__LINE__, -0x0000002,	"-2", "%+d"},
  {__LINE__, 0x030fe6e6,	"51373798", "%d"},
  {__LINE__, 0x00000007,	"007", "%.3X"},
  {__LINE__, 0x0001abe0,	"0X1ABE0", "%+#.4X"},
  {__LINE__, 0xfffffdb7,	"fffffdb7", "%-6x"},
  {__LINE__, 0xffffff8d,	"FFFFFF8D", "% 02.2X"},
  {__LINE__, 0xfff12126,	"FFF12126", "%X"},
  {__LINE__, 0x0208e32d,	"34136877", "%.2d"},
  {__LINE__, 0x11c04b55,	"297814869", "%ld"},
  {__LINE__, 0xff1e5ca3,	"0xff1e5ca3", "%#x"},
  {__LINE__, 0xf9643f09,	"f9643f09", "%x"},
  {__LINE__, -0x003c6da,	"-247514", "%4d"},
  {__LINE__, 0xff69d0e7,	"FF69D0E7", "%-X"},
  {__LINE__, 0x00006ae9,	"0x6ae9", "%#x"},
  {__LINE__, -0x005aefe,	"-372478", "%d"},
  {__LINE__, 0x0000000d,	"00013", "%3.5ld"},
  {__LINE__, 0x00cc185c,	"CC185C", "%X"},
  {__LINE__, 0x3dd14d9f,	"3DD14D9F", "%1.4X"},
  {__LINE__, -0x4cc2ad3,	"-80489171", "%1.d"},
  {__LINE__, 0xfffff79e,	"fffff79e", "%x"},
  {__LINE__, 0xfffeeb03,	"fffeeb03", "%-1x"},
  {__LINE__, -0x0b1b15c,	"-11645276", "%0ld"},
  {__LINE__, -0x06b558d,	"-7034253", "%ld"},
  {__LINE__, 0xfffffe61,	"fffffe61", "%x"},
  {__LINE__, -0x0000002,	"-2", "%d"},
  {__LINE__, -0x0000162,	"-000354", "%-5.6d"},
  {__LINE__, 0x01a23780,	"27408256", "%d"},
  {__LINE__, 0xffff3a9b,	"ffff3a9b", "% x"},
  {__LINE__, 0xfffffdc7,	"0xfffffdc7", "%#4.5x"},
  {__LINE__, 0x00000000,	"00", "%.2X"},
  {__LINE__, -0x0000006,	"-6", "%0ld"},
  {__LINE__, -0x16072c6,	"-23098054", "%#5ld"},
  {__LINE__, -0x07152b8,	"-7426744", "%01ld"},
  {__LINE__, 0x0000d6c6,	"0x0d6c6", "%#1.5x"},
  {__LINE__, 0x00000f7c,	"000f7c", "%+04.6x"},
  {__LINE__, 0x00000bd0,	"3024", "%4ld"},
  {__LINE__, 0x0000295e,	"0x295e", "%#x"},
  {__LINE__, 0x00002e38,	"11832", "%.5d"},
  {__LINE__, -0xa2f5de4,	"-170876388", "%#d"},
  {__LINE__, -0x001aa36,	"-109110", "%-#d"},
  {__LINE__, 0x03012091,	"3012091", "%+2.5X"},
  {__LINE__, -0x00009ed,	"-002541", "%-0.6ld"},
  {__LINE__, 0x0000001d,	"1d", "%x"},
  {__LINE__, 0xffffe315,	"FFFFE315", "%+4X"},
  {__LINE__, 0x0000716b,	"716B", "%X"},
  {__LINE__, 0xfffb8315,	"0xfffb8315", "%+#x"},
  {__LINE__, 0x00000132,	"132    ", "%-7.3x"},
  {__LINE__, 0x00000000,	"+0000000", "%+1.7d"},
  {__LINE__, 0xe16d27ab,	"E16D27AB", "%X"},
  {__LINE__, 0xffffffe5,	"ffffffe5", "%+x"},
  {__LINE__, -0x000ab9d,	"-43933", "%ld"},
  {__LINE__, 0xffd042d6,	"ffd042d6", "%2x"},
  {__LINE__, 0xffffff9b,	"ffffff9b", "%x"},
  {__LINE__, 0x000000fb,	"0xfb", "% #1.x"},
  {__LINE__, 0x0000000f,	" 15", "%#3ld"},
  {__LINE__, 0xfffba2d8,	"0XFFFBA2D8", "%-#0.X"},
  {__LINE__, 0xfffffff8,	"0XFFFFFFF8", "% #X"},
  {__LINE__, 0x00000000,	"    ", "%4.ld"},
  {__LINE__, 0x00000002,	"2", "%+x"},
  {__LINE__, 0xfffff314,	"FFFFF314", "%-X"},
  {__LINE__, 0x00000000,	" 0", "% ld"},
  {__LINE__, -0x0000007,	"-07", "%3.2ld"},
  {__LINE__, 0xffffdd80,	"FFFFDD80", "%.6X"},
  {__LINE__, -0x000001b,	"-27", "%-ld"},
  {__LINE__, -0x0000258,	"-600", "%-0d"},
  {__LINE__, 0x00016377,	"16377", "%3X"},
  {__LINE__, 0x00000001,	"1", "%X"},
  {__LINE__, -0xac5d314,	"-180736788", "%d"},
  {__LINE__, -0x000036e,	"-878", "% ld"},
  {__LINE__, 0xfe346af4,	"fe346af4", "%.5x"},
  {__LINE__, 0xffffffe1,	"ffffffe1", "%-7.6x"},
  {__LINE__, -0x0a1df07,	"-10608391", "%#.5d"},
  {__LINE__, 0x000000c9,	" 0XC9", "%+#5.X"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%x"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%+x"},
  {__LINE__, -0x4517255,	"-72446549", "%.6ld"},
  {__LINE__, 0xfffa3670,	"FFFA3670", "%-6X"},
  {__LINE__, 0xffffffe0,	"ffffffe0", "%2.x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%0x"},
  {__LINE__, 0x0000230d,	"8973", "%#.1d"},
  {__LINE__, 0x00000238,	"238", "%0X"},
  {__LINE__, 0xfffce5ab,	"FFFCE5AB", "%-X"},
  {__LINE__, 0x0000002c,	"2C", "%X"},
  {__LINE__, 0x00000001,	"   1", "%4.ld"},
  {__LINE__, 0xffffff8d,	"FFFFFF8D", "%-X"},
  {__LINE__, 0x00069c69,	"433257", "%06d"},
  {__LINE__, 0xfffffb8d,	"0xfffffb8d", "%#x"},
  {__LINE__, 0x000d6a2d,	"879149", "%5.5d"},
  {__LINE__, -0x0001fcb,	"  -8139", "%7.ld"},
  {__LINE__, 0xfff86937,	"fff86937", "%-0x"},
  {__LINE__, 0x00059cf9,	"367865", "%#.0ld"},
  {__LINE__, 0x02c5d87a,	"46520442", "%3.ld"},
  {__LINE__, 0x00000571,	"1393", "%ld"},
  {__LINE__, 0x0003c73f,	"+247615", "%+4ld"},
  {__LINE__, 0x0000004f,	"4f", "% 0x"},
  {__LINE__, 0x00000000,	"0", "%-ld"},
  {__LINE__, -0x0e5850f,	"-15041807", "% ld"},
  {__LINE__, -0x0000002,	"  -0002", "%7.4d"},
  {__LINE__, 0xfffffd1b,	"fffffd1b", "%05x"},
  {__LINE__, 0x0000041c,	" 1052", "% #0.ld"},
  {__LINE__, -0x0000030,	"-48", "%d"},
  {__LINE__, -0x0013593,	"-79251", "% #d"},
  {__LINE__, 0x00000001,	"1", "%+X"},
  {__LINE__, 0x0000056b,	" 56b", "%4.x"},
  {__LINE__, -0x0000004,	"-4 ", "%-3d"},
  {__LINE__, -0x0000003,	"-3", "% ld"},
  {__LINE__, 0xffff7c14,	"0XFFFF7C14", "%#X"},
  {__LINE__, 0x02f63dd8,	"49692120", "%.7ld"},
  {__LINE__, -0x03c51c9,	"-3953097", "%+d"},
  {__LINE__, 0x00ded685,	"14603909", "%5.ld"},
  {__LINE__, 0xffffffba,	"ffffffba", "%x"},
  {__LINE__, 0x000370e8,	"225512", "%#ld"},
  {__LINE__, 0x00000003,	"3", "%X"},
  {__LINE__, -0x0024a64,	"-150116", "%7.d"},
  {__LINE__, 0xff486ca1,	"ff486ca1", "%x"},
  {__LINE__, 0x000001cf,	"1CF", "% X"},
  {__LINE__, -0x0002d7e,	"-11646", "%-0d"},
  {__LINE__, 0x0a594c65,	"a594c65", "%.4x"},
  {__LINE__, -0x0000002,	"-0002", "%-5.4ld"},
  {__LINE__, 0x00000000,	"", "%00.ld"},
  {__LINE__, 0x00058bc4,	"58BC4", "%3X"},
  {__LINE__, 0x0002cf8e,	" 184206", "% 0ld"},
  {__LINE__, 0x000009c7,	"+2503", "%+4.ld"},
  {__LINE__, 0xed0c984d,	"ED0C984D", "%X"},
  {__LINE__, -0x0000058,	"-088", "%#.3ld"},
  {__LINE__, 0x0076083d,	"0X76083D", "%#6X"},
  {__LINE__, -0x0000001,	"-1", "%#d"},
  {__LINE__, -0x6bf1777,	"-113186679", "%#ld"},
  {__LINE__, -0x000011f,	"-287", "%ld"},
  {__LINE__, 0x001b0e7d,	"1B0E7D", "%-4X"},
  {__LINE__, 0x000007ac,	" 1964", "%5.ld"},
  {__LINE__, 0x00000005,	"5", "%0.d"},
  {__LINE__, -0x00003ba,	"-954", "%4.0ld"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%X"},
  {__LINE__, 0x00000019,	"19", "%x"},
  {__LINE__, 0xffffffe0,	"ffffffe0", "%-.6x"},
  {__LINE__, 0x0000012a,	" 298", "% d"},
  {__LINE__, 0x00002c74,	"2c74", "% 4.3x"},
  {__LINE__, 0x000002d5,	"725", "%d"},
  {__LINE__, 0x0001c9a9,	"1c9a9", "%-02x"},
  {__LINE__, 0xffc928c8,	"ffc928c8", "%x"},
  {__LINE__, -0x03ae51f,	"-3859743", "% #ld"},
  {__LINE__, 0x0000526d,	"526d", "%x"},
  {__LINE__, -0x00028f0,	"-10480", "%5ld"},
  {__LINE__, -0x49b4262,	"-77283938", "%+02.0d"},
  {__LINE__, 0x028d37f0,	"0x28d37f0", "%+#x"},
  {__LINE__, 0xd66e0af9,	"D66E0AF9", "%03.X"},
  {__LINE__, -0x00c7707,	"-816903", "%0d"},
  {__LINE__, -0x00000d0,	"-208", "%-.1ld"},
  {__LINE__, 0x0000c328,	"49960", "%d"},
  {__LINE__, 0x34cb86f1,	"34CB86F1", "%X"},
  {__LINE__, 0x000000f6,	"F6", "%+X"},
  {__LINE__, 0x0a3407ec,	"0xa3407ec", "%-#x"},
  {__LINE__, 0x00007ebc,	"32444", "%#3.d"},
  {__LINE__, 0xfffd3d65,	"fffd3d65", "%x"},
  {__LINE__, 0x0007bc82,	"0507010", "%0.7d"},
  {__LINE__, 0x0005bb93,	"375699", "%ld"},
  {__LINE__, 0x0ec11cc8,	"0XEC11CC8", "%+#6.2X"},
  {__LINE__, 0xfffff9c6,	"fffff9c6", "%.5x"},
  {__LINE__, 0xff05ab70,	"0XFF05AB70", "%-#.3X"},
  {__LINE__, 0x2328b716,	"589870870", "%d"},
  {__LINE__, 0x00001a79,	"6777", "%.1d"},
  {__LINE__, 0xfffee573,	"fffee573", "%0.1x"},
  {__LINE__, -0x0000929,	"  -2345", "%7.d"},
  {__LINE__, 0xffffff9a,	"FFFFFF9A", "%2.X"},
  {__LINE__, 0xfffffe60,	"fffffe60", "%.5x"},
  {__LINE__, 0xfffffcd2,	"fffffcd2", "%.7x"},
  {__LINE__, 0x00000001,	"   001", "%6.3X"},
  {__LINE__, 0x00011e9c,	"+73372", "%+0ld"},
  {__LINE__, 0x0000002a,	"2a", "% x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%.7x"},
  {__LINE__, -0x0008ee8,	"-36584", "%ld"},
  {__LINE__, 0x0000001c,	"28", "%-d"},
  {__LINE__, 0x000abeda,	"704218", "%d"},
  {__LINE__, 0x001347f7,	"1347f7", "%3.0x"},
  {__LINE__, 0x0000023e,	"574", "%3.3ld"},
  {__LINE__, 0x00000000,	"0", "%-ld"},
  {__LINE__, -0x0016de0,	"-93664", "%0ld"},
  {__LINE__, 0xffffff45,	"FFFFFF45", "% X"},
  {__LINE__, 0x02dfb08c,	"48214156", "%#ld"},
  {__LINE__, 0x003d73a2,	"3d73a2", "%6.x"},
  {__LINE__, 0x00147da7,	"1342887", "%#d"},
  {__LINE__, -0x5ff0f1e,	"-100601630", "%-01ld"},
  {__LINE__, -0x000000b,	"-11", "%ld"},
  {__LINE__, 0x00000168,	"   168", "%+6.x"},
  {__LINE__, 0xffffc28e,	"ffffc28e", "%0x"},
  {__LINE__, -0x00003a2,	"-930", "%ld"},
  {__LINE__, 0x0002e56f,	" 189807", "% 1.ld"},
  {__LINE__, 0x51abf44f,	"0x51abf44f", "%#.7x"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, 0x9581268f,	"9581268F", "%+X"},
  {__LINE__, 0xffffff3b,	"FFFFFF3B", "%X"},
  {__LINE__, 0x000083d4,	" 33748", "% #d"},
  {__LINE__, 0x00000001,	"1", "%x"},
  {__LINE__, -0x000e51f,	"-58655", "%.0ld"},
  {__LINE__, 0x0003eacb,	"256715", "%6ld"},
  {__LINE__, 0x02be09db,	" 46008795", "% 0.ld"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "% X"},
  {__LINE__, 0x000084f5,	" 34037", "%6ld"},
  {__LINE__, -0x1127f99,	"-17989529", "%#d"},
  {__LINE__, 0x5f6512de,	"5f6512de", "%.7x"},
  {__LINE__, 0x00000001,	"1", "%x"},
  {__LINE__, 0xfff74ab5,	"fff74ab5", "%x"},
  {__LINE__, 0x0eebeb94,	"250342292", "%4.ld"},
  {__LINE__, 0x0001b846,	"0x1b846", "%#1x"},
  {__LINE__, 0x001e8c32,	"1E8C32", "%2X"},
  {__LINE__, -0x0dae932,	"-14346546", "%5.1d"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, -0x0000042,	"-66", "%ld"},
  {__LINE__, 0xffffff51,	"FFFFFF51", "%0.1X"},
  {__LINE__, 0x00000043,	"43", "%x"},
  {__LINE__, 0x04c21f39,	" 79830841", "% 0ld"},
  {__LINE__, 0x0000061e,	"1566", "%03.3d"},
  {__LINE__, -0x0000003,	"-3", "%+d"},
  {__LINE__, 0x015b32db,	" 22754011", "% .4d"},
  {__LINE__, 0xfffff181,	"FFFFF181", "%-X"},
  {__LINE__, 0x000017ec,	"0X17EC", "%#X"},
  {__LINE__, 0x000d703e,	"880702", "%#ld"},
  {__LINE__, -0x6d7533a0,	"-1836397472", "%ld"},
  {__LINE__, 0x0000008a,	" 138", "% d"},
  {__LINE__, -0x7368794b,	"-1936226635", "%+#d"},
  {__LINE__, 0x0000000d,	"0XD", "%#X"},
  {__LINE__, 0x0000030d,	"30D", "% X"},
  {__LINE__, 0xfffff9fe,	"FFFFF9FE", "%5X"},
  {__LINE__, 0x00001bb2,	"7090", "%d"},
  {__LINE__, 0x041d2a0c,	"41D2A0C", "%0X"},
  {__LINE__, 0x00012aee,	" 76526", "% d"},
  {__LINE__, 0x0000055f,	"55f", "%.1x"},
  {__LINE__, 0xffffffff,	"0XFFFFFFFF", "%#1X"},
  {__LINE__, 0x07b0a971,	"+129018225", "%+.2ld"},
  {__LINE__, 0xfffffff8,	"FFFFFFF8", "%4X"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, 0x00000038,	"+56", "%+2ld"},
  {__LINE__, 0xfffffc2f,	"fffffc2f", "%+7.x"},
  {__LINE__, 0x00004477,	"0x4477", "% #x"},
  {__LINE__, 0x0000000d,	"0XD", "%+#3X"},
  {__LINE__, 0xf5bf37b1,	"F5BF37B1", "%1.X"},
  {__LINE__, 0x1a96f431,	"446100529", "%d"},
  {__LINE__, 0x0037edf3,	"+3665395", "%+#4.5ld"},
  {__LINE__, 0x0007f2aa,	"520874", "%0ld"},
  {__LINE__, -0x00051a3,	"-20899", "%+#1.ld"},
  {__LINE__, 0x0000037f,	"37F", "%0X"},
  {__LINE__, 0xffffffb4,	"ffffffb4", "%x"},
  {__LINE__, -0xd984c00,	"-228084736", "%+06ld"},
  {__LINE__, 0xffffe1be,	"FFFFE1BE", "%X"},
  {__LINE__, 0xfff20d48,	"FFF20D48", "%+6.0X"},
  {__LINE__, 0x000028b7,	"0x028b7", "%-#7.5x"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, 0x03f37945,	"66287941", "%d"},
  {__LINE__, 0xffffffed,	"0XFFFFFFED", "%+#6.4X"},
  {__LINE__, 0x0000f046,	"f046", "%x"},
  {__LINE__, 0xe9772b51,	"E9772B51", "%-1.X"},
  {__LINE__, 0xfffffffe,	"fffffffe", "% x"},
  {__LINE__, 0xfffffffa,	"0xfffffffa", "%#x"},
  {__LINE__, 0x00000015,	"15", "%-X"},
  {__LINE__, 0x0000003c,	"60", "%#ld"},
  {__LINE__, 0x3103952d,	"822318381", "%0.ld"},
  {__LINE__, 0x17ba68bb,	"398092475", "%2d"},
  {__LINE__, 0x000006c4,	"+1732", "%+.2d"},
  {__LINE__, 0x00000043,	"67", "%#d"},
  {__LINE__, 0x0043fb55,	"4455253", "%.1ld"},
  {__LINE__, 0x00004b76,	"4b76", "% 0x"},
  {__LINE__, 0xfff4c56b,	"FFF4C56B", "%7X"},
  {__LINE__, 0x00766055,	"766055", "%+5x"},
  {__LINE__, -0x000009f,	"-159", "%+d"},
  {__LINE__, 0xffff063f,	"ffff063f", "%-2x"},
  {__LINE__, 0x00808fc8,	"808fc8", "%x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, 0x000000f1,	"00000f1", "%+02.7x"},
  {__LINE__, 0x00000002,	"2", "%X"},
  {__LINE__, 0x00000000,	"000", "%03d"},
  {__LINE__, 0xe63f73b2,	"E63F73B2", "% 1X"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%5.1X"},
  {__LINE__, 0x0d3fa38b,	"222274443", "%1d"},
  {__LINE__, 0x00000000,	"0", "% X"},
  {__LINE__, 0x00000001,	"   1", "%04.ld"},
  {__LINE__, 0x00000046,	"46", "%0X"},
  {__LINE__, 0x0000761f,	" 30239", "% ld"},
  {__LINE__, -0x0002517,	"-9495", "%+d"},
  {__LINE__, 0x00000156,	"156", "% 0x"},
  {__LINE__, 0x1c55eba2,	"1c55eba2", "%.6x"},
  {__LINE__, 0x005af80d,	"5af80d", "%.6x"},
  {__LINE__, 0x0000002e,	"46", "%d"},
  {__LINE__, -0x0007c0f,	"-31759", "%ld"},
  {__LINE__, 0xffffe924,	"FFFFE924", "%7X"},
  {__LINE__, 0x00000174,	"372", "%ld"},
  {__LINE__, 0xffffffc9,	"0xffffffc9", "%-#x"},
  {__LINE__, 0x00000020,	"+000032", "%+07d"},
  {__LINE__, 0xffffe5d9,	"FFFFE5D9", "%4.5X"},
  {__LINE__, 0xffffffa3,	"FFFFFFA3", "%+.3X"},
  {__LINE__, 0x00000a03,	"+2563", "%+2d"},
  {__LINE__, 0x001b58ca,	"+1792202", "%+4d"},
  {__LINE__, 0xffffffc9,	"0xffffffc9", "%+#5x"},
  {__LINE__, -0x0000003,	"-3", "% d"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%+0x"},
  {__LINE__, -0x0000002,	"-02", "%.2d"},
  {__LINE__, 0x000243fb,	"148475", "%-ld"},
  {__LINE__, 0x00000001,	"1", "%0d"},
  {__LINE__, -0x0000672,	"-1650", "%ld"},
  {__LINE__, -0x0005413,	"-0021523", "% 7.7d"},
  {__LINE__, 0x00000017,	"0X17", "%#X"},
  {__LINE__, 0x00000e48,	"3656", "%0d"},
  {__LINE__, 0xffe79b38,	"ffe79b38", "%-x"},
  {__LINE__, 0xffffff15,	"FFFFFF15", "%+6.1X"},
  {__LINE__, 0xfff0272c,	"fff0272c", "%-.5x"},
  {__LINE__, -0x00b706f,	"-749679", "%1.ld"},
  {__LINE__, 0x0176aeec,	"176AEEC", "%.1X"},
  {__LINE__, -0x00005a1,	"-1441", "% 0ld"},
  {__LINE__, -0x0000002,	"-00002", "%.5d"},
  {__LINE__, -0xd2e6f5d,	"-221146973", "%1ld"},
  {__LINE__, -0x0000001,	" -001", "%5.3ld"},
  {__LINE__, 0x00000001,	"    1", "%05.ld"},
  {__LINE__, 0x0000749e,	"+29854", "%+#d"},
  {__LINE__, 0x00000005,	"5", "%d"},
  {__LINE__, 0xfa7128b0,	"fa7128b0", "%1.x"},
  {__LINE__, 0xffffbbb4,	"0XFFFFBBB4", "%#.1X"},
  {__LINE__, 0x0006862f,	"427567", "%d"},
  {__LINE__, 0x00000002,	"2", "%X"},
  {__LINE__, 0x000005d4,	"5d4", "% x"},
  {__LINE__, 0x001387e1,	"1279969", "%-05.0ld"},
  {__LINE__, -0x0035a56,	"-219734", "%ld"},
  {__LINE__, -0x4064ecc6,	"-1080356038", "%ld"},
  {__LINE__, 0x0000360d,	"13837", "%0ld"},
  {__LINE__, -0xea1a85b,	"-245475419", "%-.2ld"},
  {__LINE__, 0xffffff2d,	"FFFFFF2D", "%X"},
  {__LINE__, 0x00000004,	"   0004", "%7.4x"},
  {__LINE__, 0x00f72ffd,	"F72FFD", "%-X"},
  {__LINE__, 0x00000fa2,	"fa2  ", "%-5x"},
  {__LINE__, 0x05ae1f9a,	"95297434", "%#ld"},
  {__LINE__, 0x0000bf2e,	"48942", "%3.d"},
  {__LINE__, 0x00000000,	" ", "%1.X"},
  {__LINE__, 0x01bcb097,	"29143191", "%ld"},
  {__LINE__, 0x0000009c,	"156 ", "%-4.0d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "% x"},
  {__LINE__, 0x00000001,	"1     ", "%-6.d"},
  {__LINE__, 0xffffffef,	"ffffffef", "%7.x"},
  {__LINE__, 0xfffffec1,	"fffffec1", "%.5x"},
  {__LINE__, -0x000000f,	"-15", "%-1d"},
  {__LINE__, -0x0008426,	"-33830", "%0ld"},
  {__LINE__, 0x005be0ae,	"5BE0AE", "% X"},
  {__LINE__, 0x00000009,	"      9", "%+7X"},
  {__LINE__, -0x0007e18,	"-32280", "%+0.d"},
  {__LINE__, 0x01697ba1,	" 23690145", "% 5.ld"},
  {__LINE__, -0x0012042,	"-073794", "%7.6d"},
  {__LINE__, 0x04e9bd0d,	"4e9bd0d", "%-2x"},
  {__LINE__, 0xffffffd9,	"FFFFFFD9", "%.2X"},
  {__LINE__, -0x01b9632,	"-1807922", "%.6ld"},
  {__LINE__, 0x000000cd,	"205", "%1.ld"},
  {__LINE__, 0x00000000,	" ", "% .0d"},
  {__LINE__, 0xff17bbb1,	"ff17bbb1", "%x"},
  {__LINE__, -0x00146d7,	"-83671", "%+1.ld"},
  {__LINE__, 0xfffff144,	"fffff144", "%x"},
  {__LINE__, 0x000f8dbe,	"F8DBE", "%3.X"},
  {__LINE__, -0x000381c,	"-14364", "%d"},
  {__LINE__, 0x0000001e,	"  30", "%4.1d"},
  {__LINE__, 0x00000016,	"22", "%-0d"},
  {__LINE__, 0x00000002,	"+02", "%+1.2ld"},
  {__LINE__, 0x0000e803,	"59395", "%d"},
  {__LINE__, 0xb4c2448d,	"b4c2448d", "%-7x"},
  {__LINE__, 0x000e697d,	"944509", "%ld"},
  {__LINE__, 0xfffe6e32,	"0XFFFE6E32", "%#X"},
  {__LINE__, 0x00000190,	"  190", "%+5.X"},
  {__LINE__, -0x03a2219,	"-3809817", "%#6.ld"},
  {__LINE__, -0x000003c,	"-60 ", "%-#4.ld"},
  {__LINE__, 0x00000000,	"   ", "% 03.ld"},
  {__LINE__, -0x074f922,	"-7665954", "%ld"},
  {__LINE__, -0x00000f0,	"-240", "%-ld"},
  {__LINE__, 0xfffe42d2,	"0XFFFE42D2", "%#X"},
  {__LINE__, 0x000000dd,	"DD", "%X"},
  {__LINE__, 0x00359abe,	"359ABE", "%.1X"},
  {__LINE__, 0xffec7bdf,	"FFEC7BDF", "%0.1X"},
  {__LINE__, 0x0ecddcba,	"248372410", "%-#3.d"},
  {__LINE__, 0x00ad0dbc,	"11341244", "%ld"},
  {__LINE__, -0x0000001,	"-1", "%-d"},
  {__LINE__, 0x00050841,	"50841", "% .5x"},
  {__LINE__, 0x01d359e7,	"1d359e7", "%1.x"},
  {__LINE__, 0xff9efaa3,	"FF9EFAA3", "%X"},
  {__LINE__, 0x0007ea10,	"+518672", "%+ld"},
  {__LINE__, -0x000671c,	"-26396", "%1d"},
  {__LINE__, 0xffffff91,	"0xffffff91", "%#4.4x"},
  {__LINE__, 0x00000000,	"+", "%+0.0ld"},
  {__LINE__, -0x002c53e,	"-181566", "%3.d"},
  {__LINE__, 0xffffff56,	"ffffff56", "%x"},
  {__LINE__, 0xfffff589,	"FFFFF589", "%+X"},
  {__LINE__, 0x00024d13,	"24D13", "%-5.2X"},
  {__LINE__, 0x00000000,	"     0", "%6.1d"},
  {__LINE__, 0x00a64f33,	"A64F33", "%4.4X"},
  {__LINE__, 0xffebb57a,	"FFEBB57A", "%5.4X"},
  {__LINE__, 0xfff3b4a0,	"fff3b4a0", "%2.x"},
  {__LINE__, 0xffffffd9,	"FFFFFFD9", "%.2X"},
  {__LINE__, 0x00d37b84,	"13859716", "%d"},
  {__LINE__, 0x00001e85,	"0001E85", "%0.7X"},
  {__LINE__, -0x756148f,	"-123081871", "% 7.d"},
  {__LINE__, -0x0319339,	"-3248953", "%+#.4d"},
  {__LINE__, -0x00798b8,	"-497848", "%#5ld"},
  {__LINE__, -0x0000039,	"-57", "%0d"},
  {__LINE__, -0x000b1d7,	"-45527", "%+0.ld"},
  {__LINE__, 0xff811fba,	"FF811FBA", "%+X"},
  {__LINE__, 0x00000042,	" 66", "% ld"},
  {__LINE__, 0xfffffe31,	"0XFFFFFE31", "%#X"},
  {__LINE__, 0x00000073,	"115", "%ld"},
  {__LINE__, 0x45091a39,	"0x45091a39", "%+#3.x"},
  {__LINE__, 0x001270f5,	"1270f5", "%-5.6x"},
  {__LINE__, 0xfffd91fd,	"fffd91fd", "%x"},
  {__LINE__, -0x0817bad,	"-8485805", "%#ld"},
  {__LINE__, -0x32ad55f,	"-53138783", "%0d"},
  {__LINE__, 0x00003e57,	"15959", "%0ld"},
  {__LINE__, -0x0048756,	"-296790", "%2.6d"},
  {__LINE__, 0xff90f45f,	"FF90F45F", "% X"},
  {__LINE__, 0x0000e454,	"0e454", "% .5x"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%x"},
  {__LINE__, 0xfffffff7,	"FFFFFFF7", "%-2X"},
  {__LINE__, 0xffdabf0e,	"FFDABF0E", "%+X"},
  {__LINE__, 0xffffffff,	"0XFFFFFFFF", "%#1X"},
  {__LINE__, 0x01516650,	"1516650", "% x"},
  {__LINE__, 0xffffff51,	"FFFFFF51", "%X"},
  {__LINE__, 0x000000ea,	"234", "%00.d"},
  {__LINE__, 0x06db60ca,	"115040458", "%5.d"},
  {__LINE__, 0x00000f01,	" 3841", "% d"},
  {__LINE__, 0x00000009,	"9", "%x"},
  {__LINE__, 0x299b3ba0,	"299b3ba0", "%6.7x"},
  {__LINE__, 0x0067f298,	"67f298", "%-2.6x"},
  {__LINE__, 0xfffffff5,	"FFFFFFF5", "% 2X"},
  {__LINE__, 0x00102ff9,	"102FF9", "%-.0X"},
  {__LINE__, 0xffc22393,	"0xffc22393", "% #6x"},
  {__LINE__, 0x00007db5,	"32181", "%-2ld"},
  {__LINE__, 0x0000b0a3,	"0xb0a3", "%#0x"},
  {__LINE__, 0x001ceebb,	"1CEEBB", "%-3.4X"},
  {__LINE__, 0x00025101,	"0x25101", "%#x"},
  {__LINE__, -0x0000001,	"-1", "%0ld"},
  {__LINE__, 0xffffd846,	"FFFFD846", "%+2.3X"},
  {__LINE__, 0x00001d79,	" 7545", "% 0.1ld"},
  {__LINE__, -0x0000002,	"   -2", "%5d"},
  {__LINE__, 0xf93b9fdc,	"f93b9fdc", "%5x"},
  {__LINE__, 0xffff0021,	"FFFF0021", "%6X"},
  {__LINE__, 0x00007cf9,	"7cf9", "%3.1x"},
  {__LINE__, -0x0000002,	"-2", "%d"},
  {__LINE__, 0x00001d84,	"1d84", "%0x"},
  {__LINE__, -0x033201e,	"-3350558", "%-2.0d"},
  {__LINE__, 0xfff8a6fb,	"FFF8A6FB", "%+.7X"},
  {__LINE__, 0x00006fff,	" 28671", "% ld"},
  {__LINE__, -0x02a274a,	"-2762570", "%d"},
  {__LINE__, -0x0006628,	"-26152", "%00ld"},
  {__LINE__, 0x00000011,	"11", "%-x"},
  {__LINE__, -0x0000ed9,	"-3801", "%0.ld"},
  {__LINE__, 0xfc5b725d,	"FC5B725D", "%X"},
  {__LINE__, 0x3530bd4e,	"892386638", "%7.d"},
  {__LINE__, 0x03bb4ff7,	"62607351", "%#4.7ld"},
  {__LINE__, 0x00009f86,	"9f86", "%x"},
  {__LINE__, 0x0000e727,	"59175", "%1d"},
  {__LINE__, 0xfffffdf2,	"0XFFFFFDF2", "%#X"},
  {__LINE__, 0x00e60dbf,	"0XE60DBF", "% #1.X"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%+X"},
  {__LINE__, 0x0a16f44e,	"0XA16F44E", "%#.0X"},
  {__LINE__, 0x0001f97c,	"1f97c", "% x"},
  {__LINE__, 0x0000000d,	"13", "%#0ld"},
  {__LINE__, 0x0000002a,	"42", "%0ld"},
  {__LINE__, 0x00000007,	"   +7", "%+5ld"},
  {__LINE__, 0xffffff7f,	"FFFFFF7F", "%-X"},
  {__LINE__, 0x000006a6,	"1702", "%ld"},
  {__LINE__, 0xfaff2fb1,	"faff2fb1", "% x"},
  {__LINE__, 0xffff94ab,	"ffff94ab", "%x"},
  {__LINE__, 0x011d611b,	"0X11D611B", "%#2.3X"},
  {__LINE__, 0x00000000,	" +000", "%+#5.3ld"},
  {__LINE__, -0x87fcc37,	"-142593079", "%+d"},
  {__LINE__, -0x0417424,	"-4289572", "%+d"},
  {__LINE__, 0x03fabc0c,	"3fabc0c", "%x"},
  {__LINE__, 0xfffff880,	"fffff880", "%-x"},
  {__LINE__, 0x000002d7,	"2d7", "%-02.x"},
  {__LINE__, 0x00003e82,	"16002", "%#d"},
  {__LINE__, -0x0003713,	"-14099", "% 5d"},
  {__LINE__, -0x0000027,	"-39", "%ld"},
  {__LINE__, 0x00013098,	"0077976", "%01.7d"},
  {__LINE__, -0x000000c,	"-12", "%ld"},
  {__LINE__, -0x00000c0,	"-192", "% ld"},
  {__LINE__, 0xffbe9285,	"FFBE9285", "%3.X"},
  {__LINE__, 0x00000046,	"46", "%x"},
  {__LINE__, 0x00000000,	"    ", "%+4.x"},
  {__LINE__, 0x00011e72,	"73330", "%2.3d"},
  {__LINE__, -0x5276dd7,	"-86470103", "%d"},
  {__LINE__, 0x00000013,	"19", "%-02.ld"},
  {__LINE__, 0x384118a7,	"0X384118A7", "%-#X"},
  {__LINE__, 0x00000000,	"0", "% #X"},
  {__LINE__, 0x00000009,	"9", "%#ld"},
  {__LINE__, 0x00021145,	"135493", "%-ld"},
  {__LINE__, 0xff188a0c,	"FF188A0C", "%1.X"},
  {__LINE__, 0xffffffd5,	"ffffffd5", "%0x"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "% 0X"},
  {__LINE__, 0xffff74a3,	"ffff74a3", "%x"},
  {__LINE__, 0x01d5a2f8,	"1d5a2f8", "%-0.x"},
  {__LINE__, 0xfffffef6,	"fffffef6", "%+06.x"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, 0x00000000,	"+0", "%+ld"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%4.x"},
  {__LINE__, -0x0000344,	"-0836", "% .4d"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%0X"},
  {__LINE__, 0x000a3121,	"667937", "%#4.4ld"},
  {__LINE__, 0x0001e211,	"0X1E211", "%#X"},
  {__LINE__, 0x00000c8b,	"00C8B", "%05X"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%+0x"},
  {__LINE__, 0x001a53ce,	"1725390", "%d"},
  {__LINE__, 0x0000057f,	"57f    ", "%-7.x"},
  {__LINE__, -0x0073e4d,	"-474701", "%#ld"},
  {__LINE__, -0x0000002,	" -2", "% 3.d"},
  {__LINE__, 0x482dc404,	"482DC404", "%X"},
  {__LINE__, 0x0000011c,	"11c", "%-.1x"},
  {__LINE__, 0x00000c12,	" 3090", "%5.3ld"},
  {__LINE__, 0xfffe1068,	"FFFE1068", "%-.4X"},
  {__LINE__, -0x0055e88,	"-351880", "%ld"},
  {__LINE__, 0x000c9cef,	"+826607", "%+d"},
  {__LINE__, 0xffffffe3,	"ffffffe3", "%0x"},
  {__LINE__, -0x0000ee9,	"-3817", "%#ld"},
  {__LINE__, 0xff1f6daa,	"FF1F6DAA", "%X"},
  {__LINE__, 0xfffffc4e,	"FFFFFC4E", "%5.2X"},
  {__LINE__, -0x000040a,	"-1034", "%d"},
  {__LINE__, -0x0000085,	"-00133", "% 01.5d"},
  {__LINE__, -0x126c797c,	"-309098876", "%5.ld"},
  {__LINE__, 0x00000039,	" 57", "% d"},
  {__LINE__, 0xfffffff6,	"0xfffffff6", "%#5.x"},
  {__LINE__, 0xfffffff4,	"fffffff4", "%7.6x"},
  {__LINE__, 0x00000003,	"3", "%ld"},
  {__LINE__, 0x0000f8ae,	"f8ae", "%.0x"},
  {__LINE__, 0x003ca1cf,	"3973583", "%#3.7d"},
  {__LINE__, 0x14687009,	"0x14687009", "%+#3x"},
  {__LINE__, 0xfffff1f7,	"0xfffff1f7", "%#4.5x"},
  {__LINE__, 0xfffff17a,	"fffff17a", "%3.x"},
  {__LINE__, 0x0011ea18,	"1174040", "%ld"},
  {__LINE__, -0x0000019,	"-25", "%03.d"},
  {__LINE__, 0x00015d72,	"0X15D72", "%-#X"},
  {__LINE__, 0xffde4a41,	"ffde4a41", "%x"},
  {__LINE__, 0x00006f1f,	"28447", "%d"},
  {__LINE__, 0xffffffbd,	"0xffffffbd", "%#.1x"},
  {__LINE__, 0x000013b9,	"13B9", "%0X"},
  {__LINE__, -0x00001b9,	"-00441", "%1.5d"},
  {__LINE__, 0x00000001,	"000001", "%-.6d"},
  {__LINE__, 0x7b602d8f,	"+2069900687", "%+0ld"},
  {__LINE__, 0x0005e323,	"+385827", "%+ld"},
  {__LINE__, 0x00002fce,	"2FCE", "%+0X"},
  {__LINE__, 0x0000000e,	"0014", "%.4d"},
  {__LINE__, 0xffffffd6,	"0XFFFFFFD6", "%#4.X"},
  {__LINE__, 0x037bf361,	"58454881", "%5.ld"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%-7.5X"},
  {__LINE__, -0x016d4dc,	"-1496284", "%6ld"},
  {__LINE__, 0x0005be9a,	"0x5be9a", "%-#.5x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%1x"},
  {__LINE__, 0x00000055,	"     85", "% 7.d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, -0x0135392,	"-1266578", "% ld"},
  {__LINE__, 0x00850f26,	"8720166", "%d"},
  {__LINE__, 0xffffee39,	"ffffee39", "%0x"},
  {__LINE__, 0x000000dd,	"221", "%ld"},
  {__LINE__, 0x00000000,	"      ", "%6.d"},
  {__LINE__, 0x000000d8,	"d8", "%x"},
  {__LINE__, 0x000007ec,	"002028", "%4.6ld"},
  {__LINE__, 0x0dab4e67,	"0XDAB4E67", "%#X"},
  {__LINE__, 0xfffd7c95,	"FFFD7C95", "% 4X"},
  {__LINE__, 0x0009302d,	"9302D", "%3.1X"},
  {__LINE__, 0x00000003,	" 3", "% d"},
  {__LINE__, 0x0000082f,	"82f", "%-x"},
  {__LINE__, 0x0652517f,	"652517F", "%-.2X"},
  {__LINE__, -0x1fd8f4e3,	"-534312163", "%d"},
  {__LINE__, 0x00000176,	"176", "%-x"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, 0x0000001a,	"1A", "%X"},
  {__LINE__, -0x0005740,	"-22336", "% 0ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%6x"},
  {__LINE__, 0x1b273b80,	"0x1b273b80", "%#x"},
  {__LINE__, 0x00000065,	"65", "%X"},
  {__LINE__, 0x6a62138a,	"1784812426", "%2ld"},
  {__LINE__, 0x000001a2,	"1A2", "%X"},
  {__LINE__, -0x002aafd,	"-174845", "%02.ld"},
  {__LINE__, 0x00000014,	"20", "%d"},
  {__LINE__, -0x00000c7,	"   -199", "%7.0ld"},
  {__LINE__, 0xff545bfd,	"ff545bfd", "%-x"},
  {__LINE__, -0x002beb9,	"-179897", "%02.2ld"},
  {__LINE__, -0x00000df,	"-223", "% 02.d"},
  {__LINE__, -0x000d569,	"-54633", "%1.ld"},
  {__LINE__, 0x0000000e,	"14", "%d"},
  {__LINE__, -0x0077407,	"-488455", "% ld"},
  {__LINE__, 0x0001be09,	"114185", "%ld"},
  {__LINE__, -0x0000514,	"-01300", "%+05.5d"},
  {__LINE__, 0xf1fb397f,	"f1fb397f", "%+x"},
  {__LINE__, 0xfdb6707c,	"FDB6707C", "%X"},
  {__LINE__, 0x03cad111,	"3cad111", "%5.x"},
  {__LINE__, -0x022e72f,	"-2287407", "%d"},
  {__LINE__, -0xda35f48,	"-228810568", "%d"},
  {__LINE__, -0x02d1fd4,	"-2957268", "%1.3d"},
  {__LINE__, 0x0000005f,	"+95", "%+2d"},
  {__LINE__, 0xfffbf8a1,	"FFFBF8A1", "%4.2X"},
  {__LINE__, 0x0000071e,	"   71e", "%6.x"},
  {__LINE__, 0x000cc8a5,	"+837797", "%+03ld"},
  {__LINE__, 0x000eebe9,	" EEBE9", "%6.X"},
  {__LINE__, -0x2896b204,	"-680964612", "%d"},
  {__LINE__, -0x09553f8,	"-9786360", "%d"},
  {__LINE__, 0x000015d3,	"5587", "%0d"},
  {__LINE__, 0x0000056d,	" 56d", "%+4.x"},
  {__LINE__, -0x00624ad,	"-402605", "% ld"},
  {__LINE__, 0xfea64ba5,	"0xfea64ba5", "%#1x"},
  {__LINE__, 0x004f35c6,	"5191110", "%-ld"},
  {__LINE__, -0x1441fe4,	"-21241828", "%d"},
  {__LINE__, 0xffffff95,	"FFFFFF95", "%X"},
  {__LINE__, 0xfffecf81,	"FFFECF81", "%-2.X"},
  {__LINE__, -0x00002bb,	"-699", "%-d"},
  {__LINE__, -0x0000c29,	"-3113", "% 02ld"},
  {__LINE__, 0x000026a3,	" 9891", "% .4d"},
  {__LINE__, 0x00000003,	"3", "%-x"},
  {__LINE__, 0x000007db,	"+02011", "%+.5ld"},
  {__LINE__, 0xfff99558,	"FFF99558", "%.1X"},
  {__LINE__, 0x0000fce6,	"64742", "%4.0d"},
  {__LINE__, 0x000b7ea2,	"753314", "%ld"},
  {__LINE__, 0x13e5df30,	"0X13E5DF30", "%#2.X"},
  {__LINE__, 0x006761c4,	"06761C4", "%6.7X"},
  {__LINE__, 0xffffff78,	"FFFFFF78", "%0.X"},
  {__LINE__, 0xfffff1c0,	"0xfffff1c0", "% #x"},
  {__LINE__, -0x034af1c,	"-3452700", "% 06.1d"},
  {__LINE__, 0x000000de,	"0000222", "%2.7ld"},
  {__LINE__, 0x000003d8,	"0x3d8", "%#4.x"},
  {__LINE__, -0x001a1d1,	"-106961", "%3.1d"},
  {__LINE__, -0x0000002,	"-2", "% d"},
  {__LINE__, 0x00001de6,	"+7654", "%+0ld"},
  {__LINE__, 0x00000001,	"001", "%#.3d"},
  {__LINE__, -0x53dacf9f,	"-1406848927", "%ld"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%3.3x"},
  {__LINE__, -0x00950e8,	"-610536", "%3.6ld"},
  {__LINE__, 0xff14ade9,	"FF14ADE9", "%6X"},
  {__LINE__, 0x012f5284,	"0X12F5284", "% #5X"},
  {__LINE__, 0x00005a21,	" 5a21", "%5x"},
  {__LINE__, 0x00000638,	"1592", "%2.4ld"},
  {__LINE__, -0x063017b,	"-6488443", "%ld"},
  {__LINE__, 0x00000000,	"0", "% X"},
  {__LINE__, 0xfffe8ef2,	"FFFE8EF2", "%+0X"},
  {__LINE__, -0x0001c96,	"-7318", "%.3d"},
  {__LINE__, 0x0000ca7d,	"51837", "%ld"},
  {__LINE__, 0x00000001,	"1", "%+1x"},
  {__LINE__, 0xfffff7bc,	"FFFFF7BC", "%X"},
  {__LINE__, -0x03d15e2,	"-4003298", "%ld"},
  {__LINE__, 0xfffffffe,	"fffffffe", "% x"},
  {__LINE__, 0x00066183,	"+418179", "%+7.1ld"},
  {__LINE__, 0xffffef2e,	"ffffef2e", "%-2.x"},
  {__LINE__, 0x00000000,	" 000", "%04.3x"},
  {__LINE__, -0x000000f,	"-15", "% d"},
  {__LINE__, -0x00001f5,	"-501", "%d"},
  {__LINE__, 0x0c67f159,	"c67f159", "%6.2x"},
  {__LINE__, -0x0000006,	"-6", "%.1d"},
  {__LINE__, 0x00000005,	"0X5", "%+#1X"},
  {__LINE__, -0x0000002,	"    -2", "%6.ld"},
  {__LINE__, 0xeb2183ec,	"eb2183ec", "% x"},
  {__LINE__, -0x5e12a322,	"-1578279714", "%d"},
  {__LINE__, 0x00000001,	"0x1", "%#x"},
  {__LINE__, -0x0001ea4,	"-7844", "%0d"},
  {__LINE__, -0x19955a3,	"-26826147", "%d"},
  {__LINE__, 0x000002a6,	"2A6", "%2.X"},
  {__LINE__, 0x00000002,	"2", "%X"},
  {__LINE__, 0xfffffeec,	"fffffeec", "%0.4x"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%0x"},
  {__LINE__, 0xffdfe740,	"FFDFE740", "% X"},
  {__LINE__, -0x0b0b3e7,	"-11580391", "%.1d"},
  {__LINE__, 0x8e01077c,	"8E01077C", "%5.7X"},
  {__LINE__, 0x3b6b6d55,	"996896085", "%1.1d"},
  {__LINE__, 0x000016af,	"5807", "%ld"},
  {__LINE__, -0x0004900,	"-18688", "%d"},
  {__LINE__, 0xfffd77bc,	"FFFD77BC", "%X"},
  {__LINE__, 0x004cbd74,	"5029236", "%0d"},
  {__LINE__, 0x00000003,	" 00003", "%6.5d"},
  {__LINE__, 0x0004720f,	"4720f", "% x"},
  {__LINE__, 0x0e44535d,	"e44535d", "%4x"},
  {__LINE__, 0xfffffff9,	"FFFFFFF9", "%3.3X"},
  {__LINE__, -0x0000005,	"-5", "%-d"},
  {__LINE__, 0x000001a6,	"00001A6", "%1.7X"},
  {__LINE__, 0x0000004a,	"4A", "%-2.X"},
  {__LINE__, 0xfffff249,	"FFFFF249", "%X"},
  {__LINE__, 0x00004345,	"4345", "%x"},
  {__LINE__, 0x0197041d,	"197041d", "%+0x"},
  {__LINE__, 0x0000019a,	"   19a", "% 6.x"},
  {__LINE__, 0xfff98376,	"FFF98376", "%X"},
  {__LINE__, 0xfc536c41,	"FC536C41", "%X"},
  {__LINE__, -0x0008d91,	"-36241", "% d"},
  {__LINE__, 0xf058d69d,	"f058d69d", "%4.x"},
  {__LINE__, -0x00013ef,	"-5103", "%d"},
  {__LINE__, -0x0000003,	"-3", "%00ld"},
  {__LINE__, -0x09e80f0,	"-10387696", "%+07ld"},
  {__LINE__, -0x0222c15,	"-2239509", "%#0.4ld"},
  {__LINE__, 0x00000004,	"4", "%0ld"},
  {__LINE__, -0x02c6b0d,	"-2910989", "% 0ld"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%-4X"},
  {__LINE__, 0xffffff3d,	"FFFFFF3D", "%-.0X"},
  {__LINE__, -0x0000015,	"-21", "%0d"},
  {__LINE__, 0x131dfc90,	"+320732304", "%+d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%+x"},
  {__LINE__, 0x000035c8,	"13768", "%0ld"},
  {__LINE__, 0x00000033,	"0x0033", "%#.4x"},
  {__LINE__, 0x0ce7e8c1,	"0xce7e8c1", "%#.7x"},
  {__LINE__, 0xfc18b5d2,	"FC18B5D2", "%+.3X"},
  {__LINE__, 0x00000015,	"21", "%d"},
  {__LINE__, 0x001a5e7c,	"1a5e7c", "%05x"},
  {__LINE__, -0x000fbf0,	"-64496", "%ld"},
  {__LINE__, -0x000a4f7,	"-042231", "%+2.6d"},
  {__LINE__, -0x0000002,	"-002", "%3.3ld"},
  {__LINE__, 0x00728878,	"728878", "%0X"},
  {__LINE__, -0x0000002,	"-2", "%#.1ld"},
  {__LINE__, -0x00002ef,	"-751", "%-0ld"},
  {__LINE__, 0xfffffff7,	"fffffff7", "%.3x"},
  {__LINE__, 0x00491867,	"0491867", "%.7X"},
  {__LINE__, 0x00000d4d,	"3405", "%-ld"},
  {__LINE__, 0x00234e86,	"234E86", "%0X"},
  {__LINE__, -0x000001b,	"-27", "%ld"},
  {__LINE__, 0x00275255,	"2576981", "%.5ld"},
  {__LINE__, 0xfeacc214,	"0XFEACC214", "%-#3.X"},
  {__LINE__, -0x0001ce5,	"-7397", "%+#2.2ld"},
  {__LINE__, 0x089ddb6a,	"144563050", "%d"},
  {__LINE__, 0x003d5a95,	"3D5A95", "%1X"},
  {__LINE__, 0x002f0b6d,	"3083117", "%d"},
  {__LINE__, 0x1e79e228,	"511304232", "%ld"},
  {__LINE__, 0xfffffe6b,	"FFFFFE6B", "%+0X"},
  {__LINE__, -0x5104ff3,	"-84955123", "%.4ld"},
  {__LINE__, 0xfffff1de,	"FFFFF1DE", "%X"},
  {__LINE__, 0x000000cf,	"+207", "%+.1ld"},
  {__LINE__, -0x16ad0164,	"-380436836", "%+5.d"},
  {__LINE__, 0x001fefa6,	"2092966", "%ld"},
  {__LINE__, 0x00000000,	"00", "%-.2d"},
  {__LINE__, 0x00195f45,	"195f45", "%+0x"},
  {__LINE__, 0x00000001,	"  1", "%3.ld"},
  {__LINE__, -0x00001c9,	"-457", "% ld"},
  {__LINE__, 0x0002479e,	"149406", "%#ld"},
  {__LINE__, 0x001ab18b,	"1749387", "%04d"},
  {__LINE__, 0x00000045,	"69", "%ld"},
  {__LINE__, 0xfbb13f7d,	"fbb13f7d", "%.2x"},
  {__LINE__, 0x03ddc208,	"3ddc208", "%x"},
  {__LINE__, 0x00000007,	"000007", "%#.6d"},
  {__LINE__, 0x00000000,	"0", "%01X"},
  {__LINE__, -0x0023110,	"-143632", "%+0.3d"},
  {__LINE__, 0x00000006,	"06", "%#.2d"},
  {__LINE__, 0xffff9ec9,	"ffff9ec9", "%7x"},
  {__LINE__, -0x08afb12,	"-9108242", "% #0.ld"},
  {__LINE__, 0x00000004,	"4", "%X"},
  {__LINE__, 0x00059684,	"59684", "%x"},
  {__LINE__, 0xfff8d8f5,	"FFF8D8F5", "%X"},
  {__LINE__, 0x00b7027d,	"+11993725", "%+0.7ld"},
  {__LINE__, 0x0000d814,	"55316", "%0ld"},
  {__LINE__, 0x03c95a08,	"3c95a08", "%3x"},
  {__LINE__, -0x0b65f9a,	"-11952026", "%d"},
  {__LINE__, 0xfd956021,	"fd956021", "%0x"},
  {__LINE__, 0x000000ed,	"ed", "%0x"},
  {__LINE__, -0x006a80c,	"-436236", "%.6ld"},
  {__LINE__, 0xfedb109d,	"fedb109d", "%x"},
  {__LINE__, 0x00000001,	"1", "%X"},
  {__LINE__, 0x00b3eb71,	" 11791217", "% d"},
  {__LINE__, 0x00000016,	"16", "%0X"},
  {__LINE__, 0x000001db,	" 475", "% ld"},
  {__LINE__, 0x00465eaf,	"4611759", "%0d"},
  {__LINE__, 0x0001b423,	"1B423", "%0X"},
  {__LINE__, 0x05df95ea,	"5df95ea", "%+.5x"},
  {__LINE__, 0x0000000e,	"     14", "%7ld"},
  {__LINE__, 0xffffb89e,	"ffffb89e", "%+x"},
  {__LINE__, 0x01259918,	" 19241240", "% d"},
  {__LINE__, -0x0000f8d,	"-003981", "%+#.6d"},
  {__LINE__, 0x00054ae0,	"54AE0", "%X"},
  {__LINE__, -0x4589ed4,	"-72916692", "% ld"},
  {__LINE__, 0x01017516,	"1017516", "%6X"},
  {__LINE__, 0xfffb9f15,	"FFFB9F15", "%.2X"},
  {__LINE__, 0x005f8394,	"5F8394", "%.2X"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, -0x0000001,	"     -1", "%7.1ld"},
  {__LINE__, 0x004367af,	"4417455", "%4.ld"},
  {__LINE__, 0xffffff86,	"ffffff86", "%4.5x"},
  {__LINE__, -0x0000d17,	"-3351", "%2.0ld"},
  {__LINE__, 0xffffff31,	"ffffff31", "%.6x"},
  {__LINE__, -0x0000001,	"-1", "%ld"},
  {__LINE__, -0x3d785fab,	"-1031298987", "%d"},
  {__LINE__, -0x0000002,	"-2", "%-0ld"},
  {__LINE__, 0x0000019c,	"412", "%d"},
  {__LINE__, -0x0006f54,	"-28500", "%d"},
  {__LINE__, 0xfffe3524,	"FFFE3524", "% 6.2X"},
  {__LINE__, -0x128d3c00,	"-311245824", "%2d"},
  {__LINE__, -0x3be71293,	"-1004999315", "%d"},
  {__LINE__, 0x0000659d,	"26013", "%d"},
  {__LINE__, 0x2d947538,	"+764704056", "%+5d"},
  {__LINE__, 0xffa2a420,	"FFA2A420", "%0X"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, 0x04477c14,	"4477c14", "%.6x"},
  {__LINE__, -0x06e145b,	"-7214171", "%d"},
  {__LINE__, 0x00009c01,	"39937", "%-.1d"},
  {__LINE__, 0xffde174b,	"ffde174b", "% 0x"},
  {__LINE__, 0x0001fbae,	"1FBAE", "%01.X"},
  {__LINE__, -0x06b8406,	"-7046150", "%d"},
  {__LINE__, 0x000005b8,	"005b8", "%05x"},
  {__LINE__, -0x02d780b,	"-2979851", "%1d"},
  {__LINE__, 0x00209e26,	"2137638", "%2d"},
  {__LINE__, 0x0000041a,	"41A", "%0X"},
  {__LINE__, 0x2a77f42c,	"2A77F42C", "%02X"},
  {__LINE__, 0x13b6ee14,	"+330755604", "%+0d"},
  {__LINE__, -0x0000002,	"-2    ", "%-6.d"},
  {__LINE__, -0x0001eee,	"-7918", "% #2.ld"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "% .5X"},
  {__LINE__, 0x20d11927,	"20d11927", "% 0.x"},
  {__LINE__, -0x0018690,	"-99984", "% ld"},
  {__LINE__, 0x000002a0,	"2A0", "%-0X"},
  {__LINE__, -0x0000511,	"-1297", "%+d"},
  {__LINE__, 0x0e782f31,	"242757425", "%-0.ld"},
  {__LINE__, 0x2ce06da0,	"752905632", "%#0ld"},
  {__LINE__, 0x00000062,	"62     ", "%-07x"},
  {__LINE__, -0x015d9d8,	"-1432024", "% 7d"},
  {__LINE__, 0xc9125ea8,	"c9125ea8", "%x"},
  {__LINE__, 0x00000006,	"6", "%.0ld"},
  {__LINE__, 0x0000019c,	"19c", "%x"},
  {__LINE__, 0x00000000,	"      ", "%6.d"},
  {__LINE__, 0x00043e89,	"278153", "%0ld"},
  {__LINE__, 0x3e422abd,	"1044523709", "%ld"},
  {__LINE__, 0x0220a75d,	"35694429", "%#7.6d"},
  {__LINE__, 0x0000c21c,	"C21C", "% X"},
  {__LINE__, 0x000074ab,	"29867", "%d"},
  {__LINE__, 0x056b22aa,	"56B22AA", "%+0.X"},
  {__LINE__, 0xfffffff9,	"FFFFFFF9", "%X"},
  {__LINE__, 0x00000000,	"0", "%X"},
  {__LINE__, 0xf094a4f4,	"f094a4f4", "%+4.x"},
  {__LINE__, -0x1dad0244,	"-497877572", "%d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%.1X"},
  {__LINE__, 0xfffffe2d,	"fffffe2d", "%7.x"},
  {__LINE__, 0x0000042b,	"0x42b", "%#x"},
  {__LINE__, -0x0000001,	"-1", "% d"},
  {__LINE__, 0x00e77ef5,	" 15171317", "% 7.ld"},
  {__LINE__, 0x00006210,	" 25104", "% 06d"},
  {__LINE__, 0x0011187a,	"1120378", "%-ld"},
  {__LINE__, -0x000000b,	"-11", "% #ld"},
  {__LINE__, 0x14cfaff0,	"14cfaff0", "%-2.3x"},
  {__LINE__, 0xffff74ea,	"FFFF74EA", "%3.X"},
  {__LINE__, 0x000bfb9d,	"bfb9d", "%x"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%X"},
  {__LINE__, 0x00014500,	"0X14500", "%#4.X"},
  {__LINE__, -0x0000001,	"-1", "%#1d"},
  {__LINE__, -0x0000024,	"-36", "%-0d"},
  {__LINE__, -0x6528828,	"-106072104", "%d"},
  {__LINE__, 0x00000075,	" 117", "% #d"},
  {__LINE__, 0xff027d67,	"ff027d67", "%0x"},
  {__LINE__, 0x0012b8b3,	"12b8b3", "%0.1x"},
  {__LINE__, 0x1070147b,	"275780731", "%.6ld"},
  {__LINE__, 0xffffe88e,	"FFFFE88E", "%1.3X"},
  {__LINE__, 0xfffffc0d,	"fffffc0d", "%00.6x"},
  {__LINE__, 0xffd889f5,	"ffd889f5", "%x"},
  {__LINE__, 0x00000470,	"1136", "%0ld"},
  {__LINE__, 0x000297f8,	"169976", "%ld"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%+1x"},
  {__LINE__, 0x0000064a,	"64a", "%x"},
  {__LINE__, -0x3d71e43b,	"-1030874171", "%1.d"},
  {__LINE__, -0x0000004,	"-4 ", "%-3.d"},
  {__LINE__, 0xfffff132,	"FFFFF132", "%0.0X"},
  {__LINE__, 0x37b6356f,	"37b6356f", "%-x"},
  {__LINE__, 0xffffff7a,	"FFFFFF7A", "%.0X"},
  {__LINE__, 0x00023553,	"23553", "%x"},
  {__LINE__, 0x39a4c29f,	"39a4c29f", "%+5.x"},
  {__LINE__, 0xffffffcc,	"ffffffcc", "%x"},
  {__LINE__, 0x0003a83b,	"239675", "%#6ld"},
  {__LINE__, 0x00000002,	"2", "%0x"},
  {__LINE__, -0x09b4e8c,	"-10178188", "%+03.ld"},
  {__LINE__, 0x00000002,	"0000002", "%-#.7ld"},
  {__LINE__, 0x00000b5e,	"2910", "%-04ld"},
  {__LINE__, -0x0000254,	"-596", "%+0d"},
  {__LINE__, 0x00000001,	"1", "%+1.x"},
  {__LINE__, 0xf8290d3e,	"0XF8290D3E", "% #X"},
  {__LINE__, 0x00000035,	"035", "%3.3X"},
  {__LINE__, 0x00131d7d,	"131D7D ", "%-7.6X"},
  {__LINE__, 0xffdbb36a,	"0xffdbb36a", "%#.6x"},
  {__LINE__, 0xc7275816,	"c7275816", "%04.x"},
  {__LINE__, 0x00bae994,	"12249492", "%0ld"},
  {__LINE__, 0x00000002,	"+2", "%+0.0ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%0x"},
  {__LINE__, 0xffffffe0,	"ffffffe0", "%x"},
  {__LINE__, 0x00000036,	"36", "%.0X"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%1X"},
  {__LINE__, 0xffffffc8,	"ffffffc8", "%+x"},
  {__LINE__, 0xe71c3689,	"e71c3689", "%x"},
  {__LINE__, 0x00000007,	"7  ", "%-3.ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, 0x00030400,	"030400", "%-4.6x"},
  {__LINE__, 0xbd8c6fa7,	"BD8C6FA7", "%-6X"},
  {__LINE__, 0x00000233,	"0000563", "%.7ld"},
  {__LINE__, 0xfef92e35,	"fef92e35", "%x"},
  {__LINE__, 0xffff2172,	"ffff2172", "%3x"},
  {__LINE__, 0x00001233,	"1233", "% X"},
  {__LINE__, -0x000d2e1,	"-53985", "%-0d"},
  {__LINE__, -0x3ba8cb5b,	"-1000917851", "%0d"},
  {__LINE__, -0x4fefb9a,	"-83819418", "%5.ld"},
  {__LINE__, 0xffffe9eb,	"FFFFE9EB", "%X"},
  {__LINE__, 0x1e472dc3,	"507981251", "%ld"},
  {__LINE__, -0x0077046,	"-487494", "%0d"},
  {__LINE__, 0x0002c4c9,	"+181449", "%+7.d"},
  {__LINE__, 0xfffffe63,	"fffffe63", "%x"},
  {__LINE__, 0xfff5a6db,	"FFF5A6DB", "%X"},
  {__LINE__, 0x00174442,	"174442", "%-5.0X"},
  {__LINE__, 0x017891d9,	"17891D9", "%+5.X"},
  {__LINE__, 0x0261966b,	"261966B", "%-X"},
  {__LINE__, -0x3e58614d,	"-1045979469", "%ld"},
  {__LINE__, 0x002c4c41,	"+2903105", "%+01ld"},
  {__LINE__, 0x0000000c,	"012", "%#.3d"},
  {__LINE__, 0x0380f73a,	"58783546", "%ld"},
  {__LINE__, 0x000002c7,	"0000711", "%2.7ld"},
  {__LINE__, 0x00000002,	" 002", "% 04ld"},
  {__LINE__, 0x00687ca0,	"687CA0", "%X"},
  {__LINE__, 0x0000058a,	"1418", "%0ld"},
  {__LINE__, -0x0000642,	"-1602", "% ld"},
  {__LINE__, 0x0001f4f1,	"1F4F1", "%X"},
  {__LINE__, 0x0026d6fc,	"+2545404", "%+4.ld"},
  {__LINE__, 0x05dd423c,	"+98386492", "%+#ld"},
  {__LINE__, 0x0000782c,	"0782C", "%3.5X"},
  {__LINE__, 0xf67d91f8,	"f67d91f8", "%-x"},
  {__LINE__, 0xffffcf2d,	"ffffcf2d", "%+0x"},
  {__LINE__, -0x00af8a6,	"-719014", "%0ld"},
  {__LINE__, -0xe606ef9,	"-241200889", "%ld"},
  {__LINE__, 0xfe9d87f7,	"fe9d87f7", "%+x"},
  {__LINE__, 0x00000d44,	"d44", "% 1.x"},
  {__LINE__, 0x008716f5,	"8716f5", "%2x"},
  {__LINE__, 0x000027d4,	"27D4", "% X"},
  {__LINE__, 0xfdfd92ea,	"FDFD92EA", "%-.4X"},
  {__LINE__, 0xfffe764f,	"FFFE764F", "%X"},
  {__LINE__, 0xff699032,	"ff699032", "%3.x"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%-3X"},
  {__LINE__, -0x368ba995,	"-915122581", "%+#.6ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%0x"},
  {__LINE__, 0x0000035e,	" 862", "% 1d"},
  {__LINE__, 0xfe703e67,	"fe703e67", "%07.0x"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%4.x"},
  {__LINE__, 0x000e20cf,	"e20cf", "%0x"},
  {__LINE__, 0x000063b5,	"0X63B5", "%-#X"},
  {__LINE__, 0xfffffffa,	"fffffffa", "%+2.x"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%2.X"},
  {__LINE__, 0xfdfd69da,	"FDFD69DA", "%.0X"},
  {__LINE__, 0x00002f61,	"0x2f61", "%#3.x"},
  {__LINE__, 0x00000009,	"9", "%x"},
  {__LINE__, 0xffffff86,	"ffffff86", "%6x"},
  {__LINE__, 0xffffffe4,	"ffffffe4", "%0x"},
  {__LINE__, 0x0062e73b,	"+6481723", "%+0ld"},
  {__LINE__, -0x2b059130,	"-721785136", "%+d"},
  {__LINE__, -0x0000073,	"-115", "%d"},
  {__LINE__, 0xf596efcf,	"f596efcf", "%x"},
  {__LINE__, 0x0002f1cb,	"2F1CB", "%0X"},
  {__LINE__, -0x0000635,	"-01589", "%.5ld"},
  {__LINE__, 0xfffa011a,	"FFFA011A", "%0X"},
  {__LINE__, 0x00000047,	"  47", "%4X"},
  {__LINE__, 0xfffffbc0,	"FFFFFBC0", "%5.2X"},
  {__LINE__, 0x00000015,	"15", "% X"},
  {__LINE__, 0x002a87a6,	"2a87a6", "%.1x"},
  {__LINE__, -0x000069c,	"-1692", "%+ld"},
  {__LINE__, 0xfffffffd,	"fffffffd", "%+x"},
  {__LINE__, 0xfeda51f5,	"FEDA51F5", "%0X"},
  {__LINE__, 0x001781a4,	"1781a4", "%-0x"},
  {__LINE__, 0xe77358d4,	"e77358d4", "%+0x"},
  {__LINE__, 0x00000084,	" 84", "%3.x"},
  {__LINE__, 0xffff0cb2,	"FFFF0CB2", "%+5.X"},
  {__LINE__, 0x0009fa17,	"653847", "%0.0ld"},
  {__LINE__, -0x0000c92,	"-3218", "%d"},
  {__LINE__, 0x0004ebbb,	"4ebbb", "%x"},
  {__LINE__, 0x2e72568c,	"+779245196", "%+#ld"},
  {__LINE__, 0xffae86a7,	"ffae86a7", "%.7x"},
  {__LINE__, 0xffdf3f04,	"ffdf3f04", "%x"},
  {__LINE__, 0x000000c7,	"199", "%2.d"},
  {__LINE__, -0x0004a55,	"-19029", "%ld"},
  {__LINE__, 0x00564ef9,	"5656313", "%.6ld"},
  {__LINE__, 0xffffc205,	"ffffc205", "%+.0x"},
  {__LINE__, -0x135085d0,	"-324044240", "%#.5d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%-7x"},
  {__LINE__, -0x0000003,	"-3", "%.1ld"},
  {__LINE__, 0xffda9e0b,	"ffda9e0b", "%+0x"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, 0xffffffda,	"ffffffda", "%.6x"},
  {__LINE__, 0x5efdb3d1,	"+1593684945", "%+0d"},
  {__LINE__, -0x00000ca,	"-202", "% 4.d"},
  {__LINE__, -0x0014433,	"-82995", "%.3d"},
  {__LINE__, -0x0000002,	"-000002", "% .6ld"},
  {__LINE__, 0x24aac879,	"615172217", "%.7d"},
  {__LINE__, -0x1db3c1d,	"-31144989", "%+#4ld"},
  {__LINE__, 0x000945ad,	"0x945ad", "%#1x"},
  {__LINE__, 0x0000000a,	"10", "%#.1ld"},
  {__LINE__, -0x002a2e5,	"-172773", "%d"},
  {__LINE__, 0xfffffff3,	"FFFFFFF3", "%5X"},
  {__LINE__, 0x0000000e,	"e", "%+x"},
  {__LINE__, 0x335333dc,	"861090780", "%6.d"},
  {__LINE__, 0xfffa16f4,	"FFFA16F4", "%6X"},
  {__LINE__, 0xffffc727,	"ffffc727", "%+2.x"},
  {__LINE__, 0x00000273,	"273", "%x"},
  {__LINE__, -0x000000f,	"-15", "%-0d"},
  {__LINE__, 0x00065fbd,	"417725", "%5.1d"},
  {__LINE__, 0x00000ed5,	"3797", "%d"},
  {__LINE__, 0x30a40024,	"30A40024", "%3.7X"},
  {__LINE__, 0x00000054,	"84", "%ld"},
  {__LINE__, 0x00000515,	"01301", "%.5ld"},
  {__LINE__, 0x00000897,	"+02199", "%+.5d"},
  {__LINE__, -0x0001bcc,	"-7116", "% ld"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%7X"},
  {__LINE__, 0x00000013,	"0X13", "%#X"},
  {__LINE__, 0xffffffff,	"0xffffffff", "% #x"},
  {__LINE__, 0x00000006,	"6", "%ld"},
  {__LINE__, -0x00000c3,	"-195", "%1.ld"},
  {__LINE__, -0x005291e,	"-338206", "%+d"},
  {__LINE__, 0xffb437a7,	"FFB437A7", "%-0X"},
  {__LINE__, 0xff8335cb,	"ff8335cb", "%x"},
  {__LINE__, 0x0000006a,	"6A", "%2X"},
  {__LINE__, -0x004f629,	"-325161", "% .4d"},
  {__LINE__, 0x003698ef,	"3578095", "%0ld"},
  {__LINE__, 0x6b5cdf3a,	"6b5cdf3a", "%-x"},
  {__LINE__, 0xe9bc5c21,	"e9bc5c21", "%+x"},
  {__LINE__, -0x0000001,	"    -1", "%+6.ld"},
  {__LINE__, 0xfffeffc8,	"FFFEFFC8", "%6.X"},
  {__LINE__, 0xff070a73,	"ff070a73", "%+.7x"},
  {__LINE__, 0x0023f8ae,	"2357422", "%07.4ld"},
  {__LINE__, 0x00000000,	"0", "%X"},
  {__LINE__, 0x00000016,	"16", "%0X"},
  {__LINE__, -0x000005a,	" -90", "%4d"},
  {__LINE__, 0x00000116,	"116", "% .3x"},
  {__LINE__, 0xfffed024,	"fffed024", "%-x"},
  {__LINE__, 0xfb907950,	"fb907950", "%.0x"},
  {__LINE__, 0x0101a1e5,	"101a1e5", "%x"},
  {__LINE__, -0x09e7684,	"-10385028", "%-#ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%1x"},
  {__LINE__, 0xfffffff6,	"fffffff6", "%x"},
  {__LINE__, 0x00000078,	"78", "%x"},
  {__LINE__, 0xe6bca9c9,	"0XE6BCA9C9", "%#.5X"},
  {__LINE__, -0x0000010,	"-16", "%d"},
  {__LINE__, -0x1348f685,	"-323548805", "%d"},
  {__LINE__, 0x4dd85797,	"1306023831", "%ld"},
  {__LINE__, -0x0000080,	"-128", "%.2d"},
  {__LINE__, -0xaed13a7,	"-183309223", "%+ld"},
  {__LINE__, -0x000002f,	"-47", "% d"},
  {__LINE__, -0x679911f,	"-108630303", "%ld"},
  {__LINE__, 0xfffff221,	"FFFFF221", "% .7X"},
  {__LINE__, 0x0007476c,	"7476c", "%x"},
  {__LINE__, 0xffffe02a,	"0xffffe02a", "%#7x"},
  {__LINE__, 0x00000ebb,	"0XEBB", "%#X"},
  {__LINE__, 0xffffffff,	"0XFFFFFFFF", "%-#X"},
  {__LINE__, 0x00281896,	"281896", "%+1.x"},
  {__LINE__, 0x0000085d,	" 0X85D", "%#6.3X"},
  {__LINE__, 0x000112bf,	"112BF", "%X"},
  {__LINE__, 0xf5518fbf,	"F5518FBF", "% X"},
  {__LINE__, -0x00c945b,	"-824411", "%ld"},
  {__LINE__, 0x00001b43,	"0x1b43", "%-#x"},
  {__LINE__, -0x5872a246,	"-1483907654", "%#7.7ld"},
  {__LINE__, 0x00001f96,	"8086", "%#d"},
  {__LINE__, 0xfffffff9,	"FFFFFFF9", "%X"},
  {__LINE__, -0x006e244,	"-451140", "% .3d"},
  {__LINE__, -0x0382188,	"-3678600", "%0.2ld"},
  {__LINE__, 0x00000006,	"6", "%-x"},
  {__LINE__, 0x00000036,	"54   ", "%-5.d"},
  {__LINE__, -0x0000439,	" -1081", "%#6.3ld"},
  {__LINE__, 0xfff911c6,	"FFF911C6", "%X"},
  {__LINE__, -0x03454dc,	"-3429596", "%d"},
  {__LINE__, -0x0363e8d,	"-3554957", "%-.2ld"},
  {__LINE__, 0x00000000,	"000", "%.3X"},
  {__LINE__, -0x59bb030f,	"-1505428239", "%0ld"},
  {__LINE__, 0x073c94d8,	"121410776", "%-d"},
  {__LINE__, -0x001ef94,	"-126868", "%5.1ld"},
  {__LINE__, 0xfff65fc5,	"FFF65FC5", "%0X"},
  {__LINE__, 0xfffffff4,	"fffffff4", "%-x"},
  {__LINE__, 0x00001d83,	"07555", "%5.5d"},
  {__LINE__, 0x0012b40a,	"1225738", "%ld"},
  {__LINE__, -0x0000006,	"-6", "%0ld"},
  {__LINE__, 0xfffffffc,	"fffffffc", "%06.0x"},
  {__LINE__, -0x0000002,	"-00002", "%#.5ld"},
  {__LINE__, 0xf9932c1d,	"f9932c1d", "%-x"},
  {__LINE__, -0x46a31d9,	"-74068441", "%.3ld"},
  {__LINE__, 0x000987e9,	"987E9", "%1X"},
  {__LINE__, 0x0000000f,	"15", "%-ld"},
  {__LINE__, -0x0001c4d,	"-7245", "%ld"},
  {__LINE__, -0x007deee,	"-515822", "%2.6d"},
  {__LINE__, 0xffffffa2,	"FFFFFFA2", "%.6X"},
  {__LINE__, 0x00000001,	"1", "%-ld"},
  {__LINE__, 0xfc106bde,	"fc106bde", "%.4x"},
  {__LINE__, 0x0002f1f8,	"0x2f1f8", "%#7.x"},
  {__LINE__, -0x06a290b,	"-6957323", "%-ld"},
  {__LINE__, -0x0000037,	" -55", "%4ld"},
  {__LINE__, 0x0000152e,	"5422", "%2.d"},
  {__LINE__, 0xfffffcb2,	"0XFFFFFCB2", "%#3.X"},
  {__LINE__, 0x1b7ca086,	"1b7ca086", "%+x"},
  {__LINE__, 0x00000001,	"1", "%ld"},
  {__LINE__, 0x006775fc,	"6775fc", "%3.2x"},
  {__LINE__, 0x0000000e,	"0XE", "%#3.X"},
  {__LINE__, 0xffffffff,	"0xffffffff", "%+#4.x"},
  {__LINE__, 0x00001246,	"1246", "%X"},
  {__LINE__, 0xffffaed6,	"ffffaed6", "%2x"},
  {__LINE__, -0x3a2dec78,	"-976088184", "% 0ld"},
  {__LINE__, 0x0001423b,	"1423b", "%01x"},
  {__LINE__, 0x00000007,	" 0X7", "%#4.X"},
  {__LINE__, 0x01a7ff5a,	"27787098", "%.4ld"},
  {__LINE__, -0x0020d05,	"-134405", "%-d"},
  {__LINE__, 0xffffff9a,	"ffffff9a", "%-.1x"},
  {__LINE__, 0xffff3557,	"ffff3557", "%x"},
  {__LINE__, 0x08828e35,	"8828e35", "%+.1x"},
  {__LINE__, 0x000006b2,	"001714", "%04.6ld"},
  {__LINE__, 0x00000013,	"19", "%.0ld"},
  {__LINE__, -0x00341a5,	"-213413", "%#d"},
  {__LINE__, -0x0000043,	"-67", "%d"},
  {__LINE__, -0x074dce3,	"-7658723", "%.1d"},
  {__LINE__, -0x16de2df3,	"-383659507", "% ld"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0x00000ce7,	"ce7", "% 2.1x"},
  {__LINE__, 0xffecd377,	"ffecd377", "% 0x"},
  {__LINE__, 0xa4e8465c,	"a4e8465c", "% x"},
  {__LINE__, 0x000005e8,	"1512", "%d"},
  {__LINE__, 0x00000513,	"1299", "%d"},
  {__LINE__, 0xffffffb8,	"FFFFFFB8", "%X"},
  {__LINE__, 0x00000003,	"00003", "%3.5x"},
  {__LINE__, -0x0000003,	"-3 ", "%-3.ld"},
  {__LINE__, 0xad53f01d,	"ad53f01d", "%0x"},
  {__LINE__, 0x0f1c1dae,	"253500846", "%-#.0d"},
  {__LINE__, 0xff1753c0,	"0xff1753c0", "%#3.x"},
  {__LINE__, -0x00389c5,	"-231877", "%d"},
  {__LINE__, 0x0000016e,	"00016E", "%.6X"},
  {__LINE__, -0x54d3310f,	"-1423126799", "%-d"},
  {__LINE__, 0x00000005,	"0X5", "%#.1X"},
  {__LINE__, 0xfffffffd,	"0XFFFFFFFD", "%#5.3X"},
  {__LINE__, 0xfffffe0e,	"fffffe0e", "%-x"},
  {__LINE__, 0xa3c02157,	"a3c02157", "%.5x"},
  {__LINE__, 0x00005765,	"22373", "%d"},
  {__LINE__, -0x12668cd,	"-19294413", "%+ld"},
  {__LINE__, -0x66544da,	"-107300058", "%2d"},
  {__LINE__, 0x8646c605,	"0X8646C605", "% #X"},
  {__LINE__, 0x000001f5,	"1F5", "%X"},
  {__LINE__, 0x01b33ae4,	"28523236", "%5ld"},
  {__LINE__, 0x000007ce,	"7ce", "%3.x"},
  {__LINE__, 0x00000355,	"355", "%X"},
  {__LINE__, 0x000001ce,	"1CE", "% X"},
  {__LINE__, 0xfffffccd,	"fffffccd", "%7.0x"},
  {__LINE__, -0x0000001,	"-1", "%0ld"},
  {__LINE__, 0x000640b6,	"640b6", "%5.x"},
  {__LINE__, 0x0038c4ec,	"3720428", "%5.4d"},
  {__LINE__, -0x0f10b5e,	"-15797086", "%2ld"},
  {__LINE__, 0x256c815f,	"256c815f", "%4.x"},
  {__LINE__, 0x00000682,	"  1666", "%6ld"},
  {__LINE__, -0x00000ab,	"-171", "%2ld"},
  {__LINE__, 0x00000003,	"3", "%0d"},
  {__LINE__, 0x063f5075,	"63F5075", "%X"},
  {__LINE__, 0xff83b5d0,	"FF83B5D0", "%7.X"},
  {__LINE__, 0xffffffec,	"ffffffec", "%x"},
  {__LINE__, 0xffb551c4,	"0XFFB551C4", "% #4.X"},
  {__LINE__, -0x071f057,	"-7467095", "%3.7d"},
  {__LINE__, 0x00634879,	"6506617", "%#ld"},
  {__LINE__, 0x000001d7,	"471", "%d"},
  {__LINE__, 0x00a7da92,	"A7DA92", "% .4X"},
  {__LINE__, 0x00000003,	"3 ", "%-2.ld"},
  {__LINE__, -0x0000004,	"-0004", "%.4d"},
  {__LINE__, -0x01dea32,	"-1960498", "% #7.d"},
  {__LINE__, 0x53c4159f,	"53C4159F", "%1.7X"},
  {__LINE__, -0x1ad7904,	"-28145924", "%#d"},
  {__LINE__, -0x0000a85,	"-2693", "%ld"},
  {__LINE__, -0x0000c7d,	"-3197", "%d"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%+0X"},
  {__LINE__, 0x00000004,	"00004", "%1.5d"},
  {__LINE__, 0x0000b761,	"46945", "%5ld"},
  {__LINE__, -0x0ee3b2c,	"-15612716", "%.6d"},
  {__LINE__, 0x0677a73d,	"677a73d", "% x"},
  {__LINE__, -0x5f96020,	"-100229152", "% d"},
  {__LINE__, 0x00000000,	"      0", "%#7X"},
  {__LINE__, -0x5d1cb5b,	"-97635163", "% ld"},
  {__LINE__, -0x00a8d8b,	"-691595", "%-0ld"},
  {__LINE__, 0xffffffa2,	"FFFFFFA2", "%X"},
  {__LINE__, 0xffffffc9,	"FFFFFFC9", "%X"},
  {__LINE__, 0x0b180d35,	"B180D35", "%X"},
  {__LINE__, 0xfc0b94ce,	"fc0b94ce", "%.1x"},
  {__LINE__, 0x0012cd7b,	"12CD7B", "% X"},
  {__LINE__, -0x02f1da8,	"-3087784", "%ld"},
  {__LINE__, -0x000a6f9,	"-42745", "%-ld"},
  {__LINE__, -0x000006d,	"-109  ", "%-6d"},
  {__LINE__, 0x00000001,	"+1", "%+0d"},
  {__LINE__, 0x00000001,	"1", "%1d"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%5.x"},
  {__LINE__, -0x00fc4d7,	"-1033431", "%+0.5ld"},
  {__LINE__, 0xffff41b4,	"0xffff41b4", "%#x"},
  {__LINE__, -0x0000d37,	"-3383", "%ld"},
  {__LINE__, 0xffc4e405,	"ffc4e405", "%7x"},
  {__LINE__, 0xffffffb0,	"FFFFFFB0", "%04X"},
  {__LINE__, -0x0054477,	"-345207", "%01.ld"},
  {__LINE__, 0x00512778,	"0x512778", "%#3.0x"},
  {__LINE__, 0x00000007,	"      7", "%7.d"},
  {__LINE__, 0x00000008,	" 00008", "% .5ld"},
  {__LINE__, 0x000053fd,	"21501", "%.4ld"},
  {__LINE__, 0x0000370c,	"370c", "%2x"},
  {__LINE__, -0x44670a7,	"-71725223", "%3d"},
  {__LINE__, 0x00000064,	"   64", "%+5x"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%X"},
  {__LINE__, 0xf7bbf094,	"f7bbf094", "%3x"},
  {__LINE__, 0xfffeb268,	"FFFEB268", "%X"},
  {__LINE__, 0x00001ef0,	"1ef0", "%4.x"},
  {__LINE__, 0x05ad9aa4,	" 95263396", "% 0.ld"},
  {__LINE__, 0xf294dca7,	"F294DCA7", "% 4.X"},
  {__LINE__, -0x0000003,	"-000003", "%.6d"},
  {__LINE__, 0xfff57471,	"fff57471", "% x"},
  {__LINE__, 0x0a848cfd,	"176459005", "%d"},
  {__LINE__, -0x000002e,	"-46", "%.0d"},
  {__LINE__, 0x00000051,	"  +81", "%+5d"},
  {__LINE__, -0x000072b,	"-0001835", "%06.7d"},
  {__LINE__, -0x0000002,	"    -2", "%+#6ld"},
  {__LINE__, 0x00000003,	"3", "%x"},
  {__LINE__, 0xfffd1799,	"FFFD1799", "%6.X"},
  {__LINE__, 0x00000005,	"5", "%ld"},
  {__LINE__, 0x0052138b,	"5378955", "%#7.7ld"},
  {__LINE__, 0x000000c0,	"    192", "% 7ld"},
  {__LINE__, 0x005b26cd,	"5B26CD", "%X"},
  {__LINE__, -0x008df17,	"-581399", "%.4ld"},
  {__LINE__, 0xfffffad8,	"fffffad8", "%-x"},
  {__LINE__, 0x000006a9,	"6a9", "%.0x"},
  {__LINE__, -0x003b7f9,	"-243705", "%+0ld"},
  {__LINE__, 0x005d7ea4,	"6127268", "%ld"},
  {__LINE__, -0x003ccea,	"-249066", "%+.0ld"},
  {__LINE__, 0x0000846f,	"846F", "%X"},
  {__LINE__, 0x00004f79,	"4F79", "%4.X"},
  {__LINE__, 0xe3e1409c,	"E3E1409C", "%-X"},
  {__LINE__, 0x07cce2f4,	"7CCE2F4", "%2.X"},
  {__LINE__, 0x004bcc8b,	"4967563", "%-.5ld"},
  {__LINE__, 0x7d49665e,	"2101962334", "%ld"},
  {__LINE__, 0xfffffffc,	"FFFFFFFC", "%.5X"},
  {__LINE__, 0x0000019e,	"+000414", "%+.6d"},
  {__LINE__, 0x000027ef,	"10223", "%d"},
  {__LINE__, -0x0000261,	"-609", "%3ld"},
  {__LINE__, -0x000000e,	"-14", "% 2.ld"},
  {__LINE__, 0xff3ba3c7,	"ff3ba3c7", "%+5.7x"},
  {__LINE__, 0xffffffc4,	"FFFFFFC4", "%-1.X"},
  {__LINE__, 0xfffc5a70,	"0xfffc5a70", "%#4.4x"},
  {__LINE__, 0x0000d156,	" 53590", "% d"},
  {__LINE__, -0x0486258,	"-4743768", "%0ld"},
  {__LINE__, 0x00000000,	"  ", "% 2.d"},
  {__LINE__, 0x04a0ef9f,	"77655967", "%0.6ld"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%X"},
  {__LINE__, 0x00000019,	"0000019", "%.7x"},
  {__LINE__, -0x0058d3a,	"-363834", "%ld"},
  {__LINE__, 0xfffff6b3,	"fffff6b3", "%x"},
  {__LINE__, 0xfffffff5,	"FFFFFFF5", "%.0X"},
  {__LINE__, 0x005e1fcb,	"5E1FCB", "%+6X"},
  {__LINE__, 0xffc3c866,	"0xffc3c866", "%-#.4x"},
  {__LINE__, 0x00000003,	"3", "%X"},
  {__LINE__, 0xffa2e961,	"FFA2E961", "%7.4X"},
  {__LINE__, 0x00000029,	"41", "%d"},
  {__LINE__, -0x0000035,	"-53", "%d"},
  {__LINE__, 0x0001b033,	"110643", "%ld"},
  {__LINE__, 0x004dd51b,	"5100827", "%-2ld"},
  {__LINE__, -0x000252d,	"-9517", "% d"},
  {__LINE__, 0xffffdeb2,	"ffffdeb2", "%4.x"},
  {__LINE__, 0xffe94eab,	"0xffe94eab", "%#x"},
  {__LINE__, 0xf921edf6,	"f921edf6", "%4.2x"},
  {__LINE__, 0x0007df97,	"515991", "%4.ld"},
  {__LINE__, 0x00709bc5,	"709BC5", "%0X"},
  {__LINE__, -0x0000001,	"-1", "%d"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "%7.3X"},
  {__LINE__, -0x0063f74,	"-409460", "%+05.0d"},
  {__LINE__, 0xfffffe9a,	"FFFFFE9A", "%.2X"},
  {__LINE__, -0x0001ce2,	"-7394", "%.4d"},
  {__LINE__, 0x000038c5,	"14533", "%ld"},
  {__LINE__, 0x000000ad,	"000ad", "% 5.5x"},
  {__LINE__, 0xffffbcc4,	"ffffbcc4", "%-5x"},
  {__LINE__, 0x00000000,	"0", "% X"},
  {__LINE__, 0x00372877,	"372877", "%.6X"},
  {__LINE__, 0xffffffd7,	"FFFFFFD7", "%1.X"},
  {__LINE__, 0xfa58b14b,	"fa58b14b", "%x"},
  {__LINE__, 0xfffffd9f,	"FFFFFD9F", "%0.7X"},
  {__LINE__, 0x00000710,	"+1808", "%+#.2ld"},
  {__LINE__, 0x00000006,	"    6", "%5.0ld"},
  {__LINE__, 0x0fba9706,	"263886598", "%-6.3d"},
  {__LINE__, 0xffff420a,	"ffff420a", "%-2x"},
  {__LINE__, 0x14b9a825,	"14b9a825", "%x"},
  {__LINE__, 0x0077ffe4,	"77FFE4", "%+.2X"},
  {__LINE__, 0x00067108,	"422152 ", "%-7.ld"},
  {__LINE__, 0x00000001,	" 00001", "%6.5X"},
  {__LINE__, 0x00000000,	"0", "%ld"},
  {__LINE__, -0x0000001,	"     -1", "% 7ld"},
  {__LINE__, 0x01ddc7a3,	"31311779", "%d"},
  {__LINE__, -0x2a92f9b,	"-44642203", "% 3ld"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%4.6x"},
  {__LINE__, 0x0279a274,	"279a274", "%x"},
  {__LINE__, 0x2e37ed8e,	"775417230", "%d"},
  {__LINE__, 0x5ba59f58,	"1537580888", "%-ld"},
  {__LINE__, 0xffffffe0,	"ffffffe0", "%x"},
  {__LINE__, 0x3110ae47,	"0X3110AE47", "%+#X"},
  {__LINE__, 0x000e00b9,	"917689", "%d"},
  {__LINE__, 0x0000002e,	"   0046", "% 7.4d"},
  {__LINE__, 0x00000363,	"    867", "%7.d"},
  {__LINE__, -0x000000b,	"-0011", "% 0.4d"},
  {__LINE__, 0x000349c8,	"  349C8", "% 7.X"},
  {__LINE__, -0x01358f1,	"-1267953", "%d"},
  {__LINE__, -0x0039d3c,	"-236860", "%-.3d"},
  {__LINE__, 0xffd6de19,	"ffd6de19", "%04.0x"},
  {__LINE__, -0x0003c54,	"-0015444", "%1.7d"},
  {__LINE__, -0x0000e17,	"-3607", "%d"},
  {__LINE__, 0xff0fa3a9,	"ff0fa3a9", "%+3x"},
  {__LINE__, 0x00000009,	"0000009", "%1.7x"},
  {__LINE__, 0xfffffc81,	"FFFFFC81", "% X"},
  {__LINE__, -0x4ef2df5,	"-82783733", "%ld"},
  {__LINE__, 0x00000013,	"19", "%-ld"},
  {__LINE__, 0x00000000,	"      0", "%#7x"},
  {__LINE__, -0x3b9485fd,	"-999589373", "%1.d"},
  {__LINE__, -0x0000006,	"-00006", "%6.5d"},
  {__LINE__, 0x0000003f,	"+63", "%+ld"},
  {__LINE__, 0x000004c5,	"1221", "%1.d"},
  {__LINE__, 0x003f8a8c,	"4164236", "%d"},
  {__LINE__, -0x000001e,	"-30", "%-#3d"},
  {__LINE__, 0xfff9d230,	"FFF9D230", "%+07.3X"},
  {__LINE__, 0x0147cf17,	"147cf17", "% x"},
  {__LINE__, 0xffffffeb,	"ffffffeb", "%x"},
  {__LINE__, 0x0000007d,	"00125", "%.5ld"},
  {__LINE__, 0x000fff56,	"1048406", "%#3d"},
  {__LINE__, 0x064307a0,	" 105056160", "% 0.3ld"},
  {__LINE__, 0x007d2860,	"8202336", "%-.2d"},
  {__LINE__, 0x00a05711,	"a05711", "%x"},
  {__LINE__, 0x179a7f9e,	"0x179a7f9e", "%+#.3x"},
  {__LINE__, 0x00000003,	"3", "%X"},
  {__LINE__, -0x0001d7d,	"-7549", "%#5d"},
  {__LINE__, 0x0025d3f2,	"+2479090", "%+2.d"},
  {__LINE__, -0x0000001,	"-1", "%#ld"},
  {__LINE__, 0xfffffdd5,	"fffffdd5", "%.7x"},
  {__LINE__, 0x003462b9,	"3433145", "%d"},
  {__LINE__, 0x00005a81,	"23169", "%d"},
  {__LINE__, 0xfffffcdb,	"fffffcdb", "%-x"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, 0xfff22085,	"fff22085", "%x"},
  {__LINE__, 0x00016d72,	" 93554", "% d"},
  {__LINE__, -0x0000002,	"-2", "%0ld"},
  {__LINE__, 0xfffffd21,	"fffffd21", "% 0x"},
  {__LINE__, 0x00000931,	"2353", "%ld"},
  {__LINE__, 0x00010021,	"10021", "%5.1X"},
  {__LINE__, -0x000007e,	"-126", "%1.0ld"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%01.x"},
  {__LINE__, -0x001d148,	"-119112", "%d"},
  {__LINE__, -0x0000008,	"-8", "%ld"},
  {__LINE__, -0x000038e,	"-910", "% ld"},
  {__LINE__, 0x0039e3e5,	"3793893", "%0.1d"},
  {__LINE__, 0x0038fb8e,	"38FB8E", "%.2X"},
  {__LINE__, -0x002dafa,	"-187130", "%ld"},
  {__LINE__, -0xbec275b,	"-200025947", "%ld"},
  {__LINE__, 0x1a32f999,	"1A32F999", "%05.4X"},
  {__LINE__, 0x0000002f,	"2f", "%x"},
  {__LINE__, -0x0001a5b,	"-6747", "%+3.ld"},
  {__LINE__, 0x00000762,	"   1890", "%7.ld"},
  {__LINE__, 0x000000c2,	"000194", "%0.6ld"},
  {__LINE__, 0xffff002b,	"FFFF002B", "%.4X"},
  {__LINE__, -0x0019dae,	"-105902", "% .2d"},
  {__LINE__, 0x0000125f,	"125f", "%+1x"},
  {__LINE__, -0x000b688,	" -46728", "%#7.d"},
  {__LINE__, 0x000401ca,	"401ca", "%0x"},
  {__LINE__, 0x00000192,	"402", "%#ld"},
  {__LINE__, 0xffffffff,	"ffffffff", "%x"},
  {__LINE__, 0x1e505a0c,	"0X1E505A0C", "%#1.3X"},
  {__LINE__, 0x000f8f6c,	"1019756", "%d"},
  {__LINE__, 0x0004a296,	"4a296", "%5.2x"},
  {__LINE__, 0x00000003,	"3", "% x"},
  {__LINE__, -0x000d44c,	"-54348", "%#ld"},
  {__LINE__, 0x00009ae2,	"39650", "%-d"},
  {__LINE__, 0xffffff3a,	"FFFFFF3A", "% .7X"},
  {__LINE__, 0x0042350b,	"4338955", "%d"},
  {__LINE__, 0x000071af,	"71af", "%+.4x"},
  {__LINE__, 0x00000001,	"0x1", "%#0x"},
  {__LINE__, 0x00000033,	"00051", "%3.5d"},
  {__LINE__, 0x00000001,	"1", "%X"},
  {__LINE__, -0xebfb0e7,	"-247443687", "%+3ld"},
  {__LINE__, 0x00000027,	"27     ", "%-07.X"},
  {__LINE__, -0x0004837,	"-18487", "%01d"},
  {__LINE__, 0x1a8c53da,	"1A8C53DA", "%X"},
  {__LINE__, -0x0bdb8a9,	"-12433577", "%d"},
  {__LINE__, -0x0000098,	"-152", "%#ld"},
  {__LINE__, -0x003b554,	"-243028", "%d"},
  {__LINE__, 0x000000cb,	"00000CB", "%+.7X"},
  {__LINE__, 0xfffffeda,	"FFFFFEDA", "%X"},
  {__LINE__, -0x0000010,	"-16", "%-#d"},
  {__LINE__, 0x00000006,	"+6", "%+d"},
  {__LINE__, 0x003c294a,	"+3942730", "%+4.ld"},
  {__LINE__, 0x00000009,	"9", "%ld"},
  {__LINE__, 0xfbbdd2bc,	"FBBDD2BC", "% X"},
  {__LINE__, 0x71c86678,	"+1908958840", "%+0.6ld"},
  {__LINE__, -0x0b49bff,	"-11836415", "% 6.ld"},
  {__LINE__, 0xfff416be,	"fff416be", "%3.x"},
  {__LINE__, 0x00000077,	"+119", "%+d"},
  {__LINE__, 0xfff1cfaa,	"FFF1CFAA", "% 0.2X"},
  {__LINE__, 0xfffffffb,	"fffffffb", "% x"},
  {__LINE__, 0x0000127e,	"4734", "%d"},
  {__LINE__, 0x00107ad2,	"107ad2", "%+2.6x"},
  {__LINE__, 0x0006b8e9,	"440553", "%-#d"},
  {__LINE__, 0x0000eb6f,	"eb6f", "% x"},
  {__LINE__, 0x00001f18,	"7960", "%0d"},
  {__LINE__, 0xfffff225,	"fffff225", "%1.5x"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%+6.x"},
  {__LINE__, 0x000005b9,	"01465", "%.5ld"},
  {__LINE__, 0xfffc26b8,	"FFFC26B8", "% X"},
  {__LINE__, 0x540d580d,	"0X540D580D", "%+#X"},
  {__LINE__, 0x05ad7094,	"5AD7094", "% 4.7X"},
  {__LINE__, -0x000019b,	"-411", "% d"},
  {__LINE__, 0x00000006,	"000006", "%6.6ld"},
  {__LINE__, 0x0000026a,	"+618", "%+ld"},
  {__LINE__, 0x0000000b,	"11", "%ld"},
  {__LINE__, -0x26985d5,	"-40469973", "%#.0ld"},
  {__LINE__, 0x0000007d,	"7D", "%+02.0X"},
  {__LINE__, -0x0079ddf,	"-0499167", "%+.7ld"},
  {__LINE__, 0x0000375f,	"14175", "%0d"},
  {__LINE__, -0x18de7f99,	"-417234841", "%ld"},
  {__LINE__, -0x00507cc,	"-329676", "%.0d"},
  {__LINE__, 0x000029d5,	"29D5", "%-2.1X"},
  {__LINE__, 0x0000328c,	"328C", "%-3.X"},
  {__LINE__, 0x016f6234,	"24076852", "%3.ld"},
  {__LINE__, 0xfffffffc,	"0XFFFFFFFC", "%#.5X"},
  {__LINE__, 0xfe6163ca,	"FE6163CA", "%5.X"},
  {__LINE__, 0xffffffc2,	"FFFFFFC2", "%X"},
  {__LINE__, 0x00000087,	"+135", "%+ld"},
  {__LINE__, 0x00310166,	"310166", "% x"},
  {__LINE__, 0x00e8c871,	"15255665", "%d"},
  {__LINE__, 0x000005ee,	"1518", "%ld"},
  {__LINE__, 0xfcb24306,	"FCB24306", "%X"},
  {__LINE__, 0x0000000b,	"   11", "%5ld"},
  {__LINE__, 0x006d11d0,	"0x6d11d0", "%#.0x"},
  {__LINE__, 0x0010d416,	"1102870", "%#6.5d"},
  {__LINE__, -0x0047cb3,	"-294067", "%.3d"},
  {__LINE__, 0x000000c0,	"c0", "%x"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%+X"},
  {__LINE__, -0x000000a,	"-10", "%d"},
  {__LINE__, -0x0000007,	"-7", "% ld"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "%-X"},
  {__LINE__, 0x00000014,	"0x14", "%-#3.1x"},
  {__LINE__, 0x00003319,	"3319", "% x"},
  {__LINE__, 0x00000000,	"00", "%+#.2X"},
  {__LINE__, -0x0000009,	"-9", "% ld"},
  {__LINE__, -0x0000001,	"-1 ", "%-3ld"},
  {__LINE__, 0x00262909,	"2500873", "%.5ld"},
  {__LINE__, 0x33e76560,	"33e76560", "%7.0x"},
  {__LINE__, -0x0000002,	"-2", "%ld"},
  {__LINE__, 0x00035ee9,	"35EE9", "%-3.X"},
  {__LINE__, -0x0000235,	"-565", "%+4.ld"},
  {__LINE__, -0x3ea63c5,	"-65692613", "%d"},
  {__LINE__, 0x00000003,	"3", "%ld"},
  {__LINE__, -0x003362f,	"-210479", "% d"},
  {__LINE__, -0x1a819f8a,	"-444702602", "%.7d"},
  {__LINE__, 0x027a4668,	"41567848", "%d"},
  {__LINE__, 0x0002b025,	"2b025", "%x"},
  {__LINE__, -0x0000001,	"-001", "%.3ld"},
  {__LINE__, 0xfffffff0,	"fffffff0", "%-0x"},
  {__LINE__, -0x0000d4f,	"-3407", "%-ld"},
  {__LINE__, 0x00000146,	" 326", "% 1.d"},
  {__LINE__, -0x0000006,	"-6", "%d"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%06.4X"},
  {__LINE__, 0x376fddae,	"+930078126", "%+#0ld"},
  {__LINE__, 0x006d9da3,	"6d9da3", "%1.x"},
  {__LINE__, -0x0000f28,	"-3880", "%3.2ld"},
  {__LINE__, 0x0006962c,	" 431660", "% 5d"},
  {__LINE__, 0x000011db,	"  4571", "%6.ld"},
  {__LINE__, 0xffffffa8,	"ffffffa8", "%+x"},
  {__LINE__, 0x0d886db3,	"D886DB3", "%.7X"},
  {__LINE__, 0x00000000,	"000000", "%2.6ld"},
  {__LINE__, 0xfffff6b6,	"FFFFF6B6", "% X"},
  {__LINE__, -0x0739068,	"-7573608", "%+6.ld"},
  {__LINE__, 0xfba62553,	"0XFBA62553", "%#X"},
  {__LINE__, -0x4474bc5,	"-71781317", "%-2ld"},
  {__LINE__, 0xffffff95,	"FFFFFF95", "% 2.X"},
  {__LINE__, -0x1d0e1ca,	"-30466506", "%+.0d"},
  {__LINE__, -0x000f3aa,	"-62378", "%ld"},
  {__LINE__, 0x00000026,	"26", "%1x"},
  {__LINE__, 0x001c5400,	"1856512", "%-#d"},
  {__LINE__, 0x03808442,	"3808442", "%X"},
  {__LINE__, -0x0000081,	"-129", "%+#ld"},
  {__LINE__, 0x000004ae,	" 1198", "% 3.4d"},
  {__LINE__, -0x7f4ed54,	"-133492052", "%d"},
  {__LINE__, 0x00000000,	"+0", "%+ld"},
  {__LINE__, 0x00000000,	"0", "%+x"},
  {__LINE__, 0x004c7e46,	"5013062", "%.0d"},
  {__LINE__, -0x647d7a65,	"-1685944933", "%0.2d"},
  {__LINE__, 0x00003b59,	"15193", "%-#1d"},
  {__LINE__, 0xfff3e64d,	"FFF3E64D", "%-X"},
  {__LINE__, 0x00007022,	"28706", "%-d"},
  {__LINE__, 0xc28d0ad8,	"c28d0ad8", "%+x"},
  {__LINE__, -0x005c208,	"-377352", "% ld"},
  {__LINE__, 0x00cfbadc,	"13613788", "%d"},
  {__LINE__, 0x000016ea,	"5866", "%0d"},
  {__LINE__, 0x00000029,	"29", "%X"},
  {__LINE__, 0xffe16813,	"0XFFE16813", "%+#X"},
  {__LINE__, 0x00000004,	"4", "%0X"},
  {__LINE__, -0x0000096,	" -150", "%5d"},
  {__LINE__, 0x00027ac7,	"162503", "%ld"},
  {__LINE__, -0x0075de0,	"-482784", "%d"},
  {__LINE__, 0x005fcff6,	"6279158", "%d"},
  {__LINE__, 0xffffffef,	"FFFFFFEF", "%3X"},
  {__LINE__, 0x267b05ec,	"645596652", "%4ld"},
  {__LINE__, 0xa487b724,	"a487b724", "%x"},
  {__LINE__, 0x01da2a11,	"31074833", "%-.0ld"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%X"},
  {__LINE__, 0x0000037a,	"37a", "%x"},
  {__LINE__, 0x003d0314,	"+3998484", "%+#1d"},
  {__LINE__, 0x0000011b,	"  283", "%5.2d"},
  {__LINE__, 0x094f6066,	"94f6066", "%x"},
  {__LINE__, 0x00000004,	"4", "%X"},
  {__LINE__, -0x102e14bd,	"-271455421", "% 7.ld"},
  {__LINE__, 0x000048da,	"0018650", "%07ld"},
  {__LINE__, -0x24ae0390,	"-615383952", "%0.6d"},
  {__LINE__, 0xffff5159,	"0XFFFF5159", "%#0X"},
  {__LINE__, 0xfffd38c3,	"fffd38c3", "%x"},
  {__LINE__, 0xfffff9ea,	"FFFFF9EA", "%-X"},
  {__LINE__, -0x000fd28,	"-64808", "% ld"},
  {__LINE__, 0x002c1bf4,	"2890740", "%-.1d"},
  {__LINE__, 0x00d00ee7,	"D00EE7", "%0.4X"},
  {__LINE__, 0x00000cf9,	"3321", "%0d"},
  {__LINE__, -0x0000001,	"-1", "%-#ld"},
  {__LINE__, 0xfffffd75,	"FFFFFD75", "%.2X"},
  {__LINE__, 0x00000012,	"18", "%-d"},
  {__LINE__, 0xfd44b4b2,	"fd44b4b2", "%+5.x"},
  {__LINE__, -0x001c53f,	"-116031", "%-#6.d"},
  {__LINE__, 0x000ff6fd,	"ff6fd", "%2x"},
  {__LINE__, 0x00000001,	"1", "%0d"},
  {__LINE__, 0x0120b478,	"120B478", "%.7X"},
  {__LINE__, 0x0145591e,	"145591E", "%1.4X"},
  {__LINE__, 0x001f99b9,	"1F99B9", "%.1X"},
  {__LINE__, 0xffffd078,	"ffffd078", "%-1.5x"},
  {__LINE__, 0xffffff1a,	"FFFFFF1A", "%-4.6X"},
  {__LINE__, 0xfffffffa,	"fffffffa", "%x"},
  {__LINE__, -0x00000b9,	"-185", "%3ld"},
  {__LINE__, 0x00001cf0,	"7408", "%-ld"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "%X"},
  {__LINE__, 0x00151f30,	"151F30", "%X"},
  {__LINE__, -0x0000103,	"-259", "%d"},
  {__LINE__, -0x000303f,	"-12351", "%d"},
  {__LINE__, 0x000002ca,	"714", "%ld"},
  {__LINE__, -0x0000c55,	"-3157", "%1d"},
  {__LINE__, 0x00000691,	"01681", "%#.5ld"},
  {__LINE__, 0x00230537,	"2295095", "%#d"},
  {__LINE__, 0x032a1faa,	"53092266", "%.4d"},
  {__LINE__, 0x000050d7,	"20695", "%d"},
  {__LINE__, -0x0c7ad4c,	"-13086028", "%#.4ld"},
  {__LINE__, -0x00009d9,	"-2521", "%+d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%0x"},
  {__LINE__, 0xffdec2d9,	"FFDEC2D9", "%5.1X"},
  {__LINE__, -0x000563c,	"-22076", "%-.2ld"},
  {__LINE__, 0x0073b36a,	"0x73b36a", "%-#x"},
  {__LINE__, 0xfffffffd,	"fffffffd", "%x"},
  {__LINE__, 0x0193ba5a,	"193ba5a", "%1.x"},
  {__LINE__, 0x00d147b5,	"13715381", "%2.d"},
  {__LINE__, 0xffffff10,	"ffffff10", "%4x"},
  {__LINE__, 0x000648d5,	"648d5", "%1.3x"},
  {__LINE__, 0x00000011,	"11", "%X"},
  {__LINE__, 0xff259f5b,	"0xff259f5b", "% #.1x"},
  {__LINE__, 0x00000175,	"175", "%x"},
  {__LINE__, 0x00000000,	"0", "%ld"},
  {__LINE__, 0x00000015,	"21", "%#ld"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%-x"},
  {__LINE__, 0x00000013,	" 19", "% 0ld"},
  {__LINE__, -0x0000001,	"-0000001", "% 5.7ld"},
  {__LINE__, 0x0000139d,	"139D", "%X"},
  {__LINE__, 0x0041ad18,	"41ad18", "%-.6x"},
  {__LINE__, -0x00000f9,	"-249", "% 3.d"},
  {__LINE__, 0x00000076,	"118", "%ld"},
  {__LINE__, 0x000006f8,	"1784", "%d"},
  {__LINE__, -0x0000005,	"-5", "%ld"},
  {__LINE__, -0x00008e7,	"-2279", "%+ld"},
  {__LINE__, 0x00003f77,	"3F77", "%+0X"},
  {__LINE__, 0x000ca3f8,	"0XCA3F8", "%+#X"},
  {__LINE__, -0x00004bf,	"-001215", "%#5.6ld"},
  {__LINE__, 0x319129ab,	"0x319129ab", "%+#x"},
  {__LINE__, -0x0000002,	"-2", "%ld"},
  {__LINE__, -0x0f6686e,	"-16148590", "%.6ld"},
  {__LINE__, 0x0329576b,	"53041003", "%2.d"},
  {__LINE__, -0x000179e,	"-6046", "%d"},
  {__LINE__, 0x000002cc,	"+716", "%+1.3ld"},
  {__LINE__, 0xfffffff7,	"0xfffffff7", "% #x"},
  {__LINE__, 0x0016eb40,	"1502016", "%ld"},
  {__LINE__, 0x00000003,	"3", "%-0ld"},
  {__LINE__, 0x0023e0d6,	"23E0D6", "%-05.X"},
  {__LINE__, 0xffffa6a4,	"0XFFFFA6A4", "%#X"},
  {__LINE__, 0x00087664,	"87664", "% .2x"},
  {__LINE__, -0x0000002,	" -2", "%3.ld"},
  {__LINE__, 0x003ad85d,	"3AD85D", "%X"},
  {__LINE__, 0x00002f20,	"12064", "%ld"},
  {__LINE__, 0x02030bfc,	"2030BFC", "%02.3X"},
  {__LINE__, 0xfffff36a,	"FFFFF36A", "%X"},
  {__LINE__, 0xfe0729ff,	"0xfe0729ff", "% #.0x"},
  {__LINE__, 0xfec15164,	"FEC15164", "%0.2X"},
  {__LINE__, -0x00169ec,	"-92652", "%+d"},
  {__LINE__, 0x006d7990,	"0x6d7990", "%#x"},
  {__LINE__, 0xffcc89e6,	"ffcc89e6", "%x"},
  {__LINE__, 0x002d7cca,	"2981066", "%7.7ld"},
  {__LINE__, -0x1649692b,	"-373909803", "%#ld"},
  {__LINE__, 0x00664f47,	"664f47", "%+6.x"},
  {__LINE__, 0x00000000,	"0", "% X"},
  {__LINE__, 0x00000047,	"000047", "%.6X"},
  {__LINE__, 0x00000007,	"0000007", "%.7ld"},
  {__LINE__, 0x00000030,	"30", "%-x"},
  {__LINE__, -0x25bcbabb,	"-633125563", "% ld"},
  {__LINE__, 0xfe11c031,	"FE11C031", "%4.6X"},
  {__LINE__, -0x0000001,	"-0000001", "%.7d"},
  {__LINE__, 0x00b56d84,	"11890052", "%ld"},
  {__LINE__, -0x0000b01,	"-0002817", "%+07.7ld"},
  {__LINE__, 0xffffe4ad,	"ffffe4ad", "% 0.0x"},
  {__LINE__, 0x007760fc,	"7760fc", "%+x"},
  {__LINE__, 0xffef44d8,	"FFEF44D8", "%X"},
  {__LINE__, 0xfcb6862e,	"fcb6862e", "%+x"},
  {__LINE__, -0x0000001,	"-1", "%0d"},
  {__LINE__, 0xffffffe6,	"FFFFFFE6", "%3.1X"},
  {__LINE__, 0xff816e27,	"FF816E27", "% 6.X"},
  {__LINE__, 0x00006415,	"25621", "%ld"},
  {__LINE__, -0xfae5449,	"-263083081", "%0ld"},
  {__LINE__, 0x00000001,	" 1", "% 0d"},
  {__LINE__, 0x00000009,	" 9", "%2.X"},
  {__LINE__, 0x002d7e18,	"2981400", "%7d"},
  {__LINE__, -0x00000fc,	"-0000252", "%-#.7d"},
  {__LINE__, 0x00000003,	"3", "%0x"},
  {__LINE__, 0x0d46e47f,	"222749823", "%ld"},
  {__LINE__, 0xfffcbc52,	"FFFCBC52", "%+X"},
  {__LINE__, 0x00000000,	"0", "%-X"},
  {__LINE__, 0xfffff0e5,	"fffff0e5", "%x"},
  {__LINE__, 0xffffffd9,	"FFFFFFD9", "%07X"},
  {__LINE__, 0x000004ee,	"4ee", "%0x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%0x"},
  {__LINE__, -0x0008cb4,	"-036020", "%+3.6ld"},
  {__LINE__, 0x0000dada,	"0xdada", "%#0.x"},
  {__LINE__, 0x0000001a,	"26  ", "%-4d"},
  {__LINE__, -0x000000c,	" -12", "%04.d"},
  {__LINE__, 0x0000025c,	"    25c", "%7.x"},
  {__LINE__, 0xfe9b091e,	"FE9B091E", "%X"},
  {__LINE__, 0x00000002,	"      2", "%07.ld"},
  {__LINE__, -0x0004930,	"-18736", "% 6.d"},
  {__LINE__, 0xffffffe9,	"FFFFFFE9", "%X"},
  {__LINE__, 0x00000003,	" 3", "%2.ld"},
  {__LINE__, 0x00000e00,	"3584", "%.4d"},
  {__LINE__, 0xffff38c2,	"ffff38c2", "%0.x"},
  {__LINE__, 0xffffffff,	"FFFFFFFF", "% .3X"},
  {__LINE__, 0xff7c1b2f,	"FF7C1B2F", "%-3.2X"},
  {__LINE__, -0x0000005,	"-5", "%2d"},
  {__LINE__, 0x00098775,	"98775", "%x"},
  {__LINE__, 0x000015ff,	"  15FF", "%6.X"},
  {__LINE__, 0xfffbe3ef,	"FFFBE3EF", "%0.3X"},
  {__LINE__, -0x0000048,	"-72", "%ld"},
  {__LINE__, 0x0001488a,	"84106", "%d"},
  {__LINE__, 0x00000001,	"1", "%x"},
  {__LINE__, -0x0000002,	"-2", "%-0.0ld"},
  {__LINE__, -0x0000001,	"-1", "%-d"},
  {__LINE__, 0x0006616f,	"6616f", "%x"},
  {__LINE__, 0x3657856d,	"911705453", "%6.d"},
  {__LINE__, -0x0007222,	"-0029218", "%.7d"},
  {__LINE__, 0x00041606,	"267782", "%04.5d"},
  {__LINE__, 0x00000001,	" 1", "%2.ld"},
  {__LINE__, 0x00000219,	"219", "%0x"},
  {__LINE__, 0x0ae0184c,	"ae0184c", "%x"},
  {__LINE__, 0x00003a7d,	"  14973", "%7.ld"},
  {__LINE__, 0xffffffff,	"0XFFFFFFFF", "%#X"},
  {__LINE__, -0x0000002,	"-2", "%0ld"},
  {__LINE__, 0x00002cdf,	"11487", "%0ld"},
  {__LINE__, -0x000000c,	"-12", "%d"},
  {__LINE__, -0x000000e,	"-14", "%-#2d"},
  {__LINE__, 0x00000371,	"881", "%#ld"},
  {__LINE__, 0x000015be,	" 5566", "%5.ld"},
  {__LINE__, 0x01525b91,	"22174609", "%#0.0ld"},
  {__LINE__, 0xff8fc22f,	"FF8FC22F", "% X"},
  {__LINE__, -0x0007f7b,	"-32635", "%4.ld"},
  {__LINE__, 0x00007bca,	"7bca", "%x"},
  {__LINE__, -0x0000582,	"-1410", "%ld"},
  {__LINE__, 0x00000047,	" +71", "%+04.2d"},
  {__LINE__, 0xf8a8dce2,	"f8a8dce2", "%+.6x"},
  {__LINE__, -0x000de2e,	"-56878", "%.0d"},
  {__LINE__, 0x019c03c1,	"0X19C03C1", "%#X"},
  {__LINE__, -0x0f3a43e,	"-15967294", "%ld"},
  {__LINE__, 0x00009e87,	"40583", "%#5.1d"},
  {__LINE__, 0x000000b8,	"184", "%0ld"},
  {__LINE__, -0x000befe,	"-48894", "%2ld"},
  {__LINE__, -0x002ee1a,	"-192026", "%.2d"},
  {__LINE__, 0x00004fd8,	"4fd8", "%x"},
  {__LINE__, 0x0006d57b,	"447867", "%2d"},
  {__LINE__, 0xfffffa9c,	"FFFFFA9C", "%-X"},
  {__LINE__, 0x0000000f,	"15", "%ld"},
  {__LINE__, 0x0005deb2,	"5DEB2", "% X"},
  {__LINE__, 0x00000007,	"7", "%X"},
  {__LINE__, 0xffffffc8,	"0XFFFFFFC8", "% #.1X"},
  {__LINE__, 0xfffff62f,	"FFFFF62F", "%X"},
  {__LINE__, -0x1a935bba,	"-445864890", "% 3.5d"},
  {__LINE__, 0x000b34b4,	"0x0b34b4", "%-#3.6x"},
  {__LINE__, 0xfffff430,	"FFFFF430", "%X"},
  {__LINE__, 0x00000b5f,	"+0002911", "%+#.7d"},
  {__LINE__, 0x00000007,	"  7", "%3ld"},
  {__LINE__, 0xffffffd8,	"FFFFFFD8", "% .7X"},
  {__LINE__, 0xfffff544,	"FFFFF544", "%0X"},
  {__LINE__, -0x353667b9,	"-892757945", "%d"},
  {__LINE__, 0x00000058,	"0x00058", "%+#.5x"},
  {__LINE__, 0x39dbcc4a,	"+970705994", "%+0.6ld"},
  {__LINE__, 0xfffffffd,	"fffffffd", "% 01x"},
  {__LINE__, 0x00b1c28e,	"+11649678", "%+0ld"},
  {__LINE__, 0x000066c2,	"0X66C2", "%-#4X"},
  {__LINE__, 0x007171a2,	"+7434658", "%+07.ld"},
  {__LINE__, -0x0000001,	"-1", "%-d"},
  {__LINE__, 0x00000ae0,	"+2784", "%+0d"},
  {__LINE__, 0x13786a57,	"326658647", "%#5d"},
  {__LINE__, -0x0000001,	"-1", "%2.ld"},
  {__LINE__, -0x0168a16,	"-1477142", "%d"},
  {__LINE__, 0x12df7dd6,	"316636630", "%ld"},
  {__LINE__, 0x00000000,	"000000", "%1.6d"},
  {__LINE__, 0x266da2a9,	"644719273", "%ld"},
  {__LINE__, 0x0000004a,	"74", "%d"},
  {__LINE__, 0x000102ff,	"00102FF", "%+06.7X"},
  {__LINE__, 0x17916237,	"0x17916237", "%#5x"},
  {__LINE__, -0x0003cbb,	"-0015547", "%-.7d"},
  {__LINE__, 0xe7da2010,	"e7da2010", "%2.4x"},
  {__LINE__, 0xfffffff3,	"fffffff3", "% .7x"},
  {__LINE__, 0xfc9b64f8,	"FC9B64F8", "% 7.X"},
  {__LINE__, 0x000001af,	"431", "%0d"},
  {__LINE__, 0xffc81796,	"0xffc81796", "%#.5x"},
  {__LINE__, 0x057a1fbc,	"+91889596", "%+04d"},
  {__LINE__, 0x00001ae1,	"6881", "%ld"},
  {__LINE__, 0xfffffff6,	"fffffff6", "%3.0x"},
  {__LINE__, -0x6b7d5db,	"-112711131", "%-06.1d"},
  {__LINE__, 0x008e8a5c,	" 8e8a5c", "%7.0x"},
  {__LINE__, 0xfe07a9bd,	"fe07a9bd", "%.1x"},
  {__LINE__, -0x00278e6,	"-162022", "%0ld"},
  {__LINE__, 0xf98709f5,	"F98709F5", "%X"},
  {__LINE__, -0x00000c9,	"-201", "% 1.d"},
  {__LINE__, -0x000001d,	"-00029", "%+2.5ld"},
  {__LINE__, 0x00000030,	" 48", "% d"},
  {__LINE__, 0xffd753f4,	"FFD753F4", "%0X"},
  {__LINE__, 0xfffffffd,	"FFFFFFFD", "%X"},
  {__LINE__, 0x0000a765,	"a765", "%x"},
  {__LINE__, 0x0026e2c8,	"26E2C8", "%-0X"},
  {__LINE__, -0x00003eb,	"-1003", "%3.1ld"},
  {__LINE__, 0x015d53ca,	"22893514", "%0ld"},
  {__LINE__, -0x0000020,	"-32", "%ld"},
  {__LINE__, -0x03558dd,	"-3496157", "%1.0ld"},
  {__LINE__, -0x000007f,	"-127", "%1.d"},
  {__LINE__, 0xffffc737,	"0xffffc737", "%+#x"},
  {__LINE__, 0x0000a70d,	"  a70d", "%6.x"},
  {__LINE__, 0x01ea0e31,	"0X1EA0E31", "% #1.X"},
  {__LINE__, 0x00b5f406,	"0X0B5F406", "%-#.7X"},
  {__LINE__, 0x0e58fa9a,	"240712346", "%.2d"},
  {__LINE__, 0xf43ff8a9,	"f43ff8a9", "%+0.6x"},
  {__LINE__, -0x5d0d3d3,	"-97571795", "%.3ld"},
  {__LINE__, -0x000027a,	"-634", "%0d"},
  {__LINE__, 0xffcef248,	"FFCEF248", "%07.X"},
  {__LINE__, 0x000002dc,	"2dc", "%0x"},
  {__LINE__, -0x31fa6c1,	"-52405953", "%.2d"},
  {__LINE__, 0x00000014,	"14", "%X"},
  {__LINE__, -0x0282f98,	"-2633624", "%ld"},
  {__LINE__, 0x00005f55,	"24405", "%#d"},
  {__LINE__, -0x0000004,	"-4", "%d"},
  {__LINE__, 0x00000001,	"1", "%+x"},
  {__LINE__, 0x013f47ce,	"13f47ce", "%0.x"},
  {__LINE__, 0x00143fce,	"1327054", "%.3d"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, 0x00001f9a,	"1F9A", "% X"},
  {__LINE__, 0x00000cf5,	"cf5", "%x"},
  {__LINE__, 0xffea9c24,	"ffea9c24", "%x"},
  {__LINE__, 0xf09f85a7,	"F09F85A7", "%X"},
  {__LINE__, 0x00001e04,	"7684", "%ld"},
  {__LINE__, 0xffffc82a,	"ffffc82a", "%7x"},
  {__LINE__, -0x0000a77,	"-2679", "% d"},
  {__LINE__, 0x0019a859,	"+1681497", "%+2.6ld"},
  {__LINE__, -0x00002d7,	"-727", "%ld"},
  {__LINE__, 0x00011b82,	"72578", "%-#ld"},
  {__LINE__, 0x00000c32,	"3122", "%ld"},
  {__LINE__, -0x0000337,	"-823", "%1.d"},
  {__LINE__, 0x00000004,	"4", "%1ld"},
  {__LINE__, 0x0000062c,	"1580", "%.1ld"},
  {__LINE__, 0xffffffd3,	"FFFFFFD3", "% X"},
  {__LINE__, -0x07b1bf8,	"-8068088", "%#d"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%x"},
  {__LINE__, 0x159e6cfb,	"159e6cfb", "%0.x"},
  {__LINE__, 0x0001148d,	"1148d", "%-.1x"},
  {__LINE__, 0x003373b7,	"3371959", "%#.0d"},
  {__LINE__, 0x00001af2,	"1af2", "%.4x"},
  {__LINE__, -0x0000001,	"-000001", "%+.6ld"},
  {__LINE__, -0x00001a3,	"-419", "%d"},
  {__LINE__, 0xfdb232e7,	"fdb232e7", "%5.4x"},
  {__LINE__, -0x000000d,	"-13", "%d"},
  {__LINE__, 0x98ec1c74,	"98ec1c74", "% 3x"},
  {__LINE__, 0xfffffff8,	"fffffff8", "%+1.4x"},
  {__LINE__, -0x0000d58,	"-3416", "%+#0ld"},
  {__LINE__, -0x65d1973,	"-106764659", "%.6d"},
  {__LINE__, -0x0737641,	"-7566913", "%-d"},
  {__LINE__, 0x0000037c,	"37c", "%+0x"},
  {__LINE__, 0x0000012c,	"0000300", "%#3.7d"},
  {__LINE__, 0x00c12d9b,	"12660123", "%1.5ld"},
  {__LINE__, 0xe7e5e77d,	"e7e5e77d", "%6x"},
  {__LINE__, 0x1fe0e820,	"1FE0E820", "%-4X"},
  {__LINE__, 0xc85a793a,	"C85A793A", "%X"},
  {__LINE__, 0x05f9fe2c,	"100269612", "%#ld"},
  {__LINE__, 0x00000032,	"0X32", "%+#4.1X"},
  {__LINE__, 0xfab4ce81,	"fab4ce81", "%3.x"},
  {__LINE__, -0x0000009,	"-9", "%2.d"},
  {__LINE__, 0xffff8d2e,	"ffff8d2e", "% 6x"},
  {__LINE__, 0xfffffffe,	"0xfffffffe", "%#x"},
  {__LINE__, 0x02960f60,	"2960f60", "%1.x"},
  {__LINE__, 0x34cf3cbc,	" 885996732", "% 5ld"},
  {__LINE__, -0x000006e,	"-110", "% d"},
  {__LINE__, -0x0000001,	"-1", "%-.0d"},
  {__LINE__, 0x000000b1,	"     B1", "%+7X"},
  {__LINE__, 0xfffff5b4,	"FFFFF5B4", "%01.7X"},
  {__LINE__, 0x00000086,	"86", "%0X"},
  {__LINE__, 0x00074367,	" 74367", "% 6x"},
  {__LINE__, 0x001000d7,	"+1048791", "%+ld"},
  {__LINE__, 0x00000f35,	" 3893", "% d"},
  {__LINE__, -0x00000e1,	"-225", "%d"},
  {__LINE__, 0xffff6694,	"FFFF6694", "%6.X"},
  {__LINE__, 0x00019cf7,	"19cf7", "%0.x"},
  {__LINE__, 0x00000046,	"0046", "%+.4X"},
  {__LINE__, -0x000001f,	"-31", "%ld"},
  {__LINE__, 0xfff25859,	"fff25859", "%6x"},
  {__LINE__, 0x21884061,	"562577505", "%#ld"},
  {__LINE__, 0x01448b7a,	"1448B7A", "%0.1X"},
  {__LINE__, 0xffffffc0,	"ffffffc0", "%x"},
  {__LINE__, 0xfffffed5,	"fffffed5", "% 1.0x"},
  {__LINE__, 0x0e349767,	"E349767", "%.5X"},
  {__LINE__, 0x00000330,	"816", "%0d"},
  {__LINE__, -0x0000016,	"-22", "%d"},
  {__LINE__, 0xffff9bab,	"FFFF9BAB", "%X"},
  {__LINE__, 0xffffee4e,	"ffffee4e", "%x"},
  {__LINE__, 0x0026beeb,	"2539243", "%6.d"},
  {__LINE__, 0x00002c6c,	"11372", "%.2d"},
  {__LINE__, -0x000002c,	"-44", "%ld"},
  {__LINE__, -0x001dcfa,	"-122106", "% d"},
  {__LINE__, 0x0001683c,	"92220", "%#4.ld"},
  {__LINE__, 0x09b51fc9,	"9b51fc9", "%+.7x"},
  {__LINE__, 0x0000001d,	"29", "%0ld"},
  {__LINE__, -0x83f17e5,	"-138352613", "%ld"},
  {__LINE__, 0xfa4e2c1b,	"fa4e2c1b", "%x"},
  {__LINE__, 0x000001f3,	"499", "%0ld"},
  {__LINE__, 0xffff03e4,	"ffff03e4", "%x"},
  {__LINE__, 0x000000ac,	"+0172", "%+.4ld"},
  {__LINE__, 0x03c3903b,	"63148091", "%00d"},
  {__LINE__, 0x0000000d,	"13", "%#d"},
  {__LINE__, 0x0000002e,	"0X2E", "%#X"},
  {__LINE__, 0x00006b2d,	"6B2D", "%X"},
  {__LINE__, 0x0000010b,	"  0010b", "%7.5x"},
  {__LINE__, 0x0000017a,	" 17a", "%4x"},
  {__LINE__, 0xfffffffb,	"fffffffb", "%+x"},
  {__LINE__, 0xffffac6a,	"ffffac6a", "%-.3x"},
  {__LINE__, -0x0005870,	"-22640", "%0d"},
  {__LINE__, 0x189c17bc,	"189c17bc", "%x"},
  {__LINE__, -0x01bbc38,	"-1817656", "%#6.ld"},
  {__LINE__, -0x3382b55,	"-54012757", "%d"},
  {__LINE__, -0x0000007,	"-7", "%-ld"},
  {__LINE__, -0x000c74b,	"-51019", "%ld"},
  {__LINE__, 0x0001a6f2,	"+108274", "%+#1.ld"},
  {__LINE__, 0x00077448,	"77448", "%x"},
  {__LINE__, 0x00000000,	"0", "%x"},
  {__LINE__, 0xfffff056,	"FFFFF056", "%.3X"},
  {__LINE__, -0x6f3f9451,	"-1866437713", "%-#3.0ld"},
  {__LINE__, 0x000000ac,	"AC", "%X"},
  {__LINE__, 0xffc8752f,	"ffc8752f", "%-x"},
  {__LINE__, 0xfffffe6d,	"FFFFFE6D", "%2.X"},
  {__LINE__, -0x377f1a5,	"-58192293", "% .2d"},
  {__LINE__, -0x0000294,	"-660", "%d"},
  {__LINE__, 0xfffffffe,	"fffffffe", "%-x"},
  {__LINE__, 0xfffcbbe8,	"0xfffcbbe8", "%-#4.x"},
  {__LINE__, 0x0022e510,	"+2286864", "%+ld"},
  {__LINE__, 0xfffffe2a,	"FFFFFE2A", "%0.3X"},
  {__LINE__, 0xfe29f7c0,	"fe29f7c0", "%x"},
  {__LINE__, 0xfffe957e,	"FFFE957E", "%X"},
  {__LINE__, 0x000080f8,	"33016", "%ld"},
  {__LINE__, 0x0003ee2c,	" 257580", "%7d"},
  {__LINE__, 0x000003a1,	"929", "%d"},
  {__LINE__, 0x0000021f,	"21f", "%+x"},
  {__LINE__, 0xffffffff,	"ffffffff", "%.5x"},
  {__LINE__, -0x040a988,	"-4237704", "%-d"},
  {__LINE__, 0x027c8b69,	"41716585", "%ld"},
  {__LINE__, 0x00000003,	"3", "%-X"},
  {__LINE__, -0x0000368,	"   -872", "%7.d"},
  {__LINE__, 0x00000d3c,	"3388", "%0.2d"},
  {__LINE__, -0x33734cc,	"-53949644", "%2ld"},
  {__LINE__, 0x000003db,	"3DB", "%X"},
  {__LINE__, -0x00f154d,	"-988493", "%5d"},
  {__LINE__, 0x0000000b,	"  11", "%4.ld"},
  {__LINE__, 0x00000067,	"103", "%-ld"},
  {__LINE__, -0x0199fce,	"-1679310", "%4d"},
  {__LINE__, 0x02b6266b,	"2b6266b", "% x"},
  {__LINE__, -0x006b39d,	"-439197", "%+d"},
  {__LINE__, 0x00000007,	"7", "%ld"},
  {__LINE__, 0x0141fc98,	"21101720", "%0ld"},
  {__LINE__, -0x0008420,	"-33824", "%d"},
  {__LINE__, 0x0011622b,	"1139243", "%6ld"},
  {__LINE__, 0x0000001b,	"27", "%-d"},
  {__LINE__, -0x0030935,	"-198965", "%3d"},
  {__LINE__, 0x0000001f,	"  1f", "%4.x"},
  {__LINE__, -0x10782a19,	"-276310553", "%#ld"},
  {__LINE__, -0x007eac4,	"-518852", "%06.ld"},
  {__LINE__, 0x0bc4c681,	"197445249", "%6ld"},
  {__LINE__, 0x000000f5,	"245", "%.3ld"},
  {__LINE__, 0x00000197,	"197", "%X"},
  {__LINE__, 0xfffffeab,	"FFFFFEAB", "% X"},
  {__LINE__, 0x00000f05,	"F05", "%+X"},
  {__LINE__, 0xffe1b785,	"0xffe1b785", "%#x"},
  {__LINE__, -0x02d3581,	"-2962817", "%05d"},
  {__LINE__, 0xffffb994,	"FFFFB994", "%X"},
  {__LINE__, 0x03d139a3,	"64043427", "%ld"},
  {__LINE__, -0x0000002,	"  -2", "%+4.d"},
  {__LINE__, -0x043da83,	"-4446851", "%#ld"},
  {__LINE__, -0x6aad891,	"-111859857", "%7.ld"},
  {__LINE__, 0x00003e68,	"15976", "%-4.5ld"},
  {__LINE__, 0xffe4d3ee,	"FFE4D3EE", "%X"},
  {__LINE__, 0x00000002,	"000002", "%4.6ld"},
  {__LINE__, 0xffffee32,	"ffffee32", "%4x"},
  {__LINE__, 0x0cb7dd25,	"cb7dd25", "%3x"},
  {__LINE__, 0xf773d422,	"F773D422", "%X"},
  {__LINE__, -0x0b590f7,	"-11899127", "%#d"},
  {__LINE__, -0x0002c45,	"-11333", "%-#5ld"},
  {__LINE__, -0x1efc9e4,	"-32492004", "%ld"},
  {__LINE__, -0x0003b9c,	"-15260", "%d"},
  {__LINE__, 0x000001b6,	"0X1B6", "%#4X"},
  {__LINE__, 0x3ce93ec3,	"1021918915", "%.6d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%-x"},
  {__LINE__, 0xfffaf0e4,	"fffaf0e4", "%2.x"},
  {__LINE__, 0x00000002,	"0x2", "%#x"},
  {__LINE__, 0x0000e806,	"e806", "%4x"},
  {__LINE__, 0xfffffff0,	"fffffff0", "% 2.x"},
  {__LINE__, 0xfffffc0e,	"fffffc0e", "%+.4x"},
  {__LINE__, 0xfd45716e,	"FD45716E", "%.4X"},
  {__LINE__, 0xfff96fda,	"FFF96FDA", "%-X"},
  {__LINE__, 0xff99d08a,	"FF99D08A", "%.5X"},
  {__LINE__, 0x00000002,	"2", "%-00.d"},
  {__LINE__, -0x000000f,	"   -15", "%6.ld"},
  {__LINE__, -0x00d321c,	"-864796", "%#1ld"},
  {__LINE__, 0xff19ff8d,	"ff19ff8d", "%1.5x"},
  {__LINE__, 0x00000000,	"0000000", "%-.7x"},
  {__LINE__, 0x0000f50d,	" F50D", "%5X"},
  {__LINE__, 0x00001688,	"   5768", "%7.ld"},
  {__LINE__, 0x00000157,	"343", "%2ld"},
  {__LINE__, 0xfffffffd,	"0xfffffffd", "%+#3x"},
  {__LINE__, 0x00000d52,	"3410", "%ld"},
  {__LINE__, 0x00000003,	"3", "%d"},
  {__LINE__, 0x0001c6d2,	"01c6d2", "%.6x"},
  {__LINE__, 0x242d65d2,	"606954962", "%#7.ld"},
  {__LINE__, 0x00000e9f,	"0000E9F", "%5.7X"},
  {__LINE__, 0x0002d785,	"2D785", "%0X"},
  {__LINE__, 0x00000167,	"167", "%0X"},
  {__LINE__, 0xfffff5e5,	"fffff5e5", "% x"},
  {__LINE__, 0xffb69a04,	"0xffb69a04", "%#0.x"},
  {__LINE__, 0xfffa012e,	"FFFA012E", "%X"},
  {__LINE__, 0x0000001a,	"0x1a", "% #x"},
  {__LINE__, 0xfffb26d3,	"fffb26d3", "%+x"},
  {__LINE__, -0x00003e6,	"   -998", "%7ld"},
  {__LINE__, 0x00000004,	"4", "%-d"},
  {__LINE__, 0xfffffd76,	"0XFFFFFD76", "%#7X"},
  {__LINE__, 0x00000035,	"53", "%ld"},
  {__LINE__, 0xffc6c190,	"0XFFC6C190", "%#X"},
  {__LINE__, 0xffffffe2,	"ffffffe2", "%7.0x"},
  {__LINE__, 0x03ff1b87,	"67050375", "%2.d"},
  {__LINE__, 0x00020c47,	"0X20C47", "%#X"},
  {__LINE__, 0x00000000,	"0", "%d"},
  {__LINE__, 0x0000000e,	"0X000E", "% #.4X"},
  {__LINE__, -0x00035cd,	"-13773", "%+2.d"},
  {__LINE__, 0x00005eec,	"5eec", "%1x"},
  {__LINE__, 0x001da0ff,	"1941759", "%0d"},
  {__LINE__, 0xf8a9e96a,	"f8a9e96a", "%+x"},
  {__LINE__, -0x0000120,	"-288  ", "%-#6.d"},
  {__LINE__, 0x00000000,	"0", "%-X"},
  {__LINE__, 0x0000152e,	"152E", "%+X"},
  {__LINE__, -0x0001077,	"-4215", "% 0d"},
  {__LINE__, 0xffffffd7,	"FFFFFFD7", "%0X"},
  {__LINE__, 0xfffe097d,	"FFFE097D", "%2X"},
  {__LINE__, 0xcb982712,	"cb982712", "%x"},
  {__LINE__, 0xfff39f2e,	"FFF39F2E", "%.5X"},
  {__LINE__, -0x0058cae,	"-363694", "%+.1d"},
  {__LINE__, -0x000002b,	"-043", "%#1.3d"},
  {__LINE__, -0x001e989,	"-125321", "%1d"},
  {__LINE__, 0x00959ecd,	"9805517", "%d"},
  {__LINE__, 0xf49df846,	"F49DF846", "%+3X"},
  {__LINE__, 0xfffffffd,	"fffffffd", "%+.5x"},
  {__LINE__, -0x000ac76,	"-44150", "%3.ld"},
  {__LINE__, 0x00000028,	"  0028", "%06.4x"},
  {__LINE__, 0x000003e8,	"3E8", "%-02X"},
  {__LINE__, 0x00000012,	"012", "%.3X"},
  {__LINE__, 0x00000006,	"0X6", "%#X"},
  {__LINE__, 0x00ef8479,	"+15697017", "%+0.6d"},
  {__LINE__, 0xffffffe8,	"FFFFFFE8", "%-X"},
  {__LINE__, 0x773a90f7,	"773a90f7", "%3.5x"},
  {__LINE__, 0x00096d44,	"96D44", "%-X"},
  {__LINE__, -0x08a3d96,	"-9059734", "%ld"},
  {__LINE__, -0x000001a,	"-26", "%00.ld"},
  {__LINE__, 0x32f57585,	"32f57585", "% x"},
  {__LINE__, 0x2825f175,	"2825F175", "%X"},
  {__LINE__, 0x000054ff,	"21759", "%-2d"},
  {__LINE__, -0x0266cdc,	"-2518236", "%ld"},
  {__LINE__, 0x0000031d,	"0X31D", "%+#4X"},
  {__LINE__, 0x0003fc99,	"3fc99", "%x"},
  {__LINE__, -0x0064624,	"-411172", "%-#d"},
  {__LINE__, 0x0001b2d9,	"111321", "%-ld"},
  {__LINE__, -0x000007c,	"-124", "%#d"},
  {__LINE__, 0xfffffffa,	"FFFFFFFA", "%+X"},
  {__LINE__, -0x007a5b8,	"-501176", "%+ld"},
  {__LINE__, 0x0213b583,	"213B583", "%2.X"},
  {__LINE__, 0xfff12e51,	"FFF12E51", "%+X"},
  {__LINE__, 0x00052403,	"0336899", "%-0.7d"},
  {__LINE__, 0xffffffff,	"ffffffff", "%-04.4x"},
  {__LINE__, 0x00000010,	"0010", "%0.4X"},
  {__LINE__, 0xffffffb5,	"FFFFFFB5", "%-1.3X"},
  {__LINE__, -0x0000001,	"-1", "%d"},
  {__LINE__, 0x0003a2d1,	"3a2d1", "% x"},
  {__LINE__, 0x00000424,	"1060", "%0ld"},
  {__LINE__, -0x0000078,	"-120", "%1d"},
  {__LINE__, 0x00000000,	"0", "%ld"},
  {__LINE__, 0x00000414,	"1044", "%ld"},
  {__LINE__, 0x00000072,	"0x072", "%#5.3x"},
  {__LINE__, 0x0000007a,	"7A", "% X"},
  {__LINE__, 0x081542a3,	"135611043", "%0d"},
  {__LINE__, 0xfffb4ce6,	"fffb4ce6", "%4.6x"},
  {__LINE__, 0x00002ab2,	"2ab2", "%-1x"},
  {__LINE__, 0x00000000,	" 0", "% 2x"},
  {__LINE__, 0xfffffa59,	"FFFFFA59", "%2.X"},
  {__LINE__, 0xffffe22b,	"ffffe22b", "%-x"},
  {__LINE__, 0xfffffd52,	"FFFFFD52", "%+.2X"},
  {__LINE__, 0x0000039f,	"927", "%-d"},
  {__LINE__, 0x0002dea6,	"2dea6", "%0x"},
  {__LINE__, 0x000216db,	"136923", "%ld"},
  {__LINE__, 0x00000013,	"19", "%0d"},
  {__LINE__, 0x000047cc,	"18380", "%2.2ld"},
  {__LINE__, -0x0007d10,	"-32016", "%d"},
  {__LINE__, 0xff9af906,	"FF9AF906", "%0X"},
  {__LINE__, 0x02cfa224,	"+47161892", "%+0.7d"},
  {__LINE__, -0x0000022,	"-34", "%1.d"},
  {__LINE__, 0xfffffff0,	"FFFFFFF0", "%-4X"},
  {__LINE__, 0x00000029,	"    41", "%6.ld"},
  {__LINE__, 0xffffff76,	"ffffff76", "%x"},
  {__LINE__, 0x00000000,	"0", "%+X"},
  {__LINE__, 0x00000001,	"1", "%d"},
  {__LINE__, 0xfff6de5a,	"FFF6DE5A", "%X"},
  {__LINE__, 0x00000002,	"2", "%ld"},
  {__LINE__, 0x00000025,	"25", "%+x"},
  {__LINE__, 0xfffffffb,	"FFFFFFFB", "%5.0X"},
  {__LINE__, 0x0011bbb5,	"1162165", "%0.0ld"},
  {__LINE__, 0xfffcdc96,	"0XFFFCDC96", "%#X"},
  {__LINE__, 0x00008f5f,	"8f5f", "%3.1x"},
  {__LINE__, 0xffa0fa5d,	"0XFFA0FA5D", "%#X"},
  {__LINE__, 0x00004534,	"4534", "% 0X"},
  {__LINE__, 0xfffffff9,	"fffffff9", "%.2x"},
  {__LINE__, 0xffeeae50,	"ffeeae50", "%-x"},
  {__LINE__, 0x00002964,	" 0010596", "% 0.7d"},
  {__LINE__, 0x000021c9,	"  21c9", "%6x"},
  {__LINE__, 0x00000001,	" 1", "% d"},
  {__LINE__, 0x0002abd8,	"+175064", "%+d"},
  {__LINE__, 0xffffffad,	"FFFFFFAD", "%+0X"},
  {__LINE__, 0x00000003,	"3", "%ld"},
  {__LINE__, 0x0c036da3,	" 201551267", "% .3d"},
  {__LINE__, -0x004343c,	"-275516", "%+ld"},
  {__LINE__, 0x00000003,	"003", "% .3x"},
  {__LINE__, 0xffffe34e,	"ffffe34e", "%x"},
  {__LINE__, 0x0000e118,	"e118", "%x"},
  {__LINE__, -0x007d945,	"-514373", "%+#0ld"},
  {__LINE__, 0x277f1cc5,	"277f1cc5", "% x"},
  {__LINE__, 0x00003bef,	"03bef", "% 0.5x"},
  {__LINE__, 0xfffffcb9,	"fffffcb9", "%x"},
  {__LINE__, 0x0003311a,	"209178", "%ld"},
  {__LINE__, 0x00000000,	"   ", "%3.ld"},
  {__LINE__, 0x05942225,	"5942225", "%x"},
  {__LINE__, 0xfffceb4c,	"FFFCEB4C", "%-X"},
  {__LINE__, 0xffd08633,	"ffd08633", "%2.x"},
  {__LINE__, -0x0000001,	"    -1", "%6d"},
  {__LINE__, 0x000fdb12,	"1039122", "%d"},
  {__LINE__, 0x00000003,	"3", "% 0X"},
  {__LINE__, -0x2fd5bf1,	"-50158577", "% 5.ld"},
  {__LINE__, -0x0089a03,	"-563715", "%-d"},
  {__LINE__, 0xfffffffe,	"FFFFFFFE", "% X"},
  {__LINE__, 0x29fdb2ba,	"29fdb2ba", "% 0x"},
  {__LINE__, 0x0000008f,	"8F", "% X"},
  {__LINE__, 0x00000003,	"3", "%ld"},
  {__LINE__, 0xffc58445,	"FFC58445", "%.2X"},
  {__LINE__, -0x00023f6,	"-9206", "%+d"},
  {__LINE__, 0x00000011,	"11", "%X"},
  {__LINE__, -0x0000003,	"-0000003", "%-.7d"},
  {__LINE__, -0x0000003,	"-3", "%#ld"},
  {__LINE__, 0x001242d9,	"1242D9", "%X"},
  {__LINE__, -0x48d0c81,	"-76352641", "%7.d"},
  {__LINE__, -0x001b675,	"-112245", "%#ld"},
  {__LINE__, 0x00000003,	"3", "%-d"},
  {__LINE__, 0xfff93fdf,	"0XFFF93FDF", "% #X"},
  {__LINE__, 0x001a9414,	"1741844", "%#ld"},
  {__LINE__, 0x0001fd86,	"130438", "%ld"},
  {__LINE__, 0x010f37a8,	"17774504", "%4.7d"},
  {__LINE__, 0x00382838,	"0382838", "%3.7X"},
  {__LINE__, -0x47fd56c2,	"-1207785154", "%ld"},
  {__LINE__, 0x001981dd,	"1981dd", "%x"},
  {__LINE__, 0xffffefba,	"ffffefba", "% 06.x"},
  {__LINE__, -0x3f402b29,	"-1061169961", "%+#ld"},
  {__LINE__, -0x395aae44,	"-962244164", "%-1d"},
  {__LINE__, 0x1fa39f42,	"530816834", "%#d"},
  {__LINE__, -0x000358d,	"-13709", "%d"},
  {__LINE__, -0xdc17b8f,	"-230783887", "%ld"},
  {__LINE__, -0x23c41583,	"-600053123", "%+3.d"},
  {__LINE__, 0xfffffc16,	"fffffc16", "%x"},
  {__LINE__, 0x003f1364,	"4133732", "%7.ld"},
  {__LINE__, 0xffffe691,	"FFFFE691", "%07X"},
  {__LINE__, 0x07b31d71,	"129178993", "%.7d"},
  {__LINE__, -0x0019732,	"-104242", "% ld"},
  {__LINE__, 0x02428167,	"0x2428167", "%#x"},
  {__LINE__, -0x06c1ecd,	"-7085773", "%.7ld"},
  {__LINE__, 0xfb01cb4e,	"fb01cb4e", "%x"},
  {__LINE__, 0x00005a41,	"+23105", "%+ld"},
  {__LINE__, 0xfffffff4,	"FFFFFFF4", "%-5.X"},
  {__LINE__, 0x00000005,	"   5", "%4.ld"},
  {__LINE__, 0xf4ab4b2d,	"F4AB4B2D", "%0.X"},
  {__LINE__, -0x000fce3,	"-64739", "%+#3.ld"},
  {__LINE__, 0x000076ea,	" 30442", "%6.2ld"},
  {__LINE__, 0x00000cb9,	" cb9", "%4.x"},
  {__LINE__, 0x002f43ef,	"3097583", "%1.1ld"},
  {__LINE__, 0xf5bd0105,	"F5BD0105", "%+X"},
  {__LINE__, 0x0037954a,	"3642698", "%d"},
  {__LINE__, 0xfffffff7,	"0XFFFFFFF7", "%-#X"},
  {__LINE__, 0xffffcedf,	"0xffffcedf", "%#6.7x"},
  {__LINE__, 0xfffffde4,	"FFFFFDE4", "%2.4X"},
  {__LINE__, 0x01a6f103,	"1a6f103", "%5.x"},
  {__LINE__, 0x00000191,	"    191", "%7.0X"},
  {__LINE__, 0x00000003,	"03", "% .2X"},
  {__LINE__, -0xd4e3219,	"-223228441", "%6.ld"},
  {__LINE__, 0x00b0efbd,	"11595709", "%d"},
  {__LINE__, -0x00000ea,	"-234", "%#3d"},
  {__LINE__, 0x00000be8,	"BE8  ", "%-5X"},
  {__LINE__, 0xffffffff,	"ffffffff", "%5.3x"},
  {__LINE__, -0x267f8c6,	"-40368326", "%d"},
  {__LINE__, 0x000006ed,	"6ED", "%X"},
  {__LINE__, 0xfdd6c9b6,	"FDD6C9B6", "%X"},
  {__LINE__, 0x0007ac29,	"7ac29", "%-x"},
  {__LINE__, 0x00000014,	"14", "%2x"},
  {__LINE__, 0x123ca563,	"+305964387", "%+ld"},
  {__LINE__, 0x00000004,	"    4", "%5.d"},
  {__LINE__, 0xffff877a,	"ffff877a", "%x"},
  {__LINE__, -0x00003e7,	"-999", "%+0.3d"},
  {__LINE__, 0x0a68ba6e,	"a68ba6e", "%3.1x"},
  {__LINE__, 0xfe29c810,	"FE29C810", "%+X"},
#endif

  {__LINE__, 0x00000000,	"0", "%o"},
  {__LINE__, 0000000123,	"123", "%o"},
  {__LINE__, 0000123456,	"0123456", "%#o"},
  {__LINE__, 0000123456,	"00123456", "%#.8o"},
  {__LINE__, 0000123456,	"  00123456", "%#10.8o"},
  {__LINE__, 0x00000123,	"0x00123", "%#07x"},
  {__LINE__, 0x00000000,	"", "%#.0d"},
  {__LINE__, 0x00000000,	"", "%#.0x"},
  {__LINE__, 0x00000000,	"0", "%#.0o"},

  {__LINE__, 0x00000000,	"0", "%Id"},
  {__LINE__, 0x0000000a,	"10", "%Id"},
  {__LINE__, 0x000000d2,	"210", "%Id"},
  {__LINE__, 0x00000c8a,	"3210", "%Id"},
  {__LINE__, 0x0000a8ca,	"43210", "%Id"},
  {__LINE__, 0x000849ea,	"543210", "%Id"},
  {__LINE__, 0x0063d76a,	"6543210", "%Id"},
  {__LINE__, 0x048ff4ea,	"76543210", "%Id"},
  {__LINE__, 0x343efcea,	"876543210", "%Id"},

  {0},
};

int
main(int argc, char *argv[])
{
    int errcount = 0;
    int testcount = 0;
#define BSIZE 1024
    char buffer[BSIZE];
    sprint_int_type *iptr;
    for (iptr = sprint_ints; iptr->line; iptr++) {
	sprintf(buffer, iptr->format_string, iptr->value);
	if (strcmp(buffer, iptr->result) != 0) {
	    errcount++;
	    printf(
    "Error in line %d using \"%s\".  Result is \"%s\"; should be: \"%s\".\n",
		    iptr->line, iptr->format_string, buffer, iptr->result);
	}
	testcount++;
    }

    if (errcount == 0) {
	printf ("Encountered no errors in %d tests.\n", testcount);
	return 0;
    }
    else {
	printf ("Encountered %d errors in %d tests.\n",
		errcount, testcount);
	return 1;
    }
}
