/* Checking memmove for x86-64.
   Copyright (C) 2016-2017 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include <sysdep.h>
#include "asm-syntax.h"

#ifndef SHARED
	/* For libc.so this is defined in memmove.S.
	   For libc.a, this is a separate source to avoid
	   memmove bringing in __chk_fail and all routines
	   it calls.  */
        .text
ENTRY (__memmove_chk)
	cmpq	%rdx, %rcx
	jb	__chk_fail
	jmp	memmove
END (__memmove_chk)
#endif
