.TH PTHREAD_CONDATTR 3 LinuxThreads

.XREF pthread_condattr_destroy

.SH NAME
pthread_condattr_init, pthread_condattr_destroy \- condition creation attributes

.SH SYNOPSIS
#include <pthread.h>

int pthread_condattr_init(pthread_condattr_t *attr);

int pthread_condattr_destroy(pthread_condattr_t *attr);

.SH DESCRIPTION

Condition attributes can be specified at condition creation time, by passing a
condition attribute object as second argument to !pthread_cond_init!(3).
Passing !NULL! is equivalent to passing a condition attribute object with
all attributes set to their default values.

The LinuxThreads implementation supports no attributes for
conditions. The functions on condition attributes are included only
for compliance with the POSIX standard.

!pthread_condattr_init! initializes the condition attribute object
|attr| and fills it with default values for the attributes.
!pthread_condattr_destroy! destroys a condition attribute object,
which must not be reused until it is reinitialized. Both functions do
nothing in the LinuxThreads implementation.

.SH "RETURN VALUE"
!pthread_condattr_init! and !pthread_condattr_destroy! always return 0.

.SH AUTHOR
Xavier Leroy <Xavier.Leroy@inria.fr>

.SH "SEE ALSO"
!pthread_cond_init!(3).
