.\" Copyright (c) 1993, 1999 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.\" edit-pr, editing function for GNATS - Jeffrey Osier
.TH edit-pr 1 "December 1999" "GNATS @VERSION@" "GNATS User Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
edit-pr \- edit a problem report in the GNATS database
.SH SYNOPSIS
.hy 0
.na
.B edit-pr 
[
.B -h 
| 
.B --help
]
[
.B -V 
| 
.B --version
]
[
.BI -H \ host
|
.BI --host= host
]
[
.BI -P \ port
|
.BI --port= port
]
[
.BI -v \ user
|
.BI --user= user
]
[
.BI -w \ password
|
.BI --passwd= password
]
[
.BI -d \ databasename
|
.BI --database= databasename
]
.I gnats-id
.ad b
.hy 1
.SH DESCRIPTION
Calls 
.B $EDITOR
on 
.IR gnats-id ; 
when finished editing, refiles 
.I gnats-id
in the 
.B GNATS
database, updating the index and sending mail to relevant parties.
.SH OPTIONS
.TP 1i
.B -h\fR,\fB --help
Prints a brief usage message for
.BR edit-pr .
.TP
.B -V\fR,\fB --version
Prints the version number for
.BR edit-pr .
.TP
.B -d\fR,\fB --database
Specifies the database containing the PR to be edited; if no database is
specified, the database named \fIdefault\fR is assumed.  This option
overrides the database specified in the \fBGNATSDB\fR environment variable.
.SS
GNATS network options:
.TP
.B -H\fR,\fB --host
Hostname of the GNATS server.
.TP
.B -P\fR,\fB --port
The port that the GNATS server runs on.
.TP
.B -v\fR,\fB --username
Username used to log into the GNATS server.
.TP
.B -w\fR,\fB --passwd
Password used to log into the GNATS server.
.B
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database, in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted, but at least one colon must appear;
otherwise, the value is assumed to be the name of a local database.
.P
If \fBGNATSDB\fR is not set, it is assumed that the database is local
and that its name is \fIdefault\fR.
.SH FILES
.TP 1i
.B /tmp/ep$$
Temporary file for PR being edited.
.TP
.B /tmp/ed_pr_ch$$
Holds 
.B >Audit-Trail:
change message, if needed.
.TP
.B /tmp/u$$
Holds output of lock function.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (7),
.BR send-pr (1),
.BR query-pr (1),
.BR delete-pr (8),
.BR file-pr (8),
.BR queue-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdb (8).
.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
