/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sasl.srp;

import gnu.crypto.sasl.srp.SecurityContext;
import gnu.crypto.sasl.srp.StoreEntry;
import java.util.HashMap;

public class ServerStore {
    private static ServerStore singleton = null;
    private static final HashMap sid2ssc = new HashMap();
    private static final HashMap sid2ttl = new HashMap();
    private static final Object lock = new Object();
    private static int counter = 0;

    private ServerStore() {
    }

    static final synchronized ServerStore instance() {
        if (singleton == null) {
            singleton = new ServerStore();
        }
        return singleton;
    }

    static final synchronized byte[] getNewSessionID() {
        String sid = String.valueOf(++counter);
        return ("SID-" + "0000000000".substring(0, 10 - sid.length()) + sid).getBytes();
    }

    boolean isAlive(byte[] sid) {
        boolean result = false;
        if (sid != null && sid.length != 0) {
            Object object = lock;
            synchronized (object) {
                block4: {
                    try {
                        String key = new String(sid);
                        StoreEntry ctx = (StoreEntry)sid2ttl.get(key);
                        if (ctx == null || (result = ctx.isAlive())) break block4;
                        sid2ssc.remove(key);
                        sid2ttl.remove(key);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        throw throwable;
                    }
                }
                Object var4_4 = null;
            }
        }
        boolean bl = result;
        return bl;
    }

    void cacheSession(int ttl, SecurityContext ctx) {
        Object object = lock;
        synchronized (object) {
            try {
                String key = new String(ctx.getSID());
                sid2ssc.put(key, ctx);
                sid2ttl.put(key, new StoreEntry(ttl));
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }

    SecurityContext restoreSession(byte[] sid) {
        String key = new String(sid);
        Object object = lock;
        synchronized (object) {
            SecurityContext securityContext;
            SecurityContext result;
            try {
                result = (SecurityContext)sid2ssc.remove(key);
                sid2ttl.remove(key);
            }
            finally {
                securityContext = null;
            }
            securityContext = result;
            return securityContext;
        }
    }

    void invalidateSession(byte[] sid) {
        String key = new String(sid);
        Object object = lock;
        synchronized (object) {
            try {
                sid2ssc.remove(key);
                sid2ttl.remove(key);
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }
}

