/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;

public class AlgorithmIdentifier
implements DEREncodable {
    private DERObjectIdentifier objectId;
    private DEREncodable parameters;
    private boolean parametersDefined;

    private /* synthetic */ void finit$() {
        this.parametersDefined = false;
    }

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static AlgorithmIdentifier getInstance(Object obj) {
        if (obj instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)obj;
        }
        if (obj instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)obj);
        }
        if (obj instanceof String) {
            return new AlgorithmIdentifier((String)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AlgorithmIdentifier(DERObjectIdentifier objectId) {
        this.finit$();
        this.objectId = objectId;
    }

    public AlgorithmIdentifier(String objectId) {
        this.finit$();
        this.objectId = new DERObjectIdentifier(objectId);
    }

    public AlgorithmIdentifier(DERObjectIdentifier objectId, DEREncodable parameters) {
        this.finit$();
        this.parametersDefined = true;
        this.objectId = objectId;
        this.parameters = parameters;
    }

    public AlgorithmIdentifier(ASN1Sequence seq) {
        this.finit$();
        this.objectId = (DERObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() == 2) {
            this.parametersDefined = true;
            this.parameters = seq.getObjectAt(1);
        } else {
            this.parameters = null;
        }
    }

    public DERObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public DEREncodable getParameters() {
        return this.parameters;
    }

    public DERObject getDERObject() {
        DERConstructedSequence seq = new DERConstructedSequence();
        seq.addObject(this.objectId);
        if (this.parametersDefined) {
            seq.addObject(this.parameters);
        }
        return seq;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AlgorithmIdentifier)) {
            return false;
        }
        AlgorithmIdentifier other = (AlgorithmIdentifier)o;
        if (!this.getObjectId().equals(other.getObjectId())) {
            return false;
        }
        if (this.getParameters() == null && other.getParameters() == null) {
            return true;
        }
        if (this.getParameters() == null || other.getParameters() == null) {
            return false;
        }
        ByteArrayOutputStream b1Out = new ByteArrayOutputStream();
        ByteArrayOutputStream b2Out = new ByteArrayOutputStream();
        DEROutputStream d1Out = new DEROutputStream(b1Out);
        DEROutputStream d2Out = new DEROutputStream(b2Out);
        try {
            d1Out.writeObject(this.getParameters());
            d2Out.writeObject(other.getParameters());
            byte[] b1 = b1Out.toByteArray();
            byte[] b2 = b2Out.toByteArray();
            if (b1.length != b2.length) {
                return false;
            }
            for (int i = 0; i != b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

