/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool.keytool;

import gnu.crypto.tool.keytool.Command;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

class Import
extends Command {
    public void run() throws Exception {
        KeyStore store = null;
        CertificateFactory cert = null;
        if (this.provider != null) {
            store = KeyStore.getInstance(this.storeType, this.provider);
            cert = CertificateFactory.getInstance(this.certType, this.provider);
        } else {
            store = KeyStore.getInstance(this.storeType);
            cert = CertificateFactory.getInstance(this.certType);
        }
        NameCallback aliasIn = new NameCallback("alias: ", this.alias);
        PasswordCallback pass = new PasswordCallback("keystore password: ", false);
        Callback[] cb = null;
        cb = this.alias.equals("mykey") ? new Callback[]{aliasIn, pass} : new Callback[]{pass};
        this.handler.handle(cb);
        if (this.storeFile.equals("-")) {
            if (this.verbose > 0) {
                this.println("Loading keystore from standard input");
            }
            store.load(System.in, pass.getPassword());
        } else if (this.noKeystore || !new File(this.storeFile).exists()) {
            if (this.verbose > 0) {
                this.println("Creating new keystore");
            }
            store.load(null, null);
        } else {
            if (this.verbose > 0) {
                this.println("Loading keystore from " + this.storeFile);
            }
            FileInputStream in = new FileInputStream(this.storeFile);
            store.load(in, pass.getPassword());
            in.close();
        }
        String alias = this.alias;
        if (alias.equals("mykey")) {
            alias = aliasIn.getName();
        }
        if (this.verbose > 0) {
            this.println("Loading " + this.certType + " certificate from " + (this.file == null ? "standard input" : this.file));
        }
        InputStream certIn = null;
        certIn = this.file == null ? System.in : new FileInputStream(this.file);
        store.setCertificateEntry(alias, cert.generateCertificate(certIn));
        if (this.noKeystore) {
            if (this.verbose > 0) {
                this.println("No keystore. Not writing output.");
            }
            return;
        }
        OutputStream out = null;
        if (this.outFile != null) {
            out = this.outFile.equals("-") ? System.out : new FileOutputStream(this.outFile);
        } else {
            OutputStream outputStream = out = this.storeFile.equals("-") ? System.out : new FileOutputStream(this.storeFile);
        }
        if (this.verbose > 0) {
            this.println("Writing keystore to " + (out == System.out ? "standard output" : (this.outFile == null ? this.storeFile : this.outFile)));
        }
        store.store(out, pass.getPassword());
        if (out != System.out) {
            out.flush();
            out.close();
        }
    }

    public String toString() {
        return "import";
    }

    Import(Command previous) {
        super(previous);
    }
}

