/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.util;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final String NAME = "Base64";
    private static final boolean DEBUG = true;
    private static final int debuglevel = 9;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte NEW_LINE = 10;
    private static final byte EQUALS_SIGN = 61;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] DECODABET;

    private static final void debug(String s) {
        err.println(">>> Base64: " + s);
    }

    public static final String encode(byte[] src) {
        return Base64.encode(src, 0, src.length, true);
    }

    public static final String encode(byte[] src, int off, int len, boolean breakLines) {
        int len43 = len * 4 / 3;
        int n = len43 + (len % 3 > 0 ? 4 : 0);
        int n2 = 0;
        if (breakLines) {
            n2 = len43 / 76;
        }
        byte[] outBuff = new byte[n + n2];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(src, d + off, 3, outBuff, e);
            if (breakLines && (lineLength += 4) == 76) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(src, d + off, len - d, outBuff, e);
            e += 4;
        }
        return new String(outBuff, 0, e);
    }

    public static final byte[] decode(String s) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes("US-ASCII");
        return Base64.decode(bytes, 0, bytes.length);
    }

    public static byte[] decode(byte[] src, int off, int len) {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = off;
        while (i < off + len) {
            byte sbiCrop = (byte)(src[i] & 0x7F);
            byte sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode >= -1) {
                    b4[b4Posn++] = sbiCrop;
                    if (b4Posn > 3) {
                        outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                        b4Posn = 0;
                        if (sbiCrop == 61) {
                            break;
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Illegal BASE-64 character at #" + i + ": " + src[i] + "(decimal)");
            }
            ++i;
        }
        byte[] result = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, result, 0, outBuffPosn);
        return result;
    }

    private static final byte[] encode3to4(byte[] src, int sOffset, int numBytes, byte[] dest, int dOffset) {
        int n = 0;
        if (numBytes > 0) {
            n = src[sOffset] << 24 >>> 8;
        }
        int n2 = 0;
        if (numBytes > 1) {
            n2 = src[sOffset + 1] << 24 >>> 16;
        }
        int n3 = n | n2;
        int n4 = 0;
        if (numBytes > 2) {
            n4 = src[sOffset + 2] << 24 >>> 24;
        }
        int inBuff = n3 | n4;
        switch (numBytes) {
            case 3: {
                dest[dOffset] = ALPHABET[inBuff >>> 18];
                dest[dOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                dest[dOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                dest[dOffset + 3] = ALPHABET[inBuff & 0x3F];
                break;
            }
            case 2: {
                dest[dOffset] = ALPHABET[inBuff >>> 18];
                dest[dOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                dest[dOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                dest[dOffset + 3] = 61;
                break;
            }
            case 1: {
                dest[dOffset] = ALPHABET[inBuff >>> 18];
                dest[dOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                dest[dOffset + 2] = 61;
                dest[dOffset + 3] = 61;
                break;
            }
        }
        return dest;
    }

    private static final int decode4to3(byte[] src, int sOffset, byte[] dest, int dOffset) {
        if (src[sOffset + 2] == 61) {
            int outBuff = (DECODABET[src[sOffset]] & 0xFF) << 18 | (DECODABET[src[sOffset + 1]] & 0xFF) << 12;
            dest[dOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (src[sOffset + 3] == 61) {
            int outBuff = (DECODABET[src[sOffset]] & 0xFF) << 18 | (DECODABET[src[sOffset + 1]] & 0xFF) << 12 | (DECODABET[src[sOffset + 2]] & 0xFF) << 6;
            dest[dOffset] = (byte)(outBuff >>> 16);
            dest[dOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        try {
            int outBuff = (DECODABET[src[sOffset]] & 0xFF) << 18 | (DECODABET[src[sOffset + 1]] & 0xFF) << 12 | (DECODABET[src[sOffset + 2]] & 0xFF) << 6 | DECODABET[src[sOffset + 3]] & 0xFF;
            dest[dOffset] = (byte)(outBuff >> 16);
            dest[dOffset + 1] = (byte)(outBuff >> 8);
            dest[dOffset + 2] = (byte)outBuff;
            return 3;
        }
        catch (Exception x) {
            Base64.debug(src[sOffset] + ": " + DECODABET[src[sOffset]]);
            Base64.debug(src[sOffset + 1] + ": " + DECODABET[src[sOffset + 1]]);
            Base64.debug(src[sOffset + 2] + ": " + DECODABET[src[sOffset + 2]]);
            Base64.debug(src[sOffset + 3] + ": " + DECODABET[src[sOffset + 3]]);
            return -1;
        }
    }

    private Base64() {
    }

    static {
        byte[] byArray = new byte[127];
        byArray[0] = -9;
        byArray[1] = -9;
        byArray[2] = -9;
        byArray[3] = -9;
        byArray[4] = -9;
        byArray[5] = -9;
        byArray[6] = -9;
        byArray[7] = -9;
        byArray[8] = -9;
        byArray[9] = -5;
        byArray[10] = -5;
        byArray[11] = -9;
        byArray[12] = -9;
        byArray[13] = -5;
        byArray[14] = -9;
        byArray[15] = -9;
        byArray[16] = -9;
        byArray[17] = -9;
        byArray[18] = -9;
        byArray[19] = -9;
        byArray[20] = -9;
        byArray[21] = -9;
        byArray[22] = -9;
        byArray[23] = -9;
        byArray[24] = -9;
        byArray[25] = -9;
        byArray[26] = -9;
        byArray[27] = -9;
        byArray[28] = -9;
        byArray[29] = -9;
        byArray[30] = -9;
        byArray[31] = -9;
        byArray[32] = -5;
        byArray[33] = -9;
        byArray[34] = -9;
        byArray[35] = -9;
        byArray[36] = -9;
        byArray[37] = -9;
        byArray[38] = -9;
        byArray[39] = -9;
        byArray[40] = -9;
        byArray[41] = -9;
        byArray[42] = -9;
        byArray[43] = 62;
        byArray[44] = -9;
        byArray[45] = -9;
        byArray[46] = -9;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -9;
        byArray[59] = -9;
        byArray[60] = -9;
        byArray[61] = -1;
        byArray[62] = -9;
        byArray[63] = -9;
        byArray[64] = -9;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -9;
        byArray[92] = -9;
        byArray[93] = -9;
        byArray[94] = -9;
        byArray[95] = -9;
        byArray[96] = -9;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = -9;
        byArray[124] = -9;
        byArray[125] = -9;
        byArray[126] = -9;
        DECODABET = byArray;
    }
}

