/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool.keytool;

import gnu.crypto.tool.keytool.Command;
import gnu.crypto.util.Base64;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

class Export
extends Command {
    public void run() throws Exception {
        KeyStore store = null;
        store = this.provider != null ? KeyStore.getInstance(this.storeType, this.provider) : KeyStore.getInstance(this.storeType);
        NameCallback aliasIn = new NameCallback("alias: ", this.alias);
        PasswordCallback pass = new PasswordCallback("keystore password: ", false);
        Callback[] cb = null;
        cb = this.alias.equals("mykey") ? new Callback[]{aliasIn, pass} : new Callback[]{pass};
        this.handler.handle(cb);
        store.load(new FileInputStream(this.storeFile), pass.getPassword());
        String alias = this.alias;
        if (alias.equals("mykey")) {
            alias = aliasIn.getName();
        }
        if (store.isCertificateEntry(alias)) {
            OutputStream out = null;
            out = this.file == null || this.file.equals("-") || this.outFile == null || this.outFile.equals("-") ? System.out : new FileOutputStream(this.file != null ? this.file : this.outFile);
            byte[] encoded = store.getCertificate(alias).getEncoded();
            if (this.armor) {
                encoded = ("-----BEGIN CERTIFICATE----" + System.getProperty("line.separator") + Base64.encode(encoded) + System.getProperty("line.separator") + "-----END CERTIFICATE----" + System.getProperty("line.separator")).getBytes();
            }
            ((OutputStream)out).write(encoded);
            if (out != System.out) {
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
        } else {
            if (store.isKeyEntry(alias)) {
                throw new RuntimeException(alias + ": is a private key");
            }
            throw new RuntimeException(alias + ": no such alias");
        }
    }

    public String toString() {
        return "export";
    }

    Export(Command previous) {
        super(previous);
    }
}

