/*
 * Copyright (c) 2016 - 2021, Broadcom
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef I2C_REGS
#define I2C_REGS

/* SMBUS Config register */
#define SMB_CFG_REG				0x0U

#define SMB_CFG_RST_MASK			0x80000000U
#define SMB_CFG_RST_SHIFT			31U

#define SMB_CFG_SMBEN_MASK			0x40000000U
#define SMB_CFG_SMBEN_SHIFT			30U

#define SMB_CFG_BITBANGEN_MASK			0x20000000U
#define SMB_CFG_BITBANGEN_SHIFT			29U

#define SMB_CFG_EN_NIC_SMBADDR0_MASK		0x10000000U
#define SMB_CFG_EN_NIC_SMBADDR0_SHIFT		28U

#define SMB_CFG_PROMISCMODE_MASK		0x08000000U
#define SMB_CFG_PROMISCMODE_SHIFT		27U

#define SMB_CFG_TSTMPCNTEN_MASK			0x04000000U
#define SMB_CFG_TSTMPCNTEN_SHIFT		26U

#define SMB_CFG_MSTRRTRYCNT_MASK		0x000F0000U
#define SMB_CFG_MSTRRTRYCNT_SHIFT		16U

/* SMBUS Timing config register */
#define SMB_TIMGCFG_REG				0x4U

#define SMB_TIMGCFG_MODE400_MASK		0x80000000U
#define SMB_TIMGCFG_MODE400_SHIFT		31U

#define SMB_TIMGCFG_RNDSLVSTR_MASK		0x7F000000U
#define SMB_TIMGCFG_RNDSLVSTR_SHIFT		24U

#define SMB_TIMGCFG_PERSLVSTR_MASK		0x00FF0000U
#define SMB_TIMGCFG_PERSLVSTR_SHIFT		16U

#define SMB_TIMGCFG_IDLTIME_MASK		0x0000FF00U
#define SMB_TIMGCFG_IDLTIME_SHIFT		8U

/* SMBUS Slave address register */
#define SMB_ADDR_REG				0x8U

#define SMB_EN_NIC_SMBADDR3_MASK		0x80000000U
#define SMB_EN_NIC_SMBADDR3_SHIFT		31U

#define SMB_NIC_SMBADDR3_MASK			0x7F000000U
#define SMB_NIC_SMBADDR3_SHIFT			24U

#define SMB_EN_NIC_SMBADDR2_MASK		0x00800000U
#define SMB_EN_NIC_SMBADDR2_SHIFT		23U

#define SMB_NIC_SMBADDR2_MASK			0x007F0000U
#define SMB_NIC_SMBADDR2_SHIFT			16U

#define SMB_EN_NIC_SMBADDR1_MASK		0x00008000U
#define SMB_EN_NIC_SMBADDR1_SHIFT		15U

#define SMB_NIC_SMBADDR1_MASK			0x00007F00U
#define SMB_NIC_SMBADDR1_SHIFT			8U

#define SMB_EN_NIC_SMBADDR0_MASK		0x00000080U
#define SMB_EN_NIC_SMBADDR0_SHIFT		7U

#define SMB_NIC_SMBADDR0_MASK			0x0000007FU
#define SMB_NIC_SMBADDR0_SHIFT			0U

/* SMBUS Master FIFO control register */
#define SMB_MSTRFIFOCTL_REG			0xCU

#define SMB_MSTRRXFIFOFLSH_MASK			0x80000000U
#define SMB_MSTRRXFIFOFLSH_SHIFT		31U

#define SMB_MSTRTXFIFOFLSH_MASK			0x40000000U
#define SMB_MSTRTXFIFOFLSH_SHIFT		30U

#define SMB_MSTRRXPKTCNT_MASK			0x007F0000U
#define SMB_MSTRRXPKTCNT_SHIFT			16U

#define SMB_MSTRRXFIFOTHR_MASK			0x00003F00U
#define SMB_MSTRRXFIFOTHR_SHIFT			8U

/* SMBUS Slave FIFO control register */
#define SMB_SLVFIFOCTL_REG			0x10U

#define SMB_SLVRXFIFOFLSH_MASK			0x80000000U
#define SMB_SLVRXFIFOFLSH_SHIFT			31U

#define SMB_SLVTXFIFOFLSH_MASK			0x40000000U
#define SMB_SLVTXFIFOFLSH_SHIFT			30U

#define SMB_SLVRXPKTCNT_MASK			0x007F0000U
#define SMB_SLVRXPKTCNT_SHIFT			16U

#define SMB_SLVRXFIFOTHR_MASK			0x00003F00U
#define SMB_SLVRXFIFOTHR_SHIFT			8U

/* SMBUS Bit-bang mode control register */
#define SMB_BITBANGCTL_REG			0x14U

#define SMB_SMBCLKIN_MASK			0x80000000U
#define SMB_SMBCLKIN_SHIFT			31U

#define SMB_SMBCLKOUTEN_MASK			0x40000000U
#define SMB_SMBCLKOUTEN_SHIFT			30U

#define SMB_SMBDATAIN_MASK			0x20000000U
#define SMB_SMBDATAIN_SHIFT			29U

#define SMB_SMBDATAOUTEN_MASK			0x10000000U
#define SMB_SMBDATAOUTEN_SHIFT			28U

/* SMBUS Master command register */
#define SMB_MSTRCMD_REG				0x30U

#define SMB_MSTRSTARTBUSYCMD_MASK		0x80000000U
#define SMB_MSTRSTARTBUSYCMD_SHIFT		31U

#define SMB_MSTRABORT_MASK			0x40000000U
#define SMB_MSTRABORT_SHIFT			30U

#define SMB_MSTRSTS_MASK			0x0E000000U
#define SMB_MSTRSTS_SHIFT			25U

#define SMB_MSTRSMBUSPROTO_MASK			0x00001E00U
#define SMB_MSTRSMBUSPROTO_SHIFT		9U

#define SMB_MSTRPEC_MASK			0x00000100U
#define SMB_MSTRPEC_SHIFT			8U

#define SMB_MSTRRDBYTECNT_MASK			0x000000FFU
#define SMB_MSTRRDBYTECNT_SHIFT			0U

/* SMBUS Slave command register */
#define SMB_SLVCMD_REG				0x34U

#define SMB_SLVSTARTBUSYCMD_MASK		0x80000000U
#define SMB_SLVSTARTBUSYCMD_SHIFT		31U

#define SMB_SLVABORT_MASK			0x40000000U
#define SMB_SLVABORT_SHIFT			30U

#define SMB_SLVSTS_MASK				0x03800000U
#define SMB_SLVSTS_SHIFT			23U

#define SMB_SLVPEC_MASK				0x00000100U
#define SMB_SLVPEC_SHIFT			8U

/* SMBUS Event enable register */
#define SMB_EVTEN_REG				0x38U

#define SMB_MSTRRXFIFOFULLEN_MASK		0x80000000U
#define SMB_MSTRRXFIFOFULLEN_SHIFT		31U

#define SMB_MSTRRXFIFOTHRHITEN_MASK		0x40000000U
#define SMB_MSTRRXFIFOTHRHITEN_SHIFT		30U

#define SMB_MSTRRXEVTEN_MASK			0x20000000U
#define SMB_MSTRRXEVTEN_SHIFT			29U

#define SMB_MSTRSTARTBUSYEN_MASK		0x10000000U
#define SMB_MSTRSTARTBUSYEN_SHIFT		28U

#define SMB_MSTRTXUNDEN_MASK			0x08000000U
#define SMB_MSTRTXUNDEN_SHIFT			27U

#define SMB_SLVRXFIFOFULLEN_MASK		0x04000000U
#define SMB_SLVRXFIFOFULLEN_SHIFT		26U

#define SMB_SLVRXFIFOTHRHITEN_MASK		0x02000000U
#define SMB_SLVRXFIFOTHRHITEN_SHIFT		25U

#define SMB_SLVRXEVTEN_MASK			0x01000000U
#define SMB_SLVRXEVTEN_SHIFT			24U

#define SMB_SLVSTARTBUSYEN_MASK			0x00800000U
#define SMB_SLVSTARTBUSYEN_SHIFT		23U

#define SMB_SLVTXUNDEN_MASK			0x00400000U
#define SMB_SLVTXUNDEN_SHIFT			22U

#define SMB_SLVRDEVTEN_MASK			0x00200000U
#define SMB_SLVRDEVTEN_SHIFT			21U

/* SMBUS Event status register */
#define SMB_EVTSTS_REG				0x3CU

#define SMB_MSTRRXFIFOFULLSTS_MASK		0x80000000U
#define SMB_MSTRRXFIFOFULLSTS_SHIFT		31U

#define SMB_MSTRRXFIFOTHRHITSTS_MASK		0x40000000U
#define SMB_MSTRRXFIFOTHRHITSTS_SHIFT		30U

#define SMB_MSTRRXEVTSTS_MASK			0x20000000U
#define SMB_MSTRRXEVTSTS_SHIFT			29U

#define SMB_MSTRSTARTBUSYSTS_MASK		0x10000000U
#define SMB_MSTRSTARTBUSYSTS_SHIFT		28U

#define SMB_MSTRTXUNDSTS_MASK			0x08000000U
#define SMB_MSTRTXUNDSTS_SHIFT			27U

#define SMB_SLVRXFIFOFULLSTS_MASK		0x04000000U
#define SMB_SLVRXFIFOFULLSTS_SHIFT		26U

#define SMB_SLVRXFIFOTHRHITSTS_MASK		0x02000000U
#define SMB_SLVRXFIFOTHRHITSTS_SHIFT		25U

#define SMB_SLVRXEVTSTS_MASK			0x01000000U
#define SMB_SLVRXEVTSTS_SHIFT			24U

#define SMB_SLVSTARTBUSYSTS_MASK		0x00800000U
#define SMB_SLVSTARTBUSYSTS_SHIFT		23U

#define SMB_SLVTXUNDSTS_MASK			0x00400000U
#define SMB_SLVTXUNDSTS_SHIFT			22U

#define SMB_SLVRDEVTSTS_MASK			0x00200000U
#define SMB_SLVRDEVTSTS_SHIFT			21U

/* SMBUS Master data write register */
#define SMB_MSTRDATAWR_REG			0x40U

#define SMB_MSTRWRSTS_MASK			0x80000000U
#define SMB_MSTRWRSTS_SHIFT			31U

#define SMB_MSTRWRDATA_MASK			0x000000FFU
#define SMB_MSTRWRDATA_SHIFT			0U

/* SMBUS Master data read register */
#define SMB_MSTRDATARD_REG			0x44U

#define SMB_MSTRRDSTS_MASK			0xC0000000U
#define SMB_MSTRRDSTS_SHIFT			30U

#define SMB_MSTRRDPECERR_MASK			0x20000000U
#define SMB_MSTRRDPECERR_SHIFT			29U

#define SMB_MSTRRDDATA_MASK			0x000000FFU
#define SMB_MSTRRDDATA_SHIFT			0U

/* SMBUS Slave data write register */
#define SMB_SLVDATAWR_REG			0x48U

#define SMB_SLVWRSTS_MASK			0x80000000U
#define SMB_SLVWRSTS_SHIFT			31U

#define SMB_SLVWRDATA_MASK			0x000000FFU
#define SMB_SLVWRDATA_SHIFT			0U

/* SMBUS Slave data read register */
#define SMB_SLVDATARD_REG			0x4CU

#define SMB_SLVRDSTS_MASK			0xC0000000U
#define SMB_SLVRDSTS_SHIFT			30U

#define SMB_SLVRDERRSTS_MASK			0x30000000U
#define SMB_SLVRDERRSTS_SHIFT			28U

#define SMB_SLVRDDATA_MASK			0x000000FFU
#define SMB_SLVRDDATA_SHIFT			0U

#endif /* I2C_REGS */
