// +build !manifestcodegen
// Code generated by "menifestcodegen". DO NOT EDIT.
// To reproduce: go run github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest/common/manifestcodegen/cmd/manifestcodegen github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest

package manifest

import (
	"encoding/binary"
	"fmt"
	"io"
	"strings"

	"github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest/common/pretty"
)

var (
	// Just to avoid errors in "import" above in case if it wasn't used below
	_ = binary.LittleEndian
	_ = (fmt.Stringer)(nil)
	_ = (io.Reader)(nil)
	_ = pretty.Header
	_ = strings.Join
)

// NewKeySignature returns a new instance of KeySignature with
// all default values set.
func NewKeySignature() *KeySignature {
	s := &KeySignature{}
	// Set through tag "required":
	s.Version = 0x10
	// Recursively initializing a child structure:
	s.Key = *NewKey()
	// Recursively initializing a child structure:
	s.Signature = *NewSignature()
	s.Rehash()
	return s
}

// Validate (recursively) checks the structure if there are any unexpected
// values. It returns an error if so.
func (s *KeySignature) Validate() error {
	// See tag "require"
	if s.Version != 0x10 {
		return fmt.Errorf("field 'Version' expects value '0x10', but has %v", s.Version)
	}
	// Recursively validating a child structure:
	if err := s.Key.Validate(); err != nil {
		return fmt.Errorf("error on field 'Key': %w", err)
	}
	// Recursively validating a child structure:
	if err := s.Signature.Validate(); err != nil {
		return fmt.Errorf("error on field 'Signature': %w", err)
	}

	return nil
}

// ReadFrom reads the KeySignature from 'r' in format defined in the document #575623.
func (s *KeySignature) ReadFrom(r io.Reader) (int64, error) {
	totalN := int64(0)

	// Version (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Read(r, binary.LittleEndian, &s.Version)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Version': %w", err)
		}
		totalN += int64(n)
	}

	// Key (ManifestFieldType: subStruct)
	{
		n, err := s.Key.ReadFrom(r)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Key': %w", err)
		}
		totalN += int64(n)
	}

	// Signature (ManifestFieldType: subStruct)
	{
		n, err := s.Signature.ReadFrom(r)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Signature': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// RehashRecursive calls Rehash (see below) recursively.
func (s *KeySignature) RehashRecursive() {
	s.Key.Rehash()
	s.Signature.Rehash()
	s.Rehash()
}

// Rehash sets values which are calculated automatically depending on the rest
// data. It is usually about the total size field of an element.
func (s *KeySignature) Rehash() {
}

// WriteTo writes the KeySignature into 'w' in format defined in
// the document #575623.
func (s *KeySignature) WriteTo(w io.Writer) (int64, error) {
	totalN := int64(0)
	s.Rehash()

	// Version (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Write(w, binary.LittleEndian, &s.Version)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Version': %w", err)
		}
		totalN += int64(n)
	}

	// Key (ManifestFieldType: subStruct)
	{
		n, err := s.Key.WriteTo(w)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Key': %w", err)
		}
		totalN += int64(n)
	}

	// Signature (ManifestFieldType: subStruct)
	{
		n, err := s.Signature.WriteTo(w)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Signature': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// VersionSize returns the size in bytes of the value of field Version
func (s *KeySignature) VersionTotalSize() uint64 {
	return 1
}

// KeySize returns the size in bytes of the value of field Key
func (s *KeySignature) KeyTotalSize() uint64 {
	return s.Key.TotalSize()
}

// SignatureSize returns the size in bytes of the value of field Signature
func (s *KeySignature) SignatureTotalSize() uint64 {
	return s.Signature.TotalSize()
}

// VersionOffset returns the offset in bytes of field Version
func (s *KeySignature) VersionOffset() uint64 {
	return 0
}

// KeyOffset returns the offset in bytes of field Key
func (s *KeySignature) KeyOffset() uint64 {
	return s.VersionOffset() + s.VersionTotalSize()
}

// SignatureOffset returns the offset in bytes of field Signature
func (s *KeySignature) SignatureOffset() uint64 {
	return s.KeyOffset() + s.KeyTotalSize()
}

// Size returns the total size of the KeySignature.
func (s *KeySignature) TotalSize() uint64 {
	if s == nil {
		return 0
	}

	var size uint64
	size += s.VersionTotalSize()
	size += s.KeyTotalSize()
	size += s.SignatureTotalSize()
	return size
}

// PrettyString returns the content of the structure in an easy-to-read format.
func (s *KeySignature) PrettyString(depth uint, withHeader bool, opts ...pretty.Option) string {
	var lines []string
	if withHeader {
		lines = append(lines, pretty.Header(depth, "Key Signature", s))
	}
	if s == nil {
		return strings.Join(lines, "\n")
	}
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Version", "", &s.Version, opts...)...)
	// ManifestFieldType is subStruct
	lines = append(lines, pretty.SubValue(depth+1, "Key", "", &s.Key, opts...)...)
	// ManifestFieldType is subStruct
	lines = append(lines, pretty.SubValue(depth+1, "Signature", "", &s.Signature, opts...)...)
	if depth < 2 {
		lines = append(lines, "")
	}
	return strings.Join(lines, "\n")
}
