/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018 (c)
 * 
 *    file: module_js.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_js[] = { "js", "JS" };
char *keyword_js[] = {
      //JavaScript language keywords
      //As in version 5 (ECMAScript 5)
      "break",
      "const",
      "continue",
      "delete",
      "double",
      "while",
      "export",
      "for",
      "int",
      "function",
      "if",
      "else",
      "import",
      "instanceof",
      "label",
      "let",
      "new",
      "return",
      "switch",
      "this",
      "throws",
      "try",
      "catch",
      "typeof",
      "var",
      "void",
      "with",
      "yield",
      ///////////////////////////////////
      "abstract",
      "arguments",
      "boolean",
      "byte",
      "case",
      "catch",
      "char",
      "class",
      "debugger",
      "default",
      "do",
      "else",
      "enum",
      "eval",
      "extends",
      "false",
      "finally",
      "final",
      "float",
      "goto",
      "implements",
      "interface",
      "in",
      "long",
      "native",
      "null",
      "package",
      "private",
      "protected",
      "public",
      "short",
      "static",
      "super",
      "synchronized",
      "throw",
      "transient",
      "true",
      "volatile",
      ///////////////////////////////////
      "array",
      "date",
      "hasownproperty",
      "infinity",
      "isfinite",
      "isnan",
      "isprototypeof",
      "length",
      "math",
      "nan",
      "name",
      "number",
      "object",
      "prototype",
      "string",
      "tostring",
      "undefined",
      "valueof",
};

struct modulestruct module_js =
{
    .extsCount      = 2,
    .exts           = ext_js,
    .keywordCount   = 84,
    .keywords       = keyword_js,
    .mlCommentStart = "/*",
    .mlCommentEnd   = "*/",
    .slCommentStart = "//",
    .caseSensitive  = 1,
};
