/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.io.ParseException;
import gnu.prolog.io.TermWriter;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;

public class PrologException
extends Exception {
    private static final long serialVersionUID = 946127094875894543L;
    protected Term term;
    protected String msg;
    public static final AtomTerm instantiationErrorAtom = AtomTerm.get("instantiation_error");
    public static final AtomTerm systemErrorAtom = AtomTerm.get("system_error");
    public static final AtomTerm errorAtom = AtomTerm.get("error");
    public static final CompoundTermTag errorTag = CompoundTermTag.get("error", 2);
    public static final CompoundTermTag typeErrorTag = CompoundTermTag.get("type_error", 2);
    public static final CompoundTermTag existenceErrorTag = CompoundTermTag.get("existence_error", 2);
    public static final CompoundTermTag domainErrorTag = CompoundTermTag.get("domain_error", 2);
    public static final CompoundTermTag representationErrorTag = CompoundTermTag.get("representation_error", 1);
    public static final CompoundTermTag syntaxErrorTag = CompoundTermTag.get("syntax_error", 1);
    public static final CompoundTermTag permissionErrorTag = CompoundTermTag.get("permission_error", 3);
    public static final CompoundTermTag evaluationErrorTag = CompoundTermTag.get("evaluation_error", 1);

    protected PrologException() {
    }

    protected PrologException(String message, Throwable cause) {
        super(message, cause);
    }

    protected PrologException(String message) {
        super(message);
    }

    protected PrologException(Throwable cause) {
        super(cause);
    }

    public PrologException(Term term, Throwable inner) {
        this(inner);
        this.term = term;
    }

    public String getMessage() {
        if (this.msg == null) {
            this.msg = TermWriter.toString(this.term);
        }
        return this.msg;
    }

    public Term getTerm() {
        return this.term;
    }

    private static PrologException getError(Term term) {
        return PrologException.getError(term, null);
    }

    private static PrologException getError(Term term, Throwable inner) {
        if (inner != null) {
            return new PrologException(new CompoundTerm(errorTag, term, AtomTerm.get(inner.toString())), inner);
        }
        return new PrologException(new CompoundTerm(errorTag, term, errorAtom), inner);
    }

    public static void systemError() throws PrologException {
        PrologException.systemError(null);
    }

    public static void systemError(Throwable inner) throws PrologException {
        throw PrologException.getError(systemErrorAtom, inner);
    }

    public static void instantiationError() throws PrologException {
        throw PrologException.getError(instantiationErrorAtom);
    }

    public static void typeError(AtomTerm errorType, Term errorTerm) throws PrologException {
        throw PrologException.getError(new CompoundTerm(typeErrorTag, errorType, errorTerm));
    }

    public static void existenceError(AtomTerm errorType, Term errorTerm) throws PrologException {
        throw PrologException.getError(new CompoundTerm(existenceErrorTag, errorType, errorTerm));
    }

    public static void domainError(AtomTerm errorType, Term errorTerm) throws PrologException {
        throw PrologException.getError(new CompoundTerm(domainErrorTag, errorType, errorTerm));
    }

    public static void representationError(Term errorTerm) throws PrologException {
        throw PrologException.getError(new CompoundTerm(representationErrorTag, errorTerm));
    }

    public static void syntaxError(AtomTerm term) throws PrologException {
        throw PrologException.getError(new CompoundTerm(syntaxErrorTag, term));
    }

    public static void syntaxError(AtomTerm term, Throwable inner) throws PrologException {
        throw PrologException.getError(new CompoundTerm(syntaxErrorTag, term), inner);
    }

    public static void syntaxError(ParseException ex) throws PrologException {
        PrologException.syntaxError(AtomTerm.get(ex.getMessage()), ex);
    }

    public static void permissionError(AtomTerm operation, AtomTerm permissionType, Term culprit) throws PrologException {
        throw PrologException.getError(new CompoundTerm(permissionErrorTag, operation, permissionType, culprit));
    }

    public static void evalutationError(AtomTerm error) throws PrologException {
        throw PrologException.getError(new CompoundTerm(evaluationErrorTag, error));
    }
}

