#!/usr/bin/env python

import sys
import os
import os.path
import re
from optparse import OptionParser

def write_header(f, comment_char):
    f.write(comment_char); f.write('\n')
    f.write(comment_char); f.write(' Machine generated by gen_usrp_dbid.py from usrp_dbid.dat\n')
    f.write(comment_char); f.write(' Do not edit by hand.  All edits will be overwritten.\n')
    f.write(comment_char); f.write('\n')
    f.write('\n')

def gen_dbid_py(r):
    f = open('usrp_dbid.py', 'w')
    comment_char = '#'
    write_header(f, comment_char)
    f.write(comment_char); f.write('\n')
    f.write(comment_char); f.write(" USRP Daughterboard ID's\n")
    f.write(comment_char); f.write('\n')
    f.write('\n')
    for x in r:
        f.write('%-16s = %s\n' % (x[1], x[2]))

def gen_dbid_h(r):
    f = open('usrp_dbid.h', 'w')
    comment_char = '//'
    write_header(f, comment_char)
    f.write(comment_char); f.write('\n')
    f.write(comment_char); f.write(" USRP Daughterboard ID's\n")
    f.write(comment_char); f.write('\n')
    f.write('\n')
    f.write('#ifndef INCLUDED_USRP_DBID_H\n')
    f.write('#define INCLUDED_USRP_DBID_H\n')
    f.write('\n')
    for x in r:
        f.write('#define %-25s %s\n' % ('USRP_DBID_' + x[1], x[2]))
    f.write('\n')
    f.write('#endif /* INCLUDED_USRP_DBID_H */\n')

def gen_dbid_cc(r):
    f = open('usrp_dbid.cc', 'w')
    write_header(f, '//')
    head = '''/*
 * Copyright 2005 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#include <usrp_prims.h>
#include <usrp_dbid.h>
#include <stdio.h>

#define NELEM(x) sizeof(x)/sizeof(x[0])

static struct {
  unsigned short	dbid;
  const char	       *name;
} dbid_map[] = {
'''
    
    tail = '''};

const std::string
usrp_dbid_to_string (int dbid)
{
  if (dbid == -1)
    return "<none>";

  if (dbid == -2)
    return "<invalid EEPROM contents>";

  for (unsigned i = 0; i < NELEM (dbid_map); i++)
    if (dbid == dbid_map[i].dbid)
      return dbid_map[i].name;

  char tmp[64];
  snprintf (tmp, sizeof (tmp), "Unknown (0x%04x)", dbid);
  return tmp;
}
'''
    f.write(head)
    for x in r:
        f.write('  { %-27s "%s" },\n' % (
            'USRP_DBID_' + x[1] + ',', x[0]))
    f.write(tail)

def gen_all(src_filename):
    src_file = open(src_filename, 'r')
    r = []
    for line in src_file:
        line = line.strip()
        line = re.sub(r'\s*#.*$','', line)
        if len(line) == 0:
            continue
        mo = re.match('"([^"]+)"\s*(0x[0-9a-fA-F]+)', line)
        if mo:
            str_name = mo.group(1)
            id_name = str_name.upper().replace(' ', '_')
            id_val = mo.group(2)
            r.append((str_name, id_name, id_val))
            #sys.stdout.write('%-16s\t%-16s\t%s\n' % ('"'+str_name+'"', id_name, id_val))

    gen_dbid_h(r)
    gen_dbid_py(r)
    gen_dbid_cc(r)
    

def main():
    usage = "usage: %prog [options] usrp_dbid.dat"
    parser = OptionParser(usage=usage)
    (options, args) = parser.parse_args()
    if len(args) != 1:
        parser.print_help()
        sys.exit(1)

    gen_all(args[0])

if __name__ == '__main__':
    main()
