/* -*- Mode: c++ -*-
*******************************************************************************
*
* File:         raw_fm_to_file.cc
* Description:  
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

//
// Log output of FM demodulator to file for further analysis.
//


#include <make_GrMC4020Source.h>
#include <GrFFTSink.h>
#include <VrFixOffset.h>
#include <VrComplexFIRfilter.h>
#include <VrQuadratureDemod.h>
#include <VrRealFIRfilter.h>
#include <VrAudioSink.h>
#include <VrFileSink.h>
#include <VrFileSource.h>
#include <VrAudioSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <VrGUI.h>


const int inputRate = 20000000;		// input sample rate from PCI-DAS4020/12
const float FM_IF_Freq = 5.75e6;	// output freq of tuner module

const float IF_Freq = FM_IF_Freq;

// const int chanTaps = 150;
const int chanTaps = 75;
const int CFIRdecimate = 125;
const float chanGain = 2.0;


//const float fm_demodGain = 8800;
//const float fm_demodGain = 4400;	// works well
const float fm_demodGain = 2200;
//const float fm_demodGain = 1100;

const int RFIRdecimate = 5;
//const int RFIRdecimate = 1;	// for now
//const int ifTaps = 22;
const int ifTaps = 50;
const float ifGain = 1.0;

const int quadRate = inputRate / CFIRdecimate;
const int audioRate = quadRate / RFIRdecimate;


#define	ENABLE_CHANNEL_FILTER_FFT	1


int main(int argc, char **argv)
{
  float volume = 1.0;

  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();


  cerr << "Input Sampling Rate: " << inputRate << endl;
  cerr << "Complex FIR decimation factor: " << CFIRdecimate << endl;
  cerr << "QuadDemod Sampling Rate: " << quadRate << endl;
  cerr << "Real FIR decimation factor: " << RFIRdecimate << endl;
  cerr << "Audio Sampling Rate: " << audioRate << endl;

  // --> short
  VrSource<short> *source = 
    make_GrMC4020SourceS(inputRate, MCC_CH3_EN | MCC_ALL_1V);

  // short --> short 
  VrFixOffset<short,short> *offset_fixer =
    new VrFixOffset<short,short>();

  // short --> VrComplex
  VrComplexFIRfilter<short>* chan_filter = 
    new VrComplexFIRfilter<short>(CFIRdecimate, chanTaps, IF_Freq, chanGain);

  // VrComplex --> float
  VrQuadratureDemod<float> *fm_demod =
    new VrQuadratureDemod<float>(volume * fm_demodGain);

  // float --> short
  VrRealFIRfilter<float,short> *audio_filter = 
    new VrRealFIRfilter<float,short>(RFIRdecimate, audioRate/2,
				     ifTaps, ifGain);

  // order on the display depends on order of initialization, not construction

  // sink1 is channel filter output
  VrSink<VrComplex> *fft_sink1 = new GrFFTSink<VrComplex>(vert, 90, 140, 512);

  // sink2 is fm demod output
  VrSink<float> *fft_sink2 = new GrFFTSink<float>(vert, 40, 140, 512);

  // sink3 is audio output
  VrSink<short> *fft_sink3 = new GrFFTSink<short>(horiz, 40, 140, 512);

  VrSink<short> *audio_sink = new VrAudioSink<short>();
  VrSink<float> *file_sink = new VrFileSink<float>("raw_fm.float");

  //connect the modules together

  NWO_CONNECT (source, offset_fixer);
  NWO_CONNECT (offset_fixer, chan_filter);
  NWO_CONNECT (chan_filter, fm_demod);
  NWO_CONNECT (chan_filter, fft_sink1);
  NWO_CONNECT (fm_demod, audio_filter);
  NWO_CONNECT (fm_demod, fft_sink2);
  NWO_CONNECT (fm_demod, file_sink);	// your output here!
  NWO_CONNECT (audio_filter, audio_sink);
  NWO_CONNECT (audio_filter, fft_sink3);


  VrMultiTask *m = new VrMultiTask ();
  m->add (fft_sink1);
  m->add (fft_sink3);
  m->add (fft_sink2);
  m->add (audio_sink);
  m->add (file_sink);


  m->start ();
  guimain->start ();

  while (1){
    guimain->processEvents(10 /*ms*/);
    m->process();
  }  
}
