/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrRemoveDcFFF.h>

static const int NOUTPUTS = 1;

GrRemoveDcFFF::GrRemoveDcFFF (float alpha)
  : VrHistoryProc<float,float>(NOUTPUTS), d_iir(alpha)
{
  history = 1;
}


GrRemoveDcFFF::~GrRemoveDcFFF ()
{
}

int
GrRemoveDcFFF::work (VrSampleRange output, void *ao[],
		     VrSampleRange inputs[], void *ai[])
{
  float *in = (float *) ai[0];
  float *out = (float *) ao[0];

  sync (output.index);	// we have state, must sync.
  
  for (unsigned i = 0; i < output.size; i++)
    out[i] = in[i] - d_iir.filter (in[i]);

  return output.size;
}
