#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

# abstract base class

class Tuner (object):
    def __init__ (self, min, max, chan):
        self.min = min
        self.max = max
        self.chan = chan
        self.wrap = True

    def minChannel (self):
        return self.min

    def maxChannel (self):
        return self.max

    def channel (self):
        return self.chan

    def isWrap (self):
        return self.wrap

    def setWrap (self, wrap):
        self.wrap = wrap
    
    def setChannel (self, channel):
        if channel < self.min or channel > self.max:
            return
        if channel != self.chan:
            self.chan = channel
            # notify channelChanged
            
    def nextChannel (self):
        if self.chan < self.max:
            self.setChannel (self.chan + 1)
        elif self.wrap:
            self.setChannel (self.min)

    def prevChannel (self):
        if self.chan > self.min:
            self.setChannel (self.chan - 1)
        elif self.wrap:
            set.setChannel (self.max)


# concrete class for North American terrestial broadcast TV

class TVTuner (Tuner):
    # North American terrestial broadcast assignments
    # N.B., cable assignments are different.
    # These frequencies correspond to the center of the 6 MHz channel assignments
    channel_map = [
         57.00,  63.00,  69.00,  79.00,  85.00, 177.00, 183.00, 189.00, 195.00, 201.00, 
        207.00, 213.00, 473.00, 479.00, 485.00, 491.00, 497.00, 503.00, 509.00, 515.00, 
        521.00, 527.00, 533.00, 539.00, 545.00, 551.00, 557.00, 563.00, 569.00, 575.00, 
        581.00, 587.00, 593.00, 599.00, 605.00, 611.00, 617.00, 623.00, 629.00, 635.00, 
        641.00, 647.00, 653.00, 659.00, 665.00, 671.00, 677.00, 683.00, 689.00, 695.00, 
        701.00, 707.00, 713.00, 719.00, 725.00, 731.00, 737.00, 743.00, 749.00, 755.00, 
        761.00, 767.00, 773.00, 779.00, 785.00, 791.00, 797.00, 803.00
        ]
    def __init__ (self):
        Tuner.__init__ (self, 2, 69, 2)
    def frequency (self):
        return (self.channel_map[self.chan - 2] * 1e6)


# concrete class for North American terrestial broadcast FM radio (87.9 to 107.9 MHz)

class FMTuner (Tuner):
    def __init__ (self):
        Tuner.__init__ (self, 200, 300, 200)
    def frequency (self):
        return (self.chan * 0.2 + 47.9) * 1e6
    def freq_to_channel (self, freq):
        if freq >= 1e6:
            freq = freq / 1e6
        return int ((freq - 47.9) * 5)
