/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef VRGUI_H_
#define VRGUI_H_

class QApplication;
class QWidget;
class QBoxLayout;
class VrPlot;

class VrGUILayout {
public:
	VrGUILayout(QWidget *arg_widget, QBoxLayout *arg_layout);
	VrGUILayout *vertical(int arg_width = -1);
	VrGUILayout *horizontal(int arg_width = -1);
	QBoxLayout *layout;
	QWidget *widget;
};

class VrGUI {
public:
	VrGUI(int argc, char *argv[]);
	void start();
	void processEvents(int arg_param);
	VrGUILayout *top;
private:
	QApplication *app;
};

class VrGUIPlot {
public:
	VrGUIPlot(VrGUILayout *layout, const char *xaxis_name, const char *yaxis_name,
		bool lines, double xmin, double xmax, double ymin, double ymax,
		int arg_points, int arg_divisions);
	void data(double *x, double *y, int arg_points);
	void clear();
	void set_persistent(int arg_persistent);
private:
	VrPlot *display;
};

class VrGUISlider {
public:
	VrGUISlider(VrGUILayout *layout, void (*arg_callback)(double),
		const char *slider_name, float arg_min, float arg_max);
};

class VrGUINumber {
public:
	VrGUINumber(VrGUILayout *layout, const char *arg_title, const char *arg_units,
		void (*arg_callback)(double), float arg_max, float arg_default);
};

class VrGUIButton {
public:
	VrGUIButton(VrGUILayout *layout, const char *arg_title, void (*arg_callback)());
};

class VrGUILabel {
public:
	VrGUILabel(VrGUILayout *layout, const char *arg_value, int arg_center = 1, int arg_size = 14);
};

class VrGUISpace {
public:
	VrGUISpace(VrGUILayout *layout, int arg_space);
};
#endif
