/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* Transmit side of stub for testing ATSC components */

#include <VrFileSink.h>
#include <VrFileSource.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <GrTCPSink.h>
#include <GrAtscRandomizer.h>
#include <GrAtscRSEncoder.h>
#include <GrAtscInterleaver.h>
#include <GrAtscTrellisEncoder.h>
#include <atsc_types.h>
#include <unistd.h>

const int Rate	= 8000;

//typedef atsc_mpeg_packet_rs_encoded	output_type;
//typedef atsc_mpeg_packet_no_sync	output_type;
typedef atsc_data_segment		output_type;

void
usage (const char *name)
{
  cerr << "usage: " << name << " [-f <filename>] [-o <outfile>] [-p <port_number>] [-l]\n";
  exit (1);
}

int 
main (int argc, char **argv)
{
  char *filename = "mpeg.in";
  char *outfile = "atscblah.out";
  int	port = 0;
  GrTCPSink<output_type>  *tcpsink = 0;
  VrFileSink<output_type> *filesink = 0;
  VrSink<output_type>	  *finalsink;
  bool logging = false;

  int	ch;
  while ((ch = getopt (argc, argv, "f:o:p:l")) != EOF){
    switch (ch){
    case 'f':
      filename = optarg;
      break;
    
    case 'o':
      outfile = optarg;
      break;

    case 'p':
      port = strtol (optarg, 0, 0);
      break;

    case 'l':
      logging = true;
      break;
      
    default:
      usage (argv[0]);
    }
  }

  // create the modules

  VrFileSource<atsc_mpeg_packet>* source =
    new VrFileSource<atsc_mpeg_packet>(Rate, filename, 0);

  GrAtscRandomizer  *randomizer = new GrAtscRandomizer();
  GrAtscRSEncoder   *rs_encoder = new GrAtscRSEncoder();
  GrAtscInterleaver *interleaver = new GrAtscInterleaver();
  GrAtscTrellisEncoder *trellis_encoder = new GrAtscTrellisEncoder();

  VrFileSink<atsc_mpeg_packet_no_sync>    *randomizer_log = 0;
  VrFileSink<atsc_mpeg_packet_rs_encoded> *rs_encoder_log = 0;
  VrFileSink<atsc_mpeg_packet_rs_encoded> *interleaver_log = 0;
  VrFileSink<atsc_data_segment>           *trellis_encoder_log = 0;



  if (port) {
    tcpsink = new GrTCPSink<output_type>(port);
    finalsink = tcpsink;
  } else {
    filesink = new VrFileSink<output_type>(outfile);
    finalsink = filesink;
  }
  
  VrMultiTask *m = new VrMultiTask ();
  m->add (finalsink);

  /* Hook up the connections among the modules now.  */

  // NWO_CONNECT (source, sink);

  NWO_CONNECT (source, randomizer);
  NWO_CONNECT (randomizer, rs_encoder);
  NWO_CONNECT (rs_encoder, interleaver);
  NWO_CONNECT (interleaver,trellis_encoder);
  NWO_CONNECT (trellis_encoder, finalsink);

  if (logging){
    randomizer_log = new VrFileSink<atsc_mpeg_packet_no_sync>("randomizer.txout");
    rs_encoder_log = new VrFileSink<atsc_mpeg_packet_rs_encoded>("rs_encoder.txout");
    interleaver_log = new VrFileSink<atsc_mpeg_packet_rs_encoded>("interleaver.txout");
    trellis_encoder_log = new VrFileSink<atsc_data_segment>("trellis_encoder.txout");

    m->add (randomizer_log);
    m->add (rs_encoder_log);
    m->add (interleaver_log);
    m->add (trellis_encoder_log);
    

    NWO_CONNECT (randomizer,      randomizer_log);
    NWO_CONNECT (rs_encoder,      rs_encoder_log);
    NWO_CONNECT (interleaver,     interleaver_log);
    NWO_CONNECT (trellis_encoder, trellis_encoder_log);
  }


  m->start ();
  while (1){
    m->process ();
  }
  m->stop ();

  return 0;
}

