/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _GRCIRCULARSINK_H_
#define _GRCIRCULARSINK_H_

/*
 * diagnostic helper to track down problem in MC4020 driver
 * writes input samples into a circular buffer.
 */

#include <VrSink.h>
#include <gr_circular_file.h>


template <class iType>
class GrCircularSink : public VrSink<iType>
{
private:
  gr_circular_file	*d_circ_file;
  
public:
  GrCircularSink (const char *filename, int buffersize_in_bytes){
    d_circ_file = new gr_circular_file (filename, true, buffersize_in_bytes);
  }

  ~GrCircularSink () {
    delete d_circ_file;
  }

  const char *name () { return "GrCircularSink.h"; }

  virtual int work3 (VrSampleRange output, 
		     VrSampleRange inputs[], void *ai[]){

    iType *in = ((iType **) ai)[0];

    d_circ_file->write (in, output.size * sizeof (iType));
    return output.size;
  }
};



#endif /* _GRCIRCULARSINK_H_ */
