/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _GRSSBMOD_H_
#define _GRSSBMOD_H_

#include <VrSigProc.h>
#include <VrComplex.h>
#include <gr_nco.h>

template<class oType> 
class GrSSBMod : public VrSigProc {
private:
  gr_nco<float,float> 	d_nco;
  double 		d_gain;
public: 
  GrSSBMod (double freq, double gain);

  virtual const char *name() { return "GrSSBMod"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);

  // FIXME scale freq?
  void set_freq (double freq) {
    cerr << "set freq to " << freq << endl;
    d_nco.set_freq (freq);
  };

  void set_gain (double g) { d_gain = g; };
};

template<class oType> int
GrSSBMod<oType>::work(VrSampleRange output, void *ao[],
		      VrSampleRange inputs[], void *ai[])
{
  VrComplex **i = (VrComplex **)ai;
  oType **o = (oType **)ao;
  int size = output.size;

  for(int x = 0; x < size; x++)
    {
      *o[0]++ = (oType) ( d_gain * (i[0]->real() * d_nco.cos()
				    + i[0]->imag() * d_nco.sin() ));
      i[0]++;
      d_nco.step();
    }
  return output.size;
}

template<class oType> 
GrSSBMod<oType>::GrSSBMod (double freq, double gain)
  : VrSigProc(1, sizeof(VrComplex), sizeof(oType)), d_gain (gain)
{
  // FIXME scale freq?
  d_nco.set_freq (freq);
}

#endif
