#!/bin/env python
# -*- python -*-
#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from generate_utils import *

# files to generate

fx_signatures = [ 'SCF', 'SCC', 'FCF', 'FCC', 'CCF', 'CCC' ]

def init_dict (code3):
    d = {}
    d['NAME'] = 'GrFreqXlatingFIRfilter' + code3
    d['FIR_TYPE'] = 'gr_fir_' + i_code (code3) + 'CC'
    d['I_TYPE'] = i_type (code3)
    d['O_TYPE'] = o_type (code3)
    d['TAP_TYPE'] = tap_type (code3)
    d['FIR_BUILDER'] = char_to_builder[tap_code (code3)]
    return d
    

def build_header (d):
    template = open_src ('GrFreqXlatingFIRfilterXXX_h.t', 'r')
    output = open (d['NAME'] + '.h', 'w')
    do_substitution (d, template, output)
    template.close ()
    output.close ()

def build_swig_header (d):
    template = open_src ('GrFreqXlatingFIRfilterXXX_i.t', 'r')
    output = open (d['NAME'] + '.i', 'w')
    do_substitution (d, template, output)
    template.close ()
    output.close ()

def build_body (d):
    template = open_src ('GrFreqXlatingFIRfilterXXX_cc.t', 'r')
    output = open (d['NAME'] + '.cc', 'w')
    do_substitution (d, template, output)
    template.close ()
    output.close ()
    
def build_one (code3):
    d = init_dict (code3)
    build_header (d)
    build_swig_header (d)
    build_body (d)


def generate ():
    for sigs in fx_signatures:
        build_one (sigs)

if __name__ == '__main__':
    generate ()
    
